import {Request} from '../lib/request';
import {Response} from '../lib/response';
import {AWSError} from '../lib/error';
import {Service} from '../lib/service';
import {WaiterConfiguration} from '../lib/service';
import {ServiceConfigurationOptions} from '../lib/service';
import {ConfigBase as Config} from '../lib/config-base';
interface Blob {}
declare class EC2 extends Service {
  /**
   * Constructs a service object. This object has one method for each API operation.
   */
  constructor(options?: EC2.Types.ClientConfiguration)
  config: Config & EC2.Types.ClientConfiguration;
  /**
   * Accepts an Elastic IP address transfer. For more information, see Accept a transferred Elastic IP address in the Amazon Virtual Private Cloud User Guide.
   */
  acceptAddressTransfer(params: EC2.Types.AcceptAddressTransferRequest, callback?: (err: AWSError, data: EC2.Types.AcceptAddressTransferResult) => void): Request<EC2.Types.AcceptAddressTransferResult, AWSError>;
  /**
   * Accepts an Elastic IP address transfer. For more information, see Accept a transferred Elastic IP address in the Amazon Virtual Private Cloud User Guide.
   */
  acceptAddressTransfer(callback?: (err: AWSError, data: EC2.Types.AcceptAddressTransferResult) => void): Request<EC2.Types.AcceptAddressTransferResult, AWSError>;
  /**
   * Accepts the Convertible Reserved Instance exchange quote described in the GetReservedInstancesExchangeQuote call.
   */
  acceptReservedInstancesExchangeQuote(params: EC2.Types.AcceptReservedInstancesExchangeQuoteRequest, callback?: (err: AWSError, data: EC2.Types.AcceptReservedInstancesExchangeQuoteResult) => void): Request<EC2.Types.AcceptReservedInstancesExchangeQuoteResult, AWSError>;
  /**
   * Accepts the Convertible Reserved Instance exchange quote described in the GetReservedInstancesExchangeQuote call.
   */
  acceptReservedInstancesExchangeQuote(callback?: (err: AWSError, data: EC2.Types.AcceptReservedInstancesExchangeQuoteResult) => void): Request<EC2.Types.AcceptReservedInstancesExchangeQuoteResult, AWSError>;
  /**
   * Accepts a request to associate subnets with a transit gateway multicast domain.
   */
  acceptTransitGatewayMulticastDomainAssociations(params: EC2.Types.AcceptTransitGatewayMulticastDomainAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.AcceptTransitGatewayMulticastDomainAssociationsResult) => void): Request<EC2.Types.AcceptTransitGatewayMulticastDomainAssociationsResult, AWSError>;
  /**
   * Accepts a request to associate subnets with a transit gateway multicast domain.
   */
  acceptTransitGatewayMulticastDomainAssociations(callback?: (err: AWSError, data: EC2.Types.AcceptTransitGatewayMulticastDomainAssociationsResult) => void): Request<EC2.Types.AcceptTransitGatewayMulticastDomainAssociationsResult, AWSError>;
  /**
   * Accepts a transit gateway peering attachment request. The peering attachment must be in the pendingAcceptance state.
   */
  acceptTransitGatewayPeeringAttachment(params: EC2.Types.AcceptTransitGatewayPeeringAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.AcceptTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.AcceptTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Accepts a transit gateway peering attachment request. The peering attachment must be in the pendingAcceptance state.
   */
  acceptTransitGatewayPeeringAttachment(callback?: (err: AWSError, data: EC2.Types.AcceptTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.AcceptTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Accepts a request to attach a VPC to a transit gateway. The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests. Use RejectTransitGatewayVpcAttachment to reject a VPC attachment request.
   */
  acceptTransitGatewayVpcAttachment(params: EC2.Types.AcceptTransitGatewayVpcAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.AcceptTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.AcceptTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Accepts a request to attach a VPC to a transit gateway. The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests. Use RejectTransitGatewayVpcAttachment to reject a VPC attachment request.
   */
  acceptTransitGatewayVpcAttachment(callback?: (err: AWSError, data: EC2.Types.AcceptTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.AcceptTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.
   */
  acceptVpcEndpointConnections(params: EC2.Types.AcceptVpcEndpointConnectionsRequest, callback?: (err: AWSError, data: EC2.Types.AcceptVpcEndpointConnectionsResult) => void): Request<EC2.Types.AcceptVpcEndpointConnectionsResult, AWSError>;
  /**
   * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.
   */
  acceptVpcEndpointConnections(callback?: (err: AWSError, data: EC2.Types.AcceptVpcEndpointConnectionsResult) => void): Request<EC2.Types.AcceptVpcEndpointConnectionsResult, AWSError>;
  /**
   * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the pending-acceptance state, and you must be the owner of the peer VPC. Use DescribeVpcPeeringConnections to view your outstanding VPC peering connection requests. For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of the accepter VPC.
   */
  acceptVpcPeeringConnection(params: EC2.Types.AcceptVpcPeeringConnectionRequest, callback?: (err: AWSError, data: EC2.Types.AcceptVpcPeeringConnectionResult) => void): Request<EC2.Types.AcceptVpcPeeringConnectionResult, AWSError>;
  /**
   * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the pending-acceptance state, and you must be the owner of the peer VPC. Use DescribeVpcPeeringConnections to view your outstanding VPC peering connection requests. For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of the accepter VPC.
   */
  acceptVpcPeeringConnection(callback?: (err: AWSError, data: EC2.Types.AcceptVpcPeeringConnectionResult) => void): Request<EC2.Types.AcceptVpcPeeringConnectionResult, AWSError>;
  /**
   * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP). You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time. We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and start advertising it through Amazon Web Services. It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of BGP propagation delays. To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
   */
  advertiseByoipCidr(params: EC2.Types.AdvertiseByoipCidrRequest, callback?: (err: AWSError, data: EC2.Types.AdvertiseByoipCidrResult) => void): Request<EC2.Types.AdvertiseByoipCidrResult, AWSError>;
  /**
   * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP). You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time. We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and start advertising it through Amazon Web Services. It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of BGP propagation delays. To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
   */
  advertiseByoipCidr(callback?: (err: AWSError, data: EC2.Types.AdvertiseByoipCidrResult) => void): Request<EC2.Types.AdvertiseByoipCidrResult, AWSError>;
  /**
   * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account. You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own IP addresses (BYOIP). For more information, see Bring Your Own IP Addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide. [EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address that you released after it is allocated to another Amazon Web Services account. You cannot recover an Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation. An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).   We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  allocateAddress(params: EC2.Types.AllocateAddressRequest, callback?: (err: AWSError, data: EC2.Types.AllocateAddressResult) => void): Request<EC2.Types.AllocateAddressResult, AWSError>;
  /**
   * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account. You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own IP addresses (BYOIP). For more information, see Bring Your Own IP Addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide. [EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address that you released after it is allocated to another Amazon Web Services account. You cannot recover an Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation. An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).   We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  allocateAddress(callback?: (err: AWSError, data: EC2.Types.AllocateAddressResult) => void): Request<EC2.Types.AllocateAddressResult, AWSError>;
  /**
   * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.
   */
  allocateHosts(params: EC2.Types.AllocateHostsRequest, callback?: (err: AWSError, data: EC2.Types.AllocateHostsResult) => void): Request<EC2.Types.AllocateHostsResult, AWSError>;
  /**
   * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.
   */
  allocateHosts(callback?: (err: AWSError, data: EC2.Types.AllocateHostsResult) => void): Request<EC2.Types.AllocateHostsResult, AWSError>;
  /**
   * Allocate a CIDR from an IPAM pool. In IPAM, an allocation is a CIDR assignment from an IPAM pool to another resource or IPAM pool. For more information, see Allocate CIDRs in the Amazon VPC IPAM User Guide. 
   */
  allocateIpamPoolCidr(params: EC2.Types.AllocateIpamPoolCidrRequest, callback?: (err: AWSError, data: EC2.Types.AllocateIpamPoolCidrResult) => void): Request<EC2.Types.AllocateIpamPoolCidrResult, AWSError>;
  /**
   * Allocate a CIDR from an IPAM pool. In IPAM, an allocation is a CIDR assignment from an IPAM pool to another resource or IPAM pool. For more information, see Allocate CIDRs in the Amazon VPC IPAM User Guide. 
   */
  allocateIpamPoolCidr(callback?: (err: AWSError, data: EC2.Types.AllocateIpamPoolCidrResult) => void): Request<EC2.Types.AllocateIpamPoolCidrResult, AWSError>;
  /**
   * Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.
   */
  applySecurityGroupsToClientVpnTargetNetwork(params: EC2.Types.ApplySecurityGroupsToClientVpnTargetNetworkRequest, callback?: (err: AWSError, data: EC2.Types.ApplySecurityGroupsToClientVpnTargetNetworkResult) => void): Request<EC2.Types.ApplySecurityGroupsToClientVpnTargetNetworkResult, AWSError>;
  /**
   * Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.
   */
  applySecurityGroupsToClientVpnTargetNetwork(callback?: (err: AWSError, data: EC2.Types.ApplySecurityGroupsToClientVpnTargetNetworkResult) => void): Request<EC2.Types.ApplySecurityGroupsToClientVpnTargetNetworkResult, AWSError>;
  /**
   * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and the limit varies per instance type. For information, see IP Addresses Per Network Interface Per Instance Type in the Amazon Elastic Compute Cloud User Guide. You must specify either the IPv6 addresses or the IPv6 address count in the request.  You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see  Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
   */
  assignIpv6Addresses(params: EC2.Types.AssignIpv6AddressesRequest, callback?: (err: AWSError, data: EC2.Types.AssignIpv6AddressesResult) => void): Request<EC2.Types.AssignIpv6AddressesResult, AWSError>;
  /**
   * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and the limit varies per instance type. For information, see IP Addresses Per Network Interface Per Instance Type in the Amazon Elastic Compute Cloud User Guide. You must specify either the IPv6 addresses or the IPv6 address count in the request.  You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see  Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
   */
  assignIpv6Addresses(callback?: (err: AWSError, data: EC2.Types.AssignIpv6AddressesResult) => void): Request<EC2.Types.AssignIpv6AddressesResult, AWSError>;
  /**
   * Assigns one or more secondary private IP addresses to the specified network interface. You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses that you can assign to an instance varies by instance type. For information about instance types, see Instance Types in the Amazon Elastic Compute Cloud User Guide. For more information about Elastic IP addresses, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. When you move a secondary private IP address to another network interface, any Elastic IP address that is associated with the IP address is also moved. Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to another, check network/interfaces/macs/mac/local-ipv4s in the instance metadata to confirm that the remapping is complete. You must specify either the IP addresses or the IP address count in the request. You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see  Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
   */
  assignPrivateIpAddresses(params: EC2.Types.AssignPrivateIpAddressesRequest, callback?: (err: AWSError, data: EC2.Types.AssignPrivateIpAddressesResult) => void): Request<EC2.Types.AssignPrivateIpAddressesResult, AWSError>;
  /**
   * Assigns one or more secondary private IP addresses to the specified network interface. You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses that you can assign to an instance varies by instance type. For information about instance types, see Instance Types in the Amazon Elastic Compute Cloud User Guide. For more information about Elastic IP addresses, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. When you move a secondary private IP address to another network interface, any Elastic IP address that is associated with the IP address is also moved. Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to another, check network/interfaces/macs/mac/local-ipv4s in the instance metadata to confirm that the remapping is complete. You must specify either the IP addresses or the IP address count in the request. You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see  Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
   */
  assignPrivateIpAddresses(callback?: (err: AWSError, data: EC2.Types.AssignPrivateIpAddressesResult) => void): Request<EC2.Types.AssignPrivateIpAddressesResult, AWSError>;
  /**
   * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your account. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different instance, it is disassociated from that instance and associated with the specified instance. If you associate an Elastic IP address with an instance that has an existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to your account. [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated with the primary IP address. If the Elastic IP address is already associated with a different instance or a network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address with an instance or network interface that has an existing Elastic IP address. [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance or network interface.  You cannot associate an Elastic IP address with an interface in a different network border group.  This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error, and you may be charged for each time the Elastic IP address is remapped to the same instance. For more information, see the Elastic IP Addresses section of Amazon EC2 Pricing.   We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  associateAddress(params: EC2.Types.AssociateAddressRequest, callback?: (err: AWSError, data: EC2.Types.AssociateAddressResult) => void): Request<EC2.Types.AssociateAddressResult, AWSError>;
  /**
   * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your account. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different instance, it is disassociated from that instance and associated with the specified instance. If you associate an Elastic IP address with an instance that has an existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to your account. [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated with the primary IP address. If the Elastic IP address is already associated with a different instance or a network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address with an instance or network interface that has an existing Elastic IP address. [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance or network interface.  You cannot associate an Elastic IP address with an interface in a different network border group.  This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error, and you may be charged for each time the Elastic IP address is remapped to the same instance. For more information, see the Elastic IP Addresses section of Amazon EC2 Pricing.   We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  associateAddress(callback?: (err: AWSError, data: EC2.Types.AssociateAddressResult) => void): Request<EC2.Types.AssociateAddressResult, AWSError>;
  /**
   * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy. If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's associated with it.
   */
  associateClientVpnTargetNetwork(params: EC2.Types.AssociateClientVpnTargetNetworkRequest, callback?: (err: AWSError, data: EC2.Types.AssociateClientVpnTargetNetworkResult) => void): Request<EC2.Types.AssociateClientVpnTargetNetworkResult, AWSError>;
  /**
   * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy. If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's associated with it.
   */
  associateClientVpnTargetNetwork(callback?: (err: AWSError, data: EC2.Types.AssociateClientVpnTargetNetworkResult) => void): Request<EC2.Types.AssociateClientVpnTargetNetworkResult, AWSError>;
  /**
   * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP options with the VPC. After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance. For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide.
   */
  associateDhcpOptions(params: EC2.Types.AssociateDhcpOptionsRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP options with the VPC. After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance. For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide.
   */
  associateDhcpOptions(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more information, see Certificate Manager for Nitro Enclaves in the Amazon Web Services Nitro Enclaves User Guide. When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy. To enable the IAM role to access the Amazon S3 object, you must grant it permission to call s3:GetObject on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key, you must grant it permission to call kms:Decrypt on the KMS key returned by the command. For more information, see  Grant the role permission to access the certificate and encryption key in the Amazon Web Services Nitro Enclaves User Guide.
   */
  associateEnclaveCertificateIamRole(params: EC2.Types.AssociateEnclaveCertificateIamRoleRequest, callback?: (err: AWSError, data: EC2.Types.AssociateEnclaveCertificateIamRoleResult) => void): Request<EC2.Types.AssociateEnclaveCertificateIamRoleResult, AWSError>;
  /**
   * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more information, see Certificate Manager for Nitro Enclaves in the Amazon Web Services Nitro Enclaves User Guide. When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy. To enable the IAM role to access the Amazon S3 object, you must grant it permission to call s3:GetObject on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key, you must grant it permission to call kms:Decrypt on the KMS key returned by the command. For more information, see  Grant the role permission to access the certificate and encryption key in the Amazon Web Services Nitro Enclaves User Guide.
   */
  associateEnclaveCertificateIamRole(callback?: (err: AWSError, data: EC2.Types.AssociateEnclaveCertificateIamRoleResult) => void): Request<EC2.Types.AssociateEnclaveCertificateIamRoleResult, AWSError>;
  /**
   * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM instance profile with an instance.
   */
  associateIamInstanceProfile(params: EC2.Types.AssociateIamInstanceProfileRequest, callback?: (err: AWSError, data: EC2.Types.AssociateIamInstanceProfileResult) => void): Request<EC2.Types.AssociateIamInstanceProfileResult, AWSError>;
  /**
   * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM instance profile with an instance.
   */
  associateIamInstanceProfile(callback?: (err: AWSError, data: EC2.Types.AssociateIamInstanceProfileResult) => void): Request<EC2.Types.AssociateIamInstanceProfileResult, AWSError>;
  /**
   * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs, or tags) can be specified with an event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  associateInstanceEventWindow(params: EC2.Types.AssociateInstanceEventWindowRequest, callback?: (err: AWSError, data: EC2.Types.AssociateInstanceEventWindowResult) => void): Request<EC2.Types.AssociateInstanceEventWindowResult, AWSError>;
  /**
   * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs, or tags) can be specified with an event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  associateInstanceEventWindow(callback?: (err: AWSError, data: EC2.Types.AssociateInstanceEventWindowResult) => void): Request<EC2.Types.AssociateInstanceEventWindowResult, AWSError>;
  /**
   * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the routes in the route table. The action returns an association ID, which you need in order to disassociate the route table later. A route table can be associated with multiple subnets. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  associateRouteTable(params: EC2.Types.AssociateRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.AssociateRouteTableResult) => void): Request<EC2.Types.AssociateRouteTableResult, AWSError>;
  /**
   * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the routes in the route table. The action returns an association ID, which you need in order to disassociate the route table later. A route table can be associated with multiple subnets. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  associateRouteTable(callback?: (err: AWSError, data: EC2.Types.AssociateRouteTableResult) => void): Request<EC2.Types.AssociateRouteTableResult, AWSError>;
  /**
   * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a prefix length of /64.
   */
  associateSubnetCidrBlock(params: EC2.Types.AssociateSubnetCidrBlockRequest, callback?: (err: AWSError, data: EC2.Types.AssociateSubnetCidrBlockResult) => void): Request<EC2.Types.AssociateSubnetCidrBlockResult, AWSError>;
  /**
   * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a prefix length of /64.
   */
  associateSubnetCidrBlock(callback?: (err: AWSError, data: EC2.Types.AssociateSubnetCidrBlockResult) => void): Request<EC2.Types.AssociateSubnetCidrBlockResult, AWSError>;
  /**
   * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain. The transit gateway attachment must be in the available state before you can add a resource. Use DescribeTransitGatewayAttachments to see the state of the attachment.
   */
  associateTransitGatewayMulticastDomain(params: EC2.Types.AssociateTransitGatewayMulticastDomainRequest, callback?: (err: AWSError, data: EC2.Types.AssociateTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.AssociateTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain. The transit gateway attachment must be in the available state before you can add a resource. Use DescribeTransitGatewayAttachments to see the state of the attachment.
   */
  associateTransitGatewayMulticastDomain(callback?: (err: AWSError, data: EC2.Types.AssociateTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.AssociateTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Associates the specified transit gateway attachment with a transit gateway policy table.
   */
  associateTransitGatewayPolicyTable(params: EC2.Types.AssociateTransitGatewayPolicyTableRequest, callback?: (err: AWSError, data: EC2.Types.AssociateTransitGatewayPolicyTableResult) => void): Request<EC2.Types.AssociateTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Associates the specified transit gateway attachment with a transit gateway policy table.
   */
  associateTransitGatewayPolicyTable(callback?: (err: AWSError, data: EC2.Types.AssociateTransitGatewayPolicyTableResult) => void): Request<EC2.Types.AssociateTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Associates the specified attachment with the specified transit gateway route table. You can associate only one route table with an attachment.
   */
  associateTransitGatewayRouteTable(params: EC2.Types.AssociateTransitGatewayRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.AssociateTransitGatewayRouteTableResult) => void): Request<EC2.Types.AssociateTransitGatewayRouteTableResult, AWSError>;
  /**
   * Associates the specified attachment with the specified transit gateway route table. You can associate only one route table with an attachment.
   */
  associateTransitGatewayRouteTable(callback?: (err: AWSError, data: EC2.Types.AssociateTransitGatewayRouteTableResult) => void): Request<EC2.Types.AssociateTransitGatewayRouteTableResult, AWSError>;
  /**
   *  This API action is currently in limited preview only. If you are interested in using this feature, contact your account manager.  Associates a branch network interface with a trunk network interface. Before you create the association, run the create-network-interface command and set --interface-type to trunk. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface.
   */
  associateTrunkInterface(params: EC2.Types.AssociateTrunkInterfaceRequest, callback?: (err: AWSError, data: EC2.Types.AssociateTrunkInterfaceResult) => void): Request<EC2.Types.AssociateTrunkInterfaceResult, AWSError>;
  /**
   *  This API action is currently in limited preview only. If you are interested in using this feature, contact your account manager.  Associates a branch network interface with a trunk network interface. Before you create the association, run the create-network-interface command and set --interface-type to trunk. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface.
   */
  associateTrunkInterface(callback?: (err: AWSError, data: EC2.Types.AssociateTrunkInterfaceResult) => void): Request<EC2.Types.AssociateTrunkInterfaceResult, AWSError>;
  /**
   * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (BYOIP). The IPv6 CIDR block size is fixed at /56. You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block. For more information about associating CIDR blocks with your VPC and applicable restrictions, see VPC and subnet sizing in the Amazon Virtual Private Cloud User Guide.
   */
  associateVpcCidrBlock(params: EC2.Types.AssociateVpcCidrBlockRequest, callback?: (err: AWSError, data: EC2.Types.AssociateVpcCidrBlockResult) => void): Request<EC2.Types.AssociateVpcCidrBlockResult, AWSError>;
  /**
   * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (BYOIP). The IPv6 CIDR block size is fixed at /56. You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block. For more information about associating CIDR blocks with your VPC and applicable restrictions, see VPC and subnet sizing in the Amazon Virtual Private Cloud User Guide.
   */
  associateVpcCidrBlock(callback?: (err: AWSError, data: EC2.Types.AssociateVpcCidrBlockResult) => void): Request<EC2.Types.AssociateVpcCidrBlockResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the running state. An instance is automatically unlinked from a VPC when it's stopped - you can link it to the VPC again when you restart it. After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again. Linking your instance to a VPC is sometimes referred to as attaching your instance.
   */
  attachClassicLinkVpc(params: EC2.Types.AttachClassicLinkVpcRequest, callback?: (err: AWSError, data: EC2.Types.AttachClassicLinkVpcResult) => void): Request<EC2.Types.AttachClassicLinkVpcResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the running state. An instance is automatically unlinked from a VPC when it's stopped - you can link it to the VPC again when you restart it. After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again. Linking your instance to a VPC is sometimes referred to as attaching your instance.
   */
  attachClassicLinkVpc(callback?: (err: AWSError, data: EC2.Types.AttachClassicLinkVpcResult) => void): Request<EC2.Types.AttachClassicLinkVpcResult, AWSError>;
  /**
   * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and the VPC. For more information about your VPC and internet gateway, see the Amazon Virtual Private Cloud User Guide.
   */
  attachInternetGateway(params: EC2.Types.AttachInternetGatewayRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and the VPC. For more information about your VPC and internet gateway, see the Amazon Virtual Private Cloud User Guide.
   */
  attachInternetGateway(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Attaches a network interface to an instance.
   */
  attachNetworkInterface(params: EC2.Types.AttachNetworkInterfaceRequest, callback?: (err: AWSError, data: EC2.Types.AttachNetworkInterfaceResult) => void): Request<EC2.Types.AttachNetworkInterfaceResult, AWSError>;
  /**
   * Attaches a network interface to an instance.
   */
  attachNetworkInterface(callback?: (err: AWSError, data: EC2.Types.AttachNetworkInterfaceResult) => void): Request<EC2.Types.AttachNetworkInterfaceResult, AWSError>;
  /**
   * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name. Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide. After you attach an EBS volume, you must make it available. For more information, see Make an EBS volume available for use. If a volume has an Amazon Web Services Marketplace product code:   The volume can be attached only to a stopped instance.   Amazon Web Services Marketplace product codes are copied from the volume to the instance.   You must be subscribed to the product.   The instance type and operating system of the instance must support the product. For example, you can't detach a volume from a Windows instance and attach it to a Linux instance.   For more information, see Attach an Amazon EBS volume to an instance in the Amazon Elastic Compute Cloud User Guide.
   */
  attachVolume(params: EC2.Types.AttachVolumeRequest, callback?: (err: AWSError, data: EC2.Types.VolumeAttachment) => void): Request<EC2.Types.VolumeAttachment, AWSError>;
  /**
   * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name. Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide. After you attach an EBS volume, you must make it available. For more information, see Make an EBS volume available for use. If a volume has an Amazon Web Services Marketplace product code:   The volume can be attached only to a stopped instance.   Amazon Web Services Marketplace product codes are copied from the volume to the instance.   You must be subscribed to the product.   The instance type and operating system of the instance must support the product. For example, you can't detach a volume from a Windows instance and attach it to a Linux instance.   For more information, see Attach an Amazon EBS volume to an instance in the Amazon Elastic Compute Cloud User Guide.
   */
  attachVolume(callback?: (err: AWSError, data: EC2.Types.VolumeAttachment) => void): Request<EC2.Types.VolumeAttachment, AWSError>;
  /**
   * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  attachVpnGateway(params: EC2.Types.AttachVpnGatewayRequest, callback?: (err: AWSError, data: EC2.Types.AttachVpnGatewayResult) => void): Request<EC2.Types.AttachVpnGatewayResult, AWSError>;
  /**
   * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  attachVpnGateway(callback?: (err: AWSError, data: EC2.Types.AttachVpnGatewayResult) => void): Request<EC2.Types.AttachVpnGatewayResult, AWSError>;
  /**
   * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules that grant access to networks. You must configure ingress authorization rules to enable clients to access resources in Amazon Web Services or on-premises networks.
   */
  authorizeClientVpnIngress(params: EC2.Types.AuthorizeClientVpnIngressRequest, callback?: (err: AWSError, data: EC2.Types.AuthorizeClientVpnIngressResult) => void): Request<EC2.Types.AuthorizeClientVpnIngressResult, AWSError>;
  /**
   * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules that grant access to networks. You must configure ingress authorization rules to enable clients to access resources in Amazon Web Services or on-premises networks.
   */
  authorizeClientVpnIngress(callback?: (err: AWSError, data: EC2.Types.AuthorizeClientVpnIngressResult) => void): Request<EC2.Types.AuthorizeClientVpnIngressResult, AWSError>;
  /**
   * [VPC only] Adds the specified outbound (egress) rules to a security group for use with a VPC. An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the instances that are associated with the specified source security groups. When specifying an outbound rule for your security group in a VPC, the IpPermissions must include a destination for the traffic. You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes. Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur. For information about VPC security group quotas, see Amazon VPC quotas.
   */
  authorizeSecurityGroupEgress(params: EC2.Types.AuthorizeSecurityGroupEgressRequest, callback?: (err: AWSError, data: EC2.Types.AuthorizeSecurityGroupEgressResult) => void): Request<EC2.Types.AuthorizeSecurityGroupEgressResult, AWSError>;
  /**
   * [VPC only] Adds the specified outbound (egress) rules to a security group for use with a VPC. An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the instances that are associated with the specified source security groups. When specifying an outbound rule for your security group in a VPC, the IpPermissions must include a destination for the traffic. You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes. Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur. For information about VPC security group quotas, see Amazon VPC quotas.
   */
  authorizeSecurityGroupEgress(callback?: (err: AWSError, data: EC2.Types.AuthorizeSecurityGroupEgressResult) => void): Request<EC2.Types.AuthorizeSecurityGroupEgressResult, AWSError>;
  /**
   * Adds the specified inbound (ingress) rules to a security group. An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address range, or from the instances that are associated with the specified destination security groups. When specifying an inbound rule for your security group in a VPC, the IpPermissions must include a source for the traffic. You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean all types or all codes. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur. For more information about VPC security group quotas, see Amazon VPC quotas.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  authorizeSecurityGroupIngress(params: EC2.Types.AuthorizeSecurityGroupIngressRequest, callback?: (err: AWSError, data: EC2.Types.AuthorizeSecurityGroupIngressResult) => void): Request<EC2.Types.AuthorizeSecurityGroupIngressResult, AWSError>;
  /**
   * Adds the specified inbound (ingress) rules to a security group. An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address range, or from the instances that are associated with the specified destination security groups. When specifying an inbound rule for your security group in a VPC, the IpPermissions must include a source for the traffic. You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean all types or all codes. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur. For more information about VPC security group quotas, see Amazon VPC quotas.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  authorizeSecurityGroupIngress(callback?: (err: AWSError, data: EC2.Types.AuthorizeSecurityGroupIngressResult) => void): Request<EC2.Types.AuthorizeSecurityGroupIngressResult, AWSError>;
  /**
   * Bundles an Amazon instance store-backed Windows instance. During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not preserved.  This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS. 
   */
  bundleInstance(params: EC2.Types.BundleInstanceRequest, callback?: (err: AWSError, data: EC2.Types.BundleInstanceResult) => void): Request<EC2.Types.BundleInstanceResult, AWSError>;
  /**
   * Bundles an Amazon instance store-backed Windows instance. During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not preserved.  This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS. 
   */
  bundleInstance(callback?: (err: AWSError, data: EC2.Types.BundleInstanceResult) => void): Request<EC2.Types.BundleInstanceResult, AWSError>;
  /**
   * Cancels a bundling operation for an instance store-backed Windows instance.
   */
  cancelBundleTask(params: EC2.Types.CancelBundleTaskRequest, callback?: (err: AWSError, data: EC2.Types.CancelBundleTaskResult) => void): Request<EC2.Types.CancelBundleTaskResult, AWSError>;
  /**
   * Cancels a bundling operation for an instance store-backed Windows instance.
   */
  cancelBundleTask(callback?: (err: AWSError, data: EC2.Types.CancelBundleTaskResult) => void): Request<EC2.Types.CancelBundleTaskResult, AWSError>;
  /**
   * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to cancelled. Instances running in the reserved capacity continue running until you stop them. Stopped instances that target the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching attributes and sufficient capacity.
   */
  cancelCapacityReservation(params: EC2.Types.CancelCapacityReservationRequest, callback?: (err: AWSError, data: EC2.Types.CancelCapacityReservationResult) => void): Request<EC2.Types.CancelCapacityReservationResult, AWSError>;
  /**
   * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to cancelled. Instances running in the reserved capacity continue running until you stop them. Stopped instances that target the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching attributes and sufficient capacity.
   */
  cancelCapacityReservation(callback?: (err: AWSError, data: EC2.Types.CancelCapacityReservationResult) => void): Request<EC2.Types.CancelCapacityReservationResult, AWSError>;
  /**
   * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following happens:   The Capacity Reservation Fleet's status changes to cancelled.   The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations at the time of cancelling the Fleet continue to run in shared capacity.   The Fleet stops creating new Capacity Reservations.  
   */
  cancelCapacityReservationFleets(params: EC2.Types.CancelCapacityReservationFleetsRequest, callback?: (err: AWSError, data: EC2.Types.CancelCapacityReservationFleetsResult) => void): Request<EC2.Types.CancelCapacityReservationFleetsResult, AWSError>;
  /**
   * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following happens:   The Capacity Reservation Fleet's status changes to cancelled.   The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations at the time of cancelling the Fleet continue to run in shared capacity.   The Fleet stops creating new Capacity Reservations.  
   */
  cancelCapacityReservationFleets(callback?: (err: AWSError, data: EC2.Types.CancelCapacityReservationFleetsResult) => void): Request<EC2.Types.CancelCapacityReservationFleetsResult, AWSError>;
  /**
   * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception. For more information, see Importing a Virtual Machine Using the Amazon EC2 CLI.
   */
  cancelConversionTask(params: EC2.Types.CancelConversionRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception. For more information, see Importing a Virtual Machine Using the Amazon EC2 CLI.
   */
  cancelConversionTask(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.
   */
  cancelExportTask(params: EC2.Types.CancelExportTaskRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.
   */
  cancelExportTask(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information, see Cancel having an AMI shared with your Amazon Web Services account in the Amazon Elastic Compute Cloud User Guide.
   */
  cancelImageLaunchPermission(params: EC2.Types.CancelImageLaunchPermissionRequest, callback?: (err: AWSError, data: EC2.Types.CancelImageLaunchPermissionResult) => void): Request<EC2.Types.CancelImageLaunchPermissionResult, AWSError>;
  /**
   * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information, see Cancel having an AMI shared with your Amazon Web Services account in the Amazon Elastic Compute Cloud User Guide.
   */
  cancelImageLaunchPermission(callback?: (err: AWSError, data: EC2.Types.CancelImageLaunchPermissionResult) => void): Request<EC2.Types.CancelImageLaunchPermissionResult, AWSError>;
  /**
   * Cancels an in-process import virtual machine or import snapshot task.
   */
  cancelImportTask(params: EC2.Types.CancelImportTaskRequest, callback?: (err: AWSError, data: EC2.Types.CancelImportTaskResult) => void): Request<EC2.Types.CancelImportTaskResult, AWSError>;
  /**
   * Cancels an in-process import virtual machine or import snapshot task.
   */
  cancelImportTask(callback?: (err: AWSError, data: EC2.Types.CancelImportTaskResult) => void): Request<EC2.Types.CancelImportTaskResult, AWSError>;
  /**
   * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  cancelReservedInstancesListing(params: EC2.Types.CancelReservedInstancesListingRequest, callback?: (err: AWSError, data: EC2.Types.CancelReservedInstancesListingResult) => void): Request<EC2.Types.CancelReservedInstancesListingResult, AWSError>;
  /**
   * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  cancelReservedInstancesListing(callback?: (err: AWSError, data: EC2.Types.CancelReservedInstancesListingResult) => void): Request<EC2.Types.CancelReservedInstancesListingResult, AWSError>;
  /**
   * Cancels the specified Spot Fleet requests. After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request enters the cancelled_terminating state. Otherwise, the Spot Fleet request enters the cancelled_running state and the instances continue to run until they are interrupted or you terminate them manually.
   */
  cancelSpotFleetRequests(params: EC2.Types.CancelSpotFleetRequestsRequest, callback?: (err: AWSError, data: EC2.Types.CancelSpotFleetRequestsResponse) => void): Request<EC2.Types.CancelSpotFleetRequestsResponse, AWSError>;
  /**
   * Cancels the specified Spot Fleet requests. After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request enters the cancelled_terminating state. Otherwise, the Spot Fleet request enters the cancelled_running state and the instances continue to run until they are interrupted or you terminate them manually.
   */
  cancelSpotFleetRequests(callback?: (err: AWSError, data: EC2.Types.CancelSpotFleetRequestsResponse) => void): Request<EC2.Types.CancelSpotFleetRequestsResponse, AWSError>;
  /**
   * Cancels one or more Spot Instance requests.  Canceling a Spot Instance request does not terminate running Spot Instances associated with the request. 
   */
  cancelSpotInstanceRequests(params: EC2.Types.CancelSpotInstanceRequestsRequest, callback?: (err: AWSError, data: EC2.Types.CancelSpotInstanceRequestsResult) => void): Request<EC2.Types.CancelSpotInstanceRequestsResult, AWSError>;
  /**
   * Cancels one or more Spot Instance requests.  Canceling a Spot Instance request does not terminate running Spot Instances associated with the request. 
   */
  cancelSpotInstanceRequests(callback?: (err: AWSError, data: EC2.Types.CancelSpotInstanceRequestsResult) => void): Request<EC2.Types.CancelSpotInstanceRequestsResult, AWSError>;
  /**
   * Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user's instance is eligible for support.
   */
  confirmProductInstance(params: EC2.Types.ConfirmProductInstanceRequest, callback?: (err: AWSError, data: EC2.Types.ConfirmProductInstanceResult) => void): Request<EC2.Types.ConfirmProductInstanceResult, AWSError>;
  /**
   * Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user's instance is eligible for support.
   */
  confirmProductInstance(callback?: (err: AWSError, data: EC2.Types.ConfirmProductInstanceResult) => void): Request<EC2.Types.ConfirmProductInstanceResult, AWSError>;
  /**
   * Copies the specified Amazon FPGA Image (AFI) to the current Region.
   */
  copyFpgaImage(params: EC2.Types.CopyFpgaImageRequest, callback?: (err: AWSError, data: EC2.Types.CopyFpgaImageResult) => void): Request<EC2.Types.CopyFpgaImageResult, AWSError>;
  /**
   * Copies the specified Amazon FPGA Image (AFI) to the current Region.
   */
  copyFpgaImage(callback?: (err: AWSError, data: EC2.Types.CopyFpgaImageResult) => void): Request<EC2.Types.CopyFpgaImageResult, AWSError>;
  /**
   * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy an AMI to another partition, see CreateStoreImageTask. To copy an AMI from one Region to another, specify the source Region using the SourceRegion parameter, and specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set Encrypted during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot. To copy an AMI from a Region to an Outpost, specify the source Region using the SourceRegion parameter, and specify the ARN of the destination Outpost using DestinationOutpostArn. Backing snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using KmsKeyId. Outposts do not support unencrypted snapshots. For more information,  Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide. For more information about the prerequisites and limits when copying an AMI, see Copy an AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  copyImage(params: EC2.Types.CopyImageRequest, callback?: (err: AWSError, data: EC2.Types.CopyImageResult) => void): Request<EC2.Types.CopyImageResult, AWSError>;
  /**
   * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy an AMI to another partition, see CreateStoreImageTask. To copy an AMI from one Region to another, specify the source Region using the SourceRegion parameter, and specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set Encrypted during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot. To copy an AMI from a Region to an Outpost, specify the source Region using the SourceRegion parameter, and specify the ARN of the destination Outpost using DestinationOutpostArn. Backing snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using KmsKeyId. Outposts do not support unencrypted snapshots. For more information,  Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide. For more information about the prerequisites and limits when copying an AMI, see Copy an AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  copyImage(callback?: (err: AWSError, data: EC2.Types.CopyImageResult) => void): Request<EC2.Types.CopyImageResult, AWSError>;
  /**
   * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost. You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs). When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the KMS key used to encrypt the snapshot. Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using KmsKeyId. Outposts do not support unencrypted snapshots. For more information,  Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide. Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any purpose. For more information, see Copy an Amazon EBS snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  copySnapshot(params: EC2.Types.CopySnapshotRequest, callback?: (err: AWSError, data: EC2.Types.CopySnapshotResult) => void): Request<EC2.Types.CopySnapshotResult, AWSError>;
  /**
   * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost. You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs). When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the KMS key used to encrypt the snapshot. Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using KmsKeyId. Outposts do not support unencrypted snapshots. For more information,  Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide. Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any purpose. For more information, see Copy an Amazon EBS snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  copySnapshot(callback?: (err: AWSError, data: EC2.Types.CopySnapshotResult) => void): Request<EC2.Types.CopySnapshotResult, AWSError>;
  /**
   * Creates a new Capacity Reservation with the specified attributes. Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see Capacity Reservations in the Amazon EC2 User Guide. Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is flexible across instance types and sizes, try to create a Capacity Reservation with different instance attributes. Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the required instance type and try again. For more information about increasing your instance limits, see Amazon EC2 Service Quotas in the Amazon EC2 User Guide.
   */
  createCapacityReservation(params: EC2.Types.CreateCapacityReservationRequest, callback?: (err: AWSError, data: EC2.Types.CreateCapacityReservationResult) => void): Request<EC2.Types.CreateCapacityReservationResult, AWSError>;
  /**
   * Creates a new Capacity Reservation with the specified attributes. Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see Capacity Reservations in the Amazon EC2 User Guide. Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is flexible across instance types and sizes, try to create a Capacity Reservation with different instance attributes. Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the required instance type and try again. For more information about increasing your instance limits, see Amazon EC2 Service Quotas in the Amazon EC2 User Guide.
   */
  createCapacityReservation(callback?: (err: AWSError, data: EC2.Types.CreateCapacityReservationResult) => void): Request<EC2.Types.CreateCapacityReservationResult, AWSError>;
  /**
   * Creates a Capacity Reservation Fleet. For more information, see Create a Capacity Reservation Fleet in the Amazon EC2 User Guide.
   */
  createCapacityReservationFleet(params: EC2.Types.CreateCapacityReservationFleetRequest, callback?: (err: AWSError, data: EC2.Types.CreateCapacityReservationFleetResult) => void): Request<EC2.Types.CreateCapacityReservationFleetResult, AWSError>;
  /**
   * Creates a Capacity Reservation Fleet. For more information, see Create a Capacity Reservation Fleet in the Amazon EC2 User Guide.
   */
  createCapacityReservationFleet(callback?: (err: AWSError, data: EC2.Types.CreateCapacityReservationFleetResult) => void): Request<EC2.Types.CreateCapacityReservationFleetResult, AWSError>;
  /**
   * Creates a carrier gateway. For more information about carrier gateways, see Carrier gateways in the Amazon Web Services Wavelength Developer Guide.
   */
  createCarrierGateway(params: EC2.Types.CreateCarrierGatewayRequest, callback?: (err: AWSError, data: EC2.Types.CreateCarrierGatewayResult) => void): Request<EC2.Types.CreateCarrierGatewayResult, AWSError>;
  /**
   * Creates a carrier gateway. For more information about carrier gateways, see Carrier gateways in the Amazon Web Services Wavelength Developer Guide.
   */
  createCarrierGateway(callback?: (err: AWSError, data: EC2.Types.CreateCarrierGatewayResult) => void): Request<EC2.Types.CreateCarrierGatewayResult, AWSError>;
  /**
   * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
   */
  createClientVpnEndpoint(params: EC2.Types.CreateClientVpnEndpointRequest, callback?: (err: AWSError, data: EC2.Types.CreateClientVpnEndpointResult) => void): Request<EC2.Types.CreateClientVpnEndpointResult, AWSError>;
  /**
   * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
   */
  createClientVpnEndpoint(callback?: (err: AWSError, data: EC2.Types.CreateClientVpnEndpointResult) => void): Request<EC2.Types.CreateClientVpnEndpointResult, AWSError>;
  /**
   * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.
   */
  createClientVpnRoute(params: EC2.Types.CreateClientVpnRouteRequest, callback?: (err: AWSError, data: EC2.Types.CreateClientVpnRouteResult) => void): Request<EC2.Types.CreateClientVpnRouteResult, AWSError>;
  /**
   * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.
   */
  createClientVpnRoute(callback?: (err: AWSError, data: EC2.Types.CreateClientVpnRouteResult) => void): Request<EC2.Types.CreateClientVpnRouteResult, AWSError>;
  /**
   *  Creates a range of customer-owned IP addresses. 
   */
  createCoipCidr(params: EC2.Types.CreateCoipCidrRequest, callback?: (err: AWSError, data: EC2.Types.CreateCoipCidrResult) => void): Request<EC2.Types.CreateCoipCidrResult, AWSError>;
  /**
   *  Creates a range of customer-owned IP addresses. 
   */
  createCoipCidr(callback?: (err: AWSError, data: EC2.Types.CreateCoipCidrResult) => void): Request<EC2.Types.CreateCoipCidrResult, AWSError>;
  /**
   *  Creates a pool of customer-owned IP (CoIP) addresses. 
   */
  createCoipPool(params: EC2.Types.CreateCoipPoolRequest, callback?: (err: AWSError, data: EC2.Types.CreateCoipPoolResult) => void): Request<EC2.Types.CreateCoipPoolResult, AWSError>;
  /**
   *  Creates a pool of customer-owned IP (CoIP) addresses. 
   */
  createCoipPool(callback?: (err: AWSError, data: EC2.Types.CreateCoipPoolResult) => void): Request<EC2.Types.CreateCoipPoolResult, AWSError>;
  /**
   * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s external interface. The IP address must be static and can be behind a device performing network address translation (NAT). For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use a private ASN. For more information, see Customer gateway options for your Site-to-Site VPN connection in the Amazon Web Services Site-to-Site VPN User Guide. To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device name for each customer gateway. An identical request returns information about the existing customer gateway; it doesn't create a new customer gateway.
   */
  createCustomerGateway(params: EC2.Types.CreateCustomerGatewayRequest, callback?: (err: AWSError, data: EC2.Types.CreateCustomerGatewayResult) => void): Request<EC2.Types.CreateCustomerGatewayResult, AWSError>;
  /**
   * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s external interface. The IP address must be static and can be behind a device performing network address translation (NAT). For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use a private ASN. For more information, see Customer gateway options for your Site-to-Site VPN connection in the Amazon Web Services Site-to-Site VPN User Guide. To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device name for each customer gateway. An identical request returns information about the existing customer gateway; it doesn't create a new customer gateway.
   */
  createCustomerGateway(callback?: (err: AWSError, data: EC2.Types.CreateCustomerGatewayResult) => void): Request<EC2.Types.CreateCustomerGatewayResult, AWSError>;
  /**
   * Creates a default subnet with a size /20 IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see Creating a default subnet in the Amazon Virtual Private Cloud User Guide.
   */
  createDefaultSubnet(params: EC2.Types.CreateDefaultSubnetRequest, callback?: (err: AWSError, data: EC2.Types.CreateDefaultSubnetResult) => void): Request<EC2.Types.CreateDefaultSubnetResult, AWSError>;
  /**
   * Creates a default subnet with a size /20 IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see Creating a default subnet in the Amazon Virtual Private Cloud User Guide.
   */
  createDefaultSubnet(callback?: (err: AWSError, data: EC2.Types.CreateDefaultSubnetResult) => void): Request<EC2.Types.CreateDefaultSubnetResult, AWSError>;
  /**
   * Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet in each Availability Zone. For more information about the components of a default VPC, see Default VPC and default subnets in the Amazon Virtual Private Cloud User Guide. You cannot specify the components of the default VPC yourself. If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC per Region. If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see "I really want a default VPC for my existing EC2 account. Is that possible?" in the Default VPCs FAQ.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  createDefaultVpc(params: EC2.Types.CreateDefaultVpcRequest, callback?: (err: AWSError, data: EC2.Types.CreateDefaultVpcResult) => void): Request<EC2.Types.CreateDefaultVpcResult, AWSError>;
  /**
   * Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet in each Availability Zone. For more information about the components of a default VPC, see Default VPC and default subnets in the Amazon Virtual Private Cloud User Guide. You cannot specify the components of the default VPC yourself. If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC per Region. If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see "I really want a default VPC for my existing EC2 account. Is that possible?" in the Default VPCs FAQ.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  createDefaultVpc(callback?: (err: AWSError, data: EC2.Types.CreateDefaultVpcResult) => void): Request<EC2.Types.CreateDefaultVpcResult, AWSError>;
  /**
   * Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the individual DHCP options you can specify. For more information about the options, see RFC 2132.    domain-name-servers - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the IP addresses in a single parameter, separated by commas. To have your instance receive a custom DNS hostname as specified in domain-name, you must set domain-name-servers to a custom DNS server.    domain-name - If you're using AmazonProvidedDNS in us-east-1, specify ec2.internal. If you're using AmazonProvidedDNS in another Region, specify region.compute.internal (for example, ap-northeast-1.compute.internal). Otherwise, specify a domain name (for example, ExampleCompany.com). This value is used to complete unqualified DNS hostnames. Important: Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating systems, specify only one domain name.    ntp-servers - The IP addresses of up to four Network Time Protocol (NTP) servers.    netbios-name-servers - The IP addresses of up to four NetBIOS name servers.    netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2 (broadcast and multicast are not currently supported). For more information about these node types, see RFC 2132.   Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide (AmazonProvidedDNS). If you create a set of options, and if your VPC has an internet gateway, make sure to set the domain-name-servers option either to AmazonProvidedDNS or to a domain name server of your choice. For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide.
   */
  createDhcpOptions(params: EC2.Types.CreateDhcpOptionsRequest, callback?: (err: AWSError, data: EC2.Types.CreateDhcpOptionsResult) => void): Request<EC2.Types.CreateDhcpOptionsResult, AWSError>;
  /**
   * Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the individual DHCP options you can specify. For more information about the options, see RFC 2132.    domain-name-servers - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the IP addresses in a single parameter, separated by commas. To have your instance receive a custom DNS hostname as specified in domain-name, you must set domain-name-servers to a custom DNS server.    domain-name - If you're using AmazonProvidedDNS in us-east-1, specify ec2.internal. If you're using AmazonProvidedDNS in another Region, specify region.compute.internal (for example, ap-northeast-1.compute.internal). Otherwise, specify a domain name (for example, ExampleCompany.com). This value is used to complete unqualified DNS hostnames. Important: Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating systems, specify only one domain name.    ntp-servers - The IP addresses of up to four Network Time Protocol (NTP) servers.    netbios-name-servers - The IP addresses of up to four NetBIOS name servers.    netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2 (broadcast and multicast are not currently supported). For more information about these node types, see RFC 2132.   Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide (AmazonProvidedDNS). If you create a set of options, and if your VPC has an internet gateway, make sure to set the domain-name-servers option either to AmazonProvidedDNS or to a domain name server of your choice. For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide.
   */
  createDhcpOptions(callback?: (err: AWSError, data: EC2.Types.CreateDhcpOptionsResult) => void): Request<EC2.Types.CreateDhcpOptionsResult, AWSError>;
  /**
   * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.
   */
  createEgressOnlyInternetGateway(params: EC2.Types.CreateEgressOnlyInternetGatewayRequest, callback?: (err: AWSError, data: EC2.Types.CreateEgressOnlyInternetGatewayResult) => void): Request<EC2.Types.CreateEgressOnlyInternetGatewayResult, AWSError>;
  /**
   * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.
   */
  createEgressOnlyInternetGateway(callback?: (err: AWSError, data: EC2.Types.CreateEgressOnlyInternetGatewayResult) => void): Request<EC2.Types.CreateEgressOnlyInternetGatewayResult, AWSError>;
  /**
   * Launches an EC2 Fleet. You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet. For more information, see EC2 Fleet in the Amazon EC2 User Guide.
   */
  createFleet(params: EC2.Types.CreateFleetRequest, callback?: (err: AWSError, data: EC2.Types.CreateFleetResult) => void): Request<EC2.Types.CreateFleetResult, AWSError>;
  /**
   * Launches an EC2 Fleet. You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet. For more information, see EC2 Fleet in the Amazon EC2 User Guide.
   */
  createFleet(callback?: (err: AWSError, data: EC2.Types.CreateFleetResult) => void): Request<EC2.Types.CreateFleetResult, AWSError>;
  /**
   * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC.  Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting of fields that describe the traffic flow. For more information, see Flow log records in the Amazon Virtual Private Cloud User Guide. When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored network interfaces are published to a single log file object that is stored in the specified bucket. For more information, see VPC Flow Logs in the Amazon Virtual Private Cloud User Guide.
   */
  createFlowLogs(params: EC2.Types.CreateFlowLogsRequest, callback?: (err: AWSError, data: EC2.Types.CreateFlowLogsResult) => void): Request<EC2.Types.CreateFlowLogsResult, AWSError>;
  /**
   * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC.  Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting of fields that describe the traffic flow. For more information, see Flow log records in the Amazon Virtual Private Cloud User Guide. When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored network interfaces are published to a single log file object that is stored in the specified bucket. For more information, see VPC Flow Logs in the Amazon Virtual Private Cloud User Guide.
   */
  createFlowLogs(callback?: (err: AWSError, data: EC2.Types.CreateFlowLogsResult) => void): Request<EC2.Types.CreateFlowLogsResult, AWSError>;
  /**
   * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP). The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs. An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on multiple FPGA-accelerated instances. For more information, see the Amazon Web Services FPGA Hardware Development Kit.
   */
  createFpgaImage(params: EC2.Types.CreateFpgaImageRequest, callback?: (err: AWSError, data: EC2.Types.CreateFpgaImageResult) => void): Request<EC2.Types.CreateFpgaImageResult, AWSError>;
  /**
   * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP). The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs. An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on multiple FPGA-accelerated instances. For more information, see the Amazon Web Services FPGA Hardware Development Kit.
   */
  createFpgaImage(callback?: (err: AWSError, data: EC2.Types.CreateFpgaImageResult) => void): Request<EC2.Types.CreateFpgaImageResult, AWSError>;
  /**
   * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped. By default, when Amazon EC2 creates the new AMI, it reboots the instance so that it can take snapshots of the attached volumes while data is at rest, in order to ensure a consistent state. You can set the NoReboot parameter to true in the API request, or use the --no-reboot option in the CLI to prevent Amazon EC2 from shutting down and rebooting the instance.  If you choose to bypass the shutdown and reboot process by setting the NoReboot parameter to true in the API request, or by using the --no-reboot option in the CLI, we can't guarantee the file system integrity of the created image.  If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI, the instance automatically launches with those additional volumes. For more information, see Create an Amazon EBS-backed Linux AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  createImage(params: EC2.Types.CreateImageRequest, callback?: (err: AWSError, data: EC2.Types.CreateImageResult) => void): Request<EC2.Types.CreateImageResult, AWSError>;
  /**
   * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped. By default, when Amazon EC2 creates the new AMI, it reboots the instance so that it can take snapshots of the attached volumes while data is at rest, in order to ensure a consistent state. You can set the NoReboot parameter to true in the API request, or use the --no-reboot option in the CLI to prevent Amazon EC2 from shutting down and rebooting the instance.  If you choose to bypass the shutdown and reboot process by setting the NoReboot parameter to true in the API request, or by using the --no-reboot option in the CLI, we can't guarantee the file system integrity of the created image.  If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI, the instance automatically launches with those additional volumes. For more information, see Create an Amazon EBS-backed Linux AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  createImage(callback?: (err: AWSError, data: EC2.Types.CreateImageResult) => void): Request<EC2.Types.CreateImageResult, AWSError>;
  /**
   * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run. You can define either a set of time ranges or a cron expression when creating the event window, but not both. All event window times are in UTC. You can create up to 200 event windows per Amazon Web Services Region. When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with it. To ensure that the event window can be used, you must associate one or more targets with it by using the AssociateInstanceEventWindow API.  Event windows are applicable only for scheduled events that stop, reboot, or terminate instances. Event windows are not applicable for:   Expedited scheduled events and network maintenance events.    Unscheduled maintenance such as AutoRecovery and unplanned reboots.    For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  createInstanceEventWindow(params: EC2.Types.CreateInstanceEventWindowRequest, callback?: (err: AWSError, data: EC2.Types.CreateInstanceEventWindowResult) => void): Request<EC2.Types.CreateInstanceEventWindowResult, AWSError>;
  /**
   * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run. You can define either a set of time ranges or a cron expression when creating the event window, but not both. All event window times are in UTC. You can create up to 200 event windows per Amazon Web Services Region. When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with it. To ensure that the event window can be used, you must associate one or more targets with it by using the AssociateInstanceEventWindow API.  Event windows are applicable only for scheduled events that stop, reboot, or terminate instances. Event windows are not applicable for:   Expedited scheduled events and network maintenance events.    Unscheduled maintenance such as AutoRecovery and unplanned reboots.    For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  createInstanceEventWindow(callback?: (err: AWSError, data: EC2.Types.CreateInstanceEventWindowResult) => void): Request<EC2.Types.CreateInstanceEventWindowResult, AWSError>;
  /**
   * Exports a running or stopped instance to an Amazon S3 bucket. For information about the supported operating systems, image formats, and known limitations for the types of instances you can export, see Exporting an instance as a VM Using VM Import/Export in the VM Import/Export User Guide.
   */
  createInstanceExportTask(params: EC2.Types.CreateInstanceExportTaskRequest, callback?: (err: AWSError, data: EC2.Types.CreateInstanceExportTaskResult) => void): Request<EC2.Types.CreateInstanceExportTaskResult, AWSError>;
  /**
   * Exports a running or stopped instance to an Amazon S3 bucket. For information about the supported operating systems, image formats, and known limitations for the types of instances you can export, see Exporting an instance as a VM Using VM Import/Export in the VM Import/Export User Guide.
   */
  createInstanceExportTask(callback?: (err: AWSError, data: EC2.Types.CreateInstanceExportTaskResult) => void): Request<EC2.Types.CreateInstanceExportTaskResult, AWSError>;
  /**
   * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using AttachInternetGateway. For more information about your VPC and internet gateway, see the Amazon Virtual Private Cloud User Guide.
   */
  createInternetGateway(params: EC2.Types.CreateInternetGatewayRequest, callback?: (err: AWSError, data: EC2.Types.CreateInternetGatewayResult) => void): Request<EC2.Types.CreateInternetGatewayResult, AWSError>;
  /**
   * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using AttachInternetGateway. For more information about your VPC and internet gateway, see the Amazon Virtual Private Cloud User Guide.
   */
  createInternetGateway(callback?: (err: AWSError, data: EC2.Types.CreateInternetGatewayResult) => void): Request<EC2.Types.CreateInternetGatewayResult, AWSError>;
  /**
   * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see Create an IPAM in the Amazon VPC IPAM User Guide. 
   */
  createIpam(params: EC2.Types.CreateIpamRequest, callback?: (err: AWSError, data: EC2.Types.CreateIpamResult) => void): Request<EC2.Types.CreateIpamResult, AWSError>;
  /**
   * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see Create an IPAM in the Amazon VPC IPAM User Guide. 
   */
  createIpam(callback?: (err: AWSError, data: EC2.Types.CreateIpamResult) => void): Request<EC2.Types.CreateIpamResult, AWSError>;
  /**
   * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each. For more information, see Create a top-level pool in the Amazon VPC IPAM User Guide. 
   */
  createIpamPool(params: EC2.Types.CreateIpamPoolRequest, callback?: (err: AWSError, data: EC2.Types.CreateIpamPoolResult) => void): Request<EC2.Types.CreateIpamPoolResult, AWSError>;
  /**
   * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each. For more information, see Create a top-level pool in the Amazon VPC IPAM User Guide. 
   */
  createIpamPool(callback?: (err: AWSError, data: EC2.Types.CreateIpamPoolResult) => void): Request<EC2.Types.CreateIpamPoolResult, AWSError>;
  /**
   * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict. For more information, see Add a scope in the Amazon VPC IPAM User Guide.
   */
  createIpamScope(params: EC2.Types.CreateIpamScopeRequest, callback?: (err: AWSError, data: EC2.Types.CreateIpamScopeResult) => void): Request<EC2.Types.CreateIpamScopeResult, AWSError>;
  /**
   * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict. For more information, see Add a scope in the Amazon VPC IPAM User Guide.
   */
  createIpamScope(callback?: (err: AWSError, data: EC2.Types.CreateIpamScopeResult) => void): Request<EC2.Types.CreateIpamScopeResult, AWSError>;
  /**
   * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified PEM or PPK format. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use with PuTTY. If a key with the specified name already exists, Amazon EC2 returns an error. The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you prefer, you can create your own key pair using a third-party tool and upload it to any Region using ImportKeyPair. You can have up to 5,000 key pairs per Amazon Web Services Region. For more information, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.
   */
  createKeyPair(params: EC2.Types.CreateKeyPairRequest, callback?: (err: AWSError, data: EC2.Types.KeyPair) => void): Request<EC2.Types.KeyPair, AWSError>;
  /**
   * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified PEM or PPK format. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use with PuTTY. If a key with the specified name already exists, Amazon EC2 returns an error. The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you prefer, you can create your own key pair using a third-party tool and upload it to any Region using ImportKeyPair. You can have up to 5,000 key pairs per Amazon Web Services Region. For more information, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.
   */
  createKeyPair(callback?: (err: AWSError, data: EC2.Types.KeyPair) => void): Request<EC2.Types.KeyPair, AWSError>;
  /**
   * Creates a launch template. A launch template contains the parameters to launch an instance. When you launch an instance using RunInstances, you can specify a launch template instead of providing the launch parameters in the request. For more information, see Launch an instance from a launch template in the Amazon Elastic Compute Cloud User Guide. If you want to clone an existing launch template as the basis for creating a new launch template, you can use the Amazon EC2 console. The API, SDKs, and CLI do not support cloning a template. For more information, see Create a launch template from an existing launch template in the Amazon Elastic Compute Cloud User Guide.
   */
  createLaunchTemplate(params: EC2.Types.CreateLaunchTemplateRequest, callback?: (err: AWSError, data: EC2.Types.CreateLaunchTemplateResult) => void): Request<EC2.Types.CreateLaunchTemplateResult, AWSError>;
  /**
   * Creates a launch template. A launch template contains the parameters to launch an instance. When you launch an instance using RunInstances, you can specify a launch template instead of providing the launch parameters in the request. For more information, see Launch an instance from a launch template in the Amazon Elastic Compute Cloud User Guide. If you want to clone an existing launch template as the basis for creating a new launch template, you can use the Amazon EC2 console. The API, SDKs, and CLI do not support cloning a template. For more information, see Create a launch template from an existing launch template in the Amazon Elastic Compute Cloud User Guide.
   */
  createLaunchTemplate(callback?: (err: AWSError, data: EC2.Types.CreateLaunchTemplateResult) => void): Request<EC2.Types.CreateLaunchTemplateResult, AWSError>;
  /**
   * Creates a new version of a launch template. You can specify an existing version of launch template from which to base the new version. Launch template versions are numbered in the order in which they are created. You cannot specify, change, or replace the numbering of launch template versions. Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create a new version of the launch template that includes any changes you require. For more information, see Modify a launch template (manage launch template versions) in the Amazon Elastic Compute Cloud User Guide.
   */
  createLaunchTemplateVersion(params: EC2.Types.CreateLaunchTemplateVersionRequest, callback?: (err: AWSError, data: EC2.Types.CreateLaunchTemplateVersionResult) => void): Request<EC2.Types.CreateLaunchTemplateVersionResult, AWSError>;
  /**
   * Creates a new version of a launch template. You can specify an existing version of launch template from which to base the new version. Launch template versions are numbered in the order in which they are created. You cannot specify, change, or replace the numbering of launch template versions. Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create a new version of the launch template that includes any changes you require. For more information, see Modify a launch template (manage launch template versions) in the Amazon Elastic Compute Cloud User Guide.
   */
  createLaunchTemplateVersion(callback?: (err: AWSError, data: EC2.Types.CreateLaunchTemplateVersionResult) => void): Request<EC2.Types.CreateLaunchTemplateVersionResult, AWSError>;
  /**
   * Creates a static route for the specified local gateway route table. You must specify one of the following targets:     LocalGatewayVirtualInterfaceGroupId     NetworkInterfaceId   
   */
  createLocalGatewayRoute(params: EC2.Types.CreateLocalGatewayRouteRequest, callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteResult) => void): Request<EC2.Types.CreateLocalGatewayRouteResult, AWSError>;
  /**
   * Creates a static route for the specified local gateway route table. You must specify one of the following targets:     LocalGatewayVirtualInterfaceGroupId     NetworkInterfaceId   
   */
  createLocalGatewayRoute(callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteResult) => void): Request<EC2.Types.CreateLocalGatewayRouteResult, AWSError>;
  /**
   *  Creates a local gateway route table. 
   */
  createLocalGatewayRouteTable(params: EC2.Types.CreateLocalGatewayRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteTableResult) => void): Request<EC2.Types.CreateLocalGatewayRouteTableResult, AWSError>;
  /**
   *  Creates a local gateway route table. 
   */
  createLocalGatewayRouteTable(callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteTableResult) => void): Request<EC2.Types.CreateLocalGatewayRouteTableResult, AWSError>;
  /**
   *  Creates a local gateway route table virtual interface group association. 
   */
  createLocalGatewayRouteTableVirtualInterfaceGroupAssociation(params: EC2.Types.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult) => void): Request<EC2.Types.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult, AWSError>;
  /**
   *  Creates a local gateway route table virtual interface group association. 
   */
  createLocalGatewayRouteTableVirtualInterfaceGroupAssociation(callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult) => void): Request<EC2.Types.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult, AWSError>;
  /**
   * Associates the specified VPC with the specified local gateway route table.
   */
  createLocalGatewayRouteTableVpcAssociation(params: EC2.Types.CreateLocalGatewayRouteTableVpcAssociationRequest, callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteTableVpcAssociationResult) => void): Request<EC2.Types.CreateLocalGatewayRouteTableVpcAssociationResult, AWSError>;
  /**
   * Associates the specified VPC with the specified local gateway route table.
   */
  createLocalGatewayRouteTableVpcAssociation(callback?: (err: AWSError, data: EC2.Types.CreateLocalGatewayRouteTableVpcAssociationResult) => void): Request<EC2.Types.CreateLocalGatewayRouteTableVpcAssociationResult, AWSError>;
  /**
   * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and an optional description.
   */
  createManagedPrefixList(params: EC2.Types.CreateManagedPrefixListRequest, callback?: (err: AWSError, data: EC2.Types.CreateManagedPrefixListResult) => void): Request<EC2.Types.CreateManagedPrefixListResult, AWSError>;
  /**
   * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and an optional description.
   */
  createManagedPrefixList(callback?: (err: AWSError, data: EC2.Types.CreateManagedPrefixListResult) => void): Request<EC2.Types.CreateManagedPrefixListResult, AWSError>;
  /**
   * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway. With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that instances in a private subnet can connect to the internet. With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks. For more information, see NAT gateways in the Amazon Virtual Private Cloud User Guide.
   */
  createNatGateway(params: EC2.Types.CreateNatGatewayRequest, callback?: (err: AWSError, data: EC2.Types.CreateNatGatewayResult) => void): Request<EC2.Types.CreateNatGatewayResult, AWSError>;
  /**
   * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway. With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that instances in a private subnet can connect to the internet. With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks. For more information, see NAT gateways in the Amazon Virtual Private Cloud User Guide.
   */
  createNatGateway(callback?: (err: AWSError, data: EC2.Types.CreateNatGatewayResult) => void): Request<EC2.Types.CreateNatGatewayResult, AWSError>;
  /**
   * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  createNetworkAcl(params: EC2.Types.CreateNetworkAclRequest, callback?: (err: AWSError, data: EC2.Types.CreateNetworkAclResult) => void): Request<EC2.Types.CreateNetworkAclResult, AWSError>;
  /**
   * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  createNetworkAcl(callback?: (err: AWSError, data: EC2.Types.CreateNetworkAclResult) => void): Request<EC2.Types.CreateNetworkAclResult, AWSError>;
  /**
   * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules. We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules. After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old one. For more information about network ACLs, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  createNetworkAclEntry(params: EC2.Types.CreateNetworkAclEntryRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules. We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules. After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old one. For more information about network ACLs, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  createNetworkAclEntry(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Creates a Network Access Scope. Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that their networks on Amazon Web Services conform to their network security and governance objectives. For more information, see the Amazon Web Services Network Access Analyzer Guide.
   */
  createNetworkInsightsAccessScope(params: EC2.Types.CreateNetworkInsightsAccessScopeRequest, callback?: (err: AWSError, data: EC2.Types.CreateNetworkInsightsAccessScopeResult) => void): Request<EC2.Types.CreateNetworkInsightsAccessScopeResult, AWSError>;
  /**
   * Creates a Network Access Scope. Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that their networks on Amazon Web Services conform to their network security and governance objectives. For more information, see the Amazon Web Services Network Access Analyzer Guide.
   */
  createNetworkInsightsAccessScope(callback?: (err: AWSError, data: EC2.Types.CreateNetworkInsightsAccessScopeResult) => void): Request<EC2.Types.CreateNetworkInsightsAccessScopeResult, AWSError>;
  /**
   * Creates a path to analyze for reachability. Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual private cloud (VPC). For more information, see What is Reachability Analyzer.
   */
  createNetworkInsightsPath(params: EC2.Types.CreateNetworkInsightsPathRequest, callback?: (err: AWSError, data: EC2.Types.CreateNetworkInsightsPathResult) => void): Request<EC2.Types.CreateNetworkInsightsPathResult, AWSError>;
  /**
   * Creates a path to analyze for reachability. Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual private cloud (VPC). For more information, see What is Reachability Analyzer.
   */
  createNetworkInsightsPath(callback?: (err: AWSError, data: EC2.Types.CreateNetworkInsightsPathResult) => void): Request<EC2.Types.CreateNetworkInsightsPathResult, AWSError>;
  /**
   * Creates a network interface in the specified subnet. The number of IP addresses you can assign to a network interface varies by instance type. For more information, see IP Addresses Per ENI Per Instance Type in the Amazon Virtual Private Cloud User Guide. For more information about network interfaces, see Elastic network interfaces in the Amazon Elastic Compute Cloud User Guide.
   */
  createNetworkInterface(params: EC2.Types.CreateNetworkInterfaceRequest, callback?: (err: AWSError, data: EC2.Types.CreateNetworkInterfaceResult) => void): Request<EC2.Types.CreateNetworkInterfaceResult, AWSError>;
  /**
   * Creates a network interface in the specified subnet. The number of IP addresses you can assign to a network interface varies by instance type. For more information, see IP Addresses Per ENI Per Instance Type in the Amazon Virtual Private Cloud User Guide. For more information about network interfaces, see Elastic network interfaces in the Amazon Elastic Compute Cloud User Guide.
   */
  createNetworkInterface(callback?: (err: AWSError, data: EC2.Types.CreateNetworkInterfaceResult) => void): Request<EC2.Types.CreateNetworkInterfaceResult, AWSError>;
  /**
   * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an instance in their account. You can grant permission to a single Amazon Web Services account only, and only one account at a time.
   */
  createNetworkInterfacePermission(params: EC2.Types.CreateNetworkInterfacePermissionRequest, callback?: (err: AWSError, data: EC2.Types.CreateNetworkInterfacePermissionResult) => void): Request<EC2.Types.CreateNetworkInterfacePermissionResult, AWSError>;
  /**
   * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an instance in their account. You can grant permission to a single Amazon Web Services account only, and only one account at a time.
   */
  createNetworkInterfacePermission(callback?: (err: AWSError, data: EC2.Types.CreateNetworkInterfacePermissionResult) => void): Request<EC2.Types.CreateNetworkInterfacePermissionResult, AWSError>;
  /**
   * Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group.  A cluster placement group is a logical grouping of instances within a single Availability Zone that benefit from low network latency, high network throughput. A spread placement group places instances on distinct hardware. A partition placement group places groups of instances in different partitions, where instances in one partition do not share the same hardware with instances in another partition. For more information, see Placement groups in the Amazon EC2 User Guide.
   */
  createPlacementGroup(params: EC2.Types.CreatePlacementGroupRequest, callback?: (err: AWSError, data: EC2.Types.CreatePlacementGroupResult) => void): Request<EC2.Types.CreatePlacementGroupResult, AWSError>;
  /**
   * Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group.  A cluster placement group is a logical grouping of instances within a single Availability Zone that benefit from low network latency, high network throughput. A spread placement group places instances on distinct hardware. A partition placement group places groups of instances in different partitions, where instances in one partition do not share the same hardware with instances in another partition. For more information, see Placement groups in the Amazon EC2 User Guide.
   */
  createPlacementGroup(callback?: (err: AWSError, data: EC2.Types.CreatePlacementGroupResult) => void): Request<EC2.Types.CreatePlacementGroupResult, AWSError>;
  /**
   * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use DescribePublicIpv4Pools.
   */
  createPublicIpv4Pool(params: EC2.Types.CreatePublicIpv4PoolRequest, callback?: (err: AWSError, data: EC2.Types.CreatePublicIpv4PoolResult) => void): Request<EC2.Types.CreatePublicIpv4PoolResult, AWSError>;
  /**
   * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use DescribePublicIpv4Pools.
   */
  createPublicIpv4Pool(callback?: (err: AWSError, data: EC2.Types.CreatePublicIpv4PoolResult) => void): Request<EC2.Types.CreatePublicIpv4PoolResult, AWSError>;
  /**
   * Replaces the EBS-backed root volume for a running instance with a new volume that is restored to the original root volume's launch state, that is restored to a specific snapshot taken from the original root volume, or that is restored from an AMI that has the same key characteristics as that of the instance. For more information, see Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
   */
  createReplaceRootVolumeTask(params: EC2.Types.CreateReplaceRootVolumeTaskRequest, callback?: (err: AWSError, data: EC2.Types.CreateReplaceRootVolumeTaskResult) => void): Request<EC2.Types.CreateReplaceRootVolumeTaskResult, AWSError>;
  /**
   * Replaces the EBS-backed root volume for a running instance with a new volume that is restored to the original root volume's launch state, that is restored to a specific snapshot taken from the original root volume, or that is restored from an AMI that has the same key characteristics as that of the instance. For more information, see Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
   */
  createReplaceRootVolumeTask(callback?: (err: AWSError, data: EC2.Types.CreateReplaceRootVolumeTaskResult) => void): Request<EC2.Types.CreateReplaceRootVolumeTaskResult, AWSError>;
  /**
   * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the DescribeReservedInstances operation.  Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances cannot be sold.  The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances. To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved Instance listing, you can use the DescribeReservedInstancesListings operation. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  createReservedInstancesListing(params: EC2.Types.CreateReservedInstancesListingRequest, callback?: (err: AWSError, data: EC2.Types.CreateReservedInstancesListingResult) => void): Request<EC2.Types.CreateReservedInstancesListingResult, AWSError>;
  /**
   * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the DescribeReservedInstances operation.  Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances cannot be sold.  The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances. To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved Instance listing, you can use the DescribeReservedInstancesListings operation. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  createReservedInstancesListing(callback?: (err: AWSError, data: EC2.Types.CreateReservedInstancesListingResult) => void): Request<EC2.Types.CreateReservedInstancesListingResult, AWSError>;
  /**
   * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using CreateStoreImageTask. To use this API, you must have the required permissions. For more information, see Permissions for storing and restoring AMIs using Amazon S3 in the Amazon Elastic Compute Cloud User Guide. For more information, see Store and restore an AMI using Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
   */
  createRestoreImageTask(params: EC2.Types.CreateRestoreImageTaskRequest, callback?: (err: AWSError, data: EC2.Types.CreateRestoreImageTaskResult) => void): Request<EC2.Types.CreateRestoreImageTaskResult, AWSError>;
  /**
   * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using CreateStoreImageTask. To use this API, you must have the required permissions. For more information, see Permissions for storing and restoring AMIs using Amazon S3 in the Amazon Elastic Compute Cloud User Guide. For more information, see Store and restore an AMI using Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
   */
  createRestoreImageTask(callback?: (err: AWSError, data: EC2.Types.CreateRestoreImageTaskResult) => void): Request<EC2.Types.CreateRestoreImageTaskResult, AWSError>;
  /**
   * Creates a route in a route table within a VPC. You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the resources from the parameter list. When determining how to route traffic, we use the route with the most specific match. For example, traffic is destined for the IPv4 address 192.0.2.3, and the route table includes the following two IPv4 routes:    192.0.2.0/24 (goes to some target A)    192.0.2.0/28 (goes to some target B)   Both routes apply to the traffic destined for 192.0.2.3. However, the second route in the list covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where to target the traffic. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  createRoute(params: EC2.Types.CreateRouteRequest, callback?: (err: AWSError, data: EC2.Types.CreateRouteResult) => void): Request<EC2.Types.CreateRouteResult, AWSError>;
  /**
   * Creates a route in a route table within a VPC. You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the resources from the parameter list. When determining how to route traffic, we use the route with the most specific match. For example, traffic is destined for the IPv4 address 192.0.2.3, and the route table includes the following two IPv4 routes:    192.0.2.0/24 (goes to some target A)    192.0.2.0/28 (goes to some target B)   Both routes apply to the traffic destined for 192.0.2.3. However, the second route in the list covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where to target the traffic. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  createRoute(callback?: (err: AWSError, data: EC2.Types.CreateRouteResult) => void): Request<EC2.Types.CreateRouteResult, AWSError>;
  /**
   * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  createRouteTable(params: EC2.Types.CreateRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.CreateRouteTableResult) => void): Request<EC2.Types.CreateRouteTableResult, AWSError>;
  /**
   * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  createRouteTable(callback?: (err: AWSError, data: EC2.Types.CreateRouteTableResult) => void): Request<EC2.Types.CreateRouteTableResult, AWSError>;
  /**
   * Creates a security group. A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more information, see Amazon EC2 security groups in the Amazon Elastic Compute Cloud User Guide and Security groups for your VPC in the Amazon Virtual Private Cloud User Guide. When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name. You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don't specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other. You can add or remove rules from your security groups using AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress, RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress. For more information about VPC security group limits, see Amazon VPC Limits.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  createSecurityGroup(params: EC2.Types.CreateSecurityGroupRequest, callback?: (err: AWSError, data: EC2.Types.CreateSecurityGroupResult) => void): Request<EC2.Types.CreateSecurityGroupResult, AWSError>;
  /**
   * Creates a security group. A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more information, see Amazon EC2 security groups in the Amazon Elastic Compute Cloud User Guide and Security groups for your VPC in the Amazon Virtual Private Cloud User Guide. When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name. You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don't specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other. You can add or remove rules from your security groups using AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress, RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress. For more information about VPC security group limits, see Amazon VPC Limits.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  createSecurityGroup(callback?: (err: AWSError, data: EC2.Types.CreateSecurityGroupResult) => void): Request<EC2.Types.CreateSecurityGroupResult, AWSError>;
  /**
   * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance. You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost. When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source volume are propagated to the snapshot. You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the volume long enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is pending. To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the instance before taking the snapshot. Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always remain protected. You can tag your snapshots during creation. For more information, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide. For more information, see Amazon Elastic Block Store and Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  createSnapshot(params: EC2.Types.CreateSnapshotRequest, callback?: (err: AWSError, data: EC2.Types.Snapshot) => void): Request<EC2.Types.Snapshot, AWSError>;
  /**
   * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance. You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost. When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source volume are propagated to the snapshot. You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the volume long enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is pending. To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the instance before taking the snapshot. Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always remain protected. You can tag your snapshots during creation. For more information, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide. For more information, see Amazon Elastic Block Store and Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  createSnapshot(callback?: (err: AWSError, data: EC2.Types.Snapshot) => void): Request<EC2.Types.Snapshot, AWSError>;
  /**
   * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the instance. You can include all of the volumes currently attached to the instance, or you can exclude the root volume or specific data (non-root) volumes from the multi-volume snapshot set. You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance, or in the Region for that Outpost.
   */
  createSnapshots(params: EC2.Types.CreateSnapshotsRequest, callback?: (err: AWSError, data: EC2.Types.CreateSnapshotsResult) => void): Request<EC2.Types.CreateSnapshotsResult, AWSError>;
  /**
   * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the instance. You can include all of the volumes currently attached to the instance, or you can exclude the root volume or specific data (non-root) volumes from the multi-volume snapshot set. You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance, or in the Region for that Outpost.
   */
  createSnapshots(callback?: (err: AWSError, data: EC2.Types.CreateSnapshotsResult) => void): Request<EC2.Types.CreateSnapshotsResult, AWSError>;
  /**
   * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per Amazon Web Services account. For more information, see Spot Instance data feed in the Amazon EC2 User Guide for Linux Instances.
   */
  createSpotDatafeedSubscription(params: EC2.Types.CreateSpotDatafeedSubscriptionRequest, callback?: (err: AWSError, data: EC2.Types.CreateSpotDatafeedSubscriptionResult) => void): Request<EC2.Types.CreateSpotDatafeedSubscriptionResult, AWSError>;
  /**
   * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per Amazon Web Services account. For more information, see Spot Instance data feed in the Amazon EC2 User Guide for Linux Instances.
   */
  createSpotDatafeedSubscription(callback?: (err: AWSError, data: EC2.Types.CreateSpotDatafeedSubscriptionResult) => void): Request<EC2.Types.CreateSpotDatafeedSubscriptionResult, AWSError>;
  /**
   * Stores an AMI as a single object in an Amazon S3 bucket. To use this API, you must have the required permissions. For more information, see Permissions for storing and restoring AMIs using Amazon S3 in the Amazon Elastic Compute Cloud User Guide. For more information, see Store and restore an AMI using Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
   */
  createStoreImageTask(params: EC2.Types.CreateStoreImageTaskRequest, callback?: (err: AWSError, data: EC2.Types.CreateStoreImageTaskResult) => void): Request<EC2.Types.CreateStoreImageTaskResult, AWSError>;
  /**
   * Stores an AMI as a single object in an Amazon S3 bucket. To use this API, you must have the required permissions. For more information, see Permissions for storing and restoring AMIs using Amazon S3 in the Amazon Elastic Compute Cloud User Guide. For more information, see Store and restore an AMI using Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
   */
  createStoreImageTask(callback?: (err: AWSError, data: EC2.Types.CreateStoreImageTaskResult) => void): Request<EC2.Types.CreateStoreImageTaskResult, AWSError>;
  /**
   * Creates a subnet in a specified VPC. You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you can't change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the CIDR block of an existing subnet in the VPC. If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses a /64 prefix length.   Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR block. They're not available for use.  If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle. When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a subnet with no running instances (they're all stopped), but no remaining IP addresses available. For more information about subnets, see Your VPC and subnets in the Amazon Virtual Private Cloud User Guide.
   */
  createSubnet(params: EC2.Types.CreateSubnetRequest, callback?: (err: AWSError, data: EC2.Types.CreateSubnetResult) => void): Request<EC2.Types.CreateSubnetResult, AWSError>;
  /**
   * Creates a subnet in a specified VPC. You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you can't change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the CIDR block of an existing subnet in the VPC. If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses a /64 prefix length.   Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR block. They're not available for use.  If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle. When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a subnet with no running instances (they're all stopped), but no remaining IP addresses available. For more information about subnets, see Your VPC and subnets in the Amazon Virtual Private Cloud User Guide.
   */
  createSubnet(callback?: (err: AWSError, data: EC2.Types.CreateSubnetResult) => void): Request<EC2.Types.CreateSubnetResult, AWSError>;
  /**
   * Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see Subnet CIDR reservations in the Amazon Virtual Private Cloud User Guide.
   */
  createSubnetCidrReservation(params: EC2.Types.CreateSubnetCidrReservationRequest, callback?: (err: AWSError, data: EC2.Types.CreateSubnetCidrReservationResult) => void): Request<EC2.Types.CreateSubnetCidrReservationResult, AWSError>;
  /**
   * Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see Subnet CIDR reservations in the Amazon Virtual Private Cloud User Guide.
   */
  createSubnetCidrReservation(callback?: (err: AWSError, data: EC2.Types.CreateSubnetCidrReservationResult) => void): Request<EC2.Types.CreateSubnetCidrReservationResult, AWSError>;
  /**
   * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource. For more information about tags, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide. For more information about creating IAM policies that control users' access to resources based on tags, see Supported resource-level permissions for Amazon EC2 API actions in the Amazon Elastic Compute Cloud User Guide.
   */
  createTags(params: EC2.Types.CreateTagsRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource. For more information about tags, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide. For more information about creating IAM policies that control users' access to resources based on tags, see Supported resource-level permissions for Amazon EC2 API actions in the Amazon Elastic Compute Cloud User Guide.
   */
  createTags(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Creates a Traffic Mirror filter. A Traffic Mirror filter is a set of rules that defines the traffic to mirror. By default, no traffic is mirrored. To mirror traffic, use CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the filter. The rules you add define what traffic gets mirrored. You can also use ModifyTrafficMirrorFilterNetworkServices to mirror supported network services.
   */
  createTrafficMirrorFilter(params: EC2.Types.CreateTrafficMirrorFilterRequest, callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorFilterResult) => void): Request<EC2.Types.CreateTrafficMirrorFilterResult, AWSError>;
  /**
   * Creates a Traffic Mirror filter. A Traffic Mirror filter is a set of rules that defines the traffic to mirror. By default, no traffic is mirrored. To mirror traffic, use CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the filter. The rules you add define what traffic gets mirrored. You can also use ModifyTrafficMirrorFilterNetworkServices to mirror supported network services.
   */
  createTrafficMirrorFilter(callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorFilterResult) => void): Request<EC2.Types.CreateTrafficMirrorFilterResult, AWSError>;
  /**
   * Creates a Traffic Mirror filter rule. A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror. You need the Traffic Mirror filter ID when you create the rule.
   */
  createTrafficMirrorFilterRule(params: EC2.Types.CreateTrafficMirrorFilterRuleRequest, callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorFilterRuleResult) => void): Request<EC2.Types.CreateTrafficMirrorFilterRuleResult, AWSError>;
  /**
   * Creates a Traffic Mirror filter rule. A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror. You need the Traffic Mirror filter ID when you create the rule.
   */
  createTrafficMirrorFilterRule(callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorFilterRuleResult) => void): Request<EC2.Types.CreateTrafficMirrorFilterRuleResult, AWSError>;
  /**
   * Creates a Traffic Mirror session. A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway.  By default, no traffic is mirrored. Use CreateTrafficMirrorFilter to create filter rules that specify the traffic to mirror.
   */
  createTrafficMirrorSession(params: EC2.Types.CreateTrafficMirrorSessionRequest, callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorSessionResult) => void): Request<EC2.Types.CreateTrafficMirrorSessionResult, AWSError>;
  /**
   * Creates a Traffic Mirror session. A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway.  By default, no traffic is mirrored. Use CreateTrafficMirrorFilter to create filter rules that specify the traffic to mirror.
   */
  createTrafficMirrorSession(callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorSessionResult) => void): Request<EC2.Types.CreateTrafficMirrorSessionResult, AWSError>;
  /**
   * Creates a target for your Traffic Mirror session. A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a transit gateway. A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint. To use the target in a Traffic Mirror session, use CreateTrafficMirrorSession.
   */
  createTrafficMirrorTarget(params: EC2.Types.CreateTrafficMirrorTargetRequest, callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorTargetResult) => void): Request<EC2.Types.CreateTrafficMirrorTargetResult, AWSError>;
  /**
   * Creates a target for your Traffic Mirror session. A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a transit gateway. A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint. To use the target in a Traffic Mirror session, use CreateTrafficMirrorSession.
   */
  createTrafficMirrorTarget(callback?: (err: AWSError, data: EC2.Types.CreateTrafficMirrorTargetResult) => void): Request<EC2.Types.CreateTrafficMirrorTargetResult, AWSError>;
  /**
   * Creates a transit gateway. You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After the transit gateway enters the available state, you can attach your VPCs and VPN connections to the transit gateway. To attach your VPCs, use CreateTransitGatewayVpcAttachment. To attach a VPN connection, use CreateCustomerGateway to create a customer gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to CreateVpnConnection. When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table and the default propagation route table. You can use CreateTransitGatewayRouteTable to create additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table. You can use EnableTransitGatewayRouteTablePropagation to propagate routes from a resource attachment to a transit gateway route table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable to associate a resource attachment with a transit gateway route table.
   */
  createTransitGateway(params: EC2.Types.CreateTransitGatewayRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayResult) => void): Request<EC2.Types.CreateTransitGatewayResult, AWSError>;
  /**
   * Creates a transit gateway. You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After the transit gateway enters the available state, you can attach your VPCs and VPN connections to the transit gateway. To attach your VPCs, use CreateTransitGatewayVpcAttachment. To attach a VPN connection, use CreateCustomerGateway to create a customer gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to CreateVpnConnection. When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table and the default propagation route table. You can use CreateTransitGatewayRouteTable to create additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table. You can use EnableTransitGatewayRouteTablePropagation to propagate routes from a resource attachment to a transit gateway route table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable to associate a resource attachment with a transit gateway route table.
   */
  createTransitGateway(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayResult) => void): Request<EC2.Types.CreateTransitGatewayResult, AWSError>;
  /**
   * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance. A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying transport mechanism.
   */
  createTransitGatewayConnect(params: EC2.Types.CreateTransitGatewayConnectRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayConnectResult) => void): Request<EC2.Types.CreateTransitGatewayConnectResult, AWSError>;
  /**
   * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance. A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying transport mechanism.
   */
  createTransitGatewayConnect(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayConnectResult) => void): Request<EC2.Types.CreateTransitGatewayConnectResult, AWSError>;
  /**
   * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6). For more information, see Connect peers in the Transit Gateways Guide.
   */
  createTransitGatewayConnectPeer(params: EC2.Types.CreateTransitGatewayConnectPeerRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayConnectPeerResult) => void): Request<EC2.Types.CreateTransitGatewayConnectPeerResult, AWSError>;
  /**
   * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6). For more information, see Connect peers in the Transit Gateways Guide.
   */
  createTransitGatewayConnectPeer(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayConnectPeerResult) => void): Request<EC2.Types.CreateTransitGatewayConnectPeerResult, AWSError>;
  /**
   * Creates a multicast domain using the specified transit gateway. The transit gateway must be in the available state before you create a domain. Use DescribeTransitGateways to see the state of transit gateway.
   */
  createTransitGatewayMulticastDomain(params: EC2.Types.CreateTransitGatewayMulticastDomainRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.CreateTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Creates a multicast domain using the specified transit gateway. The transit gateway must be in the available state before you create a domain. Use DescribeTransitGateways to see the state of transit gateway.
   */
  createTransitGatewayMulticastDomain(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.CreateTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services account. After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment request.
   */
  createTransitGatewayPeeringAttachment(params: EC2.Types.CreateTransitGatewayPeeringAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.CreateTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services account. After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment request.
   */
  createTransitGatewayPeeringAttachment(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.CreateTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Creates a transit gateway policy table.
   */
  createTransitGatewayPolicyTable(params: EC2.Types.CreateTransitGatewayPolicyTableRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayPolicyTableResult) => void): Request<EC2.Types.CreateTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Creates a transit gateway policy table.
   */
  createTransitGatewayPolicyTable(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayPolicyTableResult) => void): Request<EC2.Types.CreateTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Creates a reference (route) to a prefix list in a specified transit gateway route table.
   */
  createTransitGatewayPrefixListReference(params: EC2.Types.CreateTransitGatewayPrefixListReferenceRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayPrefixListReferenceResult) => void): Request<EC2.Types.CreateTransitGatewayPrefixListReferenceResult, AWSError>;
  /**
   * Creates a reference (route) to a prefix list in a specified transit gateway route table.
   */
  createTransitGatewayPrefixListReference(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayPrefixListReferenceResult) => void): Request<EC2.Types.CreateTransitGatewayPrefixListReferenceResult, AWSError>;
  /**
   * Creates a static route for the specified transit gateway route table.
   */
  createTransitGatewayRoute(params: EC2.Types.CreateTransitGatewayRouteRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayRouteResult) => void): Request<EC2.Types.CreateTransitGatewayRouteResult, AWSError>;
  /**
   * Creates a static route for the specified transit gateway route table.
   */
  createTransitGatewayRoute(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayRouteResult) => void): Request<EC2.Types.CreateTransitGatewayRouteResult, AWSError>;
  /**
   * Creates a route table for the specified transit gateway.
   */
  createTransitGatewayRouteTable(params: EC2.Types.CreateTransitGatewayRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayRouteTableResult) => void): Request<EC2.Types.CreateTransitGatewayRouteTableResult, AWSError>;
  /**
   * Creates a route table for the specified transit gateway.
   */
  createTransitGatewayRouteTable(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayRouteTableResult) => void): Request<EC2.Types.CreateTransitGatewayRouteTableResult, AWSError>;
  /**
   * Advertises a new transit gateway route table.
   */
  createTransitGatewayRouteTableAnnouncement(params: EC2.Types.CreateTransitGatewayRouteTableAnnouncementRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayRouteTableAnnouncementResult) => void): Request<EC2.Types.CreateTransitGatewayRouteTableAnnouncementResult, AWSError>;
  /**
   * Advertises a new transit gateway route table.
   */
  createTransitGatewayRouteTableAnnouncement(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayRouteTableAnnouncementResult) => void): Request<EC2.Types.CreateTransitGatewayRouteTableAnnouncementResult, AWSError>;
  /**
   * Attaches the specified VPC to the specified transit gateway. If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC CIDR range is not propagated to the default propagation route table. To send VPC traffic to an attached transit gateway, add a route to the VPC route table using CreateRoute.
   */
  createTransitGatewayVpcAttachment(params: EC2.Types.CreateTransitGatewayVpcAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.CreateTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Attaches the specified VPC to the specified transit gateway. If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC CIDR range is not propagated to the default propagation route table. To send VPC traffic to an attached transit gateway, add a route to the VPC route table using CreateRoute.
   */
  createTransitGatewayVpcAttachment(callback?: (err: AWSError, data: EC2.Types.CreateTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.CreateTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Creates an EBS volume that can be attached to an instance in the same Availability Zone. You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace product codes from the snapshot are propagated to the volume. You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide. You can tag your volumes during creation. For more information, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide. For more information, see Create an Amazon EBS volume in the Amazon Elastic Compute Cloud User Guide.
   */
  createVolume(params: EC2.Types.CreateVolumeRequest, callback?: (err: AWSError, data: EC2.Types.Volume) => void): Request<EC2.Types.Volume, AWSError>;
  /**
   * Creates an EBS volume that can be attached to an instance in the same Availability Zone. You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace product codes from the snapshot are propagated to the volume. You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide. You can tag your volumes during creation. For more information, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide. For more information, see Create an Amazon EBS volume in the Amazon Elastic Compute Cloud User Guide.
   */
  createVolume(callback?: (err: AWSError, data: EC2.Types.Volume) => void): Request<EC2.Types.Volume, AWSError>;
  /**
   * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). For more information about how large to make your VPC, see Your VPC and subnets in the Amazon Virtual Private Cloud User Guide. You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (BYOIP). By default, each instance you launch in the VPC has the default DHCP options, which include only a default DNS server that we provide (AmazonProvidedDNS). For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide. You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the VPC after you create it. For more information, see Dedicated Instances in the Amazon Elastic Compute Cloud User Guide.
   */
  createVpc(params: EC2.Types.CreateVpcRequest, callback?: (err: AWSError, data: EC2.Types.CreateVpcResult) => void): Request<EC2.Types.CreateVpcResult, AWSError>;
  /**
   * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). For more information about how large to make your VPC, see Your VPC and subnets in the Amazon Virtual Private Cloud User Guide. You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (BYOIP). By default, each instance you launch in the VPC has the default DHCP options, which include only a default DNS server that we provide (AmazonProvidedDNS). For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide. You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the VPC after you create it. For more information, see Dedicated Instances in the Amazon Elastic Compute Cloud User Guide.
   */
  createVpc(callback?: (err: AWSError, data: EC2.Types.CreateVpcResult) => void): Request<EC2.Types.CreateVpcResult, AWSError>;
  /**
   * Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between your VPC and the service. The service may be provided by Amazon Web Services, an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information, see the Amazon Web Services PrivateLink Guide.
   */
  createVpcEndpoint(params: EC2.Types.CreateVpcEndpointRequest, callback?: (err: AWSError, data: EC2.Types.CreateVpcEndpointResult) => void): Request<EC2.Types.CreateVpcEndpointResult, AWSError>;
  /**
   * Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between your VPC and the service. The service may be provided by Amazon Web Services, an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information, see the Amazon Web Services PrivateLink Guide.
   */
  createVpcEndpoint(callback?: (err: AWSError, data: EC2.Types.CreateVpcEndpointResult) => void): Request<EC2.Types.CreateVpcEndpointResult, AWSError>;
  /**
   * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more information, see Create a Topic in the Amazon Simple Notification Service Developer Guide. You can create a connection notification for interface endpoints only.
   */
  createVpcEndpointConnectionNotification(params: EC2.Types.CreateVpcEndpointConnectionNotificationRequest, callback?: (err: AWSError, data: EC2.Types.CreateVpcEndpointConnectionNotificationResult) => void): Request<EC2.Types.CreateVpcEndpointConnectionNotificationResult, AWSError>;
  /**
   * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more information, see Create a Topic in the Amazon Simple Notification Service Developer Guide. You can create a connection notification for interface endpoints only.
   */
  createVpcEndpointConnectionNotification(callback?: (err: AWSError, data: EC2.Types.CreateVpcEndpointConnectionNotificationResult) => void): Request<EC2.Types.CreateVpcEndpointConnectionNotificationResult, AWSError>;
  /**
   * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, IAM users, and IAM roles) can connect. Before you create an endpoint service, you must create one of the following for your service:   A Network Load Balancer. Service consumers connect to your service using an interface endpoint.   A Gateway Load Balancer. Service consumers connect to your service using a Gateway Load Balancer endpoint.   If you set the private DNS name, you must prove that you own the private DNS domain name. For more information, see the Amazon Web Services PrivateLink Guide.
   */
  createVpcEndpointServiceConfiguration(params: EC2.Types.CreateVpcEndpointServiceConfigurationRequest, callback?: (err: AWSError, data: EC2.Types.CreateVpcEndpointServiceConfigurationResult) => void): Request<EC2.Types.CreateVpcEndpointServiceConfigurationResult, AWSError>;
  /**
   * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, IAM users, and IAM roles) can connect. Before you create an endpoint service, you must create one of the following for your service:   A Network Load Balancer. Service consumers connect to your service using an interface endpoint.   A Gateway Load Balancer. Service consumers connect to your service using a Gateway Load Balancer endpoint.   If you set the private DNS name, you must prove that you own the private DNS domain name. For more information, see the Amazon Web Services PrivateLink Guide.
   */
  createVpcEndpointServiceConfiguration(callback?: (err: AWSError, data: EC2.Types.CreateVpcEndpointServiceConfigurationResult) => void): Request<EC2.Types.CreateVpcEndpointServiceConfigurationResult, AWSError>;
  /**
   * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.  Limitations and rules apply to a VPC peering connection. For more information, see the limitations section in the VPC Peering Guide.  The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering connection request expires after 7 days, after which it cannot be accepted or rejected. If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering connection has a status of failed.
   */
  createVpcPeeringConnection(params: EC2.Types.CreateVpcPeeringConnectionRequest, callback?: (err: AWSError, data: EC2.Types.CreateVpcPeeringConnectionResult) => void): Request<EC2.Types.CreateVpcPeeringConnectionResult, AWSError>;
  /**
   * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.  Limitations and rules apply to a VPC peering connection. For more information, see the limitations section in the VPC Peering Guide.  The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering connection request expires after 7 days, after which it cannot be accepted or rejected. If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering connection has a status of failed.
   */
  createVpcPeeringConnection(callback?: (err: AWSError, data: EC2.Types.CreateVpcPeeringConnectionResult) => void): Request<EC2.Types.CreateVpcPeeringConnectionResult, AWSError>;
  /**
   * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway. The supported connection type is ipsec.1. The response includes information that you need to give to your network administrator to configure your customer gateway.  We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive cryptographic information for configuring your customer gateway device.  If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must reconfigure your customer gateway with the new information returned from this call. This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  createVpnConnection(params: EC2.Types.CreateVpnConnectionRequest, callback?: (err: AWSError, data: EC2.Types.CreateVpnConnectionResult) => void): Request<EC2.Types.CreateVpnConnectionResult, AWSError>;
  /**
   * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway. The supported connection type is ipsec.1. The response includes information that you need to give to your network administrator to configure your customer gateway.  We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive cryptographic information for configuring your customer gateway device.  If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must reconfigure your customer gateway with the new information returned from this call. This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  createVpnConnection(callback?: (err: AWSError, data: EC2.Types.CreateVpnConnectionResult) => void): Request<EC2.Types.CreateVpnConnectionResult, AWSError>;
  /**
   * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  createVpnConnectionRoute(params: EC2.Types.CreateVpnConnectionRouteRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  createVpnConnectionRoute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN connection. You can create a virtual private gateway before creating the VPC itself. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  createVpnGateway(params: EC2.Types.CreateVpnGatewayRequest, callback?: (err: AWSError, data: EC2.Types.CreateVpnGatewayResult) => void): Request<EC2.Types.CreateVpnGatewayResult, AWSError>;
  /**
   * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN connection. You can create a virtual private gateway before creating the VPC itself. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  createVpnGateway(callback?: (err: AWSError, data: EC2.Types.CreateVpnGatewayResult) => void): Request<EC2.Types.CreateVpnGatewayResult, AWSError>;
  /**
   * Deletes a carrier gateway.  If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route. For information about how to delete a route, see DeleteRoute. 
   */
  deleteCarrierGateway(params: EC2.Types.DeleteCarrierGatewayRequest, callback?: (err: AWSError, data: EC2.Types.DeleteCarrierGatewayResult) => void): Request<EC2.Types.DeleteCarrierGatewayResult, AWSError>;
  /**
   * Deletes a carrier gateway.  If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route. For information about how to delete a route, see DeleteRoute. 
   */
  deleteCarrierGateway(callback?: (err: AWSError, data: EC2.Types.DeleteCarrierGatewayResult) => void): Request<EC2.Types.DeleteCarrierGatewayResult, AWSError>;
  /**
   * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a Client VPN endpoint.
   */
  deleteClientVpnEndpoint(params: EC2.Types.DeleteClientVpnEndpointRequest, callback?: (err: AWSError, data: EC2.Types.DeleteClientVpnEndpointResult) => void): Request<EC2.Types.DeleteClientVpnEndpointResult, AWSError>;
  /**
   * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a Client VPN endpoint.
   */
  deleteClientVpnEndpoint(callback?: (err: AWSError, data: EC2.Types.DeleteClientVpnEndpointResult) => void): Request<EC2.Types.DeleteClientVpnEndpointResult, AWSError>;
  /**
   * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the CreateClientVpnRoute action. You cannot delete routes that were automatically added when associating a subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN endpoint.
   */
  deleteClientVpnRoute(params: EC2.Types.DeleteClientVpnRouteRequest, callback?: (err: AWSError, data: EC2.Types.DeleteClientVpnRouteResult) => void): Request<EC2.Types.DeleteClientVpnRouteResult, AWSError>;
  /**
   * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the CreateClientVpnRoute action. You cannot delete routes that were automatically added when associating a subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN endpoint.
   */
  deleteClientVpnRoute(callback?: (err: AWSError, data: EC2.Types.DeleteClientVpnRouteResult) => void): Request<EC2.Types.DeleteClientVpnRouteResult, AWSError>;
  /**
   *  Deletes a range of customer-owned IP addresses. 
   */
  deleteCoipCidr(params: EC2.Types.DeleteCoipCidrRequest, callback?: (err: AWSError, data: EC2.Types.DeleteCoipCidrResult) => void): Request<EC2.Types.DeleteCoipCidrResult, AWSError>;
  /**
   *  Deletes a range of customer-owned IP addresses. 
   */
  deleteCoipCidr(callback?: (err: AWSError, data: EC2.Types.DeleteCoipCidrResult) => void): Request<EC2.Types.DeleteCoipCidrResult, AWSError>;
  /**
   * Deletes a pool of customer-owned IP (CoIP) addresses. 
   */
  deleteCoipPool(params: EC2.Types.DeleteCoipPoolRequest, callback?: (err: AWSError, data: EC2.Types.DeleteCoipPoolResult) => void): Request<EC2.Types.DeleteCoipPoolResult, AWSError>;
  /**
   * Deletes a pool of customer-owned IP (CoIP) addresses. 
   */
  deleteCoipPool(callback?: (err: AWSError, data: EC2.Types.DeleteCoipPoolResult) => void): Request<EC2.Types.DeleteCoipPoolResult, AWSError>;
  /**
   * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer gateway.
   */
  deleteCustomerGateway(params: EC2.Types.DeleteCustomerGatewayRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer gateway.
   */
  deleteCustomerGateway(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.
   */
  deleteDhcpOptions(params: EC2.Types.DeleteDhcpOptionsRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.
   */
  deleteDhcpOptions(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes an egress-only internet gateway.
   */
  deleteEgressOnlyInternetGateway(params: EC2.Types.DeleteEgressOnlyInternetGatewayRequest, callback?: (err: AWSError, data: EC2.Types.DeleteEgressOnlyInternetGatewayResult) => void): Request<EC2.Types.DeleteEgressOnlyInternetGatewayResult, AWSError>;
  /**
   * Deletes an egress-only internet gateway.
   */
  deleteEgressOnlyInternetGateway(callback?: (err: AWSError, data: EC2.Types.DeleteEgressOnlyInternetGatewayResult) => void): Request<EC2.Types.DeleteEgressOnlyInternetGatewayResult, AWSError>;
  /**
   * Deletes the specified EC2 Fleet. After you delete an EC2 Fleet, it launches no new instances. You must specify whether a deleted EC2 Fleet should also terminate its instances. If you choose to terminate the instances, the EC2 Fleet enters the deleted_terminating state. Otherwise, the EC2 Fleet enters the deleted_running state, and the instances continue to run until they are interrupted or you terminate them manually. For instant fleets, EC2 Fleet must terminate the instances when the fleet is deleted. A deleted instant fleet with running instances is not supported.  Restrictions    You can delete up to 25 instant fleets in a single request. If you exceed this number, no instant fleets are deleted and an error is returned. There is no restriction on the number of fleets of type maintain or request that can be deleted in a single request.   Up to 1000 instances can be terminated in a single request to delete instant fleets.   For more information, see Delete an EC2 Fleet in the Amazon EC2 User Guide.
   */
  deleteFleets(params: EC2.Types.DeleteFleetsRequest, callback?: (err: AWSError, data: EC2.Types.DeleteFleetsResult) => void): Request<EC2.Types.DeleteFleetsResult, AWSError>;
  /**
   * Deletes the specified EC2 Fleet. After you delete an EC2 Fleet, it launches no new instances. You must specify whether a deleted EC2 Fleet should also terminate its instances. If you choose to terminate the instances, the EC2 Fleet enters the deleted_terminating state. Otherwise, the EC2 Fleet enters the deleted_running state, and the instances continue to run until they are interrupted or you terminate them manually. For instant fleets, EC2 Fleet must terminate the instances when the fleet is deleted. A deleted instant fleet with running instances is not supported.  Restrictions    You can delete up to 25 instant fleets in a single request. If you exceed this number, no instant fleets are deleted and an error is returned. There is no restriction on the number of fleets of type maintain or request that can be deleted in a single request.   Up to 1000 instances can be terminated in a single request to delete instant fleets.   For more information, see Delete an EC2 Fleet in the Amazon EC2 User Guide.
   */
  deleteFleets(callback?: (err: AWSError, data: EC2.Types.DeleteFleetsResult) => void): Request<EC2.Types.DeleteFleetsResult, AWSError>;
  /**
   * Deletes one or more flow logs.
   */
  deleteFlowLogs(params: EC2.Types.DeleteFlowLogsRequest, callback?: (err: AWSError, data: EC2.Types.DeleteFlowLogsResult) => void): Request<EC2.Types.DeleteFlowLogsResult, AWSError>;
  /**
   * Deletes one or more flow logs.
   */
  deleteFlowLogs(callback?: (err: AWSError, data: EC2.Types.DeleteFlowLogsResult) => void): Request<EC2.Types.DeleteFlowLogsResult, AWSError>;
  /**
   * Deletes the specified Amazon FPGA Image (AFI).
   */
  deleteFpgaImage(params: EC2.Types.DeleteFpgaImageRequest, callback?: (err: AWSError, data: EC2.Types.DeleteFpgaImageResult) => void): Request<EC2.Types.DeleteFpgaImageResult, AWSError>;
  /**
   * Deletes the specified Amazon FPGA Image (AFI).
   */
  deleteFpgaImage(callback?: (err: AWSError, data: EC2.Types.DeleteFpgaImageResult) => void): Request<EC2.Types.DeleteFpgaImageResult, AWSError>;
  /**
   * Deletes the specified event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  deleteInstanceEventWindow(params: EC2.Types.DeleteInstanceEventWindowRequest, callback?: (err: AWSError, data: EC2.Types.DeleteInstanceEventWindowResult) => void): Request<EC2.Types.DeleteInstanceEventWindowResult, AWSError>;
  /**
   * Deletes the specified event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  deleteInstanceEventWindow(callback?: (err: AWSError, data: EC2.Types.DeleteInstanceEventWindowResult) => void): Request<EC2.Types.DeleteInstanceEventWindowResult, AWSError>;
  /**
   * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete it.
   */
  deleteInternetGateway(params: EC2.Types.DeleteInternetGatewayRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete it.
   */
  deleteInternetGateway(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical data for CIDRs. For more information, see Delete an IPAM in the Amazon VPC IPAM User Guide. 
   */
  deleteIpam(params: EC2.Types.DeleteIpamRequest, callback?: (err: AWSError, data: EC2.Types.DeleteIpamResult) => void): Request<EC2.Types.DeleteIpamResult, AWSError>;
  /**
   * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical data for CIDRs. For more information, see Delete an IPAM in the Amazon VPC IPAM User Guide. 
   */
  deleteIpam(callback?: (err: AWSError, data: EC2.Types.DeleteIpamResult) => void): Request<EC2.Types.DeleteIpamResult, AWSError>;
  /**
   * Delete an IPAM pool.  You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations, see ReleaseIpamPoolAllocation. To deprovision pool CIDRs, see DeprovisionIpamPoolCidr.  For more information, see Delete a pool in the Amazon VPC IPAM User Guide. 
   */
  deleteIpamPool(params: EC2.Types.DeleteIpamPoolRequest, callback?: (err: AWSError, data: EC2.Types.DeleteIpamPoolResult) => void): Request<EC2.Types.DeleteIpamPoolResult, AWSError>;
  /**
   * Delete an IPAM pool.  You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations, see ReleaseIpamPoolAllocation. To deprovision pool CIDRs, see DeprovisionIpamPoolCidr.  For more information, see Delete a pool in the Amazon VPC IPAM User Guide. 
   */
  deleteIpamPool(callback?: (err: AWSError, data: EC2.Types.DeleteIpamPoolResult) => void): Request<EC2.Types.DeleteIpamPoolResult, AWSError>;
  /**
   * Delete the scope for an IPAM. You cannot delete the default scopes. For more information, see Delete a scope in the Amazon VPC IPAM User Guide. 
   */
  deleteIpamScope(params: EC2.Types.DeleteIpamScopeRequest, callback?: (err: AWSError, data: EC2.Types.DeleteIpamScopeResult) => void): Request<EC2.Types.DeleteIpamScopeResult, AWSError>;
  /**
   * Delete the scope for an IPAM. You cannot delete the default scopes. For more information, see Delete a scope in the Amazon VPC IPAM User Guide. 
   */
  deleteIpamScope(callback?: (err: AWSError, data: EC2.Types.DeleteIpamScopeResult) => void): Request<EC2.Types.DeleteIpamScopeResult, AWSError>;
  /**
   * Deletes the specified key pair, by removing the public key from Amazon EC2.
   */
  deleteKeyPair(params: EC2.Types.DeleteKeyPairRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified key pair, by removing the public key from Amazon EC2.
   */
  deleteKeyPair(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes a launch template. Deleting a launch template deletes all of its versions.
   */
  deleteLaunchTemplate(params: EC2.Types.DeleteLaunchTemplateRequest, callback?: (err: AWSError, data: EC2.Types.DeleteLaunchTemplateResult) => void): Request<EC2.Types.DeleteLaunchTemplateResult, AWSError>;
  /**
   * Deletes a launch template. Deleting a launch template deletes all of its versions.
   */
  deleteLaunchTemplate(callback?: (err: AWSError, data: EC2.Types.DeleteLaunchTemplateResult) => void): Request<EC2.Types.DeleteLaunchTemplateResult, AWSError>;
  /**
   * Deletes one or more versions of a launch template. You cannot delete the default version of a launch template; you must first assign a different version as the default. If the default version is the only version for the launch template, you must delete the entire launch template using DeleteLaunchTemplate.
   */
  deleteLaunchTemplateVersions(params: EC2.Types.DeleteLaunchTemplateVersionsRequest, callback?: (err: AWSError, data: EC2.Types.DeleteLaunchTemplateVersionsResult) => void): Request<EC2.Types.DeleteLaunchTemplateVersionsResult, AWSError>;
  /**
   * Deletes one or more versions of a launch template. You cannot delete the default version of a launch template; you must first assign a different version as the default. If the default version is the only version for the launch template, you must delete the entire launch template using DeleteLaunchTemplate.
   */
  deleteLaunchTemplateVersions(callback?: (err: AWSError, data: EC2.Types.DeleteLaunchTemplateVersionsResult) => void): Request<EC2.Types.DeleteLaunchTemplateVersionsResult, AWSError>;
  /**
   * Deletes the specified route from the specified local gateway route table.
   */
  deleteLocalGatewayRoute(params: EC2.Types.DeleteLocalGatewayRouteRequest, callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteResult, AWSError>;
  /**
   * Deletes the specified route from the specified local gateway route table.
   */
  deleteLocalGatewayRoute(callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteResult, AWSError>;
  /**
   *  Deletes a local gateway route table. 
   */
  deleteLocalGatewayRouteTable(params: EC2.Types.DeleteLocalGatewayRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteTableResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteTableResult, AWSError>;
  /**
   *  Deletes a local gateway route table. 
   */
  deleteLocalGatewayRouteTable(callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteTableResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteTableResult, AWSError>;
  /**
   *  Deletes a local gateway route table virtual interface group association. 
   */
  deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(params: EC2.Types.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult, AWSError>;
  /**
   *  Deletes a local gateway route table virtual interface group association. 
   */
  deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult, AWSError>;
  /**
   * Deletes the specified association between a VPC and local gateway route table.
   */
  deleteLocalGatewayRouteTableVpcAssociation(params: EC2.Types.DeleteLocalGatewayRouteTableVpcAssociationRequest, callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteTableVpcAssociationResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteTableVpcAssociationResult, AWSError>;
  /**
   * Deletes the specified association between a VPC and local gateway route table.
   */
  deleteLocalGatewayRouteTableVpcAssociation(callback?: (err: AWSError, data: EC2.Types.DeleteLocalGatewayRouteTableVpcAssociationResult) => void): Request<EC2.Types.DeleteLocalGatewayRouteTableVpcAssociationResult, AWSError>;
  /**
   * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.
   */
  deleteManagedPrefixList(params: EC2.Types.DeleteManagedPrefixListRequest, callback?: (err: AWSError, data: EC2.Types.DeleteManagedPrefixListResult) => void): Request<EC2.Types.DeleteManagedPrefixListResult, AWSError>;
  /**
   * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.
   */
  deleteManagedPrefixList(callback?: (err: AWSError, data: EC2.Types.DeleteManagedPrefixListResult) => void): Request<EC2.Types.DeleteManagedPrefixListResult, AWSError>;
  /**
   * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your route tables.
   */
  deleteNatGateway(params: EC2.Types.DeleteNatGatewayRequest, callback?: (err: AWSError, data: EC2.Types.DeleteNatGatewayResult) => void): Request<EC2.Types.DeleteNatGatewayResult, AWSError>;
  /**
   * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your route tables.
   */
  deleteNatGateway(callback?: (err: AWSError, data: EC2.Types.DeleteNatGatewayResult) => void): Request<EC2.Types.DeleteNatGatewayResult, AWSError>;
  /**
   * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete the default network ACL.
   */
  deleteNetworkAcl(params: EC2.Types.DeleteNetworkAclRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete the default network ACL.
   */
  deleteNetworkAcl(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
   */
  deleteNetworkAclEntry(params: EC2.Types.DeleteNetworkAclEntryRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
   */
  deleteNetworkAclEntry(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified Network Access Scope.
   */
  deleteNetworkInsightsAccessScope(params: EC2.Types.DeleteNetworkInsightsAccessScopeRequest, callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsAccessScopeResult) => void): Request<EC2.Types.DeleteNetworkInsightsAccessScopeResult, AWSError>;
  /**
   * Deletes the specified Network Access Scope.
   */
  deleteNetworkInsightsAccessScope(callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsAccessScopeResult) => void): Request<EC2.Types.DeleteNetworkInsightsAccessScopeResult, AWSError>;
  /**
   * Deletes the specified Network Access Scope analysis.
   */
  deleteNetworkInsightsAccessScopeAnalysis(params: EC2.Types.DeleteNetworkInsightsAccessScopeAnalysisRequest, callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsAccessScopeAnalysisResult) => void): Request<EC2.Types.DeleteNetworkInsightsAccessScopeAnalysisResult, AWSError>;
  /**
   * Deletes the specified Network Access Scope analysis.
   */
  deleteNetworkInsightsAccessScopeAnalysis(callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsAccessScopeAnalysisResult) => void): Request<EC2.Types.DeleteNetworkInsightsAccessScopeAnalysisResult, AWSError>;
  /**
   * Deletes the specified network insights analysis.
   */
  deleteNetworkInsightsAnalysis(params: EC2.Types.DeleteNetworkInsightsAnalysisRequest, callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsAnalysisResult) => void): Request<EC2.Types.DeleteNetworkInsightsAnalysisResult, AWSError>;
  /**
   * Deletes the specified network insights analysis.
   */
  deleteNetworkInsightsAnalysis(callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsAnalysisResult) => void): Request<EC2.Types.DeleteNetworkInsightsAnalysisResult, AWSError>;
  /**
   * Deletes the specified path.
   */
  deleteNetworkInsightsPath(params: EC2.Types.DeleteNetworkInsightsPathRequest, callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsPathResult) => void): Request<EC2.Types.DeleteNetworkInsightsPathResult, AWSError>;
  /**
   * Deletes the specified path.
   */
  deleteNetworkInsightsPath(callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInsightsPathResult) => void): Request<EC2.Types.DeleteNetworkInsightsPathResult, AWSError>;
  /**
   * Deletes the specified network interface. You must detach the network interface before you can delete it.
   */
  deleteNetworkInterface(params: EC2.Types.DeleteNetworkInterfaceRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified network interface. You must detach the network interface before you can delete it.
   */
  deleteNetworkInterface(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for which you're removing the permission has attached the network interface to an instance. However, you can force delete the permission, regardless of any attachment.
   */
  deleteNetworkInterfacePermission(params: EC2.Types.DeleteNetworkInterfacePermissionRequest, callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInterfacePermissionResult) => void): Request<EC2.Types.DeleteNetworkInterfacePermissionResult, AWSError>;
  /**
   * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for which you're removing the permission has attached the network interface to an instance. However, you can force delete the permission, regardless of any attachment.
   */
  deleteNetworkInterfacePermission(callback?: (err: AWSError, data: EC2.Types.DeleteNetworkInterfacePermissionResult) => void): Request<EC2.Types.DeleteNetworkInterfacePermissionResult, AWSError>;
  /**
   * Deletes the specified placement group. You must terminate all instances in the placement group before you can delete the placement group. For more information, see Placement groups in the Amazon EC2 User Guide.
   */
  deletePlacementGroup(params: EC2.Types.DeletePlacementGroupRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified placement group. You must terminate all instances in the placement group before you can delete the placement group. For more information, see Placement groups in the Amazon EC2 User Guide.
   */
  deletePlacementGroup(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only.
   */
  deletePublicIpv4Pool(params: EC2.Types.DeletePublicIpv4PoolRequest, callback?: (err: AWSError, data: EC2.Types.DeletePublicIpv4PoolResult) => void): Request<EC2.Types.DeletePublicIpv4PoolResult, AWSError>;
  /**
   * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only.
   */
  deletePublicIpv4Pool(callback?: (err: AWSError, data: EC2.Types.DeletePublicIpv4PoolResult) => void): Request<EC2.Types.DeletePublicIpv4PoolResult, AWSError>;
  /**
   * Deletes the queued purchases for the specified Reserved Instances.
   */
  deleteQueuedReservedInstances(params: EC2.Types.DeleteQueuedReservedInstancesRequest, callback?: (err: AWSError, data: EC2.Types.DeleteQueuedReservedInstancesResult) => void): Request<EC2.Types.DeleteQueuedReservedInstancesResult, AWSError>;
  /**
   * Deletes the queued purchases for the specified Reserved Instances.
   */
  deleteQueuedReservedInstances(callback?: (err: AWSError, data: EC2.Types.DeleteQueuedReservedInstancesResult) => void): Request<EC2.Types.DeleteQueuedReservedInstancesResult, AWSError>;
  /**
   * Deletes the specified route from the specified route table.
   */
  deleteRoute(params: EC2.Types.DeleteRouteRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified route from the specified route table.
   */
  deleteRoute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can't delete the main route table.
   */
  deleteRouteTable(params: EC2.Types.DeleteRouteTableRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can't delete the main route table.
   */
  deleteRouteTable(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes a security group. If you attempt to delete a security group that is associated with an instance, or is referenced by another security group, the operation fails with InvalidGroup.InUse in EC2-Classic or DependencyViolation in EC2-VPC.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  deleteSecurityGroup(params: EC2.Types.DeleteSecurityGroupRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes a security group. If you attempt to delete a security group that is associated with an instance, or is referenced by another security group, the operation fails with InvalidGroup.InUse in EC2-Classic or DependencyViolation in EC2-VPC.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  deleteSecurityGroup(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified snapshot. When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the volume. You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first de-register the AMI before you can delete the snapshot. For more information, see Delete an Amazon EBS snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  deleteSnapshot(params: EC2.Types.DeleteSnapshotRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified snapshot. When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the volume. You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first de-register the AMI before you can delete the snapshot. For more information, see Delete an Amazon EBS snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  deleteSnapshot(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the data feed for Spot Instances.
   */
  deleteSpotDatafeedSubscription(params: EC2.Types.DeleteSpotDatafeedSubscriptionRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the data feed for Spot Instances.
   */
  deleteSpotDatafeedSubscription(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.
   */
  deleteSubnet(params: EC2.Types.DeleteSubnetRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.
   */
  deleteSubnet(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes a subnet CIDR reservation.
   */
  deleteSubnetCidrReservation(params: EC2.Types.DeleteSubnetCidrReservationRequest, callback?: (err: AWSError, data: EC2.Types.DeleteSubnetCidrReservationResult) => void): Request<EC2.Types.DeleteSubnetCidrReservationResult, AWSError>;
  /**
   * Deletes a subnet CIDR reservation.
   */
  deleteSubnetCidrReservation(callback?: (err: AWSError, data: EC2.Types.DeleteSubnetCidrReservationResult) => void): Request<EC2.Types.DeleteSubnetCidrReservationResult, AWSError>;
  /**
   * Deletes the specified set of tags from the specified set of resources. To list the current tags, use DescribeTags. For more information about tags, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide.
   */
  deleteTags(params: EC2.Types.DeleteTagsRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified set of tags from the specified set of resources. To list the current tags, use DescribeTags. For more information about tags, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide.
   */
  deleteTags(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified Traffic Mirror filter. You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
   */
  deleteTrafficMirrorFilter(params: EC2.Types.DeleteTrafficMirrorFilterRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorFilterResult) => void): Request<EC2.Types.DeleteTrafficMirrorFilterResult, AWSError>;
  /**
   * Deletes the specified Traffic Mirror filter. You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
   */
  deleteTrafficMirrorFilter(callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorFilterResult) => void): Request<EC2.Types.DeleteTrafficMirrorFilterResult, AWSError>;
  /**
   * Deletes the specified Traffic Mirror rule.
   */
  deleteTrafficMirrorFilterRule(params: EC2.Types.DeleteTrafficMirrorFilterRuleRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorFilterRuleResult) => void): Request<EC2.Types.DeleteTrafficMirrorFilterRuleResult, AWSError>;
  /**
   * Deletes the specified Traffic Mirror rule.
   */
  deleteTrafficMirrorFilterRule(callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorFilterRuleResult) => void): Request<EC2.Types.DeleteTrafficMirrorFilterRuleResult, AWSError>;
  /**
   * Deletes the specified Traffic Mirror session.
   */
  deleteTrafficMirrorSession(params: EC2.Types.DeleteTrafficMirrorSessionRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorSessionResult) => void): Request<EC2.Types.DeleteTrafficMirrorSessionResult, AWSError>;
  /**
   * Deletes the specified Traffic Mirror session.
   */
  deleteTrafficMirrorSession(callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorSessionResult) => void): Request<EC2.Types.DeleteTrafficMirrorSessionResult, AWSError>;
  /**
   * Deletes the specified Traffic Mirror target. You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
   */
  deleteTrafficMirrorTarget(params: EC2.Types.DeleteTrafficMirrorTargetRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorTargetResult) => void): Request<EC2.Types.DeleteTrafficMirrorTargetResult, AWSError>;
  /**
   * Deletes the specified Traffic Mirror target. You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
   */
  deleteTrafficMirrorTarget(callback?: (err: AWSError, data: EC2.Types.DeleteTrafficMirrorTargetResult) => void): Request<EC2.Types.DeleteTrafficMirrorTargetResult, AWSError>;
  /**
   * Deletes the specified transit gateway.
   */
  deleteTransitGateway(params: EC2.Types.DeleteTransitGatewayRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayResult) => void): Request<EC2.Types.DeleteTransitGatewayResult, AWSError>;
  /**
   * Deletes the specified transit gateway.
   */
  deleteTransitGateway(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayResult) => void): Request<EC2.Types.DeleteTransitGatewayResult, AWSError>;
  /**
   * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
   */
  deleteTransitGatewayConnect(params: EC2.Types.DeleteTransitGatewayConnectRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayConnectResult) => void): Request<EC2.Types.DeleteTransitGatewayConnectResult, AWSError>;
  /**
   * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
   */
  deleteTransitGatewayConnect(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayConnectResult) => void): Request<EC2.Types.DeleteTransitGatewayConnectResult, AWSError>;
  /**
   * Deletes the specified Connect peer.
   */
  deleteTransitGatewayConnectPeer(params: EC2.Types.DeleteTransitGatewayConnectPeerRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayConnectPeerResult) => void): Request<EC2.Types.DeleteTransitGatewayConnectPeerResult, AWSError>;
  /**
   * Deletes the specified Connect peer.
   */
  deleteTransitGatewayConnectPeer(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayConnectPeerResult) => void): Request<EC2.Types.DeleteTransitGatewayConnectPeerResult, AWSError>;
  /**
   * Deletes the specified transit gateway multicast domain.
   */
  deleteTransitGatewayMulticastDomain(params: EC2.Types.DeleteTransitGatewayMulticastDomainRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.DeleteTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Deletes the specified transit gateway multicast domain.
   */
  deleteTransitGatewayMulticastDomain(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.DeleteTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Deletes a transit gateway peering attachment.
   */
  deleteTransitGatewayPeeringAttachment(params: EC2.Types.DeleteTransitGatewayPeeringAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.DeleteTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Deletes a transit gateway peering attachment.
   */
  deleteTransitGatewayPeeringAttachment(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.DeleteTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Deletes the specified transit gateway policy table.
   */
  deleteTransitGatewayPolicyTable(params: EC2.Types.DeleteTransitGatewayPolicyTableRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayPolicyTableResult) => void): Request<EC2.Types.DeleteTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Deletes the specified transit gateway policy table.
   */
  deleteTransitGatewayPolicyTable(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayPolicyTableResult) => void): Request<EC2.Types.DeleteTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
   */
  deleteTransitGatewayPrefixListReference(params: EC2.Types.DeleteTransitGatewayPrefixListReferenceRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayPrefixListReferenceResult) => void): Request<EC2.Types.DeleteTransitGatewayPrefixListReferenceResult, AWSError>;
  /**
   * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
   */
  deleteTransitGatewayPrefixListReference(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayPrefixListReferenceResult) => void): Request<EC2.Types.DeleteTransitGatewayPrefixListReferenceResult, AWSError>;
  /**
   * Deletes the specified route from the specified transit gateway route table.
   */
  deleteTransitGatewayRoute(params: EC2.Types.DeleteTransitGatewayRouteRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayRouteResult) => void): Request<EC2.Types.DeleteTransitGatewayRouteResult, AWSError>;
  /**
   * Deletes the specified route from the specified transit gateway route table.
   */
  deleteTransitGatewayRoute(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayRouteResult) => void): Request<EC2.Types.DeleteTransitGatewayRouteResult, AWSError>;
  /**
   * Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway route tables before you can delete it.
   */
  deleteTransitGatewayRouteTable(params: EC2.Types.DeleteTransitGatewayRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayRouteTableResult) => void): Request<EC2.Types.DeleteTransitGatewayRouteTableResult, AWSError>;
  /**
   * Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway route tables before you can delete it.
   */
  deleteTransitGatewayRouteTable(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayRouteTableResult) => void): Request<EC2.Types.DeleteTransitGatewayRouteTableResult, AWSError>;
  /**
   * Advertises to the transit gateway that a transit gateway route table is deleted.
   */
  deleteTransitGatewayRouteTableAnnouncement(params: EC2.Types.DeleteTransitGatewayRouteTableAnnouncementRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayRouteTableAnnouncementResult) => void): Request<EC2.Types.DeleteTransitGatewayRouteTableAnnouncementResult, AWSError>;
  /**
   * Advertises to the transit gateway that a transit gateway route table is deleted.
   */
  deleteTransitGatewayRouteTableAnnouncement(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayRouteTableAnnouncementResult) => void): Request<EC2.Types.DeleteTransitGatewayRouteTableAnnouncementResult, AWSError>;
  /**
   * Deletes the specified VPC attachment.
   */
  deleteTransitGatewayVpcAttachment(params: EC2.Types.DeleteTransitGatewayVpcAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.DeleteTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Deletes the specified VPC attachment.
   */
  deleteTransitGatewayVpcAttachment(callback?: (err: AWSError, data: EC2.Types.DeleteTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.DeleteTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Deletes the specified EBS volume. The volume must be in the available state (not attached to an instance). The volume can remain in the deleting state for several minutes. For more information, see Delete an Amazon EBS volume in the Amazon Elastic Compute Cloud User Guide.
   */
  deleteVolume(params: EC2.Types.DeleteVolumeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified EBS volume. The volume must be in the available state (not attached to an instance). The volume can remain in the deleting state for several minutes. For more information, see Delete an Amazon EBS volume in the Amazon Elastic Compute Cloud User Guide.
   */
  deleteVolume(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.
   */
  deleteVpc(params: EC2.Types.DeleteVpcRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.
   */
  deleteVpc(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes one or more VPC endpoint connection notifications.
   */
  deleteVpcEndpointConnectionNotifications(params: EC2.Types.DeleteVpcEndpointConnectionNotificationsRequest, callback?: (err: AWSError, data: EC2.Types.DeleteVpcEndpointConnectionNotificationsResult) => void): Request<EC2.Types.DeleteVpcEndpointConnectionNotificationsResult, AWSError>;
  /**
   * Deletes one or more VPC endpoint connection notifications.
   */
  deleteVpcEndpointConnectionNotifications(callback?: (err: AWSError, data: EC2.Types.DeleteVpcEndpointConnectionNotificationsResult) => void): Request<EC2.Types.DeleteVpcEndpointConnectionNotificationsResult, AWSError>;
  /**
   * Deletes one or more VPC endpoint service configurations in your account. Before you delete the endpoint service configuration, you must reject any Available or PendingAcceptance interface endpoint connections that are attached to the service.
   */
  deleteVpcEndpointServiceConfigurations(params: EC2.Types.DeleteVpcEndpointServiceConfigurationsRequest, callback?: (err: AWSError, data: EC2.Types.DeleteVpcEndpointServiceConfigurationsResult) => void): Request<EC2.Types.DeleteVpcEndpointServiceConfigurationsResult, AWSError>;
  /**
   * Deletes one or more VPC endpoint service configurations in your account. Before you delete the endpoint service configuration, you must reject any Available or PendingAcceptance interface endpoint connections that are attached to the service.
   */
  deleteVpcEndpointServiceConfigurations(callback?: (err: AWSError, data: EC2.Types.DeleteVpcEndpointServiceConfigurationsResult) => void): Request<EC2.Types.DeleteVpcEndpointServiceConfigurationsResult, AWSError>;
  /**
   * Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.    Gateway endpoint,   Gateway Load Balancer endpoint,   Interface endpoint   The following rules apply when you delete a VPC endpoint:   When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with the endpoint.   When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.  You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.   When you delete an interface endpoint, we delete the endpoint network interfaces.  
   */
  deleteVpcEndpoints(params: EC2.Types.DeleteVpcEndpointsRequest, callback?: (err: AWSError, data: EC2.Types.DeleteVpcEndpointsResult) => void): Request<EC2.Types.DeleteVpcEndpointsResult, AWSError>;
  /**
   * Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.    Gateway endpoint,   Gateway Load Balancer endpoint,   Interface endpoint   The following rules apply when you delete a VPC endpoint:   When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with the endpoint.   When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.  You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.   When you delete an interface endpoint, we delete the endpoint network interfaces.  
   */
  deleteVpcEndpoints(callback?: (err: AWSError, data: EC2.Types.DeleteVpcEndpointsResult) => void): Request<EC2.Types.DeleteVpcEndpointsResult, AWSError>;
  /**
   * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can delete the VPC peering connection if it's in the active state. The owner of the requester VPC can delete a VPC peering connection in the pending-acceptance state. You cannot delete a VPC peering connection that's in the failed state.
   */
  deleteVpcPeeringConnection(params: EC2.Types.DeleteVpcPeeringConnectionRequest, callback?: (err: AWSError, data: EC2.Types.DeleteVpcPeeringConnectionResult) => void): Request<EC2.Types.DeleteVpcPeeringConnectionResult, AWSError>;
  /**
   * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can delete the VPC peering connection if it's in the active state. The owner of the requester VPC can delete a VPC peering connection in the pending-acceptance state. You cannot delete a VPC peering connection that's in the failed state.
   */
  deleteVpcPeeringConnection(callback?: (err: AWSError, data: EC2.Types.DeleteVpcPeeringConnectionResult) => void): Request<EC2.Types.DeleteVpcPeeringConnectionResult, AWSError>;
  /**
   * Deletes the specified VPN connection. If you're deleting the VPC and its associated components, we recommend that you detach the virtual private gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN connection, you must reconfigure the customer gateway device using the new configuration information returned with the new VPN connection ID. For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
   */
  deleteVpnConnection(params: EC2.Types.DeleteVpnConnectionRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified VPN connection. If you're deleting the VPC and its associated components, we recommend that you detach the virtual private gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN connection, you must reconfigure the customer gateway device using the new configuration information returned with the new VPN connection ID. For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
   */
  deleteVpnConnection(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.
   */
  deleteVpnConnectionRoute(params: EC2.Types.DeleteVpnConnectionRouteRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.
   */
  deleteVpnConnectionRoute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC. Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN connection between your VPC and your network.
   */
  deleteVpnGateway(params: EC2.Types.DeleteVpnGatewayRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC. Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN connection between your VPC and your network.
   */
  deleteVpnGateway(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool. Before you can release an address range, you must stop advertising it using WithdrawByoipCidr and you must not have any IP addresses allocated from its address range.
   */
  deprovisionByoipCidr(params: EC2.Types.DeprovisionByoipCidrRequest, callback?: (err: AWSError, data: EC2.Types.DeprovisionByoipCidrResult) => void): Request<EC2.Types.DeprovisionByoipCidrResult, AWSError>;
  /**
   * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool. Before you can release an address range, you must stop advertising it using WithdrawByoipCidr and you must not have any IP addresses allocated from its address range.
   */
  deprovisionByoipCidr(callback?: (err: AWSError, data: EC2.Types.DeprovisionByoipCidrResult) => void): Request<EC2.Types.DeprovisionByoipCidrResult, AWSError>;
  /**
   * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool, the CIDR is recycled back into the source pool. For more information, see Deprovision pool CIDRs in the Amazon VPC IPAM User Guide.
   */
  deprovisionIpamPoolCidr(params: EC2.Types.DeprovisionIpamPoolCidrRequest, callback?: (err: AWSError, data: EC2.Types.DeprovisionIpamPoolCidrResult) => void): Request<EC2.Types.DeprovisionIpamPoolCidrResult, AWSError>;
  /**
   * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool, the CIDR is recycled back into the source pool. For more information, see Deprovision pool CIDRs in the Amazon VPC IPAM User Guide.
   */
  deprovisionIpamPoolCidr(callback?: (err: AWSError, data: EC2.Types.DeprovisionIpamPoolCidrResult) => void): Request<EC2.Types.DeprovisionIpamPoolCidrResult, AWSError>;
  /**
   * Deprovision a CIDR from a public IPv4 pool.
   */
  deprovisionPublicIpv4PoolCidr(params: EC2.Types.DeprovisionPublicIpv4PoolCidrRequest, callback?: (err: AWSError, data: EC2.Types.DeprovisionPublicIpv4PoolCidrResult) => void): Request<EC2.Types.DeprovisionPublicIpv4PoolCidrResult, AWSError>;
  /**
   * Deprovision a CIDR from a public IPv4 pool.
   */
  deprovisionPublicIpv4PoolCidr(callback?: (err: AWSError, data: EC2.Types.DeprovisionPublicIpv4PoolCidrResult) => void): Request<EC2.Types.DeprovisionPublicIpv4PoolCidrResult, AWSError>;
  /**
   * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances. If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for the specified retention period. For more information, see Recycle Bin in the Amazon Elastic Compute Cloud User Guide. When you deregister an AMI, it doesn't affect any instances that you've already launched from the AMI. You'll continue to incur usage costs for those instances until you terminate them. When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't affect the files that you uploaded to Amazon S3 when you created the AMI.
   */
  deregisterImage(params: EC2.Types.DeregisterImageRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances. If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for the specified retention period. For more information, see Recycle Bin in the Amazon Elastic Compute Cloud User Guide. When you deregister an AMI, it doesn't affect any instances that you've already launched from the AMI. You'll continue to incur usage costs for those instances until you terminate them. When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't affect the files that you uploaded to Amazon S3 when you created the AMI.
   */
  deregisterImage(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event notifications for resources in the Region.
   */
  deregisterInstanceEventNotificationAttributes(params: EC2.Types.DeregisterInstanceEventNotificationAttributesRequest, callback?: (err: AWSError, data: EC2.Types.DeregisterInstanceEventNotificationAttributesResult) => void): Request<EC2.Types.DeregisterInstanceEventNotificationAttributesResult, AWSError>;
  /**
   * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event notifications for resources in the Region.
   */
  deregisterInstanceEventNotificationAttributes(callback?: (err: AWSError, data: EC2.Types.DeregisterInstanceEventNotificationAttributesResult) => void): Request<EC2.Types.DeregisterInstanceEventNotificationAttributesResult, AWSError>;
  /**
   * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
   */
  deregisterTransitGatewayMulticastGroupMembers(params: EC2.Types.DeregisterTransitGatewayMulticastGroupMembersRequest, callback?: (err: AWSError, data: EC2.Types.DeregisterTransitGatewayMulticastGroupMembersResult) => void): Request<EC2.Types.DeregisterTransitGatewayMulticastGroupMembersResult, AWSError>;
  /**
   * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
   */
  deregisterTransitGatewayMulticastGroupMembers(callback?: (err: AWSError, data: EC2.Types.DeregisterTransitGatewayMulticastGroupMembersResult) => void): Request<EC2.Types.DeregisterTransitGatewayMulticastGroupMembersResult, AWSError>;
  /**
   * Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
   */
  deregisterTransitGatewayMulticastGroupSources(params: EC2.Types.DeregisterTransitGatewayMulticastGroupSourcesRequest, callback?: (err: AWSError, data: EC2.Types.DeregisterTransitGatewayMulticastGroupSourcesResult) => void): Request<EC2.Types.DeregisterTransitGatewayMulticastGroupSourcesResult, AWSError>;
  /**
   * Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
   */
  deregisterTransitGatewayMulticastGroupSources(callback?: (err: AWSError, data: EC2.Types.DeregisterTransitGatewayMulticastGroupSourcesResult) => void): Request<EC2.Types.DeregisterTransitGatewayMulticastGroupSourcesResult, AWSError>;
  /**
   * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:    supported-platforms: Indicates whether your account can launch instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.    default-vpc: The ID of the default VPC for your account, or none.    max-instances: This attribute is no longer supported. The returned value does not reflect your actual vCPU limit for running On-Demand Instances. For more information, see On-Demand Instance Limits in the Amazon Elastic Compute Cloud User Guide.    vpc-max-security-groups-per-interface: The maximum number of security groups that you can assign to a network interface.    max-elastic-ips: The maximum number of Elastic IP addresses that you can allocate for use with EC2-Classic.     vpc-max-elastic-ips: The maximum number of Elastic IP addresses that you can allocate for use with EC2-VPC.    We are retiring EC2-Classic on August 15, 2022. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon EC2 User Guide. 
   */
  describeAccountAttributes(params: EC2.Types.DescribeAccountAttributesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeAccountAttributesResult) => void): Request<EC2.Types.DescribeAccountAttributesResult, AWSError>;
  /**
   * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:    supported-platforms: Indicates whether your account can launch instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.    default-vpc: The ID of the default VPC for your account, or none.    max-instances: This attribute is no longer supported. The returned value does not reflect your actual vCPU limit for running On-Demand Instances. For more information, see On-Demand Instance Limits in the Amazon Elastic Compute Cloud User Guide.    vpc-max-security-groups-per-interface: The maximum number of security groups that you can assign to a network interface.    max-elastic-ips: The maximum number of Elastic IP addresses that you can allocate for use with EC2-Classic.     vpc-max-elastic-ips: The maximum number of Elastic IP addresses that you can allocate for use with EC2-VPC.    We are retiring EC2-Classic on August 15, 2022. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon EC2 User Guide. 
   */
  describeAccountAttributes(callback?: (err: AWSError, data: EC2.Types.DescribeAccountAttributesResult) => void): Request<EC2.Types.DescribeAccountAttributesResult, AWSError>;
  /**
   * Describes an Elastic IP address transfer. For more information, see Transfer Elastic IP addresses in the Amazon Virtual Private Cloud User Guide.
   */
  describeAddressTransfers(params: EC2.Types.DescribeAddressTransfersRequest, callback?: (err: AWSError, data: EC2.Types.DescribeAddressTransfersResult) => void): Request<EC2.Types.DescribeAddressTransfersResult, AWSError>;
  /**
   * Describes an Elastic IP address transfer. For more information, see Transfer Elastic IP addresses in the Amazon Virtual Private Cloud User Guide.
   */
  describeAddressTransfers(callback?: (err: AWSError, data: EC2.Types.DescribeAddressTransfersResult) => void): Request<EC2.Types.DescribeAddressTransfersResult, AWSError>;
  /**
   * Describes the specified Elastic IP addresses or all of your Elastic IP addresses. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeAddresses(params: EC2.Types.DescribeAddressesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeAddressesResult) => void): Request<EC2.Types.DescribeAddressesResult, AWSError>;
  /**
   * Describes the specified Elastic IP addresses or all of your Elastic IP addresses. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeAddresses(callback?: (err: AWSError, data: EC2.Types.DescribeAddressesResult) => void): Request<EC2.Types.DescribeAddressesResult, AWSError>;
  /**
   * Describes the attributes of the specified Elastic IP addresses. For requirements, see Using reverse DNS for email applications.
   */
  describeAddressesAttribute(params: EC2.Types.DescribeAddressesAttributeRequest, callback?: (err: AWSError, data: EC2.Types.DescribeAddressesAttributeResult) => void): Request<EC2.Types.DescribeAddressesAttributeResult, AWSError>;
  /**
   * Describes the attributes of the specified Elastic IP addresses. For requirements, see Using reverse DNS for email applications.
   */
  describeAddressesAttribute(callback?: (err: AWSError, data: EC2.Types.DescribeAddressesAttributeResult) => void): Request<EC2.Types.DescribeAddressesAttributeResult, AWSError>;
  /**
   * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character IDs). This request only returns information about resource types that support longer IDs. The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
   */
  describeAggregateIdFormat(params: EC2.Types.DescribeAggregateIdFormatRequest, callback?: (err: AWSError, data: EC2.Types.DescribeAggregateIdFormatResult) => void): Request<EC2.Types.DescribeAggregateIdFormatResult, AWSError>;
  /**
   * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character IDs). This request only returns information about resource types that support longer IDs. The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
   */
  describeAggregateIdFormat(callback?: (err: AWSError, data: EC2.Types.DescribeAggregateIdFormatResult) => void): Request<EC2.Types.DescribeAggregateIdFormatResult, AWSError>;
  /**
   * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an event impacting a zone, you can use this request to view the state and any provided messages for that zone. For more information about Availability Zones, Local Zones, and Wavelength Zones, see Regions and zones in the Amazon Elastic Compute Cloud User Guide.
   */
  describeAvailabilityZones(params: EC2.Types.DescribeAvailabilityZonesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeAvailabilityZonesResult) => void): Request<EC2.Types.DescribeAvailabilityZonesResult, AWSError>;
  /**
   * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an event impacting a zone, you can use this request to view the state and any provided messages for that zone. For more information about Availability Zones, Local Zones, and Wavelength Zones, see Regions and zones in the Amazon Elastic Compute Cloud User Guide.
   */
  describeAvailabilityZones(callback?: (err: AWSError, data: EC2.Types.DescribeAvailabilityZonesResult) => void): Request<EC2.Types.DescribeAvailabilityZonesResult, AWSError>;
  /**
   * Describes the specified bundle tasks or all of your bundle tasks.  Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use RegisterImage with the Amazon S3 bucket name and image manifest name you provided to the bundle task. 
   */
  describeBundleTasks(params: EC2.Types.DescribeBundleTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeBundleTasksResult) => void): Request<EC2.Types.DescribeBundleTasksResult, AWSError>;
  /**
   * Describes the specified bundle tasks or all of your bundle tasks.  Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use RegisterImage with the Amazon S3 bucket name and image manifest name you provided to the bundle task. 
   */
  describeBundleTasks(callback?: (err: AWSError, data: EC2.Types.DescribeBundleTasksResult) => void): Request<EC2.Types.DescribeBundleTasksResult, AWSError>;
  /**
   * Describes the IP address ranges that were specified in calls to ProvisionByoipCidr. To describe the address pools that were created when you provisioned the address ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
   */
  describeByoipCidrs(params: EC2.Types.DescribeByoipCidrsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeByoipCidrsResult) => void): Request<EC2.Types.DescribeByoipCidrsResult, AWSError>;
  /**
   * Describes the IP address ranges that were specified in calls to ProvisionByoipCidr. To describe the address pools that were created when you provisioned the address ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
   */
  describeByoipCidrs(callback?: (err: AWSError, data: EC2.Types.DescribeByoipCidrsResult) => void): Request<EC2.Types.DescribeByoipCidrsResult, AWSError>;
  /**
   * Describes one or more Capacity Reservation Fleets.
   */
  describeCapacityReservationFleets(params: EC2.Types.DescribeCapacityReservationFleetsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeCapacityReservationFleetsResult) => void): Request<EC2.Types.DescribeCapacityReservationFleetsResult, AWSError>;
  /**
   * Describes one or more Capacity Reservation Fleets.
   */
  describeCapacityReservationFleets(callback?: (err: AWSError, data: EC2.Types.DescribeCapacityReservationFleetsResult) => void): Request<EC2.Types.DescribeCapacityReservationFleetsResult, AWSError>;
  /**
   * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the Amazon Web Services Region that you're currently using.
   */
  describeCapacityReservations(params: EC2.Types.DescribeCapacityReservationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeCapacityReservationsResult) => void): Request<EC2.Types.DescribeCapacityReservationsResult, AWSError>;
  /**
   * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the Amazon Web Services Region that you're currently using.
   */
  describeCapacityReservations(callback?: (err: AWSError, data: EC2.Types.DescribeCapacityReservationsResult) => void): Request<EC2.Types.DescribeCapacityReservationsResult, AWSError>;
  /**
   * Describes one or more of your carrier gateways.
   */
  describeCarrierGateways(params: EC2.Types.DescribeCarrierGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeCarrierGatewaysResult) => void): Request<EC2.Types.DescribeCarrierGatewaysResult, AWSError>;
  /**
   * Describes one or more of your carrier gateways.
   */
  describeCarrierGateways(callback?: (err: AWSError, data: EC2.Types.DescribeCarrierGatewaysResult) => void): Request<EC2.Types.DescribeCarrierGatewaysResult, AWSError>;
  /**
   * Describes one or more of your linked EC2-Classic instances. This request only returns information about EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information about other instances.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeClassicLinkInstances(params: EC2.Types.DescribeClassicLinkInstancesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeClassicLinkInstancesResult) => void): Request<EC2.Types.DescribeClassicLinkInstancesResult, AWSError>;
  /**
   * Describes one or more of your linked EC2-Classic instances. This request only returns information about EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information about other instances.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeClassicLinkInstances(callback?: (err: AWSError, data: EC2.Types.DescribeClassicLinkInstancesResult) => void): Request<EC2.Types.DescribeClassicLinkInstancesResult, AWSError>;
  /**
   * Describes the authorization rules for a specified Client VPN endpoint.
   */
  describeClientVpnAuthorizationRules(params: EC2.Types.DescribeClientVpnAuthorizationRulesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnAuthorizationRulesResult) => void): Request<EC2.Types.DescribeClientVpnAuthorizationRulesResult, AWSError>;
  /**
   * Describes the authorization rules for a specified Client VPN endpoint.
   */
  describeClientVpnAuthorizationRules(callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnAuthorizationRulesResult) => void): Request<EC2.Types.DescribeClientVpnAuthorizationRulesResult, AWSError>;
  /**
   * Describes active client connections and connections that have been terminated within the last 60 minutes for the specified Client VPN endpoint.
   */
  describeClientVpnConnections(params: EC2.Types.DescribeClientVpnConnectionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnConnectionsResult) => void): Request<EC2.Types.DescribeClientVpnConnectionsResult, AWSError>;
  /**
   * Describes active client connections and connections that have been terminated within the last 60 minutes for the specified Client VPN endpoint.
   */
  describeClientVpnConnections(callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnConnectionsResult) => void): Request<EC2.Types.DescribeClientVpnConnectionsResult, AWSError>;
  /**
   * Describes one or more Client VPN endpoints in the account.
   */
  describeClientVpnEndpoints(params: EC2.Types.DescribeClientVpnEndpointsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnEndpointsResult) => void): Request<EC2.Types.DescribeClientVpnEndpointsResult, AWSError>;
  /**
   * Describes one or more Client VPN endpoints in the account.
   */
  describeClientVpnEndpoints(callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnEndpointsResult) => void): Request<EC2.Types.DescribeClientVpnEndpointsResult, AWSError>;
  /**
   * Describes the routes for the specified Client VPN endpoint.
   */
  describeClientVpnRoutes(params: EC2.Types.DescribeClientVpnRoutesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnRoutesResult) => void): Request<EC2.Types.DescribeClientVpnRoutesResult, AWSError>;
  /**
   * Describes the routes for the specified Client VPN endpoint.
   */
  describeClientVpnRoutes(callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnRoutesResult) => void): Request<EC2.Types.DescribeClientVpnRoutesResult, AWSError>;
  /**
   * Describes the target networks associated with the specified Client VPN endpoint.
   */
  describeClientVpnTargetNetworks(params: EC2.Types.DescribeClientVpnTargetNetworksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnTargetNetworksResult) => void): Request<EC2.Types.DescribeClientVpnTargetNetworksResult, AWSError>;
  /**
   * Describes the target networks associated with the specified Client VPN endpoint.
   */
  describeClientVpnTargetNetworks(callback?: (err: AWSError, data: EC2.Types.DescribeClientVpnTargetNetworksResult) => void): Request<EC2.Types.DescribeClientVpnTargetNetworksResult, AWSError>;
  /**
   * Describes the specified customer-owned address pools or all of your customer-owned address pools.
   */
  describeCoipPools(params: EC2.Types.DescribeCoipPoolsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeCoipPoolsResult) => void): Request<EC2.Types.DescribeCoipPoolsResult, AWSError>;
  /**
   * Describes the specified customer-owned address pools or all of your customer-owned address pools.
   */
  describeCoipPools(callback?: (err: AWSError, data: EC2.Types.DescribeCoipPoolsResult) => void): Request<EC2.Types.DescribeCoipPoolsResult, AWSError>;
  /**
   * Describes the specified conversion tasks or all your conversion tasks. For more information, see the VM Import/Export User Guide. For information about the import manifest referenced by this API action, see VM Import Manifest.
   */
  describeConversionTasks(params: EC2.Types.DescribeConversionTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Describes the specified conversion tasks or all your conversion tasks. For more information, see the VM Import/Export User Guide. For information about the import manifest referenced by this API action, see VM Import Manifest.
   */
  describeConversionTasks(callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Describes one or more of your VPN customer gateways. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  describeCustomerGateways(params: EC2.Types.DescribeCustomerGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeCustomerGatewaysResult) => void): Request<EC2.Types.DescribeCustomerGatewaysResult, AWSError>;
  /**
   * Describes one or more of your VPN customer gateways. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  describeCustomerGateways(callback?: (err: AWSError, data: EC2.Types.DescribeCustomerGatewaysResult) => void): Request<EC2.Types.DescribeCustomerGatewaysResult, AWSError>;
  /**
   * Describes one or more of your DHCP options sets. For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide.
   */
  describeDhcpOptions(params: EC2.Types.DescribeDhcpOptionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeDhcpOptionsResult) => void): Request<EC2.Types.DescribeDhcpOptionsResult, AWSError>;
  /**
   * Describes one or more of your DHCP options sets. For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide.
   */
  describeDhcpOptions(callback?: (err: AWSError, data: EC2.Types.DescribeDhcpOptionsResult) => void): Request<EC2.Types.DescribeDhcpOptionsResult, AWSError>;
  /**
   * Describes one or more of your egress-only internet gateways.
   */
  describeEgressOnlyInternetGateways(params: EC2.Types.DescribeEgressOnlyInternetGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeEgressOnlyInternetGatewaysResult) => void): Request<EC2.Types.DescribeEgressOnlyInternetGatewaysResult, AWSError>;
  /**
   * Describes one or more of your egress-only internet gateways.
   */
  describeEgressOnlyInternetGateways(callback?: (err: AWSError, data: EC2.Types.DescribeEgressOnlyInternetGatewaysResult) => void): Request<EC2.Types.DescribeEgressOnlyInternetGatewaysResult, AWSError>;
  /**
   * Describes the Elastic Graphics accelerator associated with your instances. For more information about Elastic Graphics, see Amazon Elastic Graphics.
   */
  describeElasticGpus(params: EC2.Types.DescribeElasticGpusRequest, callback?: (err: AWSError, data: EC2.Types.DescribeElasticGpusResult) => void): Request<EC2.Types.DescribeElasticGpusResult, AWSError>;
  /**
   * Describes the Elastic Graphics accelerator associated with your instances. For more information about Elastic Graphics, see Amazon Elastic Graphics.
   */
  describeElasticGpus(callback?: (err: AWSError, data: EC2.Types.DescribeElasticGpusResult) => void): Request<EC2.Types.DescribeElasticGpusResult, AWSError>;
  /**
   * Describes the specified export image tasks or all of your export image tasks.
   */
  describeExportImageTasks(params: EC2.Types.DescribeExportImageTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeExportImageTasksResult) => void): Request<EC2.Types.DescribeExportImageTasksResult, AWSError>;
  /**
   * Describes the specified export image tasks or all of your export image tasks.
   */
  describeExportImageTasks(callback?: (err: AWSError, data: EC2.Types.DescribeExportImageTasksResult) => void): Request<EC2.Types.DescribeExportImageTasksResult, AWSError>;
  /**
   * Describes the specified export instance tasks or all of your export instance tasks.
   */
  describeExportTasks(params: EC2.Types.DescribeExportTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeExportTasksResult) => void): Request<EC2.Types.DescribeExportTasksResult, AWSError>;
  /**
   * Describes the specified export instance tasks or all of your export instance tasks.
   */
  describeExportTasks(callback?: (err: AWSError, data: EC2.Types.DescribeExportTasksResult) => void): Request<EC2.Types.DescribeExportTasksResult, AWSError>;
  /**
   * Describe details for Windows AMIs that are configured for faster launching.
   */
  describeFastLaunchImages(params: EC2.Types.DescribeFastLaunchImagesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFastLaunchImagesResult) => void): Request<EC2.Types.DescribeFastLaunchImagesResult, AWSError>;
  /**
   * Describe details for Windows AMIs that are configured for faster launching.
   */
  describeFastLaunchImages(callback?: (err: AWSError, data: EC2.Types.DescribeFastLaunchImagesResult) => void): Request<EC2.Types.DescribeFastLaunchImagesResult, AWSError>;
  /**
   * Describes the state of fast snapshot restores for your snapshots.
   */
  describeFastSnapshotRestores(params: EC2.Types.DescribeFastSnapshotRestoresRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFastSnapshotRestoresResult) => void): Request<EC2.Types.DescribeFastSnapshotRestoresResult, AWSError>;
  /**
   * Describes the state of fast snapshot restores for your snapshots.
   */
  describeFastSnapshotRestores(callback?: (err: AWSError, data: EC2.Types.DescribeFastSnapshotRestoresResult) => void): Request<EC2.Types.DescribeFastSnapshotRestoresResult, AWSError>;
  /**
   * Describes the events for the specified EC2 Fleet during the specified time. EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours. For more information, see Monitor fleet events using Amazon EventBridge in the Amazon EC2 User Guide.
   */
  describeFleetHistory(params: EC2.Types.DescribeFleetHistoryRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFleetHistoryResult) => void): Request<EC2.Types.DescribeFleetHistoryResult, AWSError>;
  /**
   * Describes the events for the specified EC2 Fleet during the specified time. EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours. For more information, see Monitor fleet events using Amazon EventBridge in the Amazon EC2 User Guide.
   */
  describeFleetHistory(callback?: (err: AWSError, data: EC2.Types.DescribeFleetHistoryResult) => void): Request<EC2.Types.DescribeFleetHistoryResult, AWSError>;
  /**
   * Describes the running instances for the specified EC2 Fleet. For more information, see Monitor your EC2 Fleet in the Amazon EC2 User Guide.
   */
  describeFleetInstances(params: EC2.Types.DescribeFleetInstancesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFleetInstancesResult) => void): Request<EC2.Types.DescribeFleetInstancesResult, AWSError>;
  /**
   * Describes the running instances for the specified EC2 Fleet. For more information, see Monitor your EC2 Fleet in the Amazon EC2 User Guide.
   */
  describeFleetInstances(callback?: (err: AWSError, data: EC2.Types.DescribeFleetInstancesResult) => void): Request<EC2.Types.DescribeFleetInstancesResult, AWSError>;
  /**
   * Describes the specified EC2 Fleets or all of your EC2 Fleets. For more information, see Monitor your EC2 Fleet in the Amazon EC2 User Guide.
   */
  describeFleets(params: EC2.Types.DescribeFleetsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFleetsResult) => void): Request<EC2.Types.DescribeFleetsResult, AWSError>;
  /**
   * Describes the specified EC2 Fleets or all of your EC2 Fleets. For more information, see Monitor your EC2 Fleet in the Amazon EC2 User Guide.
   */
  describeFleets(callback?: (err: AWSError, data: EC2.Types.DescribeFleetsResult) => void): Request<EC2.Types.DescribeFleetsResult, AWSError>;
  /**
   * Describes one or more flow logs. To view the published flow log records, you must view the log destination. For example, the CloudWatch Logs log group, the Amazon S3 bucket, or the Kinesis Data Firehose delivery stream.
   */
  describeFlowLogs(params: EC2.Types.DescribeFlowLogsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFlowLogsResult) => void): Request<EC2.Types.DescribeFlowLogsResult, AWSError>;
  /**
   * Describes one or more flow logs. To view the published flow log records, you must view the log destination. For example, the CloudWatch Logs log group, the Amazon S3 bucket, or the Kinesis Data Firehose delivery stream.
   */
  describeFlowLogs(callback?: (err: AWSError, data: EC2.Types.DescribeFlowLogsResult) => void): Request<EC2.Types.DescribeFlowLogsResult, AWSError>;
  /**
   * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
   */
  describeFpgaImageAttribute(params: EC2.Types.DescribeFpgaImageAttributeRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFpgaImageAttributeResult) => void): Request<EC2.Types.DescribeFpgaImageAttributeResult, AWSError>;
  /**
   * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
   */
  describeFpgaImageAttribute(callback?: (err: AWSError, data: EC2.Types.DescribeFpgaImageAttributeResult) => void): Request<EC2.Types.DescribeFpgaImageAttributeResult, AWSError>;
  /**
   * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which you have load permissions.
   */
  describeFpgaImages(params: EC2.Types.DescribeFpgaImagesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeFpgaImagesResult) => void): Request<EC2.Types.DescribeFpgaImagesResult, AWSError>;
  /**
   * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which you have load permissions.
   */
  describeFpgaImages(callback?: (err: AWSError, data: EC2.Types.DescribeFpgaImagesResult) => void): Request<EC2.Types.DescribeFpgaImagesResult, AWSError>;
  /**
   * Describes the Dedicated Host reservations that are available to purchase. The results describe all of the Dedicated Host reservation offerings, including offerings that might not match the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more information about supported instance types, see Dedicated Hosts in the Amazon EC2 User Guide. 
   */
  describeHostReservationOfferings(params: EC2.Types.DescribeHostReservationOfferingsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeHostReservationOfferingsResult) => void): Request<EC2.Types.DescribeHostReservationOfferingsResult, AWSError>;
  /**
   * Describes the Dedicated Host reservations that are available to purchase. The results describe all of the Dedicated Host reservation offerings, including offerings that might not match the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more information about supported instance types, see Dedicated Hosts in the Amazon EC2 User Guide. 
   */
  describeHostReservationOfferings(callback?: (err: AWSError, data: EC2.Types.DescribeHostReservationOfferingsResult) => void): Request<EC2.Types.DescribeHostReservationOfferingsResult, AWSError>;
  /**
   * Describes reservations that are associated with Dedicated Hosts in your account.
   */
  describeHostReservations(params: EC2.Types.DescribeHostReservationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeHostReservationsResult) => void): Request<EC2.Types.DescribeHostReservationsResult, AWSError>;
  /**
   * Describes reservations that are associated with Dedicated Hosts in your account.
   */
  describeHostReservations(callback?: (err: AWSError, data: EC2.Types.DescribeHostReservationsResult) => void): Request<EC2.Types.DescribeHostReservationsResult, AWSError>;
  /**
   * Describes the specified Dedicated Hosts or all your Dedicated Hosts. The results describe only the Dedicated Hosts in the Region you're currently using. All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state released.
   */
  describeHosts(params: EC2.Types.DescribeHostsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeHostsResult) => void): Request<EC2.Types.DescribeHostsResult, AWSError>;
  /**
   * Describes the specified Dedicated Hosts or all your Dedicated Hosts. The results describe only the Dedicated Hosts in the Region you're currently using. All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state released.
   */
  describeHosts(callback?: (err: AWSError, data: EC2.Types.DescribeHostsResult) => void): Request<EC2.Types.DescribeHostsResult, AWSError>;
  /**
   * Describes your IAM instance profile associations.
   */
  describeIamInstanceProfileAssociations(params: EC2.Types.DescribeIamInstanceProfileAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeIamInstanceProfileAssociationsResult) => void): Request<EC2.Types.DescribeIamInstanceProfileAssociationsResult, AWSError>;
  /**
   * Describes your IAM instance profile associations.
   */
  describeIamInstanceProfileAssociations(callback?: (err: AWSError, data: EC2.Types.DescribeIamInstanceProfileAssociationsResult) => void): Request<EC2.Types.DescribeIamInstanceProfileAssociationsResult, AWSError>;
  /**
   * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.  These settings apply to the IAM user who makes the request; they do not apply to the entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user, unless they explicitly override the settings by running the ModifyIdFormat command. Resources created with longer IDs are visible to all IAM users, regardless of these settings and provided that they have permission to use the relevant Describe command for the resource type.
   */
  describeIdFormat(params: EC2.Types.DescribeIdFormatRequest, callback?: (err: AWSError, data: EC2.Types.DescribeIdFormatResult) => void): Request<EC2.Types.DescribeIdFormatResult, AWSError>;
  /**
   * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.  These settings apply to the IAM user who makes the request; they do not apply to the entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user, unless they explicitly override the settings by running the ModifyIdFormat command. Resources created with longer IDs are visible to all IAM users, regardless of these settings and provided that they have permission to use the relevant Describe command for the resource type.
   */
  describeIdFormat(callback?: (err: AWSError, data: EC2.Types.DescribeIdFormatResult) => void): Request<EC2.Types.DescribeIdFormatResult, AWSError>;
  /**
   * Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example, you can view the resource types that are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. For more information, see Resource IDs in the Amazon Elastic Compute Cloud User Guide.  The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.  These settings apply to the principal specified in the request. They do not apply to the principal that makes the request.
   */
  describeIdentityIdFormat(params: EC2.Types.DescribeIdentityIdFormatRequest, callback?: (err: AWSError, data: EC2.Types.DescribeIdentityIdFormatResult) => void): Request<EC2.Types.DescribeIdentityIdFormatResult, AWSError>;
  /**
   * Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example, you can view the resource types that are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. For more information, see Resource IDs in the Amazon Elastic Compute Cloud User Guide.  The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.  These settings apply to the principal specified in the request. They do not apply to the principal that makes the request.
   */
  describeIdentityIdFormat(callback?: (err: AWSError, data: EC2.Types.DescribeIdentityIdFormatResult) => void): Request<EC2.Types.DescribeIdentityIdFormatResult, AWSError>;
  /**
   * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
   */
  describeImageAttribute(params: EC2.Types.DescribeImageAttributeRequest, callback?: (err: AWSError, data: EC2.Types.ImageAttribute) => void): Request<EC2.Types.ImageAttribute, AWSError>;
  /**
   * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
   */
  describeImageAttribute(callback?: (err: AWSError, data: EC2.Types.ImageAttribute) => void): Request<EC2.Types.ImageAttribute, AWSError>;
  /**
   * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you. The images available to you include public images, private images that you own, and private images owned by other Amazon Web Services accounts for which you have explicit launch permissions. Recently deregistered images appear in the returned results for a short interval and then return empty results. After all instances that reference a deregistered AMI are terminated, specifying the ID of the image will eventually return an error indicating that the AMI ID cannot be found.
   */
  describeImages(params: EC2.Types.DescribeImagesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeImagesResult) => void): Request<EC2.Types.DescribeImagesResult, AWSError>;
  /**
   * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you. The images available to you include public images, private images that you own, and private images owned by other Amazon Web Services accounts for which you have explicit launch permissions. Recently deregistered images appear in the returned results for a short interval and then return empty results. After all instances that reference a deregistered AMI are terminated, specifying the ID of the image will eventually return an error indicating that the AMI ID cannot be found.
   */
  describeImages(callback?: (err: AWSError, data: EC2.Types.DescribeImagesResult) => void): Request<EC2.Types.DescribeImagesResult, AWSError>;
  /**
   * Displays details about an import virtual machine or import snapshot tasks that are already created.
   */
  describeImportImageTasks(params: EC2.Types.DescribeImportImageTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeImportImageTasksResult) => void): Request<EC2.Types.DescribeImportImageTasksResult, AWSError>;
  /**
   * Displays details about an import virtual machine or import snapshot tasks that are already created.
   */
  describeImportImageTasks(callback?: (err: AWSError, data: EC2.Types.DescribeImportImageTasksResult) => void): Request<EC2.Types.DescribeImportImageTasksResult, AWSError>;
  /**
   * Describes your import snapshot tasks.
   */
  describeImportSnapshotTasks(params: EC2.Types.DescribeImportSnapshotTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeImportSnapshotTasksResult) => void): Request<EC2.Types.DescribeImportSnapshotTasksResult, AWSError>;
  /**
   * Describes your import snapshot tasks.
   */
  describeImportSnapshotTasks(callback?: (err: AWSError, data: EC2.Types.DescribeImportSnapshotTasksResult) => void): Request<EC2.Types.DescribeImportSnapshotTasksResult, AWSError>;
  /**
   * Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: instanceType | kernel | ramdisk | userData | disableApiTermination | instanceInitiatedShutdownBehavior | rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck | groupSet | ebsOptimized | sriovNetSupport 
   */
  describeInstanceAttribute(params: EC2.Types.DescribeInstanceAttributeRequest, callback?: (err: AWSError, data: EC2.Types.InstanceAttribute) => void): Request<EC2.Types.InstanceAttribute, AWSError>;
  /**
   * Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: instanceType | kernel | ramdisk | userData | disableApiTermination | instanceInitiatedShutdownBehavior | rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck | groupSet | ebsOptimized | sriovNetSupport 
   */
  describeInstanceAttribute(callback?: (err: AWSError, data: EC2.Types.InstanceAttribute) => void): Request<EC2.Types.InstanceAttribute, AWSError>;
  /**
   * Describes the credit option for CPU usage of the specified burstable performance instances. The credit options are standard and unlimited. If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the unlimited credit option, as well as instances that were previously configured as T2, T3, and T3a with the unlimited credit option. For example, if you resize a T2 instance, while it is configured as unlimited, to an M4 instance, Amazon EC2 returns the M4 instance. If you specify one or more instance IDs, Amazon EC2 returns the credit option (standard or unlimited) of those instances. If you specify an instance ID that is not valid, such as an instance that is not a burstable performance instance, an error is returned. Recently terminated instances might appear in the returned results. This interval is usually less than one hour. If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected zone, the call works normally. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  describeInstanceCreditSpecifications(params: EC2.Types.DescribeInstanceCreditSpecificationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceCreditSpecificationsResult) => void): Request<EC2.Types.DescribeInstanceCreditSpecificationsResult, AWSError>;
  /**
   * Describes the credit option for CPU usage of the specified burstable performance instances. The credit options are standard and unlimited. If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the unlimited credit option, as well as instances that were previously configured as T2, T3, and T3a with the unlimited credit option. For example, if you resize a T2 instance, while it is configured as unlimited, to an M4 instance, Amazon EC2 returns the M4 instance. If you specify one or more instance IDs, Amazon EC2 returns the credit option (standard or unlimited) of those instances. If you specify an instance ID that is not valid, such as an instance that is not a burstable performance instance, an error is returned. Recently terminated instances might appear in the returned results. This interval is usually less than one hour. If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected zone, the call works normally. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  describeInstanceCreditSpecifications(callback?: (err: AWSError, data: EC2.Types.DescribeInstanceCreditSpecificationsResult) => void): Request<EC2.Types.DescribeInstanceCreditSpecificationsResult, AWSError>;
  /**
   * Describes the tag keys that are registered to appear in scheduled event notifications for resources in the current Region.
   */
  describeInstanceEventNotificationAttributes(params: EC2.Types.DescribeInstanceEventNotificationAttributesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceEventNotificationAttributesResult) => void): Request<EC2.Types.DescribeInstanceEventNotificationAttributesResult, AWSError>;
  /**
   * Describes the tag keys that are registered to appear in scheduled event notifications for resources in the current Region.
   */
  describeInstanceEventNotificationAttributes(callback?: (err: AWSError, data: EC2.Types.DescribeInstanceEventNotificationAttributesResult) => void): Request<EC2.Types.DescribeInstanceEventNotificationAttributesResult, AWSError>;
  /**
   * Describes the specified event windows or all event windows. If you specify event window IDs, the output includes information for only the specified event windows. If you specify filters, the output includes information for only those event windows that meet the filter criteria. If you do not specify event windows IDs or filters, the output includes information for all event windows, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully.  For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  describeInstanceEventWindows(params: EC2.Types.DescribeInstanceEventWindowsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceEventWindowsResult) => void): Request<EC2.Types.DescribeInstanceEventWindowsResult, AWSError>;
  /**
   * Describes the specified event windows or all event windows. If you specify event window IDs, the output includes information for only the specified event windows. If you specify filters, the output includes information for only those event windows that meet the filter criteria. If you do not specify event windows IDs or filters, the output includes information for all event windows, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully.  For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  describeInstanceEventWindows(callback?: (err: AWSError, data: EC2.Types.DescribeInstanceEventWindowsResult) => void): Request<EC2.Types.DescribeInstanceEventWindowsResult, AWSError>;
  /**
   * Describes the status of the specified instances or all of your instances. By default, only running instances are described, unless you specifically indicate to return the status of all instances. Instance status includes the following components:    Status checks - Amazon EC2 performs status checks on running EC2 instances to identify hardware and software issues. For more information, see Status checks for your instances and Troubleshoot instances with failed status checks in the Amazon EC2 User Guide.    Scheduled events - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances related to hardware issues, software updates, or system maintenance. For more information, see Scheduled events for your instances in the Amazon EC2 User Guide.    Instance state - You can manage your instances from the moment you launch them through their termination. For more information, see Instance lifecycle in the Amazon EC2 User Guide.  
   */
  describeInstanceStatus(params: EC2.Types.DescribeInstanceStatusRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceStatusResult) => void): Request<EC2.Types.DescribeInstanceStatusResult, AWSError>;
  /**
   * Describes the status of the specified instances or all of your instances. By default, only running instances are described, unless you specifically indicate to return the status of all instances. Instance status includes the following components:    Status checks - Amazon EC2 performs status checks on running EC2 instances to identify hardware and software issues. For more information, see Status checks for your instances and Troubleshoot instances with failed status checks in the Amazon EC2 User Guide.    Scheduled events - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances related to hardware issues, software updates, or system maintenance. For more information, see Scheduled events for your instances in the Amazon EC2 User Guide.    Instance state - You can manage your instances from the moment you launch them through their termination. For more information, see Instance lifecycle in the Amazon EC2 User Guide.  
   */
  describeInstanceStatus(callback?: (err: AWSError, data: EC2.Types.DescribeInstanceStatusResult) => void): Request<EC2.Types.DescribeInstanceStatusResult, AWSError>;
  /**
   * Returns a list of all instance types offered. The results can be filtered by location (Region or Availability Zone). If no location is specified, the instance types offered in the current Region are returned.
   */
  describeInstanceTypeOfferings(params: EC2.Types.DescribeInstanceTypeOfferingsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceTypeOfferingsResult) => void): Request<EC2.Types.DescribeInstanceTypeOfferingsResult, AWSError>;
  /**
   * Returns a list of all instance types offered. The results can be filtered by location (Region or Availability Zone). If no location is specified, the instance types offered in the current Region are returned.
   */
  describeInstanceTypeOfferings(callback?: (err: AWSError, data: EC2.Types.DescribeInstanceTypeOfferingsResult) => void): Request<EC2.Types.DescribeInstanceTypeOfferingsResult, AWSError>;
  /**
   * Describes the details of the instance types that are offered in a location. The results can be filtered by the attributes of the instance types.
   */
  describeInstanceTypes(params: EC2.Types.DescribeInstanceTypesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceTypesResult) => void): Request<EC2.Types.DescribeInstanceTypesResult, AWSError>;
  /**
   * Describes the details of the instance types that are offered in a location. The results can be filtered by the attributes of the instance types.
   */
  describeInstanceTypes(callback?: (err: AWSError, data: EC2.Types.DescribeInstanceTypesResult) => void): Request<EC2.Types.DescribeInstanceTypesResult, AWSError>;
  /**
   * Describes the specified instances or all instances. If you specify instance IDs, the output includes information for only the specified instances. If you specify filters, the output includes information for only those instances that meet the filter criteria. If you do not specify instance IDs or filters, the output includes information for all instances, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully. If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not own, it is not included in the output. Recently terminated instances might appear in the returned results. This interval is usually less than one hour. If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works normally.
   */
  describeInstances(params: EC2.Types.DescribeInstancesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Describes the specified instances or all instances. If you specify instance IDs, the output includes information for only the specified instances. If you specify filters, the output includes information for only those instances that meet the filter criteria. If you do not specify instance IDs or filters, the output includes information for all instances, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully. If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not own, it is not included in the output. Recently terminated instances might appear in the returned results. This interval is usually less than one hour. If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works normally.
   */
  describeInstances(callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Describes one or more of your internet gateways.
   */
  describeInternetGateways(params: EC2.Types.DescribeInternetGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeInternetGatewaysResult) => void): Request<EC2.Types.DescribeInternetGatewaysResult, AWSError>;
  /**
   * Describes one or more of your internet gateways.
   */
  describeInternetGateways(callback?: (err: AWSError, data: EC2.Types.DescribeInternetGatewaysResult) => void): Request<EC2.Types.DescribeInternetGatewaysResult, AWSError>;
  /**
   * Get information about your IPAM pools.
   */
  describeIpamPools(params: EC2.Types.DescribeIpamPoolsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeIpamPoolsResult) => void): Request<EC2.Types.DescribeIpamPoolsResult, AWSError>;
  /**
   * Get information about your IPAM pools.
   */
  describeIpamPools(callback?: (err: AWSError, data: EC2.Types.DescribeIpamPoolsResult) => void): Request<EC2.Types.DescribeIpamPoolsResult, AWSError>;
  /**
   * Get information about your IPAM scopes.
   */
  describeIpamScopes(params: EC2.Types.DescribeIpamScopesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeIpamScopesResult) => void): Request<EC2.Types.DescribeIpamScopesResult, AWSError>;
  /**
   * Get information about your IPAM scopes.
   */
  describeIpamScopes(callback?: (err: AWSError, data: EC2.Types.DescribeIpamScopesResult) => void): Request<EC2.Types.DescribeIpamScopesResult, AWSError>;
  /**
   * Get information about your IPAM pools. For more information, see What is IPAM? in the Amazon VPC IPAM User Guide. 
   */
  describeIpams(params: EC2.Types.DescribeIpamsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeIpamsResult) => void): Request<EC2.Types.DescribeIpamsResult, AWSError>;
  /**
   * Get information about your IPAM pools. For more information, see What is IPAM? in the Amazon VPC IPAM User Guide. 
   */
  describeIpams(callback?: (err: AWSError, data: EC2.Types.DescribeIpamsResult) => void): Request<EC2.Types.DescribeIpamsResult, AWSError>;
  /**
   * Describes your IPv6 address pools.
   */
  describeIpv6Pools(params: EC2.Types.DescribeIpv6PoolsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeIpv6PoolsResult) => void): Request<EC2.Types.DescribeIpv6PoolsResult, AWSError>;
  /**
   * Describes your IPv6 address pools.
   */
  describeIpv6Pools(callback?: (err: AWSError, data: EC2.Types.DescribeIpv6PoolsResult) => void): Request<EC2.Types.DescribeIpv6PoolsResult, AWSError>;
  /**
   * Describes the specified key pairs or all of your key pairs. For more information about key pairs, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.
   */
  describeKeyPairs(params: EC2.Types.DescribeKeyPairsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeKeyPairsResult) => void): Request<EC2.Types.DescribeKeyPairsResult, AWSError>;
  /**
   * Describes the specified key pairs or all of your key pairs. For more information about key pairs, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.
   */
  describeKeyPairs(callback?: (err: AWSError, data: EC2.Types.DescribeKeyPairsResult) => void): Request<EC2.Types.DescribeKeyPairsResult, AWSError>;
  /**
   * Describes one or more versions of a specified launch template. You can describe all versions, individual versions, or a range of versions. You can also describe all the latest versions or all the default versions of all the launch templates in your account.
   */
  describeLaunchTemplateVersions(params: EC2.Types.DescribeLaunchTemplateVersionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLaunchTemplateVersionsResult) => void): Request<EC2.Types.DescribeLaunchTemplateVersionsResult, AWSError>;
  /**
   * Describes one or more versions of a specified launch template. You can describe all versions, individual versions, or a range of versions. You can also describe all the latest versions or all the default versions of all the launch templates in your account.
   */
  describeLaunchTemplateVersions(callback?: (err: AWSError, data: EC2.Types.DescribeLaunchTemplateVersionsResult) => void): Request<EC2.Types.DescribeLaunchTemplateVersionsResult, AWSError>;
  /**
   * Describes one or more launch templates.
   */
  describeLaunchTemplates(params: EC2.Types.DescribeLaunchTemplatesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLaunchTemplatesResult) => void): Request<EC2.Types.DescribeLaunchTemplatesResult, AWSError>;
  /**
   * Describes one or more launch templates.
   */
  describeLaunchTemplates(callback?: (err: AWSError, data: EC2.Types.DescribeLaunchTemplatesResult) => void): Request<EC2.Types.DescribeLaunchTemplatesResult, AWSError>;
  /**
   * Describes the associations between virtual interface groups and local gateway route tables.
   */
  describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(params: EC2.Types.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult) => void): Request<EC2.Types.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult, AWSError>;
  /**
   * Describes the associations between virtual interface groups and local gateway route tables.
   */
  describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult) => void): Request<EC2.Types.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult, AWSError>;
  /**
   * Describes the specified associations between VPCs and local gateway route tables.
   */
  describeLocalGatewayRouteTableVpcAssociations(params: EC2.Types.DescribeLocalGatewayRouteTableVpcAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayRouteTableVpcAssociationsResult) => void): Request<EC2.Types.DescribeLocalGatewayRouteTableVpcAssociationsResult, AWSError>;
  /**
   * Describes the specified associations between VPCs and local gateway route tables.
   */
  describeLocalGatewayRouteTableVpcAssociations(callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayRouteTableVpcAssociationsResult) => void): Request<EC2.Types.DescribeLocalGatewayRouteTableVpcAssociationsResult, AWSError>;
  /**
   * Describes one or more local gateway route tables. By default, all local gateway route tables are described. Alternatively, you can filter the results.
   */
  describeLocalGatewayRouteTables(params: EC2.Types.DescribeLocalGatewayRouteTablesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayRouteTablesResult) => void): Request<EC2.Types.DescribeLocalGatewayRouteTablesResult, AWSError>;
  /**
   * Describes one or more local gateway route tables. By default, all local gateway route tables are described. Alternatively, you can filter the results.
   */
  describeLocalGatewayRouteTables(callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayRouteTablesResult) => void): Request<EC2.Types.DescribeLocalGatewayRouteTablesResult, AWSError>;
  /**
   * Describes the specified local gateway virtual interface groups.
   */
  describeLocalGatewayVirtualInterfaceGroups(params: EC2.Types.DescribeLocalGatewayVirtualInterfaceGroupsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayVirtualInterfaceGroupsResult) => void): Request<EC2.Types.DescribeLocalGatewayVirtualInterfaceGroupsResult, AWSError>;
  /**
   * Describes the specified local gateway virtual interface groups.
   */
  describeLocalGatewayVirtualInterfaceGroups(callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayVirtualInterfaceGroupsResult) => void): Request<EC2.Types.DescribeLocalGatewayVirtualInterfaceGroupsResult, AWSError>;
  /**
   * Describes the specified local gateway virtual interfaces.
   */
  describeLocalGatewayVirtualInterfaces(params: EC2.Types.DescribeLocalGatewayVirtualInterfacesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayVirtualInterfacesResult) => void): Request<EC2.Types.DescribeLocalGatewayVirtualInterfacesResult, AWSError>;
  /**
   * Describes the specified local gateway virtual interfaces.
   */
  describeLocalGatewayVirtualInterfaces(callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewayVirtualInterfacesResult) => void): Request<EC2.Types.DescribeLocalGatewayVirtualInterfacesResult, AWSError>;
  /**
   * Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter the results.
   */
  describeLocalGateways(params: EC2.Types.DescribeLocalGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewaysResult) => void): Request<EC2.Types.DescribeLocalGatewaysResult, AWSError>;
  /**
   * Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter the results.
   */
  describeLocalGateways(callback?: (err: AWSError, data: EC2.Types.DescribeLocalGatewaysResult) => void): Request<EC2.Types.DescribeLocalGatewaysResult, AWSError>;
  /**
   * Describes your managed prefix lists and any Amazon Web Services-managed prefix lists. To view the entries for your prefix list, use GetManagedPrefixListEntries.
   */
  describeManagedPrefixLists(params: EC2.Types.DescribeManagedPrefixListsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeManagedPrefixListsResult) => void): Request<EC2.Types.DescribeManagedPrefixListsResult, AWSError>;
  /**
   * Describes your managed prefix lists and any Amazon Web Services-managed prefix lists. To view the entries for your prefix list, use GetManagedPrefixListEntries.
   */
  describeManagedPrefixLists(callback?: (err: AWSError, data: EC2.Types.DescribeManagedPrefixListsResult) => void): Request<EC2.Types.DescribeManagedPrefixListsResult, AWSError>;
  /**
   * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.
   */
  describeMovingAddresses(params: EC2.Types.DescribeMovingAddressesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeMovingAddressesResult) => void): Request<EC2.Types.DescribeMovingAddressesResult, AWSError>;
  /**
   * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.
   */
  describeMovingAddresses(callback?: (err: AWSError, data: EC2.Types.DescribeMovingAddressesResult) => void): Request<EC2.Types.DescribeMovingAddressesResult, AWSError>;
  /**
   * Describes one or more of your NAT gateways.
   */
  describeNatGateways(params: EC2.Types.DescribeNatGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNatGatewaysResult) => void): Request<EC2.Types.DescribeNatGatewaysResult, AWSError>;
  /**
   * Describes one or more of your NAT gateways.
   */
  describeNatGateways(callback?: (err: AWSError, data: EC2.Types.DescribeNatGatewaysResult) => void): Request<EC2.Types.DescribeNatGatewaysResult, AWSError>;
  /**
   * Describes one or more of your network ACLs. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  describeNetworkAcls(params: EC2.Types.DescribeNetworkAclsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkAclsResult) => void): Request<EC2.Types.DescribeNetworkAclsResult, AWSError>;
  /**
   * Describes one or more of your network ACLs. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  describeNetworkAcls(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkAclsResult) => void): Request<EC2.Types.DescribeNetworkAclsResult, AWSError>;
  /**
   * Describes the specified Network Access Scope analyses.
   */
  describeNetworkInsightsAccessScopeAnalyses(params: EC2.Types.DescribeNetworkInsightsAccessScopeAnalysesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsAccessScopeAnalysesResult) => void): Request<EC2.Types.DescribeNetworkInsightsAccessScopeAnalysesResult, AWSError>;
  /**
   * Describes the specified Network Access Scope analyses.
   */
  describeNetworkInsightsAccessScopeAnalyses(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsAccessScopeAnalysesResult) => void): Request<EC2.Types.DescribeNetworkInsightsAccessScopeAnalysesResult, AWSError>;
  /**
   * Describes the specified Network Access Scopes.
   */
  describeNetworkInsightsAccessScopes(params: EC2.Types.DescribeNetworkInsightsAccessScopesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsAccessScopesResult) => void): Request<EC2.Types.DescribeNetworkInsightsAccessScopesResult, AWSError>;
  /**
   * Describes the specified Network Access Scopes.
   */
  describeNetworkInsightsAccessScopes(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsAccessScopesResult) => void): Request<EC2.Types.DescribeNetworkInsightsAccessScopesResult, AWSError>;
  /**
   * Describes one or more of your network insights analyses.
   */
  describeNetworkInsightsAnalyses(params: EC2.Types.DescribeNetworkInsightsAnalysesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsAnalysesResult) => void): Request<EC2.Types.DescribeNetworkInsightsAnalysesResult, AWSError>;
  /**
   * Describes one or more of your network insights analyses.
   */
  describeNetworkInsightsAnalyses(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsAnalysesResult) => void): Request<EC2.Types.DescribeNetworkInsightsAnalysesResult, AWSError>;
  /**
   * Describes one or more of your paths.
   */
  describeNetworkInsightsPaths(params: EC2.Types.DescribeNetworkInsightsPathsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsPathsResult) => void): Request<EC2.Types.DescribeNetworkInsightsPathsResult, AWSError>;
  /**
   * Describes one or more of your paths.
   */
  describeNetworkInsightsPaths(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInsightsPathsResult) => void): Request<EC2.Types.DescribeNetworkInsightsPathsResult, AWSError>;
  /**
   * Describes a network interface attribute. You can specify only one attribute at a time.
   */
  describeNetworkInterfaceAttribute(params: EC2.Types.DescribeNetworkInterfaceAttributeRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfaceAttributeResult) => void): Request<EC2.Types.DescribeNetworkInterfaceAttributeResult, AWSError>;
  /**
   * Describes a network interface attribute. You can specify only one attribute at a time.
   */
  describeNetworkInterfaceAttribute(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfaceAttributeResult) => void): Request<EC2.Types.DescribeNetworkInterfaceAttributeResult, AWSError>;
  /**
   * Describes the permissions for your network interfaces. 
   */
  describeNetworkInterfacePermissions(params: EC2.Types.DescribeNetworkInterfacePermissionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfacePermissionsResult) => void): Request<EC2.Types.DescribeNetworkInterfacePermissionsResult, AWSError>;
  /**
   * Describes the permissions for your network interfaces. 
   */
  describeNetworkInterfacePermissions(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfacePermissionsResult) => void): Request<EC2.Types.DescribeNetworkInterfacePermissionsResult, AWSError>;
  /**
   * Describes one or more of your network interfaces.
   */
  describeNetworkInterfaces(params: EC2.Types.DescribeNetworkInterfacesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfacesResult) => void): Request<EC2.Types.DescribeNetworkInterfacesResult, AWSError>;
  /**
   * Describes one or more of your network interfaces.
   */
  describeNetworkInterfaces(callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfacesResult) => void): Request<EC2.Types.DescribeNetworkInterfacesResult, AWSError>;
  /**
   * Describes the specified placement groups or all of your placement groups. For more information, see Placement groups in the Amazon EC2 User Guide.
   */
  describePlacementGroups(params: EC2.Types.DescribePlacementGroupsRequest, callback?: (err: AWSError, data: EC2.Types.DescribePlacementGroupsResult) => void): Request<EC2.Types.DescribePlacementGroupsResult, AWSError>;
  /**
   * Describes the specified placement groups or all of your placement groups. For more information, see Placement groups in the Amazon EC2 User Guide.
   */
  describePlacementGroups(callback?: (err: AWSError, data: EC2.Types.DescribePlacementGroupsResult) => void): Request<EC2.Types.DescribePlacementGroupsResult, AWSError>;
  /**
   * Describes available Amazon Web Services services in a prefix list format, which includes the prefix list name and prefix list ID of the service and the IP address range for the service. We recommend that you use DescribeManagedPrefixLists instead.
   */
  describePrefixLists(params: EC2.Types.DescribePrefixListsRequest, callback?: (err: AWSError, data: EC2.Types.DescribePrefixListsResult) => void): Request<EC2.Types.DescribePrefixListsResult, AWSError>;
  /**
   * Describes available Amazon Web Services services in a prefix list format, which includes the prefix list name and prefix list ID of the service and the IP address range for the service. We recommend that you use DescribeManagedPrefixLists instead.
   */
  describePrefixLists(callback?: (err: AWSError, data: EC2.Types.DescribePrefixListsResult) => void): Request<EC2.Types.DescribePrefixListsResult, AWSError>;
  /**
   * Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference.  By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden the default ID settings. The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway. 
   */
  describePrincipalIdFormat(params: EC2.Types.DescribePrincipalIdFormatRequest, callback?: (err: AWSError, data: EC2.Types.DescribePrincipalIdFormatResult) => void): Request<EC2.Types.DescribePrincipalIdFormatResult, AWSError>;
  /**
   * Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference.  By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden the default ID settings. The following resource types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | instance | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | reservation | route-table | route-table-association | security-group | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway. 
   */
  describePrincipalIdFormat(callback?: (err: AWSError, data: EC2.Types.DescribePrincipalIdFormatResult) => void): Request<EC2.Types.DescribePrincipalIdFormatResult, AWSError>;
  /**
   * Describes the specified IPv4 address pools.
   */
  describePublicIpv4Pools(params: EC2.Types.DescribePublicIpv4PoolsRequest, callback?: (err: AWSError, data: EC2.Types.DescribePublicIpv4PoolsResult) => void): Request<EC2.Types.DescribePublicIpv4PoolsResult, AWSError>;
  /**
   * Describes the specified IPv4 address pools.
   */
  describePublicIpv4Pools(callback?: (err: AWSError, data: EC2.Types.DescribePublicIpv4PoolsResult) => void): Request<EC2.Types.DescribePublicIpv4PoolsResult, AWSError>;
  /**
   * Describes the Regions that are enabled for your account, or all Regions. For a list of the Regions supported by Amazon EC2, see  Amazon Elastic Compute Cloud endpoints and quotas. For information about enabling and disabling Regions for your account, see Managing Amazon Web Services Regions in the Amazon Web Services General Reference.
   */
  describeRegions(params: EC2.Types.DescribeRegionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeRegionsResult) => void): Request<EC2.Types.DescribeRegionsResult, AWSError>;
  /**
   * Describes the Regions that are enabled for your account, or all Regions. For a list of the Regions supported by Amazon EC2, see  Amazon Elastic Compute Cloud endpoints and quotas. For information about enabling and disabling Regions for your account, see Managing Amazon Web Services Regions in the Amazon Web Services General Reference.
   */
  describeRegions(callback?: (err: AWSError, data: EC2.Types.DescribeRegionsResult) => void): Request<EC2.Types.DescribeRegionsResult, AWSError>;
  /**
   * Describes a root volume replacement task. For more information, see Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
   */
  describeReplaceRootVolumeTasks(params: EC2.Types.DescribeReplaceRootVolumeTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeReplaceRootVolumeTasksResult) => void): Request<EC2.Types.DescribeReplaceRootVolumeTasksResult, AWSError>;
  /**
   * Describes a root volume replacement task. For more information, see Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
   */
  describeReplaceRootVolumeTasks(callback?: (err: AWSError, data: EC2.Types.DescribeReplaceRootVolumeTasksResult) => void): Request<EC2.Types.DescribeReplaceRootVolumeTasksResult, AWSError>;
  /**
   * Describes one or more of the Reserved Instances that you purchased. For more information about Reserved Instances, see Reserved Instances in the Amazon EC2 User Guide.
   */
  describeReservedInstances(params: EC2.Types.DescribeReservedInstancesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesResult) => void): Request<EC2.Types.DescribeReservedInstancesResult, AWSError>;
  /**
   * Describes one or more of the Reserved Instances that you purchased. For more information about Reserved Instances, see Reserved Instances in the Amazon EC2 User Guide.
   */
  describeReservedInstances(callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesResult) => void): Request<EC2.Types.DescribeReservedInstancesResult, AWSError>;
  /**
   * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace. The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances. As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase. As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  describeReservedInstancesListings(params: EC2.Types.DescribeReservedInstancesListingsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesListingsResult) => void): Request<EC2.Types.DescribeReservedInstancesListingsResult, AWSError>;
  /**
   * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace. The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances. As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase. As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  describeReservedInstancesListings(callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesListingsResult) => void): Request<EC2.Types.DescribeReservedInstancesListingsResult, AWSError>;
  /**
   * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned. For more information, see Modifying Reserved Instances in the Amazon EC2 User Guide.
   */
  describeReservedInstancesModifications(params: EC2.Types.DescribeReservedInstancesModificationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesModificationsResult) => void): Request<EC2.Types.DescribeReservedInstancesModificationsResult, AWSError>;
  /**
   * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned. For more information, see Modifying Reserved Instances in the Amazon EC2 User Guide.
   */
  describeReservedInstancesModifications(callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesModificationsResult) => void): Request<EC2.Types.DescribeReservedInstancesModificationsResult, AWSError>;
  /**
   * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used. If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  describeReservedInstancesOfferings(params: EC2.Types.DescribeReservedInstancesOfferingsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesOfferingsResult) => void): Request<EC2.Types.DescribeReservedInstancesOfferingsResult, AWSError>;
  /**
   * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used. If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances. For more information, see Reserved Instance Marketplace in the Amazon EC2 User Guide.
   */
  describeReservedInstancesOfferings(callback?: (err: AWSError, data: EC2.Types.DescribeReservedInstancesOfferingsResult) => void): Request<EC2.Types.DescribeReservedInstancesOfferingsResult, AWSError>;
  /**
   * Describes one or more of your route tables. Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  describeRouteTables(params: EC2.Types.DescribeRouteTablesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeRouteTablesResult) => void): Request<EC2.Types.DescribeRouteTablesResult, AWSError>;
  /**
   * Describes one or more of your route tables. Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  describeRouteTables(callback?: (err: AWSError, data: EC2.Types.DescribeRouteTablesResult) => void): Request<EC2.Types.DescribeRouteTablesResult, AWSError>;
  /**
   * Finds available schedules that meet the specified criteria. You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours. After you find a schedule that meets your needs, call PurchaseScheduledInstances to purchase Scheduled Instances with that schedule.
   */
  describeScheduledInstanceAvailability(params: EC2.Types.DescribeScheduledInstanceAvailabilityRequest, callback?: (err: AWSError, data: EC2.Types.DescribeScheduledInstanceAvailabilityResult) => void): Request<EC2.Types.DescribeScheduledInstanceAvailabilityResult, AWSError>;
  /**
   * Finds available schedules that meet the specified criteria. You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours. After you find a schedule that meets your needs, call PurchaseScheduledInstances to purchase Scheduled Instances with that schedule.
   */
  describeScheduledInstanceAvailability(callback?: (err: AWSError, data: EC2.Types.DescribeScheduledInstanceAvailabilityResult) => void): Request<EC2.Types.DescribeScheduledInstanceAvailabilityResult, AWSError>;
  /**
   * Describes the specified Scheduled Instances or all your Scheduled Instances.
   */
  describeScheduledInstances(params: EC2.Types.DescribeScheduledInstancesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeScheduledInstancesResult) => void): Request<EC2.Types.DescribeScheduledInstancesResult, AWSError>;
  /**
   * Describes the specified Scheduled Instances or all your Scheduled Instances.
   */
  describeScheduledInstances(callback?: (err: AWSError, data: EC2.Types.DescribeScheduledInstancesResult) => void): Request<EC2.Types.DescribeScheduledInstancesResult, AWSError>;
  /**
   * [VPC only] Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've specified in this request.
   */
  describeSecurityGroupReferences(params: EC2.Types.DescribeSecurityGroupReferencesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupReferencesResult) => void): Request<EC2.Types.DescribeSecurityGroupReferencesResult, AWSError>;
  /**
   * [VPC only] Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've specified in this request.
   */
  describeSecurityGroupReferences(callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupReferencesResult) => void): Request<EC2.Types.DescribeSecurityGroupReferencesResult, AWSError>;
  /**
   * Describes one or more of your security group rules.
   */
  describeSecurityGroupRules(params: EC2.Types.DescribeSecurityGroupRulesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupRulesResult) => void): Request<EC2.Types.DescribeSecurityGroupRulesResult, AWSError>;
  /**
   * Describes one or more of your security group rules.
   */
  describeSecurityGroupRules(callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupRulesResult) => void): Request<EC2.Types.DescribeSecurityGroupRulesResult, AWSError>;
  /**
   * Describes the specified security groups or all of your security groups. A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more information, see Amazon EC2 security groups in the Amazon Elastic Compute Cloud User Guide and Security groups for your VPC in the Amazon Virtual Private Cloud User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeSecurityGroups(params: EC2.Types.DescribeSecurityGroupsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupsResult) => void): Request<EC2.Types.DescribeSecurityGroupsResult, AWSError>;
  /**
   * Describes the specified security groups or all of your security groups. A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more information, see Amazon EC2 security groups in the Amazon Elastic Compute Cloud User Guide and Security groups for your VPC in the Amazon Virtual Private Cloud User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeSecurityGroups(callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupsResult) => void): Request<EC2.Types.DescribeSecurityGroupsResult, AWSError>;
  /**
   * Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time. For more information about EBS snapshots, see Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
   */
  describeSnapshotAttribute(params: EC2.Types.DescribeSnapshotAttributeRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotAttributeResult) => void): Request<EC2.Types.DescribeSnapshotAttributeResult, AWSError>;
  /**
   * Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time. For more information about EBS snapshots, see Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
   */
  describeSnapshotAttribute(callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotAttributeResult) => void): Request<EC2.Types.DescribeSnapshotAttributeResult, AWSError>;
  /**
   * Describes the storage tier status of one or more Amazon EBS snapshots.
   */
  describeSnapshotTierStatus(params: EC2.Types.DescribeSnapshotTierStatusRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotTierStatusResult) => void): Request<EC2.Types.DescribeSnapshotTierStatusResult, AWSError>;
  /**
   * Describes the storage tier status of one or more Amazon EBS snapshots.
   */
  describeSnapshotTierStatus(callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotTierStatusResult) => void): Request<EC2.Types.DescribeSnapshotTierStatusResult, AWSError>;
  /**
   * Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you. The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots owned by other Amazon Web Services accounts for which you have explicit create volume permissions. The create volume permissions fall into the following categories:    public: The owner of the snapshot granted create volume permissions for the snapshot to the all group. All Amazon Web Services accounts have create volume permissions for these snapshots.    explicit: The owner of the snapshot granted create volume permissions to a specific Amazon Web Services account.    implicit: An Amazon Web Services account has implicit create volume permissions for all snapshots it owns.   The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or Amazon Web Services accounts with create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have create volume permissions. If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it is not included in the returned results. If you specify one or more snapshot owners using the OwnerIds option, only snapshots from the specified owners and for which you have access are returned. The results can include the Amazon Web Services account IDs of the specified owners, amazon for snapshots owned by Amazon, or self for snapshots that you own. If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are returned. You can specify Amazon Web Services account IDs (if you own the snapshots), self for snapshots for which you own or have explicit permissions, or all for public snapshots. If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more manageable. The MaxResults parameter sets the maximum number of results returned in a single page. If the list of results exceeds your MaxResults value, then that number of results is returned along with a NextToken value that can be passed to a subsequent DescribeSnapshots request to retrieve the remaining results. To get the state of fast snapshot restores for a snapshot, use DescribeFastSnapshotRestores. For more information about EBS snapshots, see Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
   */
  describeSnapshots(params: EC2.Types.DescribeSnapshotsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotsResult) => void): Request<EC2.Types.DescribeSnapshotsResult, AWSError>;
  /**
   * Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you. The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots owned by other Amazon Web Services accounts for which you have explicit create volume permissions. The create volume permissions fall into the following categories:    public: The owner of the snapshot granted create volume permissions for the snapshot to the all group. All Amazon Web Services accounts have create volume permissions for these snapshots.    explicit: The owner of the snapshot granted create volume permissions to a specific Amazon Web Services account.    implicit: An Amazon Web Services account has implicit create volume permissions for all snapshots it owns.   The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or Amazon Web Services accounts with create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have create volume permissions. If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it is not included in the returned results. If you specify one or more snapshot owners using the OwnerIds option, only snapshots from the specified owners and for which you have access are returned. The results can include the Amazon Web Services account IDs of the specified owners, amazon for snapshots owned by Amazon, or self for snapshots that you own. If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are returned. You can specify Amazon Web Services account IDs (if you own the snapshots), self for snapshots for which you own or have explicit permissions, or all for public snapshots. If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more manageable. The MaxResults parameter sets the maximum number of results returned in a single page. If the list of results exceeds your MaxResults value, then that number of results is returned along with a NextToken value that can be passed to a subsequent DescribeSnapshots request to retrieve the remaining results. To get the state of fast snapshot restores for a snapshot, use DescribeFastSnapshotRestores. For more information about EBS snapshots, see Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
   */
  describeSnapshots(callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotsResult) => void): Request<EC2.Types.DescribeSnapshotsResult, AWSError>;
  /**
   * Describes the data feed for Spot Instances. For more information, see Spot Instance data feed in the Amazon EC2 User Guide for Linux Instances.
   */
  describeSpotDatafeedSubscription(params: EC2.Types.DescribeSpotDatafeedSubscriptionRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSpotDatafeedSubscriptionResult) => void): Request<EC2.Types.DescribeSpotDatafeedSubscriptionResult, AWSError>;
  /**
   * Describes the data feed for Spot Instances. For more information, see Spot Instance data feed in the Amazon EC2 User Guide for Linux Instances.
   */
  describeSpotDatafeedSubscription(callback?: (err: AWSError, data: EC2.Types.DescribeSpotDatafeedSubscriptionResult) => void): Request<EC2.Types.DescribeSpotDatafeedSubscriptionResult, AWSError>;
  /**
   * Describes the running instances for the specified Spot Fleet.
   */
  describeSpotFleetInstances(params: EC2.Types.DescribeSpotFleetInstancesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSpotFleetInstancesResponse) => void): Request<EC2.Types.DescribeSpotFleetInstancesResponse, AWSError>;
  /**
   * Describes the running instances for the specified Spot Fleet.
   */
  describeSpotFleetInstances(callback?: (err: AWSError, data: EC2.Types.DescribeSpotFleetInstancesResponse) => void): Request<EC2.Types.DescribeSpotFleetInstancesResponse, AWSError>;
  /**
   * Describes the events for the specified Spot Fleet request during the specified time. Spot Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. Spot Fleet events are available for 48 hours. For more information, see Monitor fleet events using Amazon EventBridge in the Amazon EC2 User Guide.
   */
  describeSpotFleetRequestHistory(params: EC2.Types.DescribeSpotFleetRequestHistoryRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSpotFleetRequestHistoryResponse) => void): Request<EC2.Types.DescribeSpotFleetRequestHistoryResponse, AWSError>;
  /**
   * Describes the events for the specified Spot Fleet request during the specified time. Spot Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. Spot Fleet events are available for 48 hours. For more information, see Monitor fleet events using Amazon EventBridge in the Amazon EC2 User Guide.
   */
  describeSpotFleetRequestHistory(callback?: (err: AWSError, data: EC2.Types.DescribeSpotFleetRequestHistoryResponse) => void): Request<EC2.Types.DescribeSpotFleetRequestHistoryResponse, AWSError>;
  /**
   * Describes your Spot Fleet requests. Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.
   */
  describeSpotFleetRequests(params: EC2.Types.DescribeSpotFleetRequestsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSpotFleetRequestsResponse) => void): Request<EC2.Types.DescribeSpotFleetRequestsResponse, AWSError>;
  /**
   * Describes your Spot Fleet requests. Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.
   */
  describeSpotFleetRequests(callback?: (err: AWSError, data: EC2.Types.DescribeSpotFleetRequestsResponse) => void): Request<EC2.Types.DescribeSpotFleetRequestsResponse, AWSError>;
  /**
   * Describes the specified Spot Instance requests. You can use DescribeSpotInstanceRequests to find a running Spot Instance by examining the response. If the status of the Spot Instance is fulfilled, the instance ID appears in the response and contains the identifier of the instance. Alternatively, you can use DescribeInstances with a filter to look for instances where the instance lifecycle is spot. We recommend that you set MaxResults to a value between 5 and 1000 to limit the number of results returned. This paginates the output, which makes the list more manageable and returns the results faster. If the list of results exceeds your MaxResults value, then that number of results is returned along with a NextToken value that can be passed to a subsequent DescribeSpotInstanceRequests request to retrieve the remaining results. Spot Instance requests are deleted four hours after they are canceled and their instances are terminated.
   */
  describeSpotInstanceRequests(params: EC2.Types.DescribeSpotInstanceRequestsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSpotInstanceRequestsResult) => void): Request<EC2.Types.DescribeSpotInstanceRequestsResult, AWSError>;
  /**
   * Describes the specified Spot Instance requests. You can use DescribeSpotInstanceRequests to find a running Spot Instance by examining the response. If the status of the Spot Instance is fulfilled, the instance ID appears in the response and contains the identifier of the instance. Alternatively, you can use DescribeInstances with a filter to look for instances where the instance lifecycle is spot. We recommend that you set MaxResults to a value between 5 and 1000 to limit the number of results returned. This paginates the output, which makes the list more manageable and returns the results faster. If the list of results exceeds your MaxResults value, then that number of results is returned along with a NextToken value that can be passed to a subsequent DescribeSpotInstanceRequests request to retrieve the remaining results. Spot Instance requests are deleted four hours after they are canceled and their instances are terminated.
   */
  describeSpotInstanceRequests(callback?: (err: AWSError, data: EC2.Types.DescribeSpotInstanceRequestsResult) => void): Request<EC2.Types.DescribeSpotInstanceRequestsResult, AWSError>;
  /**
   * Describes the Spot price history. For more information, see Spot Instance pricing history in the Amazon EC2 User Guide for Linux Instances. When you specify a start and end time, the operation returns the prices of the instance types within that time range. It also returns the last price change before the start time, which is the effective price as of the start time.
   */
  describeSpotPriceHistory(params: EC2.Types.DescribeSpotPriceHistoryRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSpotPriceHistoryResult) => void): Request<EC2.Types.DescribeSpotPriceHistoryResult, AWSError>;
  /**
   * Describes the Spot price history. For more information, see Spot Instance pricing history in the Amazon EC2 User Guide for Linux Instances. When you specify a start and end time, the operation returns the prices of the instance types within that time range. It also returns the last price change before the start time, which is the effective price as of the start time.
   */
  describeSpotPriceHistory(callback?: (err: AWSError, data: EC2.Types.DescribeSpotPriceHistoryResult) => void): Request<EC2.Types.DescribeSpotPriceHistoryResult, AWSError>;
  /**
   * [VPC only] Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in the same VPC or in a peer VPC, or if they reference a security group in a peer VPC for which the VPC peering connection has been deleted.
   */
  describeStaleSecurityGroups(params: EC2.Types.DescribeStaleSecurityGroupsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeStaleSecurityGroupsResult) => void): Request<EC2.Types.DescribeStaleSecurityGroupsResult, AWSError>;
  /**
   * [VPC only] Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in the same VPC or in a peer VPC, or if they reference a security group in a peer VPC for which the VPC peering connection has been deleted.
   */
  describeStaleSecurityGroups(callback?: (err: AWSError, data: EC2.Types.DescribeStaleSecurityGroupsResult) => void): Request<EC2.Types.DescribeStaleSecurityGroupsResult, AWSError>;
  /**
   * Describes the progress of the AMI store tasks. You can describe the store tasks for specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from the last 31 days. For each AMI task, the response indicates if the task is InProgress, Completed, or Failed. For tasks InProgress, the response shows the estimated progress as a percentage. Tasks are listed in reverse chronological order. Currently, only tasks from the past 31 days can be viewed. To use this API, you must have the required permissions. For more information, see Permissions for storing and restoring AMIs using Amazon S3 in the Amazon Elastic Compute Cloud User Guide. For more information, see Store and restore an AMI using Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
   */
  describeStoreImageTasks(params: EC2.Types.DescribeStoreImageTasksRequest, callback?: (err: AWSError, data: EC2.Types.DescribeStoreImageTasksResult) => void): Request<EC2.Types.DescribeStoreImageTasksResult, AWSError>;
  /**
   * Describes the progress of the AMI store tasks. You can describe the store tasks for specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from the last 31 days. For each AMI task, the response indicates if the task is InProgress, Completed, or Failed. For tasks InProgress, the response shows the estimated progress as a percentage. Tasks are listed in reverse chronological order. Currently, only tasks from the past 31 days can be viewed. To use this API, you must have the required permissions. For more information, see Permissions for storing and restoring AMIs using Amazon S3 in the Amazon Elastic Compute Cloud User Guide. For more information, see Store and restore an AMI using Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
   */
  describeStoreImageTasks(callback?: (err: AWSError, data: EC2.Types.DescribeStoreImageTasksResult) => void): Request<EC2.Types.DescribeStoreImageTasksResult, AWSError>;
  /**
   * Describes one or more of your subnets. For more information, see Your VPC and subnets in the Amazon Virtual Private Cloud User Guide.
   */
  describeSubnets(params: EC2.Types.DescribeSubnetsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeSubnetsResult) => void): Request<EC2.Types.DescribeSubnetsResult, AWSError>;
  /**
   * Describes one or more of your subnets. For more information, see Your VPC and subnets in the Amazon Virtual Private Cloud User Guide.
   */
  describeSubnets(callback?: (err: AWSError, data: EC2.Types.DescribeSubnetsResult) => void): Request<EC2.Types.DescribeSubnetsResult, AWSError>;
  /**
   * Describes the specified tags for your EC2 resources. For more information about tags, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide.
   */
  describeTags(params: EC2.Types.DescribeTagsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTagsResult) => void): Request<EC2.Types.DescribeTagsResult, AWSError>;
  /**
   * Describes the specified tags for your EC2 resources. For more information about tags, see Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide.
   */
  describeTags(callback?: (err: AWSError, data: EC2.Types.DescribeTagsResult) => void): Request<EC2.Types.DescribeTagsResult, AWSError>;
  /**
   * Describes one or more Traffic Mirror filters.
   */
  describeTrafficMirrorFilters(params: EC2.Types.DescribeTrafficMirrorFiltersRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTrafficMirrorFiltersResult) => void): Request<EC2.Types.DescribeTrafficMirrorFiltersResult, AWSError>;
  /**
   * Describes one or more Traffic Mirror filters.
   */
  describeTrafficMirrorFilters(callback?: (err: AWSError, data: EC2.Types.DescribeTrafficMirrorFiltersResult) => void): Request<EC2.Types.DescribeTrafficMirrorFiltersResult, AWSError>;
  /**
   * Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.
   */
  describeTrafficMirrorSessions(params: EC2.Types.DescribeTrafficMirrorSessionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTrafficMirrorSessionsResult) => void): Request<EC2.Types.DescribeTrafficMirrorSessionsResult, AWSError>;
  /**
   * Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.
   */
  describeTrafficMirrorSessions(callback?: (err: AWSError, data: EC2.Types.DescribeTrafficMirrorSessionsResult) => void): Request<EC2.Types.DescribeTrafficMirrorSessionsResult, AWSError>;
  /**
   * Information about one or more Traffic Mirror targets.
   */
  describeTrafficMirrorTargets(params: EC2.Types.DescribeTrafficMirrorTargetsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTrafficMirrorTargetsResult) => void): Request<EC2.Types.DescribeTrafficMirrorTargetsResult, AWSError>;
  /**
   * Information about one or more Traffic Mirror targets.
   */
  describeTrafficMirrorTargets(callback?: (err: AWSError, data: EC2.Types.DescribeTrafficMirrorTargetsResult) => void): Request<EC2.Types.DescribeTrafficMirrorTargetsResult, AWSError>;
  /**
   * Describes one or more attachments between resources and transit gateways. By default, all attachments are described. Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.
   */
  describeTransitGatewayAttachments(params: EC2.Types.DescribeTransitGatewayAttachmentsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayAttachmentsResult) => void): Request<EC2.Types.DescribeTransitGatewayAttachmentsResult, AWSError>;
  /**
   * Describes one or more attachments between resources and transit gateways. By default, all attachments are described. Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.
   */
  describeTransitGatewayAttachments(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayAttachmentsResult) => void): Request<EC2.Types.DescribeTransitGatewayAttachmentsResult, AWSError>;
  /**
   * Describes one or more Connect peers.
   */
  describeTransitGatewayConnectPeers(params: EC2.Types.DescribeTransitGatewayConnectPeersRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayConnectPeersResult) => void): Request<EC2.Types.DescribeTransitGatewayConnectPeersResult, AWSError>;
  /**
   * Describes one or more Connect peers.
   */
  describeTransitGatewayConnectPeers(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayConnectPeersResult) => void): Request<EC2.Types.DescribeTransitGatewayConnectPeersResult, AWSError>;
  /**
   * Describes one or more Connect attachments.
   */
  describeTransitGatewayConnects(params: EC2.Types.DescribeTransitGatewayConnectsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayConnectsResult) => void): Request<EC2.Types.DescribeTransitGatewayConnectsResult, AWSError>;
  /**
   * Describes one or more Connect attachments.
   */
  describeTransitGatewayConnects(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayConnectsResult) => void): Request<EC2.Types.DescribeTransitGatewayConnectsResult, AWSError>;
  /**
   * Describes one or more transit gateway multicast domains.
   */
  describeTransitGatewayMulticastDomains(params: EC2.Types.DescribeTransitGatewayMulticastDomainsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayMulticastDomainsResult) => void): Request<EC2.Types.DescribeTransitGatewayMulticastDomainsResult, AWSError>;
  /**
   * Describes one or more transit gateway multicast domains.
   */
  describeTransitGatewayMulticastDomains(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayMulticastDomainsResult) => void): Request<EC2.Types.DescribeTransitGatewayMulticastDomainsResult, AWSError>;
  /**
   * Describes your transit gateway peering attachments.
   */
  describeTransitGatewayPeeringAttachments(params: EC2.Types.DescribeTransitGatewayPeeringAttachmentsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayPeeringAttachmentsResult) => void): Request<EC2.Types.DescribeTransitGatewayPeeringAttachmentsResult, AWSError>;
  /**
   * Describes your transit gateway peering attachments.
   */
  describeTransitGatewayPeeringAttachments(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayPeeringAttachmentsResult) => void): Request<EC2.Types.DescribeTransitGatewayPeeringAttachmentsResult, AWSError>;
  /**
   * Describes one or more transit gateway route policy tables. 
   */
  describeTransitGatewayPolicyTables(params: EC2.Types.DescribeTransitGatewayPolicyTablesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayPolicyTablesResult) => void): Request<EC2.Types.DescribeTransitGatewayPolicyTablesResult, AWSError>;
  /**
   * Describes one or more transit gateway route policy tables. 
   */
  describeTransitGatewayPolicyTables(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayPolicyTablesResult) => void): Request<EC2.Types.DescribeTransitGatewayPolicyTablesResult, AWSError>;
  /**
   * Describes one or more transit gateway route table advertisements.
   */
  describeTransitGatewayRouteTableAnnouncements(params: EC2.Types.DescribeTransitGatewayRouteTableAnnouncementsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayRouteTableAnnouncementsResult) => void): Request<EC2.Types.DescribeTransitGatewayRouteTableAnnouncementsResult, AWSError>;
  /**
   * Describes one or more transit gateway route table advertisements.
   */
  describeTransitGatewayRouteTableAnnouncements(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayRouteTableAnnouncementsResult) => void): Request<EC2.Types.DescribeTransitGatewayRouteTableAnnouncementsResult, AWSError>;
  /**
   * Describes one or more transit gateway route tables. By default, all transit gateway route tables are described. Alternatively, you can filter the results.
   */
  describeTransitGatewayRouteTables(params: EC2.Types.DescribeTransitGatewayRouteTablesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayRouteTablesResult) => void): Request<EC2.Types.DescribeTransitGatewayRouteTablesResult, AWSError>;
  /**
   * Describes one or more transit gateway route tables. By default, all transit gateway route tables are described. Alternatively, you can filter the results.
   */
  describeTransitGatewayRouteTables(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayRouteTablesResult) => void): Request<EC2.Types.DescribeTransitGatewayRouteTablesResult, AWSError>;
  /**
   * Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can filter the results.
   */
  describeTransitGatewayVpcAttachments(params: EC2.Types.DescribeTransitGatewayVpcAttachmentsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayVpcAttachmentsResult) => void): Request<EC2.Types.DescribeTransitGatewayVpcAttachmentsResult, AWSError>;
  /**
   * Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can filter the results.
   */
  describeTransitGatewayVpcAttachments(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewayVpcAttachmentsResult) => void): Request<EC2.Types.DescribeTransitGatewayVpcAttachmentsResult, AWSError>;
  /**
   * Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can filter the results.
   */
  describeTransitGateways(params: EC2.Types.DescribeTransitGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewaysResult) => void): Request<EC2.Types.DescribeTransitGatewaysResult, AWSError>;
  /**
   * Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can filter the results.
   */
  describeTransitGateways(callback?: (err: AWSError, data: EC2.Types.DescribeTransitGatewaysResult) => void): Request<EC2.Types.DescribeTransitGatewaysResult, AWSError>;
  /**
   *  This API action is currently in limited preview only. If you are interested in using this feature, contact your account manager.  Describes one or more network interface trunk associations.
   */
  describeTrunkInterfaceAssociations(params: EC2.Types.DescribeTrunkInterfaceAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeTrunkInterfaceAssociationsResult) => void): Request<EC2.Types.DescribeTrunkInterfaceAssociationsResult, AWSError>;
  /**
   *  This API action is currently in limited preview only. If you are interested in using this feature, contact your account manager.  Describes one or more network interface trunk associations.
   */
  describeTrunkInterfaceAssociations(callback?: (err: AWSError, data: EC2.Types.DescribeTrunkInterfaceAssociationsResult) => void): Request<EC2.Types.DescribeTrunkInterfaceAssociationsResult, AWSError>;
  /**
   * Describes the specified attribute of the specified volume. You can specify only one attribute at a time. For more information about EBS volumes, see Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVolumeAttribute(params: EC2.Types.DescribeVolumeAttributeRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVolumeAttributeResult) => void): Request<EC2.Types.DescribeVolumeAttributeResult, AWSError>;
  /**
   * Describes the specified attribute of the specified volume. You can specify only one attribute at a time. For more information about EBS volumes, see Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVolumeAttribute(callback?: (err: AWSError, data: EC2.Types.DescribeVolumeAttributeResult) => void): Request<EC2.Types.DescribeVolumeAttributeResult, AWSError>;
  /**
   * Describes the status of the specified volumes. Volume status provides the result of the checks performed on your volumes to determine events that can impair the performance of your volumes. The performance of a volume can be affected if an issue occurs on the volume's underlying host. If the volume's underlying host experiences a power outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the event. The DescribeVolumeStatus operation provides the following information about the specified volumes:  Status: Reflects the current status of the volume. The possible values are ok, impaired , warning, or insufficient-data. If all checks pass, the overall status of the volume is ok. If the check fails, the overall status is impaired. If the status is insufficient-data, then the checks might still be taking place on your volume at the time. We recommend that you retry the request. For more information about volume status, see Monitor the status of your volumes in the Amazon Elastic Compute Cloud User Guide.  Events: Reflect the cause of a volume status and might require you to take action. For example, if your volume returns an impaired status, then the volume event might be potential-data-inconsistency. This means that your volume has been affected by an issue with the underlying host, has all I/O operations disabled, and might have inconsistent data.  Actions: Reflect the actions you might have to take in response to an event. For example, if the status of the volume is impaired and the volume event shows potential-data-inconsistency, then the action shows enable-volume-io. This means that you may want to enable the I/O operations for the volume by calling the EnableVolumeIO action and then check the volume for data consistency. Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume status does not indicate volumes in the error state (for example, when a volume is incapable of accepting I/O.)
   */
  describeVolumeStatus(params: EC2.Types.DescribeVolumeStatusRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVolumeStatusResult) => void): Request<EC2.Types.DescribeVolumeStatusResult, AWSError>;
  /**
   * Describes the status of the specified volumes. Volume status provides the result of the checks performed on your volumes to determine events that can impair the performance of your volumes. The performance of a volume can be affected if an issue occurs on the volume's underlying host. If the volume's underlying host experiences a power outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the event. The DescribeVolumeStatus operation provides the following information about the specified volumes:  Status: Reflects the current status of the volume. The possible values are ok, impaired , warning, or insufficient-data. If all checks pass, the overall status of the volume is ok. If the check fails, the overall status is impaired. If the status is insufficient-data, then the checks might still be taking place on your volume at the time. We recommend that you retry the request. For more information about volume status, see Monitor the status of your volumes in the Amazon Elastic Compute Cloud User Guide.  Events: Reflect the cause of a volume status and might require you to take action. For example, if your volume returns an impaired status, then the volume event might be potential-data-inconsistency. This means that your volume has been affected by an issue with the underlying host, has all I/O operations disabled, and might have inconsistent data.  Actions: Reflect the actions you might have to take in response to an event. For example, if the status of the volume is impaired and the volume event shows potential-data-inconsistency, then the action shows enable-volume-io. This means that you may want to enable the I/O operations for the volume by calling the EnableVolumeIO action and then check the volume for data consistency. Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume status does not indicate volumes in the error state (for example, when a volume is incapable of accepting I/O.)
   */
  describeVolumeStatus(callback?: (err: AWSError, data: EC2.Types.DescribeVolumeStatusResult) => void): Request<EC2.Types.DescribeVolumeStatusResult, AWSError>;
  /**
   * Describes the specified EBS volumes or all of your EBS volumes. If you are describing a long list of volumes, we recommend that you paginate the output to make the list more manageable. The MaxResults parameter sets the maximum number of results returned in a single page. If the list of results exceeds your MaxResults value, then that number of results is returned along with a NextToken value that can be passed to a subsequent DescribeVolumes request to retrieve the remaining results. For more information about EBS volumes, see Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVolumes(params: EC2.Types.DescribeVolumesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Describes the specified EBS volumes or all of your EBS volumes. If you are describing a long list of volumes, we recommend that you paginate the output to make the list more manageable. The MaxResults parameter sets the maximum number of results returned in a single page. If the list of results exceeds your MaxResults value, then that number of results is returned along with a NextToken value that can be passed to a subsequent DescribeVolumes request to retrieve the remaining results. For more information about EBS volumes, see Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVolumes(callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Describes the most recent volume modification request for the specified EBS volumes. If a volume has never been modified, some information in the output will be null. If a volume has been modified more than once, the output includes only the most recent modification request. You can also use CloudWatch Events to check the status of a modification to an EBS volume. For information about CloudWatch Events, see the Amazon CloudWatch Events User Guide. For more information, see Monitor the progress of volume modifications in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVolumesModifications(params: EC2.Types.DescribeVolumesModificationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVolumesModificationsResult) => void): Request<EC2.Types.DescribeVolumesModificationsResult, AWSError>;
  /**
   * Describes the most recent volume modification request for the specified EBS volumes. If a volume has never been modified, some information in the output will be null. If a volume has been modified more than once, the output includes only the most recent modification request. You can also use CloudWatch Events to check the status of a modification to an EBS volume. For information about CloudWatch Events, see the Amazon CloudWatch Events User Guide. For more information, see Monitor the progress of volume modifications in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVolumesModifications(callback?: (err: AWSError, data: EC2.Types.DescribeVolumesModificationsResult) => void): Request<EC2.Types.DescribeVolumesModificationsResult, AWSError>;
  /**
   * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
   */
  describeVpcAttribute(params: EC2.Types.DescribeVpcAttributeRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcAttributeResult) => void): Request<EC2.Types.DescribeVpcAttributeResult, AWSError>;
  /**
   * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
   */
  describeVpcAttribute(callback?: (err: AWSError, data: EC2.Types.DescribeVpcAttributeResult) => void): Request<EC2.Types.DescribeVpcAttributeResult, AWSError>;
  /**
   * Describes the ClassicLink status of one or more VPCs.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeVpcClassicLink(params: EC2.Types.DescribeVpcClassicLinkRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcClassicLinkResult) => void): Request<EC2.Types.DescribeVpcClassicLinkResult, AWSError>;
  /**
   * Describes the ClassicLink status of one or more VPCs.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  describeVpcClassicLink(callback?: (err: AWSError, data: EC2.Types.DescribeVpcClassicLinkResult) => void): Request<EC2.Types.DescribeVpcClassicLinkResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVpcClassicLinkDnsSupport(params: EC2.Types.DescribeVpcClassicLinkDnsSupportRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcClassicLinkDnsSupportResult) => void): Request<EC2.Types.DescribeVpcClassicLinkDnsSupportResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide.
   */
  describeVpcClassicLinkDnsSupport(callback?: (err: AWSError, data: EC2.Types.DescribeVpcClassicLinkDnsSupportResult) => void): Request<EC2.Types.DescribeVpcClassicLinkDnsSupportResult, AWSError>;
  /**
   * Describes the connection notifications for VPC endpoints and VPC endpoint services.
   */
  describeVpcEndpointConnectionNotifications(params: EC2.Types.DescribeVpcEndpointConnectionNotificationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointConnectionNotificationsResult) => void): Request<EC2.Types.DescribeVpcEndpointConnectionNotificationsResult, AWSError>;
  /**
   * Describes the connection notifications for VPC endpoints and VPC endpoint services.
   */
  describeVpcEndpointConnectionNotifications(callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointConnectionNotificationsResult) => void): Request<EC2.Types.DescribeVpcEndpointConnectionNotificationsResult, AWSError>;
  /**
   * Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending your acceptance.
   */
  describeVpcEndpointConnections(params: EC2.Types.DescribeVpcEndpointConnectionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointConnectionsResult) => void): Request<EC2.Types.DescribeVpcEndpointConnectionsResult, AWSError>;
  /**
   * Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending your acceptance.
   */
  describeVpcEndpointConnections(callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointConnectionsResult) => void): Request<EC2.Types.DescribeVpcEndpointConnectionsResult, AWSError>;
  /**
   * Describes the VPC endpoint service configurations in your account (your services).
   */
  describeVpcEndpointServiceConfigurations(params: EC2.Types.DescribeVpcEndpointServiceConfigurationsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointServiceConfigurationsResult) => void): Request<EC2.Types.DescribeVpcEndpointServiceConfigurationsResult, AWSError>;
  /**
   * Describes the VPC endpoint service configurations in your account (your services).
   */
  describeVpcEndpointServiceConfigurations(callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointServiceConfigurationsResult) => void): Request<EC2.Types.DescribeVpcEndpointServiceConfigurationsResult, AWSError>;
  /**
   * Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.
   */
  describeVpcEndpointServicePermissions(params: EC2.Types.DescribeVpcEndpointServicePermissionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointServicePermissionsResult) => void): Request<EC2.Types.DescribeVpcEndpointServicePermissionsResult, AWSError>;
  /**
   * Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.
   */
  describeVpcEndpointServicePermissions(callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointServicePermissionsResult) => void): Request<EC2.Types.DescribeVpcEndpointServicePermissionsResult, AWSError>;
  /**
   * Describes available services to which you can create a VPC endpoint. When the service provider and the consumer have different accounts in multiple Availability Zones, and the consumer views the VPC endpoint service information, the response only includes the common Availability Zones. For example, when the service provider account uses us-east-1a and us-east-1c and the consumer uses us-east-1a and us-east-1b, the response includes the VPC endpoint services in the common Availability Zone, us-east-1a.
   */
  describeVpcEndpointServices(params: EC2.Types.DescribeVpcEndpointServicesRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointServicesResult) => void): Request<EC2.Types.DescribeVpcEndpointServicesResult, AWSError>;
  /**
   * Describes available services to which you can create a VPC endpoint. When the service provider and the consumer have different accounts in multiple Availability Zones, and the consumer views the VPC endpoint service information, the response only includes the common Availability Zones. For example, when the service provider account uses us-east-1a and us-east-1c and the consumer uses us-east-1a and us-east-1b, the response includes the VPC endpoint services in the common Availability Zone, us-east-1a.
   */
  describeVpcEndpointServices(callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointServicesResult) => void): Request<EC2.Types.DescribeVpcEndpointServicesResult, AWSError>;
  /**
   * Describes one or more of your VPC endpoints.
   */
  describeVpcEndpoints(params: EC2.Types.DescribeVpcEndpointsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointsResult) => void): Request<EC2.Types.DescribeVpcEndpointsResult, AWSError>;
  /**
   * Describes one or more of your VPC endpoints.
   */
  describeVpcEndpoints(callback?: (err: AWSError, data: EC2.Types.DescribeVpcEndpointsResult) => void): Request<EC2.Types.DescribeVpcEndpointsResult, AWSError>;
  /**
   * Describes one or more of your VPC peering connections.
   */
  describeVpcPeeringConnections(params: EC2.Types.DescribeVpcPeeringConnectionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcPeeringConnectionsResult) => void): Request<EC2.Types.DescribeVpcPeeringConnectionsResult, AWSError>;
  /**
   * Describes one or more of your VPC peering connections.
   */
  describeVpcPeeringConnections(callback?: (err: AWSError, data: EC2.Types.DescribeVpcPeeringConnectionsResult) => void): Request<EC2.Types.DescribeVpcPeeringConnectionsResult, AWSError>;
  /**
   * Describes one or more of your VPCs.
   */
  describeVpcs(params: EC2.Types.DescribeVpcsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpcsResult) => void): Request<EC2.Types.DescribeVpcsResult, AWSError>;
  /**
   * Describes one or more of your VPCs.
   */
  describeVpcs(callback?: (err: AWSError, data: EC2.Types.DescribeVpcsResult) => void): Request<EC2.Types.DescribeVpcsResult, AWSError>;
  /**
   * Describes one or more of your VPN connections. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  describeVpnConnections(params: EC2.Types.DescribeVpnConnectionsRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpnConnectionsResult) => void): Request<EC2.Types.DescribeVpnConnectionsResult, AWSError>;
  /**
   * Describes one or more of your VPN connections. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  describeVpnConnections(callback?: (err: AWSError, data: EC2.Types.DescribeVpnConnectionsResult) => void): Request<EC2.Types.DescribeVpnConnectionsResult, AWSError>;
  /**
   * Describes one or more of your virtual private gateways. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  describeVpnGateways(params: EC2.Types.DescribeVpnGatewaysRequest, callback?: (err: AWSError, data: EC2.Types.DescribeVpnGatewaysResult) => void): Request<EC2.Types.DescribeVpnGatewaysResult, AWSError>;
  /**
   * Describes one or more of your virtual private gateways. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  describeVpnGateways(callback?: (err: AWSError, data: EC2.Types.DescribeVpnGatewaysResult) => void): Request<EC2.Types.DescribeVpnGatewaysResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's stopped.
   */
  detachClassicLinkVpc(params: EC2.Types.DetachClassicLinkVpcRequest, callback?: (err: AWSError, data: EC2.Types.DetachClassicLinkVpcResult) => void): Request<EC2.Types.DetachClassicLinkVpcResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's stopped.
   */
  detachClassicLinkVpc(callback?: (err: AWSError, data: EC2.Types.DetachClassicLinkVpcResult) => void): Request<EC2.Types.DetachClassicLinkVpcResult, AWSError>;
  /**
   * Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must not contain any running instances with Elastic IP addresses or public IPv4 addresses.
   */
  detachInternetGateway(params: EC2.Types.DetachInternetGatewayRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must not contain any running instances with Elastic IP addresses or public IPv4 addresses.
   */
  detachInternetGateway(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Detaches a network interface from an instance.
   */
  detachNetworkInterface(params: EC2.Types.DetachNetworkInterfaceRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Detaches a network interface from an instance.
   */
  detachNetworkInterface(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the busy state while detaching. If this happens, detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of an instance, it can't be detached while the instance is running. To detach the root volume, stop the instance first. When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the product code is no longer associated with the instance. For more information, see Detach an Amazon EBS volume in the Amazon Elastic Compute Cloud User Guide.
   */
  detachVolume(params: EC2.Types.DetachVolumeRequest, callback?: (err: AWSError, data: EC2.Types.VolumeAttachment) => void): Request<EC2.Types.VolumeAttachment, AWSError>;
  /**
   * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the busy state while detaching. If this happens, detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of an instance, it can't be detached while the instance is running. To detach the root volume, stop the instance first. When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the product code is no longer associated with the instance. For more information, see Detach an Amazon EBS volume in the Amazon Elastic Compute Cloud User Guide.
   */
  detachVolume(callback?: (err: AWSError, data: EC2.Types.VolumeAttachment) => void): Request<EC2.Types.VolumeAttachment, AWSError>;
  /**
   * Detaches a virtual private gateway from a VPC. You do this if you're planning to turn off the VPC and not use it anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the virtual private gateway (any attachments to the virtual private gateway are also described). You must wait for the attachment's state to switch to detached before you can delete the VPC or attach a different VPC to the virtual private gateway.
   */
  detachVpnGateway(params: EC2.Types.DetachVpnGatewayRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Detaches a virtual private gateway from a VPC. You do this if you're planning to turn off the VPC and not use it anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the virtual private gateway (any attachments to the virtual private gateway are also described). You must wait for the attachment's state to switch to detached before you can delete the VPC or attach a different VPC to the virtual private gateway.
   */
  detachVpnGateway(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disables Elastic IP address transfer. For more information, see Transfer Elastic IP addresses in the Amazon Virtual Private Cloud User Guide.
   */
  disableAddressTransfer(params: EC2.Types.DisableAddressTransferRequest, callback?: (err: AWSError, data: EC2.Types.DisableAddressTransferResult) => void): Request<EC2.Types.DisableAddressTransferResult, AWSError>;
  /**
   * Disables Elastic IP address transfer. For more information, see Transfer Elastic IP addresses in the Amazon Virtual Private Cloud User Guide.
   */
  disableAddressTransfer(callback?: (err: AWSError, data: EC2.Types.DisableAddressTransferResult) => void): Request<EC2.Types.DisableAddressTransferResult, AWSError>;
  /**
   * Disables EBS encryption by default for your account in the current Region. After you disable encryption by default, you can still create encrypted volumes by enabling encryption when you create each volume. Disabling encryption by default does not change the encryption status of your existing volumes. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  disableEbsEncryptionByDefault(params: EC2.Types.DisableEbsEncryptionByDefaultRequest, callback?: (err: AWSError, data: EC2.Types.DisableEbsEncryptionByDefaultResult) => void): Request<EC2.Types.DisableEbsEncryptionByDefaultResult, AWSError>;
  /**
   * Disables EBS encryption by default for your account in the current Region. After you disable encryption by default, you can still create encrypted volumes by enabling encryption when you create each volume. Disabling encryption by default does not change the encryption status of your existing volumes. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  disableEbsEncryptionByDefault(callback?: (err: AWSError, data: EC2.Types.DisableEbsEncryptionByDefaultResult) => void): Request<EC2.Types.DisableEbsEncryptionByDefaultResult, AWSError>;
  /**
   * Discontinue faster launching for a Windows AMI, and clean up existing pre-provisioned snapshots. When you disable faster launching, the AMI uses the standard launch process for each instance. All pre-provisioned snapshots must be removed before you can enable faster launching again.  To change these settings, you must own the AMI. 
   */
  disableFastLaunch(params: EC2.Types.DisableFastLaunchRequest, callback?: (err: AWSError, data: EC2.Types.DisableFastLaunchResult) => void): Request<EC2.Types.DisableFastLaunchResult, AWSError>;
  /**
   * Discontinue faster launching for a Windows AMI, and clean up existing pre-provisioned snapshots. When you disable faster launching, the AMI uses the standard launch process for each instance. All pre-provisioned snapshots must be removed before you can enable faster launching again.  To change these settings, you must own the AMI. 
   */
  disableFastLaunch(callback?: (err: AWSError, data: EC2.Types.DisableFastLaunchResult) => void): Request<EC2.Types.DisableFastLaunchResult, AWSError>;
  /**
   * Disables fast snapshot restores for the specified snapshots in the specified Availability Zones.
   */
  disableFastSnapshotRestores(params: EC2.Types.DisableFastSnapshotRestoresRequest, callback?: (err: AWSError, data: EC2.Types.DisableFastSnapshotRestoresResult) => void): Request<EC2.Types.DisableFastSnapshotRestoresResult, AWSError>;
  /**
   * Disables fast snapshot restores for the specified snapshots in the specified Availability Zones.
   */
  disableFastSnapshotRestores(callback?: (err: AWSError, data: EC2.Types.DisableFastSnapshotRestoresResult) => void): Request<EC2.Types.DisableFastSnapshotRestoresResult, AWSError>;
  /**
   * Cancels the deprecation of the specified AMI. For more information, see Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  disableImageDeprecation(params: EC2.Types.DisableImageDeprecationRequest, callback?: (err: AWSError, data: EC2.Types.DisableImageDeprecationResult) => void): Request<EC2.Types.DisableImageDeprecationResult, AWSError>;
  /**
   * Cancels the deprecation of the specified AMI. For more information, see Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  disableImageDeprecation(callback?: (err: AWSError, data: EC2.Types.DisableImageDeprecationResult) => void): Request<EC2.Types.DisableImageDeprecationResult, AWSError>;
  /**
   * Disable the IPAM account. For more information, see Enable integration with Organizations in the Amazon VPC IPAM User Guide. 
   */
  disableIpamOrganizationAdminAccount(params: EC2.Types.DisableIpamOrganizationAdminAccountRequest, callback?: (err: AWSError, data: EC2.Types.DisableIpamOrganizationAdminAccountResult) => void): Request<EC2.Types.DisableIpamOrganizationAdminAccountResult, AWSError>;
  /**
   * Disable the IPAM account. For more information, see Enable integration with Organizations in the Amazon VPC IPAM User Guide. 
   */
  disableIpamOrganizationAdminAccount(callback?: (err: AWSError, data: EC2.Types.DisableIpamOrganizationAdminAccountResult) => void): Request<EC2.Types.DisableIpamOrganizationAdminAccountResult, AWSError>;
  /**
   * Disables access to the EC2 serial console of all instances for your account. By default, access to the EC2 serial console is disabled for your account. For more information, see Manage account access to the EC2 serial console in the Amazon EC2 User Guide.
   */
  disableSerialConsoleAccess(params: EC2.Types.DisableSerialConsoleAccessRequest, callback?: (err: AWSError, data: EC2.Types.DisableSerialConsoleAccessResult) => void): Request<EC2.Types.DisableSerialConsoleAccessResult, AWSError>;
  /**
   * Disables access to the EC2 serial console of all instances for your account. By default, access to the EC2 serial console is disabled for your account. For more information, see Manage account access to the EC2 serial console in the Amazon EC2 User Guide.
   */
  disableSerialConsoleAccess(callback?: (err: AWSError, data: EC2.Types.DisableSerialConsoleAccessResult) => void): Request<EC2.Types.DisableSerialConsoleAccessResult, AWSError>;
  /**
   * Disables the specified resource attachment from propagating routes to the specified propagation route table.
   */
  disableTransitGatewayRouteTablePropagation(params: EC2.Types.DisableTransitGatewayRouteTablePropagationRequest, callback?: (err: AWSError, data: EC2.Types.DisableTransitGatewayRouteTablePropagationResult) => void): Request<EC2.Types.DisableTransitGatewayRouteTablePropagationResult, AWSError>;
  /**
   * Disables the specified resource attachment from propagating routes to the specified propagation route table.
   */
  disableTransitGatewayRouteTablePropagation(callback?: (err: AWSError, data: EC2.Types.DisableTransitGatewayRouteTablePropagationResult) => void): Request<EC2.Types.DisableTransitGatewayRouteTablePropagationResult, AWSError>;
  /**
   * Disables a virtual private gateway (VGW) from propagating routes to a specified route table of a VPC.
   */
  disableVgwRoutePropagation(params: EC2.Types.DisableVgwRoutePropagationRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disables a virtual private gateway (VGW) from propagating routes to a specified route table of a VPC.
   */
  disableVgwRoutePropagation(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  disableVpcClassicLink(params: EC2.Types.DisableVpcClassicLinkRequest, callback?: (err: AWSError, data: EC2.Types.DisableVpcClassicLinkResult) => void): Request<EC2.Types.DisableVpcClassicLinkResult, AWSError>;
  /**
   * Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  disableVpcClassicLink(callback?: (err: AWSError, data: EC2.Types.DisableVpcClassicLinkResult) => void): Request<EC2.Types.DisableVpcClassicLinkResult, AWSError>;
  /**
   * Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to public IP addresses when addressed between a linked EC2-Classic instance and instances in the VPC to which it's linked. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide. You must specify a VPC ID in the request.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  disableVpcClassicLinkDnsSupport(params: EC2.Types.DisableVpcClassicLinkDnsSupportRequest, callback?: (err: AWSError, data: EC2.Types.DisableVpcClassicLinkDnsSupportResult) => void): Request<EC2.Types.DisableVpcClassicLinkDnsSupportResult, AWSError>;
  /**
   * Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to public IP addresses when addressed between a linked EC2-Classic instance and instances in the VPC to which it's linked. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide. You must specify a VPC ID in the request.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  disableVpcClassicLinkDnsSupport(callback?: (err: AWSError, data: EC2.Types.DisableVpcClassicLinkDnsSupportResult) => void): Request<EC2.Types.DisableVpcClassicLinkDnsSupportResult, AWSError>;
  /**
   * Disassociates an Elastic IP address from the instance or network interface it's associated with. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
   */
  disassociateAddress(params: EC2.Types.DisassociateAddressRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disassociates an Elastic IP address from the instance or network interface it's associated with. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
   */
  disassociateAddress(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disassociates a target network from the specified Client VPN endpoint. When you disassociate the last target network from a Client VPN, the following happens:   The route that was automatically added for the VPC is deleted   All active client connections are terminated   New client connections are disallowed   The Client VPN endpoint's status changes to pending-associate   
   */
  disassociateClientVpnTargetNetwork(params: EC2.Types.DisassociateClientVpnTargetNetworkRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateClientVpnTargetNetworkResult) => void): Request<EC2.Types.DisassociateClientVpnTargetNetworkResult, AWSError>;
  /**
   * Disassociates a target network from the specified Client VPN endpoint. When you disassociate the last target network from a Client VPN, the following happens:   The route that was automatically added for the VPC is deleted   All active client connections are terminated   New client connections are disallowed   The Client VPN endpoint's status changes to pending-associate   
   */
  disassociateClientVpnTargetNetwork(callback?: (err: AWSError, data: EC2.Types.DisassociateClientVpnTargetNetworkResult) => void): Request<EC2.Types.DisassociateClientVpnTargetNetworkResult, AWSError>;
  /**
   * Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and encrypted private key from the Amazon S3 bucket. It also revokes the IAM role's permission to use the KMS key used to encrypt the private key. This effectively revokes the role's permission to use the certificate.
   */
  disassociateEnclaveCertificateIamRole(params: EC2.Types.DisassociateEnclaveCertificateIamRoleRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateEnclaveCertificateIamRoleResult) => void): Request<EC2.Types.DisassociateEnclaveCertificateIamRoleResult, AWSError>;
  /**
   * Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and encrypted private key from the Amazon S3 bucket. It also revokes the IAM role's permission to use the KMS key used to encrypt the private key. This effectively revokes the role's permission to use the certificate.
   */
  disassociateEnclaveCertificateIamRole(callback?: (err: AWSError, data: EC2.Types.DisassociateEnclaveCertificateIamRoleResult) => void): Request<EC2.Types.DisassociateEnclaveCertificateIamRoleResult, AWSError>;
  /**
   * Disassociates an IAM instance profile from a running or stopped instance. Use DescribeIamInstanceProfileAssociations to get the association ID.
   */
  disassociateIamInstanceProfile(params: EC2.Types.DisassociateIamInstanceProfileRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateIamInstanceProfileResult) => void): Request<EC2.Types.DisassociateIamInstanceProfileResult, AWSError>;
  /**
   * Disassociates an IAM instance profile from a running or stopped instance. Use DescribeIamInstanceProfileAssociations to get the association ID.
   */
  disassociateIamInstanceProfile(callback?: (err: AWSError, data: EC2.Types.DisassociateIamInstanceProfileResult) => void): Request<EC2.Types.DisassociateIamInstanceProfileResult, AWSError>;
  /**
   * Disassociates one or more targets from an event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  disassociateInstanceEventWindow(params: EC2.Types.DisassociateInstanceEventWindowRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateInstanceEventWindowResult) => void): Request<EC2.Types.DisassociateInstanceEventWindowResult, AWSError>;
  /**
   * Disassociates one or more targets from an event window. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  disassociateInstanceEventWindow(callback?: (err: AWSError, data: EC2.Types.DisassociateInstanceEventWindowResult) => void): Request<EC2.Types.DisassociateInstanceEventWindowResult, AWSError>;
  /**
   * Disassociates a subnet or gateway from a route table. After you perform this action, the subnet no longer uses the routes in the route table. Instead, it uses the routes in the VPC's main route table. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  disassociateRouteTable(params: EC2.Types.DisassociateRouteTableRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disassociates a subnet or gateway from a route table. After you perform this action, the subnet no longer uses the routes in the route table. Instead, it uses the routes in the VPC's main route table. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  disassociateRouteTable(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it. 
   */
  disassociateSubnetCidrBlock(params: EC2.Types.DisassociateSubnetCidrBlockRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateSubnetCidrBlockResult) => void): Request<EC2.Types.DisassociateSubnetCidrBlockResult, AWSError>;
  /**
   * Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it. 
   */
  disassociateSubnetCidrBlock(callback?: (err: AWSError, data: EC2.Types.DisassociateSubnetCidrBlockResult) => void): Request<EC2.Types.DisassociateSubnetCidrBlockResult, AWSError>;
  /**
   * Disassociates the specified subnets from the transit gateway multicast domain. 
   */
  disassociateTransitGatewayMulticastDomain(params: EC2.Types.DisassociateTransitGatewayMulticastDomainRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.DisassociateTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Disassociates the specified subnets from the transit gateway multicast domain. 
   */
  disassociateTransitGatewayMulticastDomain(callback?: (err: AWSError, data: EC2.Types.DisassociateTransitGatewayMulticastDomainResult) => void): Request<EC2.Types.DisassociateTransitGatewayMulticastDomainResult, AWSError>;
  /**
   * Removes the association between an an attachment and a policy table.
   */
  disassociateTransitGatewayPolicyTable(params: EC2.Types.DisassociateTransitGatewayPolicyTableRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateTransitGatewayPolicyTableResult) => void): Request<EC2.Types.DisassociateTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Removes the association between an an attachment and a policy table.
   */
  disassociateTransitGatewayPolicyTable(callback?: (err: AWSError, data: EC2.Types.DisassociateTransitGatewayPolicyTableResult) => void): Request<EC2.Types.DisassociateTransitGatewayPolicyTableResult, AWSError>;
  /**
   * Disassociates a resource attachment from a transit gateway route table.
   */
  disassociateTransitGatewayRouteTable(params: EC2.Types.DisassociateTransitGatewayRouteTableRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateTransitGatewayRouteTableResult) => void): Request<EC2.Types.DisassociateTransitGatewayRouteTableResult, AWSError>;
  /**
   * Disassociates a resource attachment from a transit gateway route table.
   */
  disassociateTransitGatewayRouteTable(callback?: (err: AWSError, data: EC2.Types.DisassociateTransitGatewayRouteTableResult) => void): Request<EC2.Types.DisassociateTransitGatewayRouteTableResult, AWSError>;
  /**
   *  This API action is currently in limited preview only. If you are interested in using this feature, contact your account manager.  Removes an association between a branch network interface with a trunk network interface.
   */
  disassociateTrunkInterface(params: EC2.Types.DisassociateTrunkInterfaceRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateTrunkInterfaceResult) => void): Request<EC2.Types.DisassociateTrunkInterfaceResult, AWSError>;
  /**
   *  This API action is currently in limited preview only. If you are interested in using this feature, contact your account manager.  Removes an association between a branch network interface with a trunk network interface.
   */
  disassociateTrunkInterface(callback?: (err: AWSError, data: EC2.Types.DisassociateTrunkInterfaceResult) => void): Request<EC2.Types.DisassociateTrunkInterfaceResult, AWSError>;
  /**
   * Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must specify its association ID. You can get the association ID by using DescribeVpcs. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it.  You cannot disassociate the CIDR block with which you originally created the VPC (the primary CIDR block).
   */
  disassociateVpcCidrBlock(params: EC2.Types.DisassociateVpcCidrBlockRequest, callback?: (err: AWSError, data: EC2.Types.DisassociateVpcCidrBlockResult) => void): Request<EC2.Types.DisassociateVpcCidrBlockResult, AWSError>;
  /**
   * Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must specify its association ID. You can get the association ID by using DescribeVpcs. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it.  You cannot disassociate the CIDR block with which you originally created the VPC (the primary CIDR block).
   */
  disassociateVpcCidrBlock(callback?: (err: AWSError, data: EC2.Types.DisassociateVpcCidrBlockResult) => void): Request<EC2.Types.DisassociateVpcCidrBlockResult, AWSError>;
  /**
   * Enables Elastic IP address transfer. For more information, see Transfer Elastic IP addresses in the Amazon Virtual Private Cloud User Guide.
   */
  enableAddressTransfer(params: EC2.Types.EnableAddressTransferRequest, callback?: (err: AWSError, data: EC2.Types.EnableAddressTransferResult) => void): Request<EC2.Types.EnableAddressTransferResult, AWSError>;
  /**
   * Enables Elastic IP address transfer. For more information, see Transfer Elastic IP addresses in the Amazon Virtual Private Cloud User Guide.
   */
  enableAddressTransfer(callback?: (err: AWSError, data: EC2.Types.EnableAddressTransferResult) => void): Request<EC2.Types.EnableAddressTransferResult, AWSError>;
  /**
   * Enables EBS encryption by default for your account in the current Region. After you enable encryption by default, the EBS volumes that you create are always encrypted, either using the default KMS key or the KMS key that you specified when you created each volume. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide. You can specify the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId. Enabling encryption by default has no effect on the encryption status of your existing volumes. After you enable encryption by default, you can no longer launch instances using instance types that do not support encryption. For more information, see Supported instance types.
   */
  enableEbsEncryptionByDefault(params: EC2.Types.EnableEbsEncryptionByDefaultRequest, callback?: (err: AWSError, data: EC2.Types.EnableEbsEncryptionByDefaultResult) => void): Request<EC2.Types.EnableEbsEncryptionByDefaultResult, AWSError>;
  /**
   * Enables EBS encryption by default for your account in the current Region. After you enable encryption by default, the EBS volumes that you create are always encrypted, either using the default KMS key or the KMS key that you specified when you created each volume. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide. You can specify the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId. Enabling encryption by default has no effect on the encryption status of your existing volumes. After you enable encryption by default, you can no longer launch instances using instance types that do not support encryption. For more information, see Supported instance types.
   */
  enableEbsEncryptionByDefault(callback?: (err: AWSError, data: EC2.Types.EnableEbsEncryptionByDefaultResult) => void): Request<EC2.Types.EnableEbsEncryptionByDefaultResult, AWSError>;
  /**
   * When you enable faster launching for a Windows AMI, images are pre-provisioned, using snapshots to launch instances up to 65% faster. To create the optimized Windows image, Amazon EC2 launches an instance and runs through Sysprep steps, rebooting as required. Then it creates a set of reserved snapshots that are used for subsequent launches. The reserved snapshots are automatically replenished as they are used, depending on your settings for launch frequency.  To change these settings, you must own the AMI. 
   */
  enableFastLaunch(params: EC2.Types.EnableFastLaunchRequest, callback?: (err: AWSError, data: EC2.Types.EnableFastLaunchResult) => void): Request<EC2.Types.EnableFastLaunchResult, AWSError>;
  /**
   * When you enable faster launching for a Windows AMI, images are pre-provisioned, using snapshots to launch instances up to 65% faster. To create the optimized Windows image, Amazon EC2 launches an instance and runs through Sysprep steps, rebooting as required. Then it creates a set of reserved snapshots that are used for subsequent launches. The reserved snapshots are automatically replenished as they are used, depending on your settings for launch frequency.  To change these settings, you must own the AMI. 
   */
  enableFastLaunch(callback?: (err: AWSError, data: EC2.Types.EnableFastLaunchResult) => void): Request<EC2.Types.EnableFastLaunchResult, AWSError>;
  /**
   * Enables fast snapshot restores for the specified snapshots in the specified Availability Zones. You get the full benefit of fast snapshot restores after they enter the enabled state. To get the current state of fast snapshot restores, use DescribeFastSnapshotRestores. To disable fast snapshot restores, use DisableFastSnapshotRestores. For more information, see Amazon EBS fast snapshot restore in the Amazon Elastic Compute Cloud User Guide.
   */
  enableFastSnapshotRestores(params: EC2.Types.EnableFastSnapshotRestoresRequest, callback?: (err: AWSError, data: EC2.Types.EnableFastSnapshotRestoresResult) => void): Request<EC2.Types.EnableFastSnapshotRestoresResult, AWSError>;
  /**
   * Enables fast snapshot restores for the specified snapshots in the specified Availability Zones. You get the full benefit of fast snapshot restores after they enter the enabled state. To get the current state of fast snapshot restores, use DescribeFastSnapshotRestores. To disable fast snapshot restores, use DisableFastSnapshotRestores. For more information, see Amazon EBS fast snapshot restore in the Amazon Elastic Compute Cloud User Guide.
   */
  enableFastSnapshotRestores(callback?: (err: AWSError, data: EC2.Types.EnableFastSnapshotRestoresResult) => void): Request<EC2.Types.EnableFastSnapshotRestoresResult, AWSError>;
  /**
   * Enables deprecation of the specified AMI at the specified date and time. For more information, see Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  enableImageDeprecation(params: EC2.Types.EnableImageDeprecationRequest, callback?: (err: AWSError, data: EC2.Types.EnableImageDeprecationResult) => void): Request<EC2.Types.EnableImageDeprecationResult, AWSError>;
  /**
   * Enables deprecation of the specified AMI at the specified date and time. For more information, see Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.
   */
  enableImageDeprecation(callback?: (err: AWSError, data: EC2.Types.EnableImageDeprecationResult) => void): Request<EC2.Types.EnableImageDeprecationResult, AWSError>;
  /**
   * Enable an Organizations member account as the IPAM admin account. You cannot select the Organizations management account as the IPAM admin account. For more information, see Enable integration with Organizations in the Amazon VPC IPAM User Guide. 
   */
  enableIpamOrganizationAdminAccount(params: EC2.Types.EnableIpamOrganizationAdminAccountRequest, callback?: (err: AWSError, data: EC2.Types.EnableIpamOrganizationAdminAccountResult) => void): Request<EC2.Types.EnableIpamOrganizationAdminAccountResult, AWSError>;
  /**
   * Enable an Organizations member account as the IPAM admin account. You cannot select the Organizations management account as the IPAM admin account. For more information, see Enable integration with Organizations in the Amazon VPC IPAM User Guide. 
   */
  enableIpamOrganizationAdminAccount(callback?: (err: AWSError, data: EC2.Types.EnableIpamOrganizationAdminAccountResult) => void): Request<EC2.Types.EnableIpamOrganizationAdminAccountResult, AWSError>;
  /**
   * Enables access to the EC2 serial console of all instances for your account. By default, access to the EC2 serial console is disabled for your account. For more information, see Manage account access to the EC2 serial console in the Amazon EC2 User Guide.
   */
  enableSerialConsoleAccess(params: EC2.Types.EnableSerialConsoleAccessRequest, callback?: (err: AWSError, data: EC2.Types.EnableSerialConsoleAccessResult) => void): Request<EC2.Types.EnableSerialConsoleAccessResult, AWSError>;
  /**
   * Enables access to the EC2 serial console of all instances for your account. By default, access to the EC2 serial console is disabled for your account. For more information, see Manage account access to the EC2 serial console in the Amazon EC2 User Guide.
   */
  enableSerialConsoleAccess(callback?: (err: AWSError, data: EC2.Types.EnableSerialConsoleAccessResult) => void): Request<EC2.Types.EnableSerialConsoleAccessResult, AWSError>;
  /**
   * Enables the specified attachment to propagate routes to the specified propagation route table.
   */
  enableTransitGatewayRouteTablePropagation(params: EC2.Types.EnableTransitGatewayRouteTablePropagationRequest, callback?: (err: AWSError, data: EC2.Types.EnableTransitGatewayRouteTablePropagationResult) => void): Request<EC2.Types.EnableTransitGatewayRouteTablePropagationResult, AWSError>;
  /**
   * Enables the specified attachment to propagate routes to the specified propagation route table.
   */
  enableTransitGatewayRouteTablePropagation(callback?: (err: AWSError, data: EC2.Types.EnableTransitGatewayRouteTablePropagationResult) => void): Request<EC2.Types.EnableTransitGatewayRouteTablePropagationResult, AWSError>;
  /**
   * Enables a virtual private gateway (VGW) to propagate routes to the specified route table of a VPC.
   */
  enableVgwRoutePropagation(params: EC2.Types.EnableVgwRoutePropagationRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Enables a virtual private gateway (VGW) to propagate routes to the specified route table of a VPC.
   */
  enableVgwRoutePropagation(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Enables I/O operations for a volume that had I/O operations disabled because the data on the volume was potentially inconsistent.
   */
  enableVolumeIO(params: EC2.Types.EnableVolumeIORequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Enables I/O operations for a volume that had I/O operations disabled because the data on the volume was potentially inconsistent.
   */
  enableVolumeIO(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC route tables have existing routes for address ranges within the 10.0.0.0/8 IP address range, excluding local routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address ranges. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide.
   */
  enableVpcClassicLink(params: EC2.Types.EnableVpcClassicLinkRequest, callback?: (err: AWSError, data: EC2.Types.EnableVpcClassicLinkResult) => void): Request<EC2.Types.EnableVpcClassicLinkResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC route tables have existing routes for address ranges within the 10.0.0.0/8 IP address range, excluding local routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address ranges. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide.
   */
  enableVpcClassicLink(callback?: (err: AWSError, data: EC2.Types.EnableVpcClassicLinkResult) => void): Request<EC2.Types.EnableVpcClassicLinkResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide. You must specify a VPC ID in the request.
   */
  enableVpcClassicLinkDnsSupport(params: EC2.Types.EnableVpcClassicLinkDnsSupportRequest, callback?: (err: AWSError, data: EC2.Types.EnableVpcClassicLinkDnsSupportResult) => void): Request<EC2.Types.EnableVpcClassicLinkDnsSupportResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide. You must specify a VPC ID in the request.
   */
  enableVpcClassicLinkDnsSupport(callback?: (err: AWSError, data: EC2.Types.EnableVpcClassicLinkDnsSupportResult) => void): Request<EC2.Types.EnableVpcClassicLinkDnsSupportResult, AWSError>;
  /**
   * Downloads the client certificate revocation list for the specified Client VPN endpoint.
   */
  exportClientVpnClientCertificateRevocationList(params: EC2.Types.ExportClientVpnClientCertificateRevocationListRequest, callback?: (err: AWSError, data: EC2.Types.ExportClientVpnClientCertificateRevocationListResult) => void): Request<EC2.Types.ExportClientVpnClientCertificateRevocationListResult, AWSError>;
  /**
   * Downloads the client certificate revocation list for the specified Client VPN endpoint.
   */
  exportClientVpnClientCertificateRevocationList(callback?: (err: AWSError, data: EC2.Types.ExportClientVpnClientCertificateRevocationListResult) => void): Request<EC2.Types.ExportClientVpnClientCertificateRevocationListResult, AWSError>;
  /**
   * Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration file includes the Client VPN endpoint and certificate information clients need to establish a connection with the Client VPN endpoint.
   */
  exportClientVpnClientConfiguration(params: EC2.Types.ExportClientVpnClientConfigurationRequest, callback?: (err: AWSError, data: EC2.Types.ExportClientVpnClientConfigurationResult) => void): Request<EC2.Types.ExportClientVpnClientConfigurationResult, AWSError>;
  /**
   * Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration file includes the Client VPN endpoint and certificate information clients need to establish a connection with the Client VPN endpoint.
   */
  exportClientVpnClientConfiguration(callback?: (err: AWSError, data: EC2.Types.ExportClientVpnClientConfigurationResult) => void): Request<EC2.Types.ExportClientVpnClientConfigurationResult, AWSError>;
  /**
   * Exports an Amazon Machine Image (AMI) to a VM file. For more information, see Exporting a VM directly from an Amazon Machine Image (AMI) in the VM Import/Export User Guide.
   */
  exportImage(params: EC2.Types.ExportImageRequest, callback?: (err: AWSError, data: EC2.Types.ExportImageResult) => void): Request<EC2.Types.ExportImageResult, AWSError>;
  /**
   * Exports an Amazon Machine Image (AMI) to a VM file. For more information, see Exporting a VM directly from an Amazon Machine Image (AMI) in the VM Import/Export User Guide.
   */
  exportImage(callback?: (err: AWSError, data: EC2.Types.ExportImageResult) => void): Request<EC2.Types.ExportImageResult, AWSError>;
  /**
   * Exports routes from the specified transit gateway route table to the specified S3 bucket. By default, all routes are exported. Alternatively, you can filter by CIDR range. The routes are saved to the specified bucket in a JSON file. For more information, see Export Route Tables to Amazon S3 in Transit Gateways.
   */
  exportTransitGatewayRoutes(params: EC2.Types.ExportTransitGatewayRoutesRequest, callback?: (err: AWSError, data: EC2.Types.ExportTransitGatewayRoutesResult) => void): Request<EC2.Types.ExportTransitGatewayRoutesResult, AWSError>;
  /**
   * Exports routes from the specified transit gateway route table to the specified S3 bucket. By default, all routes are exported. Alternatively, you can filter by CIDR range. The routes are saved to the specified bucket in a JSON file. For more information, see Export Route Tables to Amazon S3 in Transit Gateways.
   */
  exportTransitGatewayRoutes(callback?: (err: AWSError, data: EC2.Types.ExportTransitGatewayRoutesResult) => void): Request<EC2.Types.ExportTransitGatewayRoutesResult, AWSError>;
  /**
   * Returns the IAM roles that are associated with the specified ACM (ACM) certificate. It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key that's used to encrypt the private key.
   */
  getAssociatedEnclaveCertificateIamRoles(params: EC2.Types.GetAssociatedEnclaveCertificateIamRolesRequest, callback?: (err: AWSError, data: EC2.Types.GetAssociatedEnclaveCertificateIamRolesResult) => void): Request<EC2.Types.GetAssociatedEnclaveCertificateIamRolesResult, AWSError>;
  /**
   * Returns the IAM roles that are associated with the specified ACM (ACM) certificate. It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key that's used to encrypt the private key.
   */
  getAssociatedEnclaveCertificateIamRoles(callback?: (err: AWSError, data: EC2.Types.GetAssociatedEnclaveCertificateIamRolesResult) => void): Request<EC2.Types.GetAssociatedEnclaveCertificateIamRolesResult, AWSError>;
  /**
   * Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.
   */
  getAssociatedIpv6PoolCidrs(params: EC2.Types.GetAssociatedIpv6PoolCidrsRequest, callback?: (err: AWSError, data: EC2.Types.GetAssociatedIpv6PoolCidrsResult) => void): Request<EC2.Types.GetAssociatedIpv6PoolCidrsResult, AWSError>;
  /**
   * Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.
   */
  getAssociatedIpv6PoolCidrs(callback?: (err: AWSError, data: EC2.Types.GetAssociatedIpv6PoolCidrsResult) => void): Request<EC2.Types.GetAssociatedIpv6PoolCidrsResult, AWSError>;
  /**
   * Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared, it shows usage information for the Capacity Reservation owner and each Amazon Web Services account that is currently using the shared capacity. If the Capacity Reservation is not shared, it shows only the Capacity Reservation owner's usage.
   */
  getCapacityReservationUsage(params: EC2.Types.GetCapacityReservationUsageRequest, callback?: (err: AWSError, data: EC2.Types.GetCapacityReservationUsageResult) => void): Request<EC2.Types.GetCapacityReservationUsageResult, AWSError>;
  /**
   * Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared, it shows usage information for the Capacity Reservation owner and each Amazon Web Services account that is currently using the shared capacity. If the Capacity Reservation is not shared, it shows only the Capacity Reservation owner's usage.
   */
  getCapacityReservationUsage(callback?: (err: AWSError, data: EC2.Types.GetCapacityReservationUsageResult) => void): Request<EC2.Types.GetCapacityReservationUsageResult, AWSError>;
  /**
   * Describes the allocations from the specified customer-owned address pool.
   */
  getCoipPoolUsage(params: EC2.Types.GetCoipPoolUsageRequest, callback?: (err: AWSError, data: EC2.Types.GetCoipPoolUsageResult) => void): Request<EC2.Types.GetCoipPoolUsageResult, AWSError>;
  /**
   * Describes the allocations from the specified customer-owned address pool.
   */
  getCoipPoolUsage(callback?: (err: AWSError, data: EC2.Types.GetCoipPoolUsageResult) => void): Request<EC2.Types.GetCoipPoolUsageResult, AWSError>;
  /**
   * Gets the console output for the specified instance. For Linux instances, the instance console output displays the exact console output that would normally be displayed on a physical monitor attached to a computer. For Windows instances, the instance console output includes the last three system event log errors. By default, the console output returns buffered information that was posted shortly after an instance transition state (start, stop, reboot, or terminate). This information is available for at least one hour after the most recent post. Only the most recent 64 KB of console output is available. You can optionally retrieve the latest serial console output at any time during the instance lifecycle. This option is supported on instance types that use the Nitro hypervisor. For more information, see Instance console output in the Amazon EC2 User Guide.
   */
  getConsoleOutput(params: EC2.Types.GetConsoleOutputRequest, callback?: (err: AWSError, data: EC2.Types.GetConsoleOutputResult) => void): Request<EC2.Types.GetConsoleOutputResult, AWSError>;
  /**
   * Gets the console output for the specified instance. For Linux instances, the instance console output displays the exact console output that would normally be displayed on a physical monitor attached to a computer. For Windows instances, the instance console output includes the last three system event log errors. By default, the console output returns buffered information that was posted shortly after an instance transition state (start, stop, reboot, or terminate). This information is available for at least one hour after the most recent post. Only the most recent 64 KB of console output is available. You can optionally retrieve the latest serial console output at any time during the instance lifecycle. This option is supported on instance types that use the Nitro hypervisor. For more information, see Instance console output in the Amazon EC2 User Guide.
   */
  getConsoleOutput(callback?: (err: AWSError, data: EC2.Types.GetConsoleOutputResult) => void): Request<EC2.Types.GetConsoleOutputResult, AWSError>;
  /**
   * Retrieve a JPG-format screenshot of a running instance to help with troubleshooting. The returned content is Base64-encoded.
   */
  getConsoleScreenshot(params: EC2.Types.GetConsoleScreenshotRequest, callback?: (err: AWSError, data: EC2.Types.GetConsoleScreenshotResult) => void): Request<EC2.Types.GetConsoleScreenshotResult, AWSError>;
  /**
   * Retrieve a JPG-format screenshot of a running instance to help with troubleshooting. The returned content is Base64-encoded.
   */
  getConsoleScreenshot(callback?: (err: AWSError, data: EC2.Types.GetConsoleScreenshotResult) => void): Request<EC2.Types.GetConsoleScreenshotResult, AWSError>;
  /**
   * Describes the default credit option for CPU usage of a burstable performance instance family. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  getDefaultCreditSpecification(params: EC2.Types.GetDefaultCreditSpecificationRequest, callback?: (err: AWSError, data: EC2.Types.GetDefaultCreditSpecificationResult) => void): Request<EC2.Types.GetDefaultCreditSpecificationResult, AWSError>;
  /**
   * Describes the default credit option for CPU usage of a burstable performance instance family. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  getDefaultCreditSpecification(callback?: (err: AWSError, data: EC2.Types.GetDefaultCreditSpecificationResult) => void): Request<EC2.Types.GetDefaultCreditSpecificationResult, AWSError>;
  /**
   * Describes the default KMS key for EBS encryption by default for your account in this Region. You can change the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  getEbsDefaultKmsKeyId(params: EC2.Types.GetEbsDefaultKmsKeyIdRequest, callback?: (err: AWSError, data: EC2.Types.GetEbsDefaultKmsKeyIdResult) => void): Request<EC2.Types.GetEbsDefaultKmsKeyIdResult, AWSError>;
  /**
   * Describes the default KMS key for EBS encryption by default for your account in this Region. You can change the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  getEbsDefaultKmsKeyId(callback?: (err: AWSError, data: EC2.Types.GetEbsDefaultKmsKeyIdResult) => void): Request<EC2.Types.GetEbsDefaultKmsKeyIdResult, AWSError>;
  /**
   * Describes whether EBS encryption by default is enabled for your account in the current Region. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  getEbsEncryptionByDefault(params: EC2.Types.GetEbsEncryptionByDefaultRequest, callback?: (err: AWSError, data: EC2.Types.GetEbsEncryptionByDefaultResult) => void): Request<EC2.Types.GetEbsEncryptionByDefaultResult, AWSError>;
  /**
   * Describes whether EBS encryption by default is enabled for your account in the current Region. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  getEbsEncryptionByDefault(callback?: (err: AWSError, data: EC2.Types.GetEbsEncryptionByDefaultResult) => void): Request<EC2.Types.GetEbsEncryptionByDefaultResult, AWSError>;
  /**
   * Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data. Based on the information that you provide, we configure resources in the template to do the following:   Create a table in Athena that maps fields to a custom log format   Create a Lambda function that updates the table with new partitions on a daily, weekly, or monthly basis   Create a table partitioned between two timestamps in the past   Create a set of named queries in Athena that you can use to get started quickly  
   */
  getFlowLogsIntegrationTemplate(params: EC2.Types.GetFlowLogsIntegrationTemplateRequest, callback?: (err: AWSError, data: EC2.Types.GetFlowLogsIntegrationTemplateResult) => void): Request<EC2.Types.GetFlowLogsIntegrationTemplateResult, AWSError>;
  /**
   * Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data. Based on the information that you provide, we configure resources in the template to do the following:   Create a table in Athena that maps fields to a custom log format   Create a Lambda function that updates the table with new partitions on a daily, weekly, or monthly basis   Create a table partitioned between two timestamps in the past   Create a set of named queries in Athena that you can use to get started quickly  
   */
  getFlowLogsIntegrationTemplate(callback?: (err: AWSError, data: EC2.Types.GetFlowLogsIntegrationTemplateResult) => void): Request<EC2.Types.GetFlowLogsIntegrationTemplateResult, AWSError>;
  /**
   * Lists the resource groups to which a Capacity Reservation has been added.
   */
  getGroupsForCapacityReservation(params: EC2.Types.GetGroupsForCapacityReservationRequest, callback?: (err: AWSError, data: EC2.Types.GetGroupsForCapacityReservationResult) => void): Request<EC2.Types.GetGroupsForCapacityReservationResult, AWSError>;
  /**
   * Lists the resource groups to which a Capacity Reservation has been added.
   */
  getGroupsForCapacityReservation(callback?: (err: AWSError, data: EC2.Types.GetGroupsForCapacityReservationResult) => void): Request<EC2.Types.GetGroupsForCapacityReservationResult, AWSError>;
  /**
   * Preview a reservation purchase with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This is a preview of the PurchaseHostReservation action and does not result in the offering being purchased.
   */
  getHostReservationPurchasePreview(params: EC2.Types.GetHostReservationPurchasePreviewRequest, callback?: (err: AWSError, data: EC2.Types.GetHostReservationPurchasePreviewResult) => void): Request<EC2.Types.GetHostReservationPurchasePreviewResult, AWSError>;
  /**
   * Preview a reservation purchase with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This is a preview of the PurchaseHostReservation action and does not result in the offering being purchased.
   */
  getHostReservationPurchasePreview(callback?: (err: AWSError, data: EC2.Types.GetHostReservationPurchasePreviewResult) => void): Request<EC2.Types.GetHostReservationPurchasePreviewResult, AWSError>;
  /**
   * Returns a list of instance types with the specified instance attributes. You can use the response to preview the instance types without launching instances. Note that the response does not consider capacity. When you specify multiple parameters, you get instance types that satisfy all of the specified parameters. If you specify multiple values for a parameter, you get instance types that satisfy any of the specified values. For more information, see Preview instance types with specified attributes, Attribute-based instance type selection for EC2 Fleet, Attribute-based instance type selection for Spot Fleet, and Spot placement score in the Amazon EC2 User Guide, and Creating an Auto Scaling group using attribute-based instance type selection in the Amazon EC2 Auto Scaling User Guide.
   */
  getInstanceTypesFromInstanceRequirements(params: EC2.Types.GetInstanceTypesFromInstanceRequirementsRequest, callback?: (err: AWSError, data: EC2.Types.GetInstanceTypesFromInstanceRequirementsResult) => void): Request<EC2.Types.GetInstanceTypesFromInstanceRequirementsResult, AWSError>;
  /**
   * Returns a list of instance types with the specified instance attributes. You can use the response to preview the instance types without launching instances. Note that the response does not consider capacity. When you specify multiple parameters, you get instance types that satisfy all of the specified parameters. If you specify multiple values for a parameter, you get instance types that satisfy any of the specified values. For more information, see Preview instance types with specified attributes, Attribute-based instance type selection for EC2 Fleet, Attribute-based instance type selection for Spot Fleet, and Spot placement score in the Amazon EC2 User Guide, and Creating an Auto Scaling group using attribute-based instance type selection in the Amazon EC2 Auto Scaling User Guide.
   */
  getInstanceTypesFromInstanceRequirements(callback?: (err: AWSError, data: EC2.Types.GetInstanceTypesFromInstanceRequirementsResult) => void): Request<EC2.Types.GetInstanceTypesFromInstanceRequirementsResult, AWSError>;
  /**
   * A binary representation of the UEFI variable store. Only non-volatile variables are stored. This is a base64 encoded and zlib compressed binary value that must be properly encoded. When you use register-image to create an AMI, you can create an exact copy of your variable store by passing the UEFI data in the UefiData parameter. You can modify the UEFI data by using the python-uefivars tool on GitHub. You can use the tool to convert the UEFI data into a human-readable format (JSON), which you can inspect and modify, and then convert back into the binary format to use with register-image. For more information, see UEFI Secure Boot in the Amazon EC2 User Guide.
   */
  getInstanceUefiData(params: EC2.Types.GetInstanceUefiDataRequest, callback?: (err: AWSError, data: EC2.Types.GetInstanceUefiDataResult) => void): Request<EC2.Types.GetInstanceUefiDataResult, AWSError>;
  /**
   * A binary representation of the UEFI variable store. Only non-volatile variables are stored. This is a base64 encoded and zlib compressed binary value that must be properly encoded. When you use register-image to create an AMI, you can create an exact copy of your variable store by passing the UEFI data in the UefiData parameter. You can modify the UEFI data by using the python-uefivars tool on GitHub. You can use the tool to convert the UEFI data into a human-readable format (JSON), which you can inspect and modify, and then convert back into the binary format to use with register-image. For more information, see UEFI Secure Boot in the Amazon EC2 User Guide.
   */
  getInstanceUefiData(callback?: (err: AWSError, data: EC2.Types.GetInstanceUefiDataResult) => void): Request<EC2.Types.GetInstanceUefiDataResult, AWSError>;
  /**
   * Retrieve historical information about a CIDR within an IPAM scope. For more information, see View the history of IP addresses in the Amazon VPC IPAM User Guide.
   */
  getIpamAddressHistory(params: EC2.Types.GetIpamAddressHistoryRequest, callback?: (err: AWSError, data: EC2.Types.GetIpamAddressHistoryResult) => void): Request<EC2.Types.GetIpamAddressHistoryResult, AWSError>;
  /**
   * Retrieve historical information about a CIDR within an IPAM scope. For more information, see View the history of IP addresses in the Amazon VPC IPAM User Guide.
   */
  getIpamAddressHistory(callback?: (err: AWSError, data: EC2.Types.GetIpamAddressHistoryResult) => void): Request<EC2.Types.GetIpamAddressHistoryResult, AWSError>;
  /**
   * Get a list of all the CIDR allocations in an IPAM pool.
   */
  getIpamPoolAllocations(params: EC2.Types.GetIpamPoolAllocationsRequest, callback?: (err: AWSError, data: EC2.Types.GetIpamPoolAllocationsResult) => void): Request<EC2.Types.GetIpamPoolAllocationsResult, AWSError>;
  /**
   * Get a list of all the CIDR allocations in an IPAM pool.
   */
  getIpamPoolAllocations(callback?: (err: AWSError, data: EC2.Types.GetIpamPoolAllocationsResult) => void): Request<EC2.Types.GetIpamPoolAllocationsResult, AWSError>;
  /**
   * Get the CIDRs provisioned to an IPAM pool.
   */
  getIpamPoolCidrs(params: EC2.Types.GetIpamPoolCidrsRequest, callback?: (err: AWSError, data: EC2.Types.GetIpamPoolCidrsResult) => void): Request<EC2.Types.GetIpamPoolCidrsResult, AWSError>;
  /**
   * Get the CIDRs provisioned to an IPAM pool.
   */
  getIpamPoolCidrs(callback?: (err: AWSError, data: EC2.Types.GetIpamPoolCidrsResult) => void): Request<EC2.Types.GetIpamPoolCidrsResult, AWSError>;
  /**
   * Get information about the resources in a scope.
   */
  getIpamResourceCidrs(params: EC2.Types.GetIpamResourceCidrsRequest, callback?: (err: AWSError, data: EC2.Types.GetIpamResourceCidrsResult) => void): Request<EC2.Types.GetIpamResourceCidrsResult, AWSError>;
  /**
   * Get information about the resources in a scope.
   */
  getIpamResourceCidrs(callback?: (err: AWSError, data: EC2.Types.GetIpamResourceCidrsResult) => void): Request<EC2.Types.GetIpamResourceCidrsResult, AWSError>;
  /**
   * Retrieves the configuration data of the specified instance. You can use this data to create a launch template.  This action calls on other describe actions to get instance information. Depending on your instance configuration, you may need to allow the following actions in your IAM policy: DescribeSpotInstanceRequests, DescribeInstanceCreditSpecifications, DescribeVolumes, DescribeInstanceAttribute, and DescribeElasticGpus. Or, you can allow describe* depending on your instance requirements.
   */
  getLaunchTemplateData(params: EC2.Types.GetLaunchTemplateDataRequest, callback?: (err: AWSError, data: EC2.Types.GetLaunchTemplateDataResult) => void): Request<EC2.Types.GetLaunchTemplateDataResult, AWSError>;
  /**
   * Retrieves the configuration data of the specified instance. You can use this data to create a launch template.  This action calls on other describe actions to get instance information. Depending on your instance configuration, you may need to allow the following actions in your IAM policy: DescribeSpotInstanceRequests, DescribeInstanceCreditSpecifications, DescribeVolumes, DescribeInstanceAttribute, and DescribeElasticGpus. Or, you can allow describe* depending on your instance requirements.
   */
  getLaunchTemplateData(callback?: (err: AWSError, data: EC2.Types.GetLaunchTemplateDataResult) => void): Request<EC2.Types.GetLaunchTemplateDataResult, AWSError>;
  /**
   * Gets information about the resources that are associated with the specified managed prefix list.
   */
  getManagedPrefixListAssociations(params: EC2.Types.GetManagedPrefixListAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.GetManagedPrefixListAssociationsResult) => void): Request<EC2.Types.GetManagedPrefixListAssociationsResult, AWSError>;
  /**
   * Gets information about the resources that are associated with the specified managed prefix list.
   */
  getManagedPrefixListAssociations(callback?: (err: AWSError, data: EC2.Types.GetManagedPrefixListAssociationsResult) => void): Request<EC2.Types.GetManagedPrefixListAssociationsResult, AWSError>;
  /**
   * Gets information about the entries for a specified managed prefix list.
   */
  getManagedPrefixListEntries(params: EC2.Types.GetManagedPrefixListEntriesRequest, callback?: (err: AWSError, data: EC2.Types.GetManagedPrefixListEntriesResult) => void): Request<EC2.Types.GetManagedPrefixListEntriesResult, AWSError>;
  /**
   * Gets information about the entries for a specified managed prefix list.
   */
  getManagedPrefixListEntries(callback?: (err: AWSError, data: EC2.Types.GetManagedPrefixListEntriesResult) => void): Request<EC2.Types.GetManagedPrefixListEntriesResult, AWSError>;
  /**
   * Gets the findings for the specified Network Access Scope analysis.
   */
  getNetworkInsightsAccessScopeAnalysisFindings(params: EC2.Types.GetNetworkInsightsAccessScopeAnalysisFindingsRequest, callback?: (err: AWSError, data: EC2.Types.GetNetworkInsightsAccessScopeAnalysisFindingsResult) => void): Request<EC2.Types.GetNetworkInsightsAccessScopeAnalysisFindingsResult, AWSError>;
  /**
   * Gets the findings for the specified Network Access Scope analysis.
   */
  getNetworkInsightsAccessScopeAnalysisFindings(callback?: (err: AWSError, data: EC2.Types.GetNetworkInsightsAccessScopeAnalysisFindingsResult) => void): Request<EC2.Types.GetNetworkInsightsAccessScopeAnalysisFindingsResult, AWSError>;
  /**
   * Gets the content for the specified Network Access Scope.
   */
  getNetworkInsightsAccessScopeContent(params: EC2.Types.GetNetworkInsightsAccessScopeContentRequest, callback?: (err: AWSError, data: EC2.Types.GetNetworkInsightsAccessScopeContentResult) => void): Request<EC2.Types.GetNetworkInsightsAccessScopeContentResult, AWSError>;
  /**
   * Gets the content for the specified Network Access Scope.
   */
  getNetworkInsightsAccessScopeContent(callback?: (err: AWSError, data: EC2.Types.GetNetworkInsightsAccessScopeContentResult) => void): Request<EC2.Types.GetNetworkInsightsAccessScopeContentResult, AWSError>;
  /**
   * Retrieves the encrypted administrator password for a running Windows instance. The Windows password is generated at boot by the EC2Config service or EC2Launch scripts (Windows Server 2016 and later). This usually only happens the first time an instance is launched. For more information, see EC2Config and EC2Launch in the Amazon EC2 User Guide. For the EC2Config service, the password is not generated for rebundled AMIs unless Ec2SetPassword is enabled before bundling. The password is encrypted using the key pair that you specified when you launched the instance. You must provide the corresponding key pair file. When you launch an instance, password generation and encryption may take a few minutes. If you try to retrieve the password before it's available, the output returns an empty string. We recommend that you wait up to 15 minutes after launching an instance before trying to retrieve the generated password.
   */
  getPasswordData(params: EC2.Types.GetPasswordDataRequest, callback?: (err: AWSError, data: EC2.Types.GetPasswordDataResult) => void): Request<EC2.Types.GetPasswordDataResult, AWSError>;
  /**
   * Retrieves the encrypted administrator password for a running Windows instance. The Windows password is generated at boot by the EC2Config service or EC2Launch scripts (Windows Server 2016 and later). This usually only happens the first time an instance is launched. For more information, see EC2Config and EC2Launch in the Amazon EC2 User Guide. For the EC2Config service, the password is not generated for rebundled AMIs unless Ec2SetPassword is enabled before bundling. The password is encrypted using the key pair that you specified when you launched the instance. You must provide the corresponding key pair file. When you launch an instance, password generation and encryption may take a few minutes. If you try to retrieve the password before it's available, the output returns an empty string. We recommend that you wait up to 15 minutes after launching an instance before trying to retrieve the generated password.
   */
  getPasswordData(callback?: (err: AWSError, data: EC2.Types.GetPasswordDataResult) => void): Request<EC2.Types.GetPasswordDataResult, AWSError>;
  /**
   * Returns a quote and exchange information for exchanging one or more specified Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange cannot be performed, the reason is returned in the response. Use AcceptReservedInstancesExchangeQuote to perform the exchange.
   */
  getReservedInstancesExchangeQuote(params: EC2.Types.GetReservedInstancesExchangeQuoteRequest, callback?: (err: AWSError, data: EC2.Types.GetReservedInstancesExchangeQuoteResult) => void): Request<EC2.Types.GetReservedInstancesExchangeQuoteResult, AWSError>;
  /**
   * Returns a quote and exchange information for exchanging one or more specified Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange cannot be performed, the reason is returned in the response. Use AcceptReservedInstancesExchangeQuote to perform the exchange.
   */
  getReservedInstancesExchangeQuote(callback?: (err: AWSError, data: EC2.Types.GetReservedInstancesExchangeQuoteResult) => void): Request<EC2.Types.GetReservedInstancesExchangeQuoteResult, AWSError>;
  /**
   * Retrieves the access status of your account to the EC2 serial console of all instances. By default, access to the EC2 serial console is disabled for your account. For more information, see Manage account access to the EC2 serial console in the Amazon EC2 User Guide.
   */
  getSerialConsoleAccessStatus(params: EC2.Types.GetSerialConsoleAccessStatusRequest, callback?: (err: AWSError, data: EC2.Types.GetSerialConsoleAccessStatusResult) => void): Request<EC2.Types.GetSerialConsoleAccessStatusResult, AWSError>;
  /**
   * Retrieves the access status of your account to the EC2 serial console of all instances. By default, access to the EC2 serial console is disabled for your account. For more information, see Manage account access to the EC2 serial console in the Amazon EC2 User Guide.
   */
  getSerialConsoleAccessStatus(callback?: (err: AWSError, data: EC2.Types.GetSerialConsoleAccessStatusResult) => void): Request<EC2.Types.GetSerialConsoleAccessStatusResult, AWSError>;
  /**
   * Calculates the Spot placement score for a Region or Availability Zone based on the specified target capacity and compute requirements. You can specify your compute requirements either by using InstanceRequirementsWithMetadata and letting Amazon EC2 choose the optimal instance types to fulfill your Spot request, or you can specify the instance types by using InstanceTypes. For more information, see Spot placement score in the Amazon EC2 User Guide.
   */
  getSpotPlacementScores(params: EC2.Types.GetSpotPlacementScoresRequest, callback?: (err: AWSError, data: EC2.Types.GetSpotPlacementScoresResult) => void): Request<EC2.Types.GetSpotPlacementScoresResult, AWSError>;
  /**
   * Calculates the Spot placement score for a Region or Availability Zone based on the specified target capacity and compute requirements. You can specify your compute requirements either by using InstanceRequirementsWithMetadata and letting Amazon EC2 choose the optimal instance types to fulfill your Spot request, or you can specify the instance types by using InstanceTypes. For more information, see Spot placement score in the Amazon EC2 User Guide.
   */
  getSpotPlacementScores(callback?: (err: AWSError, data: EC2.Types.GetSpotPlacementScoresResult) => void): Request<EC2.Types.GetSpotPlacementScoresResult, AWSError>;
  /**
   * Gets information about the subnet CIDR reservations.
   */
  getSubnetCidrReservations(params: EC2.Types.GetSubnetCidrReservationsRequest, callback?: (err: AWSError, data: EC2.Types.GetSubnetCidrReservationsResult) => void): Request<EC2.Types.GetSubnetCidrReservationsResult, AWSError>;
  /**
   * Gets information about the subnet CIDR reservations.
   */
  getSubnetCidrReservations(callback?: (err: AWSError, data: EC2.Types.GetSubnetCidrReservationsResult) => void): Request<EC2.Types.GetSubnetCidrReservationsResult, AWSError>;
  /**
   * Lists the route tables to which the specified resource attachment propagates routes.
   */
  getTransitGatewayAttachmentPropagations(params: EC2.Types.GetTransitGatewayAttachmentPropagationsRequest, callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayAttachmentPropagationsResult) => void): Request<EC2.Types.GetTransitGatewayAttachmentPropagationsResult, AWSError>;
  /**
   * Lists the route tables to which the specified resource attachment propagates routes.
   */
  getTransitGatewayAttachmentPropagations(callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayAttachmentPropagationsResult) => void): Request<EC2.Types.GetTransitGatewayAttachmentPropagationsResult, AWSError>;
  /**
   * Gets information about the associations for the transit gateway multicast domain.
   */
  getTransitGatewayMulticastDomainAssociations(params: EC2.Types.GetTransitGatewayMulticastDomainAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayMulticastDomainAssociationsResult) => void): Request<EC2.Types.GetTransitGatewayMulticastDomainAssociationsResult, AWSError>;
  /**
   * Gets information about the associations for the transit gateway multicast domain.
   */
  getTransitGatewayMulticastDomainAssociations(callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayMulticastDomainAssociationsResult) => void): Request<EC2.Types.GetTransitGatewayMulticastDomainAssociationsResult, AWSError>;
  /**
   * Gets a list of the transit gateway policy table associations.
   */
  getTransitGatewayPolicyTableAssociations(params: EC2.Types.GetTransitGatewayPolicyTableAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayPolicyTableAssociationsResult) => void): Request<EC2.Types.GetTransitGatewayPolicyTableAssociationsResult, AWSError>;
  /**
   * Gets a list of the transit gateway policy table associations.
   */
  getTransitGatewayPolicyTableAssociations(callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayPolicyTableAssociationsResult) => void): Request<EC2.Types.GetTransitGatewayPolicyTableAssociationsResult, AWSError>;
  /**
   * Returns a list of transit gateway policy table entries.
   */
  getTransitGatewayPolicyTableEntries(params: EC2.Types.GetTransitGatewayPolicyTableEntriesRequest, callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayPolicyTableEntriesResult) => void): Request<EC2.Types.GetTransitGatewayPolicyTableEntriesResult, AWSError>;
  /**
   * Returns a list of transit gateway policy table entries.
   */
  getTransitGatewayPolicyTableEntries(callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayPolicyTableEntriesResult) => void): Request<EC2.Types.GetTransitGatewayPolicyTableEntriesResult, AWSError>;
  /**
   * Gets information about the prefix list references in a specified transit gateway route table.
   */
  getTransitGatewayPrefixListReferences(params: EC2.Types.GetTransitGatewayPrefixListReferencesRequest, callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayPrefixListReferencesResult) => void): Request<EC2.Types.GetTransitGatewayPrefixListReferencesResult, AWSError>;
  /**
   * Gets information about the prefix list references in a specified transit gateway route table.
   */
  getTransitGatewayPrefixListReferences(callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayPrefixListReferencesResult) => void): Request<EC2.Types.GetTransitGatewayPrefixListReferencesResult, AWSError>;
  /**
   * Gets information about the associations for the specified transit gateway route table.
   */
  getTransitGatewayRouteTableAssociations(params: EC2.Types.GetTransitGatewayRouteTableAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayRouteTableAssociationsResult) => void): Request<EC2.Types.GetTransitGatewayRouteTableAssociationsResult, AWSError>;
  /**
   * Gets information about the associations for the specified transit gateway route table.
   */
  getTransitGatewayRouteTableAssociations(callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayRouteTableAssociationsResult) => void): Request<EC2.Types.GetTransitGatewayRouteTableAssociationsResult, AWSError>;
  /**
   * Gets information about the route table propagations for the specified transit gateway route table.
   */
  getTransitGatewayRouteTablePropagations(params: EC2.Types.GetTransitGatewayRouteTablePropagationsRequest, callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayRouteTablePropagationsResult) => void): Request<EC2.Types.GetTransitGatewayRouteTablePropagationsResult, AWSError>;
  /**
   * Gets information about the route table propagations for the specified transit gateway route table.
   */
  getTransitGatewayRouteTablePropagations(callback?: (err: AWSError, data: EC2.Types.GetTransitGatewayRouteTablePropagationsResult) => void): Request<EC2.Types.GetTransitGatewayRouteTablePropagationsResult, AWSError>;
  /**
   * Download an Amazon Web Services-provided sample configuration file to be used with the customer gateway device specified for your Site-to-Site VPN connection.
   */
  getVpnConnectionDeviceSampleConfiguration(params: EC2.Types.GetVpnConnectionDeviceSampleConfigurationRequest, callback?: (err: AWSError, data: EC2.Types.GetVpnConnectionDeviceSampleConfigurationResult) => void): Request<EC2.Types.GetVpnConnectionDeviceSampleConfigurationResult, AWSError>;
  /**
   * Download an Amazon Web Services-provided sample configuration file to be used with the customer gateway device specified for your Site-to-Site VPN connection.
   */
  getVpnConnectionDeviceSampleConfiguration(callback?: (err: AWSError, data: EC2.Types.GetVpnConnectionDeviceSampleConfigurationResult) => void): Request<EC2.Types.GetVpnConnectionDeviceSampleConfigurationResult, AWSError>;
  /**
   * Obtain a list of customer gateway devices for which sample configuration files can be provided. The request has no additional parameters. You can also see the list of device types with sample configuration files available under Your customer gateway device in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  getVpnConnectionDeviceTypes(params: EC2.Types.GetVpnConnectionDeviceTypesRequest, callback?: (err: AWSError, data: EC2.Types.GetVpnConnectionDeviceTypesResult) => void): Request<EC2.Types.GetVpnConnectionDeviceTypesResult, AWSError>;
  /**
   * Obtain a list of customer gateway devices for which sample configuration files can be provided. The request has no additional parameters. You can also see the list of device types with sample configuration files available under Your customer gateway device in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  getVpnConnectionDeviceTypes(callback?: (err: AWSError, data: EC2.Types.GetVpnConnectionDeviceTypesResult) => void): Request<EC2.Types.GetVpnConnectionDeviceTypesResult, AWSError>;
  /**
   * Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list. Uploading a client certificate revocation list resets existing client connections.
   */
  importClientVpnClientCertificateRevocationList(params: EC2.Types.ImportClientVpnClientCertificateRevocationListRequest, callback?: (err: AWSError, data: EC2.Types.ImportClientVpnClientCertificateRevocationListResult) => void): Request<EC2.Types.ImportClientVpnClientCertificateRevocationListResult, AWSError>;
  /**
   * Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list. Uploading a client certificate revocation list resets existing client connections.
   */
  importClientVpnClientCertificateRevocationList(callback?: (err: AWSError, data: EC2.Types.ImportClientVpnClientCertificateRevocationListResult) => void): Request<EC2.Types.ImportClientVpnClientCertificateRevocationListResult, AWSError>;
  /**
   * Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI).  Amazon Web Services VM Import/Export strongly recommends specifying a value for either the --license-type or --usage-operation parameter when you create a new VM Import task. This ensures your operating system is licensed appropriately and your billing is optimized.  For more information, see Importing a VM as an image using VM Import/Export in the VM Import/Export User Guide.
   */
  importImage(params: EC2.Types.ImportImageRequest, callback?: (err: AWSError, data: EC2.Types.ImportImageResult) => void): Request<EC2.Types.ImportImageResult, AWSError>;
  /**
   * Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI).  Amazon Web Services VM Import/Export strongly recommends specifying a value for either the --license-type or --usage-operation parameter when you create a new VM Import task. This ensures your operating system is licensed appropriately and your billing is optimized.  For more information, see Importing a VM as an image using VM Import/Export in the VM Import/Export User Guide.
   */
  importImage(callback?: (err: AWSError, data: EC2.Types.ImportImageResult) => void): Request<EC2.Types.ImportImageResult, AWSError>;
  /**
   * Creates an import instance task using metadata from the specified disk image. This API action supports only single-volume VMs. To import multi-volume VMs, use ImportImage instead. This API action is not supported by the Command Line Interface (CLI). For information about using the Amazon EC2 CLI, which is deprecated, see Importing a VM to Amazon EC2 in the Amazon EC2 CLI Reference PDF file. For information about the import manifest referenced by this API action, see VM Import Manifest.
   */
  importInstance(params: EC2.Types.ImportInstanceRequest, callback?: (err: AWSError, data: EC2.Types.ImportInstanceResult) => void): Request<EC2.Types.ImportInstanceResult, AWSError>;
  /**
   * Creates an import instance task using metadata from the specified disk image. This API action supports only single-volume VMs. To import multi-volume VMs, use ImportImage instead. This API action is not supported by the Command Line Interface (CLI). For information about using the Amazon EC2 CLI, which is deprecated, see Importing a VM to Amazon EC2 in the Amazon EC2 CLI Reference PDF file. For information about the import manifest referenced by this API action, see VM Import Manifest.
   */
  importInstance(callback?: (err: AWSError, data: EC2.Types.ImportInstanceResult) => void): Request<EC2.Types.ImportInstanceResult, AWSError>;
  /**
   * Imports the public key from an RSA or ED25519 key pair that you created with a third-party tool. Compare this with CreateKeyPair, in which Amazon Web Services creates the key pair and gives the keys to you (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key. The private key is never transferred between you and Amazon Web Services. For more information about key pairs, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.
   */
  importKeyPair(params: EC2.Types.ImportKeyPairRequest, callback?: (err: AWSError, data: EC2.Types.ImportKeyPairResult) => void): Request<EC2.Types.ImportKeyPairResult, AWSError>;
  /**
   * Imports the public key from an RSA or ED25519 key pair that you created with a third-party tool. Compare this with CreateKeyPair, in which Amazon Web Services creates the key pair and gives the keys to you (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key. The private key is never transferred between you and Amazon Web Services. For more information about key pairs, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.
   */
  importKeyPair(callback?: (err: AWSError, data: EC2.Types.ImportKeyPairResult) => void): Request<EC2.Types.ImportKeyPairResult, AWSError>;
  /**
   * Imports a disk into an EBS snapshot. For more information, see Importing a disk as a snapshot using VM Import/Export in the VM Import/Export User Guide.
   */
  importSnapshot(params: EC2.Types.ImportSnapshotRequest, callback?: (err: AWSError, data: EC2.Types.ImportSnapshotResult) => void): Request<EC2.Types.ImportSnapshotResult, AWSError>;
  /**
   * Imports a disk into an EBS snapshot. For more information, see Importing a disk as a snapshot using VM Import/Export in the VM Import/Export User Guide.
   */
  importSnapshot(callback?: (err: AWSError, data: EC2.Types.ImportSnapshotResult) => void): Request<EC2.Types.ImportSnapshotResult, AWSError>;
  /**
   * Creates an import volume task using metadata from the specified disk image. This API action supports only single-volume VMs. To import multi-volume VMs, use ImportImage instead. To import a disk to a snapshot, use ImportSnapshot instead. This API action is not supported by the Command Line Interface (CLI). For information about using the Amazon EC2 CLI, which is deprecated, see Importing Disks to Amazon EBS in the Amazon EC2 CLI Reference PDF file. For information about the import manifest referenced by this API action, see VM Import Manifest.
   */
  importVolume(params: EC2.Types.ImportVolumeRequest, callback?: (err: AWSError, data: EC2.Types.ImportVolumeResult) => void): Request<EC2.Types.ImportVolumeResult, AWSError>;
  /**
   * Creates an import volume task using metadata from the specified disk image. This API action supports only single-volume VMs. To import multi-volume VMs, use ImportImage instead. To import a disk to a snapshot, use ImportSnapshot instead. This API action is not supported by the Command Line Interface (CLI). For information about using the Amazon EC2 CLI, which is deprecated, see Importing Disks to Amazon EBS in the Amazon EC2 CLI Reference PDF file. For information about the import manifest referenced by this API action, see VM Import Manifest.
   */
  importVolume(callback?: (err: AWSError, data: EC2.Types.ImportVolumeResult) => void): Request<EC2.Types.ImportVolumeResult, AWSError>;
  /**
   * Lists one or more AMIs that are currently in the Recycle Bin. For more information, see Recycle Bin in the Amazon Elastic Compute Cloud User Guide.
   */
  listImagesInRecycleBin(params: EC2.Types.ListImagesInRecycleBinRequest, callback?: (err: AWSError, data: EC2.Types.ListImagesInRecycleBinResult) => void): Request<EC2.Types.ListImagesInRecycleBinResult, AWSError>;
  /**
   * Lists one or more AMIs that are currently in the Recycle Bin. For more information, see Recycle Bin in the Amazon Elastic Compute Cloud User Guide.
   */
  listImagesInRecycleBin(callback?: (err: AWSError, data: EC2.Types.ListImagesInRecycleBinResult) => void): Request<EC2.Types.ListImagesInRecycleBinResult, AWSError>;
  /**
   * Lists one or more snapshots that are currently in the Recycle Bin.
   */
  listSnapshotsInRecycleBin(params: EC2.Types.ListSnapshotsInRecycleBinRequest, callback?: (err: AWSError, data: EC2.Types.ListSnapshotsInRecycleBinResult) => void): Request<EC2.Types.ListSnapshotsInRecycleBinResult, AWSError>;
  /**
   * Lists one or more snapshots that are currently in the Recycle Bin.
   */
  listSnapshotsInRecycleBin(callback?: (err: AWSError, data: EC2.Types.ListSnapshotsInRecycleBinResult) => void): Request<EC2.Types.ListSnapshotsInRecycleBinResult, AWSError>;
  /**
   * Modifies an attribute of the specified Elastic IP address. For requirements, see Using reverse DNS for email applications.
   */
  modifyAddressAttribute(params: EC2.Types.ModifyAddressAttributeRequest, callback?: (err: AWSError, data: EC2.Types.ModifyAddressAttributeResult) => void): Request<EC2.Types.ModifyAddressAttributeResult, AWSError>;
  /**
   * Modifies an attribute of the specified Elastic IP address. For requirements, see Using reverse DNS for email applications.
   */
  modifyAddressAttribute(callback?: (err: AWSError, data: EC2.Types.ModifyAddressAttributeResult) => void): Request<EC2.Types.ModifyAddressAttributeResult, AWSError>;
  /**
   * Changes the opt-in status of the Local Zone and Wavelength Zone group for your account. Use  DescribeAvailabilityZones to view the value for GroupName.
   */
  modifyAvailabilityZoneGroup(params: EC2.Types.ModifyAvailabilityZoneGroupRequest, callback?: (err: AWSError, data: EC2.Types.ModifyAvailabilityZoneGroupResult) => void): Request<EC2.Types.ModifyAvailabilityZoneGroupResult, AWSError>;
  /**
   * Changes the opt-in status of the Local Zone and Wavelength Zone group for your account. Use  DescribeAvailabilityZones to view the value for GroupName.
   */
  modifyAvailabilityZoneGroup(callback?: (err: AWSError, data: EC2.Types.ModifyAvailabilityZoneGroupResult) => void): Request<EC2.Types.ModifyAvailabilityZoneGroupResult, AWSError>;
  /**
   * Modifies a Capacity Reservation's capacity and the conditions under which it is to be released. You cannot change a Capacity Reservation's instance type, EBS optimization, instance store settings, platform, Availability Zone, or instance eligibility. If you need to modify any of these attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with the required attributes.
   */
  modifyCapacityReservation(params: EC2.Types.ModifyCapacityReservationRequest, callback?: (err: AWSError, data: EC2.Types.ModifyCapacityReservationResult) => void): Request<EC2.Types.ModifyCapacityReservationResult, AWSError>;
  /**
   * Modifies a Capacity Reservation's capacity and the conditions under which it is to be released. You cannot change a Capacity Reservation's instance type, EBS optimization, instance store settings, platform, Availability Zone, or instance eligibility. If you need to modify any of these attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with the required attributes.
   */
  modifyCapacityReservation(callback?: (err: AWSError, data: EC2.Types.ModifyCapacityReservationResult) => void): Request<EC2.Types.ModifyCapacityReservationResult, AWSError>;
  /**
   * Modifies a Capacity Reservation Fleet. When you modify the total target capacity of a Capacity Reservation Fleet, the Fleet automatically creates new Capacity Reservations, or modifies or cancels existing Capacity Reservations in the Fleet to meet the new total target capacity. When you modify the end date for the Fleet, the end dates for all of the individual Capacity Reservations in the Fleet are updated accordingly.
   */
  modifyCapacityReservationFleet(params: EC2.Types.ModifyCapacityReservationFleetRequest, callback?: (err: AWSError, data: EC2.Types.ModifyCapacityReservationFleetResult) => void): Request<EC2.Types.ModifyCapacityReservationFleetResult, AWSError>;
  /**
   * Modifies a Capacity Reservation Fleet. When you modify the total target capacity of a Capacity Reservation Fleet, the Fleet automatically creates new Capacity Reservations, or modifies or cancels existing Capacity Reservations in the Fleet to meet the new total target capacity. When you modify the end date for the Fleet, the end dates for all of the individual Capacity Reservations in the Fleet are updated accordingly.
   */
  modifyCapacityReservationFleet(callback?: (err: AWSError, data: EC2.Types.ModifyCapacityReservationFleetResult) => void): Request<EC2.Types.ModifyCapacityReservationFleetResult, AWSError>;
  /**
   * Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.
   */
  modifyClientVpnEndpoint(params: EC2.Types.ModifyClientVpnEndpointRequest, callback?: (err: AWSError, data: EC2.Types.ModifyClientVpnEndpointResult) => void): Request<EC2.Types.ModifyClientVpnEndpointResult, AWSError>;
  /**
   * Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.
   */
  modifyClientVpnEndpoint(callback?: (err: AWSError, data: EC2.Types.ModifyClientVpnEndpointResult) => void): Request<EC2.Types.ModifyClientVpnEndpointResult, AWSError>;
  /**
   * Modifies the default credit option for CPU usage of burstable performance instances. The default credit option is set at the account level per Amazon Web Services Region, and is specified per instance family. All new burstable performance instances in the account launch using the default credit option.  ModifyDefaultCreditSpecification is an asynchronous operation, which works at an Amazon Web Services Region level and modifies the credit option for each Availability Zone. All zones in a Region are updated within five minutes. But if instances are launched during this operation, they might not get the new credit option until the zone is updated. To verify whether the update has occurred, you can call GetDefaultCreditSpecification and check DefaultCreditSpecification for updates. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  modifyDefaultCreditSpecification(params: EC2.Types.ModifyDefaultCreditSpecificationRequest, callback?: (err: AWSError, data: EC2.Types.ModifyDefaultCreditSpecificationResult) => void): Request<EC2.Types.ModifyDefaultCreditSpecificationResult, AWSError>;
  /**
   * Modifies the default credit option for CPU usage of burstable performance instances. The default credit option is set at the account level per Amazon Web Services Region, and is specified per instance family. All new burstable performance instances in the account launch using the default credit option.  ModifyDefaultCreditSpecification is an asynchronous operation, which works at an Amazon Web Services Region level and modifies the credit option for each Availability Zone. All zones in a Region are updated within five minutes. But if instances are launched during this operation, they might not get the new credit option until the zone is updated. To verify whether the update has occurred, you can call GetDefaultCreditSpecification and check DefaultCreditSpecification for updates. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  modifyDefaultCreditSpecification(callback?: (err: AWSError, data: EC2.Types.ModifyDefaultCreditSpecificationResult) => void): Request<EC2.Types.ModifyDefaultCreditSpecificationResult, AWSError>;
  /**
   * Changes the default KMS key for EBS encryption by default for your account in this Region. Amazon Web Services creates a unique Amazon Web Services managed KMS key in each Region for use with encryption by default. If you change the default KMS key to a symmetric customer managed KMS key, it is used instead of the Amazon Web Services managed KMS key. To reset the default KMS key to the Amazon Web Services managed KMS key for EBS, use ResetEbsDefaultKmsKeyId. Amazon EBS does not support asymmetric KMS keys. If you delete or disable the customer managed KMS key that you specified for use with encryption by default, your instances will fail to launch. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  modifyEbsDefaultKmsKeyId(params: EC2.Types.ModifyEbsDefaultKmsKeyIdRequest, callback?: (err: AWSError, data: EC2.Types.ModifyEbsDefaultKmsKeyIdResult) => void): Request<EC2.Types.ModifyEbsDefaultKmsKeyIdResult, AWSError>;
  /**
   * Changes the default KMS key for EBS encryption by default for your account in this Region. Amazon Web Services creates a unique Amazon Web Services managed KMS key in each Region for use with encryption by default. If you change the default KMS key to a symmetric customer managed KMS key, it is used instead of the Amazon Web Services managed KMS key. To reset the default KMS key to the Amazon Web Services managed KMS key for EBS, use ResetEbsDefaultKmsKeyId. Amazon EBS does not support asymmetric KMS keys. If you delete or disable the customer managed KMS key that you specified for use with encryption by default, your instances will fail to launch. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  modifyEbsDefaultKmsKeyId(callback?: (err: AWSError, data: EC2.Types.ModifyEbsDefaultKmsKeyIdResult) => void): Request<EC2.Types.ModifyEbsDefaultKmsKeyIdResult, AWSError>;
  /**
   * Modifies the specified EC2 Fleet. You can only modify an EC2 Fleet request of type maintain. While the EC2 Fleet is being modified, it is in the modifying state. To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation strategy is lowest-price, the EC2 Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is diversified, the EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is capacity-optimized, EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is lowest-price, the EC2 Fleet terminates the instances with the highest price per unit. If the allocation strategy is capacity-optimized, the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is diversified, the EC2 Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually. If you are finished with your EC2 Fleet for now, but will use it again later, you can set the target capacity to 0.
   */
  modifyFleet(params: EC2.Types.ModifyFleetRequest, callback?: (err: AWSError, data: EC2.Types.ModifyFleetResult) => void): Request<EC2.Types.ModifyFleetResult, AWSError>;
  /**
   * Modifies the specified EC2 Fleet. You can only modify an EC2 Fleet request of type maintain. While the EC2 Fleet is being modified, it is in the modifying state. To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation strategy is lowest-price, the EC2 Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is diversified, the EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is capacity-optimized, EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is lowest-price, the EC2 Fleet terminates the instances with the highest price per unit. If the allocation strategy is capacity-optimized, the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is diversified, the EC2 Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually. If you are finished with your EC2 Fleet for now, but will use it again later, you can set the target capacity to 0.
   */
  modifyFleet(callback?: (err: AWSError, data: EC2.Types.ModifyFleetResult) => void): Request<EC2.Types.ModifyFleetResult, AWSError>;
  /**
   * Modifies the specified attribute of the specified Amazon FPGA Image (AFI).
   */
  modifyFpgaImageAttribute(params: EC2.Types.ModifyFpgaImageAttributeRequest, callback?: (err: AWSError, data: EC2.Types.ModifyFpgaImageAttributeResult) => void): Request<EC2.Types.ModifyFpgaImageAttributeResult, AWSError>;
  /**
   * Modifies the specified attribute of the specified Amazon FPGA Image (AFI).
   */
  modifyFpgaImageAttribute(callback?: (err: AWSError, data: EC2.Types.ModifyFpgaImageAttributeResult) => void): Request<EC2.Types.ModifyFpgaImageAttributeResult, AWSError>;
  /**
   * Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, any instances that you launch with a tenancy of host but without a specific host ID are placed onto any available Dedicated Host in your account that has auto-placement enabled. When auto-placement is disabled, you need to provide a host ID to have the instance launch onto a specific host. If no host ID is provided, the instance is launched onto a suitable host with auto-placement enabled. You can also use this API action to modify a Dedicated Host to support either multiple instance types in an instance family, or to support a specific instance type only.
   */
  modifyHosts(params: EC2.Types.ModifyHostsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyHostsResult) => void): Request<EC2.Types.ModifyHostsResult, AWSError>;
  /**
   * Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, any instances that you launch with a tenancy of host but without a specific host ID are placed onto any available Dedicated Host in your account that has auto-placement enabled. When auto-placement is disabled, you need to provide a host ID to have the instance launch onto a specific host. If no host ID is provided, the instance is launched onto a suitable host with auto-placement enabled. You can also use this API action to modify a Dedicated Host to support either multiple instance types in an instance family, or to support a specific instance type only.
   */
  modifyHosts(callback?: (err: AWSError, data: EC2.Types.ModifyHostsResult) => void): Request<EC2.Types.ModifyHostsResult, AWSError>;
  /**
   * Modifies the ID format for the specified resource on a per-Region basis. You can specify that resources should receive longer IDs (17-character IDs) when they are created. This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | route-table | route-table-association | security-group | subnet | subnet-cidr-block-association | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway. This setting applies to the IAM user who makes the request; it does not apply to the entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user. If you're using this action as the root user, then these settings apply to the entire account, unless an IAM user explicitly overrides these settings for themselves. For more information, see Resource IDs in the Amazon Elastic Compute Cloud User Guide. Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant Describe command for the resource type.
   */
  modifyIdFormat(params: EC2.Types.ModifyIdFormatRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the ID format for the specified resource on a per-Region basis. You can specify that resources should receive longer IDs (17-character IDs) when they are created. This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | route-table | route-table-association | security-group | subnet | subnet-cidr-block-association | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway. This setting applies to the IAM user who makes the request; it does not apply to the entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user. If you're using this action as the root user, then these settings apply to the entire account, unless an IAM user explicitly overrides these settings for themselves. For more information, see Resource IDs in the Amazon Elastic Compute Cloud User Guide. Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant Describe command for the resource type.
   */
  modifyIdFormat(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the ID format of a resource for a specified IAM user, IAM role, or the root user for an account; or all IAM users, IAM roles, and the root user for an account. You can specify that resources should receive longer IDs (17-character IDs) when they are created.  This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | route-table | route-table-association | security-group | subnet | subnet-cidr-block-association | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.  For more information, see Resource IDs in the Amazon Elastic Compute Cloud User Guide.  This setting applies to the principal specified in the request; it does not apply to the principal that makes the request.  Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant Describe command for the resource type.
   */
  modifyIdentityIdFormat(params: EC2.Types.ModifyIdentityIdFormatRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the ID format of a resource for a specified IAM user, IAM role, or the root user for an account; or all IAM users, IAM roles, and the root user for an account. You can specify that resources should receive longer IDs (17-character IDs) when they are created.  This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image | import-task | internet-gateway | network-acl | network-acl-association | network-interface | network-interface-attachment | prefix-list | route-table | route-table-association | security-group | subnet | subnet-cidr-block-association | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.  For more information, see Resource IDs in the Amazon Elastic Compute Cloud User Guide.  This setting applies to the principal specified in the request; it does not apply to the principal that makes the request.  Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant Describe command for the resource type.
   */
  modifyIdentityIdFormat(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time. You can use the Attribute parameter to specify the attribute or one of the following parameters: Description or LaunchPermission. Images with an Amazon Web Services Marketplace product code cannot be made public. To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance and create an AMI from the instance.
   */
  modifyImageAttribute(params: EC2.Types.ModifyImageAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time. You can use the Attribute parameter to specify the attribute or one of the following parameters: Description or LaunchPermission. Images with an Amazon Web Services Marketplace product code cannot be made public. To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance and create an AMI from the instance.
   */
  modifyImageAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.  Note: Using this action to change the security groups associated with an elastic network interface (ENI) attached to an instance in a VPC can result in an error if the instance has more than one ENI. To change the security groups associated with an ENI attached to an instance that has multiple ENIs, we recommend that you use the ModifyNetworkInterfaceAttribute action. To modify some attributes, the instance must be stopped. For more information, see Modify a stopped instance in the Amazon EC2 User Guide.
   */
  modifyInstanceAttribute(params: EC2.Types.ModifyInstanceAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.  Note: Using this action to change the security groups associated with an elastic network interface (ENI) attached to an instance in a VPC can result in an error if the instance has more than one ENI. To change the security groups associated with an ENI attached to an instance that has multiple ENIs, we recommend that you use the ModifyNetworkInterfaceAttribute action. To modify some attributes, the instance must be stopped. For more information, see Modify a stopped instance in the Amazon EC2 User Guide.
   */
  modifyInstanceAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an instance to target a specific Capacity Reservation, run in any open Capacity Reservation with matching attributes, or run On-Demand Instance capacity.
   */
  modifyInstanceCapacityReservationAttributes(params: EC2.Types.ModifyInstanceCapacityReservationAttributesRequest, callback?: (err: AWSError, data: EC2.Types.ModifyInstanceCapacityReservationAttributesResult) => void): Request<EC2.Types.ModifyInstanceCapacityReservationAttributesResult, AWSError>;
  /**
   * Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an instance to target a specific Capacity Reservation, run in any open Capacity Reservation with matching attributes, or run On-Demand Instance capacity.
   */
  modifyInstanceCapacityReservationAttributes(callback?: (err: AWSError, data: EC2.Types.ModifyInstanceCapacityReservationAttributesResult) => void): Request<EC2.Types.ModifyInstanceCapacityReservationAttributesResult, AWSError>;
  /**
   * Modifies the credit option for CPU usage on a running or stopped burstable performance instance. The credit options are standard and unlimited. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  modifyInstanceCreditSpecification(params: EC2.Types.ModifyInstanceCreditSpecificationRequest, callback?: (err: AWSError, data: EC2.Types.ModifyInstanceCreditSpecificationResult) => void): Request<EC2.Types.ModifyInstanceCreditSpecificationResult, AWSError>;
  /**
   * Modifies the credit option for CPU usage on a running or stopped burstable performance instance. The credit options are standard and unlimited. For more information, see Burstable performance instances in the Amazon EC2 User Guide.
   */
  modifyInstanceCreditSpecification(callback?: (err: AWSError, data: EC2.Types.ModifyInstanceCreditSpecificationResult) => void): Request<EC2.Types.ModifyInstanceCreditSpecificationResult, AWSError>;
  /**
   * Modifies the start time for a scheduled Amazon EC2 instance event.
   */
  modifyInstanceEventStartTime(params: EC2.Types.ModifyInstanceEventStartTimeRequest, callback?: (err: AWSError, data: EC2.Types.ModifyInstanceEventStartTimeResult) => void): Request<EC2.Types.ModifyInstanceEventStartTimeResult, AWSError>;
  /**
   * Modifies the start time for a scheduled Amazon EC2 instance event.
   */
  modifyInstanceEventStartTime(callback?: (err: AWSError, data: EC2.Types.ModifyInstanceEventStartTimeResult) => void): Request<EC2.Types.ModifyInstanceEventStartTimeResult, AWSError>;
  /**
   * Modifies the specified event window. You can define either a set of time ranges or a cron expression when modifying the event window, but not both. To modify the targets associated with the event window, use the AssociateInstanceEventWindow and DisassociateInstanceEventWindow API. If Amazon Web Services has already scheduled an event, modifying an event window won't change the time of the scheduled event. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  modifyInstanceEventWindow(params: EC2.Types.ModifyInstanceEventWindowRequest, callback?: (err: AWSError, data: EC2.Types.ModifyInstanceEventWindowResult) => void): Request<EC2.Types.ModifyInstanceEventWindowResult, AWSError>;
  /**
   * Modifies the specified event window. You can define either a set of time ranges or a cron expression when modifying the event window, but not both. To modify the targets associated with the event window, use the AssociateInstanceEventWindow and DisassociateInstanceEventWindow API. If Amazon Web Services has already scheduled an event, modifying an event window won't change the time of the scheduled event. For more information, see Define event windows for scheduled events in the Amazon EC2 User Guide.
   */
  modifyInstanceEventWindow(callback?: (err: AWSError, data: EC2.Types.ModifyInstanceEventWindowResult) => void): Request<EC2.Types.ModifyInstanceEventWindowResult, AWSError>;
  /**
   * Modifies the recovery behavior of your instance to disable simplified automatic recovery or set the recovery behavior to default. The default configuration will not enable simplified automatic recovery for an unsupported instance type. For more information, see Simplified automatic recovery.
   */
  modifyInstanceMaintenanceOptions(params: EC2.Types.ModifyInstanceMaintenanceOptionsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyInstanceMaintenanceOptionsResult) => void): Request<EC2.Types.ModifyInstanceMaintenanceOptionsResult, AWSError>;
  /**
   * Modifies the recovery behavior of your instance to disable simplified automatic recovery or set the recovery behavior to default. The default configuration will not enable simplified automatic recovery for an unsupported instance type. For more information, see Simplified automatic recovery.
   */
  modifyInstanceMaintenanceOptions(callback?: (err: AWSError, data: EC2.Types.ModifyInstanceMaintenanceOptionsResult) => void): Request<EC2.Types.ModifyInstanceMaintenanceOptionsResult, AWSError>;
  /**
   * Modify the instance metadata parameters on a running or stopped instance. When you modify the parameters on a stopped instance, they are applied when the instance is started. When you modify the parameters on a running instance, the API responds with a state of “pending”. After the parameter modifications are successfully applied to the instance, the state of the modifications changes from “pending” to “applied” in subsequent describe-instances API calls. For more information, see Instance metadata and user data in the Amazon EC2 User Guide.
   */
  modifyInstanceMetadataOptions(params: EC2.Types.ModifyInstanceMetadataOptionsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyInstanceMetadataOptionsResult) => void): Request<EC2.Types.ModifyInstanceMetadataOptionsResult, AWSError>;
  /**
   * Modify the instance metadata parameters on a running or stopped instance. When you modify the parameters on a stopped instance, they are applied when the instance is started. When you modify the parameters on a running instance, the API responds with a state of “pending”. After the parameter modifications are successfully applied to the instance, the state of the modifications changes from “pending” to “applied” in subsequent describe-instances API calls. For more information, see Instance metadata and user data in the Amazon EC2 User Guide.
   */
  modifyInstanceMetadataOptions(callback?: (err: AWSError, data: EC2.Types.ModifyInstanceMetadataOptionsResult) => void): Request<EC2.Types.ModifyInstanceMetadataOptionsResult, AWSError>;
  /**
   * Modifies the placement attributes for a specified instance. You can do the following:   Modify the affinity between an instance and a Dedicated Host. When affinity is set to host and the instance is not associated with a specific Dedicated Host, the next time the instance is launched, it is automatically associated with the host on which it lands. If the instance is restarted or rebooted, this relationship persists.   Change the Dedicated Host with which an instance is associated.   Change the instance tenancy of an instance.   Move an instance to or from a placement group.   At least one attribute for affinity, host ID, tenancy, or placement group name must be specified in the request. Affinity and tenancy can be modified in the same request. To modify the host ID, tenancy, placement group, or partition for an instance, the instance must be in the stopped state.
   */
  modifyInstancePlacement(params: EC2.Types.ModifyInstancePlacementRequest, callback?: (err: AWSError, data: EC2.Types.ModifyInstancePlacementResult) => void): Request<EC2.Types.ModifyInstancePlacementResult, AWSError>;
  /**
   * Modifies the placement attributes for a specified instance. You can do the following:   Modify the affinity between an instance and a Dedicated Host. When affinity is set to host and the instance is not associated with a specific Dedicated Host, the next time the instance is launched, it is automatically associated with the host on which it lands. If the instance is restarted or rebooted, this relationship persists.   Change the Dedicated Host with which an instance is associated.   Change the instance tenancy of an instance.   Move an instance to or from a placement group.   At least one attribute for affinity, host ID, tenancy, or placement group name must be specified in the request. Affinity and tenancy can be modified in the same request. To modify the host ID, tenancy, placement group, or partition for an instance, the instance must be in the stopped state.
   */
  modifyInstancePlacement(callback?: (err: AWSError, data: EC2.Types.ModifyInstancePlacementResult) => void): Request<EC2.Types.ModifyInstancePlacementResult, AWSError>;
  /**
   * Modify the configurations of an IPAM. 
   */
  modifyIpam(params: EC2.Types.ModifyIpamRequest, callback?: (err: AWSError, data: EC2.Types.ModifyIpamResult) => void): Request<EC2.Types.ModifyIpamResult, AWSError>;
  /**
   * Modify the configurations of an IPAM. 
   */
  modifyIpam(callback?: (err: AWSError, data: EC2.Types.ModifyIpamResult) => void): Request<EC2.Types.ModifyIpamResult, AWSError>;
  /**
   * Modify the configurations of an IPAM pool. For more information, see Modify a pool in the Amazon VPC IPAM User Guide. 
   */
  modifyIpamPool(params: EC2.Types.ModifyIpamPoolRequest, callback?: (err: AWSError, data: EC2.Types.ModifyIpamPoolResult) => void): Request<EC2.Types.ModifyIpamPoolResult, AWSError>;
  /**
   * Modify the configurations of an IPAM pool. For more information, see Modify a pool in the Amazon VPC IPAM User Guide. 
   */
  modifyIpamPool(callback?: (err: AWSError, data: EC2.Types.ModifyIpamPoolResult) => void): Request<EC2.Types.ModifyIpamPoolResult, AWSError>;
  /**
   * Modify a resource CIDR. You can use this action to transfer resource CIDRs between scopes and ignore resource CIDRs that you do not want to manage. If set to false, the resource will not be tracked for overlap, it cannot be auto-imported into a pool, and it will be removed from any pool it has an allocation in. For more information, see Move resource CIDRs between scopes and Change the monitoring state of resource CIDRs in the Amazon VPC IPAM User Guide.
   */
  modifyIpamResourceCidr(params: EC2.Types.ModifyIpamResourceCidrRequest, callback?: (err: AWSError, data: EC2.Types.ModifyIpamResourceCidrResult) => void): Request<EC2.Types.ModifyIpamResourceCidrResult, AWSError>;
  /**
   * Modify a resource CIDR. You can use this action to transfer resource CIDRs between scopes and ignore resource CIDRs that you do not want to manage. If set to false, the resource will not be tracked for overlap, it cannot be auto-imported into a pool, and it will be removed from any pool it has an allocation in. For more information, see Move resource CIDRs between scopes and Change the monitoring state of resource CIDRs in the Amazon VPC IPAM User Guide.
   */
  modifyIpamResourceCidr(callback?: (err: AWSError, data: EC2.Types.ModifyIpamResourceCidrResult) => void): Request<EC2.Types.ModifyIpamResourceCidrResult, AWSError>;
  /**
   * Modify an IPAM scope.
   */
  modifyIpamScope(params: EC2.Types.ModifyIpamScopeRequest, callback?: (err: AWSError, data: EC2.Types.ModifyIpamScopeResult) => void): Request<EC2.Types.ModifyIpamScopeResult, AWSError>;
  /**
   * Modify an IPAM scope.
   */
  modifyIpamScope(callback?: (err: AWSError, data: EC2.Types.ModifyIpamScopeResult) => void): Request<EC2.Types.ModifyIpamScopeResult, AWSError>;
  /**
   * Modifies a launch template. You can specify which version of the launch template to set as the default version. When launching an instance, the default version applies when a launch template version is not specified.
   */
  modifyLaunchTemplate(params: EC2.Types.ModifyLaunchTemplateRequest, callback?: (err: AWSError, data: EC2.Types.ModifyLaunchTemplateResult) => void): Request<EC2.Types.ModifyLaunchTemplateResult, AWSError>;
  /**
   * Modifies a launch template. You can specify which version of the launch template to set as the default version. When launching an instance, the default version applies when a launch template version is not specified.
   */
  modifyLaunchTemplate(callback?: (err: AWSError, data: EC2.Types.ModifyLaunchTemplateResult) => void): Request<EC2.Types.ModifyLaunchTemplateResult, AWSError>;
  /**
   * Modifies the specified local gateway route.
   */
  modifyLocalGatewayRoute(params: EC2.Types.ModifyLocalGatewayRouteRequest, callback?: (err: AWSError, data: EC2.Types.ModifyLocalGatewayRouteResult) => void): Request<EC2.Types.ModifyLocalGatewayRouteResult, AWSError>;
  /**
   * Modifies the specified local gateway route.
   */
  modifyLocalGatewayRoute(callback?: (err: AWSError, data: EC2.Types.ModifyLocalGatewayRouteResult) => void): Request<EC2.Types.ModifyLocalGatewayRouteResult, AWSError>;
  /**
   * Modifies the specified managed prefix list. Adding or removing entries in a prefix list creates a new version of the prefix list. Changing the name of the prefix list does not affect the version. If you specify a current version number that does not match the true current version number, the request fails.
   */
  modifyManagedPrefixList(params: EC2.Types.ModifyManagedPrefixListRequest, callback?: (err: AWSError, data: EC2.Types.ModifyManagedPrefixListResult) => void): Request<EC2.Types.ModifyManagedPrefixListResult, AWSError>;
  /**
   * Modifies the specified managed prefix list. Adding or removing entries in a prefix list creates a new version of the prefix list. Changing the name of the prefix list does not affect the version. If you specify a current version number that does not match the true current version number, the request fails.
   */
  modifyManagedPrefixList(callback?: (err: AWSError, data: EC2.Types.ModifyManagedPrefixListResult) => void): Request<EC2.Types.ModifyManagedPrefixListResult, AWSError>;
  /**
   * Modifies the specified network interface attribute. You can specify only one attribute at a time. You can use this action to attach and detach security groups from an existing EC2 instance.
   */
  modifyNetworkInterfaceAttribute(params: EC2.Types.ModifyNetworkInterfaceAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the specified network interface attribute. You can specify only one attribute at a time. You can use this action to attach and detach security groups from an existing EC2 instance.
   */
  modifyNetworkInterfaceAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the options for instance hostnames for the specified instance.
   */
  modifyPrivateDnsNameOptions(params: EC2.Types.ModifyPrivateDnsNameOptionsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyPrivateDnsNameOptionsResult) => void): Request<EC2.Types.ModifyPrivateDnsNameOptionsResult, AWSError>;
  /**
   * Modifies the options for instance hostnames for the specified instance.
   */
  modifyPrivateDnsNameOptions(callback?: (err: AWSError, data: EC2.Types.ModifyPrivateDnsNameOptionsResult) => void): Request<EC2.Types.ModifyPrivateDnsNameOptionsResult, AWSError>;
  /**
   * Modifies the configuration of your Reserved Instances, such as the Availability Zone, instance count, or instance type. The Reserved Instances to be modified must be identical, except for Availability Zone, network platform, and instance type. For more information, see Modifying Reserved Instances in the Amazon EC2 User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  modifyReservedInstances(params: EC2.Types.ModifyReservedInstancesRequest, callback?: (err: AWSError, data: EC2.Types.ModifyReservedInstancesResult) => void): Request<EC2.Types.ModifyReservedInstancesResult, AWSError>;
  /**
   * Modifies the configuration of your Reserved Instances, such as the Availability Zone, instance count, or instance type. The Reserved Instances to be modified must be identical, except for Availability Zone, network platform, and instance type. For more information, see Modifying Reserved Instances in the Amazon EC2 User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  modifyReservedInstances(callback?: (err: AWSError, data: EC2.Types.ModifyReservedInstancesResult) => void): Request<EC2.Types.ModifyReservedInstancesResult, AWSError>;
  /**
   * Modifies the rules of a security group.
   */
  modifySecurityGroupRules(params: EC2.Types.ModifySecurityGroupRulesRequest, callback?: (err: AWSError, data: EC2.Types.ModifySecurityGroupRulesResult) => void): Request<EC2.Types.ModifySecurityGroupRulesResult, AWSError>;
  /**
   * Modifies the rules of a security group.
   */
  modifySecurityGroupRules(callback?: (err: AWSError, data: EC2.Types.ModifySecurityGroupRulesResult) => void): Request<EC2.Types.ModifySecurityGroupRulesResult, AWSError>;
  /**
   * Adds or removes permission settings for the specified snapshot. You may add or remove specified Amazon Web Services account IDs from a snapshot's list of create volume permissions, but you cannot do both in a single operation. If you need to both add and remove account IDs for a snapshot, you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation. Encrypted snapshots and snapshots with Amazon Web Services Marketplace product codes cannot be made public. Snapshots encrypted with your default KMS key cannot be shared with other accounts. For more information about modifying snapshot permissions, see Share a snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  modifySnapshotAttribute(params: EC2.Types.ModifySnapshotAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Adds or removes permission settings for the specified snapshot. You may add or remove specified Amazon Web Services account IDs from a snapshot's list of create volume permissions, but you cannot do both in a single operation. If you need to both add and remove account IDs for a snapshot, you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation. Encrypted snapshots and snapshots with Amazon Web Services Marketplace product codes cannot be made public. Snapshots encrypted with your default KMS key cannot be shared with other accounts. For more information about modifying snapshot permissions, see Share a snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  modifySnapshotAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Archives an Amazon EBS snapshot. When you archive a snapshot, it is converted to a full snapshot that includes all of the blocks of data that were written to the volume at the time the snapshot was created, and moved from the standard tier to the archive tier. For more information, see Archive Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
   */
  modifySnapshotTier(params: EC2.Types.ModifySnapshotTierRequest, callback?: (err: AWSError, data: EC2.Types.ModifySnapshotTierResult) => void): Request<EC2.Types.ModifySnapshotTierResult, AWSError>;
  /**
   * Archives an Amazon EBS snapshot. When you archive a snapshot, it is converted to a full snapshot that includes all of the blocks of data that were written to the volume at the time the snapshot was created, and moved from the standard tier to the archive tier. For more information, see Archive Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
   */
  modifySnapshotTier(callback?: (err: AWSError, data: EC2.Types.ModifySnapshotTierResult) => void): Request<EC2.Types.ModifySnapshotTierResult, AWSError>;
  /**
   * Modifies the specified Spot Fleet request. You can only modify a Spot Fleet request of type maintain. While the Spot Fleet request is being modified, it is in the modifying state. To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the additional Spot Instances according to the allocation strategy for the Spot Fleet request. If the allocation strategy is lowestPrice, the Spot Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is diversified, the Spot Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is capacityOptimized, Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet cancels any open requests that exceed the new target capacity. You can request that the Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is lowestPrice, the Spot Fleet terminates the instances with the highest price per unit. If the allocation strategy is capacityOptimized, the Spot Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is diversified, the Spot Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually. If you are finished with your Spot Fleet for now, but will use it again later, you can set the target capacity to 0.
   */
  modifySpotFleetRequest(params: EC2.Types.ModifySpotFleetRequestRequest, callback?: (err: AWSError, data: EC2.Types.ModifySpotFleetRequestResponse) => void): Request<EC2.Types.ModifySpotFleetRequestResponse, AWSError>;
  /**
   * Modifies the specified Spot Fleet request. You can only modify a Spot Fleet request of type maintain. While the Spot Fleet request is being modified, it is in the modifying state. To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the additional Spot Instances according to the allocation strategy for the Spot Fleet request. If the allocation strategy is lowestPrice, the Spot Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is diversified, the Spot Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is capacityOptimized, Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet cancels any open requests that exceed the new target capacity. You can request that the Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is lowestPrice, the Spot Fleet terminates the instances with the highest price per unit. If the allocation strategy is capacityOptimized, the Spot Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is diversified, the Spot Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually. If you are finished with your Spot Fleet for now, but will use it again later, you can set the target capacity to 0.
   */
  modifySpotFleetRequest(callback?: (err: AWSError, data: EC2.Types.ModifySpotFleetRequestResponse) => void): Request<EC2.Types.ModifySpotFleetRequestResponse, AWSError>;
  /**
   * Modifies a subnet attribute. You can only modify one attribute at a time. Use this action to modify subnets on Amazon Web Services Outposts.   To modify a subnet on an Outpost rack, set both MapCustomerOwnedIpOnLaunch and CustomerOwnedIpv4Pool. These two parameters act as a single attribute.   To modify a subnet on an Outpost server, set either EnableLniAtDeviceIndex or DisableLniAtDeviceIndex.   For more information about Amazon Web Services Outposts, see the following:    Outpost servers     Outpost racks   
   */
  modifySubnetAttribute(params: EC2.Types.ModifySubnetAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies a subnet attribute. You can only modify one attribute at a time. Use this action to modify subnets on Amazon Web Services Outposts.   To modify a subnet on an Outpost rack, set both MapCustomerOwnedIpOnLaunch and CustomerOwnedIpv4Pool. These two parameters act as a single attribute.   To modify a subnet on an Outpost server, set either EnableLniAtDeviceIndex or DisableLniAtDeviceIndex.   For more information about Amazon Web Services Outposts, see the following:    Outpost servers     Outpost racks   
   */
  modifySubnetAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Allows or restricts mirroring network services.  By default, Amazon DNS network services are not eligible for Traffic Mirror. Use AddNetworkServices to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored. When you no longer want to mirror network services, use RemoveNetworkServices to remove the network services from the Traffic Mirror filter. 
   */
  modifyTrafficMirrorFilterNetworkServices(params: EC2.Types.ModifyTrafficMirrorFilterNetworkServicesRequest, callback?: (err: AWSError, data: EC2.Types.ModifyTrafficMirrorFilterNetworkServicesResult) => void): Request<EC2.Types.ModifyTrafficMirrorFilterNetworkServicesResult, AWSError>;
  /**
   * Allows or restricts mirroring network services.  By default, Amazon DNS network services are not eligible for Traffic Mirror. Use AddNetworkServices to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored. When you no longer want to mirror network services, use RemoveNetworkServices to remove the network services from the Traffic Mirror filter. 
   */
  modifyTrafficMirrorFilterNetworkServices(callback?: (err: AWSError, data: EC2.Types.ModifyTrafficMirrorFilterNetworkServicesResult) => void): Request<EC2.Types.ModifyTrafficMirrorFilterNetworkServicesResult, AWSError>;
  /**
   * Modifies the specified Traffic Mirror rule.  DestinationCidrBlock and SourceCidrBlock must both be an IPv4 range or an IPv6 range.
   */
  modifyTrafficMirrorFilterRule(params: EC2.Types.ModifyTrafficMirrorFilterRuleRequest, callback?: (err: AWSError, data: EC2.Types.ModifyTrafficMirrorFilterRuleResult) => void): Request<EC2.Types.ModifyTrafficMirrorFilterRuleResult, AWSError>;
  /**
   * Modifies the specified Traffic Mirror rule.  DestinationCidrBlock and SourceCidrBlock must both be an IPv4 range or an IPv6 range.
   */
  modifyTrafficMirrorFilterRule(callback?: (err: AWSError, data: EC2.Types.ModifyTrafficMirrorFilterRuleResult) => void): Request<EC2.Types.ModifyTrafficMirrorFilterRuleResult, AWSError>;
  /**
   * Modifies a Traffic Mirror session.
   */
  modifyTrafficMirrorSession(params: EC2.Types.ModifyTrafficMirrorSessionRequest, callback?: (err: AWSError, data: EC2.Types.ModifyTrafficMirrorSessionResult) => void): Request<EC2.Types.ModifyTrafficMirrorSessionResult, AWSError>;
  /**
   * Modifies a Traffic Mirror session.
   */
  modifyTrafficMirrorSession(callback?: (err: AWSError, data: EC2.Types.ModifyTrafficMirrorSessionResult) => void): Request<EC2.Types.ModifyTrafficMirrorSessionResult, AWSError>;
  /**
   * Modifies the specified transit gateway. When you modify a transit gateway, the modified options are applied to new transit gateway attachments only. Your existing transit gateway attachments are not modified.
   */
  modifyTransitGateway(params: EC2.Types.ModifyTransitGatewayRequest, callback?: (err: AWSError, data: EC2.Types.ModifyTransitGatewayResult) => void): Request<EC2.Types.ModifyTransitGatewayResult, AWSError>;
  /**
   * Modifies the specified transit gateway. When you modify a transit gateway, the modified options are applied to new transit gateway attachments only. Your existing transit gateway attachments are not modified.
   */
  modifyTransitGateway(callback?: (err: AWSError, data: EC2.Types.ModifyTransitGatewayResult) => void): Request<EC2.Types.ModifyTransitGatewayResult, AWSError>;
  /**
   * Modifies a reference (route) to a prefix list in a specified transit gateway route table.
   */
  modifyTransitGatewayPrefixListReference(params: EC2.Types.ModifyTransitGatewayPrefixListReferenceRequest, callback?: (err: AWSError, data: EC2.Types.ModifyTransitGatewayPrefixListReferenceResult) => void): Request<EC2.Types.ModifyTransitGatewayPrefixListReferenceResult, AWSError>;
  /**
   * Modifies a reference (route) to a prefix list in a specified transit gateway route table.
   */
  modifyTransitGatewayPrefixListReference(callback?: (err: AWSError, data: EC2.Types.ModifyTransitGatewayPrefixListReferenceResult) => void): Request<EC2.Types.ModifyTransitGatewayPrefixListReferenceResult, AWSError>;
  /**
   * Modifies the specified VPC attachment.
   */
  modifyTransitGatewayVpcAttachment(params: EC2.Types.ModifyTransitGatewayVpcAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.ModifyTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.ModifyTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Modifies the specified VPC attachment.
   */
  modifyTransitGatewayVpcAttachment(callback?: (err: AWSError, data: EC2.Types.ModifyTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.ModifyTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * You can modify several parameters of an existing EBS volume, including volume size, volume type, and IOPS capacity. If your EBS volume is attached to a current-generation EC2 instance type, you might be able to apply these changes without stopping the instance or detaching the volume from it. For more information about modifying EBS volumes, see Amazon EBS Elastic Volumes (Linux instances) or Amazon EBS Elastic Volumes (Windows instances). When you complete a resize operation on your volume, you need to extend the volume's file-system size to take advantage of the new storage capacity. For more information, see Extend a Linux file system or Extend a Windows file system.  You can use CloudWatch Events to check the status of a modification to an EBS volume. For information about CloudWatch Events, see the Amazon CloudWatch Events User Guide. You can also track the status of a modification using DescribeVolumesModifications. For information about tracking status changes using either method, see Monitor the progress of volume modifications. With previous-generation instance types, resizing an EBS volume might require detaching and reattaching the volume or stopping and restarting the instance. After modifying a volume, you must wait at least six hours and ensure that the volume is in the in-use or available state before you can modify the same volume. This is sometimes referred to as a cooldown period.
   */
  modifyVolume(params: EC2.Types.ModifyVolumeRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVolumeResult) => void): Request<EC2.Types.ModifyVolumeResult, AWSError>;
  /**
   * You can modify several parameters of an existing EBS volume, including volume size, volume type, and IOPS capacity. If your EBS volume is attached to a current-generation EC2 instance type, you might be able to apply these changes without stopping the instance or detaching the volume from it. For more information about modifying EBS volumes, see Amazon EBS Elastic Volumes (Linux instances) or Amazon EBS Elastic Volumes (Windows instances). When you complete a resize operation on your volume, you need to extend the volume's file-system size to take advantage of the new storage capacity. For more information, see Extend a Linux file system or Extend a Windows file system.  You can use CloudWatch Events to check the status of a modification to an EBS volume. For information about CloudWatch Events, see the Amazon CloudWatch Events User Guide. You can also track the status of a modification using DescribeVolumesModifications. For information about tracking status changes using either method, see Monitor the progress of volume modifications. With previous-generation instance types, resizing an EBS volume might require detaching and reattaching the volume or stopping and restarting the instance. After modifying a volume, you must wait at least six hours and ensure that the volume is in the in-use or available state before you can modify the same volume. This is sometimes referred to as a cooldown period.
   */
  modifyVolume(callback?: (err: AWSError, data: EC2.Types.ModifyVolumeResult) => void): Request<EC2.Types.ModifyVolumeResult, AWSError>;
  /**
   * Modifies a volume attribute. By default, all I/O operations for the volume are suspended when the data on the volume is determined to be potentially inconsistent, to prevent undetectable, latent data corruption. The I/O access to the volume can be resumed by first enabling I/O access and then checking the data consistency on your volume. You can change the default behavior to resume I/O operations. We recommend that you change this only for boot volumes or for volumes that are stateless or disposable.
   */
  modifyVolumeAttribute(params: EC2.Types.ModifyVolumeAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies a volume attribute. By default, all I/O operations for the volume are suspended when the data on the volume is determined to be potentially inconsistent, to prevent undetectable, latent data corruption. The I/O access to the volume can be resumed by first enabling I/O access and then checking the data consistency on your volume. You can change the default behavior to resume I/O operations. We recommend that you change this only for boot volumes or for volumes that are stateless or disposable.
   */
  modifyVolumeAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the specified attribute of the specified VPC.
   */
  modifyVpcAttribute(params: EC2.Types.ModifyVpcAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies the specified attribute of the specified VPC.
   */
  modifyVpcAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Modifies attributes of a specified VPC endpoint. The attributes that you can modify depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see the Amazon Web Services PrivateLink Guide.
   */
  modifyVpcEndpoint(params: EC2.Types.ModifyVpcEndpointRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointResult) => void): Request<EC2.Types.ModifyVpcEndpointResult, AWSError>;
  /**
   * Modifies attributes of a specified VPC endpoint. The attributes that you can modify depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see the Amazon Web Services PrivateLink Guide.
   */
  modifyVpcEndpoint(callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointResult) => void): Request<EC2.Types.ModifyVpcEndpointResult, AWSError>;
  /**
   * Modifies a connection notification for VPC endpoint or VPC endpoint service. You can change the SNS topic for the notification, or the events for which to be notified. 
   */
  modifyVpcEndpointConnectionNotification(params: EC2.Types.ModifyVpcEndpointConnectionNotificationRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointConnectionNotificationResult) => void): Request<EC2.Types.ModifyVpcEndpointConnectionNotificationResult, AWSError>;
  /**
   * Modifies a connection notification for VPC endpoint or VPC endpoint service. You can change the SNS topic for the notification, or the events for which to be notified. 
   */
  modifyVpcEndpointConnectionNotification(callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointConnectionNotificationResult) => void): Request<EC2.Types.ModifyVpcEndpointConnectionNotificationResult, AWSError>;
  /**
   * Modifies the attributes of your VPC endpoint service configuration. You can change the Network Load Balancers or Gateway Load Balancers for your service, and you can specify whether acceptance is required for requests to connect to your endpoint service through an interface VPC endpoint. If you set or modify the private DNS name, you must prove that you own the private DNS domain name.
   */
  modifyVpcEndpointServiceConfiguration(params: EC2.Types.ModifyVpcEndpointServiceConfigurationRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointServiceConfigurationResult) => void): Request<EC2.Types.ModifyVpcEndpointServiceConfigurationResult, AWSError>;
  /**
   * Modifies the attributes of your VPC endpoint service configuration. You can change the Network Load Balancers or Gateway Load Balancers for your service, and you can specify whether acceptance is required for requests to connect to your endpoint service through an interface VPC endpoint. If you set or modify the private DNS name, you must prove that you own the private DNS domain name.
   */
  modifyVpcEndpointServiceConfiguration(callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointServiceConfigurationResult) => void): Request<EC2.Types.ModifyVpcEndpointServiceConfigurationResult, AWSError>;
  /**
   * Modifies the payer responsibility for your VPC endpoint service.
   */
  modifyVpcEndpointServicePayerResponsibility(params: EC2.Types.ModifyVpcEndpointServicePayerResponsibilityRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointServicePayerResponsibilityResult) => void): Request<EC2.Types.ModifyVpcEndpointServicePayerResponsibilityResult, AWSError>;
  /**
   * Modifies the payer responsibility for your VPC endpoint service.
   */
  modifyVpcEndpointServicePayerResponsibility(callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointServicePayerResponsibilityResult) => void): Request<EC2.Types.ModifyVpcEndpointServicePayerResponsibilityResult, AWSError>;
  /**
   * Modifies the permissions for your VPC endpoint service. You can add or remove permissions for service consumers (IAM users, IAM roles, and Amazon Web Services accounts) to connect to your endpoint service. If you grant permissions to all principals, the service is public. Any users who know the name of a public service can send a request to attach an endpoint. If the service does not require manual approval, attachments are automatically approved.
   */
  modifyVpcEndpointServicePermissions(params: EC2.Types.ModifyVpcEndpointServicePermissionsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointServicePermissionsResult) => void): Request<EC2.Types.ModifyVpcEndpointServicePermissionsResult, AWSError>;
  /**
   * Modifies the permissions for your VPC endpoint service. You can add or remove permissions for service consumers (IAM users, IAM roles, and Amazon Web Services accounts) to connect to your endpoint service. If you grant permissions to all principals, the service is public. Any users who know the name of a public service can send a request to attach an endpoint. If the service does not require manual approval, attachments are automatically approved.
   */
  modifyVpcEndpointServicePermissions(callback?: (err: AWSError, data: EC2.Types.ModifyVpcEndpointServicePermissionsResult) => void): Request<EC2.Types.ModifyVpcEndpointServicePermissionsResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:   Enable/disable communication over the peering connection between an EC2-Classic instance that's linked to your VPC (using ClassicLink) and instances in the peer VPC.   Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic instance that's linked to the peer VPC.   Enable/disable the ability to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.   If the peered VPCs are in the same Amazon Web Services account, you can enable DNS resolution for queries from the local VPC. This ensures that queries from the local VPC resolve to private IP addresses in the peer VPC. This option is not available if the peered VPCs are in different different Amazon Web Services accounts or different Regions. For peered VPCs in different Amazon Web Services accounts, each Amazon Web Services account owner must initiate a separate request to modify the peering connection options. For inter-region peering connections, you must use the Region for the requester VPC to modify the requester VPC peering options and the Region for the accepter VPC to modify the accepter VPC peering options. To verify which VPCs are the accepter and the requester for a VPC peering connection, use the DescribeVpcPeeringConnections command.
   */
  modifyVpcPeeringConnectionOptions(params: EC2.Types.ModifyVpcPeeringConnectionOptionsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpcPeeringConnectionOptionsResult) => void): Request<EC2.Types.ModifyVpcPeeringConnectionOptionsResult, AWSError>;
  /**
   *  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:   Enable/disable communication over the peering connection between an EC2-Classic instance that's linked to your VPC (using ClassicLink) and instances in the peer VPC.   Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic instance that's linked to the peer VPC.   Enable/disable the ability to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.   If the peered VPCs are in the same Amazon Web Services account, you can enable DNS resolution for queries from the local VPC. This ensures that queries from the local VPC resolve to private IP addresses in the peer VPC. This option is not available if the peered VPCs are in different different Amazon Web Services accounts or different Regions. For peered VPCs in different Amazon Web Services accounts, each Amazon Web Services account owner must initiate a separate request to modify the peering connection options. For inter-region peering connections, you must use the Region for the requester VPC to modify the requester VPC peering options and the Region for the accepter VPC to modify the accepter VPC peering options. To verify which VPCs are the accepter and the requester for a VPC peering connection, use the DescribeVpcPeeringConnections command.
   */
  modifyVpcPeeringConnectionOptions(callback?: (err: AWSError, data: EC2.Types.ModifyVpcPeeringConnectionOptionsResult) => void): Request<EC2.Types.ModifyVpcPeeringConnectionOptionsResult, AWSError>;
  /**
   * Modifies the instance tenancy attribute of the specified VPC. You can change the instance tenancy attribute of a VPC to default only. You cannot change the instance tenancy attribute to dedicated. After you modify the tenancy of the VPC, any new instances that you launch into the VPC have a tenancy of default, unless you specify otherwise during launch. The tenancy of any existing instances in the VPC is not affected. For more information, see Dedicated Instances in the Amazon Elastic Compute Cloud User Guide.
   */
  modifyVpcTenancy(params: EC2.Types.ModifyVpcTenancyRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpcTenancyResult) => void): Request<EC2.Types.ModifyVpcTenancyResult, AWSError>;
  /**
   * Modifies the instance tenancy attribute of the specified VPC. You can change the instance tenancy attribute of a VPC to default only. You cannot change the instance tenancy attribute to dedicated. After you modify the tenancy of the VPC, any new instances that you launch into the VPC have a tenancy of default, unless you specify otherwise during launch. The tenancy of any existing instances in the VPC is not affected. For more information, see Dedicated Instances in the Amazon Elastic Compute Cloud User Guide.
   */
  modifyVpcTenancy(callback?: (err: AWSError, data: EC2.Types.ModifyVpcTenancyResult) => void): Request<EC2.Types.ModifyVpcTenancyResult, AWSError>;
  /**
   * Modifies the customer gateway or the target gateway of an Amazon Web Services Site-to-Site VPN connection. To modify the target gateway, the following migration options are available:   An existing virtual private gateway to a new virtual private gateway   An existing virtual private gateway to a transit gateway   An existing transit gateway to a new transit gateway   An existing transit gateway to a virtual private gateway   Before you perform the migration to the new gateway, you must configure the new gateway. Use CreateVpnGateway to create a virtual private gateway, or CreateTransitGateway to create a transit gateway. This step is required when you migrate from a virtual private gateway with static routes to a transit gateway.  You must delete the static routes before you migrate to the new gateway. Keep a copy of the static route before you delete it. You will need to add back these routes to the transit gateway after the VPN connection migration is complete. After you migrate to the new gateway, you might need to modify your VPC route table. Use CreateRoute and DeleteRoute to make the changes described in Update VPC route tables in the Amazon Web Services Site-to-Site VPN User Guide. When the new gateway is a transit gateway, modify the transit gateway route table to allow traffic between the VPC and the Amazon Web Services Site-to-Site VPN connection. Use CreateTransitGatewayRoute to add the routes.  If you deleted VPN static routes, you must add the static routes to the transit gateway route table. After you perform this operation, the VPN endpoint's IP addresses on the Amazon Web Services side and the tunnel options remain intact. Your Amazon Web Services Site-to-Site VPN connection will be temporarily unavailable for a brief period while we provision the new endpoints.
   */
  modifyVpnConnection(params: EC2.Types.ModifyVpnConnectionRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpnConnectionResult) => void): Request<EC2.Types.ModifyVpnConnectionResult, AWSError>;
  /**
   * Modifies the customer gateway or the target gateway of an Amazon Web Services Site-to-Site VPN connection. To modify the target gateway, the following migration options are available:   An existing virtual private gateway to a new virtual private gateway   An existing virtual private gateway to a transit gateway   An existing transit gateway to a new transit gateway   An existing transit gateway to a virtual private gateway   Before you perform the migration to the new gateway, you must configure the new gateway. Use CreateVpnGateway to create a virtual private gateway, or CreateTransitGateway to create a transit gateway. This step is required when you migrate from a virtual private gateway with static routes to a transit gateway.  You must delete the static routes before you migrate to the new gateway. Keep a copy of the static route before you delete it. You will need to add back these routes to the transit gateway after the VPN connection migration is complete. After you migrate to the new gateway, you might need to modify your VPC route table. Use CreateRoute and DeleteRoute to make the changes described in Update VPC route tables in the Amazon Web Services Site-to-Site VPN User Guide. When the new gateway is a transit gateway, modify the transit gateway route table to allow traffic between the VPC and the Amazon Web Services Site-to-Site VPN connection. Use CreateTransitGatewayRoute to add the routes.  If you deleted VPN static routes, you must add the static routes to the transit gateway route table. After you perform this operation, the VPN endpoint's IP addresses on the Amazon Web Services side and the tunnel options remain intact. Your Amazon Web Services Site-to-Site VPN connection will be temporarily unavailable for a brief period while we provision the new endpoints.
   */
  modifyVpnConnection(callback?: (err: AWSError, data: EC2.Types.ModifyVpnConnectionResult) => void): Request<EC2.Types.ModifyVpnConnectionResult, AWSError>;
  /**
   * Modifies the connection options for your Site-to-Site VPN connection. When you modify the VPN connection options, the VPN endpoint IP addresses on the Amazon Web Services side do not change, and the tunnel options do not change. Your VPN connection will be temporarily unavailable for a brief period while the VPN connection is updated.
   */
  modifyVpnConnectionOptions(params: EC2.Types.ModifyVpnConnectionOptionsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpnConnectionOptionsResult) => void): Request<EC2.Types.ModifyVpnConnectionOptionsResult, AWSError>;
  /**
   * Modifies the connection options for your Site-to-Site VPN connection. When you modify the VPN connection options, the VPN endpoint IP addresses on the Amazon Web Services side do not change, and the tunnel options do not change. Your VPN connection will be temporarily unavailable for a brief period while the VPN connection is updated.
   */
  modifyVpnConnectionOptions(callback?: (err: AWSError, data: EC2.Types.ModifyVpnConnectionOptionsResult) => void): Request<EC2.Types.ModifyVpnConnectionOptionsResult, AWSError>;
  /**
   * Modifies the VPN tunnel endpoint certificate.
   */
  modifyVpnTunnelCertificate(params: EC2.Types.ModifyVpnTunnelCertificateRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpnTunnelCertificateResult) => void): Request<EC2.Types.ModifyVpnTunnelCertificateResult, AWSError>;
  /**
   * Modifies the VPN tunnel endpoint certificate.
   */
  modifyVpnTunnelCertificate(callback?: (err: AWSError, data: EC2.Types.ModifyVpnTunnelCertificateResult) => void): Request<EC2.Types.ModifyVpnTunnelCertificateResult, AWSError>;
  /**
   * Modifies the options for a VPN tunnel in an Amazon Web Services Site-to-Site VPN connection. You can modify multiple options for a tunnel in a single request, but you can only modify one tunnel at a time. For more information, see Site-to-Site VPN tunnel options for your Site-to-Site VPN connection in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  modifyVpnTunnelOptions(params: EC2.Types.ModifyVpnTunnelOptionsRequest, callback?: (err: AWSError, data: EC2.Types.ModifyVpnTunnelOptionsResult) => void): Request<EC2.Types.ModifyVpnTunnelOptionsResult, AWSError>;
  /**
   * Modifies the options for a VPN tunnel in an Amazon Web Services Site-to-Site VPN connection. You can modify multiple options for a tunnel in a single request, but you can only modify one tunnel at a time. For more information, see Site-to-Site VPN tunnel options for your Site-to-Site VPN connection in the Amazon Web Services Site-to-Site VPN User Guide.
   */
  modifyVpnTunnelOptions(callback?: (err: AWSError, data: EC2.Types.ModifyVpnTunnelOptionsResult) => void): Request<EC2.Types.ModifyVpnTunnelOptionsResult, AWSError>;
  /**
   * Enables detailed monitoring for a running instance. Otherwise, basic monitoring is enabled. For more information, see Monitor your instances using CloudWatch in the Amazon EC2 User Guide. To disable detailed monitoring, see UnmonitorInstances.
   */
  monitorInstances(params: EC2.Types.MonitorInstancesRequest, callback?: (err: AWSError, data: EC2.Types.MonitorInstancesResult) => void): Request<EC2.Types.MonitorInstancesResult, AWSError>;
  /**
   * Enables detailed monitoring for a running instance. Otherwise, basic monitoring is enabled. For more information, see Monitor your instances using CloudWatch in the Amazon EC2 User Guide. To disable detailed monitoring, see UnmonitorInstances.
   */
  monitorInstances(callback?: (err: AWSError, data: EC2.Types.MonitorInstancesResult) => void): Request<EC2.Types.MonitorInstancesResult, AWSError>;
  /**
   * Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The Elastic IP address must be allocated to your account for more than 24 hours, and it must not be associated with an instance. After the Elastic IP address is moved, it is no longer available for use in the EC2-Classic platform, unless you move it back using the RestoreAddressToClassic request. You cannot move an Elastic IP address that was originally allocated for use in the EC2-VPC platform to the EC2-Classic platform.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  moveAddressToVpc(params: EC2.Types.MoveAddressToVpcRequest, callback?: (err: AWSError, data: EC2.Types.MoveAddressToVpcResult) => void): Request<EC2.Types.MoveAddressToVpcResult, AWSError>;
  /**
   * Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The Elastic IP address must be allocated to your account for more than 24 hours, and it must not be associated with an instance. After the Elastic IP address is moved, it is no longer available for use in the EC2-Classic platform, unless you move it back using the RestoreAddressToClassic request. You cannot move an Elastic IP address that was originally allocated for use in the EC2-VPC platform to the EC2-Classic platform.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  moveAddressToVpc(callback?: (err: AWSError, data: EC2.Types.MoveAddressToVpcResult) => void): Request<EC2.Types.MoveAddressToVpcResult, AWSError>;
  /**
   * Move an BYOIP IPv4 CIDR to IPAM from a public IPv4 pool. If you already have an IPv4 BYOIP CIDR with Amazon Web Services, you can move the CIDR to IPAM from a public IPv4 pool. You cannot move an IPv6 CIDR to IPAM. If you are bringing a new IP address to Amazon Web Services for the first time, complete the steps in Tutorial: BYOIP address CIDRs to IPAM.
   */
  moveByoipCidrToIpam(params: EC2.Types.MoveByoipCidrToIpamRequest, callback?: (err: AWSError, data: EC2.Types.MoveByoipCidrToIpamResult) => void): Request<EC2.Types.MoveByoipCidrToIpamResult, AWSError>;
  /**
   * Move an BYOIP IPv4 CIDR to IPAM from a public IPv4 pool. If you already have an IPv4 BYOIP CIDR with Amazon Web Services, you can move the CIDR to IPAM from a public IPv4 pool. You cannot move an IPv6 CIDR to IPAM. If you are bringing a new IP address to Amazon Web Services for the first time, complete the steps in Tutorial: BYOIP address CIDRs to IPAM.
   */
  moveByoipCidrToIpam(callback?: (err: AWSError, data: EC2.Types.MoveByoipCidrToIpamResult) => void): Request<EC2.Types.MoveByoipCidrToIpamResult, AWSError>;
  /**
   * Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using AdvertiseByoipCidr. Amazon Web Services verifies that you own the address range and are authorized to advertise it. You must ensure that the address range is registered to you and that you created an RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range. For more information, see Bring your own IP addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide. Provisioning an address range is an asynchronous operation, so the call returns immediately, but the address range is not ready to use until its status changes from pending-provision to provisioned. To monitor the status of an address range, use DescribeByoipCidrs. To allocate an Elastic IP address from your IPv4 address pool, use AllocateAddress with either the specific address from the address pool or the ID of the address pool.
   */
  provisionByoipCidr(params: EC2.Types.ProvisionByoipCidrRequest, callback?: (err: AWSError, data: EC2.Types.ProvisionByoipCidrResult) => void): Request<EC2.Types.ProvisionByoipCidrResult, AWSError>;
  /**
   * Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using AdvertiseByoipCidr. Amazon Web Services verifies that you own the address range and are authorized to advertise it. You must ensure that the address range is registered to you and that you created an RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range. For more information, see Bring your own IP addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide. Provisioning an address range is an asynchronous operation, so the call returns immediately, but the address range is not ready to use until its status changes from pending-provision to provisioned. To monitor the status of an address range, use DescribeByoipCidrs. To allocate an Elastic IP address from your IPv4 address pool, use AllocateAddress with either the specific address from the address pool or the ID of the address pool.
   */
  provisionByoipCidr(callback?: (err: AWSError, data: EC2.Types.ProvisionByoipCidrResult) => void): Request<EC2.Types.ProvisionByoipCidrResult, AWSError>;
  /**
   * Provision a CIDR to an IPAM pool. You can use this action to provision new CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool within it. For more information, see Provision CIDRs to pools in the Amazon VPC IPAM User Guide. 
   */
  provisionIpamPoolCidr(params: EC2.Types.ProvisionIpamPoolCidrRequest, callback?: (err: AWSError, data: EC2.Types.ProvisionIpamPoolCidrResult) => void): Request<EC2.Types.ProvisionIpamPoolCidrResult, AWSError>;
  /**
   * Provision a CIDR to an IPAM pool. You can use this action to provision new CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool within it. For more information, see Provision CIDRs to pools in the Amazon VPC IPAM User Guide. 
   */
  provisionIpamPoolCidr(callback?: (err: AWSError, data: EC2.Types.ProvisionIpamPoolCidrResult) => void): Request<EC2.Types.ProvisionIpamPoolCidrResult, AWSError>;
  /**
   * Provision a CIDR to a public IPv4 pool. For more information about IPAM, see What is IPAM? in the Amazon VPC IPAM User Guide.
   */
  provisionPublicIpv4PoolCidr(params: EC2.Types.ProvisionPublicIpv4PoolCidrRequest, callback?: (err: AWSError, data: EC2.Types.ProvisionPublicIpv4PoolCidrResult) => void): Request<EC2.Types.ProvisionPublicIpv4PoolCidrResult, AWSError>;
  /**
   * Provision a CIDR to a public IPv4 pool. For more information about IPAM, see What is IPAM? in the Amazon VPC IPAM User Guide.
   */
  provisionPublicIpv4PoolCidr(callback?: (err: AWSError, data: EC2.Types.ProvisionPublicIpv4PoolCidrResult) => void): Request<EC2.Types.ProvisionPublicIpv4PoolCidrResult, AWSError>;
  /**
   * Purchase a reservation with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This action results in the specified reservation being purchased and charged to your account.
   */
  purchaseHostReservation(params: EC2.Types.PurchaseHostReservationRequest, callback?: (err: AWSError, data: EC2.Types.PurchaseHostReservationResult) => void): Request<EC2.Types.PurchaseHostReservationResult, AWSError>;
  /**
   * Purchase a reservation with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This action results in the specified reservation being purchased and charged to your account.
   */
  purchaseHostReservation(callback?: (err: AWSError, data: EC2.Types.PurchaseHostReservationResult) => void): Request<EC2.Types.PurchaseHostReservationResult, AWSError>;
  /**
   * Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower hourly rate compared to On-Demand instance pricing. Use DescribeReservedInstancesOfferings to get a list of Reserved Instance offerings that match your specifications. After you've purchased a Reserved Instance, you can check for your new Reserved Instance with DescribeReservedInstances. To queue a purchase for a future date and time, specify a purchase time. If you do not specify a purchase time, the default is the current time. For more information, see Reserved Instances and Reserved Instance Marketplace in the Amazon EC2 User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  purchaseReservedInstancesOffering(params: EC2.Types.PurchaseReservedInstancesOfferingRequest, callback?: (err: AWSError, data: EC2.Types.PurchaseReservedInstancesOfferingResult) => void): Request<EC2.Types.PurchaseReservedInstancesOfferingResult, AWSError>;
  /**
   * Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower hourly rate compared to On-Demand instance pricing. Use DescribeReservedInstancesOfferings to get a list of Reserved Instance offerings that match your specifications. After you've purchased a Reserved Instance, you can check for your new Reserved Instance with DescribeReservedInstances. To queue a purchase for a future date and time, specify a purchase time. If you do not specify a purchase time, the default is the current time. For more information, see Reserved Instances and Reserved Instance Marketplace in the Amazon EC2 User Guide.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  purchaseReservedInstancesOffering(callback?: (err: AWSError, data: EC2.Types.PurchaseReservedInstancesOfferingResult) => void): Request<EC2.Types.PurchaseReservedInstancesOfferingResult, AWSError>;
  /**
   *  You can no longer purchase Scheduled Instances.  Purchases the Scheduled Instances with the specified schedule. Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term. Before you can purchase a Scheduled Instance, you must call DescribeScheduledInstanceAvailability to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance, you must call RunScheduledInstances during each scheduled time period. After you purchase a Scheduled Instance, you can't cancel, modify, or resell your purchase.
   */
  purchaseScheduledInstances(params: EC2.Types.PurchaseScheduledInstancesRequest, callback?: (err: AWSError, data: EC2.Types.PurchaseScheduledInstancesResult) => void): Request<EC2.Types.PurchaseScheduledInstancesResult, AWSError>;
  /**
   *  You can no longer purchase Scheduled Instances.  Purchases the Scheduled Instances with the specified schedule. Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term. Before you can purchase a Scheduled Instance, you must call DescribeScheduledInstanceAvailability to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance, you must call RunScheduledInstances during each scheduled time period. After you purchase a Scheduled Instance, you can't cancel, modify, or resell your purchase.
   */
  purchaseScheduledInstances(callback?: (err: AWSError, data: EC2.Types.PurchaseScheduledInstancesResult) => void): Request<EC2.Types.PurchaseScheduledInstancesResult, AWSError>;
  /**
   * Requests a reboot of the specified instances. This operation is asynchronous; it only queues a request to reboot the specified instances. The operation succeeds if the instances are valid and belong to you. Requests to reboot terminated instances are ignored. If an instance does not cleanly shut down within a few minutes, Amazon EC2 performs a hard reboot. For more information about troubleshooting, see Troubleshoot an unreachable instance in the Amazon EC2 User Guide.
   */
  rebootInstances(params: EC2.Types.RebootInstancesRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Requests a reboot of the specified instances. This operation is asynchronous; it only queues a request to reboot the specified instances. The operation succeeds if the instances are valid and belong to you. Requests to reboot terminated instances are ignored. If an instance does not cleanly shut down within a few minutes, Amazon EC2 performs a hard reboot. For more information about troubleshooting, see Troubleshoot an unreachable instance in the Amazon EC2 User Guide.
   */
  rebootInstances(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Registers an AMI. When you're creating an AMI, this is the final step you must complete before you can launch an instance from the AMI. For more information about creating AMIs, see Create your own AMI in the Amazon Elastic Compute Cloud User Guide.  For Amazon EBS-backed instances, CreateImage creates and registers the AMI in a single request, so you don't have to register the AMI yourself. We recommend that you always use CreateImage unless you have a specific reason to use RegisterImage.  If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration. If you make changes to an image, deregister the previous image and register the new image.  Register a snapshot of a root device volume  You can use RegisterImage to create an Amazon EBS-backed Linux AMI from a snapshot of a root device volume. You specify the snapshot using a block device mapping. You can't set the encryption state of the volume using the block device mapping. If the snapshot is encrypted, or encryption by default is enabled, the root volume of an instance launched from the AMI is encrypted. For more information, see Create a Linux AMI from a snapshot and Use encryption with Amazon EBS-backed AMIs in the Amazon Elastic Compute Cloud User Guide.  Amazon Web Services Marketplace product codes  If any snapshots have Amazon Web Services Marketplace product codes, they are copied to the new AMI. Windows and some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE Linux Enterprise Server (SLES), use the Amazon EC2 billing product code associated with an AMI to verify the subscription status for package updates. To create a new AMI for operating systems that require a billing product code, instead of registering the AMI, do the following to preserve the billing product code association:   Launch an instance from an existing AMI with that billing product code.   Customize the instance.   Create an AMI from the instance using CreateImage.   If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched from an AMI with a billing product code, make sure that the Reserved Instance has the matching billing product code. If you purchase a Reserved Instance without the matching billing product code, the Reserved Instance will not be applied to the On-Demand Instance. For information about how to obtain the platform details and billing information of an AMI, see Understand AMI billing information in the Amazon Elastic Compute Cloud User Guide.
   */
  registerImage(params: EC2.Types.RegisterImageRequest, callback?: (err: AWSError, data: EC2.Types.RegisterImageResult) => void): Request<EC2.Types.RegisterImageResult, AWSError>;
  /**
   * Registers an AMI. When you're creating an AMI, this is the final step you must complete before you can launch an instance from the AMI. For more information about creating AMIs, see Create your own AMI in the Amazon Elastic Compute Cloud User Guide.  For Amazon EBS-backed instances, CreateImage creates and registers the AMI in a single request, so you don't have to register the AMI yourself. We recommend that you always use CreateImage unless you have a specific reason to use RegisterImage.  If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration. If you make changes to an image, deregister the previous image and register the new image.  Register a snapshot of a root device volume  You can use RegisterImage to create an Amazon EBS-backed Linux AMI from a snapshot of a root device volume. You specify the snapshot using a block device mapping. You can't set the encryption state of the volume using the block device mapping. If the snapshot is encrypted, or encryption by default is enabled, the root volume of an instance launched from the AMI is encrypted. For more information, see Create a Linux AMI from a snapshot and Use encryption with Amazon EBS-backed AMIs in the Amazon Elastic Compute Cloud User Guide.  Amazon Web Services Marketplace product codes  If any snapshots have Amazon Web Services Marketplace product codes, they are copied to the new AMI. Windows and some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE Linux Enterprise Server (SLES), use the Amazon EC2 billing product code associated with an AMI to verify the subscription status for package updates. To create a new AMI for operating systems that require a billing product code, instead of registering the AMI, do the following to preserve the billing product code association:   Launch an instance from an existing AMI with that billing product code.   Customize the instance.   Create an AMI from the instance using CreateImage.   If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched from an AMI with a billing product code, make sure that the Reserved Instance has the matching billing product code. If you purchase a Reserved Instance without the matching billing product code, the Reserved Instance will not be applied to the On-Demand Instance. For information about how to obtain the platform details and billing information of an AMI, see Understand AMI billing information in the Amazon Elastic Compute Cloud User Guide.
   */
  registerImage(callback?: (err: AWSError, data: EC2.Types.RegisterImageResult) => void): Request<EC2.Types.RegisterImageResult, AWSError>;
  /**
   * Registers a set of tag keys to include in scheduled event notifications for your resources.  To remove tags, use DeregisterInstanceEventNotificationAttributes.
   */
  registerInstanceEventNotificationAttributes(params: EC2.Types.RegisterInstanceEventNotificationAttributesRequest, callback?: (err: AWSError, data: EC2.Types.RegisterInstanceEventNotificationAttributesResult) => void): Request<EC2.Types.RegisterInstanceEventNotificationAttributesResult, AWSError>;
  /**
   * Registers a set of tag keys to include in scheduled event notifications for your resources.  To remove tags, use DeregisterInstanceEventNotificationAttributes.
   */
  registerInstanceEventNotificationAttributes(callback?: (err: AWSError, data: EC2.Types.RegisterInstanceEventNotificationAttributesResult) => void): Request<EC2.Types.RegisterInstanceEventNotificationAttributesResult, AWSError>;
  /**
   * Registers members (network interfaces) with the transit gateway multicast group. A member is a network interface associated with a supported EC2 instance that receives multicast traffic. For information about supported instances, see Multicast Consideration in Amazon VPC Transit Gateways. After you add the members, use SearchTransitGatewayMulticastGroups to verify that the members were added to the transit gateway multicast group.
   */
  registerTransitGatewayMulticastGroupMembers(params: EC2.Types.RegisterTransitGatewayMulticastGroupMembersRequest, callback?: (err: AWSError, data: EC2.Types.RegisterTransitGatewayMulticastGroupMembersResult) => void): Request<EC2.Types.RegisterTransitGatewayMulticastGroupMembersResult, AWSError>;
  /**
   * Registers members (network interfaces) with the transit gateway multicast group. A member is a network interface associated with a supported EC2 instance that receives multicast traffic. For information about supported instances, see Multicast Consideration in Amazon VPC Transit Gateways. After you add the members, use SearchTransitGatewayMulticastGroups to verify that the members were added to the transit gateway multicast group.
   */
  registerTransitGatewayMulticastGroupMembers(callback?: (err: AWSError, data: EC2.Types.RegisterTransitGatewayMulticastGroupMembersResult) => void): Request<EC2.Types.RegisterTransitGatewayMulticastGroupMembersResult, AWSError>;
  /**
   * Registers sources (network interfaces) with the specified transit gateway multicast group. A multicast source is a network interface attached to a supported instance that sends multicast traffic. For information about supported instances, see Multicast Considerations in Amazon VPC Transit Gateways. After you add the source, use SearchTransitGatewayMulticastGroups to verify that the source was added to the multicast group.
   */
  registerTransitGatewayMulticastGroupSources(params: EC2.Types.RegisterTransitGatewayMulticastGroupSourcesRequest, callback?: (err: AWSError, data: EC2.Types.RegisterTransitGatewayMulticastGroupSourcesResult) => void): Request<EC2.Types.RegisterTransitGatewayMulticastGroupSourcesResult, AWSError>;
  /**
   * Registers sources (network interfaces) with the specified transit gateway multicast group. A multicast source is a network interface attached to a supported instance that sends multicast traffic. For information about supported instances, see Multicast Considerations in Amazon VPC Transit Gateways. After you add the source, use SearchTransitGatewayMulticastGroups to verify that the source was added to the multicast group.
   */
  registerTransitGatewayMulticastGroupSources(callback?: (err: AWSError, data: EC2.Types.RegisterTransitGatewayMulticastGroupSourcesResult) => void): Request<EC2.Types.RegisterTransitGatewayMulticastGroupSourcesResult, AWSError>;
  /**
   * Rejects a request to associate cross-account subnets with a transit gateway multicast domain.
   */
  rejectTransitGatewayMulticastDomainAssociations(params: EC2.Types.RejectTransitGatewayMulticastDomainAssociationsRequest, callback?: (err: AWSError, data: EC2.Types.RejectTransitGatewayMulticastDomainAssociationsResult) => void): Request<EC2.Types.RejectTransitGatewayMulticastDomainAssociationsResult, AWSError>;
  /**
   * Rejects a request to associate cross-account subnets with a transit gateway multicast domain.
   */
  rejectTransitGatewayMulticastDomainAssociations(callback?: (err: AWSError, data: EC2.Types.RejectTransitGatewayMulticastDomainAssociationsResult) => void): Request<EC2.Types.RejectTransitGatewayMulticastDomainAssociationsResult, AWSError>;
  /**
   * Rejects a transit gateway peering attachment request.
   */
  rejectTransitGatewayPeeringAttachment(params: EC2.Types.RejectTransitGatewayPeeringAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.RejectTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.RejectTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Rejects a transit gateway peering attachment request.
   */
  rejectTransitGatewayPeeringAttachment(callback?: (err: AWSError, data: EC2.Types.RejectTransitGatewayPeeringAttachmentResult) => void): Request<EC2.Types.RejectTransitGatewayPeeringAttachmentResult, AWSError>;
  /**
   * Rejects a request to attach a VPC to a transit gateway. The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests. Use AcceptTransitGatewayVpcAttachment to accept a VPC attachment request.
   */
  rejectTransitGatewayVpcAttachment(params: EC2.Types.RejectTransitGatewayVpcAttachmentRequest, callback?: (err: AWSError, data: EC2.Types.RejectTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.RejectTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Rejects a request to attach a VPC to a transit gateway. The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests. Use AcceptTransitGatewayVpcAttachment to accept a VPC attachment request.
   */
  rejectTransitGatewayVpcAttachment(callback?: (err: AWSError, data: EC2.Types.RejectTransitGatewayVpcAttachmentResult) => void): Request<EC2.Types.RejectTransitGatewayVpcAttachmentResult, AWSError>;
  /**
   * Rejects one or more VPC endpoint connection requests to your VPC endpoint service.
   */
  rejectVpcEndpointConnections(params: EC2.Types.RejectVpcEndpointConnectionsRequest, callback?: (err: AWSError, data: EC2.Types.RejectVpcEndpointConnectionsResult) => void): Request<EC2.Types.RejectVpcEndpointConnectionsResult, AWSError>;
  /**
   * Rejects one or more VPC endpoint connection requests to your VPC endpoint service.
   */
  rejectVpcEndpointConnections(callback?: (err: AWSError, data: EC2.Types.RejectVpcEndpointConnectionsResult) => void): Request<EC2.Types.RejectVpcEndpointConnectionsResult, AWSError>;
  /**
   * Rejects a VPC peering connection request. The VPC peering connection must be in the pending-acceptance state. Use the DescribeVpcPeeringConnections request to view your outstanding VPC peering connection requests. To delete an active VPC peering connection, or to delete a VPC peering connection request that you initiated, use DeleteVpcPeeringConnection.
   */
  rejectVpcPeeringConnection(params: EC2.Types.RejectVpcPeeringConnectionRequest, callback?: (err: AWSError, data: EC2.Types.RejectVpcPeeringConnectionResult) => void): Request<EC2.Types.RejectVpcPeeringConnectionResult, AWSError>;
  /**
   * Rejects a VPC peering connection request. The VPC peering connection must be in the pending-acceptance state. Use the DescribeVpcPeeringConnections request to view your outstanding VPC peering connection requests. To delete an active VPC peering connection, or to delete a VPC peering connection request that you initiated, use DeleteVpcPeeringConnection.
   */
  rejectVpcPeeringConnection(callback?: (err: AWSError, data: EC2.Types.RejectVpcPeeringConnectionResult) => void): Request<EC2.Types.RejectVpcPeeringConnectionResult, AWSError>;
  /**
   * Releases the specified Elastic IP address. [EC2-Classic, default VPC] Releasing an Elastic IP address automatically disassociates it from any instance that it's associated with. To disassociate an Elastic IP address without releasing it, use DisassociateAddress.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  [Nondefault VPC] You must use DisassociateAddress to disassociate the Elastic IP address before you can release it. Otherwise, Amazon EC2 returns an error (InvalidIPAddress.InUse). After releasing an Elastic IP address, it is released to the IP address pool. Be sure to update your DNS records and any servers or devices that communicate with the address. If you attempt to release an Elastic IP address that you already released, you'll get an AuthFailure error if the address is already allocated to another Amazon Web Services account. [EC2-VPC] After you release an Elastic IP address for use in a VPC, you might be able to recover it. For more information, see AllocateAddress. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
   */
  releaseAddress(params: EC2.Types.ReleaseAddressRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Releases the specified Elastic IP address. [EC2-Classic, default VPC] Releasing an Elastic IP address automatically disassociates it from any instance that it's associated with. To disassociate an Elastic IP address without releasing it, use DisassociateAddress.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide.  [Nondefault VPC] You must use DisassociateAddress to disassociate the Elastic IP address before you can release it. Otherwise, Amazon EC2 returns an error (InvalidIPAddress.InUse). After releasing an Elastic IP address, it is released to the IP address pool. Be sure to update your DNS records and any servers or devices that communicate with the address. If you attempt to release an Elastic IP address that you already released, you'll get an AuthFailure error if the address is already allocated to another Amazon Web Services account. [EC2-VPC] After you release an Elastic IP address for use in a VPC, you might be able to recover it. For more information, see AllocateAddress. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
   */
  releaseAddress(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * When you no longer want to use an On-Demand Dedicated Host it can be released. On-Demand billing is stopped and the host goes into released state. The host ID of Dedicated Hosts that have been released can no longer be specified in another request, for example, to modify the host. You must stop or terminate all instances on a host before it can be released. When Dedicated Hosts are released, it may take some time for them to stop counting toward your limit and you may receive capacity errors when trying to allocate new Dedicated Hosts. Wait a few minutes and then try again. Released hosts still appear in a DescribeHosts response.
   */
  releaseHosts(params: EC2.Types.ReleaseHostsRequest, callback?: (err: AWSError, data: EC2.Types.ReleaseHostsResult) => void): Request<EC2.Types.ReleaseHostsResult, AWSError>;
  /**
   * When you no longer want to use an On-Demand Dedicated Host it can be released. On-Demand billing is stopped and the host goes into released state. The host ID of Dedicated Hosts that have been released can no longer be specified in another request, for example, to modify the host. You must stop or terminate all instances on a host before it can be released. When Dedicated Hosts are released, it may take some time for them to stop counting toward your limit and you may receive capacity errors when trying to allocate new Dedicated Hosts. Wait a few minutes and then try again. Released hosts still appear in a DescribeHosts response.
   */
  releaseHosts(callback?: (err: AWSError, data: EC2.Types.ReleaseHostsResult) => void): Request<EC2.Types.ReleaseHostsResult, AWSError>;
  /**
   * Release an allocation within an IPAM pool. You can only use this action to release manual allocations. To remove an allocation for a resource without deleting the resource, set its monitored state to false using ModifyIpamResourceCidr. For more information, see Release an allocation in the Amazon VPC IPAM User Guide. 
   */
  releaseIpamPoolAllocation(params: EC2.Types.ReleaseIpamPoolAllocationRequest, callback?: (err: AWSError, data: EC2.Types.ReleaseIpamPoolAllocationResult) => void): Request<EC2.Types.ReleaseIpamPoolAllocationResult, AWSError>;
  /**
   * Release an allocation within an IPAM pool. You can only use this action to release manual allocations. To remove an allocation for a resource without deleting the resource, set its monitored state to false using ModifyIpamResourceCidr. For more information, see Release an allocation in the Amazon VPC IPAM User Guide. 
   */
  releaseIpamPoolAllocation(callback?: (err: AWSError, data: EC2.Types.ReleaseIpamPoolAllocationResult) => void): Request<EC2.Types.ReleaseIpamPoolAllocationResult, AWSError>;
  /**
   * Replaces an IAM instance profile for the specified running instance. You can use this action to change the IAM instance profile that's associated with an instance without having to disassociate the existing IAM instance profile first. Use DescribeIamInstanceProfileAssociations to get the association ID.
   */
  replaceIamInstanceProfileAssociation(params: EC2.Types.ReplaceIamInstanceProfileAssociationRequest, callback?: (err: AWSError, data: EC2.Types.ReplaceIamInstanceProfileAssociationResult) => void): Request<EC2.Types.ReplaceIamInstanceProfileAssociationResult, AWSError>;
  /**
   * Replaces an IAM instance profile for the specified running instance. You can use this action to change the IAM instance profile that's associated with an instance without having to disassociate the existing IAM instance profile first. Use DescribeIamInstanceProfileAssociations to get the association ID.
   */
  replaceIamInstanceProfileAssociation(callback?: (err: AWSError, data: EC2.Types.ReplaceIamInstanceProfileAssociationResult) => void): Request<EC2.Types.ReplaceIamInstanceProfileAssociationResult, AWSError>;
  /**
   * Changes which network ACL a subnet is associated with. By default when you create a subnet, it's automatically associated with the default network ACL. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide. This is an idempotent operation.
   */
  replaceNetworkAclAssociation(params: EC2.Types.ReplaceNetworkAclAssociationRequest, callback?: (err: AWSError, data: EC2.Types.ReplaceNetworkAclAssociationResult) => void): Request<EC2.Types.ReplaceNetworkAclAssociationResult, AWSError>;
  /**
   * Changes which network ACL a subnet is associated with. By default when you create a subnet, it's automatically associated with the default network ACL. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide. This is an idempotent operation.
   */
  replaceNetworkAclAssociation(callback?: (err: AWSError, data: EC2.Types.ReplaceNetworkAclAssociationResult) => void): Request<EC2.Types.ReplaceNetworkAclAssociationResult, AWSError>;
  /**
   * Replaces an entry (rule) in a network ACL. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  replaceNetworkAclEntry(params: EC2.Types.ReplaceNetworkAclEntryRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Replaces an entry (rule) in a network ACL. For more information, see Network ACLs in the Amazon Virtual Private Cloud User Guide.
   */
  replaceNetworkAclEntry(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Replaces an existing route within a route table in a VPC. You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the resources from the parameter list, or reset the local route to its default target. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  replaceRoute(params: EC2.Types.ReplaceRouteRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Replaces an existing route within a route table in a VPC. You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the resources from the parameter list, or reset the local route to its default target. For more information, see Route tables in the Amazon Virtual Private Cloud User Guide.
   */
  replaceRoute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation completes, the subnet or gateway uses the routes in the new route table. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide. You can also use this operation to change which table is the main route table in the VPC. Specify the main route table's association ID and the route table ID of the new main route table.
   */
  replaceRouteTableAssociation(params: EC2.Types.ReplaceRouteTableAssociationRequest, callback?: (err: AWSError, data: EC2.Types.ReplaceRouteTableAssociationResult) => void): Request<EC2.Types.ReplaceRouteTableAssociationResult, AWSError>;
  /**
   * Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation completes, the subnet or gateway uses the routes in the new route table. For more information about route tables, see Route tables in the Amazon Virtual Private Cloud User Guide. You can also use this operation to change which table is the main route table in the VPC. Specify the main route table's association ID and the route table ID of the new main route table.
   */
  replaceRouteTableAssociation(callback?: (err: AWSError, data: EC2.Types.ReplaceRouteTableAssociationResult) => void): Request<EC2.Types.ReplaceRouteTableAssociationResult, AWSError>;
  /**
   * Replaces the specified route in the specified transit gateway route table.
   */
  replaceTransitGatewayRoute(params: EC2.Types.ReplaceTransitGatewayRouteRequest, callback?: (err: AWSError, data: EC2.Types.ReplaceTransitGatewayRouteResult) => void): Request<EC2.Types.ReplaceTransitGatewayRouteResult, AWSError>;
  /**
   * Replaces the specified route in the specified transit gateway route table.
   */
  replaceTransitGatewayRoute(callback?: (err: AWSError, data: EC2.Types.ReplaceTransitGatewayRouteResult) => void): Request<EC2.Types.ReplaceTransitGatewayRouteResult, AWSError>;
  /**
   * Submits feedback about the status of an instance. The instance must be in the running state. If your experience with the instance differs from the instance status returned by DescribeInstanceStatus, use ReportInstanceStatus to report your experience with the instance. Amazon EC2 collects this information to improve the accuracy of status checks. Use of this action does not change the value returned by DescribeInstanceStatus.
   */
  reportInstanceStatus(params: EC2.Types.ReportInstanceStatusRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Submits feedback about the status of an instance. The instance must be in the running state. If your experience with the instance differs from the instance status returned by DescribeInstanceStatus, use ReportInstanceStatus to report your experience with the instance. Amazon EC2 collects this information to improve the accuracy of status checks. Use of this action does not change the value returned by DescribeInstanceStatus.
   */
  reportInstanceStatus(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Creates a Spot Fleet request. The Spot Fleet request specifies the total target capacity and the On-Demand target capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand capacity, and launches the difference as Spot capacity. You can submit a single request that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet. By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the price per unit is the lowest. Each launch specification can include its own instance weighting that reflects the value of the instance type to your application workload. Alternatively, you can specify that the Spot Fleet distribute the target capacity across the Spot pools included in its launch specifications. By ensuring that the Spot Instances in your Spot Fleet are in different Spot pools, you can improve the availability of your fleet. You can specify tags for the Spot Fleet request and instances launched by the fleet. You cannot tag other resource types in a Spot Fleet request because only the spot-fleet-request and instance resource types are supported. For more information, see Spot Fleet requests in the Amazon EC2 User Guide.  We strongly discourage using the RequestSpotFleet API because it is a legacy API with no planned investment. For options for requesting Spot Instances, see Which is the best Spot request method to use? in the Amazon EC2 User Guide. 
   */
  requestSpotFleet(params: EC2.Types.RequestSpotFleetRequest, callback?: (err: AWSError, data: EC2.Types.RequestSpotFleetResponse) => void): Request<EC2.Types.RequestSpotFleetResponse, AWSError>;
  /**
   * Creates a Spot Fleet request. The Spot Fleet request specifies the total target capacity and the On-Demand target capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand capacity, and launches the difference as Spot capacity. You can submit a single request that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet. By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the price per unit is the lowest. Each launch specification can include its own instance weighting that reflects the value of the instance type to your application workload. Alternatively, you can specify that the Spot Fleet distribute the target capacity across the Spot pools included in its launch specifications. By ensuring that the Spot Instances in your Spot Fleet are in different Spot pools, you can improve the availability of your fleet. You can specify tags for the Spot Fleet request and instances launched by the fleet. You cannot tag other resource types in a Spot Fleet request because only the spot-fleet-request and instance resource types are supported. For more information, see Spot Fleet requests in the Amazon EC2 User Guide.  We strongly discourage using the RequestSpotFleet API because it is a legacy API with no planned investment. For options for requesting Spot Instances, see Which is the best Spot request method to use? in the Amazon EC2 User Guide. 
   */
  requestSpotFleet(callback?: (err: AWSError, data: EC2.Types.RequestSpotFleetResponse) => void): Request<EC2.Types.RequestSpotFleetResponse, AWSError>;
  /**
   * Creates a Spot Instance request. For more information, see Spot Instance requests in the Amazon EC2 User Guide for Linux Instances.  We strongly discourage using the RequestSpotInstances API because it is a legacy API with no planned investment. For options for requesting Spot Instances, see Which is the best Spot request method to use? in the Amazon EC2 User Guide for Linux Instances.   We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon EC2 User Guide for Linux Instances. 
   */
  requestSpotInstances(params: EC2.Types.RequestSpotInstancesRequest, callback?: (err: AWSError, data: EC2.Types.RequestSpotInstancesResult) => void): Request<EC2.Types.RequestSpotInstancesResult, AWSError>;
  /**
   * Creates a Spot Instance request. For more information, see Spot Instance requests in the Amazon EC2 User Guide for Linux Instances.  We strongly discourage using the RequestSpotInstances API because it is a legacy API with no planned investment. For options for requesting Spot Instances, see Which is the best Spot request method to use? in the Amazon EC2 User Guide for Linux Instances.   We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon EC2 User Guide for Linux Instances. 
   */
  requestSpotInstances(callback?: (err: AWSError, data: EC2.Types.RequestSpotInstancesResult) => void): Request<EC2.Types.RequestSpotInstancesResult, AWSError>;
  /**
   * Resets the attribute of the specified IP address. For requirements, see Using reverse DNS for email applications.
   */
  resetAddressAttribute(params: EC2.Types.ResetAddressAttributeRequest, callback?: (err: AWSError, data: EC2.Types.ResetAddressAttributeResult) => void): Request<EC2.Types.ResetAddressAttributeResult, AWSError>;
  /**
   * Resets the attribute of the specified IP address. For requirements, see Using reverse DNS for email applications.
   */
  resetAddressAttribute(callback?: (err: AWSError, data: EC2.Types.ResetAddressAttributeResult) => void): Request<EC2.Types.ResetAddressAttributeResult, AWSError>;
  /**
   * Resets the default KMS key for EBS encryption for your account in this Region to the Amazon Web Services managed KMS key for EBS. After resetting the default KMS key to the Amazon Web Services managed KMS key, you can continue to encrypt by a customer managed KMS key by specifying it when you create the volume. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  resetEbsDefaultKmsKeyId(params: EC2.Types.ResetEbsDefaultKmsKeyIdRequest, callback?: (err: AWSError, data: EC2.Types.ResetEbsDefaultKmsKeyIdResult) => void): Request<EC2.Types.ResetEbsDefaultKmsKeyIdResult, AWSError>;
  /**
   * Resets the default KMS key for EBS encryption for your account in this Region to the Amazon Web Services managed KMS key for EBS. After resetting the default KMS key to the Amazon Web Services managed KMS key, you can continue to encrypt by a customer managed KMS key by specifying it when you create the volume. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
   */
  resetEbsDefaultKmsKeyId(callback?: (err: AWSError, data: EC2.Types.ResetEbsDefaultKmsKeyIdResult) => void): Request<EC2.Types.ResetEbsDefaultKmsKeyIdResult, AWSError>;
  /**
   * Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value. You can only reset the load permission attribute.
   */
  resetFpgaImageAttribute(params: EC2.Types.ResetFpgaImageAttributeRequest, callback?: (err: AWSError, data: EC2.Types.ResetFpgaImageAttributeResult) => void): Request<EC2.Types.ResetFpgaImageAttributeResult, AWSError>;
  /**
   * Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value. You can only reset the load permission attribute.
   */
  resetFpgaImageAttribute(callback?: (err: AWSError, data: EC2.Types.ResetFpgaImageAttributeResult) => void): Request<EC2.Types.ResetFpgaImageAttributeResult, AWSError>;
  /**
   * Resets an attribute of an AMI to its default value.
   */
  resetImageAttribute(params: EC2.Types.ResetImageAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Resets an attribute of an AMI to its default value.
   */
  resetImageAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Resets an attribute of an instance to its default value. To reset the kernel or ramdisk, the instance must be in a stopped state. To reset the sourceDestCheck, the instance can be either running or stopped. The sourceDestCheck attribute controls whether source/destination checking is enabled. The default value is true, which means checking is enabled. This value must be false for a NAT instance to perform NAT. For more information, see NAT Instances in the Amazon VPC User Guide.
   */
  resetInstanceAttribute(params: EC2.Types.ResetInstanceAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Resets an attribute of an instance to its default value. To reset the kernel or ramdisk, the instance must be in a stopped state. To reset the sourceDestCheck, the instance can be either running or stopped. The sourceDestCheck attribute controls whether source/destination checking is enabled. The default value is true, which means checking is enabled. This value must be false for a NAT instance to perform NAT. For more information, see NAT Instances in the Amazon VPC User Guide.
   */
  resetInstanceAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Resets a network interface attribute. You can specify only one attribute at a time.
   */
  resetNetworkInterfaceAttribute(params: EC2.Types.ResetNetworkInterfaceAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Resets a network interface attribute. You can specify only one attribute at a time.
   */
  resetNetworkInterfaceAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Resets permission settings for the specified snapshot. For more information about modifying snapshot permissions, see Share a snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  resetSnapshotAttribute(params: EC2.Types.ResetSnapshotAttributeRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Resets permission settings for the specified snapshot. For more information about modifying snapshot permissions, see Share a snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  resetSnapshotAttribute(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  restoreAddressToClassic(params: EC2.Types.RestoreAddressToClassicRequest, callback?: (err: AWSError, data: EC2.Types.RestoreAddressToClassicResult) => void): Request<EC2.Types.RestoreAddressToClassicResult, AWSError>;
  /**
   * Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  restoreAddressToClassic(callback?: (err: AWSError, data: EC2.Types.RestoreAddressToClassicResult) => void): Request<EC2.Types.RestoreAddressToClassicResult, AWSError>;
  /**
   * Restores an AMI from the Recycle Bin. For more information, see Recycle Bin in the Amazon Elastic Compute Cloud User Guide.
   */
  restoreImageFromRecycleBin(params: EC2.Types.RestoreImageFromRecycleBinRequest, callback?: (err: AWSError, data: EC2.Types.RestoreImageFromRecycleBinResult) => void): Request<EC2.Types.RestoreImageFromRecycleBinResult, AWSError>;
  /**
   * Restores an AMI from the Recycle Bin. For more information, see Recycle Bin in the Amazon Elastic Compute Cloud User Guide.
   */
  restoreImageFromRecycleBin(callback?: (err: AWSError, data: EC2.Types.RestoreImageFromRecycleBinResult) => void): Request<EC2.Types.RestoreImageFromRecycleBinResult, AWSError>;
  /**
   * Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.
   */
  restoreManagedPrefixListVersion(params: EC2.Types.RestoreManagedPrefixListVersionRequest, callback?: (err: AWSError, data: EC2.Types.RestoreManagedPrefixListVersionResult) => void): Request<EC2.Types.RestoreManagedPrefixListVersionResult, AWSError>;
  /**
   * Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.
   */
  restoreManagedPrefixListVersion(callback?: (err: AWSError, data: EC2.Types.RestoreManagedPrefixListVersionResult) => void): Request<EC2.Types.RestoreManagedPrefixListVersionResult, AWSError>;
  /**
   * Restores a snapshot from the Recycle Bin. For more information, see Restore snapshots from the Recycle Bin in the Amazon Elastic Compute Cloud User Guide.
   */
  restoreSnapshotFromRecycleBin(params: EC2.Types.RestoreSnapshotFromRecycleBinRequest, callback?: (err: AWSError, data: EC2.Types.RestoreSnapshotFromRecycleBinResult) => void): Request<EC2.Types.RestoreSnapshotFromRecycleBinResult, AWSError>;
  /**
   * Restores a snapshot from the Recycle Bin. For more information, see Restore snapshots from the Recycle Bin in the Amazon Elastic Compute Cloud User Guide.
   */
  restoreSnapshotFromRecycleBin(callback?: (err: AWSError, data: EC2.Types.RestoreSnapshotFromRecycleBinResult) => void): Request<EC2.Types.RestoreSnapshotFromRecycleBinResult, AWSError>;
  /**
   * Restores an archived Amazon EBS snapshot for use temporarily or permanently, or modifies the restore period or restore type for a snapshot that was previously temporarily restored. For more information see  Restore an archived snapshot and  modify the restore period or restore type for a temporarily restored snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  restoreSnapshotTier(params: EC2.Types.RestoreSnapshotTierRequest, callback?: (err: AWSError, data: EC2.Types.RestoreSnapshotTierResult) => void): Request<EC2.Types.RestoreSnapshotTierResult, AWSError>;
  /**
   * Restores an archived Amazon EBS snapshot for use temporarily or permanently, or modifies the restore period or restore type for a snapshot that was previously temporarily restored. For more information see  Restore an archived snapshot and  modify the restore period or restore type for a temporarily restored snapshot in the Amazon Elastic Compute Cloud User Guide.
   */
  restoreSnapshotTier(callback?: (err: AWSError, data: EC2.Types.RestoreSnapshotTierResult) => void): Request<EC2.Types.RestoreSnapshotTierResult, AWSError>;
  /**
   * Removes an ingress authorization rule from a Client VPN endpoint. 
   */
  revokeClientVpnIngress(params: EC2.Types.RevokeClientVpnIngressRequest, callback?: (err: AWSError, data: EC2.Types.RevokeClientVpnIngressResult) => void): Request<EC2.Types.RevokeClientVpnIngressResult, AWSError>;
  /**
   * Removes an ingress authorization rule from a Client VPN endpoint. 
   */
  revokeClientVpnIngress(callback?: (err: AWSError, data: EC2.Types.RevokeClientVpnIngressResult) => void): Request<EC2.Types.RevokeClientVpnIngressResult, AWSError>;
  /**
   * [VPC only] Removes the specified outbound (egress) rules from a security group for EC2-VPC. This action does not apply to security groups for use in EC2-Classic. You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule's values exactly. Each rule has a protocol, from and to ports, and destination (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule. [Default VPC] If the values you specify do not match the existing rule's values, no error is returned, and the output describes the security group rules that were not revoked. Amazon Web Services recommends that you describe the security group to verify that the rules were removed. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.
   */
  revokeSecurityGroupEgress(params: EC2.Types.RevokeSecurityGroupEgressRequest, callback?: (err: AWSError, data: EC2.Types.RevokeSecurityGroupEgressResult) => void): Request<EC2.Types.RevokeSecurityGroupEgressResult, AWSError>;
  /**
   * [VPC only] Removes the specified outbound (egress) rules from a security group for EC2-VPC. This action does not apply to security groups for use in EC2-Classic. You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule's values exactly. Each rule has a protocol, from and to ports, and destination (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule. [Default VPC] If the values you specify do not match the existing rule's values, no error is returned, and the output describes the security group rules that were not revoked. Amazon Web Services recommends that you describe the security group to verify that the rules were removed. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.
   */
  revokeSecurityGroupEgress(callback?: (err: AWSError, data: EC2.Types.RevokeSecurityGroupEgressResult) => void): Request<EC2.Types.RevokeSecurityGroupEgressResult, AWSError>;
  /**
   * Removes the specified inbound (ingress) rules from a security group. You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule's values exactly. Each rule has a protocol, from and to ports, and source (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule. [EC2-Classic, default VPC] If the values you specify do not match the existing rule's values, no error is returned, and the output describes the security group rules that were not revoked. Amazon Web Services recommends that you describe the security group to verify that the rules were removed. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  revokeSecurityGroupIngress(params: EC2.Types.RevokeSecurityGroupIngressRequest, callback?: (err: AWSError, data: EC2.Types.RevokeSecurityGroupIngressResult) => void): Request<EC2.Types.RevokeSecurityGroupIngressResult, AWSError>;
  /**
   * Removes the specified inbound (ingress) rules from a security group. You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule's values exactly. Each rule has a protocol, from and to ports, and source (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule. [EC2-Classic, default VPC] If the values you specify do not match the existing rule's values, no error is returned, and the output describes the security group rules that were not revoked. Amazon Web Services recommends that you describe the security group to verify that the rules were removed. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon Elastic Compute Cloud User Guide. 
   */
  revokeSecurityGroupIngress(callback?: (err: AWSError, data: EC2.Types.RevokeSecurityGroupIngressResult) => void): Request<EC2.Types.RevokeSecurityGroupIngressResult, AWSError>;
  /**
   * Launches the specified number of instances using an AMI for which you have permissions. You can specify a number of options, or leave the default options. The following rules apply:   [EC2-VPC] If you don't specify a subnet ID, we choose a default subnet from your default VPC for you. If you don't have a default VPC, you must specify a subnet ID in the request.   [EC2-Classic] If don't specify an Availability Zone, we choose one for you.   Some instance types must be launched into a VPC. If you do not have a default VPC, or if you do not specify a subnet ID, the request fails. For more information, see Instance types available only in a VPC.   [EC2-VPC] All instances have a network interface with a primary private IPv4 address. If you don't specify this address, we choose one from the IPv4 range of your subnet.   Not all instance types support IPv6 addresses. For more information, see Instance types.   If you don't specify a security group ID, we use the default security group. For more information, see Security groups.   If any of the AMIs have a product code attached for which the user has not subscribed, the request fails.   You can create a launch template, which is a resource that contains the parameters to launch an instance. When you launch an instance using RunInstances, you can specify the launch template instead of specifying the launch parameters. To ensure faster instance launches, break up large requests into smaller batches. For example, create five separate launch requests for 100 instances each instead of one launch request for 500 instances. An instance is ready for you to use when it's in the running state. You can check the state of your instance using DescribeInstances. You can tag instances and EBS volumes during launch, after launch, or both. For more information, see CreateTags and Tagging your Amazon EC2 resources. Linux instances have access to the public key of the key pair at boot. You can use this key to provide secure access to the instance. Amazon EC2 public images use this feature to provide secure access without passwords. For more information, see Key pairs. For troubleshooting, see What to do if an instance immediately terminates, and Troubleshooting connecting to your instance.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon EC2 User Guide. 
   */
  runInstances(params: EC2.Types.RunInstancesRequest, callback?: (err: AWSError, data: EC2.Types.Reservation) => void): Request<EC2.Types.Reservation, AWSError>;
  /**
   * Launches the specified number of instances using an AMI for which you have permissions. You can specify a number of options, or leave the default options. The following rules apply:   [EC2-VPC] If you don't specify a subnet ID, we choose a default subnet from your default VPC for you. If you don't have a default VPC, you must specify a subnet ID in the request.   [EC2-Classic] If don't specify an Availability Zone, we choose one for you.   Some instance types must be launched into a VPC. If you do not have a default VPC, or if you do not specify a subnet ID, the request fails. For more information, see Instance types available only in a VPC.   [EC2-VPC] All instances have a network interface with a primary private IPv4 address. If you don't specify this address, we choose one from the IPv4 range of your subnet.   Not all instance types support IPv6 addresses. For more information, see Instance types.   If you don't specify a security group ID, we use the default security group. For more information, see Security groups.   If any of the AMIs have a product code attached for which the user has not subscribed, the request fails.   You can create a launch template, which is a resource that contains the parameters to launch an instance. When you launch an instance using RunInstances, you can specify the launch template instead of specifying the launch parameters. To ensure faster instance launches, break up large requests into smaller batches. For example, create five separate launch requests for 100 instances each instead of one launch request for 500 instances. An instance is ready for you to use when it's in the running state. You can check the state of your instance using DescribeInstances. You can tag instances and EBS volumes during launch, after launch, or both. For more information, see CreateTags and Tagging your Amazon EC2 resources. Linux instances have access to the public key of the key pair at boot. You can use this key to provide secure access to the instance. Amazon EC2 public images use this feature to provide secure access without passwords. For more information, see Key pairs. For troubleshooting, see What to do if an instance immediately terminates, and Troubleshooting connecting to your instance.  We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic to a VPC in the Amazon EC2 User Guide. 
   */
  runInstances(callback?: (err: AWSError, data: EC2.Types.Reservation) => void): Request<EC2.Types.Reservation, AWSError>;
  /**
   * Launches the specified Scheduled Instances. Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using PurchaseScheduledInstances. You must launch a Scheduled Instance during its scheduled time period. You can't stop or reboot a Scheduled Instance, but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends, you can launch it again after a few minutes. For more information, see Scheduled Instances in the Amazon EC2 User Guide.
   */
  runScheduledInstances(params: EC2.Types.RunScheduledInstancesRequest, callback?: (err: AWSError, data: EC2.Types.RunScheduledInstancesResult) => void): Request<EC2.Types.RunScheduledInstancesResult, AWSError>;
  /**
   * Launches the specified Scheduled Instances. Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using PurchaseScheduledInstances. You must launch a Scheduled Instance during its scheduled time period. You can't stop or reboot a Scheduled Instance, but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends, you can launch it again after a few minutes. For more information, see Scheduled Instances in the Amazon EC2 User Guide.
   */
  runScheduledInstances(callback?: (err: AWSError, data: EC2.Types.RunScheduledInstancesResult) => void): Request<EC2.Types.RunScheduledInstancesResult, AWSError>;
  /**
   * Searches for routes in the specified local gateway route table.
   */
  searchLocalGatewayRoutes(params: EC2.Types.SearchLocalGatewayRoutesRequest, callback?: (err: AWSError, data: EC2.Types.SearchLocalGatewayRoutesResult) => void): Request<EC2.Types.SearchLocalGatewayRoutesResult, AWSError>;
  /**
   * Searches for routes in the specified local gateway route table.
   */
  searchLocalGatewayRoutes(callback?: (err: AWSError, data: EC2.Types.SearchLocalGatewayRoutesResult) => void): Request<EC2.Types.SearchLocalGatewayRoutesResult, AWSError>;
  /**
   * Searches one or more transit gateway multicast groups and returns the group membership information.
   */
  searchTransitGatewayMulticastGroups(params: EC2.Types.SearchTransitGatewayMulticastGroupsRequest, callback?: (err: AWSError, data: EC2.Types.SearchTransitGatewayMulticastGroupsResult) => void): Request<EC2.Types.SearchTransitGatewayMulticastGroupsResult, AWSError>;
  /**
   * Searches one or more transit gateway multicast groups and returns the group membership information.
   */
  searchTransitGatewayMulticastGroups(callback?: (err: AWSError, data: EC2.Types.SearchTransitGatewayMulticastGroupsResult) => void): Request<EC2.Types.SearchTransitGatewayMulticastGroupsResult, AWSError>;
  /**
   * Searches for routes in the specified transit gateway route table.
   */
  searchTransitGatewayRoutes(params: EC2.Types.SearchTransitGatewayRoutesRequest, callback?: (err: AWSError, data: EC2.Types.SearchTransitGatewayRoutesResult) => void): Request<EC2.Types.SearchTransitGatewayRoutesResult, AWSError>;
  /**
   * Searches for routes in the specified transit gateway route table.
   */
  searchTransitGatewayRoutes(callback?: (err: AWSError, data: EC2.Types.SearchTransitGatewayRoutesResult) => void): Request<EC2.Types.SearchTransitGatewayRoutesResult, AWSError>;
  /**
   * Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a kernel panic (on Linux instances), or a blue screen/stop error (on Windows instances). For instances based on Intel and AMD processors, the interrupt is received as a non-maskable interrupt (NMI). In general, the operating system crashes and reboots when a kernel panic or stop error is triggered. The operating system can also be configured to perform diagnostic tasks, such as generating a memory dump file, loading a secondary kernel, or obtaining a call trace. Before sending a diagnostic interrupt to your instance, ensure that its operating system is configured to perform the required diagnostic tasks. For more information about configuring your operating system to generate a crash dump when a kernel panic or stop error occurs, see Send a diagnostic interrupt (for advanced users) (Linux instances) or Send a diagnostic interrupt (for advanced users) (Windows instances).
   */
  sendDiagnosticInterrupt(params: EC2.Types.SendDiagnosticInterruptRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a kernel panic (on Linux instances), or a blue screen/stop error (on Windows instances). For instances based on Intel and AMD processors, the interrupt is received as a non-maskable interrupt (NMI). In general, the operating system crashes and reboots when a kernel panic or stop error is triggered. The operating system can also be configured to perform diagnostic tasks, such as generating a memory dump file, loading a secondary kernel, or obtaining a call trace. Before sending a diagnostic interrupt to your instance, ensure that its operating system is configured to perform the required diagnostic tasks. For more information about configuring your operating system to generate a crash dump when a kernel panic or stop error occurs, see Send a diagnostic interrupt (for advanced users) (Linux instances) or Send a diagnostic interrupt (for advanced users) (Windows instances).
   */
  sendDiagnosticInterrupt(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Starts an Amazon EBS-backed instance that you've previously stopped. Instances that use Amazon EBS volumes as their root devices can be quickly stopped and started. When an instance is stopped, the compute resources are released and you are not billed for instance usage. However, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. You can restart your instance at any time. Every time you start your instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage. Before stopping an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM. Performing this operation on an instance that uses an instance store as its root device returns an error. If you attempt to start a T3 instance with host tenancy and the unlimted CPU credit option, the request fails. The unlimited CPU credit option is not supported on Dedicated Hosts. Before you start the instance, either change its CPU credit option to standard, or change its tenancy to default or dedicated. For more information, see Stop and start your instance in the Amazon EC2 User Guide.
   */
  startInstances(params: EC2.Types.StartInstancesRequest, callback?: (err: AWSError, data: EC2.Types.StartInstancesResult) => void): Request<EC2.Types.StartInstancesResult, AWSError>;
  /**
   * Starts an Amazon EBS-backed instance that you've previously stopped. Instances that use Amazon EBS volumes as their root devices can be quickly stopped and started. When an instance is stopped, the compute resources are released and you are not billed for instance usage. However, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. You can restart your instance at any time. Every time you start your instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage. Before stopping an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM. Performing this operation on an instance that uses an instance store as its root device returns an error. If you attempt to start a T3 instance with host tenancy and the unlimted CPU credit option, the request fails. The unlimited CPU credit option is not supported on Dedicated Hosts. Before you start the instance, either change its CPU credit option to standard, or change its tenancy to default or dedicated. For more information, see Stop and start your instance in the Amazon EC2 User Guide.
   */
  startInstances(callback?: (err: AWSError, data: EC2.Types.StartInstancesResult) => void): Request<EC2.Types.StartInstancesResult, AWSError>;
  /**
   * Starts analyzing the specified Network Access Scope.
   */
  startNetworkInsightsAccessScopeAnalysis(params: EC2.Types.StartNetworkInsightsAccessScopeAnalysisRequest, callback?: (err: AWSError, data: EC2.Types.StartNetworkInsightsAccessScopeAnalysisResult) => void): Request<EC2.Types.StartNetworkInsightsAccessScopeAnalysisResult, AWSError>;
  /**
   * Starts analyzing the specified Network Access Scope.
   */
  startNetworkInsightsAccessScopeAnalysis(callback?: (err: AWSError, data: EC2.Types.StartNetworkInsightsAccessScopeAnalysisResult) => void): Request<EC2.Types.StartNetworkInsightsAccessScopeAnalysisResult, AWSError>;
  /**
   * Starts analyzing the specified path. If the path is reachable, the operation returns the shortest feasible path.
   */
  startNetworkInsightsAnalysis(params: EC2.Types.StartNetworkInsightsAnalysisRequest, callback?: (err: AWSError, data: EC2.Types.StartNetworkInsightsAnalysisResult) => void): Request<EC2.Types.StartNetworkInsightsAnalysisResult, AWSError>;
  /**
   * Starts analyzing the specified path. If the path is reachable, the operation returns the shortest feasible path.
   */
  startNetworkInsightsAnalysis(callback?: (err: AWSError, data: EC2.Types.StartNetworkInsightsAnalysisResult) => void): Request<EC2.Types.StartNetworkInsightsAnalysisResult, AWSError>;
  /**
   * Initiates the verification process to prove that the service provider owns the private DNS name domain for the endpoint service. The service provider must successfully perform the verification before the consumer can use the name to access the service. Before the service provider runs this command, they must add a record to the DNS server.
   */
  startVpcEndpointServicePrivateDnsVerification(params: EC2.Types.StartVpcEndpointServicePrivateDnsVerificationRequest, callback?: (err: AWSError, data: EC2.Types.StartVpcEndpointServicePrivateDnsVerificationResult) => void): Request<EC2.Types.StartVpcEndpointServicePrivateDnsVerificationResult, AWSError>;
  /**
   * Initiates the verification process to prove that the service provider owns the private DNS name domain for the endpoint service. The service provider must successfully perform the verification before the consumer can use the name to access the service. Before the service provider runs this command, they must add a record to the DNS server.
   */
  startVpcEndpointServicePrivateDnsVerification(callback?: (err: AWSError, data: EC2.Types.StartVpcEndpointServicePrivateDnsVerificationResult) => void): Request<EC2.Types.StartVpcEndpointServicePrivateDnsVerificationResult, AWSError>;
  /**
   * Stops an Amazon EBS-backed instance. For more information, see Stop and start your instance in the Amazon EC2 User Guide. You can use the Stop action to hibernate an instance if the instance is enabled for hibernation and it meets the hibernation prerequisites. For more information, see Hibernate your instance in the Amazon EC2 User Guide. We don't charge usage for a stopped instance, or data transfer fees; however, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. Every time you start your instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage. You can't stop or hibernate instance store-backed instances. You can't use the Stop action to hibernate Spot Instances, but you can specify that Amazon EC2 should hibernate Spot Instances when they are interrupted. For more information, see Hibernating interrupted Spot Instances in the Amazon EC2 User Guide. When you stop or hibernate an instance, we shut it down. You can restart your instance at any time. Before stopping or hibernating an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM, but hibernating an instance does preserve data stored in RAM. If an instance cannot hibernate successfully, a normal shutdown occurs. Stopping and hibernating an instance is different to rebooting or terminating it. For example, when you stop or hibernate an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, the root device and any other devices attached during the instance launch are automatically deleted. For more information about the differences between rebooting, stopping, hibernating, and terminating instances, see Instance lifecycle in the Amazon EC2 User Guide. When you stop an instance, we attempt to shut it down forcibly after a short while. If your instance appears stuck in the stopping state after a period of time, there may be an issue with the underlying host computer. For more information, see Troubleshoot stopping your instance in the Amazon EC2 User Guide.
   */
  stopInstances(params: EC2.Types.StopInstancesRequest, callback?: (err: AWSError, data: EC2.Types.StopInstancesResult) => void): Request<EC2.Types.StopInstancesResult, AWSError>;
  /**
   * Stops an Amazon EBS-backed instance. For more information, see Stop and start your instance in the Amazon EC2 User Guide. You can use the Stop action to hibernate an instance if the instance is enabled for hibernation and it meets the hibernation prerequisites. For more information, see Hibernate your instance in the Amazon EC2 User Guide. We don't charge usage for a stopped instance, or data transfer fees; however, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. Every time you start your instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage. You can't stop or hibernate instance store-backed instances. You can't use the Stop action to hibernate Spot Instances, but you can specify that Amazon EC2 should hibernate Spot Instances when they are interrupted. For more information, see Hibernating interrupted Spot Instances in the Amazon EC2 User Guide. When you stop or hibernate an instance, we shut it down. You can restart your instance at any time. Before stopping or hibernating an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM, but hibernating an instance does preserve data stored in RAM. If an instance cannot hibernate successfully, a normal shutdown occurs. Stopping and hibernating an instance is different to rebooting or terminating it. For example, when you stop or hibernate an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, the root device and any other devices attached during the instance launch are automatically deleted. For more information about the differences between rebooting, stopping, hibernating, and terminating instances, see Instance lifecycle in the Amazon EC2 User Guide. When you stop an instance, we attempt to shut it down forcibly after a short while. If your instance appears stuck in the stopping state after a period of time, there may be an issue with the underlying host computer. For more information, see Troubleshoot stopping your instance in the Amazon EC2 User Guide.
   */
  stopInstances(callback?: (err: AWSError, data: EC2.Types.StopInstancesResult) => void): Request<EC2.Types.StopInstancesResult, AWSError>;
  /**
   * Terminates active Client VPN endpoint connections. This action can be used to terminate a specific client connection, or up to five connections established by a specific user.
   */
  terminateClientVpnConnections(params: EC2.Types.TerminateClientVpnConnectionsRequest, callback?: (err: AWSError, data: EC2.Types.TerminateClientVpnConnectionsResult) => void): Request<EC2.Types.TerminateClientVpnConnectionsResult, AWSError>;
  /**
   * Terminates active Client VPN endpoint connections. This action can be used to terminate a specific client connection, or up to five connections established by a specific user.
   */
  terminateClientVpnConnections(callback?: (err: AWSError, data: EC2.Types.TerminateClientVpnConnectionsResult) => void): Request<EC2.Types.TerminateClientVpnConnectionsResult, AWSError>;
  /**
   * Shuts down the specified instances. This operation is idempotent; if you terminate an instance more than once, each call succeeds.  If you specify multiple instances and the request fails (for example, because of a single incorrect instance ID), none of the instances are terminated. If you terminate multiple instances across multiple Availability Zones, and one or more of the specified instances are enabled for termination protection, the request fails with the following results:   The specified instances that are in the same Availability Zone as the protected instance are not terminated.   The specified instances that are in different Availability Zones, where no other specified instances are protected, are successfully terminated.   For example, say you have the following instances:   Instance A: us-east-1a; Not protected   Instance B: us-east-1a; Not protected   Instance C: us-east-1b; Protected   Instance D: us-east-1b; not protected   If you attempt to terminate all of these instances in the same request, the request reports failure with the following results:   Instance A and Instance B are successfully terminated because none of the specified instances in us-east-1a are enabled for termination protection.   Instance C and Instance D fail to terminate because at least one of the specified instances in us-east-1b (Instance C) is enabled for termination protection.   Terminated instances remain visible after termination (for approximately one hour). By default, Amazon EC2 deletes all EBS volumes that were attached when the instance launched. Volumes attached after instance launch continue running. You can stop, start, and terminate EBS-backed instances. You can only terminate instance store-backed instances. What happens to an instance differs if you stop it or terminate it. For example, when you stop an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, any attached EBS volumes with the DeleteOnTermination block device mapping parameter set to true are automatically deleted. For more information about the differences between stopping and terminating instances, see Instance lifecycle in the Amazon EC2 User Guide. For more information about troubleshooting, see Troubleshooting terminating your instance in the Amazon EC2 User Guide.
   */
  terminateInstances(params: EC2.Types.TerminateInstancesRequest, callback?: (err: AWSError, data: EC2.Types.TerminateInstancesResult) => void): Request<EC2.Types.TerminateInstancesResult, AWSError>;
  /**
   * Shuts down the specified instances. This operation is idempotent; if you terminate an instance more than once, each call succeeds.  If you specify multiple instances and the request fails (for example, because of a single incorrect instance ID), none of the instances are terminated. If you terminate multiple instances across multiple Availability Zones, and one or more of the specified instances are enabled for termination protection, the request fails with the following results:   The specified instances that are in the same Availability Zone as the protected instance are not terminated.   The specified instances that are in different Availability Zones, where no other specified instances are protected, are successfully terminated.   For example, say you have the following instances:   Instance A: us-east-1a; Not protected   Instance B: us-east-1a; Not protected   Instance C: us-east-1b; Protected   Instance D: us-east-1b; not protected   If you attempt to terminate all of these instances in the same request, the request reports failure with the following results:   Instance A and Instance B are successfully terminated because none of the specified instances in us-east-1a are enabled for termination protection.   Instance C and Instance D fail to terminate because at least one of the specified instances in us-east-1b (Instance C) is enabled for termination protection.   Terminated instances remain visible after termination (for approximately one hour). By default, Amazon EC2 deletes all EBS volumes that were attached when the instance launched. Volumes attached after instance launch continue running. You can stop, start, and terminate EBS-backed instances. You can only terminate instance store-backed instances. What happens to an instance differs if you stop it or terminate it. For example, when you stop an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, any attached EBS volumes with the DeleteOnTermination block device mapping parameter set to true are automatically deleted. For more information about the differences between stopping and terminating instances, see Instance lifecycle in the Amazon EC2 User Guide. For more information about troubleshooting, see Troubleshooting terminating your instance in the Amazon EC2 User Guide.
   */
  terminateInstances(callback?: (err: AWSError, data: EC2.Types.TerminateInstancesResult) => void): Request<EC2.Types.TerminateInstancesResult, AWSError>;
  /**
   * Unassigns one or more IPv6 addresses IPv4 Prefix Delegation prefixes from a network interface.
   */
  unassignIpv6Addresses(params: EC2.Types.UnassignIpv6AddressesRequest, callback?: (err: AWSError, data: EC2.Types.UnassignIpv6AddressesResult) => void): Request<EC2.Types.UnassignIpv6AddressesResult, AWSError>;
  /**
   * Unassigns one or more IPv6 addresses IPv4 Prefix Delegation prefixes from a network interface.
   */
  unassignIpv6Addresses(callback?: (err: AWSError, data: EC2.Types.UnassignIpv6AddressesResult) => void): Request<EC2.Types.UnassignIpv6AddressesResult, AWSError>;
  /**
   * Unassigns one or more secondary private IP addresses, or IPv4 Prefix Delegation prefixes from a network interface.
   */
  unassignPrivateIpAddresses(params: EC2.Types.UnassignPrivateIpAddressesRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Unassigns one or more secondary private IP addresses, or IPv4 Prefix Delegation prefixes from a network interface.
   */
  unassignPrivateIpAddresses(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Disables detailed monitoring for a running instance. For more information, see Monitoring your instances and volumes in the Amazon EC2 User Guide.
   */
  unmonitorInstances(params: EC2.Types.UnmonitorInstancesRequest, callback?: (err: AWSError, data: EC2.Types.UnmonitorInstancesResult) => void): Request<EC2.Types.UnmonitorInstancesResult, AWSError>;
  /**
   * Disables detailed monitoring for a running instance. For more information, see Monitoring your instances and volumes in the Amazon EC2 User Guide.
   */
  unmonitorInstances(callback?: (err: AWSError, data: EC2.Types.UnmonitorInstancesResult) => void): Request<EC2.Types.UnmonitorInstancesResult, AWSError>;
  /**
   * [VPC only] Updates the description of an egress (outbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.
   */
  updateSecurityGroupRuleDescriptionsEgress(params: EC2.Types.UpdateSecurityGroupRuleDescriptionsEgressRequest, callback?: (err: AWSError, data: EC2.Types.UpdateSecurityGroupRuleDescriptionsEgressResult) => void): Request<EC2.Types.UpdateSecurityGroupRuleDescriptionsEgressResult, AWSError>;
  /**
   * [VPC only] Updates the description of an egress (outbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.
   */
  updateSecurityGroupRuleDescriptionsEgress(callback?: (err: AWSError, data: EC2.Types.UpdateSecurityGroupRuleDescriptionsEgressResult) => void): Request<EC2.Types.UpdateSecurityGroupRuleDescriptionsEgressResult, AWSError>;
  /**
   * Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.
   */
  updateSecurityGroupRuleDescriptionsIngress(params: EC2.Types.UpdateSecurityGroupRuleDescriptionsIngressRequest, callback?: (err: AWSError, data: EC2.Types.UpdateSecurityGroupRuleDescriptionsIngressResult) => void): Request<EC2.Types.UpdateSecurityGroupRuleDescriptionsIngressResult, AWSError>;
  /**
   * Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.
   */
  updateSecurityGroupRuleDescriptionsIngress(callback?: (err: AWSError, data: EC2.Types.UpdateSecurityGroupRuleDescriptionsIngressResult) => void): Request<EC2.Types.UpdateSecurityGroupRuleDescriptionsIngressResult, AWSError>;
  /**
   * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time. It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because of BGP propagation delays.
   */
  withdrawByoipCidr(params: EC2.Types.WithdrawByoipCidrRequest, callback?: (err: AWSError, data: EC2.Types.WithdrawByoipCidrResult) => void): Request<EC2.Types.WithdrawByoipCidrResult, AWSError>;
  /**
   * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time. It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because of BGP propagation delays.
   */
  withdrawByoipCidr(callback?: (err: AWSError, data: EC2.Types.WithdrawByoipCidrResult) => void): Request<EC2.Types.WithdrawByoipCidrResult, AWSError>;
  /**
   * Waits for the instanceExists state by periodically calling the underlying EC2.describeInstancesoperation every 5 seconds (at most 40 times).
   */
  waitFor(state: "instanceExists", params: EC2.Types.DescribeInstancesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the instanceExists state by periodically calling the underlying EC2.describeInstancesoperation every 5 seconds (at most 40 times).
   */
  waitFor(state: "instanceExists", callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the bundleTaskComplete state by periodically calling the underlying EC2.describeBundleTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "bundleTaskComplete", params: EC2.Types.DescribeBundleTasksRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeBundleTasksResult) => void): Request<EC2.Types.DescribeBundleTasksResult, AWSError>;
  /**
   * Waits for the bundleTaskComplete state by periodically calling the underlying EC2.describeBundleTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "bundleTaskComplete", callback?: (err: AWSError, data: EC2.Types.DescribeBundleTasksResult) => void): Request<EC2.Types.DescribeBundleTasksResult, AWSError>;
  /**
   * Waits for the conversionTaskCancelled state by periodically calling the underlying EC2.describeConversionTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "conversionTaskCancelled", params: EC2.Types.DescribeConversionTasksRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Waits for the conversionTaskCancelled state by periodically calling the underlying EC2.describeConversionTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "conversionTaskCancelled", callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Waits for the conversionTaskCompleted state by periodically calling the underlying EC2.describeConversionTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "conversionTaskCompleted", params: EC2.Types.DescribeConversionTasksRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Waits for the conversionTaskCompleted state by periodically calling the underlying EC2.describeConversionTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "conversionTaskCompleted", callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Waits for the conversionTaskDeleted state by periodically calling the underlying EC2.describeConversionTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "conversionTaskDeleted", params: EC2.Types.DescribeConversionTasksRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Waits for the conversionTaskDeleted state by periodically calling the underlying EC2.describeConversionTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "conversionTaskDeleted", callback?: (err: AWSError, data: EC2.Types.DescribeConversionTasksResult) => void): Request<EC2.Types.DescribeConversionTasksResult, AWSError>;
  /**
   * Waits for the customerGatewayAvailable state by periodically calling the underlying EC2.describeCustomerGatewaysoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "customerGatewayAvailable", params: EC2.Types.DescribeCustomerGatewaysRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeCustomerGatewaysResult) => void): Request<EC2.Types.DescribeCustomerGatewaysResult, AWSError>;
  /**
   * Waits for the customerGatewayAvailable state by periodically calling the underlying EC2.describeCustomerGatewaysoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "customerGatewayAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeCustomerGatewaysResult) => void): Request<EC2.Types.DescribeCustomerGatewaysResult, AWSError>;
  /**
   * Waits for the exportTaskCancelled state by periodically calling the underlying EC2.describeExportTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "exportTaskCancelled", params: EC2.Types.DescribeExportTasksRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeExportTasksResult) => void): Request<EC2.Types.DescribeExportTasksResult, AWSError>;
  /**
   * Waits for the exportTaskCancelled state by periodically calling the underlying EC2.describeExportTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "exportTaskCancelled", callback?: (err: AWSError, data: EC2.Types.DescribeExportTasksResult) => void): Request<EC2.Types.DescribeExportTasksResult, AWSError>;
  /**
   * Waits for the exportTaskCompleted state by periodically calling the underlying EC2.describeExportTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "exportTaskCompleted", params: EC2.Types.DescribeExportTasksRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeExportTasksResult) => void): Request<EC2.Types.DescribeExportTasksResult, AWSError>;
  /**
   * Waits for the exportTaskCompleted state by periodically calling the underlying EC2.describeExportTasksoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "exportTaskCompleted", callback?: (err: AWSError, data: EC2.Types.DescribeExportTasksResult) => void): Request<EC2.Types.DescribeExportTasksResult, AWSError>;
  /**
   * Waits for the imageExists state by periodically calling the underlying EC2.describeImagesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "imageExists", params: EC2.Types.DescribeImagesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeImagesResult) => void): Request<EC2.Types.DescribeImagesResult, AWSError>;
  /**
   * Waits for the imageExists state by periodically calling the underlying EC2.describeImagesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "imageExists", callback?: (err: AWSError, data: EC2.Types.DescribeImagesResult) => void): Request<EC2.Types.DescribeImagesResult, AWSError>;
  /**
   * Waits for the imageAvailable state by periodically calling the underlying EC2.describeImagesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "imageAvailable", params: EC2.Types.DescribeImagesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeImagesResult) => void): Request<EC2.Types.DescribeImagesResult, AWSError>;
  /**
   * Waits for the imageAvailable state by periodically calling the underlying EC2.describeImagesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "imageAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeImagesResult) => void): Request<EC2.Types.DescribeImagesResult, AWSError>;
  /**
   * Waits for the instanceRunning state by periodically calling the underlying EC2.describeInstancesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceRunning", params: EC2.Types.DescribeInstancesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the instanceRunning state by periodically calling the underlying EC2.describeInstancesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceRunning", callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the instanceStatusOk state by periodically calling the underlying EC2.describeInstanceStatusoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceStatusOk", params: EC2.Types.DescribeInstanceStatusRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceStatusResult) => void): Request<EC2.Types.DescribeInstanceStatusResult, AWSError>;
  /**
   * Waits for the instanceStatusOk state by periodically calling the underlying EC2.describeInstanceStatusoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceStatusOk", callback?: (err: AWSError, data: EC2.Types.DescribeInstanceStatusResult) => void): Request<EC2.Types.DescribeInstanceStatusResult, AWSError>;
  /**
   * Waits for the instanceStopped state by periodically calling the underlying EC2.describeInstancesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceStopped", params: EC2.Types.DescribeInstancesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the instanceStopped state by periodically calling the underlying EC2.describeInstancesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceStopped", callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the instanceTerminated state by periodically calling the underlying EC2.describeInstancesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceTerminated", params: EC2.Types.DescribeInstancesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the instanceTerminated state by periodically calling the underlying EC2.describeInstancesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "instanceTerminated", callback?: (err: AWSError, data: EC2.Types.DescribeInstancesResult) => void): Request<EC2.Types.DescribeInstancesResult, AWSError>;
  /**
   * Waits for the internetGatewayExists state by periodically calling the underlying EC2.describeInternetGatewaysoperation every 5 seconds (at most 6 times).
   */
  waitFor(state: "internetGatewayExists", params: EC2.Types.DescribeInternetGatewaysRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeInternetGatewaysResult) => void): Request<EC2.Types.DescribeInternetGatewaysResult, AWSError>;
  /**
   * Waits for the internetGatewayExists state by periodically calling the underlying EC2.describeInternetGatewaysoperation every 5 seconds (at most 6 times).
   */
  waitFor(state: "internetGatewayExists", callback?: (err: AWSError, data: EC2.Types.DescribeInternetGatewaysResult) => void): Request<EC2.Types.DescribeInternetGatewaysResult, AWSError>;
  /**
   * Waits for the keyPairExists state by periodically calling the underlying EC2.describeKeyPairsoperation every 5 seconds (at most 6 times).
   */
  waitFor(state: "keyPairExists", params: EC2.Types.DescribeKeyPairsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeKeyPairsResult) => void): Request<EC2.Types.DescribeKeyPairsResult, AWSError>;
  /**
   * Waits for the keyPairExists state by periodically calling the underlying EC2.describeKeyPairsoperation every 5 seconds (at most 6 times).
   */
  waitFor(state: "keyPairExists", callback?: (err: AWSError, data: EC2.Types.DescribeKeyPairsResult) => void): Request<EC2.Types.DescribeKeyPairsResult, AWSError>;
  /**
   * Waits for the natGatewayAvailable state by periodically calling the underlying EC2.describeNatGatewaysoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "natGatewayAvailable", params: EC2.Types.DescribeNatGatewaysRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeNatGatewaysResult) => void): Request<EC2.Types.DescribeNatGatewaysResult, AWSError>;
  /**
   * Waits for the natGatewayAvailable state by periodically calling the underlying EC2.describeNatGatewaysoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "natGatewayAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeNatGatewaysResult) => void): Request<EC2.Types.DescribeNatGatewaysResult, AWSError>;
  /**
   * Waits for the natGatewayDeleted state by periodically calling the underlying EC2.describeNatGatewaysoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "natGatewayDeleted", params: EC2.Types.DescribeNatGatewaysRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeNatGatewaysResult) => void): Request<EC2.Types.DescribeNatGatewaysResult, AWSError>;
  /**
   * Waits for the natGatewayDeleted state by periodically calling the underlying EC2.describeNatGatewaysoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "natGatewayDeleted", callback?: (err: AWSError, data: EC2.Types.DescribeNatGatewaysResult) => void): Request<EC2.Types.DescribeNatGatewaysResult, AWSError>;
  /**
   * Waits for the networkInterfaceAvailable state by periodically calling the underlying EC2.describeNetworkInterfacesoperation every 20 seconds (at most 10 times).
   */
  waitFor(state: "networkInterfaceAvailable", params: EC2.Types.DescribeNetworkInterfacesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfacesResult) => void): Request<EC2.Types.DescribeNetworkInterfacesResult, AWSError>;
  /**
   * Waits for the networkInterfaceAvailable state by periodically calling the underlying EC2.describeNetworkInterfacesoperation every 20 seconds (at most 10 times).
   */
  waitFor(state: "networkInterfaceAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeNetworkInterfacesResult) => void): Request<EC2.Types.DescribeNetworkInterfacesResult, AWSError>;
  /**
   * Waits for the passwordDataAvailable state by periodically calling the underlying EC2.getPasswordDataoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "passwordDataAvailable", params: EC2.Types.GetPasswordDataRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.GetPasswordDataResult) => void): Request<EC2.Types.GetPasswordDataResult, AWSError>;
  /**
   * Waits for the passwordDataAvailable state by periodically calling the underlying EC2.getPasswordDataoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "passwordDataAvailable", callback?: (err: AWSError, data: EC2.Types.GetPasswordDataResult) => void): Request<EC2.Types.GetPasswordDataResult, AWSError>;
  /**
   * Waits for the snapshotCompleted state by periodically calling the underlying EC2.describeSnapshotsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "snapshotCompleted", params: EC2.Types.DescribeSnapshotsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotsResult) => void): Request<EC2.Types.DescribeSnapshotsResult, AWSError>;
  /**
   * Waits for the snapshotCompleted state by periodically calling the underlying EC2.describeSnapshotsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "snapshotCompleted", callback?: (err: AWSError, data: EC2.Types.DescribeSnapshotsResult) => void): Request<EC2.Types.DescribeSnapshotsResult, AWSError>;
  /**
   * Waits for the securityGroupExists state by periodically calling the underlying EC2.describeSecurityGroupsoperation every 5 seconds (at most 6 times).
   */
  waitFor(state: "securityGroupExists", params: EC2.Types.DescribeSecurityGroupsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupsResult) => void): Request<EC2.Types.DescribeSecurityGroupsResult, AWSError>;
  /**
   * Waits for the securityGroupExists state by periodically calling the underlying EC2.describeSecurityGroupsoperation every 5 seconds (at most 6 times).
   */
  waitFor(state: "securityGroupExists", callback?: (err: AWSError, data: EC2.Types.DescribeSecurityGroupsResult) => void): Request<EC2.Types.DescribeSecurityGroupsResult, AWSError>;
  /**
   * Waits for the spotInstanceRequestFulfilled state by periodically calling the underlying EC2.describeSpotInstanceRequestsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "spotInstanceRequestFulfilled", params: EC2.Types.DescribeSpotInstanceRequestsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeSpotInstanceRequestsResult) => void): Request<EC2.Types.DescribeSpotInstanceRequestsResult, AWSError>;
  /**
   * Waits for the spotInstanceRequestFulfilled state by periodically calling the underlying EC2.describeSpotInstanceRequestsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "spotInstanceRequestFulfilled", callback?: (err: AWSError, data: EC2.Types.DescribeSpotInstanceRequestsResult) => void): Request<EC2.Types.DescribeSpotInstanceRequestsResult, AWSError>;
  /**
   * Waits for the subnetAvailable state by periodically calling the underlying EC2.describeSubnetsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "subnetAvailable", params: EC2.Types.DescribeSubnetsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeSubnetsResult) => void): Request<EC2.Types.DescribeSubnetsResult, AWSError>;
  /**
   * Waits for the subnetAvailable state by periodically calling the underlying EC2.describeSubnetsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "subnetAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeSubnetsResult) => void): Request<EC2.Types.DescribeSubnetsResult, AWSError>;
  /**
   * Waits for the systemStatusOk state by periodically calling the underlying EC2.describeInstanceStatusoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "systemStatusOk", params: EC2.Types.DescribeInstanceStatusRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeInstanceStatusResult) => void): Request<EC2.Types.DescribeInstanceStatusResult, AWSError>;
  /**
   * Waits for the systemStatusOk state by periodically calling the underlying EC2.describeInstanceStatusoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "systemStatusOk", callback?: (err: AWSError, data: EC2.Types.DescribeInstanceStatusResult) => void): Request<EC2.Types.DescribeInstanceStatusResult, AWSError>;
  /**
   * Waits for the volumeAvailable state by periodically calling the underlying EC2.describeVolumesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "volumeAvailable", params: EC2.Types.DescribeVolumesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Waits for the volumeAvailable state by periodically calling the underlying EC2.describeVolumesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "volumeAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Waits for the volumeDeleted state by periodically calling the underlying EC2.describeVolumesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "volumeDeleted", params: EC2.Types.DescribeVolumesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Waits for the volumeDeleted state by periodically calling the underlying EC2.describeVolumesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "volumeDeleted", callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Waits for the volumeInUse state by periodically calling the underlying EC2.describeVolumesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "volumeInUse", params: EC2.Types.DescribeVolumesRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Waits for the volumeInUse state by periodically calling the underlying EC2.describeVolumesoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "volumeInUse", callback?: (err: AWSError, data: EC2.Types.DescribeVolumesResult) => void): Request<EC2.Types.DescribeVolumesResult, AWSError>;
  /**
   * Waits for the vpcAvailable state by periodically calling the underlying EC2.describeVpcsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpcAvailable", params: EC2.Types.DescribeVpcsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVpcsResult) => void): Request<EC2.Types.DescribeVpcsResult, AWSError>;
  /**
   * Waits for the vpcAvailable state by periodically calling the underlying EC2.describeVpcsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpcAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeVpcsResult) => void): Request<EC2.Types.DescribeVpcsResult, AWSError>;
  /**
   * Waits for the vpcExists state by periodically calling the underlying EC2.describeVpcsoperation every 1 seconds (at most 5 times).
   */
  waitFor(state: "vpcExists", params: EC2.Types.DescribeVpcsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVpcsResult) => void): Request<EC2.Types.DescribeVpcsResult, AWSError>;
  /**
   * Waits for the vpcExists state by periodically calling the underlying EC2.describeVpcsoperation every 1 seconds (at most 5 times).
   */
  waitFor(state: "vpcExists", callback?: (err: AWSError, data: EC2.Types.DescribeVpcsResult) => void): Request<EC2.Types.DescribeVpcsResult, AWSError>;
  /**
   * Waits for the vpnConnectionAvailable state by periodically calling the underlying EC2.describeVpnConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpnConnectionAvailable", params: EC2.Types.DescribeVpnConnectionsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVpnConnectionsResult) => void): Request<EC2.Types.DescribeVpnConnectionsResult, AWSError>;
  /**
   * Waits for the vpnConnectionAvailable state by periodically calling the underlying EC2.describeVpnConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpnConnectionAvailable", callback?: (err: AWSError, data: EC2.Types.DescribeVpnConnectionsResult) => void): Request<EC2.Types.DescribeVpnConnectionsResult, AWSError>;
  /**
   * Waits for the vpnConnectionDeleted state by periodically calling the underlying EC2.describeVpnConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpnConnectionDeleted", params: EC2.Types.DescribeVpnConnectionsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVpnConnectionsResult) => void): Request<EC2.Types.DescribeVpnConnectionsResult, AWSError>;
  /**
   * Waits for the vpnConnectionDeleted state by periodically calling the underlying EC2.describeVpnConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpnConnectionDeleted", callback?: (err: AWSError, data: EC2.Types.DescribeVpnConnectionsResult) => void): Request<EC2.Types.DescribeVpnConnectionsResult, AWSError>;
  /**
   * Waits for the vpcPeeringConnectionExists state by periodically calling the underlying EC2.describeVpcPeeringConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpcPeeringConnectionExists", params: EC2.Types.DescribeVpcPeeringConnectionsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVpcPeeringConnectionsResult) => void): Request<EC2.Types.DescribeVpcPeeringConnectionsResult, AWSError>;
  /**
   * Waits for the vpcPeeringConnectionExists state by periodically calling the underlying EC2.describeVpcPeeringConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpcPeeringConnectionExists", callback?: (err: AWSError, data: EC2.Types.DescribeVpcPeeringConnectionsResult) => void): Request<EC2.Types.DescribeVpcPeeringConnectionsResult, AWSError>;
  /**
   * Waits for the vpcPeeringConnectionDeleted state by periodically calling the underlying EC2.describeVpcPeeringConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpcPeeringConnectionDeleted", params: EC2.Types.DescribeVpcPeeringConnectionsRequest & {$waiter?: WaiterConfiguration}, callback?: (err: AWSError, data: EC2.Types.DescribeVpcPeeringConnectionsResult) => void): Request<EC2.Types.DescribeVpcPeeringConnectionsResult, AWSError>;
  /**
   * Waits for the vpcPeeringConnectionDeleted state by periodically calling the underlying EC2.describeVpcPeeringConnectionsoperation every 15 seconds (at most 40 times).
   */
  waitFor(state: "vpcPeeringConnectionDeleted", callback?: (err: AWSError, data: EC2.Types.DescribeVpcPeeringConnectionsResult) => void): Request<EC2.Types.DescribeVpcPeeringConnectionsResult, AWSError>;
}
declare namespace EC2 {
  export interface AcceleratorCount {
    /**
     * The minimum number of accelerators. If this parameter is not specified, there is no minimum limit.
     */
    Min?: Integer;
    /**
     * The maximum number of accelerators. If this parameter is not specified, there is no maximum limit.
     */
    Max?: Integer;
  }
  export interface AcceleratorCountRequest {
    /**
     * The minimum number of accelerators. To specify no minimum limit, omit this parameter.
     */
    Min?: Integer;
    /**
     * The maximum number of accelerators. To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set Max to 0.
     */
    Max?: Integer;
  }
  export type AcceleratorManufacturer = "nvidia"|"amd"|"amazon-web-services"|"xilinx"|string;
  export type AcceleratorManufacturerSet = AcceleratorManufacturer[];
  export type AcceleratorName = "a100"|"v100"|"k80"|"t4"|"m60"|"radeon-pro-v520"|"vu9p"|"inferentia"|"k520"|string;
  export type AcceleratorNameSet = AcceleratorName[];
  export interface AcceleratorTotalMemoryMiB {
    /**
     * The minimum amount of accelerator memory, in MiB. If this parameter is not specified, there is no minimum limit.
     */
    Min?: Integer;
    /**
     * The maximum amount of accelerator memory, in MiB. If this parameter is not specified, there is no maximum limit.
     */
    Max?: Integer;
  }
  export interface AcceleratorTotalMemoryMiBRequest {
    /**
     * The minimum amount of accelerator memory, in MiB. To specify no minimum limit, omit this parameter.
     */
    Min?: Integer;
    /**
     * The maximum amount of accelerator memory, in MiB. To specify no maximum limit, omit this parameter.
     */
    Max?: Integer;
  }
  export type AcceleratorType = "gpu"|"fpga"|"inference"|string;
  export type AcceleratorTypeSet = AcceleratorType[];
  export interface AcceptAddressTransferRequest {
    /**
     * The Elastic IP address you are accepting for transfer.
     */
    Address: String;
    /**
     *  tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AcceptAddressTransferResult {
    /**
     * An Elastic IP address transfer.
     */
    AddressTransfer?: AddressTransfer;
  }
  export interface AcceptReservedInstancesExchangeQuoteRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.
     */
    ReservedInstanceIds: ReservedInstanceIdSet;
    /**
     * The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances.
     */
    TargetConfigurations?: TargetConfigurationRequestSet;
  }
  export interface AcceptReservedInstancesExchangeQuoteResult {
    /**
     * The ID of the successful exchange.
     */
    ExchangeId?: String;
  }
  export interface AcceptTransitGatewayMulticastDomainAssociationsRequest {
    /**
     * The ID of the transit gateway multicast domain.
     */
    TransitGatewayMulticastDomainId?: TransitGatewayMulticastDomainId;
    /**
     * The ID of the transit gateway attachment.
     */
    TransitGatewayAttachmentId?: TransitGatewayAttachmentId;
    /**
     * The IDs of the subnets to associate with the transit gateway multicast domain.
     */
    SubnetIds?: ValueStringList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AcceptTransitGatewayMulticastDomainAssociationsResult {
    Associations?: TransitGatewayMulticastDomainAssociations;
  }
  export interface AcceptTransitGatewayPeeringAttachmentRequest {
    /**
     * The ID of the transit gateway attachment.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AcceptTransitGatewayPeeringAttachmentResult {
    /**
     * The transit gateway peering attachment.
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
  }
  export interface AcceptTransitGatewayVpcAttachmentRequest {
    /**
     * The ID of the attachment.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AcceptTransitGatewayVpcAttachmentResult {
    /**
     * The VPC attachment.
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
  }
  export interface AcceptVpcEndpointConnectionsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the VPC endpoint service.
     */
    ServiceId: VpcEndpointServiceId;
    /**
     * The IDs of one or more interface VPC endpoints.
     */
    VpcEndpointIds: VpcEndpointIdList;
  }
  export interface AcceptVpcEndpointConnectionsResult {
    /**
     * Information about the interface endpoints that were not accepted, if applicable.
     */
    Unsuccessful?: UnsuccessfulItemSet;
  }
  export interface AcceptVpcPeeringConnectionRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the VPC peering connection. You must specify this parameter in the request.
     */
    VpcPeeringConnectionId?: VpcPeeringConnectionId;
  }
  export interface AcceptVpcPeeringConnectionResult {
    /**
     * Information about the VPC peering connection.
     */
    VpcPeeringConnection?: VpcPeeringConnection;
  }
  export interface AccessScopeAnalysisFinding {
    /**
     * The ID of the Network Access Scope analysis.
     */
    NetworkInsightsAccessScopeAnalysisId?: NetworkInsightsAccessScopeAnalysisId;
    /**
     * The ID of the Network Access Scope.
     */
    NetworkInsightsAccessScopeId?: NetworkInsightsAccessScopeId;
    /**
     * The ID of the finding.
     */
    FindingId?: String;
    /**
     * The finding components.
     */
    FindingComponents?: PathComponentList;
  }
  export type AccessScopeAnalysisFindingList = AccessScopeAnalysisFinding[];
  export interface AccessScopePath {
    /**
     * The source.
     */
    Source?: PathStatement;
    /**
     * The destination.
     */
    Destination?: PathStatement;
    /**
     * The through resources.
     */
    ThroughResources?: ThroughResourcesStatementList;
  }
  export type AccessScopePathList = AccessScopePath[];
  export type AccessScopePathListRequest = AccessScopePathRequest[];
  export interface AccessScopePathRequest {
    /**
     * The source.
     */
    Source?: PathStatementRequest;
    /**
     * The destination.
     */
    Destination?: PathStatementRequest;
    /**
     * The through resources.
     */
    ThroughResources?: ThroughResourcesStatementRequestList;
  }
  export interface AccountAttribute {
    /**
     * The name of the account attribute.
     */
    AttributeName?: String;
    /**
     * The values for the account attribute.
     */
    AttributeValues?: AccountAttributeValueList;
  }
  export type AccountAttributeList = AccountAttribute[];
  export type AccountAttributeName = "supported-platforms"|"default-vpc"|string;
  export type AccountAttributeNameStringList = AccountAttributeName[];
  export interface AccountAttributeValue {
    /**
     * The value of the attribute.
     */
    AttributeValue?: String;
  }
  export type AccountAttributeValueList = AccountAttributeValue[];
  export interface ActiveInstance {
    /**
     * The ID of the instance.
     */
    InstanceId?: String;
    /**
     * The instance type.
     */
    InstanceType?: String;
    /**
     * The ID of the Spot Instance request.
     */
    SpotInstanceRequestId?: String;
    /**
     * The health status of the instance. If the status of either the instance status check or the system status check is impaired, the health status of the instance is unhealthy. Otherwise, the health status is healthy.
     */
    InstanceHealth?: InstanceHealthStatus;
  }
  export type ActiveInstanceSet = ActiveInstance[];
  export type ActivityStatus = "error"|"pending_fulfillment"|"pending_termination"|"fulfilled"|string;
  export interface AddIpamOperatingRegion {
    /**
     * The name of the operating Region.
     */
    RegionName?: String;
  }
  export type AddIpamOperatingRegionSet = AddIpamOperatingRegion[];
  export type AddPrefixListEntries = AddPrefixListEntry[];
  export interface AddPrefixListEntry {
    /**
     * The CIDR block.
     */
    Cidr: String;
    /**
     * A description for the entry. Constraints: Up to 255 characters in length.
     */
    Description?: String;
  }
  export interface AddedPrincipal {
    /**
     * The type of principal.
     */
    PrincipalType?: PrincipalType;
    /**
     * The Amazon Resource Name (ARN) of the principal.
     */
    Principal?: String;
    /**
     * The ID of the service permission.
     */
    ServicePermissionId?: String;
    /**
     * The ID of the service.
     */
    ServiceId?: String;
  }
  export type AddedPrincipalSet = AddedPrincipal[];
  export interface AdditionalDetail {
    /**
     * The information type.
     */
    AdditionalDetailType?: String;
    /**
     * The path component.
     */
    Component?: AnalysisComponent;
  }
  export type AdditionalDetailList = AdditionalDetail[];
  export interface Address {
    /**
     * The ID of the instance that the address is associated with (if any).
     */
    InstanceId?: String;
    /**
     * The Elastic IP address.
     */
    PublicIp?: String;
    /**
     * The ID representing the allocation of the address for use with EC2-VPC.
     */
    AllocationId?: String;
    /**
     * The ID representing the association of the address with an instance in a VPC.
     */
    AssociationId?: String;
    /**
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (standard) or instances in a VPC (vpc).
     */
    Domain?: DomainType;
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId?: String;
    /**
     * The ID of the Amazon Web Services account that owns the network interface.
     */
    NetworkInterfaceOwnerId?: String;
    /**
     * The private IP address associated with the Elastic IP address.
     */
    PrivateIpAddress?: String;
    /**
     * Any tags assigned to the Elastic IP address.
     */
    Tags?: TagList;
    /**
     * The ID of an address pool.
     */
    PublicIpv4Pool?: String;
    /**
     * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses.
     */
    NetworkBorderGroup?: String;
    /**
     * The customer-owned IP address.
     */
    CustomerOwnedIp?: String;
    /**
     * The ID of the customer-owned address pool.
     */
    CustomerOwnedIpv4Pool?: String;
    /**
     * The carrier IP address associated. This option is only available for network interfaces which reside in a subnet in a Wavelength Zone (for example an EC2 instance). 
     */
    CarrierIp?: String;
  }
  export interface AddressAttribute {
    /**
     * The public IP address.
     */
    PublicIp?: PublicIpAddress;
    /**
     * [EC2-VPC] The allocation ID.
     */
    AllocationId?: AllocationId;
    /**
     * The pointer (PTR) record for the IP address.
     */
    PtrRecord?: String;
    /**
     * The updated PTR record for the IP address.
     */
    PtrRecordUpdate?: PtrUpdateStatus;
  }
  export type AddressAttributeName = "domain-name"|string;
  export type AddressFamily = "ipv4"|"ipv6"|string;
  export type AddressList = Address[];
  export type AddressMaxResults = number;
  export type AddressSet = AddressAttribute[];
  export interface AddressTransfer {
    /**
     * The Elastic IP address being transferred.
     */
    PublicIp?: String;
    /**
     * The allocation ID of an Elastic IP address.
     */
    AllocationId?: String;
    /**
     * The ID of the account that you want to transfer the Elastic IP address to.
     */
    TransferAccountId?: String;
    /**
     * The timestamp when the Elastic IP address transfer expired. When the source account starts the transfer, the transfer account has seven hours to allocate the Elastic IP address to complete the transfer, or the Elastic IP address will return to its original owner.
     */
    TransferOfferExpirationTimestamp?: MillisecondDateTime;
    /**
     * The timestamp when the Elastic IP address transfer was accepted.
     */
    TransferOfferAcceptedTimestamp?: MillisecondDateTime;
    /**
     * The Elastic IP address transfer status.
     */
    AddressTransferStatus?: AddressTransferStatus;
  }
  export type AddressTransferList = AddressTransfer[];
  export type AddressTransferStatus = "pending"|"disabled"|"accepted"|string;
  export interface AdvertiseByoipCidrRequest {
    /**
     * The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.
     */
    Cidr: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AdvertiseByoipCidrResult {
    /**
     * Information about the address range.
     */
    ByoipCidr?: ByoipCidr;
  }
  export type Affinity = "default"|"host"|string;
  export interface AllocateAddressRequest {
    /**
     * Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic. Default: If the Region supports EC2-Classic, the default is standard. Otherwise, the default is vpc.
     */
    Domain?: DomainType;
    /**
     * [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.
     */
    Address?: PublicIpAddress;
    /**
     * The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the Address parameter instead.
     */
    PublicIpv4Pool?: Ipv4PoolEc2Id;
    /**
     *  A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups. Use DescribeAvailabilityZones to view the network border groups. You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic, you receive an InvalidParameterCombination error.
     */
    NetworkBorderGroup?: String;
    /**
     * The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.
     */
    CustomerOwnedIpv4Pool?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The tags to assign to the Elastic IP address.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface AllocateAddressResult {
    /**
     * The Elastic IP address.
     */
    PublicIp?: String;
    /**
     * [EC2-VPC] The ID that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
     */
    AllocationId?: String;
    /**
     * The ID of an address pool.
     */
    PublicIpv4Pool?: String;
    /**
     * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses.
     */
    NetworkBorderGroup?: String;
    /**
     * Indicates whether the Elastic IP address is for use with instances in a VPC (vpc) or instances in EC2-Classic (standard).
     */
    Domain?: DomainType;
    /**
     * The customer-owned IP address.
     */
    CustomerOwnedIp?: String;
    /**
     * The ID of the customer-owned address pool.
     */
    CustomerOwnedIpv4Pool?: String;
    /**
     * The carrier IP address. This option is only available for network interfaces which reside in a subnet in a Wavelength Zone (for example an EC2 instance). 
     */
    CarrierIp?: String;
  }
  export interface AllocateHostsRequest {
    /**
     * Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see  Understanding auto-placement and affinity in the Amazon EC2 User Guide. Default: on 
     */
    AutoPlacement?: AutoPlacement;
    /**
     * The Availability Zone in which to allocate the Dedicated Host.
     */
    AvailabilityZone: String;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency.
     */
    ClientToken?: String;
    /**
     * Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only. If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify InstanceFamily instead. You cannot specify InstanceType and InstanceFamily in the same request.
     */
    InstanceType?: String;
    /**
     * Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family. If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify InstanceType instead. You cannot specify InstanceFamily and InstanceType in the same request.
     */
    InstanceFamily?: String;
    /**
     * The number of Dedicated Hosts to allocate to your account with these parameters.
     */
    Quantity: Integer;
    /**
     * The tags to apply to the Dedicated Host during creation.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see  Host recovery in the Amazon EC2 User Guide. Default: off 
     */
    HostRecovery?: HostRecovery;
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which to allocate the Dedicated Host.
     */
    OutpostArn?: String;
  }
  export interface AllocateHostsResult {
    /**
     * The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.
     */
    HostIds?: ResponseHostIdList;
  }
  export interface AllocateIpamPoolCidrRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the IPAM pool from which you would like to allocate a CIDR.
     */
    IpamPoolId: IpamPoolId;
    /**
     * The CIDR you would like to allocate from the IPAM pool. Note the following:   If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.   If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.   Possible values: Any available IPv4 or IPv6 CIDR.
     */
    Cidr?: String;
    /**
     * The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:   If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.   If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.   Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    NetmaskLength?: Integer;
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency.
     */
    ClientToken?: String;
    /**
     * A description for the allocation.
     */
    Description?: String;
    /**
     * A preview of the next available CIDR in a pool.
     */
    PreviewNextCidr?: Boolean;
    /**
     * Exclude a particular CIDR range from being returned by the pool. Disallowed CIDRs are only allowed if using netmask length for allocation.
     */
    DisallowedCidrs?: IpamPoolAllocationDisallowedCidrs;
  }
  export interface AllocateIpamPoolCidrResult {
    /**
     * Information about the allocation created.
     */
    IpamPoolAllocation?: IpamPoolAllocation;
  }
  export type AllocationId = string;
  export type AllocationIdList = AllocationId[];
  export type AllocationIds = AllocationId[];
  export type AllocationState = "available"|"under-assessment"|"permanent-failure"|"released"|"released-permanent-failure"|"pending"|string;
  export type AllocationStrategy = "lowestPrice"|"diversified"|"capacityOptimized"|"capacityOptimizedPrioritized"|"priceCapacityOptimized"|string;
  export type AllocationType = "used"|string;
  export type AllowedInstanceType = string;
  export type AllowedInstanceTypeSet = AllowedInstanceType[];
  export interface AllowedPrincipal {
    /**
     * The type of principal.
     */
    PrincipalType?: PrincipalType;
    /**
     * The Amazon Resource Name (ARN) of the principal.
     */
    Principal?: String;
    /**
     * The ID of the service permission.
     */
    ServicePermissionId?: String;
    /**
     * The tags.
     */
    Tags?: TagList;
    /**
     * The ID of the service.
     */
    ServiceId?: String;
  }
  export type AllowedPrincipalSet = AllowedPrincipal[];
  export type AllowsMultipleInstanceTypes = "on"|"off"|string;
  export interface AlternatePathHint {
    /**
     * The ID of the component.
     */
    ComponentId?: String;
    /**
     * The Amazon Resource Name (ARN) of the component.
     */
    ComponentArn?: String;
  }
  export type AlternatePathHintList = AlternatePathHint[];
  export interface AnalysisAclRule {
    /**
     * The IPv4 address range, in CIDR notation.
     */
    Cidr?: String;
    /**
     * Indicates whether the rule is an outbound rule.
     */
    Egress?: Boolean;
    /**
     * The range of ports.
     */
    PortRange?: PortRange;
    /**
     * The protocol.
     */
    Protocol?: String;
    /**
     * Indicates whether to allow or deny traffic that matches the rule.
     */
    RuleAction?: String;
    /**
     * The rule number.
     */
    RuleNumber?: Integer;
  }
  export interface AnalysisComponent {
    /**
     * The ID of the component.
     */
    Id?: String;
    /**
     * The Amazon Resource Name (ARN) of the component.
     */
    Arn?: String;
    /**
     * The name of the analysis component.
     */
    Name?: String;
  }
  export type AnalysisComponentList = AnalysisComponent[];
  export interface AnalysisLoadBalancerListener {
    /**
     * The port on which the load balancer is listening.
     */
    LoadBalancerPort?: Port;
    /**
     * [Classic Load Balancers] The back-end port for the listener.
     */
    InstancePort?: Port;
  }
  export interface AnalysisLoadBalancerTarget {
    /**
     * The IP address.
     */
    Address?: IpAddress;
    /**
     * The Availability Zone.
     */
    AvailabilityZone?: String;
    /**
     * Information about the instance.
     */
    Instance?: AnalysisComponent;
    /**
     * The port on which the target is listening.
     */
    Port?: Port;
  }
  export interface AnalysisPacketHeader {
    /**
     * The destination addresses.
     */
    DestinationAddresses?: IpAddressList;
    /**
     * The destination port ranges.
     */
    DestinationPortRanges?: PortRangeList;
    /**
     * The protocol.
     */
    Protocol?: String;
    /**
     * The source addresses.
     */
    SourceAddresses?: IpAddressList;
    /**
     * The source port ranges.
     */
    SourcePortRanges?: PortRangeList;
  }
  export interface AnalysisRouteTableRoute {
    /**
     * The destination IPv4 address, in CIDR notation.
     */
    DestinationCidr?: String;
    /**
     * The prefix of the Amazon Web Service.
     */
    DestinationPrefixListId?: String;
    /**
     * The ID of an egress-only internet gateway.
     */
    EgressOnlyInternetGatewayId?: String;
    /**
     * The ID of the gateway, such as an internet gateway or virtual private gateway.
     */
    GatewayId?: String;
    /**
     * The ID of the instance, such as a NAT instance.
     */
    InstanceId?: String;
    /**
     * The ID of a NAT gateway.
     */
    NatGatewayId?: String;
    /**
     * The ID of a network interface.
     */
    NetworkInterfaceId?: String;
    /**
     * Describes how the route was created. The following are the possible values:   CreateRouteTable - The route was automatically created when the route table was created.   CreateRoute - The route was manually added to the route table.   EnableVgwRoutePropagation - The route was propagated by route propagation.  
     */
    Origin?: String;
    /**
     * The ID of a transit gateway.
     */
    TransitGatewayId?: String;
    /**
     * The ID of a VPC peering connection.
     */
    VpcPeeringConnectionId?: String;
    /**
     * The state. The following are the possible values:   active   blackhole  
     */
    State?: String;
  }
  export interface AnalysisSecurityGroupRule {
    /**
     * The IPv4 address range, in CIDR notation.
     */
    Cidr?: String;
    /**
     * The direction. The following are the possible values:   egress   ingress  
     */
    Direction?: String;
    /**
     * The security group ID.
     */
    SecurityGroupId?: String;
    /**
     * The port range.
     */
    PortRange?: PortRange;
    /**
     * The prefix list ID.
     */
    PrefixListId?: String;
    /**
     * The protocol name.
     */
    Protocol?: String;
  }
  export type AnalysisStatus = "running"|"succeeded"|"failed"|string;
  export type ApplianceModeSupportValue = "enable"|"disable"|string;
  export interface ApplySecurityGroupsToClientVpnTargetNetworkRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * The ID of the VPC in which the associated target network is located.
     */
    VpcId: VpcId;
    /**
     * The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.
     */
    SecurityGroupIds: ClientVpnSecurityGroupIdSet;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface ApplySecurityGroupsToClientVpnTargetNetworkResult {
    /**
     * The IDs of the applied security groups.
     */
    SecurityGroupIds?: ClientVpnSecurityGroupIdSet;
  }
  export type ArchitectureType = "i386"|"x86_64"|"arm64"|"x86_64_mac"|"arm64_mac"|string;
  export type ArchitectureTypeList = ArchitectureType[];
  export type ArchitectureTypeSet = ArchitectureType[];
  export type ArchitectureValues = "i386"|"x86_64"|"arm64"|"x86_64_mac"|"arm64_mac"|string;
  export type ArnList = ResourceArn[];
  export interface AssignIpv6AddressesRequest {
    /**
     * The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.
     */
    Ipv6AddressCount?: Integer;
    /**
     * The IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses.
     */
    Ipv6Addresses?: Ipv6AddressList;
    /**
     * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv6Prefixes option.
     */
    Ipv6PrefixCount?: Integer;
    /**
     * One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the Ipv6PrefixCount option.
     */
    Ipv6Prefixes?: IpPrefixList;
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId: NetworkInterfaceId;
  }
  export interface AssignIpv6AddressesResult {
    /**
     * The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned to the network interface before the request are not included.
     */
    AssignedIpv6Addresses?: Ipv6AddressList;
    /**
     * The IPv6 prefixes that are assigned to the network interface.
     */
    AssignedIpv6Prefixes?: IpPrefixList;
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId?: String;
  }
  export interface AssignPrivateIpAddressesRequest {
    /**
     * Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.
     */
    AllowReassignment?: Boolean;
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId: NetworkInterfaceId;
    /**
     * The IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses. If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
     */
    PrivateIpAddresses?: PrivateIpAddressStringList;
    /**
     * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.
     */
    SecondaryPrivateIpAddressCount?: Integer;
    /**
     * One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option.
     */
    Ipv4Prefixes?: IpPrefixList;
    /**
     * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option.
     */
    Ipv4PrefixCount?: Integer;
  }
  export interface AssignPrivateIpAddressesResult {
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId?: String;
    /**
     * The private IP addresses assigned to the network interface.
     */
    AssignedPrivateIpAddresses?: AssignedPrivateIpAddressList;
    /**
     * The IPv4 prefixes that are assigned to the network interface.
     */
    AssignedIpv4Prefixes?: Ipv4PrefixesList;
  }
  export interface AssignedPrivateIpAddress {
    /**
     * The private IP address assigned to the network interface.
     */
    PrivateIpAddress?: String;
  }
  export type AssignedPrivateIpAddressList = AssignedPrivateIpAddress[];
  export interface AssociateAddressRequest {
    /**
     * [EC2-VPC] The allocation ID. This is required for EC2-VPC.
     */
    AllocationId?: AllocationId;
    /**
     * The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state.
     */
    InstanceId?: InstanceId;
    /**
     * [EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.
     */
    PublicIp?: String;
    /**
     * [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.
     */
    AllowReassociation?: Boolean;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. 
     */
    NetworkInterfaceId?: NetworkInterfaceId;
    /**
     * [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
     */
    PrivateIpAddress?: String;
  }
  export interface AssociateAddressResult {
    /**
     * [EC2-VPC] The ID that represents the association of the Elastic IP address with an instance.
     */
    AssociationId?: String;
  }
  export interface AssociateClientVpnTargetNetworkRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * The ID of the subnet to associate with the Client VPN endpoint.
     */
    SubnetId: SubnetId;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AssociateClientVpnTargetNetworkResult {
    /**
     * The unique ID of the target network association.
     */
    AssociationId?: String;
    /**
     * The current state of the target network association.
     */
    Status?: AssociationStatus;
  }
  export interface AssociateDhcpOptionsRequest {
    /**
     * The ID of the DHCP options set, or default to associate no DHCP options with the VPC.
     */
    DhcpOptionsId: DefaultingDhcpOptionsId;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AssociateEnclaveCertificateIamRoleRequest {
    /**
     * The ARN of the ACM certificate with which to associate the IAM role.
     */
    CertificateArn?: ResourceArn;
    /**
     * The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate.
     */
    RoleArn?: ResourceArn;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AssociateEnclaveCertificateIamRoleResult {
    /**
     * The name of the Amazon S3 bucket to which the certificate was uploaded.
     */
    CertificateS3BucketName?: String;
    /**
     * The Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored. The object key is formatted as follows: role_arn/certificate_arn.
     */
    CertificateS3ObjectKey?: String;
    /**
     * The ID of the KMS key used to encrypt the private key of the certificate.
     */
    EncryptionKmsKeyId?: String;
  }
  export interface AssociateIamInstanceProfileRequest {
    /**
     * The IAM instance profile.
     */
    IamInstanceProfile: IamInstanceProfileSpecification;
    /**
     * The ID of the instance.
     */
    InstanceId: InstanceId;
  }
  export interface AssociateIamInstanceProfileResult {
    /**
     * Information about the IAM instance profile association.
     */
    IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
  }
  export interface AssociateInstanceEventWindowRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the event window.
     */
    InstanceEventWindowId: InstanceEventWindowId;
    /**
     * One or more targets associated with the specified event window.
     */
    AssociationTarget: InstanceEventWindowAssociationRequest;
  }
  export interface AssociateInstanceEventWindowResult {
    /**
     * Information about the event window.
     */
    InstanceEventWindow?: InstanceEventWindow;
  }
  export interface AssociateRouteTableRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the route table.
     */
    RouteTableId: RouteTableId;
    /**
     * The ID of the subnet.
     */
    SubnetId?: SubnetId;
    /**
     * The ID of the internet gateway or virtual private gateway.
     */
    GatewayId?: RouteGatewayId;
  }
  export interface AssociateRouteTableResult {
    /**
     * The route table association ID. This ID is required for disassociating the route table.
     */
    AssociationId?: String;
    /**
     * The state of the association.
     */
    AssociationState?: RouteTableAssociationState;
  }
  export interface AssociateSubnetCidrBlockRequest {
    /**
     * The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.
     */
    Ipv6CidrBlock: String;
    /**
     * The ID of your subnet.
     */
    SubnetId: SubnetId;
  }
  export interface AssociateSubnetCidrBlockResult {
    /**
     * Information about the IPv6 association.
     */
    Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
    /**
     * The ID of the subnet.
     */
    SubnetId?: String;
  }
  export interface AssociateTransitGatewayMulticastDomainRequest {
    /**
     * The ID of the transit gateway multicast domain.
     */
    TransitGatewayMulticastDomainId?: TransitGatewayMulticastDomainId;
    /**
     * The ID of the transit gateway attachment to associate with the transit gateway multicast domain.
     */
    TransitGatewayAttachmentId?: TransitGatewayAttachmentId;
    /**
     * The IDs of the subnets to associate with the transit gateway multicast domain.
     */
    SubnetIds?: TransitGatewaySubnetIdList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AssociateTransitGatewayMulticastDomainResult {
    /**
     * Information about the transit gateway multicast domain associations.
     */
    Associations?: TransitGatewayMulticastDomainAssociations;
  }
  export interface AssociateTransitGatewayPolicyTableRequest {
    /**
     * The ID of the transit gateway policy table to associate with the transit gateway attachment.
     */
    TransitGatewayPolicyTableId: TransitGatewayPolicyTableId;
    /**
     * The ID of the transit gateway attachment to associate with the policy table.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AssociateTransitGatewayPolicyTableResult {
    /**
     * Describes the association of a transit gateway and a transit gateway policy table.
     */
    Association?: TransitGatewayPolicyTableAssociation;
  }
  export interface AssociateTransitGatewayRouteTableRequest {
    /**
     * The ID of the transit gateway route table.
     */
    TransitGatewayRouteTableId: TransitGatewayRouteTableId;
    /**
     * The ID of the attachment.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AssociateTransitGatewayRouteTableResult {
    /**
     * The ID of the association.
     */
    Association?: TransitGatewayAssociation;
  }
  export interface AssociateTrunkInterfaceRequest {
    /**
     * The ID of the branch network interface.
     */
    BranchInterfaceId: NetworkInterfaceId;
    /**
     * The ID of the trunk network interface.
     */
    TrunkInterfaceId: NetworkInterfaceId;
    /**
     * The ID of the VLAN. This applies to the VLAN protocol.
     */
    VlanId?: Integer;
    /**
     * The application key. This applies to the GRE protocol.
     */
    GreKey?: Integer;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency.
     */
    ClientToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AssociateTrunkInterfaceResult {
    /**
     * Information about the association between the trunk network interface and branch network interface.
     */
    InterfaceAssociation?: TrunkInterfaceAssociation;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency.
     */
    ClientToken?: String;
  }
  export interface AssociateVpcCidrBlockRequest {
    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
     */
    AmazonProvidedIpv6CidrBlock?: Boolean;
    /**
     * An IPv4 CIDR block to associate with the VPC.
     */
    CidrBlock?: String;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.  You must set AmazonProvidedIpv6CidrBlock to true to use this parameter.  You can have one IPv6 CIDR block association per network border group.
     */
    Ipv6CidrBlockNetworkBorderGroup?: String;
    /**
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    Ipv6Pool?: Ipv6PoolEc2Id;
    /**
     * An IPv6 CIDR block from the IPv6 address pool. You must also specify Ipv6Pool in the request. To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    Ipv6CidrBlock?: String;
    /**
     * Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see What is IPAM? in the Amazon VPC IPAM User Guide.
     */
    Ipv4IpamPoolId?: IpamPoolId;
    /**
     * The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see What is IPAM? in the Amazon VPC IPAM User Guide. 
     */
    Ipv4NetmaskLength?: NetmaskLength;
    /**
     * Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see What is IPAM? in the Amazon VPC IPAM User Guide.
     */
    Ipv6IpamPoolId?: IpamPoolId;
    /**
     * The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see What is IPAM? in the Amazon VPC IPAM User Guide. 
     */
    Ipv6NetmaskLength?: NetmaskLength;
  }
  export interface AssociateVpcCidrBlockResult {
    /**
     * Information about the IPv6 CIDR block association.
     */
    Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
    /**
     * Information about the IPv4 CIDR block association.
     */
    CidrBlockAssociation?: VpcCidrBlockAssociation;
    /**
     * The ID of the VPC.
     */
    VpcId?: String;
  }
  export type AssociatedNetworkType = "vpc"|string;
  export interface AssociatedRole {
    /**
     * The ARN of the associated IAM role.
     */
    AssociatedRoleArn?: ResourceArn;
    /**
     * The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
     */
    CertificateS3BucketName?: String;
    /**
     * The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle is stored. The object key is formated as follows: role_arn/certificate_arn. 
     */
    CertificateS3ObjectKey?: String;
    /**
     * The ID of the KMS customer master key (CMK) used to encrypt the private key.
     */
    EncryptionKmsKeyId?: String;
  }
  export type AssociatedRolesList = AssociatedRole[];
  export interface AssociatedTargetNetwork {
    /**
     * The ID of the subnet.
     */
    NetworkId?: String;
    /**
     * The target network type.
     */
    NetworkType?: AssociatedNetworkType;
  }
  export type AssociatedTargetNetworkSet = AssociatedTargetNetwork[];
  export type AssociationIdList = IamInstanceProfileAssociationId[];
  export interface AssociationStatus {
    /**
     * The state of the target network association.
     */
    Code?: AssociationStatusCode;
    /**
     * A message about the status of the target network association, if applicable.
     */
    Message?: String;
  }
  export type AssociationStatusCode = "associating"|"associated"|"association-failed"|"disassociating"|"disassociated"|string;
  export interface AthenaIntegration {
    /**
     * The location in Amazon S3 to store the generated CloudFormation template.
     */
    IntegrationResultS3DestinationArn: String;
    /**
     * The schedule for adding new partitions to the table.
     */
    PartitionLoadFrequency: PartitionLoadFrequency;
    /**
     * The start date for the partition.
     */
    PartitionStartDate?: MillisecondDateTime;
    /**
     * The end date for the partition.
     */
    PartitionEndDate?: MillisecondDateTime;
  }
  export type AthenaIntegrationsSet = AthenaIntegration[];
  export interface AttachClassicLinkVpcRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.
     */
    Groups: GroupIdStringList;
    /**
     * The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
     */
    InstanceId: InstanceId;
    /**
     * The ID of a ClassicLink-enabled VPC.
     */
    VpcId: VpcId;
  }
  export interface AttachClassicLinkVpcResult {
    /**
     * Returns true if the request succeeds; otherwise, it returns an error.
     */
    Return?: Boolean;
  }
  export interface AttachInternetGatewayRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the internet gateway.
     */
    InternetGatewayId: InternetGatewayId;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
  }
  export interface AttachNetworkInterfaceRequest {
    /**
     * The index of the device for the network interface attachment.
     */
    DeviceIndex: Integer;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the instance.
     */
    InstanceId: InstanceId;
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId: NetworkInterfaceId;
    /**
     * The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.
     */
    NetworkCardIndex?: Integer;
  }
  export interface AttachNetworkInterfaceResult {
    /**
     * The ID of the network interface attachment.
     */
    AttachmentId?: String;
    /**
     * The index of the network card.
     */
    NetworkCardIndex?: Integer;
  }
  export interface AttachVolumeRequest {
    /**
     * The device name (for example, /dev/sdh or xvdh).
     */
    Device: String;
    /**
     * The ID of the instance.
     */
    InstanceId: InstanceId;
    /**
     * The ID of the EBS volume. The volume and instance must be within the same Availability Zone.
     */
    VolumeId: VolumeId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AttachVpnGatewayRequest {
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * The ID of the virtual private gateway.
     */
    VpnGatewayId: VpnGatewayId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AttachVpnGatewayResult {
    /**
     * Information about the attachment.
     */
    VpcAttachment?: VpcAttachment;
  }
  export type AttachmentStatus = "attaching"|"attached"|"detaching"|"detached"|string;
  export interface AttributeBooleanValue {
    /**
     * The attribute value. The valid values are true or false.
     */
    Value?: Boolean;
  }
  export interface AttributeValue {
    /**
     * The attribute value. The value is case-sensitive.
     */
    Value?: String;
  }
  export interface AuthorizationRule {
    /**
     * The ID of the Client VPN endpoint with which the authorization rule is associated.
     */
    ClientVpnEndpointId?: String;
    /**
     * A brief description of the authorization rule.
     */
    Description?: String;
    /**
     * The ID of the Active Directory group to which the authorization rule grants access.
     */
    GroupId?: String;
    /**
     * Indicates whether the authorization rule grants access to all clients.
     */
    AccessAll?: Boolean;
    /**
     * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     */
    DestinationCidr?: String;
    /**
     * The current state of the authorization rule.
     */
    Status?: ClientVpnAuthorizationRuleStatus;
  }
  export type AuthorizationRuleSet = AuthorizationRule[];
  export interface AuthorizeClientVpnIngressRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     */
    TargetNetworkCidr: String;
    /**
     * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if AuthorizeAllGroups is false or not specified.
     */
    AccessGroupId?: String;
    /**
     * Indicates whether to grant access to all clients. Specify true to grant all clients who successfully establish a VPN connection access to the network. Must be set to true if AccessGroupId is not specified.
     */
    AuthorizeAllGroups?: Boolean;
    /**
     * A brief description of the authorization rule.
     */
    Description?: String;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface AuthorizeClientVpnIngressResult {
    /**
     * The current state of the authorization rule.
     */
    Status?: ClientVpnAuthorizationRuleStatus;
  }
  export interface AuthorizeSecurityGroupEgressRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the security group.
     */
    GroupId: SecurityGroupId;
    /**
     * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.
     */
    IpPermissions?: IpPermissionList;
    /**
     * The tags applied to the security group rule.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Not supported. Use a set of IP permissions to specify the CIDR.
     */
    CidrIp?: String;
    /**
     * Not supported. Use a set of IP permissions to specify the port.
     */
    FromPort?: Integer;
    /**
     * Not supported. Use a set of IP permissions to specify the protocol name or number.
     */
    IpProtocol?: String;
    /**
     * Not supported. Use a set of IP permissions to specify the port.
     */
    ToPort?: Integer;
    /**
     * Not supported. Use a set of IP permissions to specify a destination security group.
     */
    SourceSecurityGroupName?: String;
    /**
     * Not supported. Use a set of IP permissions to specify a destination security group.
     */
    SourceSecurityGroupOwnerId?: String;
  }
  export interface AuthorizeSecurityGroupEgressResult {
    /**
     * Returns true if the request succeeds; otherwise, returns an error.
     */
    Return?: Boolean;
    /**
     * Information about the outbound (egress) security group rules that were added.
     */
    SecurityGroupRules?: SecurityGroupRuleList;
  }
  export interface AuthorizeSecurityGroupIngressRequest {
    /**
     * The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    CidrIp?: String;
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use -1 to specify all types. If you specify all ICMP types, you must specify all codes. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    FromPort?: Integer;
    /**
     * The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    GroupId?: SecurityGroupId;
    /**
     * [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    GroupName?: SecurityGroupName;
    /**
     * The sets of IP permissions.
     */
    IpPermissions?: IpPermissionList;
    /**
     * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers). To specify icmpv6, use a set of IP permissions. [VPC only] Use -1 to specify all protocols. If you specify -1 or a protocol other than tcp, udp, or icmp, traffic on all ports is allowed, regardless of any ports you specify. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    IpProtocol?: String;
    /**
     * [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.
     */
    SourceSecurityGroupName?: String;
    /**
     * [nondefault VPC] The Amazon Web Services account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.
     */
    SourceSecurityGroupOwnerId?: String;
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use -1 to specify all codes. If you specify all ICMP types, you must specify all codes. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    ToPort?: Integer;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * [VPC Only] The tags applied to the security group rule.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface AuthorizeSecurityGroupIngressResult {
    /**
     * Returns true if the request succeeds; otherwise, returns an error.
     */
    Return?: Boolean;
    /**
     * Information about the inbound (ingress) security group rules that were added.
     */
    SecurityGroupRules?: SecurityGroupRuleList;
  }
  export type AutoAcceptSharedAssociationsValue = "enable"|"disable"|string;
  export type AutoAcceptSharedAttachmentsValue = "enable"|"disable"|string;
  export type AutoPlacement = "on"|"off"|string;
  export type AutoRecoveryFlag = boolean;
  export interface AvailabilityZone {
    /**
     * The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always available.
     */
    State?: AvailabilityZoneState;
    /**
     * For Availability Zones, this parameter always has the value of opt-in-not-required. For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are opted-in, and not-opted-in.
     */
    OptInStatus?: AvailabilityZoneOptInStatus;
    /**
     * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
     */
    Messages?: AvailabilityZoneMessageList;
    /**
     * The name of the Region.
     */
    RegionName?: String;
    /**
     * The name of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    ZoneName?: String;
    /**
     * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    ZoneId?: String;
    /**
     *  For Availability Zones, this parameter has the same value as the Region name. For Local Zones, the name of the associated group, for example us-west-2-lax-1. For Wavelength Zones, the name of the associated group, for example us-east-1-wl1-bos-wlz-1.
     */
    GroupName?: String;
    /**
     * The name of the network border group.
     */
    NetworkBorderGroup?: String;
    /**
     * The type of zone. The valid values are availability-zone, local-zone, and wavelength-zone.
     */
    ZoneType?: String;
    /**
     * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
     */
    ParentZoneName?: String;
    /**
     * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
     */
    ParentZoneId?: String;
  }
  export type AvailabilityZoneList = AvailabilityZone[];
  export interface AvailabilityZoneMessage {
    /**
     * The message about the Availability Zone, Local Zone, or Wavelength Zone.
     */
    Message?: String;
  }
  export type AvailabilityZoneMessageList = AvailabilityZoneMessage[];
  export type AvailabilityZoneOptInStatus = "opt-in-not-required"|"opted-in"|"not-opted-in"|string;
  export type AvailabilityZoneState = "available"|"information"|"impaired"|"unavailable"|string;
  export type AvailabilityZoneStringList = String[];
  export interface AvailableCapacity {
    /**
     * The number of instances that can be launched onto the Dedicated Host depending on the host's available capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number of instances for each instance size that is supported on the host.
     */
    AvailableInstanceCapacity?: AvailableInstanceCapacityList;
    /**
     * The number of vCPUs available for launching instances onto the Dedicated Host.
     */
    AvailableVCpus?: Integer;
  }
  export type AvailableInstanceCapacityList = InstanceCapacity[];
  export type BareMetal = "included"|"required"|"excluded"|string;
  export type BareMetalFlag = boolean;
  export type BaselineBandwidthInMbps = number;
  export interface BaselineEbsBandwidthMbps {
    /**
     * The minimum baseline bandwidth, in Mbps. If this parameter is not specified, there is no minimum limit.
     */
    Min?: Integer;
    /**
     * The maximum baseline bandwidth, in Mbps. If this parameter is not specified, there is no maximum limit.
     */
    Max?: Integer;
  }
  export interface BaselineEbsBandwidthMbpsRequest {
    /**
     * The minimum baseline bandwidth, in Mbps. To specify no minimum limit, omit this parameter.
     */
    Min?: Integer;
    /**
     * The maximum baseline bandwidth, in Mbps. To specify no maximum limit, omit this parameter.
     */
    Max?: Integer;
  }
  export type BaselineIops = number;
  export type BaselineThroughputInMBps = number;
  export type BatchState = "submitted"|"active"|"cancelled"|"failed"|"cancelled_running"|"cancelled_terminating"|"modifying"|string;
  export type BgpStatus = "up"|"down"|string;
  export type BillingProductList = String[];
  export type _Blob = Buffer|Uint8Array|Blob|string;
  export interface BlobAttributeValue {
    Value?: _Blob;
  }
  export interface BlockDeviceMapping {
    /**
     * The device name (for example, /dev/sdh or xvdh).
     */
    DeviceName?: String;
    /**
     * The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for ephemeral0 and ephemeral1. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume. NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect. Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.
     */
    VirtualName?: String;
    /**
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    Ebs?: EbsBlockDevice;
    /**
     * To omit the device from the block device mapping, specify an empty string. When this property is specified, the device is removed from the block device mapping regardless of the assigned value.
     */
    NoDevice?: String;
  }
  export type BlockDeviceMappingList = BlockDeviceMapping[];
  export type BlockDeviceMappingRequestList = BlockDeviceMapping[];
  export type Boolean = boolean;
  export type BootModeType = "legacy-bios"|"uefi"|string;
  export type BootModeTypeList = BootModeType[];
  export type BootModeValues = "legacy-bios"|"uefi"|string;
  export type BoxedDouble = number;
  export type BundleId = string;
  export type BundleIdStringList = BundleId[];
  export interface BundleInstanceRequest {
    /**
     * The ID of the instance to bundle. Type: String Default: None Required: Yes
     */
    InstanceId: InstanceId;
    /**
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     */
    Storage: Storage;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface BundleInstanceResult {
    /**
     * Information about the bundle task.
     */
    BundleTask?: BundleTask;
  }
  export interface BundleTask {
    /**
     * The ID of the bundle task.
     */
    BundleId?: String;
    /**
     * If the task fails, a description of the error.
     */
    BundleTaskError?: BundleTaskError;
    /**
     * The ID of the instance associated with this bundle task.
     */
    InstanceId?: String;
    /**
     * The level of task completion, as a percent (for example, 20%).
     */
    Progress?: String;
    /**
     * The time this task started.
     */
    StartTime?: DateTime;
    /**
     * The state of the task.
     */
    State?: BundleTaskState;
    /**
     * The Amazon S3 storage locations.
     */
    Storage?: Storage;
    /**
     * The time of the most recent update for the task.
     */
    UpdateTime?: DateTime;
  }
  export interface BundleTaskError {
    /**
     * The error code.
     */
    Code?: String;
    /**
     * The error message.
     */
    Message?: String;
  }
  export type BundleTaskList = BundleTask[];
  export type BundleTaskState = "pending"|"waiting-for-shutdown"|"bundling"|"storing"|"cancelling"|"complete"|"failed"|string;
  export type BurstablePerformance = "included"|"required"|"excluded"|string;
  export type BurstablePerformanceFlag = boolean;
  export interface ByoipCidr {
    /**
     * The address range, in CIDR notation.
     */
    Cidr?: String;
    /**
     * The description of the address range.
     */
    Description?: String;
    /**
     * Upon success, contains the ID of the address pool. Otherwise, contains an error message.
     */
    StatusMessage?: String;
    /**
     * The state of the address pool.
     */
    State?: ByoipCidrState;
  }
  export type ByoipCidrSet = ByoipCidr[];
  export type ByoipCidrState = "advertised"|"deprovisioned"|"failed-deprovision"|"failed-provision"|"pending-deprovision"|"pending-provision"|"provisioned"|"provisioned-not-publicly-advertisable"|string;
  export type CancelBatchErrorCode = "fleetRequestIdDoesNotExist"|"fleetRequestIdMalformed"|"fleetRequestNotInCancellableState"|"unexpectedError"|string;
  export interface CancelBundleTaskRequest {
    /**
     * The ID of the bundle task.
     */
    BundleId: BundleId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CancelBundleTaskResult {
    /**
     * Information about the bundle task.
     */
    BundleTask?: BundleTask;
  }
  export interface CancelCapacityReservationFleetError {
    /**
     * The error code.
     */
    Code?: CancelCapacityReservationFleetErrorCode;
    /**
     * The error message.
     */
    Message?: CancelCapacityReservationFleetErrorMessage;
  }
  export type CancelCapacityReservationFleetErrorCode = string;
  export type CancelCapacityReservationFleetErrorMessage = string;
  export interface CancelCapacityReservationFleetsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of the Capacity Reservation Fleets to cancel.
     */
    CapacityReservationFleetIds: CapacityReservationFleetIdSet;
  }
  export interface CancelCapacityReservationFleetsResult {
    /**
     * Information about the Capacity Reservation Fleets that were successfully cancelled.
     */
    SuccessfulFleetCancellations?: CapacityReservationFleetCancellationStateSet;
    /**
     * Information about the Capacity Reservation Fleets that could not be cancelled.
     */
    FailedFleetCancellations?: FailedCapacityReservationFleetCancellationResultSet;
  }
  export interface CancelCapacityReservationRequest {
    /**
     * The ID of the Capacity Reservation to be cancelled.
     */
    CapacityReservationId: CapacityReservationId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CancelCapacityReservationResult {
    /**
     * Returns true if the request succeeds; otherwise, it returns an error.
     */
    Return?: Boolean;
  }
  export interface CancelConversionRequest {
    /**
     * The ID of the conversion task.
     */
    ConversionTaskId: ConversionTaskId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The reason for canceling the conversion task.
     */
    ReasonMessage?: String;
  }
  export interface CancelExportTaskRequest {
    /**
     * The ID of the export task. This is the ID returned by CreateInstanceExportTask.
     */
    ExportTaskId: ExportVmTaskId;
  }
  export interface CancelImageLaunchPermissionRequest {
    /**
     * The ID of the AMI that was shared with your Amazon Web Services account.
     */
    ImageId: ImageId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CancelImageLaunchPermissionResult {
    /**
     * Returns true if the request succeeds; otherwise, it returns an error.
     */
    Return?: Boolean;
  }
  export interface CancelImportTaskRequest {
    /**
     * The reason for canceling the task.
     */
    CancelReason?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the import image or import snapshot task to be canceled.
     */
    ImportTaskId?: ImportTaskId;
  }
  export interface CancelImportTaskResult {
    /**
     * The ID of the task being canceled.
     */
    ImportTaskId?: String;
    /**
     * The current state of the task being canceled.
     */
    PreviousState?: String;
    /**
     * The current state of the task being canceled.
     */
    State?: String;
  }
  export interface CancelReservedInstancesListingRequest {
    /**
     * The ID of the Reserved Instance listing.
     */
    ReservedInstancesListingId: ReservedInstancesListingId;
  }
  export interface CancelReservedInstancesListingResult {
    /**
     * The Reserved Instance listing.
     */
    ReservedInstancesListings?: ReservedInstancesListingList;
  }
  export interface CancelSpotFleetRequestsError {
    /**
     * The error code.
     */
    Code?: CancelBatchErrorCode;
    /**
     * The description for the error code.
     */
    Message?: String;
  }
  export interface CancelSpotFleetRequestsErrorItem {
    /**
     * The error.
     */
    Error?: CancelSpotFleetRequestsError;
    /**
     * The ID of the Spot Fleet request.
     */
    SpotFleetRequestId?: String;
  }
  export type CancelSpotFleetRequestsErrorSet = CancelSpotFleetRequestsErrorItem[];
  export interface CancelSpotFleetRequestsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of the Spot Fleet requests.
     */
    SpotFleetRequestIds: SpotFleetRequestIdList;
    /**
     * Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.
     */
    TerminateInstances: Boolean;
  }
  export interface CancelSpotFleetRequestsResponse {
    /**
     * Information about the Spot Fleet requests that are successfully canceled.
     */
    SuccessfulFleetRequests?: CancelSpotFleetRequestsSuccessSet;
    /**
     * Information about the Spot Fleet requests that are not successfully canceled.
     */
    UnsuccessfulFleetRequests?: CancelSpotFleetRequestsErrorSet;
  }
  export interface CancelSpotFleetRequestsSuccessItem {
    /**
     * The current state of the Spot Fleet request.
     */
    CurrentSpotFleetRequestState?: BatchState;
    /**
     * The previous state of the Spot Fleet request.
     */
    PreviousSpotFleetRequestState?: BatchState;
    /**
     * The ID of the Spot Fleet request.
     */
    SpotFleetRequestId?: String;
  }
  export type CancelSpotFleetRequestsSuccessSet = CancelSpotFleetRequestsSuccessItem[];
  export type CancelSpotInstanceRequestState = "active"|"open"|"closed"|"cancelled"|"completed"|string;
  export interface CancelSpotInstanceRequestsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * One or more Spot Instance request IDs.
     */
    SpotInstanceRequestIds: SpotInstanceRequestIdList;
  }
  export interface CancelSpotInstanceRequestsResult {
    /**
     * One or more Spot Instance requests.
     */
    CancelledSpotInstanceRequests?: CancelledSpotInstanceRequestList;
  }
  export interface CancelledSpotInstanceRequest {
    /**
     * The ID of the Spot Instance request.
     */
    SpotInstanceRequestId?: String;
    /**
     * The state of the Spot Instance request.
     */
    State?: CancelSpotInstanceRequestState;
  }
  export type CancelledSpotInstanceRequestList = CancelledSpotInstanceRequest[];
  export interface CapacityAllocation {
    /**
     * The usage type. used indicates that the instance capacity is in use by instances that are running in the Capacity Reservation.
     */
    AllocationType?: AllocationType;
    /**
     * The amount of instance capacity associated with the usage. For example a value of 4 indicates that instance capacity for 4 instances is currently in use.
     */
    Count?: Integer;
  }
  export type CapacityAllocations = CapacityAllocation[];
  export interface CapacityReservation {
    /**
     * The ID of the Capacity Reservation.
     */
    CapacityReservationId?: String;
    /**
     * The ID of the Amazon Web Services account that owns the Capacity Reservation.
     */
    OwnerId?: String;
    /**
     * The Amazon Resource Name (ARN) of the Capacity Reservation.
     */
    CapacityReservationArn?: String;
    /**
     * The Availability Zone ID of the Capacity Reservation.
     */
    AvailabilityZoneId?: String;
    /**
     * The type of instance for which the Capacity Reservation reserves capacity.
     */
    InstanceType?: String;
    /**
     * The type of operating system for which the Capacity Reservation reserves capacity.
     */
    InstancePlatform?: CapacityReservationInstancePlatform;
    /**
     * The Availability Zone in which the capacity is reserved.
     */
    AvailabilityZone?: String;
    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:    default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.    dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.  
     */
    Tenancy?: CapacityReservationTenancy;
    /**
     * The total number of instances for which the Capacity Reservation reserves capacity.
     */
    TotalInstanceCount?: Integer;
    /**
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     */
    AvailableInstanceCount?: Integer;
    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
     */
    EbsOptimized?: Boolean;
    /**
     *  Deprecated. 
     */
    EphemeralStorage?: Boolean;
    /**
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:    active - The Capacity Reservation is active and the capacity is available for your use.    expired - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.    cancelled - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.    pending - The Capacity Reservation request was successful but the capacity provisioning is still pending.    failed - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.  
     */
    State?: CapacityReservationState;
    /**
     * The date and time at which the Capacity Reservation was started.
     */
    StartDate?: MillisecondDateTime;
    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.
     */
    EndDate?: DateTime;
    /**
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:    unlimited - The Capacity Reservation remains active until you explicitly cancel it.    limited - The Capacity Reservation expires automatically at a specified date and time.  
     */
    EndDateType?: EndDateType;
    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:    open - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.    targeted - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.   
     */
    InstanceMatchCriteria?: InstanceMatchCriteria;
    /**
     * The date and time at which the Capacity Reservation was created.
     */
    CreateDate?: DateTime;
    /**
     * Any tags assigned to the Capacity Reservation.
     */
    Tags?: TagList;
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
     */
    OutpostArn?: OutpostArn;
    /**
     * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for Capacity Reservations that were created by a Capacity Reservation Fleet.
     */
    CapacityReservationFleetId?: String;
    /**
     * The Amazon Resource Name (ARN) of the cluster placement group in which the Capacity Reservation was created. For more information, see  Capacity Reservations for cluster placement groups in the Amazon EC2 User Guide.
     */
    PlacementGroupArn?: PlacementGroupArn;
    /**
     * Information about instance capacity usage.
     */
    CapacityAllocations?: CapacityAllocations;
  }
  export interface CapacityReservationFleet {
    /**
     * The ID of the Capacity Reservation Fleet.
     */
    CapacityReservationFleetId?: CapacityReservationFleetId;
    /**
     * The ARN of the Capacity Reservation Fleet.
     */
    CapacityReservationFleetArn?: String;
    /**
     * The state of the Capacity Reservation Fleet. Possible states include:    submitted - The Capacity Reservation Fleet request has been submitted and Amazon Elastic Compute Cloud is preparing to create the Capacity Reservations.    modifying - The Capacity Reservation Fleet is being modified. The Fleet remains in this state until the modification is complete.    active - The Capacity Reservation Fleet has fulfilled its total target capacity and it is attempting to maintain this capacity. The Fleet remains in this state until it is modified or deleted.    partially_fulfilled - The Capacity Reservation Fleet has partially fulfilled its total target capacity. There is insufficient Amazon EC2 to fulfill the total target capacity. The Fleet is attempting to asynchronously fulfill its total target capacity.    expiring - The Capacity Reservation Fleet has reach its end date and it is in the process of expiring. One or more of its Capacity reservations might still be active.    expired - The Capacity Reservation Fleet has reach its end date. The Fleet and its Capacity Reservations are expired. The Fleet can't create new Capacity Reservations.    cancelling - The Capacity Reservation Fleet is in the process of being cancelled. One or more of its Capacity reservations might still be active.    cancelled - The Capacity Reservation Fleet has been manually cancelled. The Fleet and its Capacity Reservations are cancelled and the Fleet can't create new Capacity Reservations.    failed - The Capacity Reservation Fleet failed to reserve capacity for the specified instance types.  
     */
    State?: CapacityReservationFleetState;
    /**
     * The total number of capacity units for which the Capacity Reservation Fleet reserves capacity. For more information, see Total target capacity in the Amazon EC2 User Guide.
     */
    TotalTargetCapacity?: Integer;
    /**
     * The capacity units that have been fulfilled.
     */
    TotalFulfilledCapacity?: Double;
    /**
     * The tenancy of the Capacity Reservation Fleet. Tenancies include:    default - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.    dedicated - The Capacity Reservation Fleet is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.  
     */
    Tenancy?: FleetCapacityReservationTenancy;
    /**
     * The date and time at which the Capacity Reservation Fleet expires.
     */
    EndDate?: MillisecondDateTime;
    /**
     * The date and time at which the Capacity Reservation Fleet was created.
     */
    CreateTime?: MillisecondDateTime;
    /**
     * Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria. Currently, Capacity Reservation Fleets support open instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
     */
    InstanceMatchCriteria?: FleetInstanceMatchCriteria;
    /**
     * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. For more information, see For more information, see  Allocation strategy in the Amazon EC2 User Guide.
     */
    AllocationStrategy?: String;
    /**
     * Information about the instance types for which to reserve the capacity.
     */
    InstanceTypeSpecifications?: FleetCapacityReservationSet;
    /**
     * The tags assigned to the Capacity Reservation Fleet.
     */
    Tags?: TagList;
  }
  export interface CapacityReservationFleetCancellationState {
    /**
     * The current state of the Capacity Reservation Fleet.
     */
    CurrentFleetState?: CapacityReservationFleetState;
    /**
     * The previous state of the Capacity Reservation Fleet.
     */
    PreviousFleetState?: CapacityReservationFleetState;
    /**
     * The ID of the Capacity Reservation Fleet that was successfully cancelled.
     */
    CapacityReservationFleetId?: CapacityReservationFleetId;
  }
  export type CapacityReservationFleetCancellationStateSet = CapacityReservationFleetCancellationState[];
  export type CapacityReservationFleetId = string;
  export type CapacityReservationFleetIdSet = CapacityReservationFleetId[];
  export type CapacityReservationFleetSet = CapacityReservationFleet[];
  export type CapacityReservationFleetState = "submitted"|"modifying"|"active"|"partially_fulfilled"|"expiring"|"expired"|"cancelling"|"cancelled"|"failed"|string;
  export interface CapacityReservationGroup {
    /**
     * The ARN of the resource group.
     */
    GroupArn?: String;
    /**
     * The ID of the Amazon Web Services account that owns the resource group.
     */
    OwnerId?: String;
  }
  export type CapacityReservationGroupSet = CapacityReservationGroup[];
  export type CapacityReservationId = string;
  export type CapacityReservationIdSet = CapacityReservationId[];
  export type CapacityReservationInstancePlatform = "Linux/UNIX"|"Red Hat Enterprise Linux"|"SUSE Linux"|"Windows"|"Windows with SQL Server"|"Windows with SQL Server Enterprise"|"Windows with SQL Server Standard"|"Windows with SQL Server Web"|"Linux with SQL Server Standard"|"Linux with SQL Server Web"|"Linux with SQL Server Enterprise"|"RHEL with SQL Server Standard"|"RHEL with SQL Server Enterprise"|"RHEL with SQL Server Web"|"RHEL with HA"|"RHEL with HA and SQL Server Standard"|"RHEL with HA and SQL Server Enterprise"|string;
  export interface CapacityReservationOptions {
    /**
     * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity. If you specify use-capacity-reservations-first, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (lowest-price or prioritized) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (lowest-price or prioritized). If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.
     */
    UsageStrategy?: FleetCapacityReservationUsageStrategy;
  }
  export interface CapacityReservationOptionsRequest {
    /**
     * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity. If you specify use-capacity-reservations-first, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (lowest-price or prioritized) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (lowest-price or prioritized). If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.
     */
    UsageStrategy?: FleetCapacityReservationUsageStrategy;
  }
  export type CapacityReservationPreference = "open"|"none"|string;
  export type CapacityReservationSet = CapacityReservation[];
  export interface CapacityReservationSpecification {
    /**
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:    open - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).    none - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.  
     */
    CapacityReservationPreference?: CapacityReservationPreference;
    /**
     * Information about the target Capacity Reservation or Capacity Reservation group.
     */
    CapacityReservationTarget?: CapacityReservationTarget;
  }
  export interface CapacityReservationSpecificationResponse {
    /**
     * Describes the instance's Capacity Reservation preferences. Possible preferences include:    open - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).    none - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.  
     */
    CapacityReservationPreference?: CapacityReservationPreference;
    /**
     * Information about the targeted Capacity Reservation or Capacity Reservation group.
     */
    CapacityReservationTarget?: CapacityReservationTargetResponse;
  }
  export type CapacityReservationState = "active"|"expired"|"cancelled"|"pending"|"failed"|string;
  export interface CapacityReservationTarget {
    /**
     * The ID of the Capacity Reservation in which to run the instance.
     */
    CapacityReservationId?: CapacityReservationId;
    /**
     * The ARN of the Capacity Reservation resource group in which to run the instance.
     */
    CapacityReservationResourceGroupArn?: String;
  }
  export interface CapacityReservationTargetResponse {
    /**
     * The ID of the targeted Capacity Reservation.
     */
    CapacityReservationId?: String;
    /**
     * The ARN of the targeted Capacity Reservation group.
     */
    CapacityReservationResourceGroupArn?: String;
  }
  export type CapacityReservationTenancy = "default"|"dedicated"|string;
  export interface CarrierGateway {
    /**
     * The ID of the carrier gateway.
     */
    CarrierGatewayId?: CarrierGatewayId;
    /**
     * The ID of the VPC associated with the carrier gateway.
     */
    VpcId?: VpcId;
    /**
     * The state of the carrier gateway.
     */
    State?: CarrierGatewayState;
    /**
     * The Amazon Web Services account ID of the owner of the carrier gateway.
     */
    OwnerId?: String;
    /**
     * The tags assigned to the carrier gateway.
     */
    Tags?: TagList;
  }
  export type CarrierGatewayId = string;
  export type CarrierGatewayIdSet = CarrierGatewayId[];
  export type CarrierGatewayMaxResults = number;
  export type CarrierGatewaySet = CarrierGateway[];
  export type CarrierGatewayState = "pending"|"available"|"deleting"|"deleted"|string;
  export interface CertificateAuthentication {
    /**
     * The ARN of the client certificate. 
     */
    ClientRootCertificateChain?: String;
  }
  export interface CertificateAuthenticationRequest {
    /**
     * The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in Certificate Manager (ACM).
     */
    ClientRootCertificateChainArn?: String;
  }
  export interface CidrAuthorizationContext {
    /**
     * The plain-text authorization message for the prefix and account.
     */
    Message: String;
    /**
     * The signed authorization message for the prefix and account.
     */
    Signature: String;
  }
  export interface CidrBlock {
    /**
     * The IPv4 CIDR block.
     */
    CidrBlock?: String;
  }
  export type CidrBlockSet = CidrBlock[];
  export interface ClassicLinkDnsSupport {
    /**
     * Indicates whether ClassicLink DNS support is enabled for the VPC.
     */
    ClassicLinkDnsSupported?: Boolean;
    /**
     * The ID of the VPC.
     */
    VpcId?: String;
  }
  export type ClassicLinkDnsSupportList = ClassicLinkDnsSupport[];
  export interface ClassicLinkInstance {
    /**
     * A list of security groups.
     */
    Groups?: GroupIdentifierList;
    /**
     * The ID of the instance.
     */
    InstanceId?: String;
    /**
     * Any tags assigned to the instance.
     */
    Tags?: TagList;
    /**
     * The ID of the VPC.
     */
    VpcId?: String;
  }
  export type ClassicLinkInstanceList = ClassicLinkInstance[];
  export interface ClassicLoadBalancer {
    /**
     * The name of the load balancer.
     */
    Name?: String;
  }
  export type ClassicLoadBalancers = ClassicLoadBalancer[];
  export interface ClassicLoadBalancersConfig {
    /**
     * One or more Classic Load Balancers.
     */
    ClassicLoadBalancers?: ClassicLoadBalancers;
  }
  export interface ClientCertificateRevocationListStatus {
    /**
     * The state of the client certificate revocation list.
     */
    Code?: ClientCertificateRevocationListStatusCode;
    /**
     * A message about the status of the client certificate revocation list, if applicable.
     */
    Message?: String;
  }
  export type ClientCertificateRevocationListStatusCode = "pending"|"active"|string;
  export interface ClientConnectOptions {
    /**
     * Indicates whether client connect options are enabled. The default is false (not enabled).
     */
    Enabled?: Boolean;
    /**
     * The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
     */
    LambdaFunctionArn?: String;
  }
  export interface ClientConnectResponseOptions {
    /**
     * Indicates whether client connect options are enabled.
     */
    Enabled?: Boolean;
    /**
     * The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
     */
    LambdaFunctionArn?: String;
    /**
     * The status of any updates to the client connect options.
     */
    Status?: ClientVpnEndpointAttributeStatus;
  }
  export interface ClientData {
    /**
     * A user-defined comment about the disk upload.
     */
    Comment?: String;
    /**
     * The time that the disk upload ends.
     */
    UploadEnd?: DateTime;
    /**
     * The size of the uploaded disk image, in GiB.
     */
    UploadSize?: Double;
    /**
     * The time that the disk upload starts.
     */
    UploadStart?: DateTime;
  }
  export interface ClientLoginBannerOptions {
    /**
     * Enable or disable a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established. Valid values: true | false  Default value: false 
     */
    Enabled?: Boolean;
    /**
     * Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
     */
    BannerText?: String;
  }
  export interface ClientLoginBannerResponseOptions {
    /**
     * Current state of text banner feature. Valid values: true | false 
     */
    Enabled?: Boolean;
    /**
     * Customizable text that will be displayed in a banner on Amazon Web Services provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
     */
    BannerText?: String;
  }
  export type ClientVpnAssociationId = string;
  export interface ClientVpnAuthentication {
    /**
     * The authentication type used.
     */
    Type?: ClientVpnAuthenticationType;
    /**
     * Information about the Active Directory, if applicable.
     */
    ActiveDirectory?: DirectoryServiceAuthentication;
    /**
     * Information about the authentication certificates, if applicable.
     */
    MutualAuthentication?: CertificateAuthentication;
    /**
     * Information about the IAM SAML identity provider, if applicable.
     */
    FederatedAuthentication?: FederatedAuthentication;
  }
  export type ClientVpnAuthenticationList = ClientVpnAuthentication[];
  export interface ClientVpnAuthenticationRequest {
    /**
     * The type of client authentication to be used.
     */
    Type?: ClientVpnAuthenticationType;
    /**
     * Information about the Active Directory to be used, if applicable. You must provide this information if Type is directory-service-authentication.
     */
    ActiveDirectory?: DirectoryServiceAuthenticationRequest;
    /**
     * Information about the authentication certificates to be used, if applicable. You must provide this information if Type is certificate-authentication.
     */
    MutualAuthentication?: CertificateAuthenticationRequest;
    /**
     * Information about the IAM SAML identity provider to be used, if applicable. You must provide this information if Type is federated-authentication.
     */
    FederatedAuthentication?: FederatedAuthenticationRequest;
  }
  export type ClientVpnAuthenticationRequestList = ClientVpnAuthenticationRequest[];
  export type ClientVpnAuthenticationType = "certificate-authentication"|"directory-service-authentication"|"federated-authentication"|string;
  export interface ClientVpnAuthorizationRuleStatus {
    /**
     * The state of the authorization rule.
     */
    Code?: ClientVpnAuthorizationRuleStatusCode;
    /**
     * A message about the status of the authorization rule, if applicable.
     */
    Message?: String;
  }
  export type ClientVpnAuthorizationRuleStatusCode = "authorizing"|"active"|"failed"|"revoking"|string;
  export interface ClientVpnConnection {
    /**
     * The ID of the Client VPN endpoint to which the client is connected.
     */
    ClientVpnEndpointId?: String;
    /**
     * The current date and time.
     */
    Timestamp?: String;
    /**
     * The ID of the client connection.
     */
    ConnectionId?: String;
    /**
     * The username of the client who established the client connection. This information is only provided if Active Directory client authentication is used.
     */
    Username?: String;
    /**
     * The date and time the client connection was established.
     */
    ConnectionEstablishedTime?: String;
    /**
     * The number of bytes sent by the client.
     */
    IngressBytes?: String;
    /**
     * The number of bytes received by the client.
     */
    EgressBytes?: String;
    /**
     * The number of packets sent by the client.
     */
    IngressPackets?: String;
    /**
     * The number of packets received by the client.
     */
    EgressPackets?: String;
    /**
     * The IP address of the client.
     */
    ClientIp?: String;
    /**
     * The common name associated with the client. This is either the name of the client certificate, or the Active Directory user name.
     */
    CommonName?: String;
    /**
     * The current state of the client connection.
     */
    Status?: ClientVpnConnectionStatus;
    /**
     * The date and time the client connection was terminated.
     */
    ConnectionEndTime?: String;
    /**
     * The statuses returned by the client connect handler for posture compliance, if applicable.
     */
    PostureComplianceStatuses?: ValueStringList;
  }
  export type ClientVpnConnectionSet = ClientVpnConnection[];
  export interface ClientVpnConnectionStatus {
    /**
     * The state of the client connection.
     */
    Code?: ClientVpnConnectionStatusCode;
    /**
     * A message about the status of the client connection, if applicable.
     */
    Message?: String;
  }
  export type ClientVpnConnectionStatusCode = "active"|"failed-to-terminate"|"terminating"|"terminated"|string;
  export interface ClientVpnEndpoint {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId?: String;
    /**
     * A brief description of the endpoint.
     */
    Description?: String;
    /**
     * The current state of the Client VPN endpoint.
     */
    Status?: ClientVpnEndpointStatus;
    /**
     * The date and time the Client VPN endpoint was created.
     */
    CreationTime?: String;
    /**
     * The date and time the Client VPN endpoint was deleted, if applicable.
     */
    DeletionTime?: String;
    /**
     * The DNS name to be used by clients when connecting to the Client VPN endpoint.
     */
    DnsName?: String;
    /**
     * The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
     */
    ClientCidrBlock?: String;
    /**
     * Information about the DNS servers to be used for DNS resolution. 
     */
    DnsServers?: ValueStringList;
    /**
     * Indicates whether split-tunnel is enabled in the Client VPN endpoint. For information about split-tunnel VPN endpoints, see Split-Tunnel Client VPN endpoint in the Client VPN Administrator Guide.
     */
    SplitTunnel?: Boolean;
    /**
     * The protocol used by the VPN session.
     */
    VpnProtocol?: VpnProtocol;
    /**
     * The transport protocol used by the Client VPN endpoint.
     */
    TransportProtocol?: TransportProtocol;
    /**
     * The port number for the Client VPN endpoint.
     */
    VpnPort?: Integer;
    /**
     * Information about the associated target networks. A target network is a subnet in a VPC.
     */
    AssociatedTargetNetworks?: AssociatedTargetNetworkSet;
    /**
     * The ARN of the server certificate.
     */
    ServerCertificateArn?: String;
    /**
     * Information about the authentication method used by the Client VPN endpoint.
     */
    AuthenticationOptions?: ClientVpnAuthenticationList;
    /**
     * Information about the client connection logging options for the Client VPN endpoint.
     */
    ConnectionLogOptions?: ConnectionLogResponseOptions;
    /**
     * Any tags assigned to the Client VPN endpoint.
     */
    Tags?: TagList;
    /**
     * The IDs of the security groups for the target network.
     */
    SecurityGroupIds?: ClientVpnSecurityGroupIdSet;
    /**
     * The ID of the VPC.
     */
    VpcId?: VpcId;
    /**
     * The URL of the self-service portal.
     */
    SelfServicePortalUrl?: String;
    /**
     * The options for managing connection authorization for new client connections.
     */
    ClientConnectOptions?: ClientConnectResponseOptions;
    /**
     * The maximum VPN session duration time in hours. Valid values: 8 | 10 | 12 | 24  Default value: 24 
     */
    SessionTimeoutHours?: Integer;
    /**
     * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.
     */
    ClientLoginBannerOptions?: ClientLoginBannerResponseOptions;
  }
  export interface ClientVpnEndpointAttributeStatus {
    /**
     * The status code.
     */
    Code?: ClientVpnEndpointAttributeStatusCode;
    /**
     * The status message.
     */
    Message?: String;
  }
  export type ClientVpnEndpointAttributeStatusCode = "applying"|"applied"|string;
  export type ClientVpnEndpointId = string;
  export type ClientVpnEndpointIdList = ClientVpnEndpointId[];
  export interface ClientVpnEndpointStatus {
    /**
     * The state of the Client VPN endpoint. Possible states include:    pending-associate - The Client VPN endpoint has been created but no target networks have been associated. The Client VPN endpoint cannot accept connections.    available - The Client VPN endpoint has been created and a target network has been associated. The Client VPN endpoint can accept connections.    deleting - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept connections.    deleted - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept connections.  
     */
    Code?: ClientVpnEndpointStatusCode;
    /**
     * A message about the status of the Client VPN endpoint.
     */
    Message?: String;
  }
  export type ClientVpnEndpointStatusCode = "pending-associate"|"available"|"deleting"|"deleted"|string;
  export interface ClientVpnRoute {
    /**
     * The ID of the Client VPN endpoint with which the route is associated.
     */
    ClientVpnEndpointId?: String;
    /**
     * The IPv4 address range, in CIDR notation, of the route destination.
     */
    DestinationCidr?: String;
    /**
     * The ID of the subnet through which traffic is routed.
     */
    TargetSubnet?: String;
    /**
     * The route type.
     */
    Type?: String;
    /**
     * Indicates how the route was associated with the Client VPN endpoint. associate indicates that the route was automatically added when the target network was associated with the Client VPN endpoint. add-route indicates that the route was manually added using the CreateClientVpnRoute action.
     */
    Origin?: String;
    /**
     * The current state of the route.
     */
    Status?: ClientVpnRouteStatus;
    /**
     * A brief description of the route.
     */
    Description?: String;
  }
  export type ClientVpnRouteSet = ClientVpnRoute[];
  export interface ClientVpnRouteStatus {
    /**
     * The state of the Client VPN endpoint route.
     */
    Code?: ClientVpnRouteStatusCode;
    /**
     * A message about the status of the Client VPN endpoint route, if applicable.
     */
    Message?: String;
  }
  export type ClientVpnRouteStatusCode = "creating"|"active"|"failed"|"deleting"|string;
  export type ClientVpnSecurityGroupIdSet = SecurityGroupId[];
  export type CloudWatchLogGroupArn = string;
  export interface CloudWatchLogOptions {
    /**
     * Status of VPN tunnel logging feature. Default value is False. Valid values: True | False 
     */
    LogEnabled?: Boolean;
    /**
     * The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
     */
    LogGroupArn?: String;
    /**
     * Configured log format. Default format is json. Valid values: json | text 
     */
    LogOutputFormat?: String;
  }
  export interface CloudWatchLogOptionsSpecification {
    /**
     * Enable or disable VPN tunnel logging feature. Default value is False. Valid values: True | False 
     */
    LogEnabled?: Boolean;
    /**
     * The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
     */
    LogGroupArn?: CloudWatchLogGroupArn;
    /**
     * Set log format. Default format is json. Valid values: json | text 
     */
    LogOutputFormat?: String;
  }
  export interface CoipAddressUsage {
    /**
     * The allocation ID of the address.
     */
    AllocationId?: String;
    /**
     * The Amazon Web Services account ID.
     */
    AwsAccountId?: String;
    /**
     * The Amazon Web Services service.
     */
    AwsService?: String;
    /**
     * The customer-owned IP address.
     */
    CoIp?: String;
  }
  export type CoipAddressUsageSet = CoipAddressUsage[];
  export interface CoipCidr {
    /**
     *  An address range in a customer-owned IP address space. 
     */
    Cidr?: String;
    /**
     *  The ID of the address pool. 
     */
    CoipPoolId?: Ipv4PoolCoipId;
    /**
     *  The ID of the local gateway route table. 
     */
    LocalGatewayRouteTableId?: String;
  }
  export interface CoipPool {
    /**
     * The ID of the address pool.
     */
    PoolId?: Ipv4PoolCoipId;
    /**
     * The address ranges of the address pool.
     */
    PoolCidrs?: ValueStringList;
    /**
     * The ID of the local gateway route table.
     */
    LocalGatewayRouteTableId?: LocalGatewayRoutetableId;
    /**
     * The tags.
     */
    Tags?: TagList;
    /**
     * The ARN of the address pool.
     */
    PoolArn?: ResourceArn;
  }
  export type CoipPoolId = string;
  export type CoipPoolIdSet = Ipv4PoolCoipId[];
  export type CoipPoolMaxResults = number;
  export type CoipPoolSet = CoipPool[];
  export type ComponentAccount = string;
  export type ComponentRegion = string;
  export interface ConfirmProductInstanceRequest {
    /**
     * The ID of the instance.
     */
    InstanceId: InstanceId;
    /**
     * The product code. This must be a product code that you own.
     */
    ProductCode: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface ConfirmProductInstanceResult {
    /**
     * The Amazon Web Services account ID of the instance owner. This is only present if the product code is attached to the instance.
     */
    OwnerId?: String;
    /**
     * The return value of the request. Returns true if the specified product code is owned by the requester and associated with the specified instance.
     */
    Return?: Boolean;
  }
  export interface ConnectionLogOptions {
    /**
     * Indicates whether connection logging is enabled.
     */
    Enabled?: Boolean;
    /**
     * The name of the CloudWatch Logs log group. Required if connection logging is enabled.
     */
    CloudwatchLogGroup?: String;
    /**
     * The name of the CloudWatch Logs log stream to which the connection data is published.
     */
    CloudwatchLogStream?: String;
  }
  export interface ConnectionLogResponseOptions {
    /**
     * Indicates whether client connection logging is enabled for the Client VPN endpoint.
     */
    Enabled?: Boolean;
    /**
     * The name of the Amazon CloudWatch Logs log group to which connection logging data is published.
     */
    CloudwatchLogGroup?: String;
    /**
     * The name of the Amazon CloudWatch Logs log stream to which connection logging data is published.
     */
    CloudwatchLogStream?: String;
  }
  export interface ConnectionNotification {
    /**
     * The ID of the notification.
     */
    ConnectionNotificationId?: String;
    /**
     * The ID of the endpoint service.
     */
    ServiceId?: String;
    /**
     * The ID of the VPC endpoint.
     */
    VpcEndpointId?: String;
    /**
     * The type of notification.
     */
    ConnectionNotificationType?: ConnectionNotificationType;
    /**
     * The ARN of the SNS topic for the notification.
     */
    ConnectionNotificationArn?: String;
    /**
     * The events for the notification. Valid values are Accept, Connect, Delete, and Reject.
     */
    ConnectionEvents?: ValueStringList;
    /**
     * The state of the notification.
     */
    ConnectionNotificationState?: ConnectionNotificationState;
  }
  export type ConnectionNotificationId = string;
  export type ConnectionNotificationIdsList = ConnectionNotificationId[];
  export type ConnectionNotificationSet = ConnectionNotification[];
  export type ConnectionNotificationState = "Enabled"|"Disabled"|string;
  export type ConnectionNotificationType = "Topic"|string;
  export type ConnectivityType = "private"|"public"|string;
  export type ContainerFormat = "ova"|string;
  export type ConversionIdStringList = ConversionTaskId[];
  export interface ConversionTask {
    /**
     * The ID of the conversion task.
     */
    ConversionTaskId?: String;
    /**
     * The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel the task.
     */
    ExpirationTime?: String;
    /**
     * If the task is for importing an instance, this contains information about the import instance task.
     */
    ImportInstance?: ImportInstanceTaskDetails;
    /**
     * If the task is for importing a volume, this contains information about the import volume task.
     */
    ImportVolume?: ImportVolumeTaskDetails;
    /**
     * The state of the conversion task.
     */
    State?: ConversionTaskState;
    /**
     * The status message related to the conversion task.
     */
    StatusMessage?: String;
    /**
     * Any tags assigned to the task.
     */
    Tags?: TagList;
  }
  export type ConversionTaskId = string;
  export type ConversionTaskState = "active"|"cancelling"|"cancelled"|"completed"|string;
  export interface CopyFpgaImageRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the source AFI.
     */
    SourceFpgaImageId: String;
    /**
     * The description for the new AFI.
     */
    Description?: String;
    /**
     * The name for the new AFI. The default is the name of the source AFI.
     */
    Name?: String;
    /**
     * The Region that contains the source AFI.
     */
    SourceRegion: String;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring idempotency.
     */
    ClientToken?: String;
  }
  export interface CopyFpgaImageResult {
    /**
     * The ID of the new AFI.
     */
    FpgaImageId?: String;
  }
  export interface CopyImageRequest {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
     */
    ClientToken?: String;
    /**
     * A description for the new AMI in the destination Region.
     */
    Description?: String;
    /**
     * Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using KmsKeyId. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     */
    Encrypted?: Boolean;
    /**
     * The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to true. You can specify a KMS key using any of the following:   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example, alias/ExampleAlias.   Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails. The specified KMS key must exist in the destination Region. Amazon EBS does not support asymmetric KMS keys.
     */
    KmsKeyId?: KmsKeyId;
    /**
     * The name of the new AMI in the destination Region.
     */
    Name: String;
    /**
     * The ID of the AMI to copy.
     */
    SourceImageId: String;
    /**
     * The name of the Region that contains the AMI to copy.
     */
    SourceRegion: String;
    /**
     * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. For more information, see  Copy AMIs from an Amazon Web Services Region to an Outpost in the Amazon Elastic Compute Cloud User Guide.
     */
    DestinationOutpostArn?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Indicates whether to include your user-defined AMI tags when copying the AMI. The following tags will not be copied:   System tags (prefixed with aws:)   For public and shared AMIs, user-defined tags that are attached by other Amazon Web Services accounts   Default: Your user-defined AMI tags are not copied.
     */
    CopyImageTags?: Boolean;
  }
  export interface CopyImageResult {
    /**
     * The ID of the new AMI.
     */
    ImageId?: String;
  }
  export interface CopySnapshotRequest {
    /**
     * A description for the EBS snapshot.
     */
    Description?: String;
    /**
     * The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot. Only specify this parameter when copying a snapshot from an Amazon Web Services Region to an Outpost. The snapshot must be in the Region for the destination Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost. For more information, see  Copy snapshots from an Amazon Web Services Region to an Outpost in the Amazon Elastic Compute Cloud User Guide.
     */
    DestinationOutpostArn?: String;
    /**
     * The destination Region to use in the PresignedUrl parameter of a snapshot copy operation. This parameter is only valid for specifying the destination Region in a PresignedUrl parameter, where it is required. The snapshot copy is sent to the regional endpoint that you sent the HTTP request to (for example, ec2.us-east-1.amazonaws.com). With the CLI, this is specified using the --region parameter or the default Region in your Amazon Web Services configuration file.
     */
    DestinationRegion?: String;
    /**
     * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     */
    Encrypted?: Boolean;
    /**
     * The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If KmsKeyId is specified, the encrypted state must be true. You can specify the KMS key using any of the following:   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example, alias/ExampleAlias.   Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.
     */
    KmsKeyId?: KmsKeyId;
    /**
     * When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see Query requests. The PresignedUrl should use the snapshot source endpoint, the CopySnapshot action, and include the SourceRegion, SourceSnapshotId, and DestinationRegion parameters. The PresignedUrl must be signed using Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) in the Amazon Simple Storage Service API Reference. An invalid or improperly signed PresignedUrl will cause the copy operation to fail asynchronously, and the snapshot will move to an error state.
     */
    PresignedUrl?: String;
    /**
     * The ID of the Region that contains the snapshot to be copied.
     */
    SourceRegion: String;
    /**
     * The ID of the EBS snapshot to copy.
     */
    SourceSnapshotId: String;
    /**
     * The tags to apply to the new snapshot.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CopySnapshotResult {
    /**
     * The ID of the new snapshot.
     */
    SnapshotId?: String;
    /**
     * Any tags applied to the new snapshot.
     */
    Tags?: TagList;
  }
  export type CopyTagsFromSource = "volume"|string;
  export type CoreCount = number;
  export type CoreCountList = CoreCount[];
  export type CoreNetworkArn = string;
  export type CpuManufacturer = "intel"|"amd"|"amazon-web-services"|string;
  export type CpuManufacturerSet = CpuManufacturer[];
  export interface CpuOptions {
    /**
     * The number of CPU cores for the instance.
     */
    CoreCount?: Integer;
    /**
     * The number of threads per CPU core.
     */
    ThreadsPerCore?: Integer;
  }
  export interface CpuOptionsRequest {
    /**
     * The number of CPU cores for the instance.
     */
    CoreCount?: Integer;
    /**
     * The number of threads per CPU core. To disable multithreading for the instance, specify a value of 1. Otherwise, specify the default value of 2.
     */
    ThreadsPerCore?: Integer;
  }
  export interface CreateCapacityReservationFleetRequest {
    /**
     * The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the prioritized allocation strategy is supported. For more information, see  Allocation strategy in the Amazon EC2 User Guide. Valid values: prioritized 
     */
    AllocationStrategy?: String;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensure Idempotency.
     */
    ClientToken?: String;
    /**
     * Information about the instance types for which to reserve the capacity.
     */
    InstanceTypeSpecifications: ReservationFleetInstanceSpecificationList;
    /**
     * Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:    default - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.    dedicated - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.  
     */
    Tenancy?: FleetCapacityReservationTenancy;
    /**
     * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see  Total target capacity in the Amazon EC2 User Guide.
     */
    TotalTargetCapacity: Integer;
    /**
     * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to expired and all of the Capacity Reservations in the Fleet expire. The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation Fleet is guaranteed to expire between 13:30:55 and 14:30:55 on 5/31/2019. 
     */
    EndDate?: MillisecondDateTime;
    /**
     * Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria. Currently, Capacity Reservation Fleets support open instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
     */
    InstanceMatchCriteria?: FleetInstanceMatchCriteria;
    /**
     * The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateCapacityReservationFleetResult {
    /**
     * The ID of the Capacity Reservation Fleet.
     */
    CapacityReservationFleetId?: CapacityReservationFleetId;
    /**
     * The status of the Capacity Reservation Fleet.
     */
    State?: CapacityReservationFleetState;
    /**
     * The total number of capacity units for which the Capacity Reservation Fleet reserves capacity.
     */
    TotalTargetCapacity?: Integer;
    /**
     * The requested capacity units that have been successfully reserved.
     */
    TotalFulfilledCapacity?: Double;
    /**
     * The instance matching criteria for the Capacity Reservation Fleet.
     */
    InstanceMatchCriteria?: FleetInstanceMatchCriteria;
    /**
     * The allocation strategy used by the Capacity Reservation Fleet.
     */
    AllocationStrategy?: String;
    /**
     * The date and time at which the Capacity Reservation Fleet was created.
     */
    CreateTime?: MillisecondDateTime;
    /**
     * The date and time at which the Capacity Reservation Fleet expires.
     */
    EndDate?: MillisecondDateTime;
    /**
     * Indicates the tenancy of Capacity Reservation Fleet.
     */
    Tenancy?: FleetCapacityReservationTenancy;
    /**
     * Information about the individual Capacity Reservations in the Capacity Reservation Fleet.
     */
    FleetCapacityReservations?: FleetCapacityReservationSet;
    /**
     * The tags assigned to the Capacity Reservation Fleet.
     */
    Tags?: TagList;
  }
  export interface CreateCapacityReservationRequest {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensure Idempotency.
     */
    ClientToken?: String;
    /**
     * The instance type for which to reserve capacity. For more information, see Instance types in the Amazon EC2 User Guide.
     */
    InstanceType: String;
    /**
     * The type of operating system for which to reserve capacity.
     */
    InstancePlatform: CapacityReservationInstancePlatform;
    /**
     * The Availability Zone in which to create the Capacity Reservation.
     */
    AvailabilityZone?: String;
    /**
     * The ID of the Availability Zone in which to create the Capacity Reservation.
     */
    AvailabilityZoneId?: String;
    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:    default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.    dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.  
     */
    Tenancy?: CapacityReservationTenancy;
    /**
     * The number of instances for which to reserve capacity. Valid range: 1 - 1000
     */
    InstanceCount: Integer;
    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
     */
    EbsOptimized?: Boolean;
    /**
     *  Deprecated. 
     */
    EphemeralStorage?: Boolean;
    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time. You must provide an EndDate value if EndDateType is limited. Omit EndDate if EndDateType is unlimited. If the EndDateType is limited, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     */
    EndDate?: DateTime;
    /**
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:    unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an EndDate if the EndDateType is unlimited.    limited - The Capacity Reservation expires automatically at a specified date and time. You must provide an EndDate value if the EndDateType value is limited.  
     */
    EndDateType?: EndDateType;
    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:    open - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.    targeted - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.    Default: open 
     */
    InstanceMatchCriteria?: InstanceMatchCriteria;
    /**
     * The tags to apply to the Capacity Reservation during launch.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    OutpostArn?: OutpostArn;
    /**
     * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. For more information, see  Capacity Reservations for cluster placement groups in the Amazon EC2 User Guide.
     */
    PlacementGroupArn?: PlacementGroupArn;
  }
  export interface CreateCapacityReservationResult {
    /**
     * Information about the Capacity Reservation.
     */
    CapacityReservation?: CapacityReservation;
  }
  export interface CreateCarrierGatewayRequest {
    /**
     * The ID of the VPC to associate with the carrier gateway.
     */
    VpcId: VpcId;
    /**
     * The tags to associate with the carrier gateway.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateCarrierGatewayResult {
    /**
     * Information about the carrier gateway.
     */
    CarrierGateway?: CarrierGateway;
  }
  export interface CreateClientVpnEndpointRequest {
    /**
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    ClientCidrBlock: String;
    /**
     * The ARN of the server certificate. For more information, see the Certificate Manager User Guide.
     */
    ServerCertificateArn: String;
    /**
     * Information about the authentication method to be used to authenticate clients.
     */
    AuthenticationOptions: ClientVpnAuthenticationRequestList;
    /**
     * Information about the client connection logging options. If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:   Client connection requests   Client connection results (successful and unsuccessful)   Reasons for unsuccessful client connection requests   Client connection termination time  
     */
    ConnectionLogOptions: ConnectionLogOptions;
    /**
     * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
     */
    DnsServers?: ValueStringList;
    /**
     * The transport protocol to be used by the VPN session. Default value: udp 
     */
    TransportProtocol?: TransportProtocol;
    /**
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic. Valid Values: 443 | 1194  Default Value: 443 
     */
    VpnPort?: Integer;
    /**
     * A brief description of the Client VPN endpoint.
     */
    Description?: String;
    /**
     * Indicates whether split-tunnel is enabled on the Client VPN endpoint. By default, split-tunnel on a VPN endpoint is disabled. For information about split-tunnel VPN endpoints, see Split-tunnel Client VPN endpoint in the Client VPN Administrator Guide.
     */
    SplitTunnel?: Boolean;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * The tags to apply to the Client VPN endpoint during creation.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    SecurityGroupIds?: ClientVpnSecurityGroupIdSet;
    /**
     * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    VpcId?: VpcId;
    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint. Default Value: enabled 
     */
    SelfServicePortal?: SelfServicePortal;
    /**
     * The options for managing connection authorization for new client connections.
     */
    ClientConnectOptions?: ClientConnectOptions;
    /**
     * The maximum VPN session duration time in hours. Valid values: 8 | 10 | 12 | 24  Default value: 24 
     */
    SessionTimeoutHours?: Integer;
    /**
     * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.
     */
    ClientLoginBannerOptions?: ClientLoginBannerOptions;
  }
  export interface CreateClientVpnEndpointResult {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId?: String;
    /**
     * The current state of the Client VPN endpoint.
     */
    Status?: ClientVpnEndpointStatus;
    /**
     * The DNS name to be used by clients when establishing their VPN session.
     */
    DnsName?: String;
  }
  export interface CreateClientVpnRouteRequest {
    /**
     * The ID of the Client VPN endpoint to which to add the route.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * The IPv4 address range, in CIDR notation, of the route destination. For example:   To add a route for Internet access, enter 0.0.0.0/0    To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range   To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range   To add a route for the local network, enter the client CIDR range  
     */
    DestinationCidrBlock: String;
    /**
     * The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint. Alternatively, if you're adding a route for the local network, specify local.
     */
    TargetVpcSubnetId: SubnetId;
    /**
     * A brief description of the route.
     */
    Description?: String;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateClientVpnRouteResult {
    /**
     * The current state of the route.
     */
    Status?: ClientVpnRouteStatus;
  }
  export interface CreateCoipCidrRequest {
    /**
     *  A customer-owned IP address range to create. 
     */
    Cidr: String;
    /**
     *  The ID of the address pool. 
     */
    CoipPoolId: Ipv4PoolCoipId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateCoipCidrResult {
    /**
     *  Information about a range of customer-owned IP addresses. 
     */
    CoipCidr?: CoipCidr;
  }
  export interface CreateCoipPoolRequest {
    /**
     *  The ID of the local gateway route table. 
     */
    LocalGatewayRouteTableId: LocalGatewayRoutetableId;
    /**
     *  The tags to assign to the CoIP address pool. 
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateCoipPoolResult {
    CoipPool?: CoipPool;
  }
  export interface CreateCustomerGatewayRequest {
    /**
     * For devices that support BGP, the customer gateway's BGP ASN. Default: 65000
     */
    BgpAsn: Integer;
    /**
     *  This member has been deprecated. The Internet-routable IP address for the customer gateway's outside interface. The address must be static.
     */
    PublicIp?: String;
    /**
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    CertificateArn?: String;
    /**
     * The type of VPN connection that this customer gateway supports (ipsec.1).
     */
    Type: GatewayType;
    /**
     * The tags to apply to the customer gateway.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * A name for the customer gateway device. Length Constraints: Up to 255 characters.
     */
    DeviceName?: String;
    /**
     *  IPv4 address for the customer gateway device's outside interface. The address must be static. 
     */
    IpAddress?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateCustomerGatewayResult {
    /**
     * Information about the customer gateway.
     */
    CustomerGateway?: CustomerGateway;
  }
  export interface CreateDefaultSubnetRequest {
    /**
     * The Availability Zone in which to create the default subnet.
     */
    AvailabilityZone: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Indicates whether to create an IPv6 only subnet. If you already have a default subnet for this Availability Zone, you must delete it before you can create an IPv6 only subnet.
     */
    Ipv6Native?: Boolean;
  }
  export interface CreateDefaultSubnetResult {
    /**
     * Information about the subnet.
     */
    Subnet?: Subnet;
  }
  export interface CreateDefaultVpcRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateDefaultVpcResult {
    /**
     * Information about the VPC.
     */
    Vpc?: Vpc;
  }
  export interface CreateDhcpOptionsRequest {
    /**
     * A DHCP configuration option.
     */
    DhcpConfigurations: NewDhcpConfigurationList;
    /**
     * The tags to assign to the DHCP option.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateDhcpOptionsResult {
    /**
     * A set of DHCP options.
     */
    DhcpOptions?: DhcpOptions;
  }
  export interface CreateEgressOnlyInternetGatewayRequest {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the VPC for which to create the egress-only internet gateway.
     */
    VpcId: VpcId;
    /**
     * The tags to assign to the egress-only internet gateway.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateEgressOnlyInternetGatewayResult {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    ClientToken?: String;
    /**
     * Information about the egress-only internet gateway.
     */
    EgressOnlyInternetGateway?: EgressOnlyInternetGateway;
  }
  export interface CreateFleetError {
    /**
     * The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.
     */
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    /**
     * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
     */
    Lifecycle?: InstanceLifecycle;
    /**
     * The error code that indicates why the instance could not be launched. For more information about error codes, see Error codes.
     */
    ErrorCode?: String;
    /**
     * The error message that describes why the instance could not be launched. For more information about error messages, see Error codes.
     */
    ErrorMessage?: String;
  }
  export type CreateFleetErrorsSet = CreateFleetError[];
  export interface CreateFleetInstance {
    /**
     * The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.
     */
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    /**
     * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     */
    Lifecycle?: InstanceLifecycle;
    /**
     * The IDs of the instances.
     */
    InstanceIds?: InstanceIdsSet;
    /**
     * The instance type.
     */
    InstanceType?: InstanceType;
    /**
     * The value is Windows for Windows instances. Otherwise, the value is blank.
     */
    Platform?: PlatformValues;
  }
  export type CreateFleetInstancesSet = CreateFleetInstance[];
  export interface CreateFleetRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring idempotency.
     */
    ClientToken?: String;
    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    SpotOptions?: SpotOptionsRequest;
    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    OnDemandOptions?: OnDemandOptionsRequest;
    /**
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy;
    /**
     * The configuration for the EC2 Fleet.
     */
    LaunchTemplateConfigs: FleetLaunchTemplateConfigListRequest;
    /**
     * The number of units to request.
     */
    TargetCapacitySpecification: TargetCapacitySpecificationRequest;
    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    TerminateInstancesWithExpiration?: Boolean;
    /**
     * The fleet type. The default value is maintain.    maintain - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.    request - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.    instant - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.   For more information, see EC2 Fleet request types in the Amazon EC2 User Guide.
     */
    Type?: FleetType;
    /**
     * The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    ValidFrom?: DateTime;
    /**
     * The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    ValidUntil?: DateTime;
    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type maintain. For more information, see EC2 Fleet health checks in the Amazon EC2 User Guide.
     */
    ReplaceUnhealthyInstances?: Boolean;
    /**
     * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see Tagging your resources. If the fleet type is instant, specify a resource type of fleet to tag the fleet or instance to tag the instances at launch. If the fleet type is maintain or request, specify a resource type of fleet to tag the fleet. You cannot specify a resource type of instance. To tag instances at launch, specify the tags in a launch template.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Reserved.
     */
    Context?: String;
  }
  export interface CreateFleetResult {
    /**
     * The ID of the EC2 Fleet.
     */
    FleetId?: FleetId;
    /**
     * Information about the instances that could not be launched by the fleet. Supported only for fleets of type instant.
     */
    Errors?: CreateFleetErrorsSet;
    /**
     * Information about the instances that were launched by the fleet. Supported only for fleets of type instant.
     */
    Instances?: CreateFleetInstancesSet;
  }
  export interface CreateFlowLogsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * The ARN of the IAM role that allows Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account. This parameter is required if the destination type is cloud-watch-logs and unsupported otherwise.
     */
    DeliverLogsPermissionArn?: String;
    /**
     * The ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
     */
    DeliverCrossAccountRole?: String;
    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs. This parameter is valid only if the destination type is cloud-watch-logs.
     */
    LogGroupName?: String;
    /**
     * The IDs of the resources to monitor. For example, if the resource type is VPC, specify the IDs of the VPCs. Constraints: Maximum of 25 for transit gateway resource types. Maximum of 1000 for the other resource types.
     */
    ResourceIds: FlowLogResourceIds;
    /**
     * The type of resource to monitor.
     */
    ResourceType: FlowLogsResourceType;
    /**
     * The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic). This parameter is not supported for transit gateway resource types. It is required for the other resource types.
     */
    TrafficType?: TrafficType;
    /**
     * The type of destination for the flow log data. Default: cloud-watch-logs 
     */
    LogDestinationType?: LogDestinationType;
    /**
     * The destination for the flow log data. The meaning of this parameter depends on the destination type.   If the destination type is cloud-watch-logs, specify the ARN of a CloudWatch Logs log group. For example: arn:aws:logs:region:account_id:log-group:my_group  Alternatively, use the LogGroupName parameter.   If the destination type is s3, specify the ARN of an S3 bucket. For example: arn:aws:s3:::my_bucket/my_subfolder/ The subfolder is optional. Note that you can't use AWSLogs as a subfolder name.   If the destination type is kinesis-data-firehose, specify the ARN of a Kinesis Data Firehose delivery stream. For example: arn:aws:firehose:region:account_id:deliverystream:my_stream   
     */
    LogDestination?: String;
    /**
     * The fields to include in the flow log record. List the fields in the order in which they should appear. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must include at least one field. For more information about the available fields, see Flow log records in the Amazon VPC User Guide or Transit Gateway Flow Log records in the Amazon Web Services Transit Gateway Guide. Specify the fields using the ${field-id} format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.
     */
    LogFormat?: String;
    /**
     * The tags to apply to the flow logs.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. The possible values are 60 seconds (1 minute) or 600 seconds (10 minutes). This parameter must be 60 seconds for transit gateway resource types. When a network interface is attached to a Nitro-based instance, the aggregation interval is always 60 seconds or less, regardless of the value that you specify. Default: 600
     */
    MaxAggregationInterval?: Integer;
    /**
     * The destination options.
     */
    DestinationOptions?: DestinationOptionsRequest;
  }
  export interface CreateFlowLogsResult {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    ClientToken?: String;
    /**
     * The IDs of the flow logs.
     */
    FlowLogIds?: ValueStringList;
    /**
     * Information about the flow logs that could not be created successfully.
     */
    Unsuccessful?: UnsuccessfulItemSet;
  }
  export interface CreateFpgaImageRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
     */
    InputStorageLocation: StorageLocation;
    /**
     * The location in Amazon S3 for the output logs.
     */
    LogsStorageLocation?: StorageLocation;
    /**
     * A description for the AFI.
     */
    Description?: String;
    /**
     * A name for the AFI.
     */
    Name?: String;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency.
     */
    ClientToken?: String;
    /**
     * The tags to apply to the FPGA image during creation.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateFpgaImageResult {
    /**
     * The FPGA image identifier (AFI ID).
     */
    FpgaImageId?: String;
    /**
     * The global FPGA image identifier (AGFI ID).
     */
    FpgaImageGlobalId?: String;
  }
  export interface CreateImageRequest {
    /**
     * The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the CopyImage action.
     */
    BlockDeviceMappings?: BlockDeviceMappingRequestList;
    /**
     * A description for the new image.
     */
    Description?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the instance.
     */
    InstanceId: InstanceId;
    /**
     * A name for the new image. Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    Name: String;
    /**
     * By default, when Amazon EC2 creates the new AMI, it reboots the instance so that it can take snapshots of the attached volumes while data is at rest, in order to ensure a consistent state. You can set the NoReboot parameter to true in the API request, or use the --no-reboot option in the CLI to prevent Amazon EC2 from shutting down and rebooting the instance.  If you choose to bypass the shutdown and reboot process by setting the NoReboot parameter to true in the API request, or by using the --no-reboot option in the CLI, we can't guarantee the file system integrity of the created image.  Default: false (follow standard reboot process)
     */
    NoReboot?: Boolean;
    /**
     * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.   To tag the AMI, the value for ResourceType must be image.   To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to the instance, the value for ResourceType must be snapshot. The same tag is applied to all of the snapshots that are created.   If you specify other values for ResourceType, the request fails. To tag an AMI or snapshot after it has been created, see CreateTags. 
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateImageResult {
    /**
     * The ID of the new AMI.
     */
    ImageId?: String;
  }
  export interface CreateInstanceEventWindowRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The name of the event window.
     */
    Name?: String;
    /**
     * The time range for the event window. If you specify a time range, you can't specify a cron expression.
     */
    TimeRanges?: InstanceEventWindowTimeRangeRequestSet;
    /**
     * The cron expression for the event window, for example, * 0-4,20-23 * * 1,5. If you specify a cron expression, you can't specify a time range. Constraints:   Only hour and day of the week values are supported.   For day of the week values, you can specify either integers 0 through 6, or alternative single values SUN through SAT.   The minute, month, and year must be specified by *.   The hour value must be one or a multiple range, for example, 0-4 or 0-4,20-23.   Each hour range must be &gt;= 2 hours, for example, 0-2 or 20-23.   The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4 hours.   For more information about cron expressions, see cron on the Wikipedia website.
     */
    CronExpression?: InstanceEventWindowCronExpression;
    /**
     * The tags to apply to the event window.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateInstanceEventWindowResult {
    /**
     * Information about the event window.
     */
    InstanceEventWindow?: InstanceEventWindow;
  }
  export interface CreateInstanceExportTaskRequest {
    /**
     * A description for the conversion task or the resource being exported. The maximum length is 255 characters.
     */
    Description?: String;
    /**
     * The format and location for an export instance task.
     */
    ExportToS3Task: ExportToS3TaskSpecification;
    /**
     * The ID of the instance.
     */
    InstanceId: InstanceId;
    /**
     * The target virtualization environment.
     */
    TargetEnvironment: ExportEnvironment;
    /**
     * The tags to apply to the export instance task during creation.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateInstanceExportTaskResult {
    /**
     * Information about the export instance task.
     */
    ExportTask?: ExportTask;
  }
  export interface CreateInternetGatewayRequest {
    /**
     * The tags to assign to the internet gateway.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateInternetGatewayResult {
    /**
     * Information about the internet gateway.
     */
    InternetGateway?: InternetGateway;
  }
  export interface CreateIpamPoolRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the scope in which you would like to create the IPAM pool.
     */
    IpamScopeId: IpamScopeId;
    /**
     * In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool. Possible values: Any Amazon Web Services Region, such as us-east-1.
     */
    Locale?: String;
    /**
     * The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.
     */
    SourceIpamPoolId?: IpamPoolId;
    /**
     * A description for the IPAM pool.
     */
    Description?: String;
    /**
     * The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.
     */
    AddressFamily: AddressFamily;
    /**
     * If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.  A locale must be set on the pool for this feature to work.
     */
    AutoImport?: Boolean;
    /**
     * Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to ipv4.
     */
    PubliclyAdvertisable?: Boolean;
    /**
     * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    AllocationMinNetmaskLength?: IpamNetmaskLength;
    /**
     * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    AllocationMaxNetmaskLength?: IpamNetmaskLength;
    /**
     * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
     */
    AllocationDefaultNetmaskLength?: IpamNetmaskLength;
    /**
     * Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     */
    AllocationResourceTags?: RequestIpamResourceTagList;
    /**
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency.
     */
    ClientToken?: String;
    /**
     * Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.
     */
    AwsService?: IpamPoolAwsService;
  }
  export interface CreateIpamPoolResult {
    /**
     * Information about the IPAM pool created.
     */
    IpamPool?: IpamPool;
  }
  export interface CreateIpamRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * A description for the IPAM.
     */
    Description?: String;
    /**
     * The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions. For more information about operating Regions, see Create an IPAM in the Amazon VPC IPAM User Guide. 
     */
    OperatingRegions?: AddIpamOperatingRegionSet;
    /**
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateIpamResult {
    /**
     * Information about the IPAM created.
     */
    Ipam?: Ipam;
  }
  export interface CreateIpamScopeRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the IPAM for which you're creating this scope.
     */
    IpamId: IpamId;
    /**
     * A description for the scope you're creating.
     */
    Description?: String;
    /**
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateIpamScopeResult {
    /**
     * Information about the created scope.
     */
    IpamScope?: IpamScope;
  }
  export interface CreateKeyPairRequest {
    /**
     * A unique name for the key pair. Constraints: Up to 255 ASCII characters
     */
    KeyName: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The type of key pair. Note that ED25519 keys are not supported for Windows instances. Default: rsa 
     */
    KeyType?: KeyType;
    /**
     * The tags to apply to the new key pair.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * The format of the key pair. Default: pem 
     */
    KeyFormat?: KeyFormat;
  }
  export interface CreateLaunchTemplateRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see Ensuring idempotency. Constraint: Maximum 128 ASCII characters.
     */
    ClientToken?: String;
    /**
     * A name for the launch template.
     */
    LaunchTemplateName: LaunchTemplateName;
    /**
     * A description for the first version of the launch template.
     */
    VersionDescription?: VersionDescription;
    /**
     * The information for the launch template.
     */
    LaunchTemplateData: RequestLaunchTemplateData;
    /**
     * The tags to apply to the launch template on creation. To tag the launch template, the resource type must be launch-template.  To specify the tags for the resources that are created when an instance is launched, you must use the TagSpecifications parameter in the launch template data structure. 
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateLaunchTemplateResult {
    /**
     * Information about the launch template.
     */
    LaunchTemplate?: LaunchTemplate;
    /**
     * If the launch template contains parameters or parameter combinations that are not valid, an error code and an error message are returned for each issue that's found.
     */
    Warning?: ValidationWarning;
  }
  export interface CreateLaunchTemplateVersionRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see Ensuring idempotency. Constraint: Maximum 128 ASCII characters.
     */
    ClientToken?: String;
    /**
     * The ID of the launch template. You must specify either the LaunchTemplateId or the LaunchTemplateName, but not both.
     */
    LaunchTemplateId?: LaunchTemplateId;
    /**
     * The name of the launch template. You must specify the LaunchTemplateName or the LaunchTemplateId, but not both.
     */
    LaunchTemplateName?: LaunchTemplateName;
    /**
     * The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in LaunchTemplateData. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included.
     */
    SourceVersion?: String;
    /**
     * A description for the version of the launch template.
     */
    VersionDescription?: VersionDescription;
    /**
     * The information for the launch template.
     */
    LaunchTemplateData: RequestLaunchTemplateData;
  }
  export interface CreateLaunchTemplateVersionResult {
    /**
     * Information about the launch template version.
     */
    LaunchTemplateVersion?: LaunchTemplateVersion;
    /**
     * If the new version of the launch template contains parameters or parameter combinations that are not valid, an error code and an error message are returned for each issue that's found.
     */
    Warning?: ValidationWarning;
  }
  export interface CreateLocalGatewayRouteRequest {
    /**
     * The CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    DestinationCidrBlock: String;
    /**
     * The ID of the local gateway route table.
     */
    LocalGatewayRouteTableId: LocalGatewayRoutetableId;
    /**
     * The ID of the virtual interface group.
     */
    LocalGatewayVirtualInterfaceGroupId?: LocalGatewayVirtualInterfaceGroupId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId?: NetworkInterfaceId;
  }
  export interface CreateLocalGatewayRouteResult {
    /**
     * Information about the route.
     */
    Route?: LocalGatewayRoute;
  }
  export interface CreateLocalGatewayRouteTableRequest {
    /**
     *  The ID of the local gateway. 
     */
    LocalGatewayId: LocalGatewayId;
    /**
     *  The mode of the local gateway route table. 
     */
    Mode?: LocalGatewayRouteTableMode;
    /**
     *  The tags assigned to the local gateway route table. 
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateLocalGatewayRouteTableResult {
    LocalGatewayRouteTable?: LocalGatewayRouteTable;
  }
  export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
    /**
     *  The ID of the local gateway route table. 
     */
    LocalGatewayRouteTableId: LocalGatewayRoutetableId;
    /**
     *  The ID of the local gateway route table virtual interface group association. 
     */
    LocalGatewayVirtualInterfaceGroupId: LocalGatewayVirtualInterfaceGroupId;
    /**
     *  The tags assigned to the local gateway route table virtual interface group association. 
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
    LocalGatewayRouteTableVirtualInterfaceGroupAssociation?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation;
  }
  export interface CreateLocalGatewayRouteTableVpcAssociationRequest {
    /**
     * The ID of the local gateway route table.
     */
    LocalGatewayRouteTableId: LocalGatewayRoutetableId;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * The tags to assign to the local gateway route table VPC association.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateLocalGatewayRouteTableVpcAssociationResult {
    /**
     * Information about the association.
     */
    LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
  }
  export interface CreateManagedPrefixListRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * A name for the prefix list. Constraints: Up to 255 characters in length. The name cannot start with com.amazonaws.
     */
    PrefixListName: String;
    /**
     * One or more entries for the prefix list.
     */
    Entries?: AddPrefixListEntries;
    /**
     * The maximum number of entries for the prefix list.
     */
    MaxEntries: Integer;
    /**
     * The tags to apply to the prefix list during creation.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * The IP address type. Valid Values: IPv4 | IPv6 
     */
    AddressFamily: String;
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Constraints: Up to 255 UTF-8 characters in length.
     */
    ClientToken?: String;
  }
  export interface CreateManagedPrefixListResult {
    /**
     * Information about the prefix list.
     */
    PrefixList?: ManagedPrefixList;
  }
  export interface CreateNatGatewayRequest {
    /**
     * [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.
     */
    AllocationId?: AllocationId;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency. Constraint: Maximum 64 ASCII characters.
     */
    ClientToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The subnet in which to create the NAT gateway.
     */
    SubnetId: SubnetId;
    /**
     * The tags to assign to the NAT gateway.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     */
    ConnectivityType?: ConnectivityType;
    /**
     * The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
     */
    PrivateIpAddress?: String;
  }
  export interface CreateNatGatewayResult {
    /**
     * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.
     */
    ClientToken?: String;
    /**
     * Information about the NAT gateway.
     */
    NatGateway?: NatGateway;
  }
  export interface CreateNetworkAclEntryRequest {
    /**
     * The IPv4 network range to allow or deny, in CIDR notation (for example 172.16.0.0/24). We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
     */
    CidrBlock?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
     */
    Egress: Boolean;
    /**
     * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
     */
    IcmpTypeCode?: IcmpTypeCode;
    /**
     * The IPv6 network range to allow or deny, in CIDR notation (for example 2001:db8:1234:1a00::/64).
     */
    Ipv6CidrBlock?: String;
    /**
     * The ID of the network ACL.
     */
    NetworkAclId: NetworkAclId;
    /**
     * TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).
     */
    PortRange?: PortRange;
    /**
     * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
     */
    Protocol: String;
    /**
     * Indicates whether to allow or deny the traffic that matches the rule.
     */
    RuleAction: RuleAction;
    /**
     * The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number. Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
     */
    RuleNumber: Integer;
  }
  export interface CreateNetworkAclRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * The tags to assign to the network ACL.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateNetworkAclResult {
    /**
     * Information about the network ACL.
     */
    NetworkAcl?: NetworkAcl;
  }
  export interface CreateNetworkInsightsAccessScopeRequest {
    /**
     * The paths to match.
     */
    MatchPaths?: AccessScopePathListRequest;
    /**
     * The paths to exclude.
     */
    ExcludePaths?: AccessScopePathListRequest;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken: String;
    /**
     * The tags to apply.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateNetworkInsightsAccessScopeResult {
    /**
     * The Network Access Scope.
     */
    NetworkInsightsAccessScope?: NetworkInsightsAccessScope;
    /**
     * The Network Access Scope content.
     */
    NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
  }
  export interface CreateNetworkInsightsPathRequest {
    /**
     * The IP address of the Amazon Web Services resource that is the source of the path.
     */
    SourceIp?: IpAddress;
    /**
     * The IP address of the Amazon Web Services resource that is the destination of the path.
     */
    DestinationIp?: IpAddress;
    /**
     * The Amazon Web Services resource that is the source of the path.
     */
    Source: NetworkInsightsResourceId;
    /**
     * The Amazon Web Services resource that is the destination of the path.
     */
    Destination: NetworkInsightsResourceId;
    /**
     * The protocol.
     */
    Protocol: Protocol;
    /**
     * The destination port.
     */
    DestinationPort?: Port;
    /**
     * The tags to add to the path.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken: String;
  }
  export interface CreateNetworkInsightsPathResult {
    /**
     * Information about the path.
     */
    NetworkInsightsPath?: NetworkInsightsPath;
  }
  export interface CreateNetworkInterfacePermissionRequest {
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId: NetworkInterfaceId;
    /**
     * The Amazon Web Services account ID.
     */
    AwsAccountId?: String;
    /**
     * The Amazon Web Service. Currently not supported.
     */
    AwsService?: String;
    /**
     * The type of permission to grant.
     */
    Permission: InterfacePermissionType;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateNetworkInterfacePermissionResult {
    /**
     * Information about the permission for the network interface.
     */
    InterfacePermission?: NetworkInterfacePermission;
  }
  export interface CreateNetworkInterfaceRequest {
    /**
     * A description for the network interface.
     */
    Description?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of one or more security groups.
     */
    Groups?: SecurityGroupIdStringList;
    /**
     * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't specify a count of IPv6 addresses using this parameter if you've specified one of the following: specific IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes. If your subnet has the AssignIpv6AddressOnCreation attribute set, you can override that setting by specifying 0 as the IPv6 address count.
     */
    Ipv6AddressCount?: Integer;
    /**
     * The IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't specify IPv6 addresses using this parameter if you've specified one of the following: a count of IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
     */
    Ipv6Addresses?: InstanceIpv6AddressList;
    /**
     * The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in privateIpAddresses as primary (only one IP address can be designated as primary).
     */
    PrivateIpAddress?: String;
    /**
     * The private IPv4 addresses. You can't specify private IPv4 addresses if you've specified one of the following: a count of private IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
     */
    PrivateIpAddresses?: PrivateIpAddressSpecificationList;
    /**
     * The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using privateIpAddresses. You can't specify a count of private IPv4 addresses if you've specified one of the following: specific private IPv4 addresses, specific IPv4 prefixes, or a count of IPv4 prefixes.
     */
    SecondaryPrivateIpAddressCount?: Integer;
    /**
     * The IPv4 prefixes assigned to the network interface. You can't specify IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
     */
    Ipv4Prefixes?: Ipv4PrefixList;
    /**
     * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You can't specify a count of IPv4 prefixes if you've specified one of the following: specific IPv4 prefixes, specific private IPv4 addresses, or a count of private IPv4 addresses.
     */
    Ipv4PrefixCount?: Integer;
    /**
     * The IPv6 prefixes assigned to the network interface. You can't specify IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
     */
    Ipv6Prefixes?: Ipv6PrefixList;
    /**
     * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You can't specify a count of IPv6 prefixes if you've specified one of the following: specific IPv6 prefixes, specific IPv6 addresses, or a count of IPv6 addresses.
     */
    Ipv6PrefixCount?: Integer;
    /**
     * The type of network interface. The default is interface. The only supported values are efa and trunk.
     */
    InterfaceType?: NetworkInterfaceCreationType;
    /**
     * The ID of the subnet to associate with the network interface.
     */
    SubnetId: SubnetId;
    /**
     * The tags to apply to the new network interface.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateNetworkInterfaceResult {
    /**
     * Information about the network interface.
     */
    NetworkInterface?: NetworkInterface;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    ClientToken?: String;
  }
  export interface CreatePlacementGroupRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * A name for the placement group. Must be unique within the scope of your account for the Region. Constraints: Up to 255 ASCII characters
     */
    GroupName?: String;
    /**
     * The placement strategy.
     */
    Strategy?: PlacementStrategy;
    /**
     * The number of partitions. Valid only when Strategy is set to partition.
     */
    PartitionCount?: Integer;
    /**
     * The tags to apply to the new placement group.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Determines how placement groups spread instances.    Host – You can use host only with Outpost placement groups.   Rack – No usage restrictions.  
     */
    SpreadLevel?: SpreadLevel;
  }
  export interface CreatePlacementGroupResult {
    /**
     * Information about the placement group.
     */
    PlacementGroup?: PlacementGroup;
  }
  export interface CreatePublicIpv4PoolRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreatePublicIpv4PoolResult {
    /**
     * The ID of the public IPv4 pool.
     */
    PoolId?: Ipv4PoolEc2Id;
  }
  export interface CreateReplaceRootVolumeTaskRequest {
    /**
     * The ID of the instance for which to replace the root volume.
     */
    InstanceId: InstanceId;
    /**
     * The ID of the snapshot from which to restore the replacement root volume. The specified snapshot must be a snapshot that you previously created from the original root volume. If you want to restore the replacement root volume to the initial launch state, or if you want to restore the replacement root volume from an AMI, omit this parameter.
     */
    SnapshotId?: SnapshotId;
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency. For more information, see Ensuring idempotency.
     */
    ClientToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The tags to apply to the root volume replacement task.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * The ID of the AMI to use to restore the root volume. The specified AMI must have the same product code, billing information, architecture type, and virtualization type as that of the instance. If you want to restore the replacement volume from a specific snapshot, or if you want to restore it to its launch state, omit this parameter.
     */
    ImageId?: ImageId;
    /**
     * Indicates whether to automatically delete the original root volume after the root volume replacement task completes. To delete the original root volume, specify true. If you choose to keep the original root volume after the replacement task completes, you must manually delete it when you no longer need it.
     */
    DeleteReplacedRootVolume?: Boolean;
  }
  export interface CreateReplaceRootVolumeTaskResult {
    /**
     * Information about the root volume replacement task.
     */
    ReplaceRootVolumeTask?: ReplaceRootVolumeTask;
  }
  export interface CreateReservedInstancesListingRequest {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see Ensuring Idempotency.
     */
    ClientToken: String;
    /**
     * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.
     */
    InstanceCount: Integer;
    /**
     * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.
     */
    PriceSchedules: PriceScheduleSpecificationList;
    /**
     * The ID of the active Standard Reserved Instance.
     */
    ReservedInstancesId: ReservationId;
  }
  export interface CreateReservedInstancesListingResult {
    /**
     * Information about the Standard Reserved Instance listing.
     */
    ReservedInstancesListings?: ReservedInstancesListingList;
  }
  export interface CreateRestoreImageTaskRequest {
    /**
     * The name of the Amazon S3 bucket that contains the stored AMI object.
     */
    Bucket: String;
    /**
     * The name of the stored AMI object in the bucket.
     */
    ObjectKey: String;
    /**
     * The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.
     */
    Name?: String;
    /**
     * The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.   To tag the AMI, the value for ResourceType must be image.   To tag the snapshots, the value for ResourceType must be snapshot. The same tag is applied to all of the snapshots that are created.  
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateRestoreImageTaskResult {
    /**
     * The AMI ID.
     */
    ImageId?: String;
  }
  export interface CreateRouteRequest {
    /**
     * The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
     */
    DestinationCidrBlock?: String;
    /**
     * The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match.
     */
    DestinationIpv6CidrBlock?: String;
    /**
     * The ID of a prefix list used for the destination match.
     */
    DestinationPrefixListId?: PrefixListResourceId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.
     */
    VpcEndpointId?: VpcEndpointId;
    /**
     * [IPv6 traffic only] The ID of an egress-only internet gateway.
     */
    EgressOnlyInternetGatewayId?: EgressOnlyInternetGatewayId;
    /**
     * The ID of an internet gateway or virtual private gateway attached to your VPC.
     */
    GatewayId?: RouteGatewayId;
    /**
     * The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.
     */
    InstanceId?: InstanceId;
    /**
     * [IPv4 traffic only] The ID of a NAT gateway.
     */
    NatGatewayId?: NatGatewayId;
    /**
     * The ID of a transit gateway.
     */
    TransitGatewayId?: TransitGatewayId;
    /**
     * The ID of the local gateway.
     */
    LocalGatewayId?: LocalGatewayId;
    /**
     * The ID of the carrier gateway. You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.
     */
    CarrierGatewayId?: CarrierGatewayId;
    /**
     * The ID of a network interface.
     */
    NetworkInterfaceId?: NetworkInterfaceId;
    /**
     * The ID of the route table for the route.
     */
    RouteTableId: RouteTableId;
    /**
     * The ID of a VPC peering connection.
     */
    VpcPeeringConnectionId?: VpcPeeringConnectionId;
    /**
     * The Amazon Resource Name (ARN) of the core network.
     */
    CoreNetworkArn?: CoreNetworkArn;
  }
  export interface CreateRouteResult {
    /**
     * Returns true if the request succeeds; otherwise, it returns an error.
     */
    Return?: Boolean;
  }
  export interface CreateRouteTableRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * The tags to assign to the route table.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateRouteTableResult {
    /**
     * Information about the route table.
     */
    RouteTable?: RouteTable;
  }
  export interface CreateSecurityGroupRequest {
    /**
     * A description for the security group. This is informational only. Constraints: Up to 255 characters in length Constraints for EC2-Classic: ASCII characters Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     */
    Description: String;
    /**
     * The name of the security group. Constraints: Up to 255 characters in length. Cannot start with sg-. Constraints for EC2-Classic: ASCII characters Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     */
    GroupName: String;
    /**
     * [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
     */
    VpcId?: VpcId;
    /**
     * The tags to assign to the security group.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateSecurityGroupResult {
    /**
     * The ID of the security group.
     */
    GroupId?: String;
    /**
     * The tags assigned to the security group.
     */
    Tags?: TagList;
  }
  export interface CreateSnapshotRequest {
    /**
     * A description for the snapshot.
     */
    Description?: String;
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.   To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.   To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.   To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.   For more information, see Create local snapshots from volumes on an Outpost in the Amazon Elastic Compute Cloud User Guide.
     */
    OutpostArn?: String;
    /**
     * The ID of the Amazon EBS volume.
     */
    VolumeId: VolumeId;
    /**
     * The tags to apply to the snapshot during creation.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateSnapshotsRequest {
    /**
     *  A description propagated to every snapshot specified by the instance.
     */
    Description?: String;
    /**
     * The instance to specify which volumes should be included in the snapshots.
     */
    InstanceSpecification: InstanceSpecification;
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.   To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.   To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.   To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.   For more information, see  Create multi-volume local snapshots from instances on an Outpost in the Amazon Elastic Compute Cloud User Guide.
     */
    OutpostArn?: String;
    /**
     * Tags to apply to every snapshot specified by the instance.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Copies the tags from the specified volume to corresponding snapshot.
     */
    CopyTagsFromSource?: CopyTagsFromSource;
  }
  export interface CreateSnapshotsResult {
    /**
     * List of snapshots.
     */
    Snapshots?: SnapshotSet;
  }
  export interface CreateSpotDatafeedSubscriptionRequest {
    /**
     * The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see Rules for bucket naming in the Amazon S3 Developer Guide.
     */
    Bucket: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The prefix for the data feed file names.
     */
    Prefix?: String;
  }
  export interface CreateSpotDatafeedSubscriptionResult {
    /**
     * The Spot Instance data feed subscription.
     */
    SpotDatafeedSubscription?: SpotDatafeedSubscription;
  }
  export interface CreateStoreImageTaskRequest {
    /**
     * The ID of the AMI.
     */
    ImageId: ImageId;
    /**
     * The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in the Region in which the request is being made. The AMI object appears in the bucket only after the upload task has completed. 
     */
    Bucket: String;
    /**
     * The tags to apply to the AMI object that will be stored in the Amazon S3 bucket. 
     */
    S3ObjectTags?: S3ObjectTagList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateStoreImageTaskResult {
    /**
     * The name of the stored AMI object in the S3 bucket.
     */
    ObjectKey?: String;
  }
  export interface CreateSubnetCidrReservationRequest {
    /**
     * The ID of the subnet.
     */
    SubnetId: SubnetId;
    /**
     * The IPv4 or IPV6 CIDR range to reserve.
     */
    Cidr: String;
    /**
     * The type of reservation. The following are valid values:    prefix: The Amazon EC2 Prefix Delegation feature assigns the IP addresses to network interfaces that are associated with an instance. For information about Prefix Delegation, see Prefix Delegation for Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.    explicit: You manually assign the IP addresses to resources that reside in your subnet.   
     */
    ReservationType: SubnetCidrReservationType;
    /**
     * The description to assign to the subnet CIDR reservation.
     */
    Description?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The tags to assign to the subnet CIDR reservation.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateSubnetCidrReservationResult {
    /**
     * Information about the created subnet CIDR reservation.
     */
    SubnetCidrReservation?: SubnetCidrReservation;
  }
  export interface CreateSubnetRequest {
    /**
     * The tags to assign to the subnet.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * The Availability Zone or Local Zone for the subnet. Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not necessarily select a different zone for each subnet. To create a subnet in a Local Zone, set this value to the Local Zone ID, for example us-west-2-lax-1a. For information about the Regions that support Local Zones, see Available Regions in the Amazon Elastic Compute Cloud User Guide. To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost ARN.
     */
    AvailabilityZone?: String;
    /**
     * The AZ ID or the Local Zone ID of the subnet.
     */
    AvailabilityZoneId?: String;
    /**
     * The IPv4 network range for the subnet, in CIDR notation. For example, 10.0.0.0/24. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18. This parameter is not supported for an IPv6 only subnet.
     */
    CidrBlock?: String;
    /**
     * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length. This parameter is required for an IPv6 only subnet.
     */
    Ipv6CidrBlock?: String;
    /**
     * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the Availability Zone of the Outpost subnet.
     */
    OutpostArn?: String;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Indicates whether to create an IPv6 only subnet.
     */
    Ipv6Native?: Boolean;
  }
  export interface CreateSubnetResult {
    /**
     * Information about the subnet.
     */
    Subnet?: Subnet;
  }
  export interface CreateTagsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of the resources, separated by spaces. Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.
     */
    Resources: ResourceIdList;
    /**
     * The tags. The value parameter is required, but if you don't want the tag to have a value, specify the parameter with no value, and we set the value to an empty string.
     */
    Tags: TagList;
  }
  export interface CreateTrafficMirrorFilterRequest {
    /**
     * The description of the Traffic Mirror filter.
     */
    Description?: String;
    /**
     * The tags to assign to a Traffic Mirror filter.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateTrafficMirrorFilterResult {
    /**
     * Information about the Traffic Mirror filter.
     */
    TrafficMirrorFilter?: TrafficMirrorFilter;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateTrafficMirrorFilterRuleRequest {
    /**
     * The ID of the filter that this rule is associated with.
     */
    TrafficMirrorFilterId: TrafficMirrorFilterId;
    /**
     * The type of traffic.
     */
    TrafficDirection: TrafficDirection;
    /**
     * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     */
    RuleNumber: Integer;
    /**
     * The action to take on the filtered traffic.
     */
    RuleAction: TrafficMirrorRuleAction;
    /**
     * The destination port range.
     */
    DestinationPortRange?: TrafficMirrorPortRangeRequest;
    /**
     * The source port range.
     */
    SourcePortRange?: TrafficMirrorPortRangeRequest;
    /**
     * The protocol, for example UDP, to assign to the Traffic Mirror rule. For information about the protocol value, see Protocol Numbers on the Internet Assigned Numbers Authority (IANA) website.
     */
    Protocol?: Integer;
    /**
     * The destination CIDR block to assign to the Traffic Mirror rule.
     */
    DestinationCidrBlock: String;
    /**
     * The source CIDR block to assign to the Traffic Mirror rule.
     */
    SourceCidrBlock: String;
    /**
     * The description of the Traffic Mirror rule.
     */
    Description?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateTrafficMirrorFilterRuleResult {
    /**
     * The Traffic Mirror rule.
     */
    TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateTrafficMirrorSessionRequest {
    /**
     * The ID of the source network interface.
     */
    NetworkInterfaceId: NetworkInterfaceId;
    /**
     * The ID of the Traffic Mirror target.
     */
    TrafficMirrorTargetId: TrafficMirrorTargetId;
    /**
     * The ID of the Traffic Mirror filter.
     */
    TrafficMirrorFilterId: TrafficMirrorFilterId;
    /**
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. If you do not want to mirror the entire packet, use the PacketLength parameter to specify the number of bytes in each packet to mirror.
     */
    PacketLength?: Integer;
    /**
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets. Valid values are 1-32766.
     */
    SessionNumber: Integer;
    /**
     * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
     */
    VirtualNetworkId?: Integer;
    /**
     * The description of the Traffic Mirror session.
     */
    Description?: String;
    /**
     * The tags to assign to a Traffic Mirror session.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateTrafficMirrorSessionResult {
    /**
     * Information about the Traffic Mirror session.
     */
    TrafficMirrorSession?: TrafficMirrorSession;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateTrafficMirrorTargetRequest {
    /**
     * The network interface ID that is associated with the target.
     */
    NetworkInterfaceId?: NetworkInterfaceId;
    /**
     * The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
     */
    NetworkLoadBalancerArn?: String;
    /**
     * The description of the Traffic Mirror target.
     */
    Description?: String;
    /**
     * The tags to assign to the Traffic Mirror target.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * The ID of the Gateway Load Balancer endpoint.
     */
    GatewayLoadBalancerEndpointId?: VpcEndpointId;
  }
  export interface CreateTrafficMirrorTargetResult {
    /**
     * Information about the Traffic Mirror target.
     */
    TrafficMirrorTarget?: TrafficMirrorTarget;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateTransitGatewayConnectPeerRequest {
    /**
     * The ID of the Connect attachment.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the first available IP address from the transit gateway CIDR block.
     */
    TransitGatewayAddress?: String;
    /**
     * The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
     */
    PeerAddress: String;
    /**
     * The BGP options for the Connect peer.
     */
    BgpOptions?: TransitGatewayConnectRequestBgpOptions;
    /**
     * The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR block from the 169.254.0.0/16 range. The first address from the range must be configured on the appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the fd00::/8 range.
     */
    InsideCidrBlocks: InsideCidrBlocksStringList;
    /**
     * The tags to apply to the Connect peer.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayConnectPeerResult {
    /**
     * Information about the Connect peer.
     */
    TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
  }
  export interface CreateTransitGatewayConnectRequest {
    /**
     * The ID of the transit gateway attachment. You can specify a VPC attachment or Amazon Web Services Direct Connect attachment.
     */
    TransportTransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * The Connect attachment options.
     */
    Options: CreateTransitGatewayConnectRequestOptions;
    /**
     * The tags to apply to the Connect attachment.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayConnectRequestOptions {
    /**
     * The tunnel protocol.
     */
    Protocol: ProtocolValue;
  }
  export interface CreateTransitGatewayConnectResult {
    /**
     * Information about the Connect attachment.
     */
    TransitGatewayConnect?: TransitGatewayConnect;
  }
  export interface CreateTransitGatewayMulticastDomainRequest {
    /**
     * The ID of the transit gateway.
     */
    TransitGatewayId: TransitGatewayId;
    /**
     * The options for the transit gateway multicast domain.
     */
    Options?: CreateTransitGatewayMulticastDomainRequestOptions;
    /**
     * The tags for the transit gateway multicast domain.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayMulticastDomainRequestOptions {
    /**
     * Specify whether to enable Internet Group Management Protocol (IGMP) version 2 for the transit gateway multicast domain.
     */
    Igmpv2Support?: Igmpv2SupportValue;
    /**
     * Specify whether to enable support for statically configuring multicast group sources for a domain.
     */
    StaticSourcesSupport?: StaticSourcesSupportValue;
    /**
     * Indicates whether to automatically accept cross-account subnet associations that are associated with the transit gateway multicast domain.
     */
    AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue;
  }
  export interface CreateTransitGatewayMulticastDomainResult {
    /**
     * Information about the transit gateway multicast domain.
     */
    TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
  }
  export interface CreateTransitGatewayPeeringAttachmentRequest {
    /**
     * The ID of the transit gateway.
     */
    TransitGatewayId: TransitGatewayId;
    /**
     * The ID of the peer transit gateway with which to create the peering attachment.
     */
    PeerTransitGatewayId: TransitAssociationGatewayId;
    /**
     * The ID of the Amazon Web Services account that owns the peer transit gateway.
     */
    PeerAccountId: String;
    /**
     * The Region where the peer transit gateway is located.
     */
    PeerRegion: String;
    /**
     * Requests a transit gateway peering attachment.
     */
    Options?: CreateTransitGatewayPeeringAttachmentRequestOptions;
    /**
     * The tags to apply to the transit gateway peering attachment.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayPeeringAttachmentRequestOptions {
    /**
     * Indicates whether dynamic routing is enabled or disabled.
     */
    DynamicRouting?: DynamicRoutingValue;
  }
  export interface CreateTransitGatewayPeeringAttachmentResult {
    /**
     * The transit gateway peering attachment.
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
  }
  export interface CreateTransitGatewayPolicyTableRequest {
    /**
     * The ID of the transit gateway used for the policy table.
     */
    TransitGatewayId: TransitGatewayId;
    /**
     * The tags specification for the transit gateway policy table created during the request.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayPolicyTableResult {
    /**
     * Describes the created transit gateway policy table.
     */
    TransitGatewayPolicyTable?: TransitGatewayPolicyTable;
  }
  export interface CreateTransitGatewayPrefixListReferenceRequest {
    /**
     * The ID of the transit gateway route table.
     */
    TransitGatewayRouteTableId: TransitGatewayRouteTableId;
    /**
     * The ID of the prefix list that is used for destination matches.
     */
    PrefixListId: PrefixListResourceId;
    /**
     * The ID of the attachment to which traffic is routed.
     */
    TransitGatewayAttachmentId?: TransitGatewayAttachmentId;
    /**
     * Indicates whether to drop traffic that matches this route.
     */
    Blackhole?: Boolean;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayPrefixListReferenceResult {
    /**
     * Information about the prefix list reference.
     */
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
  }
  export interface CreateTransitGatewayRequest {
    /**
     * A description of the transit gateway.
     */
    Description?: String;
    /**
     * The transit gateway options.
     */
    Options?: TransitGatewayRequestOptions;
    /**
     * The tags to apply to the transit gateway.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayResult {
    /**
     * Information about the transit gateway.
     */
    TransitGateway?: TransitGateway;
  }
  export interface CreateTransitGatewayRouteRequest {
    /**
     * The CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    DestinationCidrBlock: String;
    /**
     * The ID of the transit gateway route table.
     */
    TransitGatewayRouteTableId: TransitGatewayRouteTableId;
    /**
     * The ID of the attachment.
     */
    TransitGatewayAttachmentId?: TransitGatewayAttachmentId;
    /**
     * Indicates whether to drop traffic that matches this route.
     */
    Blackhole?: Boolean;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayRouteResult {
    /**
     * Information about the route.
     */
    Route?: TransitGatewayRoute;
  }
  export interface CreateTransitGatewayRouteTableAnnouncementRequest {
    /**
     * The ID of the transit gateway route table.
     */
    TransitGatewayRouteTableId: TransitGatewayRouteTableId;
    /**
     * The ID of the peering attachment.
     */
    PeeringAttachmentId: TransitGatewayAttachmentId;
    /**
     * The tags specifications applied to the transit gateway route table announcement.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayRouteTableAnnouncementResult {
    /**
     * Provides details about the transit gateway route table announcement.
     */
    TransitGatewayRouteTableAnnouncement?: TransitGatewayRouteTableAnnouncement;
  }
  export interface CreateTransitGatewayRouteTableRequest {
    /**
     * The ID of the transit gateway.
     */
    TransitGatewayId: TransitGatewayId;
    /**
     * The tags to apply to the transit gateway route table.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayRouteTableResult {
    /**
     * Information about the transit gateway route table.
     */
    TransitGatewayRouteTable?: TransitGatewayRouteTable;
  }
  export interface CreateTransitGatewayVpcAttachmentRequest {
    /**
     * The ID of the transit gateway.
     */
    TransitGatewayId: TransitGatewayId;
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * The IDs of one or more subnets. You can specify only one subnet per Availability Zone. You must specify at least one subnet, but we recommend that you specify two subnets for better availability. The transit gateway uses one IP address from each specified subnet.
     */
    SubnetIds: TransitGatewaySubnetIdList;
    /**
     * The VPC attachment options.
     */
    Options?: CreateTransitGatewayVpcAttachmentRequestOptions;
    /**
     * The tags to apply to the VPC attachment.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateTransitGatewayVpcAttachmentRequestOptions {
    /**
     * Enable or disable DNS support. The default is enable.
     */
    DnsSupport?: DnsSupportValue;
    /**
     * Enable or disable IPv6 support. The default is disable.
     */
    Ipv6Support?: Ipv6SupportValue;
    /**
     * Enable or disable support for appliance mode. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. The default is disable.
     */
    ApplianceModeSupport?: ApplianceModeSupportValue;
  }
  export interface CreateTransitGatewayVpcAttachmentResult {
    /**
     * Information about the VPC attachment.
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
  }
  export interface CreateVolumePermission {
    /**
     * The group to be added or removed. The possible value is all.
     */
    Group?: PermissionGroup;
    /**
     * The ID of the Amazon Web Services account to be added or removed.
     */
    UserId?: String;
  }
  export type CreateVolumePermissionList = CreateVolumePermission[];
  export interface CreateVolumePermissionModifications {
    /**
     * Adds the specified Amazon Web Services account ID or group to the list.
     */
    Add?: CreateVolumePermissionList;
    /**
     * Removes the specified Amazon Web Services account ID or group from the list.
     */
    Remove?: CreateVolumePermissionList;
  }
  export interface CreateVolumeRequest {
    /**
     * The Availability Zone in which to create the volume.
     */
    AvailabilityZone: String;
    /**
     * Indicates whether the volume should be encrypted. The effect of setting the encryption state to true depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see Encryption by default in the Amazon Elastic Compute Cloud User Guide. Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see Supported instance types.
     */
    Encrypted?: Boolean;
    /**
     * The number of I/O operations per second (IOPS). For gp3, io1, and io2 volumes, this represents the number of IOPS that are provisioned for the volume. For gp2 volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. The following are the supported values for each volume type:    gp3: 3,000-16,000 IOPS    io1: 100-64,000 IOPS    io2: 100-64,000 IOPS    io1 and io2 volumes support up to 64,000 IOPS only on Instances built on the Nitro System. Other instance families support performance up to 32,000 IOPS. This parameter is required for io1 and io2 volumes. The default for gp3 volumes is 3,000 IOPS. This parameter is not supported for gp2, st1, sc1, or standard volumes.
     */
    Iops?: Integer;
    /**
     * The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If KmsKeyId is specified, the encrypted state must be true. You can specify the KMS key using any of the following:   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example, alias/ExampleAlias.   Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.
     */
    KmsKeyId?: KmsKeyId;
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    OutpostArn?: String;
    /**
     * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size. The following are the supported volumes sizes for each volume type:    gp2 and gp3: 1-16,384    io1 and io2: 4-16,384    st1 and sc1: 125-16,384    standard: 1-1,024  
     */
    Size?: Integer;
    /**
     * The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
     */
    SnapshotId?: SnapshotId;
    /**
     * The volume type. This parameter can be one of the following values:   General Purpose SSD: gp2 | gp3    Provisioned IOPS SSD: io1 | io2    Throughput Optimized HDD: st1    Cold HDD: sc1    Magnetic: standard    For more information, see Amazon EBS volume types in the Amazon Elastic Compute Cloud User Guide. Default: gp2 
     */
    VolumeType?: VolumeType;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The tags to apply to the volume during creation.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up to 16 Instances built on the Nitro System in the same Availability Zone. This parameter is supported with io1 and io2 volumes only. For more information, see  Amazon EBS Multi-Attach in the Amazon Elastic Compute Cloud User Guide.
     */
    MultiAttachEnabled?: Boolean;
    /**
     * The throughput to provision for a volume, with a maximum of 1,000 MiB/s. This parameter is valid only for gp3 volumes. Valid Range: Minimum value of 125. Maximum value of 1000.
     */
    Throughput?: Integer;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensure Idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateVpcEndpointConnectionNotificationRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the endpoint service.
     */
    ServiceId?: VpcEndpointServiceId;
    /**
     * The ID of the endpoint.
     */
    VpcEndpointId?: VpcEndpointId;
    /**
     * The ARN of the SNS topic for the notifications.
     */
    ConnectionNotificationArn: String;
    /**
     * One or more endpoint events for which to receive notifications. Valid values are Accept, Connect, Delete, and Reject.
     */
    ConnectionEvents: ValueStringList;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
  }
  export interface CreateVpcEndpointConnectionNotificationResult {
    /**
     * Information about the notification.
     */
    ConnectionNotification?: ConnectionNotification;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    ClientToken?: String;
  }
  export interface CreateVpcEndpointRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The type of endpoint. Default: Gateway
     */
    VpcEndpointType?: VpcEndpointType;
    /**
     * The ID of the VPC in which the endpoint will be used.
     */
    VpcId: VpcId;
    /**
     * The service name. To get a list of available services, use the DescribeVpcEndpointServices request, or get the name from the service provider.
     */
    ServiceName: String;
    /**
     * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows full access to the service.
     */
    PolicyDocument?: String;
    /**
     * (Gateway endpoint) One or more route table IDs.
     */
    RouteTableIds?: VpcEndpointRouteTableIdList;
    /**
     * (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.
     */
    SubnetIds?: VpcEndpointSubnetIdList;
    /**
     * (Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.
     */
    SecurityGroupIds?: VpcEndpointSecurityGroupIdList;
    /**
     * The IP address type for the endpoint.
     */
    IpAddressType?: IpAddressType;
    /**
     * The DNS options for the endpoint.
     */
    DnsOptions?: DnsOptionsSpecification;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, kinesis.us-east-1.amazonaws.com), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service. To use a private hosted zone, you must set the following VPC attributes to true: enableDnsHostnames and enableDnsSupport. Use ModifyVpcAttribute to set the VPC attributes. Default: true 
     */
    PrivateDnsEnabled?: Boolean;
    /**
     * The tags to associate with the endpoint.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateVpcEndpointResult {
    /**
     * Information about the endpoint.
     */
    VpcEndpoint?: VpcEndpoint;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    ClientToken?: String;
  }
  export interface CreateVpcEndpointServiceConfigurationRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Indicates whether requests from service consumers to create an endpoint to your service must be accepted manually.
     */
    AcceptanceRequired?: Boolean;
    /**
     * (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
     */
    PrivateDnsName?: String;
    /**
     * The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.
     */
    NetworkLoadBalancerArns?: ValueStringList;
    /**
     * The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
     */
    GatewayLoadBalancerArns?: ValueStringList;
    /**
     * The supported IP address types. The possible values are ipv4 and ipv6.
     */
    SupportedIpAddressTypes?: ValueStringList;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency.
     */
    ClientToken?: String;
    /**
     * The tags to associate with the service.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateVpcEndpointServiceConfigurationResult {
    /**
     * Information about the service configuration.
     */
    ServiceConfiguration?: ServiceConfiguration;
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    ClientToken?: String;
  }
  export interface CreateVpcPeeringConnectionRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The Amazon Web Services account ID of the owner of the accepter VPC. Default: Your Amazon Web Services account ID
     */
    PeerOwnerId?: String;
    /**
     * The ID of the VPC with which you are creating the VPC peering connection. You must specify this parameter in the request.
     */
    PeerVpcId?: String;
    /**
     * The ID of the requester VPC. You must specify this parameter in the request.
     */
    VpcId?: VpcId;
    /**
     * The Region code for the accepter VPC, if the accepter VPC is located in a Region other than the Region in which you make the request. Default: The Region in which you make the request.
     */
    PeerRegion?: String;
    /**
     * The tags to assign to the peering connection.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateVpcPeeringConnectionResult {
    /**
     * Information about the VPC peering connection.
     */
    VpcPeeringConnection?: VpcPeeringConnection;
  }
  export interface CreateVpcRequest {
    /**
     * The IPv4 network range for the VPC, in CIDR notation. For example, 10.0.0.0/16. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
     */
    CidrBlock?: String;
    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.
     */
    AmazonProvidedIpv6CidrBlock?: Boolean;
    /**
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    Ipv6Pool?: Ipv6PoolEc2Id;
    /**
     * The IPv6 CIDR block from the IPv6 address pool. You must also specify Ipv6Pool in the request. To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    Ipv6CidrBlock?: String;
    /**
     * The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. For more information, see What is IPAM? in the Amazon VPC IPAM User Guide. 
     */
    Ipv4IpamPoolId?: IpamPoolId;
    /**
     * The netmask length of the IPv4 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see What is IPAM? in the Amazon VPC IPAM User Guide.
     */
    Ipv4NetmaskLength?: NetmaskLength;
    /**
     * The ID of an IPv6 IPAM pool which will be used to allocate this VPC an IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see What is IPAM? in the Amazon VPC IPAM User Guide.
     */
    Ipv6IpamPoolId?: IpamPoolId;
    /**
     * The netmask length of the IPv6 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see What is IPAM? in the Amazon VPC IPAM User Guide.
     */
    Ipv6NetmaskLength?: NetmaskLength;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The tenancy options for instances launched into the VPC. For default, instances are launched with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For dedicated, instances are launched as dedicated tenancy instances by default. You can only launch instances with a tenancy of dedicated or host into a dedicated tenancy VPC.   Important: The host value cannot be used with this parameter. Use the default or dedicated values only. Default: default 
     */
    InstanceTenancy?: Tenancy;
    /**
     * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to this location.  You must set AmazonProvidedIpv6CidrBlock to true to use this parameter.
     */
    Ipv6CidrBlockNetworkBorderGroup?: String;
    /**
     * The tags to assign to the VPC.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateVpcResult {
    /**
     * Information about the VPC.
     */
    Vpc?: Vpc;
  }
  export interface CreateVpnConnectionRequest {
    /**
     * The ID of the customer gateway.
     */
    CustomerGatewayId: CustomerGatewayId;
    /**
     * The type of VPN connection (ipsec.1).
     */
    Type: String;
    /**
     * The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a transit gateway.
     */
    VpnGatewayId?: VpnGatewayId;
    /**
     * The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private gateway.
     */
    TransitGatewayId?: TransitGatewayId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The options for the VPN connection.
     */
    Options?: VpnConnectionOptionsSpecification;
    /**
     * The tags to apply to the VPN connection.
     */
    TagSpecifications?: TagSpecificationList;
  }
  export interface CreateVpnConnectionResult {
    /**
     * Information about the VPN connection.
     */
    VpnConnection?: VpnConnection;
  }
  export interface CreateVpnConnectionRouteRequest {
    /**
     * The CIDR block associated with the local subnet of the customer network.
     */
    DestinationCidrBlock: String;
    /**
     * The ID of the VPN connection.
     */
    VpnConnectionId: VpnConnectionId;
  }
  export interface CreateVpnGatewayRequest {
    /**
     * The Availability Zone for the virtual private gateway.
     */
    AvailabilityZone?: String;
    /**
     * The type of VPN connection this virtual private gateway supports.
     */
    Type: GatewayType;
    /**
     * The tags to apply to the virtual private gateway.
     */
    TagSpecifications?: TagSpecificationList;
    /**
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you're using a 16-bit ASN, it must be in the 64512 to 65534 range. If you're using a 32-bit ASN, it must be in the 4200000000 to 4294967294 range. Default: 64512
     */
    AmazonSideAsn?: Long;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface CreateVpnGatewayResult {
    /**
     * Information about the virtual private gateway.
     */
    VpnGateway?: VpnGateway;
  }
  export interface CreditSpecification {
    /**
     * The credit option for CPU usage of a T instance. Valid values: standard | unlimited 
     */
    CpuCredits?: String;
  }
  export interface CreditSpecificationRequest {
    /**
     * The credit option for CPU usage of a T instance. Valid values: standard | unlimited 
     */
    CpuCredits: String;
  }
  export type CurrencyCodeValues = "USD"|string;
  export type CurrentGenerationFlag = boolean;
  export interface CustomerGateway {
    /**
     * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     */
    BgpAsn?: String;
    /**
     * The ID of the customer gateway.
     */
    CustomerGatewayId?: String;
    /**
     * The IP address of the customer gateway device's outside interface.
     */
    IpAddress?: String;
    /**
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    CertificateArn?: String;
    /**
     * The current state of the customer gateway (pending | available | deleting | deleted).
     */
    State?: String;
    /**
     * The type of VPN connection the customer gateway supports (ipsec.1).
     */
    Type?: String;
    /**
     * The name of customer gateway device.
     */
    DeviceName?: String;
    /**
     * Any tags assigned to the customer gateway.
     */
    Tags?: TagList;
  }
  export type CustomerGatewayId = string;
  export type CustomerGatewayIdStringList = CustomerGatewayId[];
  export type CustomerGatewayList = CustomerGateway[];
  export type DITMaxResults = number;
  export type DITOMaxResults = number;
  export type DatafeedSubscriptionState = "Active"|"Inactive"|string;
  export type DateTime = Date;
  export type DedicatedHostFlag = boolean;
  export type DedicatedHostId = string;
  export type DedicatedHostIdList = DedicatedHostId[];
  export type DefaultNetworkCardIndex = number;
  export type DefaultRouteTableAssociationValue = "enable"|"disable"|string;
  export type DefaultRouteTablePropagationValue = "enable"|"disable"|string;
  export type DefaultTargetCapacityType = "spot"|"on-demand"|string;
  export type DefaultingDhcpOptionsId = string;
  export interface DeleteCarrierGatewayRequest {
    /**
     * The ID of the carrier gateway.
     */
    CarrierGatewayId: CarrierGatewayId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteCarrierGatewayResult {
    /**
     * Information about the carrier gateway.
     */
    CarrierGateway?: CarrierGateway;
  }
  export interface DeleteClientVpnEndpointRequest {
    /**
     * The ID of the Client VPN to be deleted.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteClientVpnEndpointResult {
    /**
     * The current state of the Client VPN endpoint.
     */
    Status?: ClientVpnEndpointStatus;
  }
  export interface DeleteClientVpnRouteRequest {
    /**
     * The ID of the Client VPN endpoint from which the route is to be deleted.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * The ID of the target subnet used by the route.
     */
    TargetVpcSubnetId?: SubnetId;
    /**
     * The IPv4 address range, in CIDR notation, of the route to be deleted.
     */
    DestinationCidrBlock: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteClientVpnRouteResult {
    /**
     * The current state of the route.
     */
    Status?: ClientVpnRouteStatus;
  }
  export interface DeleteCoipCidrRequest {
    /**
     *  A customer-owned IP address range that you want to delete. 
     */
    Cidr: String;
    /**
     *  The ID of the customer-owned address pool. 
     */
    CoipPoolId: Ipv4PoolCoipId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteCoipCidrResult {
    /**
     *  Information about a range of customer-owned IP addresses. 
     */
    CoipCidr?: CoipCidr;
  }
  export interface DeleteCoipPoolRequest {
    /**
     * The ID of the CoIP pool that you want to delete. 
     */
    CoipPoolId: Ipv4PoolCoipId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteCoipPoolResult {
    CoipPool?: CoipPool;
  }
  export interface DeleteCustomerGatewayRequest {
    /**
     * The ID of the customer gateway.
     */
    CustomerGatewayId: CustomerGatewayId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteDhcpOptionsRequest {
    /**
     * The ID of the DHCP options set.
     */
    DhcpOptionsId: DhcpOptionsId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteEgressOnlyInternetGatewayRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the egress-only internet gateway.
     */
    EgressOnlyInternetGatewayId: EgressOnlyInternetGatewayId;
  }
  export interface DeleteEgressOnlyInternetGatewayResult {
    /**
     * Returns true if the request succeeds; otherwise, it returns an error.
     */
    ReturnCode?: Boolean;
  }
  export interface DeleteFleetError {
    /**
     * The error code.
     */
    Code?: DeleteFleetErrorCode;
    /**
     * The description for the error code.
     */
    Message?: String;
  }
  export type DeleteFleetErrorCode = "fleetIdDoesNotExist"|"fleetIdMalformed"|"fleetNotInDeletableState"|"unexpectedError"|string;
  export interface DeleteFleetErrorItem {
    /**
     * The error.
     */
    Error?: DeleteFleetError;
    /**
     * The ID of the EC2 Fleet.
     */
    FleetId?: FleetId;
  }
  export type DeleteFleetErrorSet = DeleteFleetErrorItem[];
  export interface DeleteFleetSuccessItem {
    /**
     * The current state of the EC2 Fleet.
     */
    CurrentFleetState?: FleetStateCode;
    /**
     * The previous state of the EC2 Fleet.
     */
    PreviousFleetState?: FleetStateCode;
    /**
     * The ID of the EC2 Fleet.
     */
    FleetId?: FleetId;
  }
  export type DeleteFleetSuccessSet = DeleteFleetSuccessItem[];
  export interface DeleteFleetsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of the EC2 Fleets.
     */
    FleetIds: FleetIdSet;
    /**
     * Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to terminate the instances. To let the instances continue to run after the EC2 Fleet is deleted, specify NoTerminateInstances. Supported only for fleets of type maintain and request. For instant fleets, you cannot specify NoTerminateInstances. A deleted instant fleet with running instances is not supported.
     */
    TerminateInstances: Boolean;
  }
  export interface DeleteFleetsResult {
    /**
     * Information about the EC2 Fleets that are successfully deleted.
     */
    SuccessfulFleetDeletions?: DeleteFleetSuccessSet;
    /**
     * Information about the EC2 Fleets that are not successfully deleted.
     */
    UnsuccessfulFleetDeletions?: DeleteFleetErrorSet;
  }
  export interface DeleteFlowLogsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * One or more flow log IDs. Constraint: Maximum of 1000 flow log IDs.
     */
    FlowLogIds: FlowLogIdList;
  }
  export interface DeleteFlowLogsResult {
    /**
     * Information about the flow logs that could not be deleted successfully.
     */
    Unsuccessful?: UnsuccessfulItemSet;
  }
  export interface DeleteFpgaImageRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the AFI.
     */
    FpgaImageId: FpgaImageId;
  }
  export interface DeleteFpgaImageResult {
    /**
     * Is true if the request succeeds, and an error otherwise.
     */
    Return?: Boolean;
  }
  export interface DeleteInstanceEventWindowRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Specify true to force delete the event window. Use the force delete parameter if the event window is currently associated with targets.
     */
    ForceDelete?: Boolean;
    /**
     * The ID of the event window.
     */
    InstanceEventWindowId: InstanceEventWindowId;
  }
  export interface DeleteInstanceEventWindowResult {
    /**
     * The state of the event window.
     */
    InstanceEventWindowState?: InstanceEventWindowStateChange;
  }
  export interface DeleteInternetGatewayRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the internet gateway.
     */
    InternetGatewayId: InternetGatewayId;
  }
  export interface DeleteIpamPoolRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the pool to delete.
     */
    IpamPoolId: IpamPoolId;
  }
  export interface DeleteIpamPoolResult {
    /**
     * Information about the results of the deletion.
     */
    IpamPool?: IpamPool;
  }
  export interface DeleteIpamRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the IPAM to delete.
     */
    IpamId: IpamId;
    /**
     * Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes. You cannot delete the IPAM with this option if there is a pool in your public scope. If you use this option, IPAM does the following:   Deallocates any CIDRs allocated to VPC resources (such as VPCs) in pools in private scopes.  No VPC resources are deleted as a result of enabling this option. The CIDR associated with the resource will no longer be allocated from an IPAM pool, but the CIDR itself will remain unchanged.    Deprovisions all IPv4 CIDRs provisioned to IPAM pools in private scopes.   Deletes all IPAM pools in private scopes.   Deletes all non-default private scopes in the IPAM.   Deletes the default public and private scopes and the IPAM.  
     */
    Cascade?: Boolean;
  }
  export interface DeleteIpamResult {
    /**
     * Information about the results of the deletion.
     */
    Ipam?: Ipam;
  }
  export interface DeleteIpamScopeRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the scope to delete.
     */
    IpamScopeId: IpamScopeId;
  }
  export interface DeleteIpamScopeResult {
    /**
     * Information about the results of the deletion.
     */
    IpamScope?: IpamScope;
  }
  export interface DeleteKeyPairRequest {
    /**
     * The name of the key pair.
     */
    KeyName?: KeyPairName;
    /**
     * The ID of the key pair.
     */
    KeyPairId?: KeyPairId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteLaunchTemplateRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the launch template. You must specify either the LaunchTemplateId or the LaunchTemplateName, but not both.
     */
    LaunchTemplateId?: LaunchTemplateId;
    /**
     * The name of the launch template. You must specify either the LaunchTemplateName or the LaunchTemplateId, but not both.
     */
    LaunchTemplateName?: LaunchTemplateName;
  }
  export interface DeleteLaunchTemplateResult {
    /**
     * Information about the launch template.
     */
    LaunchTemplate?: LaunchTemplate;
  }
  export interface DeleteLaunchTemplateVersionsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the launch template. You must specify either the LaunchTemplateId or the LaunchTemplateName, but not both.
     */
    LaunchTemplateId?: LaunchTemplateId;
    /**
     * The name of the launch template. You must specify either the LaunchTemplateName or the LaunchTemplateId, but not both.
     */
    LaunchTemplateName?: LaunchTemplateName;
    /**
     * The version numbers of one or more launch template versions to delete.
     */
    Versions: VersionStringList;
  }
  export interface DeleteLaunchTemplateVersionsResponseErrorItem {
    /**
     * The ID of the launch template.
     */
    LaunchTemplateId?: String;
    /**
     * The name of the launch template.
     */
    LaunchTemplateName?: String;
    /**
     * The version number of the launch template.
     */
    VersionNumber?: Long;
    /**
     * Information about the error.
     */
    ResponseError?: ResponseError;
  }
  export type DeleteLaunchTemplateVersionsResponseErrorSet = DeleteLaunchTemplateVersionsResponseErrorItem[];
  export interface DeleteLaunchTemplateVersionsResponseSuccessItem {
    /**
     * The ID of the launch template.
     */
    LaunchTemplateId?: String;
    /**
     * The name of the launch template.
     */
    LaunchTemplateName?: String;
    /**
     * The version number of the launch template.
     */
    VersionNumber?: Long;
  }
  export type DeleteLaunchTemplateVersionsResponseSuccessSet = DeleteLaunchTemplateVersionsResponseSuccessItem[];
  export interface DeleteLaunchTemplateVersionsResult {
    /**
     * Information about the launch template versions that were successfully deleted.
     */
    SuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseSuccessSet;
    /**
     * Information about the launch template versions that could not be deleted.
     */
    UnsuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseErrorSet;
  }
  export interface DeleteLocalGatewayRouteRequest {
    /**
     * The CIDR range for the route. This must match the CIDR for the route exactly.
     */
    DestinationCidrBlock: String;
    /**
     * The ID of the local gateway route table.
     */
    LocalGatewayRouteTableId: LocalGatewayRoutetableId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteLocalGatewayRouteResult {
    /**
     * Information about the route.
     */
    Route?: LocalGatewayRoute;
  }
  export interface DeleteLocalGatewayRouteTableRequest {
    /**
     *  The ID of the local gateway route table. 
     */
    LocalGatewayRouteTableId: LocalGatewayRoutetableId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteLocalGatewayRouteTableResult {
    LocalGatewayRouteTable?: LocalGatewayRouteTable;
  }
  export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
    /**
     *  The ID of the local gateway route table virtual interface group association. 
     */
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationId: LocalGatewayRouteTableVirtualInterfaceGroupAssociationId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
    LocalGatewayRouteTableVirtualInterfaceGroupAssociation?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation;
  }
  export interface DeleteLocalGatewayRouteTableVpcAssociationRequest {
    /**
     * The ID of the association.
     */
    LocalGatewayRouteTableVpcAssociationId: LocalGatewayRouteTableVpcAssociationId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteLocalGatewayRouteTableVpcAssociationResult {
    /**
     * Information about the association.
     */
    LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
  }
  export interface DeleteManagedPrefixListRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the prefix list.
     */
    PrefixListId: PrefixListResourceId;
  }
  export interface DeleteManagedPrefixListResult {
    /**
     * Information about the prefix list.
     */
    PrefixList?: ManagedPrefixList;
  }
  export interface DeleteNatGatewayRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the NAT gateway.
     */
    NatGatewayId: NatGatewayId;
  }
  export interface DeleteNatGatewayResult {
    /**
     * The ID of the NAT gateway.
     */
    NatGatewayId?: String;
  }
  export interface DeleteNetworkAclEntryRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Indicates whether the rule is an egress rule.
     */
    Egress: Boolean;
    /**
     * The ID of the network ACL.
     */
    NetworkAclId: NetworkAclId;
    /**
     * The rule number of the entry to delete.
     */
    RuleNumber: Integer;
  }
  export interface DeleteNetworkAclRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the network ACL.
     */
    NetworkAclId: NetworkAclId;
  }
  export interface DeleteNetworkInsightsAccessScopeAnalysisRequest {
    /**
     * The ID of the Network Access Scope analysis.
     */
    NetworkInsightsAccessScopeAnalysisId: NetworkInsightsAccessScopeAnalysisId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteNetworkInsightsAccessScopeAnalysisResult {
    /**
     * The ID of the Network Access Scope analysis.
     */
    NetworkInsightsAccessScopeAnalysisId?: NetworkInsightsAccessScopeAnalysisId;
  }
  export interface DeleteNetworkInsightsAccessScopeRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the Network Access Scope.
     */
    NetworkInsightsAccessScopeId: NetworkInsightsAccessScopeId;
  }
  export interface DeleteNetworkInsightsAccessScopeResult {
    /**
     * The ID of the Network Access Scope.
     */
    NetworkInsightsAccessScopeId?: NetworkInsightsAccessScopeId;
  }
  export interface DeleteNetworkInsightsAnalysisRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the network insights analysis.
     */
    NetworkInsightsAnalysisId: NetworkInsightsAnalysisId;
  }
  export interface DeleteNetworkInsightsAnalysisResult {
    /**
     * The ID of the network insights analysis.
     */
    NetworkInsightsAnalysisId?: NetworkInsightsAnalysisId;
  }
  export interface DeleteNetworkInsightsPathRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the path.
     */
    NetworkInsightsPathId: NetworkInsightsPathId;
  }
  export interface DeleteNetworkInsightsPathResult {
    /**
     * The ID of the path.
     */
    NetworkInsightsPathId?: NetworkInsightsPathId;
  }
  export interface DeleteNetworkInterfacePermissionRequest {
    /**
     * The ID of the network interface permission.
     */
    NetworkInterfacePermissionId: NetworkInterfacePermissionId;
    /**
     * Specify true to remove the permission even if the network interface is attached to an instance.
     */
    Force?: Boolean;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteNetworkInterfacePermissionResult {
    /**
     * Returns true if the request succeeds, otherwise returns an error.
     */
    Return?: Boolean;
  }
  export interface DeleteNetworkInterfaceRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the network interface.
     */
    NetworkInterfaceId: NetworkInterfaceId;
  }
  export interface DeletePlacementGroupRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The name of the placement group.
     */
    GroupName: PlacementGroupName;
  }
  export interface DeletePublicIpv4PoolRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the public IPv4 pool you want to delete.
     */
    PoolId: Ipv4PoolEc2Id;
  }
  export interface DeletePublicIpv4PoolResult {
    /**
     * Information about the result of deleting the public IPv4 pool.
     */
    ReturnValue?: Boolean;
  }
  export interface DeleteQueuedReservedInstancesError {
    /**
     * The error code.
     */
    Code?: DeleteQueuedReservedInstancesErrorCode;
    /**
     * The error message.
     */
    Message?: String;
  }
  export type DeleteQueuedReservedInstancesErrorCode = "reserved-instances-id-invalid"|"reserved-instances-not-in-queued-state"|"unexpected-error"|string;
  export type DeleteQueuedReservedInstancesIdList = ReservationId[];
  export interface DeleteQueuedReservedInstancesRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of the Reserved Instances.
     */
    ReservedInstancesIds: DeleteQueuedReservedInstancesIdList;
  }
  export interface DeleteQueuedReservedInstancesResult {
    /**
     * Information about the queued purchases that were successfully deleted.
     */
    SuccessfulQueuedPurchaseDeletions?: SuccessfulQueuedPurchaseDeletionSet;
    /**
     * Information about the queued purchases that could not be deleted.
     */
    FailedQueuedPurchaseDeletions?: FailedQueuedPurchaseDeletionSet;
  }
  export interface DeleteRouteRequest {
    /**
     * The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
     */
    DestinationCidrBlock?: String;
    /**
     * The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.
     */
    DestinationIpv6CidrBlock?: String;
    /**
     * The ID of the prefix list for the route.
     */
    DestinationPrefixListId?: PrefixListResourceId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the route table.
     */
    RouteTableId: RouteTableId;
  }
  export interface DeleteRouteTableRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the route table.
     */
    RouteTableId: RouteTableId;
  }
  export interface DeleteSecurityGroupRequest {
    /**
     * The ID of the security group. Required for a nondefault VPC.
     */
    GroupId?: SecurityGroupId;
    /**
     * [EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or the security group ID. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    GroupName?: SecurityGroupName;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteSnapshotRequest {
    /**
     * The ID of the EBS snapshot.
     */
    SnapshotId: SnapshotId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteSpotDatafeedSubscriptionRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteSubnetCidrReservationRequest {
    /**
     * The ID of the subnet CIDR reservation.
     */
    SubnetCidrReservationId: SubnetCidrReservationId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteSubnetCidrReservationResult {
    /**
     * Information about the deleted subnet CIDR reservation.
     */
    DeletedSubnetCidrReservation?: SubnetCidrReservation;
  }
  export interface DeleteSubnetRequest {
    /**
     * The ID of the subnet.
     */
    SubnetId: SubnetId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTagsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of the resources, separated by spaces. Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.
     */
    Resources: ResourceIdList;
    /**
     * The tags to delete. Specify a tag key and an optional tag value to delete specific tags. If you specify a tag key without a tag value, we delete any tag with this key regardless of its value. If you specify a tag key with an empty string as the tag value, we delete the tag only if its value is an empty string. If you omit this parameter, we delete all user-defined tags for the specified resources. We do not delete Amazon Web Services-generated tags (tags that have the aws: prefix). Constraints: Up to 1000 tags.
     */
    Tags?: TagList;
  }
  export interface DeleteTrafficMirrorFilterRequest {
    /**
     * The ID of the Traffic Mirror filter.
     */
    TrafficMirrorFilterId: TrafficMirrorFilterId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTrafficMirrorFilterResult {
    /**
     * The ID of the Traffic Mirror filter.
     */
    TrafficMirrorFilterId?: String;
  }
  export interface DeleteTrafficMirrorFilterRuleRequest {
    /**
     * The ID of the Traffic Mirror rule.
     */
    TrafficMirrorFilterRuleId: TrafficMirrorFilterRuleId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTrafficMirrorFilterRuleResult {
    /**
     * The ID of the deleted Traffic Mirror rule.
     */
    TrafficMirrorFilterRuleId?: String;
  }
  export interface DeleteTrafficMirrorSessionRequest {
    /**
     * The ID of the Traffic Mirror session.
     */
    TrafficMirrorSessionId: TrafficMirrorSessionId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTrafficMirrorSessionResult {
    /**
     * The ID of the deleted Traffic Mirror session.
     */
    TrafficMirrorSessionId?: String;
  }
  export interface DeleteTrafficMirrorTargetRequest {
    /**
     * The ID of the Traffic Mirror target.
     */
    TrafficMirrorTargetId: TrafficMirrorTargetId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTrafficMirrorTargetResult {
    /**
     * The ID of the deleted Traffic Mirror target.
     */
    TrafficMirrorTargetId?: String;
  }
  export interface DeleteTransitGatewayConnectPeerRequest {
    /**
     * The ID of the Connect peer.
     */
    TransitGatewayConnectPeerId: TransitGatewayConnectPeerId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayConnectPeerResult {
    /**
     * Information about the deleted Connect peer.
     */
    TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
  }
  export interface DeleteTransitGatewayConnectRequest {
    /**
     * The ID of the Connect attachment.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayConnectResult {
    /**
     * Information about the deleted Connect attachment.
     */
    TransitGatewayConnect?: TransitGatewayConnect;
  }
  export interface DeleteTransitGatewayMulticastDomainRequest {
    /**
     * The ID of the transit gateway multicast domain.
     */
    TransitGatewayMulticastDomainId: TransitGatewayMulticastDomainId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayMulticastDomainResult {
    /**
     * Information about the deleted transit gateway multicast domain.
     */
    TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
  }
  export interface DeleteTransitGatewayPeeringAttachmentRequest {
    /**
     * The ID of the transit gateway peering attachment.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayPeeringAttachmentResult {
    /**
     * The transit gateway peering attachment.
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
  }
  export interface DeleteTransitGatewayPolicyTableRequest {
    /**
     * The transit gateway policy table to delete.
     */
    TransitGatewayPolicyTableId: TransitGatewayPolicyTableId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayPolicyTableResult {
    /**
     * Provides details about the deleted transit gateway policy table.
     */
    TransitGatewayPolicyTable?: TransitGatewayPolicyTable;
  }
  export interface DeleteTransitGatewayPrefixListReferenceRequest {
    /**
     * The ID of the route table.
     */
    TransitGatewayRouteTableId: TransitGatewayRouteTableId;
    /**
     * The ID of the prefix list.
     */
    PrefixListId: PrefixListResourceId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayPrefixListReferenceResult {
    /**
     * Information about the deleted prefix list reference.
     */
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
  }
  export interface DeleteTransitGatewayRequest {
    /**
     * The ID of the transit gateway.
     */
    TransitGatewayId: TransitGatewayId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayResult {
    /**
     * Information about the deleted transit gateway.
     */
    TransitGateway?: TransitGateway;
  }
  export interface DeleteTransitGatewayRouteRequest {
    /**
     * The ID of the transit gateway route table.
     */
    TransitGatewayRouteTableId: TransitGatewayRouteTableId;
    /**
     * The CIDR range for the route. This must match the CIDR for the route exactly.
     */
    DestinationCidrBlock: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayRouteResult {
    /**
     * Information about the route.
     */
    Route?: TransitGatewayRoute;
  }
  export interface DeleteTransitGatewayRouteTableAnnouncementRequest {
    /**
     * The transit gateway route table ID that's being deleted. 
     */
    TransitGatewayRouteTableAnnouncementId: TransitGatewayRouteTableAnnouncementId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayRouteTableAnnouncementResult {
    /**
     * Provides details about a deleted transit gateway route table.
     */
    TransitGatewayRouteTableAnnouncement?: TransitGatewayRouteTableAnnouncement;
  }
  export interface DeleteTransitGatewayRouteTableRequest {
    /**
     * The ID of the transit gateway route table.
     */
    TransitGatewayRouteTableId: TransitGatewayRouteTableId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayRouteTableResult {
    /**
     * Information about the deleted transit gateway route table.
     */
    TransitGatewayRouteTable?: TransitGatewayRouteTable;
  }
  export interface DeleteTransitGatewayVpcAttachmentRequest {
    /**
     * The ID of the attachment.
     */
    TransitGatewayAttachmentId: TransitGatewayAttachmentId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteTransitGatewayVpcAttachmentResult {
    /**
     * Information about the deleted VPC attachment.
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
  }
  export interface DeleteVolumeRequest {
    /**
     * The ID of the volume.
     */
    VolumeId: VolumeId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteVpcEndpointConnectionNotificationsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * One or more notification IDs.
     */
    ConnectionNotificationIds: ConnectionNotificationIdsList;
  }
  export interface DeleteVpcEndpointConnectionNotificationsResult {
    /**
     * Information about the notifications that could not be deleted successfully.
     */
    Unsuccessful?: UnsuccessfulItemSet;
  }
  export interface DeleteVpcEndpointServiceConfigurationsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The IDs of one or more services.
     */
    ServiceIds: VpcEndpointServiceIdList;
  }
  export interface DeleteVpcEndpointServiceConfigurationsResult {
    /**
     * Information about the service configurations that were not deleted, if applicable.
     */
    Unsuccessful?: UnsuccessfulItemSet;
  }
  export interface DeleteVpcEndpointsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * One or more VPC endpoint IDs.
     */
    VpcEndpointIds: VpcEndpointIdList;
  }
  export interface DeleteVpcEndpointsResult {
    /**
     * Information about the VPC endpoints that were not successfully deleted.
     */
    Unsuccessful?: UnsuccessfulItemSet;
  }
  export interface DeleteVpcPeeringConnectionRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the VPC peering connection.
     */
    VpcPeeringConnectionId: VpcPeeringConnectionId;
  }
  export interface DeleteVpcPeeringConnectionResult {
    /**
     * Returns true if the request succeeds; otherwise, it returns an error.
     */
    Return?: Boolean;
  }
  export interface DeleteVpcRequest {
    /**
     * The ID of the VPC.
     */
    VpcId: VpcId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteVpnConnectionRequest {
    /**
     * The ID of the VPN connection.
     */
    VpnConnectionId: VpnConnectionId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeleteVpnConnectionRouteRequest {
    /**
     * The CIDR block associated with the local subnet of the customer network.
     */
    DestinationCidrBlock: String;
    /**
     * The ID of the VPN connection.
     */
    VpnConnectionId: VpnConnectionId;
  }
  export interface DeleteVpnGatewayRequest {
    /**
     * The ID of the virtual private gateway.
     */
    VpnGatewayId: VpnGatewayId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeprovisionByoipCidrRequest {
    /**
     * The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.
     */
    Cidr: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeprovisionByoipCidrResult {
    /**
     * Information about the address range.
     */
    ByoipCidr?: ByoipCidr;
  }
  export interface DeprovisionIpamPoolCidrRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the pool that has the CIDR you want to deprovision.
     */
    IpamPoolId: IpamPoolId;
    /**
     * The CIDR which you want to deprovision from the pool.
     */
    Cidr?: String;
  }
  export interface DeprovisionIpamPoolCidrResult {
    /**
     * The deprovisioned pool CIDR.
     */
    IpamPoolCidr?: IpamPoolCidr;
  }
  export interface DeprovisionPublicIpv4PoolCidrRequest {
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The ID of the pool that you want to deprovision the CIDR from.
     */
    PoolId: Ipv4PoolEc2Id;
    /**
     * The CIDR you want to deprovision from the pool.
     */
    Cidr: String;
  }
  export interface DeprovisionPublicIpv4PoolCidrResult {
    /**
     * The ID of the pool that you deprovisioned the CIDR from.
     */
    PoolId?: Ipv4PoolEc2Id;
    /**
     * The deprovisioned CIDRs.
     */
    DeprovisionedAddresses?: DeprovisionedAddressSet;
  }
  export type DeprovisionedAddressSet = String[];
  export interface DeregisterImageRequest {
    /**
     * The ID of the AMI.
     */
    ImageId: ImageId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeregisterInstanceEventNotificationAttributesRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * Information about the tag keys to deregister.
     */
    InstanceTagAttribute?: DeregisterInstanceTagAttributeRequest;
  }
  export interface DeregisterInstanceEventNotificationAttributesResult {
    /**
     * The resulting set of tag keys.
     */
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
  }
  export interface DeregisterInstanceTagAttributeRequest {
    /**
     * Indicates whether to deregister all tag keys in the current Region. Specify false to deregister all tag keys.
     */
    IncludeAllTagsOfInstance?: Boolean;
    /**
     * Information about the tag keys to deregister.
     */
    InstanceTagKeys?: InstanceTagKeySet;
  }
  export interface DeregisterTransitGatewayMulticastGroupMembersRequest {
    /**
     * The ID of the transit gateway multicast domain.
     */
    TransitGatewayMulticastDomainId?: TransitGatewayMulticastDomainId;
    /**
     * The IP address assigned to the transit gateway multicast group.
     */
    GroupIpAddress?: String;
    /**
     * The IDs of the group members' network interfaces.
     */
    NetworkInterfaceIds?: TransitGatewayNetworkInterfaceIdList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeregisterTransitGatewayMulticastGroupMembersResult {
    /**
     * Information about the deregistered members.
     */
    DeregisteredMulticastGroupMembers?: TransitGatewayMulticastDeregisteredGroupMembers;
  }
  export interface DeregisterTransitGatewayMulticastGroupSourcesRequest {
    /**
     * The ID of the transit gateway multicast domain.
     */
    TransitGatewayMulticastDomainId?: TransitGatewayMulticastDomainId;
    /**
     * The IP address assigned to the transit gateway multicast group.
     */
    GroupIpAddress?: String;
    /**
     * The IDs of the group sources' network interfaces.
     */
    NetworkInterfaceIds?: TransitGatewayNetworkInterfaceIdList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DeregisterTransitGatewayMulticastGroupSourcesResult {
    /**
     * Information about the deregistered group sources.
     */
    DeregisteredMulticastGroupSources?: TransitGatewayMulticastDeregisteredGroupSources;
  }
  export interface DescribeAccountAttributesRequest {
    /**
     * The account attribute names.
     */
    AttributeNames?: AccountAttributeNameStringList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeAccountAttributesResult {
    /**
     * Information about the account attributes.
     */
    AccountAttributes?: AccountAttributeList;
  }
  export type DescribeAddressTransfersMaxResults = number;
  export interface DescribeAddressTransfersRequest {
    /**
     * The allocation IDs of Elastic IP addresses.
     */
    AllocationIds?: AllocationIdList;
    /**
     * Specify the pagination token from a previous request to retrieve the next page of results.
     */
    NextToken?: String;
    /**
     * The maximum number of address transfers to return in one page of results.
     */
    MaxResults?: DescribeAddressTransfersMaxResults;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeAddressTransfersResult {
    /**
     * The Elastic IP address transfer.
     */
    AddressTransfers?: AddressTransferList;
    /**
     * Specify the pagination token from a previous request to retrieve the next page of results.
     */
    NextToken?: String;
  }
  export interface DescribeAddressesAttributeRequest {
    /**
     * [EC2-VPC] The allocation IDs.
     */
    AllocationIds?: AllocationIds;
    /**
     * The attribute of the IP address.
     */
    Attribute?: AddressAttributeName;
    /**
     * The token for the next page of results.
     */
    NextToken?: NextToken;
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.
     */
    MaxResults?: AddressMaxResults;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeAddressesAttributeResult {
    /**
     * Information about the IP addresses.
     */
    Addresses?: AddressSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: NextToken;
  }
  export interface DescribeAddressesRequest {
    /**
     * One or more filters. Filter names and values are case-sensitive.    allocation-id - [EC2-VPC] The allocation ID for the address.    association-id - [EC2-VPC] The association ID for the address.    domain - Indicates whether the address is for use in EC2-Classic (standard) or in a VPC (vpc).    instance-id - The ID of the instance the address is associated with, if any.    network-border-group - A unique set of Availability Zones, Local Zones, or Wavelength Zones from where Amazon Web Services advertises IP addresses.     network-interface-id - [EC2-VPC] The ID of the network interface that the address is associated with, if any.    network-interface-owner-id - The Amazon Web Services account ID of the owner.    private-ip-address - [EC2-VPC] The private IP address associated with the Elastic IP address.    public-ip - The Elastic IP address, or the carrier IP address.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  
     */
    Filters?: FilterList;
    /**
     * One or more Elastic IP addresses. Default: Describes all your Elastic IP addresses.
     */
    PublicIps?: PublicIpStringList;
    /**
     * [EC2-VPC] Information about the allocation IDs.
     */
    AllocationIds?: AllocationIdList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeAddressesResult {
    /**
     * Information about the Elastic IP addresses.
     */
    Addresses?: AddressList;
  }
  export interface DescribeAggregateIdFormatRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeAggregateIdFormatResult {
    /**
     * Indicates whether all resource types in the Region are configured to use longer IDs. This value is only true if all users are configured to use longer IDs for all resources types in the Region.
     */
    UseLongIdsAggregated?: Boolean;
    /**
     * Information about each resource's ID format.
     */
    Statuses?: IdFormatList;
  }
  export interface DescribeAvailabilityZonesRequest {
    /**
     * The filters.    group-name - For Availability Zones, use the Region name. For Local Zones, use the name of the group associated with the Local Zone (for example, us-west-2-lax-1) For Wavelength Zones, use the name of the group associated with the Wavelength Zone (for example, us-east-1-wl1-bos-wlz-1).    message - The Zone message.    opt-in-status - The opt-in status (opted-in, and not-opted-in | opt-in-not-required).    parent-zoneID - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.    parent-zoneName - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.    region-name - The name of the Region for the Zone (for example, us-east-1).    state - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (available).    zone-id - The ID of the Availability Zone (for example, use1-az1), the Local Zone (for example, usw2-lax1-az1), or the Wavelength Zone (for example, us-east-1-wl1-bos-wlz-1).    zone-type - The type of zone, for example, local-zone.    zone-name - The name of the Availability Zone (for example, us-east-1a), the Local Zone (for example, us-west-2-lax-1a), or the Wavelength Zone (for example, us-east-1-wl1-bos-wlz-1).    zone-type - The type of zone, for example, local-zone.  
     */
    Filters?: FilterList;
    /**
     * The names of the Availability Zones, Local Zones, and Wavelength Zones.
     */
    ZoneNames?: ZoneNameStringList;
    /**
     * The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
     */
    ZoneIds?: ZoneIdStringList;
    /**
     * Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status. If you do not use this parameter, the results include only the zones for the Regions where you have chosen the option to opt in.
     */
    AllAvailabilityZones?: Boolean;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeAvailabilityZonesResult {
    /**
     * Information about the Availability Zones, Local Zones, and Wavelength Zones.
     */
    AvailabilityZones?: AvailabilityZoneList;
  }
  export interface DescribeBundleTasksRequest {
    /**
     * The bundle task IDs. Default: Describes all your bundle tasks.
     */
    BundleIds?: BundleIdStringList;
    /**
     * The filters.    bundle-id - The ID of the bundle task.    error-code - If the task failed, the error code returned.    error-message - If the task failed, the error message returned.    instance-id - The ID of the instance.    progress - The level of task completion, as a percentage (for example, 20%).    s3-bucket - The Amazon S3 bucket to store the AMI.    s3-prefix - The beginning of the AMI name.    start-time - The time the task started (for example, 2013-09-15T17:15:20.000Z).    state - The state of the task (pending | waiting-for-shutdown | bundling | storing | cancelling | complete | failed).    update-time - The time of the most recent update for the task.  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeBundleTasksResult {
    /**
     * Information about the bundle tasks.
     */
    BundleTasks?: BundleTaskList;
  }
  export type DescribeByoipCidrsMaxResults = number;
  export interface DescribeByoipCidrsRequest {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.
     */
    MaxResults: DescribeByoipCidrsMaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: NextToken;
  }
  export interface DescribeByoipCidrsResult {
    /**
     * Information about your address ranges.
     */
    ByoipCidrs?: ByoipCidrSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: String;
  }
  export type DescribeCapacityReservationFleetsMaxResults = number;
  export interface DescribeCapacityReservationFleetsRequest {
    /**
     * The IDs of the Capacity Reservation Fleets to describe.
     */
    CapacityReservationFleetIds?: CapacityReservationFleetIdSet;
    /**
     * The token to use to retrieve the next page of results.
     */
    NextToken?: String;
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
     */
    MaxResults?: DescribeCapacityReservationFleetsMaxResults;
    /**
     * One or more filters.    state - The state of the Fleet (submitted | modifying | active | partially_fulfilled | expiring | expired | cancelling | cancelled | failed).    instance-match-criteria - The instance matching criteria for the Fleet. Only open is supported.    tenancy - The tenancy of the Fleet (default | dedicated).    allocation-strategy - The allocation strategy used by the Fleet. Only prioritized is supported.  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeCapacityReservationFleetsResult {
    /**
     * Information about the Capacity Reservation Fleets.
     */
    CapacityReservationFleets?: CapacityReservationFleetSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: String;
  }
  export type DescribeCapacityReservationsMaxResults = number;
  export interface DescribeCapacityReservationsRequest {
    /**
     * The ID of the Capacity Reservation.
     */
    CapacityReservationIds?: CapacityReservationIdSet;
    /**
     * The token to use to retrieve the next page of results.
     */
    NextToken?: String;
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
     */
    MaxResults?: DescribeCapacityReservationsMaxResults;
    /**
     * One or more filters.    instance-type - The type of instance for which the Capacity Reservation reserves capacity.    owner-id - The ID of the Amazon Web Services account that owns the Capacity Reservation.    instance-platform - The type of operating system for which the Capacity Reservation reserves capacity.    availability-zone - The Availability Zone of the Capacity Reservation.    tenancy - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:    default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.    dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.      outpost-arn - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.    state - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:    active- The Capacity Reservation is active and the capacity is available for your use.    expired - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.    cancelled - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.    pending - The Capacity Reservation request was successful but the capacity provisioning is still pending.    failed - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.      start-date - The date and time at which the Capacity Reservation was started.    end-date - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.    end-date-type - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:    unlimited - The Capacity Reservation remains active until you explicitly cancel it.    limited - The Capacity Reservation expires automatically at a specified date and time.      instance-match-criteria - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:    open - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.    targeted - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.      placement-group-arn - The ARN of the cluster placement group in which the Capacity Reservation was created.  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeCapacityReservationsResult {
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: String;
    /**
     * Information about the Capacity Reservations.
     */
    CapacityReservations?: CapacityReservationSet;
  }
  export interface DescribeCarrierGatewaysRequest {
    /**
     * One or more carrier gateway IDs.
     */
    CarrierGatewayIds?: CarrierGatewayIdSet;
    /**
     * One or more filters.    carrier-gateway-id - The ID of the carrier gateway.    state - The state of the carrier gateway (pending | failed | available | deleting | deleted).    owner-id - The Amazon Web Services account ID of the owner of the carrier gateway.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    vpc-id - The ID of the VPC associated with the carrier gateway.  
     */
    Filters?: FilterList;
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.
     */
    MaxResults?: CarrierGatewayMaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeCarrierGatewaysResult {
    /**
     * Information about the carrier gateway.
     */
    CarrierGateways?: CarrierGatewaySet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: String;
  }
  export type DescribeClassicLinkInstancesMaxResults = number;
  export interface DescribeClassicLinkInstancesRequest {
    /**
     * One or more filters.    group-id - The ID of a VPC security group that's associated with the instance.    instance-id - The ID of the instance.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    vpc-id - The ID of the VPC to which the instance is linked.  vpc-id - The ID of the VPC that the instance is linked to.  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
     */
    InstanceIds?: InstanceIdStringList;
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Constraint: If the value is greater than 1000, we return only 1000 items.
     */
    MaxResults?: DescribeClassicLinkInstancesMaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface DescribeClassicLinkInstancesResult {
    /**
     * Information about one or more linked EC2-Classic instances.
     */
    Instances?: ClassicLinkInstanceList;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: String;
  }
  export type DescribeClientVpnAuthorizationRulesMaxResults = number;
  export interface DescribeClientVpnAuthorizationRulesRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
    /**
     * The token to retrieve the next page of results.
     */
    NextToken?: NextToken;
    /**
     * One or more filters. Filter names and values are case-sensitive.    description - The description of the authorization rule.    destination-cidr - The CIDR of the network to which the authorization rule applies.    group-id - The ID of the Active Directory group to which the authorization rule grants access.  
     */
    Filters?: FilterList;
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.
     */
    MaxResults?: DescribeClientVpnAuthorizationRulesMaxResults;
  }
  export interface DescribeClientVpnAuthorizationRulesResult {
    /**
     * Information about the authorization rules.
     */
    AuthorizationRules?: AuthorizationRuleSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: NextToken;
  }
  export type DescribeClientVpnConnectionsMaxResults = number;
  export interface DescribeClientVpnConnectionsRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * One or more filters. Filter names and values are case-sensitive.    connection-id - The ID of the connection.    username - For Active Directory client authentication, the user name of the client who established the client connection.  
     */
    Filters?: FilterList;
    /**
     * The token to retrieve the next page of results.
     */
    NextToken?: NextToken;
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.
     */
    MaxResults?: DescribeClientVpnConnectionsMaxResults;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeClientVpnConnectionsResult {
    /**
     * Information about the active and terminated client connections.
     */
    Connections?: ClientVpnConnectionSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: NextToken;
  }
  export type DescribeClientVpnEndpointMaxResults = number;
  export interface DescribeClientVpnEndpointsRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointIds?: ClientVpnEndpointIdList;
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.
     */
    MaxResults?: DescribeClientVpnEndpointMaxResults;
    /**
     * The token to retrieve the next page of results.
     */
    NextToken?: NextToken;
    /**
     * One or more filters. Filter names and values are case-sensitive.    endpoint-id - The ID of the Client VPN endpoint.    transport-protocol - The transport protocol (tcp | udp).  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeClientVpnEndpointsResult {
    /**
     * Information about the Client VPN endpoints.
     */
    ClientVpnEndpoints?: EndpointSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: NextToken;
  }
  export type DescribeClientVpnRoutesMaxResults = number;
  export interface DescribeClientVpnRoutesRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * One or more filters. Filter names and values are case-sensitive.    destination-cidr - The CIDR of the route destination.    origin - How the route was associated with the Client VPN endpoint (associate | add-route).    target-subnet - The ID of the subnet through which traffic is routed.  
     */
    Filters?: FilterList;
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.
     */
    MaxResults?: DescribeClientVpnRoutesMaxResults;
    /**
     * The token to retrieve the next page of results.
     */
    NextToken?: NextToken;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeClientVpnRoutesResult {
    /**
     * Information about the Client VPN endpoint routes.
     */
    Routes?: ClientVpnRouteSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: NextToken;
  }
  export type DescribeClientVpnTargetNetworksMaxResults = number;
  export interface DescribeClientVpnTargetNetworksRequest {
    /**
     * The ID of the Client VPN endpoint.
     */
    ClientVpnEndpointId: ClientVpnEndpointId;
    /**
     * The IDs of the target network associations.
     */
    AssociationIds?: ValueStringList;
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.
     */
    MaxResults?: DescribeClientVpnTargetNetworksMaxResults;
    /**
     * The token to retrieve the next page of results.
     */
    NextToken?: NextToken;
    /**
     * One or more filters. Filter names and values are case-sensitive.    association-id - The ID of the association.    target-network-id - The ID of the subnet specified as the target network.    vpc-id - The ID of the VPC in which the target network is located.  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeClientVpnTargetNetworksResult {
    /**
     * Information about the associated target networks.
     */
    ClientVpnTargetNetworks?: TargetNetworkSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: NextToken;
  }
  export interface DescribeCoipPoolsRequest {
    /**
     * The IDs of the address pools.
     */
    PoolIds?: CoipPoolIdSet;
    /**
     * One or more filters.    coip-pool.local-gateway-route-table-id - The ID of the local gateway route table.    coip-pool.pool-id - The ID of the address pool.  
     */
    Filters?: FilterList;
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.
     */
    MaxResults?: CoipPoolMaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeCoipPoolsResult {
    /**
     * Information about the address pools.
     */
    CoipPools?: CoipPoolSet;
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    NextToken?: String;
  }
  export type DescribeConversionTaskList = ConversionTask[];
  export interface DescribeConversionTasksRequest {
    /**
     * The conversion task IDs.
     */
    ConversionTaskIds?: ConversionIdStringList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeConversionTasksResult {
    /**
     * Information about the conversion tasks.
     */
    ConversionTasks?: DescribeConversionTaskList;
  }
  export interface DescribeCustomerGatewaysRequest {
    /**
     * One or more customer gateway IDs. Default: Describes all your customer gateways.
     */
    CustomerGatewayIds?: CustomerGatewayIdStringList;
    /**
     * One or more filters.    bgp-asn - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).    customer-gateway-id - The ID of the customer gateway.    ip-address - The IP address of the customer gateway device's external interface.    state - The state of the customer gateway (pending | available | deleting | deleted).    type - The type of customer gateway. Currently, the only supported type is ipsec.1.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    DryRun?: Boolean;
  }
  export interface DescribeCustomerGatewaysResult {
    /**
     * Information about one or more customer gateways.
     */
    CustomerGateways?: CustomerGatewayList;
  }
  export type DescribeDhcpOptionsMaxResults = number;
  export interface DescribeDhcpOptionsRequest {
    /**
     * The IDs of one or more DHCP options sets. Default: Describes all your DHCP options sets.
     */
    DhcpOptionsIds?: DhcpOptionsIdStringList;
    /**
     * One or more filters.    dhcp-options-id - The ID of a DHCP options set.    key - The key for one of the options (for example, domain-name).    value - The value for one of the options.    owner-id - The ID of the Amazon Web Services account that owns the DHCP options set.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  
     */
    Filters?: FilterList;
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperatio