"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRepository = exports.toJson_SourceDefinition = exports.toJson_TemplateDefinition = exports.toJson_PagesDefinition = exports.toJson_CfnRepositoryProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnRepositoryProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnRepositoryProps(obj) {
    var _b, _c, _d;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AllowMergeCommit': obj.allowMergeCommit,
        'AllowRebaseMerge': obj.allowRebaseMerge,
        'AllowSquashMerge': obj.allowSquashMerge,
        'ArchiveOnDestroy': obj.archiveOnDestroy,
        'Archived': obj.archived,
        'AutoInit': obj.autoInit,
        'DefaultBranch': obj.defaultBranch,
        'DeleteBranchOnMerge': obj.deleteBranchOnMerge,
        'Description': obj.description,
        'GitignoreTemplate': obj.gitignoreTemplate,
        'HasDownloads': obj.hasDownloads,
        'HasIssues': obj.hasIssues,
        'HasProjects': obj.hasProjects,
        'HasWiki': obj.hasWiki,
        'HomepageUrl': obj.homepageUrl,
        'IsTemplate': obj.isTemplate,
        'LicenseTemplate': obj.licenseTemplate,
        'Name': obj.name,
        'Private': obj.private,
        'Topics': (_b = obj.topics) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'Visibility': obj.visibility,
        'VulnerabilityAlerts': obj.vulnerabilityAlerts,
        'Pages': (_c = obj.pages) === null || _c === void 0 ? void 0 : _c.map(y => toJson_PagesDefinition(y)),
        'Template': (_d = obj.template) === null || _d === void 0 ? void 0 : _d.map(y => toJson_TemplateDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnRepositoryProps = toJson_CfnRepositoryProps;
/**
 * Converts an object of type 'PagesDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_PagesDefinition(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Cname': obj.cname,
        'Source': (_b = obj.source) === null || _b === void 0 ? void 0 : _b.map(y => toJson_SourceDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_PagesDefinition = toJson_PagesDefinition;
/**
 * Converts an object of type 'TemplateDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TemplateDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Owner': obj.owner,
        'Repository': obj.repository,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TemplateDefinition = toJson_TemplateDefinition;
/**
 * Converts an object of type 'SourceDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SourceDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Branch': obj.branch,
        'Path': obj.path,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SourceDefinition = toJson_SourceDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::GitHub::Repository`
 *
 * @cloudformationResource TF::GitHub::Repository
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnRepository extends cdk.CfnResource {
    /**
     * Create a new `TF::GitHub::Repository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRepository.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnRepositoryProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrEtag = cdk.Token.asString(this.getAtt('Etag'));
        this.attrFullName = cdk.Token.asString(this.getAtt('FullName'));
        this.attrGitCloneUrl = cdk.Token.asString(this.getAtt('GitCloneUrl'));
        this.attrHtmlUrl = cdk.Token.asString(this.getAtt('HtmlUrl'));
        this.attrHttpCloneUrl = cdk.Token.asString(this.getAtt('HttpCloneUrl'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrNodeId = cdk.Token.asString(this.getAtt('NodeId'));
        this.attrRepoId = cdk.Token.asNumber(this.getAtt('RepoId'));
        this.attrSshCloneUrl = cdk.Token.asString(this.getAtt('SshCloneUrl'));
        this.attrSvnUrl = cdk.Token.asString(this.getAtt('SvnUrl'));
    }
}
exports.CfnRepository = CfnRepository;
_a = JSII_RTTI_SYMBOL_1;
CfnRepository[_a] = { fqn: "@cdk-cloudformation/tf-github-repository.CfnRepository", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnRepository.CFN_RESOURCE_TYPE_NAME = "TF::GitHub::Repository";
//# sourceMappingURL=data:application/json;base64,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