from telegram import InlineKeyboardButton


def build_menu(buttons,
               n_cols,
               header_buttons=None,
               footer_buttons=None):
    menu = [buttons[i:i + n_cols] for i in range(0, len(buttons), n_cols)]
    if header_buttons:
        menu.insert(0, [header_buttons])
    if footer_buttons:
        menu.append(footer_buttons)
    return menu


def accept_build_menu(buttons, n_cols):
    accept = InlineKeyboardButton("Accept", callback_data="accept")
    cancel = InlineKeyboardButton("Cancel", callback_data="cancel")
    return build_menu(buttons, n_cols, footer_buttons=[accept, cancel])
