__copyright__ = "Copyright (c) 2021"
__author__ = "Rakha Asyrofi"
__date__ = "2021-10-08:18:07:39"

# -*- coding: utf-8 -*-
"""modul_relasi.ipynb
Author Rakha Asyrofi / 05111950010038

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1h6HKNeALV8bXjrxWB0Jn0ztHtLv2cXz8
"""



"""# Modul2: parsing aksi dan aktor"""

import pandas as pd
from tabulate import tabulate
import spacy
from spacy.lang.en import English
from spacy.tokenizer import Tokenizer
from tqdm.auto import tqdm
from time import time, sleep

# template class parsingRequirement
class parsingRequirement:

    # inisialisasi
    def __init__(self, filename):
    	self.namaFile = filename

    def progressBar(self, data):
        pbar = tqdm(iterable= range(0, len(data)), leave= False, desc= 'loading..', unit= 'synsets')
        for i in pbar:
            sleep(0.1)
            pbar.update(1)
        return pbar.close()
    
    def progressDf(self, data):
      return data.groupby('id').progress_apply(lambda x: x)

    #fungsi parse tree elemen
    def membacaCSV(self):
      try: 
        modul_pembacaan = pd.read_csv(self.namaFile, delimiter= ',')
        return modul_pembacaan
      except OSError as err:
        print("OS error: {0}".format(err))

    def clean_text(self, raw_text):
      try:
        nlp = spacy.load("en_core_web_sm")
        doc = nlp(raw_text)
        lemma_list = [num.lemma_.lower() for num in doc
                      if num.is_stop is False and num.is_punct is False and num.is_alpha is True]
        joined_words = ( " ".join(lemma_list))
        return joined_words
      except OSError as err:
        print("OS error: {0}".format(err))

    # cleaning text
    def apply_cleaning_function_to_list(self, X):
      try:
        cleaned_X = [parsingRequirement.clean_text(self, element)for element in X]
        parsingRequirement.progressBar(self, cleaned_X)
        return cleaned_X
      except OSError as err:
        print("OS error: {0}".format(err))


    def data_raw(self, data_raw): # get data raw
        dt =  [num2 for num in data_raw.fillna('empty') for num1 in num.split(';') for num2 in num1.split('.') 
              if 'Submitter' in num2 or 'Viewer' in num2 or 'system' in num2 or 'actor' in num2 or 'empty' in num2]
        parsingRequirement.progressBar(self, dt)
        return dt

    def aksi_aktor(self, data): # get data aksi dan aktor
      try:
        nlp = English()
        tokenizer = Tokenizer(nlp.vocab)
        tokens = tokenizer(data)
        a = [token.text.lower() for token in tokens]
        b = [x for x in a if x == 'submitter' or x == 'Submitter' or x == 'viewer' or  x == 'Viewer' or x == 'system' or x == 'actor']  
        b1 = ";".join(b)
        b1 = b1.replace("actor", "submitter; viewer")
        c = [x for x in a if x != 'submitter' and x != 'Submitter' and x != 'viewer' and x != 'Viewer' and x != 'system' and x != 'actor']  
        c1 = " ".join(c)
        return b1, c1        
      except OSError as err:
        print("OS error: {0}".format(err))

    def __del__(self):
        print ('Destructor called.')

if __name__ == "__main__":
  try:

    # parsing functional
    t0 = time()
    MyParsingRequirement = parsingRequirement(filename= "freqs_researcher.txt")
    freqs = MyParsingRequirement.membacaCSV()
    data_freqs = MyParsingRequirement.data_raw(freqs.requirement)
    cleaned_freq = MyParsingRequirement.apply_cleaning_function_to_list(data_freqs)
    freqs['aksi'] = [MyParsingRequirement.aksi_aktor(num)[1] for num in cleaned_freq]
    freqs['aktor'] = [MyParsingRequirement.aksi_aktor(num)[0] for num in cleaned_freq]
    tqdm.pandas(desc="freq process")
    MyParsingRequirement.progressDf(freqs)
    print(tabulate(freqs, headers = 'keys', tablefmt = 'psql'))

    # parsing ucd1
    MyParsingRequirement = parsingRequirement(filename= "researcher_insert_metadata.txt")
    ucd1 = MyParsingRequirement.membacaCSV()
    data_ucd1 = MyParsingRequirement.data_raw(ucd1.flowOfEvents)

    list_index= [("data{}".format(idx)) for idx, num in enumerate(data_ucd1)]
    data_list = pd.DataFrame(data_ucd1, index= list_index)
    data_list = data_list.drop(index= "data5").reset_index().drop(labels= ['index'], axis= 1)
    # data_list = data_list.reset_index().drop(labels= ['index'], axis= 1)
    ucd1['aksi'] = data_list

    cleaned1_ucd = MyParsingRequirement.apply_cleaning_function_to_list(list(ucd1.aksi))
    ucd1['aksi'] = [MyParsingRequirement.aksi_aktor(num)[1] for num in cleaned1_ucd]
    ucd1['aktor'] = [MyParsingRequirement.aksi_aktor(num)[0] for num in cleaned1_ucd]
    tqdm.pandas(desc="ucd1 process")
    MyParsingRequirement.progressDf(ucd1)
    print(tabulate(ucd1, headers = 'keys', tablefmt = 'psql'))

    # parsing ucd2
    MyParsingRequirement = parsingRequirement(filename= "researcher_search_researcher.txt")
    ucd2 = MyParsingRequirement.membacaCSV()
    data_ucd2 = MyParsingRequirement.data_raw(ucd2.flowOfEvents)

    list2_index= [("data{}".format(idx)) for idx, num in enumerate(data_ucd2)]
    data2_list = pd.DataFrame(data_ucd2, index= list2_index)
    data2_list = data2_list.reset_index().drop(labels= ['index'], axis= 1)
    ucd2['aksi'] = data2_list

    cleaned2_ucd = MyParsingRequirement.apply_cleaning_function_to_list(list(ucd2.aksi))
    ucd2['aksi'] = [MyParsingRequirement.aksi_aktor(num)[1] for num in cleaned2_ucd]
    ucd2['aktor'] = [MyParsingRequirement.aksi_aktor(num)[0] for num in cleaned2_ucd]
    tqdm.pandas(desc="ucd2 process")
    MyParsingRequirement.progressDf(ucd2)
    print(tabulate(ucd2, headers = 'keys', tablefmt = 'psql'))
    
    print("done in %0.3fs." % (time() - t0))
    input('Press ENTER to exit') 

  except OSError as err:
      print("OS error: {0}".format(err))