"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginAccessIdentity = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const cloudfront_generated_1 = require("./cloudfront.generated");
class OriginAccessIdentityBase extends cdk.Resource {
    /**
     * The ARN to include in S3 bucket policy to allow CloudFront access
     */
    arn() {
        return cdk.Stack.of(this).formatArn({
            service: 'iam',
            region: '',
            account: 'cloudfront',
            resource: 'user',
            resourceName: `CloudFront Origin Access Identity ${this.originAccessIdentityName}`,
        });
    }
}
/**
 * An origin access identity is a special CloudFront user that you can
 * associate with Amazon S3 origins, so that you can secure all or just some of
 * your Amazon S3 content.
 *
 * @resource AWS::CloudFront::CloudFrontOriginAccessIdentity
 */
class OriginAccessIdentity extends OriginAccessIdentityBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_OriginAccessIdentityProps(props);
        // Comment has a max length of 128.
        const comment = ((_b = props === null || props === void 0 ? void 0 : props.comment) !== null && _b !== void 0 ? _b : 'Allows CloudFront to reach the bucket').substr(0, 128);
        this.resource = new cloudfront_generated_1.CfnCloudFrontOriginAccessIdentity(this, 'Resource', {
            cloudFrontOriginAccessIdentityConfig: { comment },
        });
        // physical id - OAI name
        this.originAccessIdentityName = this.getResourceNameAttribute(this.resource.ref);
        // Canonical user to grant access to in the S3 Bucket Policy
        this.cloudFrontOriginAccessIdentityS3CanonicalUserId = this.resource.attrS3CanonicalUserId;
        // The principal for must be either the canonical user or a special ARN
        // with the CloudFront Origin Access Id (see `arn()` method). For
        // import/export the OAI is anyway required so the principal is constructed
        // with it. But for the normal case the S3 Canonical User as a nicer
        // interface and does not require constructing the ARN.
        this.grantPrincipal = new iam.CanonicalUserPrincipal(this.cloudFrontOriginAccessIdentityS3CanonicalUserId);
    }
    /**
     * Creates a OriginAccessIdentity by providing the OriginAccessIdentityName
     */
    static fromOriginAccessIdentityName(scope, id, originAccessIdentityName) {
        class Import extends OriginAccessIdentityBase {
            constructor(s, i) {
                super(s, i, { physicalName: originAccessIdentityName });
                this.originAccessIdentityName = originAccessIdentityName;
                this.grantPrincipal = new iam.ArnPrincipal(this.arn());
            }
        }
        return new Import(scope, id);
    }
}
exports.OriginAccessIdentity = OriginAccessIdentity;
_a = JSII_RTTI_SYMBOL_1;
OriginAccessIdentity[_a] = { fqn: "@aws-cdk/aws-cloudfront.OriginAccessIdentity", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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