# Generated by Django 3.1.7 on 2021-03-04 11:16

import asymmetric_jwt_auth.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('asymmetric_jwt_auth', '0004_auto_20191104_1628'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='publickey',
            options={'verbose_name': 'Public Key', 'verbose_name_plural': 'Public Keys'},
        ),
        migrations.AlterField(
            model_name='publickey',
            name='comment',
            field=models.CharField(blank=True, help_text='Comment describing this key', max_length=100, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='publickey',
            name='key',
            field=models.TextField(help_text="The user's RSA public key", validators=[asymmetric_jwt_auth.models.validate_public_key], verbose_name='Public Key'),
        ),
        migrations.AlterField(
            model_name='publickey',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='public_keys', to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.CreateModel(
            name='JWKSEndpointTrust',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jwks_url', models.URLField(help_text='e.g. https://dev-87evx9ru.auth0.com/.well-known/jwks.json', verbose_name='JSON Web Key Set (JWKS) URL')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='jwks_endpoint', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'JSON Web Key Set',
                'verbose_name_plural': 'JSON Web Key Sets',
            },
        ),
    ]
