# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/config/v2/transaction/types.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


class State(betterproto.Enum):
    """State is the state of a phase"""

    # PENDING indicates the phase is pending
    PENDING = 0
    # COMPLETE indicates the phase is complete
    COMPLETE = 2
    # FAILED indicates the phase failed
    FAILED = 3


class Phase(betterproto.Enum):
    """Phase is the phase of a Transaction"""

    # CHANGE indicates the transaction has been requested
    CHANGE = 0
    # ROLLBACK indicates a rollback has been requested for the transaction
    ROLLBACK = 1


class Reason(betterproto.Enum):
    """Reason is a reason for a FAILED state"""

    # NONE indicates no error has occurred
    NONE = 0
    # ERROR indicates an error occurred when applying the change
    ERROR = 1


@dataclass(eq=False, repr=False)
class Transaction(betterproto.Message):
    """Transaction refers to a multi-target transactional change"""

    # 'id' is the unique identifier of the transaction This field should be set
    # prior to persisting the object.
    id: str = betterproto.string_field(1)
    # 'index' is a monotonically increasing, globally unique index of the change
    # The index is provided by the store, is static and unique for each unique
    # change identifier, and should not be modified by client code.
    index: int = betterproto.uint64_field(2)
    # 'revision' is the change revision number The revision number is provided by
    # the store and should not be modified by client code. Each unique state of
    # the change will be assigned a unique revision number which can be used for
    # optimistic concurrency control when updating or deleting the change state.
    revision: int = betterproto.uint64_field(3)
    # 'status' is the current lifecycle status of the transaction
    status: "Status" = betterproto.message_field(4)
    # 'created' is the time at which the transaction was created
    created: datetime = betterproto.message_field(5)
    # 'updated' is the time at which the transaction was last updated
    updated: datetime = betterproto.message_field(6)
    # 'changes' is a set of changes to apply to targets The list of changes
    # should contain only a single change per target/version pair.
    changes: List["Change"] = betterproto.message_field(7)
    # 'deleted' is a flag indicating whether this transaction is being deleted by
    # a snapshot
    deleted: bool = betterproto.bool_field(9)
    # 'dependency' is a reference to the transaction on which this transaction is
    # dependent
    dependency: "TransactionRef" = betterproto.message_field(10)
    # 'dependents' is a list of references to transactions that depend on this
    # transaction
    dependents: List["TransactionRef"] = betterproto.message_field(11)
    # 'username' is the name of the user that made the transaction
    username: str = betterproto.string_field(12)


@dataclass(eq=False, repr=False)
class TransactionRef(betterproto.Message):
    """TransactionRef is a reference to a transaction"""

    none: "betterproto_lib_google_protobuf.Empty" = betterproto.message_field(
        1, group="id"
    )
    transaction_id: str = betterproto.string_field(2, group="id")


@dataclass(eq=False, repr=False)
class Change(betterproto.Message):
    """Change represents a configuration change to a single target"""

    # 'target_id' is the identifier of the target to which this change applies
    target_id: str = betterproto.string_field(1)
    # 'target_version' is an optional target version to which to apply this
    # change
    target_version: str = betterproto.string_field(2)
    # 'target_type' is an optional target type to which to apply this change
    target_type: str = betterproto.string_field(3)
    # 'values' is a set of change values to apply
    values: List["ChangeValue"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ChangeValue(betterproto.Message):
    """
    ChangeValue is an individual Path/Value and removed flag combination in a
    Change
    """

    # 'path' is the path to change
    path: str = betterproto.string_field(1)
    # 'value' is the change value
    value: "__v2__.TypedValue" = betterproto.message_field(2)
    # 'removed' indicates whether this is a delete
    removed: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class Status(betterproto.Message):
    """Status is the status of a Transaction"""

    # 'phase' is the current phase of the
    phase: "Phase" = betterproto.enum_field(1)
    # 'state' is the state of the transaction within a Phase
    state: "State" = betterproto.enum_field(2)
    # 'reason' is a failure reason
    reason: "Reason" = betterproto.enum_field(3)
    # message is a result message
    message: str = betterproto.string_field(4)
    # MastershipState mastership info
    mastership_state: "MastershipState" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class MastershipState(betterproto.Message):
    """Mastership state"""

    term: int = betterproto.uint64_field(1)
    node_id: str = betterproto.string_field(2)


from ... import v2 as __v2__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
