"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnProject = exports.toJson_ApiKeyDefinition = exports.toJson_CfnProjectProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnProjectProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnProjectProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'OrgId': obj.orgId,
        'ClusterCount': obj.clusterCount,
        'ApiKeys': toJson_ApiKeyDefinition(obj.apiKeys),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnProjectProps = toJson_CfnProjectProps;
/**
 * Converts an object of type 'ApiKeyDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ApiKeyDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'PublicKey': obj.publicKey,
        'PrivateKey': obj.privateKey,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ApiKeyDefinition = toJson_ApiKeyDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `MongoDB::Atlas::Project`
 *
 * @cloudformationResource MongoDB::Atlas::Project
 * @stability external
 * @link http://unknown-url
 */
class CfnProject extends cdk.CfnResource {
    /**
     * Create a new `MongoDB::Atlas::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnProject.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnProjectProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrCreated = cdk.Token.asString(this.getAtt('Created'));
    }
}
exports.CfnProject = CfnProject;
_a = JSII_RTTI_SYMBOL_1;
CfnProject[_a] = { fqn: "@cdk-cloudformation/mongodb-atlas-project.CfnProject", version: "1.6.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnProject.CFN_RESOURCE_TYPE_NAME = "MongoDB::Atlas::Project";
//# sourceMappingURL=data:application/json;base64,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