"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceMicrosoftTeams = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams gitlab_service_microsoft_teams}
*/
class ServiceMicrosoftTeams extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams gitlab_service_microsoft_teams} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceMicrosoftTeamsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_service_microsoft_teams',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._branchesToBeNotified = config.branchesToBeNotified;
        this._confidentialIssuesEvents = config.confidentialIssuesEvents;
        this._confidentialNoteEvents = config.confidentialNoteEvents;
        this._issuesEvents = config.issuesEvents;
        this._mergeRequestsEvents = config.mergeRequestsEvents;
        this._noteEvents = config.noteEvents;
        this._notifyOnlyBrokenPipelines = config.notifyOnlyBrokenPipelines;
        this._pipelineEvents = config.pipelineEvents;
        this._project = config.project;
        this._pushEvents = config.pushEvents;
        this._tagPushEvents = config.tagPushEvents;
        this._webhook = config.webhook;
        this._wikiPageEvents = config.wikiPageEvents;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // active - computed: true, optional: false, required: false
    get active() {
        return this.getBooleanAttribute('active');
    }
    get branchesToBeNotified() {
        return this.getStringAttribute('branches_to_be_notified');
    }
    set branchesToBeNotified(value) {
        this._branchesToBeNotified = value;
    }
    resetBranchesToBeNotified() {
        this._branchesToBeNotified = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchesToBeNotifiedInput() {
        return this._branchesToBeNotified;
    }
    get confidentialIssuesEvents() {
        return this.getBooleanAttribute('confidential_issues_events');
    }
    set confidentialIssuesEvents(value) {
        this._confidentialIssuesEvents = value;
    }
    resetConfidentialIssuesEvents() {
        this._confidentialIssuesEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialIssuesEventsInput() {
        return this._confidentialIssuesEvents;
    }
    get confidentialNoteEvents() {
        return this.getBooleanAttribute('confidential_note_events');
    }
    set confidentialNoteEvents(value) {
        this._confidentialNoteEvents = value;
    }
    resetConfidentialNoteEvents() {
        this._confidentialNoteEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialNoteEventsInput() {
        return this._confidentialNoteEvents;
    }
    // created_at - computed: true, optional: false, required: false
    get createdAt() {
        return this.getStringAttribute('created_at');
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get issuesEvents() {
        return this.getBooleanAttribute('issues_events');
    }
    set issuesEvents(value) {
        this._issuesEvents = value;
    }
    resetIssuesEvents() {
        this._issuesEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEventsInput() {
        return this._issuesEvents;
    }
    get mergeRequestsEvents() {
        return this.getBooleanAttribute('merge_requests_events');
    }
    set mergeRequestsEvents(value) {
        this._mergeRequestsEvents = value;
    }
    resetMergeRequestsEvents() {
        this._mergeRequestsEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEventsInput() {
        return this._mergeRequestsEvents;
    }
    get noteEvents() {
        return this.getBooleanAttribute('note_events');
    }
    set noteEvents(value) {
        this._noteEvents = value;
    }
    resetNoteEvents() {
        this._noteEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noteEventsInput() {
        return this._noteEvents;
    }
    get notifyOnlyBrokenPipelines() {
        return this.getBooleanAttribute('notify_only_broken_pipelines');
    }
    set notifyOnlyBrokenPipelines(value) {
        this._notifyOnlyBrokenPipelines = value;
    }
    resetNotifyOnlyBrokenPipelines() {
        this._notifyOnlyBrokenPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyOnlyBrokenPipelinesInput() {
        return this._notifyOnlyBrokenPipelines;
    }
    get pipelineEvents() {
        return this.getBooleanAttribute('pipeline_events');
    }
    set pipelineEvents(value) {
        this._pipelineEvents = value;
    }
    resetPipelineEvents() {
        this._pipelineEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineEventsInput() {
        return this._pipelineEvents;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get pushEvents() {
        return this.getBooleanAttribute('push_events');
    }
    set pushEvents(value) {
        this._pushEvents = value;
    }
    resetPushEvents() {
        this._pushEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushEventsInput() {
        return this._pushEvents;
    }
    get tagPushEvents() {
        return this.getBooleanAttribute('tag_push_events');
    }
    set tagPushEvents(value) {
        this._tagPushEvents = value;
    }
    resetTagPushEvents() {
        this._tagPushEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagPushEventsInput() {
        return this._tagPushEvents;
    }
    // updated_at - computed: true, optional: false, required: false
    get updatedAt() {
        return this.getStringAttribute('updated_at');
    }
    get webhook() {
        return this.getStringAttribute('webhook');
    }
    set webhook(value) {
        this._webhook = value;
    }
    // Temporarily expose input value. Use with caution.
    get webhookInput() {
        return this._webhook;
    }
    get wikiPageEvents() {
        return this.getBooleanAttribute('wiki_page_events');
    }
    set wikiPageEvents(value) {
        this._wikiPageEvents = value;
    }
    resetWikiPageEvents() {
        this._wikiPageEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiPageEventsInput() {
        return this._wikiPageEvents;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            branches_to_be_notified: cdktf.stringToTerraform(this._branchesToBeNotified),
            confidential_issues_events: cdktf.booleanToTerraform(this._confidentialIssuesEvents),
            confidential_note_events: cdktf.booleanToTerraform(this._confidentialNoteEvents),
            issues_events: cdktf.booleanToTerraform(this._issuesEvents),
            merge_requests_events: cdktf.booleanToTerraform(this._mergeRequestsEvents),
            note_events: cdktf.booleanToTerraform(this._noteEvents),
            notify_only_broken_pipelines: cdktf.booleanToTerraform(this._notifyOnlyBrokenPipelines),
            pipeline_events: cdktf.booleanToTerraform(this._pipelineEvents),
            project: cdktf.stringToTerraform(this._project),
            push_events: cdktf.booleanToTerraform(this._pushEvents),
            tag_push_events: cdktf.booleanToTerraform(this._tagPushEvents),
            webhook: cdktf.stringToTerraform(this._webhook),
            wiki_page_events: cdktf.booleanToTerraform(this._wikiPageEvents),
        };
    }
}
exports.ServiceMicrosoftTeams = ServiceMicrosoftTeams;
_a = JSII_RTTI_SYMBOL_1;
ServiceMicrosoftTeams[_a] = { fqn: "@cdktf/provider-gitlab.ServiceMicrosoftTeams", version: "0.0.11" };
// =================
// STATIC PROPERTIES
// =================
ServiceMicrosoftTeams.tfResourceType = "gitlab_service_microsoft_teams";
//# sourceMappingURL=data:application/json;base64,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