import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedLicenseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The approval status of the license. Valid values are: `approved`, `blacklisted`, `allowed`, `denied`. "approved" and "blacklisted"
                  have been deprecated in favor of "allowed" and "denied"; use "allowed" and "denied" for GitLab versions 15.0 and higher.
                  Prior to version 15.0 and after 14.6, the values are equivalent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/managed_license#approval_status ManagedLicense#approval_status}
    */
    readonly approvalStatus: string;
    /**
    * The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/managed_license#name ManagedLicense#name}
    */
    readonly name: string;
    /**
    * The ID of the project under which the managed license will be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/managed_license#project ManagedLicense#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/managed_license gitlab_managed_license}
*/
export declare class ManagedLicense extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_managed_license";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/managed_license gitlab_managed_license} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedLicenseConfig
    */
    constructor(scope: Construct, id: string, config: ManagedLicenseConfig);
    private _approvalStatus?;
    get approvalStatus(): string;
    set approvalStatus(value: string);
    get approvalStatusInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=managed-license.d.ts.map