import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupProjectFileTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the project that will be used for file templates. This project must be the direct
                  child of the project defined by the group_id
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_project_file_template#file_template_project_id GroupProjectFileTemplate#file_template_project_id}
    */
    readonly fileTemplateProjectId: number;
    /**
    * The ID of the group that will use the file template project. This group must be the direct
                  parent of the project defined by project_id
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_project_file_template#group_id GroupProjectFileTemplate#group_id}
    */
    readonly groupId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_project_file_template gitlab_group_project_file_template}
*/
export declare class GroupProjectFileTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_project_file_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_project_file_template gitlab_group_project_file_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupProjectFileTemplateConfig
    */
    constructor(scope: Construct, id: string, config: GroupProjectFileTemplateConfig);
    private _fileTemplateProjectId?;
    get fileTemplateProjectId(): number;
    set fileTemplateProjectId(value: number);
    get fileTemplateProjectIdInput(): number | undefined;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    get groupIdInput(): number | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=group-project-file-template.d.ts.map