"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnEndpoint = exports.ClientVpnUserBasedAuthentication = exports.ClientVpnSessionTimeout = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const client_vpn_authorization_rule_1 = require("./client-vpn-authorization-rule");
const client_vpn_route_1 = require("./client-vpn-route");
const connections_1 = require("./connections");
const ec2_generated_1 = require("./ec2.generated");
const network_util_1 = require("./network-util");
const security_group_1 = require("./security-group");
/**
 * Maximum VPN session duration time
 */
var ClientVpnSessionTimeout;
(function (ClientVpnSessionTimeout) {
    /** 8 hours */
    ClientVpnSessionTimeout[ClientVpnSessionTimeout["EIGHT_HOURS"] = 8] = "EIGHT_HOURS";
    /** 10 hours */
    ClientVpnSessionTimeout[ClientVpnSessionTimeout["TEN_HOURS"] = 10] = "TEN_HOURS";
    /** 12 hours */
    ClientVpnSessionTimeout[ClientVpnSessionTimeout["TWELVE_HOURS"] = 12] = "TWELVE_HOURS";
    /** 24 hours */
    ClientVpnSessionTimeout[ClientVpnSessionTimeout["TWENTY_FOUR_HOURS"] = 24] = "TWENTY_FOUR_HOURS";
})(ClientVpnSessionTimeout = exports.ClientVpnSessionTimeout || (exports.ClientVpnSessionTimeout = {}));
/**
 * User-based authentication for a client VPN endpoint
 */
class ClientVpnUserBasedAuthentication {
    /**
     * Active Directory authentication
     */
    static activeDirectory(directoryId) {
        return new ActiveDirectoryAuthentication(directoryId);
    }
    /** Federated authentication */
    static federated(samlProvider, selfServiceSamlProvider) {
        return new FederatedAuthentication(samlProvider, selfServiceSamlProvider);
    }
}
exports.ClientVpnUserBasedAuthentication = ClientVpnUserBasedAuthentication;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnUserBasedAuthentication[_a] = { fqn: "@aws-cdk/aws-ec2.ClientVpnUserBasedAuthentication", version: "1.148.0" };
/**
 * Active Directory authentication
 */
class ActiveDirectoryAuthentication extends ClientVpnUserBasedAuthentication {
    constructor(directoryId) {
        super();
        this.directoryId = directoryId;
    }
    render() {
        return {
            type: 'directory-service-authentication',
            activeDirectory: { directoryId: this.directoryId },
        };
    }
}
/**
 * Federated authentication
 */
class FederatedAuthentication extends ClientVpnUserBasedAuthentication {
    constructor(samlProvider, selfServiceSamlProvider) {
        super();
        this.samlProvider = samlProvider;
        this.selfServiceSamlProvider = selfServiceSamlProvider;
    }
    render() {
        var _c;
        return {
            type: 'federated-authentication',
            federatedAuthentication: {
                samlProviderArn: this.samlProvider.samlProviderArn,
                selfServiceSamlProviderArn: (_c = this.selfServiceSamlProvider) === null || _c === void 0 ? void 0 : _c.samlProviderArn,
            },
        };
    }
}
/**
 * A client VPN connnection
 */
class ClientVpnEndpoint extends core_1.Resource {
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g, _h;
        super(scope, id);
        this._targetNetworksAssociated = new core_1.ConcreteDependable();
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_ClientVpnEndpointProps(props);
        if (!core_1.Token.isUnresolved(props.vpc.vpcCidrBlock)) {
            const clientCidr = new network_util_1.CidrBlock(props.cidr);
            const vpcCidr = new network_util_1.CidrBlock(props.vpc.vpcCidrBlock);
            if (vpcCidr.containsCidr(clientCidr)) {
                throw new Error('The client CIDR cannot overlap with the local CIDR of the VPC');
            }
        }
        if (props.dnsServers && props.dnsServers.length > 2) {
            throw new Error('A client VPN endpoint can have up to two DNS servers');
        }
        if (props.logging == false && (props.logGroup || props.logStream)) {
            throw new Error('Cannot specify `logGroup` or `logStream` when logging is disabled');
        }
        if (props.clientConnectionHandler
            && !core_1.Token.isUnresolved(props.clientConnectionHandler.functionName)
            && !props.clientConnectionHandler.functionName.startsWith('AWSClientVPN-')) {
            throw new Error('The name of the Lambda function must begin with the `AWSClientVPN-` prefix');
        }
        if (props.clientLoginBanner
            && !core_1.Token.isUnresolved(props.clientLoginBanner)
            && props.clientLoginBanner.length > 1400) {
            throw new Error(`The maximum length for the client login banner is 1400, got ${props.clientLoginBanner.length}`);
        }
        const logging = (_c = props.logging) !== null && _c !== void 0 ? _c : true;
        const logGroup = logging
            ? (_d = props.logGroup) !== null && _d !== void 0 ? _d : new logs.LogGroup(this, 'LogGroup') : undefined;
        const securityGroups = (_e = props.securityGroups) !== null && _e !== void 0 ? _e : [new security_group_1.SecurityGroup(this, 'SecurityGroup', {
                vpc: props.vpc,
            })];
        this.connections = new connections_1.Connections({ securityGroups });
        const endpoint = new ec2_generated_1.CfnClientVpnEndpoint(this, 'Resource', {
            authenticationOptions: renderAuthenticationOptions(props.clientCertificateArn, props.userBasedAuthentication),
            clientCidrBlock: props.cidr,
            clientConnectOptions: props.clientConnectionHandler
                ? {
                    enabled: true,
                    lambdaFunctionArn: props.clientConnectionHandler.functionArn,
                }
                : undefined,
            connectionLogOptions: {
                enabled: logging,
                cloudwatchLogGroup: logGroup === null || logGroup === void 0 ? void 0 : logGroup.logGroupName,
                cloudwatchLogStream: (_f = props.logStream) === null || _f === void 0 ? void 0 : _f.logStreamName,
            },
            description: props.description,
            dnsServers: props.dnsServers,
            securityGroupIds: securityGroups.map(s => s.securityGroupId),
            selfServicePortal: booleanToEnabledDisabled(props.selfServicePortal),
            serverCertificateArn: props.serverCertificateArn,
            splitTunnel: props.splitTunnel,
            transportProtocol: props.transportProtocol,
            vpcId: props.vpc.vpcId,
            vpnPort: props.port,
            sessionTimeoutHours: props.sessionTimeout,
            clientLoginBannerOptions: props.clientLoginBanner
                ? {
                    enabled: true,
                    bannerText: props.clientLoginBanner,
                }
                : undefined,
        });
        this.endpointId = endpoint.ref;
        if (props.userBasedAuthentication && ((_g = props.selfServicePortal) !== null && _g !== void 0 ? _g : true)) {
            // Output self-service portal URL
            new core_1.CfnOutput(this, 'SelfServicePortalUrl', {
                value: `https://self-service.clientvpn.amazonaws.com/endpoints/${this.endpointId}`,
            });
        }
        // Associate subnets
        const subnetIds = props.vpc.selectSubnets(props.vpcSubnets).subnetIds;
        if (core_1.Token.isUnresolved(subnetIds)) {
            throw new Error('Cannot associate subnets when VPC are imported from parameters or exports containing lists of subnet IDs.');
        }
        for (const [idx, subnetId] of Object.entries(subnetIds)) {
            this._targetNetworksAssociated.add(new ec2_generated_1.CfnClientVpnTargetNetworkAssociation(this, `Association${idx}`, {
                clientVpnEndpointId: this.endpointId,
                subnetId,
            }));
        }
        this.targetNetworksAssociated = this._targetNetworksAssociated;
        if ((_h = props.authorizeAllUsersToVpcCidr) !== null && _h !== void 0 ? _h : true) {
            this.addAuthorizationRule('AuthorizeAll', {
                cidr: props.vpc.vpcCidrBlock,
            });
        }
    }
    /**
     * Import an existing client VPN endpoint
     */
    static fromEndpointAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_ClientVpnEndpointAttributes(attrs);
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.endpointId = attrs.endpointId;
                this.connections = new connections_1.Connections({ securityGroups: attrs.securityGroups });
                this.targetNetworksAssociated = new core_1.ConcreteDependable();
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds an authorization rule to this endpoint
     */
    addAuthorizationRule(id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_ClientVpnAuthorizationRuleOptions(props);
        return new client_vpn_authorization_rule_1.ClientVpnAuthorizationRule(this, id, {
            ...props,
            clientVpnEndpoint: this,
        });
    }
    /**
     * Adds a route to this endpoint
     */
    addRoute(id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_ClientVpnRouteOptions(props);
        return new client_vpn_route_1.ClientVpnRoute(this, id, {
            ...props,
            clientVpnEndpoint: this,
        });
    }
}
exports.ClientVpnEndpoint = ClientVpnEndpoint;
_b = JSII_RTTI_SYMBOL_1;
ClientVpnEndpoint[_b] = { fqn: "@aws-cdk/aws-ec2.ClientVpnEndpoint", version: "1.148.0" };
function renderAuthenticationOptions(clientCertificateArn, userBasedAuthentication) {
    const authenticationOptions = [];
    if (clientCertificateArn) {
        authenticationOptions.push({
            type: 'certificate-authentication',
            mutualAuthentication: {
                clientRootCertificateChainArn: clientCertificateArn,
            },
        });
    }
    if (userBasedAuthentication) {
        authenticationOptions.push(userBasedAuthentication.render());
    }
    if (authenticationOptions.length === 0) {
        throw new Error('A client VPN endpoint must use at least one authentication option');
    }
    return authenticationOptions;
}
function booleanToEnabledDisabled(val) {
    switch (val) {
        case undefined:
            return undefined;
        case true:
            return 'enabled';
        case false:
            return 'disabled';
    }
}
//# sourceMappingURL=data:application/json;base64,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