import * as codepipeline from '@aws-cdk/aws-codepipeline';
import { Action } from '../action';
import { Construct } from '@aws-cdk/core';
/**
 * The CodePipeline variables emitted by CodeStar source Action.
 *
 * @stability stable
 */
export interface CodeStarSourceVariables {
    /**
     * The name of the repository this action points to.
     *
     * @stability stable
     */
    readonly fullRepositoryName: string;
    /**
     * The name of the branch this action tracks.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * The date the currently last commit on the tracked branch was authored, in ISO-8601 format.
     *
     * @stability stable
     */
    readonly authorDate: string;
    /**
     * The SHA1 hash of the currently last commit on the tracked branch.
     *
     * @stability stable
     */
    readonly commitId: string;
    /**
     * The message of the currently last commit on the tracked branch.
     *
     * @stability stable
     */
    readonly commitMessage: string;
    /**
     * The connection ARN this source uses.
     *
     * @stability stable
     */
    readonly connectionArn: string;
}
/**
 * Construction properties for {@link CodeStarConnectionsSourceAction}.
 *
 * @stability stable
 */
export interface CodeStarConnectionsSourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The output artifact that this action produces.
     *
     * Can be used as input for further pipeline actions.
     *
     * @stability stable
     */
    readonly output: codepipeline.Artifact;
    /**
     * The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository.
     *
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html
     * @stability stable
     * @example
     *
     * 'arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh'
     */
    readonly connectionArn: string;
    /**
     * The owning user or organization of the repository.
     *
     * @stability stable
     * @example
     *
     * 'aws'
     */
    readonly owner: string;
    /**
     * The name of the repository.
     *
     * @stability stable
     * @example
     *
     * 'aws-cdk'
     */
    readonly repo: string;
    /**
     * The branch to build.
     *
     * @default 'master'
     * @stability stable
     */
    readonly branch?: string;
    /**
     * Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
     *
     * **Note**: if this option is true,
     * then only CodeBuild actions can use the resulting {@link output}.
     *
     * @default false
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config
     * @stability stable
     */
    readonly codeBuildCloneOutput?: boolean;
    /**
     * Controls automatically starting your pipeline when a new commit is made on the configured repository and branch.
     *
     * If unspecified,
     * the default value is true, and the field does not display by default.
     *
     * @default true
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html
     * @stability stable
     */
    readonly triggerOnPush?: boolean;
}
/**
 * A CodePipeline source action for the CodeStar Connections source, which allows connecting to GitHub and BitBucket.
 *
 * @stability stable
 */
export declare class CodeStarConnectionsSourceAction extends Action {
    /**
     * The name of the property that holds the ARN of the CodeStar Connection
     * inside of the CodePipeline Artifact's metadata.
     *
     * @internal
     */
    static readonly _CONNECTION_ARN_PROPERTY = "CodeStarConnectionArnProperty";
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: CodeStarConnectionsSourceActionProps);
    /**
     * The variables emitted by this action.
     *
     * @stability stable
     */
    get variables(): CodeStarSourceVariables;
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     *
     * @stability stable
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
