from .affine_transform import AffineTransform
from .annotation import Annotation
from .annotation_ref import AnnotationRef
from .arc import Arc
from .basic_annotation import BasicAnnotation
from .bin_data import BinData
from .binary_file import BinaryFile
from .boolean_annotation import BooleanAnnotation
from .channel import Channel
from .channel_ref import ChannelRef
from .comment_annotation import CommentAnnotation
from .dataset import Dataset
from .dataset_ref import DatasetRef
from .detector import Detector
from .detector_settings import DetectorSettings
from .dichroic import Dichroic
from .dichroic_ref import DichroicRef
from .double_annotation import DoubleAnnotation
from .ellipse import Ellipse
from .experiment import Experiment
from .experiment_ref import ExperimentRef
from .experimenter import Experimenter
from .experimenter_group import ExperimenterGroup
from .experimenter_group_ref import ExperimenterGroupRef
from .experimenter_ref import ExperimenterRef
from .external import External
from .filament import Filament
from .file_annotation import FileAnnotation
from .filter import Filter
from .filter_ref import FilterRef
from .filter_set import FilterSet
from .filter_set_ref import FilterSetRef
from .folder import Folder
from .folder_ref import FolderRef
from .generic_excitation_source import GenericExcitationSource
from .image import Image
from .image_ref import ImageRef
from .imaging_environment import ImagingEnvironment
from .instrument import Instrument
from .instrument_ref import InstrumentRef
from .label import Label
from .laser import Laser
from .leader import Leader
from .light_emitting_diode import LightEmittingDiode
from .light_path import LightPath
from .light_source import LightSource
from .light_source_group import LightSourceGroup
from .light_source_settings import LightSourceSettings
from .line import Line
from .list_annotation import ListAnnotation
from .long_annotation import LongAnnotation
from .manufacturer_spec import ManufacturerSpec
from .map import Map
from .map_annotation import MapAnnotation
from .mask import Mask
from .microbeam_manipulation import MicrobeamManipulation
from .microbeam_manipulation_ref import MicrobeamManipulationRef
from .microscope import Microscope
from .numeric_annotation import NumericAnnotation
from .objective import Objective
from .objective_settings import ObjectiveSettings
from .ome import OME
from .pixels import Pixels
from .plane import Plane
from .plate import Plate
from .plate_acquisition import PlateAcquisition
from .point import Point
from .polygon import Polygon
from .polyline import Polyline
from .project import Project
from .project_ref import ProjectRef
from .pump import Pump
from .reagent import Reagent
from .reagent_ref import ReagentRef
from .rectangle import Rectangle
from .reference import Reference
from .rights import Rights
from .roi import ROI
from .roi_ref import ROIRef
from .screen import Screen
from .settings import Settings
from .shape import Shape
from .shape_group import ShapeGroup
from .stage_label import StageLabel
from .structured_annotations import StructuredAnnotations
from .tag_annotation import TagAnnotation
from .term_annotation import TermAnnotation
from .text_annotation import TextAnnotation
from .tiff_data import TiffData
from .timestamp_annotation import TimestampAnnotation
from .transmittance_range import TransmittanceRange
from .type_annotation import TypeAnnotation
from .well import Well
from .well_sample import WellSample
from .well_sample_ref import WellSampleRef
from .xml_annotation import XMLAnnotation


__all__ = [
    "AffineTransform",
    "Annotation",
    "AnnotationRef",
    "Arc",
    "BasicAnnotation",
    "BinData",
    "BinaryFile",
    "BooleanAnnotation",
    "Channel",
    "ChannelRef",
    "CommentAnnotation",
    "Dataset",
    "DatasetRef",
    "Detector",
    "DetectorSettings",
    "Dichroic",
    "DichroicRef",
    "DoubleAnnotation",
    "Ellipse",
    "Experiment",
    "ExperimentRef",
    "Experimenter",
    "ExperimenterGroup",
    "ExperimenterGroupRef",
    "ExperimenterRef",
    "External",
    "Filament",
    "FileAnnotation",
    "Filter",
    "FilterRef",
    "FilterSet",
    "FilterSetRef",
    "Folder",
    "FolderRef",
    "GenericExcitationSource",
    "Image",
    "ImageRef",
    "ImagingEnvironment",
    "Instrument",
    "InstrumentRef",
    "Label",
    "Laser",
    "Leader",
    "LightEmittingDiode",
    "LightPath",
    "LightSource",
    "LightSourceGroup",
    "LightSourceSettings",
    "Line",
    "ListAnnotation",
    "LongAnnotation",
    "ManufacturerSpec",
    "Map",
    "MapAnnotation",
    "Mask",
    "MicrobeamManipulation",
    "MicrobeamManipulationRef",
    "Microscope",
    "NumericAnnotation",
    "OME",
    "Objective",
    "ObjectiveSettings",
    "Pixels",
    "Plane",
    "Plate",
    "PlateAcquisition",
    "Point",
    "Polygon",
    "Polyline",
    "Project",
    "ProjectRef",
    "Pump",
    "ROI",
    "ROIRef",
    "Reagent",
    "ReagentRef",
    "Rectangle",
    "Reference",
    "Rights",
    "Screen",
    "Settings",
    "Shape",
    "ShapeGroup",
    "StageLabel",
    "StructuredAnnotations",
    "TagAnnotation",
    "TermAnnotation",
    "TextAnnotation",
    "TiffData",
    "TimestampAnnotation",
    "TransmittanceRange",
    "TypeAnnotation",
    "Well",
    "WellSample",
    "WellSampleRef",
    "XMLAnnotation",
]

_field_plurals = {
    ("OME", "roi"): "rois",
    ("OME", "experiment"): "experiments",
    ("OME", "experimenter"): "experimenters",
    ("OME", "image"): "images",
    ("OME", "dataset"): "datasets",
    ("OME", "project"): "projects",
    ("OME", "plate"): "plates",
    ("OME", "experimenter_group"): "experimenter_groups",
    ("OME", "folder"): "folders",
    ("OME", "screen"): "screens",
    ("OME", "instrument"): "instruments",
    ("Pixels", "channel"): "channels",
    ("Pixels", "tiff_data"): "tiff_data_blocks",
    ("Pixels", "plane"): "planes",
    ("Instrument", "filter_set"): "filter_sets",
    ("Instrument", "objective"): "objectives",
    ("Instrument", "filter"): "filters",
    ("Instrument", "detector"): "detectors",
    ("Instrument", "dichroic"): "dichroics",
    ("Experiment", "microbeam_manipulation"): "microbeam_manipulations",
    ("StructuredAnnotations", "map_annotation"): "map_annotations",
    ("StructuredAnnotations", "file_annotation"): "file_annotations",
    ("StructuredAnnotations", "timestamp_annotation"): "timestamp_annotations",
    ("StructuredAnnotations", "double_annotation"): "double_annotations",
    ("StructuredAnnotations", "boolean_annotation"): "boolean_annotations",
    ("StructuredAnnotations", "list_annotation"): "list_annotations",
    ("StructuredAnnotations", "tag_annotation"): "tag_annotations",
    ("StructuredAnnotations", "term_annotation"): "term_annotations",
    ("StructuredAnnotations", "comment_annotation"): "comment_annotations",
    ("StructuredAnnotations", "long_annotation"): "long_annotations",
    ("StructuredAnnotations", "xml_annotation"): "xml_annotations",
    ("Plate", "well"): "wells",
    ("Plate", "plate_acquisition"): "plate_acquisitions",
    ("Screen", "reagent"): "reagents",
    ("Well", "well_sample"): "well_samples",
}
