import { View } from "@deck.gl/core";
import IntersectionViewport from "../viewports/intersectionViewport";

export type IntersectionViewState = {
    /** The world position at the center of the viewport. Default `[0, 0, 0]`. */
    target?: [number, number, number] | [number, number];
    /**  The zoom level of the viewport. `zoom: 0` maps one unit distance to one pixel on screen, and increasing `zoom` by `1` scales the same object to twice as large.
     *   To apply independent zoom levels to the X and Y axes, supply an array `[zoomX, zoomY]`. Default `0`. */
    zoom?: number | [number, number];
    /** The min zoom level of the viewport. Default `-Infinity`. */
    minZoom?: number;
    /** The max zoom level of the viewport. Default `Infinity`. */
    maxZoom?: number;
};

type IntersectionViewProps = {
    /** Distance of near clipping plane. Default `0.1`. */
    near?: number;
    /** Distance of far clipping plane. Default `1000`. */
    far?: number;
    /** Whether to use top-left coordinates (`true`) or bottom-left coordinates (`false`). Default `true`. */
    flipY?: boolean;
};

// The typings generated by @danmarshall/deckgl-typings is for deckgl 8.1.3, typings for v8.8.3 is not available
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
export default class IntersectionView extends View<
    IntersectionViewState,
    IntersectionViewProps
> {
    static displayName = "IntersectionView";

    constructor(props: IntersectionViewProps) {
        super({
            ...props,
            target: [275, 0, -500],
            controller: false,
        });
    }

    get ViewportType(): unknown {
        return IntersectionViewport;
    }

    get ControllerType(): unknown {
        throw new Error("Method not implemented.");
    }
}
