"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""

try:
    import cStringIO.StringIO as BytesIO
except ImportError:
    from io import BytesIO
import struct

class microstrain_lcmt(object):
    __slots__ = ["omega", "acc", "temp", "good_packets", "bad_packets", "navQuat", "navOmega", "navRPY"]

    def __init__(self):
        self.omega = [ 0.0 for dim0 in range(3) ]
        self.acc = [ 0.0 for dim0 in range(3) ]
        self.temp = 0.0
        self.good_packets = 0
        self.bad_packets = 0
        self.navQuat = [ 0.0 for dim0 in range(4) ]
        self.navOmega = [ 0.0 for dim0 in range(3) ]
        self.navRPY = [ 0.0 for dim0 in range(3) ]

    def encode(self):
        buf = BytesIO()
        buf.write(microstrain_lcmt._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack('>3f', *self.omega[:3]))
        buf.write(struct.pack('>3f', *self.acc[:3]))
        buf.write(struct.pack(">fqq", self.temp, self.good_packets, self.bad_packets))
        buf.write(struct.pack('>4f', *self.navQuat[:4]))
        buf.write(struct.pack('>3f', *self.navOmega[:3]))
        buf.write(struct.pack('>3f', *self.navRPY[:3]))

    def decode(data):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != microstrain_lcmt._get_packed_fingerprint():
            raise ValueError("Decode error")
        return microstrain_lcmt._decode_one(buf)
    decode = staticmethod(decode)

    def _decode_one(buf):
        self = microstrain_lcmt()
        self.omega = struct.unpack('>3f', buf.read(12))
        self.acc = struct.unpack('>3f', buf.read(12))
        self.temp, self.good_packets, self.bad_packets = struct.unpack(">fqq", buf.read(20))
        self.navQuat = struct.unpack('>4f', buf.read(16))
        self.navOmega = struct.unpack('>3f', buf.read(12))
        self.navRPY = struct.unpack('>3f', buf.read(12))
        return self
    _decode_one = staticmethod(_decode_one)

    _hash = None
    def _get_hash_recursive(parents):
        if microstrain_lcmt in parents: return 0
        tmphash = (0x491dbdb1d605c43a) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff)  + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _get_hash_recursive = staticmethod(_get_hash_recursive)
    _packed_fingerprint = None

    def _get_packed_fingerprint():
        if microstrain_lcmt._packed_fingerprint is None:
            microstrain_lcmt._packed_fingerprint = struct.pack(">Q", microstrain_lcmt._get_hash_recursive([]))
        return microstrain_lcmt._packed_fingerprint
    _get_packed_fingerprint = staticmethod(_get_packed_fingerprint)

