/*
 * Decompiled with CFR 0.152.
 */
package lcm.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lcm.util.ParameterListener;

public class ParameterGUI {
    HashMap<String, PValue> parammap = new HashMap();
    JPanel panel = new JPanel(new GridBagLayout());
    int row = 0;
    GridBagConstraints gA;
    GridBagConstraints gB;
    GridBagConstraints gC;
    GridBagConstraints gD;
    GridBagConstraints gBC;
    GridBagConstraints gCD;
    GridBagConstraints gBCD;
    GridBagConstraints gABCD;
    ArrayList<ParameterListener> listeners = new ArrayList();
    boolean showvars;

    static void setupJTextField(JTextField jTextField) {
        JTFListener jTFListener = new JTFListener(jTextField);
        jTextField.addActionListener(jTFListener);
        jTextField.addCaretListener(jTFListener);
        jTextField.addKeyListener(jTFListener);
    }

    static final int parseInteger(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    static final double parseDouble(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public ParameterGUI() {
        this(true);
    }

    public ParameterGUI(boolean bl) {
        this.showvars = bl;
        this.gA = new GridBagConstraints();
        this.gA.gridx = 0;
        this.gA.weightx = 0.05;
        this.gA.fill = 2;
        this.gB = new GridBagConstraints();
        this.gB.gridx = 1;
        this.gB.weightx = 1.0;
        this.gB.fill = 2;
        this.gC = new GridBagConstraints();
        this.gC.gridx = 2;
        this.gC.weightx = 0.1;
        this.gC.fill = 2;
        this.gD = new GridBagConstraints();
        this.gD.gridx = 3;
        this.gD.weightx = 0.05;
        this.gD.anchor = 10;
        this.gBC = new GridBagConstraints();
        this.gBC.gridx = 1;
        this.gBC.gridwidth = 2;
        this.gBC.weightx = this.gB.weightx + this.gC.weightx;
        this.gBC.fill = 2;
        this.gCD = new GridBagConstraints();
        this.gCD.gridx = 2;
        this.gCD.gridwidth = 2;
        this.gCD.weightx = this.gC.weightx + this.gD.weightx;
        this.gCD.fill = 2;
        this.gCD.anchor = 13;
        this.gBCD = new GridBagConstraints();
        this.gBCD.gridx = 1;
        this.gBCD.gridwidth = 3;
        this.gBCD.weightx = this.gB.weightx + this.gC.weightx + this.gD.weightx;
        this.gBCD.fill = 2;
        this.gBCD.anchor = 13;
        this.gABCD = new GridBagConstraints();
        this.gABCD.gridx = 0;
        this.gABCD.gridwidth = 4;
        this.gABCD.weightx = this.gA.weightx + this.gB.weightx + this.gC.weightx + this.gD.weightx;
        this.gABCD.fill = 2;
    }

    protected void notifyListeners(String string) {
        for (ParameterListener parameterListener : this.listeners) {
            parameterListener.parameterChanged(string);
        }
    }

    public void addListener(ParameterListener parameterListener) {
        this.listeners.add(parameterListener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public void addInt(String string, String string2, int n) {
        this.addInt(string, string2, -2147483647, Integer.MAX_VALUE, n);
    }

    public void addInt(String string, String string2, int n, int n2, int n3) {
        IntegerValue integerValue = new IntegerValue(string, string2, -2147483647, Integer.MAX_VALUE, n3);
        this.parammap.put(string, integerValue);
        this.gA.gridy = this.row;
        this.gBCD.gridy = this.row++;
        this.panel.add((Component)new JLabel(string2), this.gA);
        this.panel.add((Component)integerValue.getTextField(), this.gBCD);
    }

    public void addIntSlider(String string, String string2, int n, int n2, int n3) {
        IntegerValue integerValue = new IntegerValue(string, string2, n, n2, n3);
        this.parammap.put(string, integerValue);
        this.gA.gridy = this.row;
        this.gBC.gridy = this.row;
        this.gD.gridy = this.row++;
        this.panel.add((Component)new JLabel(string2), this.gA);
        this.panel.add((Component)integerValue.getSlider(), this.gBC);
        this.panel.add((Component)integerValue.getLabel(), this.gD);
    }

    public void addDouble(String string, String string2, double d) {
        this.addDouble(string, string2, -1.7976931348623157E308, Double.MAX_VALUE, d);
    }

    public void addDouble(String string, String string2, double d, double d2, double d3) {
        DoubleValue doubleValue = new DoubleValue(string, string2, d, d2, d3);
        this.parammap.put(string, doubleValue);
        this.gA.gridy = this.row;
        this.gBCD.gridy = this.row++;
        this.panel.add((Component)new JLabel(string2), this.gA);
        this.panel.add((Component)doubleValue.getTextField(), this.gBCD);
    }

    public void addDoubleSlider(String string, String string2, double d, double d2, double d3) {
        DoubleValue doubleValue = new DoubleValue(string, string2, d, d2, d3);
        this.parammap.put(string, doubleValue);
        this.gA.gridy = this.row;
        this.gBC.gridy = this.row;
        this.gD.gridy = this.row++;
        this.panel.add((Component)new JLabel(string2), this.gA);
        this.panel.add((Component)doubleValue.getSlider(), this.gBC);
        this.panel.add((Component)doubleValue.getLabel(), this.gD);
    }

    public void addString(String string, String string2, String string3) {
        StringValue stringValue = new StringValue(string, string2, null, string3);
        this.parammap.put(string, stringValue);
        this.gA.gridy = this.row;
        this.gBCD.gridy = this.row++;
        this.panel.add((Component)new JLabel(string2), this.gA);
        this.panel.add((Component)stringValue.getTextField(), this.gBCD);
    }

    public void addChoice(String string, String string2, String[] stringArray, int n) {
        StringValue stringValue = new StringValue(string, string2, stringArray, stringArray[n]);
        this.parammap.put(string, stringValue);
        this.gA.gridy = this.row;
        this.gBCD.gridy = this.row++;
        this.panel.add((Component)new JLabel(string2), this.gA);
        this.panel.add((Component)stringValue.getComboBox(), this.gBCD);
    }

    public void addBoolean(String string, String string2, boolean bl) {
        BooleanValue booleanValue = new BooleanValue(string, string2, bl);
        this.parammap.put(string, booleanValue);
        this.gA.gridy = this.row;
        this.gBCD.gridy = this.row++;
        this.panel.add((Component)new JLabel(string2), this.gA);
        this.panel.add((Component)booleanValue.getCheckBox(), this.gBCD);
    }

    public void addButton(String string, String string2) {
        this.addButtons(string, string2);
    }

    public void addButtons(Object ... objectArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, objectArray.length / 2));
        for (int i = 0; i < objectArray.length / 2; ++i) {
            String string = (String)objectArray[i * 2];
            String string2 = (String)objectArray[i * 2 + 1];
            JButton jButton = new JButton(string2);
            jButton.addActionListener(new ActionNotifier(string));
            jPanel.add(jButton);
        }
        this.gABCD.gridy = this.row++;
        this.panel.add((Component)jPanel, this.gABCD);
    }

    public void addCheckBoxes(Object ... objectArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, objectArray.length / 3));
        for (int i = 0; i < objectArray.length / 3; ++i) {
            String string = (String)objectArray[i * 3 + 0];
            String string2 = (String)objectArray[i * 3 + 1];
            boolean bl = (Boolean)objectArray[i * 3 + 2];
            BooleanValue booleanValue = new BooleanValue(string, string2, bl);
            this.parammap.put(string, booleanValue);
            jPanel.add(booleanValue.getCheckBox());
        }
        this.gABCD.gridy = this.row++;
        this.panel.add((Component)jPanel, this.gABCD);
    }

    public double gd(String string) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof DoubleValue);
        return ((DoubleValue)pValue).getDoubleValue();
    }

    public void sd(String string, double d) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof DoubleValue);
        ((DoubleValue)pValue).setDoubleValue(d);
    }

    public int gi(String string) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        if (pValue instanceof StringValue) {
            return ((StringValue)pValue).idx;
        }
        assert (pValue instanceof IntegerValue);
        return ((IntegerValue)pValue).getIntegerValue();
    }

    public void si(String string, int n) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        if (pValue instanceof StringValue) {
            StringValue stringValue = (StringValue)pValue;
            assert (n < stringValue.values.length);
            stringValue.setStringValue(stringValue.values[n]);
        } else if (pValue instanceof IntegerValue) {
            ((IntegerValue)pValue).setIntegerValue(n);
        } else assert (false);
    }

    public void setMinMax(String string, int n, int n2) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof IntegerValue);
        ((IntegerValue)pValue).setMinMax(n, n2);
    }

    public void setMinMax(String string, double d, double d2) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof DoubleValue);
        ((DoubleValue)pValue).setMinMax(d, d2);
    }

    public String gs(String string) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof StringValue);
        return ((StringValue)pValue).getStringValue();
    }

    public void ss(String string, String string2) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof StringValue);
        ((StringValue)pValue).setStringValue(string2);
    }

    public boolean gb(String string) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof BooleanValue);
        return ((BooleanValue)pValue).getBooleanValue();
    }

    public void sb(String string, boolean bl) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        assert (pValue instanceof BooleanValue);
        ((BooleanValue)pValue).setBooleanValue(bl);
    }

    public void setEnabled(String string, boolean bl) {
        PValue pValue = this.parammap.get(string);
        assert (pValue != null);
        pValue.setEnabled(bl);
    }

    public Container getPanel() {
        return this.panel;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("ParameterGUI Test");
        jFrame.setLayout(new BorderLayout());
        jFrame.setSize(400, 400);
        ParameterGUI parameterGUI = new ParameterGUI();
        parameterGUI.addDouble("Double Value", "A double value", 3.1415926);
        parameterGUI.addInt("IntValue1", "An integer value", 45);
        parameterGUI.addIntSlider("IntValue2", "An integer value", 100, 1000, 999);
        parameterGUI.addDoubleSlider("DoubleSlider", "A sliding double", -1.0, 1.0, 0.5);
        parameterGUI.addDoubleSlider("DoubleSlider2", "Another sliding double", 2500000.0, 3000000.0, 2500000.0);
        parameterGUI.addString("StringValue1", "A string value", "Hi");
        parameterGUI.addString("StringValue2", "A string value", "world");
        parameterGUI.addChoice("Combo", "A combo box", new String[]{"Choice 1", "Choice 2", "Choice 3"}, 1);
        parameterGUI.addBoolean("BoolVal1", "A boolean value", true);
        parameterGUI.addBoolean("BoolVal2", "A boolean value", false);
        parameterGUI.addButton("Button", "button one");
        parameterGUI.addButtons("Buttons", "button one", "button2", "button two", "button3", "button three");
        parameterGUI.addCheckBoxes("name1", "Checkbox 1", true, "name2", "Checkbox 2", false);
        parameterGUI.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                System.out.println("Changed " + string);
            }
        });
        jFrame.add((Component)parameterGUI.getPanel(), "Center");
        jFrame.setVisible(true);
    }

    class StringValue
    extends PValue {
        JTextField textField;
        JComboBox comboBox;
        String value;
        String[] values;
        int idx;

        public StringValue(String string, String string2, String[] stringArray, String string3) {
            super(string, string2);
            this.value = string3;
            this.values = stringArray;
            this.updateIndex();
        }

        JTextField getTextField() {
            if (this.textField == null) {
                this.textField = new JTextField(this.value);
                ParameterGUI.setupJTextField(this.textField);
                this.textField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = StringValue.this.textField.getText();
                        StringValue.this.setStringValue(string);
                    }
                });
            }
            return this.textField;
        }

        JComboBox getComboBox() {
            assert (this.values != null);
            if (this.comboBox == null) {
                this.comboBox = new JComboBox<String>(this.values);
                this.comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringValue.this.setStringValue(StringValue.this.values[StringValue.this.comboBox.getSelectedIndex()]);
                    }
                });
                this.comboBox.setSelectedIndex(this.idx);
            }
            return this.comboBox;
        }

        String getStringValue() {
            return this.value;
        }

        void updateIndex() {
            if (this.values != null) {
                this.idx = -1;
                for (int i = 0; i < this.values.length; ++i) {
                    if (!this.value.equals(this.values[i])) continue;
                    this.idx = i;
                }
                if (this.idx == -1) {
                    System.out.println("Warning: illegal string value specified: " + this.value);
                }
            }
        }

        void setStringValue(String string) {
            if (string.equals(this.value)) {
                return;
            }
            this.value = string;
            this.updateIndex();
            if (this.textField != null) {
                this.textField.setText(string);
            }
            if (this.comboBox != null) {
                this.comboBox.setSelectedIndex(this.idx);
            }
            ParameterGUI.this.notifyListeners(this.name);
        }

        @Override
        void setEnabled(boolean bl) {
            if (this.textField != null) {
                this.textField.setEnabled(bl);
            }
        }
    }

    class DoubleValue
    extends PValue {
        JSlider slider;
        JTextField textField;
        JLabel label;
        double min;
        double max;
        double value;
        int ivalue;
        static final int SLIDER_CLICKS = 100000;
        double stepsize;
        String svalue;

        DoubleValue(String string, String string2, double d, double d2, double d3) {
            super(string, string2);
            this.min = d;
            this.max = d2;
            this.value = d3;
            this.updateSliderValue();
        }

        void updateSliderValue() {
            this.ivalue = (int)(100000.0 * (this.value - this.min) / (this.max - this.min));
            if (this.slider != null) {
                this.slider.setValue(this.ivalue);
            }
            this.stepsize = (this.max - this.min) / 100000.0;
        }

        JSlider getSlider() {
            if (this.slider == null) {
                this.slider = new JSlider(0, 100000, this.ivalue);
                this.slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        DoubleValue.this.setDoubleValue(((double)DoubleValue.this.slider.getValue() + 0.5) / 100000.0 * (DoubleValue.this.max - DoubleValue.this.min) + DoubleValue.this.min);
                    }
                });
            }
            return this.slider;
        }

        JLabel getLabel() {
            if (this.label == null) {
                this.label = new JLabel("" + this.value);
            }
            return this.label;
        }

        JTextField getTextField() {
            if (this.textField == null) {
                this.textField = new JTextField("" + this.value);
                ParameterGUI.setupJTextField(this.textField);
                this.textField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DoubleValue.this.setDoubleValue(ParameterGUI.parseDouble(DoubleValue.this.textField.getText(), DoubleValue.this.value));
                    }
                });
            }
            return this.textField;
        }

        double getDoubleValue() {
            return this.value;
        }

        void setDoubleValue(double d) {
            if (d < this.min) {
                d = this.min;
            }
            if (d > this.max) {
                d = this.max;
            }
            if (d == this.value) {
                return;
            }
            this.value = d;
            this.updateSliderValue();
            int n = (int)(-Math.log(this.stepsize) / Math.log(10.0)) + 1;
            if (n < 0) {
                n = 0;
            }
            this.svalue = String.format("%." + n + "f", this.value);
            if (this.textField != null) {
                this.textField.setText(this.svalue);
            }
            if (this.label != null) {
                this.label.setText(this.svalue);
            }
            ParameterGUI.this.notifyListeners(this.name);
        }

        void setMinMax(double d, double d2) {
            this.min = d;
            this.max = d2;
            this.updateSliderValue();
        }

        @Override
        void setEnabled(boolean bl) {
            if (this.slider != null) {
                this.slider.setEnabled(bl);
            }
            if (this.textField != null) {
                this.textField.setEnabled(bl);
            }
        }
    }

    class IntegerValue
    extends PValue {
        JSlider slider;
        JTextField textField;
        JLabel label;
        int min;
        int max;
        int value;

        IntegerValue(String string, String string2, int n, int n2, int n3) {
            super(string, string2);
            this.min = n;
            this.max = n2;
            this.value = n3;
        }

        JSlider getSlider() {
            if (this.slider == null) {
                this.slider = new JSlider(this.min, this.max, this.value);
                this.slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        IntegerValue.this.setIntegerValue(IntegerValue.this.slider.getValue());
                    }
                });
            }
            return this.slider;
        }

        JLabel getLabel() {
            if (this.label == null) {
                this.label = new JLabel("" + this.value);
            }
            return this.label;
        }

        JTextField getTextField() {
            if (this.textField == null) {
                this.textField = new JTextField("" + this.value);
                ParameterGUI.setupJTextField(this.textField);
                this.textField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        IntegerValue.this.setIntegerValue(ParameterGUI.parseInteger(IntegerValue.this.textField.getText(), IntegerValue.this.value));
                    }
                });
            }
            return this.textField;
        }

        int getIntegerValue() {
            return this.value;
        }

        void setIntegerValue(int n) {
            if (n < this.min) {
                n = this.min;
            }
            if (n > this.max) {
                n = this.max;
            }
            if (n == this.value) {
                return;
            }
            this.value = n;
            if (this.slider != null) {
                this.slider.setValue(n);
            }
            if (this.textField != null) {
                this.textField.setText("" + n);
            }
            if (this.label != null) {
                this.label.setText("" + n);
            }
            ParameterGUI.this.notifyListeners(this.name);
        }

        void setMinMax(int n, int n2) {
            this.min = n;
            this.max = n2;
            if (this.slider != null) {
                this.slider.setMinimum(n);
                this.slider.setMaximum(n2);
            }
        }

        @Override
        void setEnabled(boolean bl) {
            if (this.slider != null) {
                this.slider.setEnabled(bl);
            }
            if (this.textField != null) {
                this.textField.setEnabled(bl);
            }
        }
    }

    class BooleanValue
    extends PValue {
        JCheckBox jcb;
        boolean value;

        BooleanValue(String string, String string2, boolean bl) {
            super(string, string2);
            this.value = bl;
        }

        JCheckBox getCheckBox() {
            if (this.jcb == null) {
                this.jcb = new JCheckBox(this.desc, this.value);
                this.jcb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        BooleanValue.this.setBooleanValue(BooleanValue.this.jcb.isSelected());
                    }
                });
            }
            return this.jcb;
        }

        boolean getBooleanValue() {
            return this.value;
        }

        void setBooleanValue(boolean bl) {
            if (bl == this.value) {
                return;
            }
            this.value = bl;
            ParameterGUI.this.notifyListeners(this.name);
        }

        @Override
        void setEnabled(boolean bl) {
            this.jcb.setEnabled(bl);
        }
    }

    class ActionNotifier
    implements ActionListener {
        String name;

        public ActionNotifier(String string) {
            this.name = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParameterGUI.this.notifyListeners(this.name);
        }
    }

    abstract class PValue {
        String name;
        String desc;

        PValue(String string, String string2) {
            this.name = string;
            this.desc = string2;
        }

        abstract void setEnabled(boolean var1);
    }

    static class JTFListener
    extends KeyAdapter
    implements ActionListener,
    CaretListener {
        JTextField jtf;

        JTFListener(JTextField jTextField) {
            this.jtf = jTextField;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.jtf.setBackground(Color.yellow);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.jtf.setBackground(Color.white);
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
        }
    }
}

