/*
 * Decompiled with CFR 0.152.
 */
package lcm.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JImage
extends JComponent {
    public static final long serialVersionUID = 1001L;
    BufferedImage im;
    boolean fit = false;
    JPopupMenu popupMenu = new JPopupMenu("JImage Menu");
    AffineTransform t = new AffineTransform();

    public JImage() {
        this(null, true);
    }

    public JImage(int n, int n2) {
        this(new BufferedImage(n, n2, 10), true);
    }

    public JImage(BufferedImage bufferedImage) {
        this(bufferedImage, true);
    }

    public JImage(BufferedImage bufferedImage, boolean bl) {
        this.im = bufferedImage;
        if (bl) {
            this.initControls();
        }
    }

    void initControls() {
        JMenuItem jMenuItem = new JMenuItem("JImage Menu");
        jMenuItem.setEnabled(false);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Fit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JImage.this.fit = true;
                JImage.this.repaint();
            }
        });
        this.popupMenu.add(jMenuItem);
        JMenu jMenu = new JMenu("Set Scale");
        this.popupMenu.add(jMenu);
        int[] nArray = new int[]{25, 50, 100, 200, 400, 800};
        for (int i = 0; i < nArray.length; ++i) {
            jMenuItem = new JMenuItem(nArray[i] + " %");
            jMenuItem.addActionListener(new ScaleAction(nArray[i]));
            jMenu.add(jMenuItem);
        }
        MyListener myListener = new MyListener();
        this.addMouseMotionListener(myListener);
        this.addMouseListener(myListener);
        this.addMouseWheelListener(myListener);
        this.addKeyListener(myListener);
    }

    void adjustZoom(double d, Point2D point2D) {
        if (point2D == null) {
            point2D = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
        }
        Point2D point2D2 = this.componentToImage(point2D);
        double d2 = point2D.getX() - point2D2.getX() * d;
        double d3 = point2D.getY() - point2D2.getY() * d;
        this.t = new AffineTransform();
        this.t.translate(d2, d3);
        this.t.scale(d, d);
        this.fit = false;
        this.repaint();
    }

    void zoomIn(Point2D point2D) {
        double d = this.t.getScaleX() * 2.0;
        d = Math.min(d, 64.0);
        this.adjustZoom(d, point2D);
    }

    void zoomOut(Point2D point2D) {
        double d = this.t.getScaleX() * 0.5;
        d = Math.max(d, 0.03125);
        this.adjustZoom(d, point2D);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.im = bufferedImage;
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(2, 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.im == null) {
            return new Dimension(2, 2);
        }
        return new Dimension(this.im.getWidth(), this.im.getHeight());
    }

    public Point2D componentToImage(Point2D point2D) {
        Point2D point2D2 = null;
        try {
            point2D2 = this.t.inverseTransform(point2D, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return point2D2;
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.im == null) {
            return;
        }
        int n = this.getHeight();
        int n2 = this.getWidth();
        if (this.fit) {
            this.t = new AffineTransform();
            d = Math.min((double)n2 / (double)this.im.getWidth(), (double)n / (double)this.im.getHeight());
            this.t.scale(d, d);
        }
        d = (double)this.im.getWidth() * this.t.getScaleX();
        double d2 = (double)this.im.getHeight() * this.t.getScaleY();
        if (d < (double)n2) {
            this.t.preConcatenate(AffineTransform.getTranslateInstance(((double)n2 - d) / 2.0 - this.t.getTranslateX(), 0.0));
        }
        if (d2 < (double)n) {
            this.t.preConcatenate(AffineTransform.getTranslateInstance(0.0, ((double)n - d2) / 2.0 - this.t.getTranslateY()));
        }
        Point2D point2D = this.t.transform(new Point2D.Double(0.0, 0.0), null);
        Point2D point2D2 = this.t.transform(new Point2D.Double(this.im.getWidth(), this.im.getHeight()), null);
        if (d > (double)n2) {
            if (point2D.getX() > 0.0) {
                this.t.preConcatenate(AffineTransform.getTranslateInstance(-point2D.getX(), 0.0));
            }
            if (point2D2.getX() < (double)n2) {
                this.t.preConcatenate(AffineTransform.getTranslateInstance((double)n2 - point2D2.getX(), 0.0));
            }
        }
        if (d2 > (double)n) {
            if (point2D.getY() > 0.0) {
                this.t.preConcatenate(AffineTransform.getTranslateInstance(0.0, -point2D.getY()));
            }
            if (point2D2.getY() < (double)n) {
                this.t.preConcatenate(AffineTransform.getTranslateInstance(0.0, (double)n - point2D2.getY()));
            }
        }
        graphics2D.drawImage(this.im, this.t, null);
    }

    class MyListener
    implements KeyListener,
    MouseMotionListener,
    MouseListener,
    MouseWheelListener {
        boolean nodrag = true;
        Point dragBegin = null;

        MyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        public boolean handleKeyPress(KeyEvent keyEvent) {
            return false;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            Point2D.Double double_ = new Point2D.Double(mouseWheelEvent.getPoint().getX(), mouseWheelEvent.getPoint().getY());
            if (n > 0) {
                JImage.this.zoomOut(double_);
            }
            if (n < 0) {
                JImage.this.zoomIn(double_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            boolean bl;
            int n = mouseEvent.getModifiersEx();
            Point point = mouseEvent.getPoint();
            boolean bl2 = (n & 0x40) > 0;
            boolean bl3 = (n & 0x80) > 0;
            boolean bl4 = bl2 & bl3;
            boolean bl5 = bl = !((bl2 &= !bl4) | (bl3 &= !bl4) | bl4);
            if (this.dragBegin == null) {
                this.dragBegin = point;
            }
            this.nodrag = false;
            if ((n & 0x1000) <= 0) {
                // empty if block
            }
            double d = point.getX() - this.dragBegin.getX();
            double d2 = point.getY() - this.dragBegin.getY();
            JImage jImage = JImage.this;
            synchronized (jImage) {
                JImage.this.t.preConcatenate(AffineTransform.getTranslateInstance(d, d2));
            }
            this.dragBegin = point;
            JImage.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dragBegin = mouseEvent.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            if (this.nodrag && mouseEvent.getButton() == 3) {
                JImage.this.popupMenu.show(JImage.this, (int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
            }
            this.nodrag = true;
            this.dragBegin = null;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                JImage.this.adjustZoom(1.0, null);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class ScaleAction
    implements ActionListener {
        int scale;

        public ScaleAction(int n) {
            this.scale = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JImage.this.adjustZoom((double)this.scale / 100.0, null);
        }
    }
}

