/*
 * Decompiled with CFR 0.152.
 */
package lcm.util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile {
    RandomAccessFile raf;
    static final int BUFFER_SIZE = 32768;
    boolean bufferDirty = false;
    byte[] buffer = new byte[32768];
    long bufferOffset = -1L;
    int bufferLength = -1;
    int bufferPosition = -1;
    long fileLength;
    public static boolean check;

    public BufferedRandomAccessFile(File file, String string) throws IOException {
        this.raf = new RandomAccessFile(file, string);
        this.fileLength = this.raf.length();
        this.bufferSeek(0L);
    }

    public BufferedRandomAccessFile(String string, String string2) throws IOException {
        this.raf = new RandomAccessFile(string, string2);
        this.fileLength = this.raf.length();
        this.bufferSeek(0L);
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.raf.close();
    }

    public long getFilePointer() {
        return this.bufferOffset + (long)this.bufferPosition;
    }

    public long length() throws IOException {
        return this.fileLength;
    }

    int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public void seek(long l) throws IOException {
        this.bufferSeek(l);
    }

    public void flush() throws IOException {
        this.flushBuffer();
    }

    void flushBuffer() throws IOException {
        if (!this.bufferDirty) {
            return;
        }
        this.raf.seek(this.bufferOffset);
        this.raf.write(this.buffer, 0, this.bufferLength);
        this.bufferDirty = false;
    }

    void bufferSeek(long l) throws IOException {
        this.flushBuffer();
        long l2 = l - (l & 0x7FFFL);
        if (l2 == this.bufferOffset) {
            this.bufferPosition = (int)(l - this.bufferOffset);
            return;
        }
        this.bufferOffset = l2;
        this.bufferLength = (int)this.min(32768L, this.fileLength - this.bufferOffset);
        if (this.bufferLength < 0) {
            this.bufferLength = 0;
        }
        this.bufferPosition = (int)(l - this.bufferOffset);
        this.raf.seek(this.bufferOffset);
        this.raf.readFully(this.buffer, 0, this.bufferLength);
    }

    public final int read() throws IOException {
        if (this.bufferOffset + (long)this.bufferPosition >= this.fileLength) {
            throw new EOFException("EOF");
        }
        if (this.bufferPosition >= this.bufferLength) {
            this.bufferSeek(this.bufferOffset + (long)this.bufferPosition);
        }
        return this.buffer[this.bufferPosition++] & 0xFF;
    }

    public boolean hasMore() throws IOException {
        return (long)this.bufferPosition + this.bufferOffset < this.fileLength;
    }

    public byte peek() throws IOException {
        if (this.bufferPosition < this.bufferLength) {
            return this.buffer[this.bufferPosition];
        }
        this.raf.seek(this.bufferOffset + (long)this.bufferPosition);
        return this.raf.readByte();
    }

    public void write(int n) throws IOException {
        this.write((byte)(n & 0xFF));
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write((byte)(bl ? 1 : 0));
    }

    public boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    public void writeShort(short s) throws IOException {
        this.write((byte)(s >> 8));
        this.write((byte)(s & 0xFF));
    }

    public byte readByte() throws IOException {
        int n = this.read();
        return (byte)(n & 0xFF);
    }

    public short readShort() throws IOException {
        short s = 0;
        s = (short)(s | this.read() << 8);
        s = (short)(s | this.read());
        return s;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.bufferLength - this.bufferPosition;
            int n4 = Math.min(n3, n2);
            if (n4 == 0) {
                this.flushBuffer();
                if (this.bufferOffset + (long)this.bufferPosition >= this.fileLength) {
                    throw new EOFException("EOF");
                }
                this.bufferSeek(this.bufferOffset + (long)this.bufferLength);
                continue;
            }
            System.arraycopy(this.buffer, this.bufferPosition, byArray, n, n4);
            this.bufferPosition += n4;
            n += n4;
            n2 -= n4;
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void writeInt(long l) throws IOException {
        this.write((byte)(l >> 24));
        this.write((byte)(l >> 16));
        this.write((byte)(l >> 8));
        this.write((byte)(l & 0xFFL));
    }

    public int readInt() throws IOException {
        int n = 0;
        n |= this.read() << 24;
        n |= this.read() << 16;
        n |= this.read() << 8;
        return n |= this.read();
    }

    public void writeLong(long l) throws IOException {
        this.write((byte)(l >> 56));
        this.write((byte)(l >> 48));
        this.write((byte)(l >> 40));
        this.write((byte)(l >> 32));
        this.write((byte)(l >> 24));
        this.write((byte)(l >> 16));
        this.write((byte)(l >> 8));
        this.write((byte)(l & 0xFFL));
    }

    public long readLong() throws IOException {
        long l = 0L;
        l |= (long)this.read() << 56;
        l |= (long)this.read() << 48;
        l |= (long)this.read() << 40;
        l |= (long)this.read() << 32;
        l |= (long)this.read() << 24;
        l |= (long)this.read() << 16;
        l |= (long)this.read() << 8;
        return l |= (long)this.read();
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public void writeUTF(String string) throws IOException {
        this.writeShort((short)string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.write(string.charAt(i) & 0xFF);
        }
    }

    public String readUTF() throws IOException {
        int n = this.readShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)this.read());
        }
        return stringBuffer.toString();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            this.write(byArray[i]);
        }
    }

    public void write(byte by) throws IOException {
        this.bufferDirty = true;
        if (this.bufferPosition < this.bufferLength) {
            this.buffer[this.bufferPosition++] = by;
            return;
        }
        if (this.bufferLength < 32768) {
            this.buffer[this.bufferPosition++] = by;
            ++this.bufferLength;
            ++this.fileLength;
            return;
        }
        this.flushBuffer();
        this.bufferSeek(this.bufferOffset + (long)this.bufferPosition);
        this.write(by);
    }

    public String readLineCheck() throws IOException {
        if (!check) {
            return this.readLine();
        }
        this.raf.seek(this.bufferOffset + (long)this.bufferPosition);
        String string = this.raf.readLine();
        String string2 = this.readLine();
        System.out.println("braf: " + string2);
        System.out.println(" raf: " + string);
        return string2;
    }

    public String readLine() throws IOException {
        StringBuilder stringBuilder = null;
        while (true) {
            int n = this.bufferPosition;
            String string = null;
            while (this.bufferPosition < this.bufferLength) {
                char c;
                if ((c = (char)(this.buffer[this.bufferPosition++] & 0xFF)) == '\n') {
                    string = new String(this.buffer, n, this.bufferPosition - n - 1);
                    break;
                }
                if (c != '\r') continue;
                string = new String(this.buffer, n, this.bufferPosition - n - 1);
                break;
            }
            if (string != null) {
                if (stringBuilder == null) {
                    return string;
                }
                stringBuilder.append(string);
                return stringBuilder.toString();
            }
            string = new String(this.buffer, n, this.bufferPosition - n);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string);
            if (this.bufferOffset + (long)this.bufferPosition >= this.fileLength) {
                if (stringBuilder.length() > 0) {
                    return stringBuilder.toString();
                }
                return null;
            }
            this.bufferSeek(this.bufferOffset + (long)this.bufferPosition);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(stringArray[0], "r");
            while ((string = bufferedRandomAccessFile.readLine()) != null) {
                System.out.printf("^%s$\n", string);
            }
        }
        catch (IOException iOException) {
            System.out.println("Ex: " + iOException);
        }
    }
}

