/*
 * Decompiled with CFR 0.152.
 */
package lcm.spy;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lcm.spy.ChartData;

public class ZoomableChartScrollWheel
extends ZoomableChart {
    private double mouseDownStartX;
    private double mouseDownStartY;
    private double mouseDownValPerPxX;
    private double mouseDownMinX;
    private double mouseDownMaxX;
    private ArrayList<Double> mouseDownValPerPxY = new ArrayList();
    private ArrayList<Double> mouseDownMinY = new ArrayList();
    private ArrayList<Double> mouseDownMaxY = new ArrayList();
    private long lastFocusTime = -1L;
    private JFrame frame = null;
    private ArrayList<Color> colors = new ArrayList();
    private int colorNum = 0;
    private ArrayList<AAxis> rightYAxis = new ArrayList();
    private JPopupMenu popup = new JPopupMenu();
    ChartData chartData;

    public ZoomableChartScrollWheel(ChartData chartData) {
        this.addMouseWheelListener(new MyMouseWheelListener(this));
        this.getAxisX().setPaintGrid(true);
        this.getAxisY().setPaintGrid(true);
        this.setUseAntialiasing(true);
        this.setGridColor(Color.LIGHT_GRAY);
        this.getAxisX().getAxisTitle().setTitle("Time (sec)");
        this.getAxisY().getAxisTitle().setTitle("");
        this.chartData = chartData;
        this.colors.add(Color.RED);
        this.colors.add(Color.BLACK);
        this.colors.add(Color.BLUE);
        this.colors.add(Color.MAGENTA);
        this.colors.add(Color.CYAN);
        this.colors.add(Color.ORANGE);
        this.colors.add(Color.GREEN);
        this.setFixedWidthXAxisFormat();
        this.setMinPaintLatency(16);
    }

    public static void newChartFrame(final ChartData chartData, ITrace2D iTrace2D) {
        JFrame jFrame = new JFrame(iTrace2D.getName());
        ZoomableChartScrollWheel zoomableChartScrollWheel = new ZoomableChartScrollWheel(chartData);
        iTrace2D.setColor(zoomableChartScrollWheel.popColor());
        zoomableChartScrollWheel.addTrace(iTrace2D);
        zoomableChartScrollWheel.updateRightClickMenu();
        chartData.getCharts().add(zoomableChartScrollWheel);
        Container container = jFrame.getContentPane();
        container.add((Component)((Object)zoomableChartScrollWheel));
        zoomableChartScrollWheel.addFrameFocusTimer(jFrame);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                for (ITrace2D iTrace2D : ZoomableChartScrollWheel.this.getTraces()) {
                    ((Trace2DLtd)iTrace2D).setMaxSize(chartData.sparklineChartSize);
                }
                chartData.getCharts().remove((Object)ZoomableChartScrollWheel.this);
            }
        });
        jFrame.setSize(600, 500);
        jFrame.setLocationByPlatform(true);
        jFrame.setVisible(true);
    }

    private boolean maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    public Color popColor() {
        Color color = this.colors.get(this.colorNum % this.colors.size());
        ++this.colorNum;
        return color;
    }

    public void pushColor() {
        --this.colorNum;
    }

    public void updateRightClickMenu() {
        this.popup = new JPopupMenu();
        Iterator iterator = this.getTraces().iterator();
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Object object;
            final ITrace2D iTrace2D = (ITrace2D)iterator.next();
            JMenuItem jMenuItem = new JMenuItem(iTrace2D.getName());
            jMenuItem.setEnabled(false);
            if (!bl) {
                this.popup.addSeparator();
            }
            this.popup.add(jMenuItem);
            this.popup.addSeparator();
            boolean bl2 = false;
            for (final AAxis aAxis : this.rightYAxis) {
                if (!aAxis.getTraces().contains(iTrace2D)) continue;
                JMenuItem jMenuItem2 = new JMenuItem("    to main axis");
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ZoomableChartScrollWheel.this.removeAxisYRight((IAxis<?>)aAxis);
                        ZoomableChartScrollWheel.this.removeTrace(iTrace2D);
                        ZoomableChartScrollWheel.this.addTrace(iTrace2D);
                        ZoomableChartScrollWheel.this.updateRightClickMenu();
                    }
                });
                this.popup.add(jMenuItem2);
                bl2 = true;
                break;
            }
            if (!bl2) {
                object = new JMenuItem("    to separate axis");
                if (this.getAxisY().getTraces().size() < 2) {
                    ((JMenuItem)object).setEnabled(false);
                }
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AxisLinear axisLinear = new AxisLinear();
                        ZoomableChartScrollWheel.this.removeTrace(iTrace2D);
                        ZoomableChartScrollWheel.this.addAxisYRight((AAxis<?>)axisLinear);
                        ZoomableChartScrollWheel.this.addTrace(iTrace2D, ZoomableChartScrollWheel.this.getAxisX(), (IAxis)axisLinear);
                        ZoomableChartScrollWheel.this.updateRightClickMenu();
                    }
                });
                this.popup.add((JMenuItem)object);
            }
            object = new JMenuItem("    move to new window");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (AAxis aAxis : ZoomableChartScrollWheel.this.rightYAxis) {
                        if (!aAxis.getTraces().contains(iTrace2D)) continue;
                        ZoomableChartScrollWheel.this.removeAxisYRight((IAxis<?>)aAxis);
                        break;
                    }
                    ZoomableChartScrollWheel.this.removeTrace(iTrace2D);
                    ZoomableChartScrollWheel.this.updateRightClickMenu();
                    ZoomableChartScrollWheel.newChartFrame(ZoomableChartScrollWheel.this.chartData, iTrace2D);
                }
            });
            JMenuItem object22 = new JMenuItem("    remove");
            object22.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (AAxis aAxis : ZoomableChartScrollWheel.this.rightYAxis) {
                        if (!aAxis.getTraces().contains(iTrace2D)) continue;
                        ZoomableChartScrollWheel.this.removeAxisYRight((IAxis<?>)aAxis);
                        break;
                    }
                    ZoomableChartScrollWheel.this.removeTrace(iTrace2D);
                    ZoomableChartScrollWheel.this.updateRightClickMenu();
                }
            });
            if (this.getAxisX().getTraces().size() < 2) {
                object22.setEnabled(false);
                ((JMenuItem)object).setEnabled(false);
            }
            this.popup.add((JMenuItem)object);
            this.popup.add(object22);
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iTrace2D.getName());
            bl = false;
        }
        if (this.frame != null) {
            this.frame.setTitle(stringBuilder.toString());
        }
    }

    public void addAxisYRight(AAxis<?> aAxis) {
        super.addAxisYRight(aAxis);
        this.rightYAxis.add(aAxis);
    }

    public boolean removeAxisYRight(IAxis<?> iAxis) {
        this.rightYAxis.remove(iAxis);
        return super.removeAxisYRight(iAxis);
    }

    public void toFront() {
        if (this.frame != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ZoomableChartScrollWheel.this.frame.toFront();
                    ZoomableChartScrollWheel.this.frame.repaint();
                }
            });
        }
    }

    public void addFrameFocusTimer(JFrame jFrame) {
        this.frame = jFrame;
        this.frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                ZoomableChartScrollWheel.this.lastFocusTime = System.nanoTime() / 1000L;
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                ZoomableChartScrollWheel.this.lastFocusTime = System.nanoTime() / 1000L;
            }
        });
    }

    public long getLastFocusTime() {
        return this.lastFocusTime;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.maybeShowPopup(mouseEvent)) {
            return;
        }
        IAxis iAxis = this.getAxisX();
        IAxis iAxis2 = this.getAxisY();
        double d = iAxis.getRange().getExtent();
        this.mouseDownValPerPxY.clear();
        this.mouseDownMinY.clear();
        this.mouseDownMaxY.clear();
        this.mouseDownStartX = mouseEvent.getX();
        this.mouseDownStartY = mouseEvent.getY();
        double d2 = this.getXChartEnd() - this.getXChartStart();
        double d3 = this.getYChartStart() - this.getYChartEnd();
        this.mouseDownValPerPxX = d / d2;
        this.mouseDownMinX = iAxis.getMin();
        this.mouseDownMaxX = iAxis.getMax();
        double d4 = iAxis2.getRange().getExtent();
        this.mouseDownValPerPxY.add(d4 / d3);
        this.mouseDownMinY.add(iAxis2.getMin());
        this.mouseDownMaxY.add(iAxis2.getMax());
        for (AAxis aAxis : this.rightYAxis) {
            double d5 = aAxis.getMax() - aAxis.getMin();
            this.mouseDownValPerPxY.add(d5 / d3);
            this.mouseDownMinY.add(aAxis.getMin());
            this.mouseDownMaxY.add(aAxis.getMax());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x1000) != 4096) {
            this.dragChart(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.zoomAll();
            this.setFixedWidthXAxisFormat();
            mouseEvent.consume();
        } else {
            this.maybeShowPopup(mouseEvent);
        }
    }

    private void dragChart(MouseEvent mouseEvent) {
        double d = (double)mouseEvent.getX() - this.mouseDownStartX;
        double d2 = (double)mouseEvent.getY() - this.mouseDownStartY;
        double d3 = d * this.mouseDownValPerPxX;
        double d4 = d2 * this.mouseDownValPerPxY.get(0);
        if (Double.isNaN(this.mouseDownMinX) || Double.isNaN(this.mouseDownMaxX) || Double.isNaN(this.mouseDownMinY.get(0)) || Double.isNaN(this.mouseDownMaxY.get(0)) || Double.isNaN(d3) || Double.isNaN(d4) || Double.isInfinite(this.mouseDownMinX) || Double.isInfinite(this.mouseDownMaxX) || Double.isInfinite(this.mouseDownMinY.get(0)) || Double.isInfinite(this.mouseDownMaxY.get(0)) || Double.isInfinite(d3) || Double.isInfinite(d4)) {
            return;
        }
        this.zoom(this.mouseDownMinX - d3, this.mouseDownMaxX - d3, this.mouseDownMinY.get(0) + d4, this.mouseDownMaxY.get(0) + d4);
        this.setVariableWidthXAxisFormat();
        for (int i = 0; i < this.rightYAxis.size(); ++i) {
            AAxis aAxis = this.rightYAxis.get(i);
            double d5 = d2 * this.mouseDownValPerPxY.get(i + 1);
            this.zoom((IAxis)aAxis, aAxis.translateValueToPx(this.mouseDownMinY.get(i + 1) + d5), aAxis.translateValueToPx(this.mouseDownMaxY.get(i + 1) + d5));
        }
    }

    private void setFixedWidthXAxisFormat() {
        DecimalFormat decimalFormat = new DecimalFormat("#");
        LabelFormatterNumber labelFormatterNumber = new LabelFormatterNumber((NumberFormat)decimalFormat);
        this.getAxisX().setFormatter((IAxisLabelFormatter)labelFormatterNumber);
    }

    private void setVariableWidthXAxisFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        LabelFormatterNumber labelFormatterNumber = new LabelFormatterNumber((NumberFormat)decimalFormat);
        this.getAxisX().setFormatter((IAxisLabelFormatter)labelFormatterNumber);
    }

    public class MyMouseWheelListener
    implements MouseWheelListener {
        private ZoomableChartScrollWheel chart;

        public MyMouseWheelListener(ZoomableChartScrollWheel zoomableChartScrollWheel2) {
            this.chart = zoomableChartScrollWheel2;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            IAxis iAxis = this.chart.getAxisX();
            IAxis iAxis2 = this.chart.getAxisY();
            double d = iAxis.getRange().getExtent();
            double d2 = iAxis2.getRange().getExtent();
            double d3 = n > 0 ? (double)n * 1.2 : (double)(-n) * 0.8;
            double d4 = d * d3;
            double d5 = d2 * d3;
            double d6 = ((double)mouseWheelEvent.getX() - (double)this.chart.getXChartStart()) / (double)(this.chart.getXChartEnd() - this.chart.getXChartStart());
            double d7 = ((double)mouseWheelEvent.getY() - (double)this.chart.getYChartEnd()) / (double)(this.chart.getYChartStart() - this.chart.getYChartEnd());
            double d8 = iAxis.translatePxToValue(mouseWheelEvent.getX());
            double d9 = d8 - d4 * d6;
            double d10 = d8 + d4 * (1.0 - d6);
            double d11 = iAxis2.translatePxToValue(mouseWheelEvent.getY());
            double d12 = d11 - d5 * (1.0 - d7);
            double d13 = d11 + d5 * d7;
            if (Double.isNaN(d9) || Double.isNaN(d10) || Double.isNaN(d12) || Double.isNaN(d13)) {
                return;
            }
            this.chart.zoom(d9, d10, d12, d13);
            for (int i = 0; i < ZoomableChartScrollWheel.this.rightYAxis.size(); ++i) {
                AAxis aAxis = (AAxis)ZoomableChartScrollWheel.this.rightYAxis.get(i);
                double d14 = aAxis.getMax() - aAxis.getMin();
                double d15 = d14 * d3;
                double d16 = aAxis.translatePxToValue(mouseWheelEvent.getY());
                double d17 = d16 - d15 * (1.0 - d7);
                double d18 = d16 + d15 * d7;
                ZoomableChartScrollWheel.this.zoom((IAxis)aAxis, aAxis.translateValueToPx(d17), aAxis.translateValueToPx(d18));
            }
            ZoomableChartScrollWheel.this.setVariableWidthXAxisFormat();
        }
    }
}

