/*
 * Decompiled with CFR 0.152.
 */
package lcm.spy;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lcm.spy.ChartData;
import lcm.spy.ZoomableChartScrollWheel;

public class ObjectPanel
extends JPanel {
    String name;
    Object o;
    long utime;
    int lastwidth = 500;
    int lastheight = 100;
    JViewport scrollViewport;
    final int sparklineWidth = 150;
    final int sparklineDrawMargin = 500;
    Section currentlyHoveringSection;
    String currentlyHoveringName;
    ChartData chartData;
    ArrayList<SparklineData> visibleSparklines = new ArrayList();
    boolean visibleSparklinesInitialized = false;
    ArrayList<SparklineData> graphingSparklines = new ArrayList();
    int currentDrawNumber = 0;
    ArrayList<Section> sections = new ArrayList();

    public ObjectPanel(String string, ChartData chartData) {
        this.name = string;
        this.setLayout(null);
        this.chartData = chartData;
        this.addMouseListener(new MyMouseAdapter());
        this.addMouseMotionListener(new MyMouseMotionListener());
        this.repaint();
    }

    public void setViewport(JViewport jViewport) {
        this.scrollViewport = jViewport;
        this.scrollViewport.addChangeListener(new MyViewportChangeListener());
    }

    public boolean doSparklineInteraction(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        this.currentlyHoveringName = "";
        this.currentlyHoveringSection = null;
        for (SparklineData sparklineData : this.visibleSparklines) {
            if (sparklineData.ymin > n || sparklineData.ymax < n || sparklineData.lastDrawNumber != this.currentDrawNumber) continue;
            this.currentlyHoveringName = sparklineData.name;
            this.currentlyHoveringSection = sparklineData.section;
            if (mouseEvent.getButton() == 1) {
                this.displayDetailedChart(sparklineData, false, false);
                this.graphingSparklines.add(sparklineData);
            } else if (mouseEvent.getButton() == 2) {
                this.displayDetailedChart(sparklineData, true, true);
                this.graphingSparklines.add(sparklineData);
            } else if (mouseEvent.getButton() == 3) {
                this.displayDetailedChart(sparklineData, false, true);
                this.graphingSparklines.add(sparklineData);
            }
            return true;
        }
        return false;
    }

    public void displayDetailedChart(SparklineData sparklineData, boolean bl, boolean bl2) {
        if (sparklineData.chart == null) {
            System.out.println("Warning: detailed chart display requested on uninitialized chart " + sparklineData.name);
            return;
        }
        Trace2DLtd trace2DLtd = (Trace2DLtd)sparklineData.chart.getTraces().first();
        for (ZoomableChartScrollWheel zoomableChartScrollWheel : this.chartData.getCharts()) {
            if (!zoomableChartScrollWheel.getTraces().contains(trace2DLtd)) continue;
            zoomableChartScrollWheel.toFront();
            return;
        }
        if (bl || this.chartData.getCharts().size() < 1) {
            trace2DLtd.setMaxSize(this.chartData.detailedSparklineChartSize);
            ZoomableChartScrollWheel.newChartFrame(this.chartData, (ITrace2D)trace2DLtd);
        } else {
            long l = -1L;
            ZoomableChartScrollWheel zoomableChartScrollWheel = null;
            for (ZoomableChartScrollWheel zoomableChartScrollWheel2 : this.chartData.getCharts()) {
                if (zoomableChartScrollWheel2.getLastFocusTime() <= l) continue;
                l = zoomableChartScrollWheel2.getLastFocusTime();
                zoomableChartScrollWheel = zoomableChartScrollWheel2;
            }
            if (zoomableChartScrollWheel != null) {
                if (!zoomableChartScrollWheel.getTraces().contains(trace2DLtd)) {
                    trace2DLtd.setMaxSize(this.chartData.detailedSparklineChartSize);
                    trace2DLtd.setColor(zoomableChartScrollWheel.popColor());
                    if (bl2) {
                        AxisLinear axisLinear = new AxisLinear();
                        zoomableChartScrollWheel.addAxisYRight((AAxis<?>)axisLinear);
                        zoomableChartScrollWheel.addTrace((ITrace2D)trace2DLtd, zoomableChartScrollWheel.getAxisX(), (IAxis)axisLinear);
                    } else {
                        zoomableChartScrollWheel.addTrace((ITrace2D)trace2DLtd);
                    }
                }
                zoomableChartScrollWheel.updateRightClickMenu();
                zoomableChartScrollWheel.toFront();
            }
        }
    }

    public void setObject(Object object, long l) {
        this.o = object;
        this.utime = l - this.chartData.getStartTime();
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
        if (jFrame.getExtendedState() == 1) {
            this.UpdateGraphDataWithoutPaint();
        } else {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.lastwidth, this.lastheight);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    void updateVisibleSparklines(JViewport jViewport) {
        Rectangle rectangle = jViewport.getViewRect();
        this.visibleSparklines.clear();
        for (int i = this.sections.size() - 1; i > -1; --i) {
            Section section = this.sections.get(i);
            if (section.collapsed) continue;
            for (Map.Entry<String, SparklineData> entry : section.sparklines.entrySet()) {
                SparklineData sparklineData = entry.getValue();
                if (sparklineData.ymin <= rectangle.y - 500 || sparklineData.ymax >= rectangle.y + rectangle.height + 500) continue;
                this.visibleSparklines.add(sparklineData);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        PaintState paintState = new PaintState();
        paintState.panel = this;
        paintState.g = graphics;
        paintState.fm = fontMetrics;
        paintState.y = paintState.textheight = 15;
        paintState.indent_level = 1;
        paintState.x[0] = 0;
        paintState.x[1] = Math.min(200, n / 4);
        paintState.x[2] = Math.min(paintState.x[1] + 200, 2 * n / 4);
        paintState.x[3] = paintState.x[2] + 150;
        ++this.currentDrawNumber;
        int n3 = this.sections.size();
        if (!this.visibleSparklinesInitialized && this.visibleSparklines.isEmpty() && n3 > 0 && this.scrollViewport != null) {
            this.visibleSparklinesInitialized = true;
            this.updateVisibleSparklines(this.scrollViewport);
        }
        if (this.o != null) {
            this.paintRecurse(graphics, paintState, "", this.o.getClass(), this.o, false, -1);
        }
        paintState.finish();
        if (paintState.y != this.lastheight) {
            this.lastheight = paintState.y;
            this.invalidate();
            this.getParent().validate();
        }
        if (n3 != this.sections.size()) {
            this.repaint();
        }
    }

    void paintRecurse(Graphics graphics, PaintState paintState, String string, Class clazz, Object object, boolean bl, int n) {
        if (object == null) {
            paintState.drawStrings(clazz == null ? "(null)" : clazz.getName(), string, "(null)", bl);
            return;
        }
        if (clazz.isPrimitive() || clazz.equals(Byte.TYPE)) {
            Section section = this.sections.get(n);
            SparklineData sparklineData = section.sparklines.get(string);
            if (sparklineData == null) {
                sparklineData = new SparklineData();
                sparklineData.name = string;
                sparklineData.section = section;
                sparklineData.isHovering = false;
                sparklineData.chart = null;
                section.sparklines.put(string, sparklineData);
            }
            sparklineData.ymin = paintState.y - paintState.textheight + 2;
            sparklineData.ymax = paintState.y + 2;
            if (this.visibleSparklines.contains(sparklineData) || this.graphingSparklines.contains(sparklineData)) {
                paintState.drawStringsAndGraph(clazz, string, object, bl, n);
            } else {
                if (paintState.collapse_depth > 0) {
                    return;
                }
                paintState.y += paintState.textheight;
            }
        } else if (object instanceof Enum) {
            paintState.drawStrings(clazz.getName(), string, ((Enum)object).name(), bl);
        } else if (clazz.equals(String.class)) {
            paintState.drawStrings("String", string, object.toString(), bl);
        } else if (clazz.isArray()) {
            int n2 = Array.getLength(object);
            int n3 = paintState.beginSection(clazz.getComponentType() + "[]", string + "[" + n2 + "]", "");
            for (int i = 0; i < n2; ++i) {
                this.paintRecurse(graphics, paintState, string + "[" + i + "]", clazz.getComponentType(), Array.get(object, i), bl, n3);
            }
            paintState.endSection(n3);
        } else {
            Field[] fieldArray;
            int n4 = paintState.beginSection(clazz.getName(), string, "");
            for (Field field : fieldArray = clazz.getFields()) {
                try {
                    this.paintRecurse(graphics, paintState, field.getName(), field.getType(), field.get(object), bl || (field.getModifiers() & 8) != 0, n4);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace(System.out);
                }
            }
            paintState.endSection(n4);
        }
    }

    void UpdateGraphDataWithoutPaint() {
        for (SparklineData sparklineData : this.graphingSparklines) {
            this.UpdateGraphDataWithoutPaintRecurse(sparklineData, "", this.o.getClass(), this.o);
        }
    }

    void UpdateGraphDataWithoutPaintRecurse(SparklineData sparklineData, String string, Class clazz, Object object) {
        if (sparklineData.chart == null) {
            return;
        }
        if (object instanceof Enum || clazz.equals(String.class)) {
            return;
        }
        if (clazz.isPrimitive() || clazz.equals(Byte.TYPE)) {
            if (sparklineData.name.equals(string)) {
                double d = Double.NaN;
                if (object instanceof Double) {
                    d = (Double)object;
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                }
                ITrace2D iTrace2D = (ITrace2D)sparklineData.chart.getTraces().first();
                if (iTrace2D.getMaxX() < (double)this.utime / 1000000.0) {
                    iTrace2D.addPoint((double)this.utime / 1000000.0, d);
                }
                return;
            }
        } else if (clazz.isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.UpdateGraphDataWithoutPaintRecurse(sparklineData, string + "[" + i + "]", clazz.getComponentType(), Array.get(object, i));
            }
        } else {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getFields()) {
                try {
                    this.UpdateGraphDataWithoutPaintRecurse(sparklineData, field.getName(), field.getType(), field.get(object));
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace(System.out);
                }
            }
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public Chart2D InitChart(String string) {
        Chart2D chart2D = new Chart2D();
        Trace2DLtd trace2DLtd = new Trace2DLtd(this.chartData.sparklineChartSize, string);
        chart2D.addTrace((ITrace2D)trace2DLtd);
        TracePainterDisc tracePainterDisc = new TracePainterDisc();
        tracePainterDisc.setDiscSize(2);
        trace2DLtd.addTracePainter((ITracePainter)tracePainterDisc);
        return chart2D;
    }

    class MyViewportChangeListener
    implements ChangeListener {
        MyViewportChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            ObjectPanel.this.updateVisibleSparklines(jViewport);
        }
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ObjectPanel.this.doSparklineInteraction(mouseEvent);
            ObjectPanel.this.repaint();
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (ObjectPanel.this.doSparklineInteraction(mouseEvent)) {
                return;
            }
            int n3 = -1;
            for (int i = 0; i < ObjectPanel.this.sections.size(); ++i) {
                Section section = ObjectPanel.this.sections.get(i);
                if (n < section.x0 || n > section.x1 || n2 < section.y0 || n2 > section.y1) continue;
                n3 = i;
            }
            if (n3 >= 0) {
                ObjectPanel.this.sections.get((int)n3).collapsed ^= true;
            }
            ObjectPanel.this.updateVisibleSparklines(ObjectPanel.this.scrollViewport);
            ObjectPanel.this.repaint();
        }
    }

    class PaintState {
        Color[] indentColors = new Color[]{new Color(255, 255, 255), new Color(230, 230, 255), new Color(200, 200, 255)};
        Graphics g;
        FontMetrics fm;
        JPanel panel;
        int indent_level;
        int color_level;
        int y;
        int textheight;
        int[] x = new int[4];
        int indentpx = 20;
        int maxwidth;
        int nextsection = 0;
        int collapse_depth = 0;

        PaintState() {
        }

        public int beginSection(String string, String string2, String string3) {
            Section section;
            int n;
            if ((n = this.nextsection++) == ObjectPanel.this.sections.size()) {
                section = new Section();
                ObjectPanel.this.sections.add(section);
            }
            section = ObjectPanel.this.sections.get(n);
            if (this.collapse_depth == 0) {
                this.beginColorBlock();
                this.spacer();
                Font font = this.g.getFont();
                this.g.setFont(font.deriveFont(1));
                FontMetrics fontMetrics = this.g.getFontMetrics();
                String string4 = section.collapsed ? "+" : "-";
                this.g.setColor(Color.white);
                this.g.fillRect(this.x[0] + this.indent_level * this.indentpx, this.y, 1, 1);
                this.g.setColor(Color.black);
                String[] stringArray = string.split("\\.");
                String string5 = stringArray[stringArray.length - 1];
                int n2 = fontMetrics.stringWidth(string5);
                int n3 = fontMetrics.stringWidth(string2);
                int n4 = this.x[0] + this.indent_level * this.indentpx;
                int n5 = this.x[0] + this.indent_level * this.indentpx + 10;
                this.g.drawString(string4, n4, this.y);
                this.g.drawString(string5, n5, this.y);
                section.y0 = this.y - this.textheight;
                if (n5 + n2 > this.x[1]) {
                    this.y += this.textheight;
                }
                this.g.drawString(string2, this.x[1], this.y);
                if (this.x[1] + n3 > this.x[2] && string3.length() > 0) {
                    this.y += this.textheight;
                }
                this.g.drawString(string3, this.x[2], this.y);
                this.g.setFont(font);
                section.x0 = this.x[0];
                section.x1 = n3 > 0 ? this.x[1] + n3 + 10 : n5 + n2 + 10;
                section.y1 = this.y;
                this.y += this.textheight;
            } else {
                section.x0 = 0;
                section.x1 = 0;
                section.y0 = 0;
                section.y1 = 0;
            }
            if (ObjectPanel.this.sections.get((int)n).collapsed) {
                ++this.collapse_depth;
            } else if (this.collapse_depth == 0) {
                this.indent();
            }
            return n;
        }

        public void endSection(int n) {
            Section section = ObjectPanel.this.sections.get(n);
            if (ObjectPanel.this.sections.get((int)n).collapsed) {
                --this.collapse_depth;
            }
            if (this.collapse_depth == 0) {
                this.unindent();
            }
            this.spacer();
            this.endColorBlock();
            this.spacer();
        }

        public void drawStrings(String string, String string2, String string3, boolean bl) {
            if (this.collapse_depth > 0) {
                return;
            }
            Font font = this.g.getFont();
            if (bl) {
                this.g.setFont(font.deriveFont(2));
            }
            this.g.drawString(string, this.x[0] + this.indent_level * this.indentpx, this.y);
            this.g.drawString(string2, this.x[1], this.y);
            this.g.drawString(string3, this.x[2], this.y);
            this.y += this.textheight;
            this.g.setFont(font);
        }

        public void drawStringsAndGraph(Class clazz, String string, Object object, boolean bl, int n) {
            Section section = ObjectPanel.this.sections.get(n);
            double d = Double.NaN;
            if (object instanceof Double) {
                d = (Double)object;
            } else if (object instanceof Float) {
                d = ((Float)object).floatValue();
            } else if (object instanceof Integer) {
                d = ((Integer)object).intValue();
            } else if (object instanceof Long) {
                d = ((Long)object).longValue();
            } else if (object instanceof Short) {
                d = ((Short)object).shortValue();
            } else if (object instanceof Byte) {
                d = ((Byte)object).byteValue();
            }
            if (this.collapse_depth > 0) {
                ITrace2D iTrace2D;
                SparklineData sparklineData = section.sparklines.get(string);
                if (sparklineData.chart != null && (iTrace2D = (ITrace2D)sparklineData.chart.getTraces().first()).getMaxX() < (double)ObjectPanel.this.utime / 1000000.0) {
                    iTrace2D.addPoint((double)ObjectPanel.this.utime / 1000000.0, d);
                }
                return;
            }
            if (bl) {
                this.drawStrings(clazz.getName(), string, object.toString(), bl);
                return;
            }
            Color color = this.g.getColor();
            boolean bl2 = false;
            if (ObjectPanel.this.currentlyHoveringSection != null && section == ObjectPanel.this.currentlyHoveringSection && ObjectPanel.this.currentlyHoveringName.equals(string)) {
                bl2 = true;
                this.g.setColor(Color.RED);
            }
            Font font = this.g.getFont();
            this.g.drawString(clazz.getName(), this.x[0] + this.indent_level * this.indentpx, this.y);
            this.g.drawString(string, this.x[1], this.y);
            if (clazz.equals(Byte.TYPE)) {
                this.g.drawString(String.format("0x%02X   %03d   %+04d   %c", object, ((Byte)object).intValue() & 0xFF, object, (Byte)object & 0xFF), this.x[2], this.y);
            } else {
                this.g.drawString(object.toString(), this.x[2], this.y);
            }
            this.g.setColor(color);
            if (!Double.isNaN(d)) {
                SparklineData sparklineData = section.sparklines.get(string);
                if (sparklineData.chart == null) {
                    sparklineData.chart = ObjectPanel.this.InitChart(string);
                }
                Chart2D chart2D = sparklineData.chart;
                ITrace2D iTrace2D = (ITrace2D)chart2D.getTraces().first();
                sparklineData.xmin = this.x[3];
                sparklineData.xmax = this.x[3] + 150;
                if (iTrace2D.getMaxX() < (double)ObjectPanel.this.utime / 1000000.0) {
                    iTrace2D.addPoint((double)ObjectPanel.this.utime / 1000000.0, d);
                }
                sparklineData.lastDrawNumber = ObjectPanel.this.currentDrawNumber;
                this.DrawSparkline(this.x[3], this.y, iTrace2D, bl2);
            }
            this.y += this.textheight;
            this.g.setFont(font);
            this.g.setColor(color);
        }

        public void DrawSparkline(int n, int n2, ITrace2D iTrace2D, boolean bl) {
            if (iTrace2D.getSize() < 2) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)this.g;
            Iterator iterator = iTrace2D.iterator();
            int n3 = this.textheight;
            double d = 5.0;
            if (iTrace2D.getMaxX() == iTrace2D.getMinX()) {
                return;
            }
            Color color = Color.RED;
            Color color2 = Color.BLACK;
            if (bl) {
                Color color3 = color;
                color = color2;
                color2 = color3;
            }
            double d2 = (double)ObjectPanel.this.utime / 1000000.0 - d;
            double d3 = 150.0 / d;
            if (iTrace2D.getMaxY() == iTrace2D.getMinY()) {
                graphics2D.setColor(color2);
                ITracePoint2D iTracePoint2D = (ITracePoint2D)iterator.next();
                int n4 = (int)((iTracePoint2D.getX() - d2) * d3) + n;
                if (n4 < n) {
                    n4 = n;
                }
                graphics2D.drawLine(n4, n2 - (int)((double)n3 / 2.0), n + 150, n2 - (int)((double)n3 / 2.0));
                graphics2D.setColor(color);
                graphics2D.fillOval(n + 150 - 1, n2 - (int)((double)n3 / 2.0) - 1, 3, 3);
                return;
            }
            double d4 = (double)n3 / (iTrace2D.getMaxY() - iTrace2D.getMinY());
            graphics2D.setColor(color2);
            boolean bl2 = true;
            double d5 = 0.0;
            double d6 = 0.0;
            while (iterator.hasNext()) {
                ITracePoint2D iTracePoint2D = (ITracePoint2D)iterator.next();
                if (bl2) {
                    bl2 = false;
                    d5 = (iTracePoint2D.getX() - d2) * d3 + (double)n;
                    d6 = (double)n2 - (iTracePoint2D.getY() - iTrace2D.getMinY()) * d4;
                } else {
                    double d7 = (iTracePoint2D.getX() - d2) * d3 + (double)n;
                    double d8 = (double)n2 - (iTracePoint2D.getY() - iTrace2D.getMinY()) * d4;
                    if (d7 >= (double)n && d5 >= (double)n) {
                        graphics2D.drawLine((int)d5, (int)d6, (int)d7, (int)d8);
                    }
                    d5 = d7;
                    d6 = d8;
                }
                if (iterator.hasNext()) continue;
                graphics2D.setColor(color);
                graphics2D.fillOval((int)d5 - 1, (int)d6 - 1, 3, 3);
                graphics2D.setColor(color2);
            }
        }

        public void spacer() {
            if (this.collapse_depth > 0) {
                return;
            }
            this.y += this.textheight / 2;
        }

        public void beginColorBlock() {
            if (this.collapse_depth > 0) {
                return;
            }
            ++this.color_level;
            this.g.setColor(this.indentColors[this.color_level % this.indentColors.length]);
            this.g.fillRect(this.x[0] + this.indent_level * this.indentpx - this.indentpx / 2, this.y - this.fm.getMaxAscent(), ObjectPanel.this.getWidth(), ObjectPanel.this.getHeight());
            this.g.setColor(Color.black);
        }

        public void endColorBlock() {
            if (this.collapse_depth > 0) {
                return;
            }
            --this.color_level;
            this.g.setColor(this.indentColors[this.color_level % this.indentColors.length]);
            this.g.fillRect(this.x[0] + this.indent_level * this.indentpx - this.indentpx / 2, this.y - this.fm.getMaxAscent(), ObjectPanel.this.getWidth(), ObjectPanel.this.getHeight());
            this.g.setColor(Color.black);
        }

        public void indent() {
            ++this.indent_level;
        }

        public void unindent() {
            --this.indent_level;
        }

        public void finish() {
            this.g.setColor(Color.white);
            this.g.fillRect(0, this.y, ObjectPanel.this.getWidth(), ObjectPanel.this.getHeight());
        }
    }

    class SparklineData {
        int xmin;
        int xmax;
        int ymin;
        int ymax;
        boolean isHovering;
        Chart2D chart;
        String name;
        Section section;
        int lastDrawNumber = 0;

        SparklineData() {
        }
    }

    class Section {
        int x0;
        int y0;
        int x1;
        int y1;
        boolean collapsed;
        HashMap<String, SparklineData> sparklines = new HashMap();
    }
}

