/*
 * Decompiled with CFR 0.152.
 */
package lcm.logging;

import java.io.IOException;
import lcm.lcm.LCMDataOutputStream;
import lcm.lcm.LCMEncodable;
import lcm.util.BufferedRandomAccessFile;

public class Log {
    BufferedRandomAccessFile raf;
    static final int LOG_MAGIC = -308159999;
    String path;
    long numMessagesWritten = 0L;

    public Log(String string, String string2) throws IOException {
        this.path = string;
        this.raf = new BufferedRandomAccessFile(string, string2);
    }

    public String getPath() {
        return this.path;
    }

    public void flush() throws IOException {
        this.raf.flush();
    }

    public synchronized Event readNext() throws IOException {
        int n = 0;
        Event event = new Event();
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n = n << 8 | (n4 = this.raf.readByte() & 0xFF)) != -308159999) {
                continue;
            }
            event.eventNumber = this.raf.readLong();
            event.utime = this.raf.readLong();
            n2 = this.raf.readInt();
            n3 = this.raf.readInt();
            if (n2 > 0 && n3 > 0 && n2 < 256 && n3 < 0x1000000) break;
            System.out.printf("Bad log event eventnumber = 0x%08x utime = 0x%08x channellen = 0x%08x datalen=0x%08x\n", event.eventNumber, event.utime, n2, n3);
        }
        byte[] byArray = new byte[n2];
        event.data = new byte[n3];
        this.raf.readFully(byArray);
        event.channel = new String(byArray);
        this.raf.readFully(event.data);
        return event;
    }

    public synchronized double getPositionFraction() throws IOException {
        return (double)this.raf.getFilePointer() / (double)this.raf.length();
    }

    public synchronized void seekPositionFraction(double d) throws IOException {
        this.raf.seek((long)((double)this.raf.length() * d));
    }

    public synchronized void write(Event event) throws IOException {
        byte[] byArray = event.channel.getBytes();
        this.raf.writeInt(-308159999L);
        this.raf.writeLong(event.eventNumber);
        this.raf.writeLong(event.utime);
        this.raf.writeInt(byArray.length);
        this.raf.writeInt(event.data.length);
        this.raf.write(byArray, 0, byArray.length);
        this.raf.write(event.data, 0, event.data.length);
    }

    public synchronized void write(long l, String string, LCMEncodable lCMEncodable) throws IOException {
        Event event = new Event();
        event.utime = l;
        event.channel = string;
        LCMDataOutputStream lCMDataOutputStream = new LCMDataOutputStream();
        lCMEncodable.encode(lCMDataOutputStream);
        event.data = lCMDataOutputStream.toByteArray();
        event.eventNumber = this.numMessagesWritten++;
        this.write(event);
    }

    public synchronized void close() throws IOException {
        this.raf.close();
    }

    public static class Event {
        public long utime;
        public long eventNumber;
        public byte[] data;
        public String channel;
    }
}

