/*
 * Decompiled with CFR 0.152.
 */
package lcm.logging;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MouseInputAdapter;
import lcm.logging.JScrubberListener;

public class JScrubber
extends JComponent {
    static final int BARHEIGHT = 5;
    static final int KNOBSIZE = 10;
    static final int MARGIN = 10;
    static final int MIN_HEIGHT = 55;
    static final int BOOKMARK_HEIGHT = 15;
    static final int BOOKMARK_WIDTH = 6;
    static final int CLICK_CLOSENESS = 5;
    static final int REPEAT_DOT_SIZE = 4;
    double position = 0.5;
    double zoomfrac = 0.1;
    double zoom0;
    double zoom1;
    int cy;
    int cy2;
    int lastDrawX = -1;
    int lastDrawX2 = -1;
    ArrayList<JScrubberListener> listeners = new ArrayList();
    boolean inhibitGeometryChanges = false;
    JPopupMenu popupMenu = new JPopupMenu();
    double popupPosition;
    int mouseDownRow = 0;
    public static final int BOOKMARK_PLAIN = 0;
    public static final int BOOKMARK_LREPEAT = 1;
    public static final int BOOKMARK_RREPEAT = 2;
    ArrayList<Bookmark> bookmarks = new ArrayList();

    public JScrubber() {
        MyMouseAdapter myMouseAdapter = new MyMouseAdapter();
        this.addMouseListener(myMouseAdapter);
        this.addMouseMotionListener(myMouseAdapter);
        this.popupMenu.add(new PopupAction("Bookmark", 0));
        this.popupMenu.add(new PopupAction("Right repeat :]", 2));
        this.popupMenu.add(new PopupAction("Left repeat [:", 1));
        this.popupMenu.addSeparator();
        int[] nArray = new int[]{10, 20, 50, 100, 200, 500, 1000};
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < nArray.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Zoom " + nArray[i] + "x");
            jRadioButtonMenuItem.addActionListener(new ZoomAction("foo", nArray[i]));
            buttonGroup.add(jRadioButtonMenuItem);
            this.popupMenu.add(jRadioButtonMenuItem);
            if (i != 3) continue;
            jRadioButtonMenuItem.setSelected(true);
            this.zoomfrac = 1.0 / (double)nArray[i];
        }
        this.popupMenu.addSeparator();
        this.popupMenu.add(new ExportAction());
    }

    public void clearBookmarks() {
        this.bookmarks = new ArrayList();
        this.repaint();
    }

    public void addBookmark(int n, double d) {
        this.bookmarks.add(new Bookmark(d, n));
        this.repaint();
    }

    public ArrayList<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public double getZoomFraction() {
        return this.zoomfrac;
    }

    public void setZoomFraction(double d) {
        this.zoomfrac = d;
        this.updateGeometry();
        this.repaint();
    }

    public void addScrubberListener(JScrubberListener jScrubberListener) {
        this.listeners.add(jScrubberListener);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 55);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension((int)dimension.getWidth(), (int)Math.max(dimension.getHeight(), 55.0));
    }

    int getX(double d) {
        return (int)(10.0 + d * (double)(this.getWidth() - 20));
    }

    int getX2(double d) {
        return this.getX((d - this.zoom0) / (this.zoom1 - this.zoom0));
    }

    double getPosition(int n) {
        double d = ((double)n - 10.0) / (double)(this.getWidth() - 20);
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    double getPosition2(int n) {
        double d = ((double)n - 10.0) / (double)(this.getWidth() - 20);
        if (d < 0.0) {
            return this.zoom0;
        }
        if (d > 1.0) {
            return this.zoom1;
        }
        double d2 = d * (this.zoom1 - this.zoom0) + this.zoom0;
        return d2;
    }

    int getRow(int n, int n2) {
        return n2 > (this.cy + this.cy2) / 2 ? 1 : 0;
    }

    double getPosition(int n, int n2) {
        double d = this.getRow(n, n2) == 0 ? this.getPosition(n) : this.getPosition2(n);
        return d;
    }

    double getPosition(int n, int n2, int n3) {
        if (n3 == 1) {
            return this.getPosition2(n);
        }
        return this.getPosition(n);
    }

    void updateGeometry() {
        if (this.inhibitGeometryChanges) {
            return;
        }
        if (this.position < this.zoomfrac / 2.0) {
            this.zoom0 = 0.0;
            this.zoom1 = this.zoomfrac;
        } else if (this.position > 1.0 - this.zoomfrac / 2.0) {
            this.zoom0 = 1.0 - this.zoomfrac;
            this.zoom1 = 1.0;
        } else {
            this.zoom0 = this.position - this.zoomfrac / 2.0;
            this.zoom1 = this.position + this.zoomfrac / 2.0;
        }
        this.cy = this.getHeight() / 3;
        this.cy2 = this.cy + 20;
    }

    void drawBookmark(Graphics graphics, Bookmark bookmark, int n, int n2) {
        graphics.setColor(new Color(0, 200, 0));
        graphics.fillRect(n - 3, n2 - 7, 6, 15);
        graphics.setColor(new Color(0, 100, 0));
        graphics.drawRect(n - 3, n2 - 7, 6, 15);
        if (bookmark.type == 1) {
            graphics.setColor(new Color(0, 50, 0));
            graphics.fillRect(n + 3, n2 - 7, 4, 4);
            graphics.fillRect(n + 3, n2 + 7 - 4, 4, 4);
        }
        if (bookmark.type == 2) {
            graphics.setColor(new Color(0, 50, 0));
            graphics.fillRect(n - 3 - 4, n2 - 7, 4, 4);
            graphics.fillRect(n - 3 - 4, n2 + 7 - 4, 4, 4);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 4;
        int n4 = 10;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        double d = (this.position - this.zoom0) / this.zoomfrac;
        graphics.setColor(Color.lightGray);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(this.getX(this.zoom0), this.cy + 2 + 1);
        generalPath.lineTo(this.getX(this.zoom1), this.cy + 2 + 1);
        generalPath.lineTo(this.getX(1.0), this.cy2 - 2);
        generalPath.lineTo(this.getX(0.0), this.cy2 - 2);
        generalPath.closePath();
        graphics2D.fill(generalPath);
        graphics.setColor(new Color(150, 150, 255));
        graphics.fillRect(10, this.cy - 2, n - 20, 5);
        graphics.setColor(Color.blue);
        graphics.drawRect(10, this.cy - 2, n - 20, 5);
        graphics.setColor(new Color(150, 255, 255));
        graphics.fillRect(10, this.cy2 - 2, n - 20, 5);
        graphics.setColor(Color.blue);
        graphics.drawRect(10, this.cy2 - 2, n - 20, 5);
        graphics.setColor(Color.darkGray);
        graphics.fillRect(this.getX(this.zoom0), this.cy - 1, this.getX(this.zoom1) - this.getX(this.zoom0), 5);
        for (Bookmark bookmark : this.bookmarks) {
            this.drawBookmark(graphics, bookmark, this.getX(bookmark.position), this.cy);
            if (!(bookmark.position >= this.zoom0) || !(bookmark.position <= this.zoom1)) continue;
            this.drawBookmark(graphics, bookmark, this.getX2(bookmark.position), this.cy2);
        }
        graphics.setColor(Color.yellow);
        graphics.fillOval(this.getX(this.position) - 5, this.cy - 5, 10, 10);
        graphics.setColor(Color.black);
        graphics.drawOval(this.getX(this.position) - 5, this.cy - 5, 10, 10);
        graphics.setColor(Color.yellow);
        graphics.fillOval(this.getX2(this.position) - 5, this.cy2 - 5, 10, 10);
        graphics.setColor(Color.black);
        graphics.drawOval(this.getX2(this.position) - 5, this.cy2 - 5, 10, 10);
        this.lastDrawX = this.getX(this.position);
        this.lastDrawX2 = this.getX2(this.position);
    }

    void userSet(double d) {
        this.position = d;
        for (JScrubberListener jScrubberListener : this.listeners) {
            jScrubberListener.scrubberMovedByUser(this, this.position);
        }
        this.updateGeometry();
        this.repaint();
    }

    public synchronized void set(double d) {
        double d2 = this.position;
        this.position = d;
        this.updateGeometry();
        if (Math.abs(this.getX(this.position) - this.lastDrawX) > 1 || Math.abs(this.getX2(this.position) - this.lastDrawX2) > 1) {
            this.repaint();
        }
        for (Bookmark bookmark : this.bookmarks) {
            if (bookmark.type != 2 || !(bookmark.position > d2) || !(bookmark.position <= d)) continue;
            Bookmark bookmark2 = null;
            for (Bookmark bookmark3 : this.bookmarks) {
                if (!(bookmark3.position < bookmark.position) || bookmark3.type != 1 || bookmark2 != null && !(bookmark3.position > bookmark2.position)) continue;
                bookmark2 = bookmark3;
            }
            double d3 = bookmark2 == null ? 0.0 : bookmark2.position;
            for (JScrubberListener jScrubberListener : this.listeners) {
                jScrubberListener.scrubberPassedRepeat(this, bookmark.position, d3);
            }
        }
    }

    class MyMouseAdapter
    extends MouseInputAdapter {
        Bookmark trackbookmark;

        MyMouseAdapter() {
        }

        Bookmark findBookmark(double d, double d2) {
            double d3 = d2;
            Bookmark bookmark = null;
            for (Bookmark bookmark2 : JScrubber.this.bookmarks) {
                double d4 = Math.abs(d - bookmark2.position);
                if (!(d4 < d3)) continue;
                bookmark = bookmark2;
                d3 = d4;
            }
            return bookmark;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JScrubber.this.mouseDownRow = JScrubber.this.getRow(mouseEvent.getX(), mouseEvent.getY());
            double d = JScrubber.this.getPosition(mouseEvent.getX(), mouseEvent.getY(), JScrubber.this.mouseDownRow);
            double d2 = JScrubber.this.getPosition(mouseEvent.getX() + 5, mouseEvent.getY(), JScrubber.this.mouseDownRow) - d;
            if (mouseEvent.getButton() == 3) {
                this.trackbookmark = this.findBookmark(d, d2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.trackbookmark != null) {
                if (this.trackbookmark.position == 0.0 || this.trackbookmark.position == 1.0) {
                    JScrubber.this.bookmarks.remove(this.trackbookmark);
                    JScrubber.this.repaint();
                }
                this.trackbookmark = null;
            }
            JScrubber.this.inhibitGeometryChanges = false;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            boolean bl = (n & 0x40) > 0;
            boolean bl2 = (n & 0x80) > 0;
            boolean bl3 = bl & bl2;
            boolean bl4 = !((bl &= !bl3) | (bl2 &= !bl3) | bl3);
            double d = JScrubber.this.getPosition(mouseEvent.getX() + 5, mouseEvent.getY()) - JScrubber.this.position;
            double d2 = JScrubber.this.getPosition(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.getButton() == 1) {
                Bookmark bookmark = this.findBookmark(d2, d);
                if (bookmark == null) {
                    JScrubber.this.userSet(d2);
                } else {
                    JScrubber.this.userSet(bookmark.position);
                }
            }
            if (mouseEvent.getButton() == 3) {
                JScrubber.this.popupPosition = d2;
                JScrubber.this.popupMenu.show(JScrubber.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            double d = JScrubber.this.getPosition(mouseEvent.getX(), mouseEvent.getY(), JScrubber.this.mouseDownRow);
            JScrubber.this.inhibitGeometryChanges = JScrubber.this.mouseDownRow == 1;
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                JScrubber.this.userSet(d);
            }
            if ((mouseEvent.getModifiers() & 4) != 0 && this.trackbookmark != null) {
                this.trackbookmark.position = d;
                JScrubber.this.repaint();
            }
        }
    }

    class PopupAction
    extends AbstractAction {
        int op;

        public PopupAction(String string, int n) {
            super(string);
            this.op = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JScrubber.this.bookmarks.add(new Bookmark(JScrubber.this.popupPosition, this.op));
            JScrubber.this.repaint();
        }
    }

    class ZoomAction
    extends AbstractAction {
        int zoom;

        public ZoomAction(String string, int n) {
            super(string);
            this.zoom = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JScrubber.this.setZoomFraction(1.0 / (double)this.zoom);
        }
    }

    class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super("Export log snippet...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2 = new Bookmark(0.0, 0);
            Object object3 = new Bookmark(1.0, 0);
            if (JScrubber.this.bookmarks.size() == 0) {
                System.out.println("didn't find bookmark region");
                return;
            }
            if (JScrubber.this.bookmarks.size() == 1) {
                object = JScrubber.this.bookmarks.get(0);
                if (JScrubber.this.position > ((Bookmark)object).position) {
                    object2 = object;
                } else {
                    object3 = object;
                }
            } else if (JScrubber.this.bookmarks.size() == 2) {
                object2 = JScrubber.this.bookmarks.get(0);
                object3 = JScrubber.this.bookmarks.get(1);
                if (((Bookmark)object2).position > ((Bookmark)object3).position) {
                    object = object2;
                    object3 = object2 = object3;
                }
            } else {
                for (Bookmark object4 : JScrubber.this.bookmarks) {
                    if (object4.position < JScrubber.this.position && (object2 == null || ((Bookmark)object2).position < object4.position)) {
                        object2 = object4;
                    }
                    if (!(object4.position > JScrubber.this.position) || object3 != null && !(((Bookmark)object3).position > object4.position)) continue;
                    object3 = object4;
                }
            }
            for (JScrubberListener jScrubberListener : JScrubber.this.listeners) {
                jScrubberListener.scrubberExportRegion(JScrubber.this, ((Bookmark)object2).position, ((Bookmark)object3).position);
            }
        }
    }

    class Bookmark {
        double position;
        int type;

        Bookmark(double d, int n) {
            this.position = d;
            this.type = n;
        }
    }
}

