/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public class TCPService {
    ServerSocket serverSocket;
    AcceptThread acceptThread;
    ArrayList<ClientThread> clients = new ArrayList();
    ReadWriteLock clients_lock = new ReentrantReadWriteLock();
    int bytesCount = 0;

    public TCPService(int n) throws IOException {
        this.serverSocket = new ServerSocket(n);
        this.acceptThread = new AcceptThread();
        this.acceptThread.start();
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            long l3 = System.currentTimeMillis();
            double d = (double)(l3 - l2) / 1000.0;
            l2 = l3;
            System.out.printf("%10.3f : %10.1f kB/s, %d clients\n", (double)(l3 - l) / 1000.0, (double)this.bytesCount / 1024.0 / d, this.clients.size());
            this.bytesCount = 0;
        }
        this.closeResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeResources() throws IOException {
        this.acceptThread.interrupt();
        this.serverSocket.close();
        ArrayList<ClientThread> arrayList = this.clients;
        synchronized (arrayList) {
            for (ClientThread clientThread : this.clients) {
                clientThread.closeResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relay(byte[] byArray, byte[] byArray2) {
        String string = new String(byArray);
        try {
            this.clients_lock.readLock().lock();
            for (ClientThread clientThread : this.clients) {
                clientThread.send(string, byArray, byArray2);
            }
        }
        finally {
            this.clients_lock.readLock().unlock();
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n = 7700;
            if (stringArray.length > 0) {
                n = Integer.parseInt(stringArray[0]);
            }
            new TCPService(n);
        }
        catch (IOException iOException) {
            System.out.println("Ex: " + iOException);
        }
    }

    class ClientThread
    extends Thread {
        Socket sock;
        DataInputStream ins;
        DataOutputStream outs;
        ArrayList<SubscriptionRecord> subscriptions = new ArrayList();
        ReadWriteLock subscriptions_lock = new ReentrantReadWriteLock();

        public ClientThread(Socket socket) throws IOException {
            this.sock = socket;
            this.ins = new DataInputStream(socket.getInputStream());
            this.outs = new DataOutputStream(socket.getOutputStream());
            this.outs.writeInt(678828026);
            this.outs.writeInt(256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block13: while (true) {
                    byte[] byArray;
                    int n;
                    int n2;
                    if ((n2 = this.ins.readInt()) == 1) {
                        n = this.ins.readInt();
                        byArray = new byte[n];
                        this.ins.readFully(byArray);
                        int n3 = this.ins.readInt();
                        byte[] byArray2 = new byte[n3];
                        this.ins.readFully(byArray2);
                        TCPService.this.relay(byArray, byArray2);
                        TCPService.this.bytesCount += n + n3 + 8;
                        continue;
                    }
                    if (n2 == 2) {
                        n = this.ins.readInt();
                        byArray = new byte[n];
                        this.ins.readFully(byArray);
                        try {
                            this.subscriptions_lock.writeLock().lock();
                            this.subscriptions.add(new SubscriptionRecord(new String(byArray)));
                        }
                        finally {
                            this.subscriptions_lock.writeLock().unlock();
                        }
                        continue;
                    }
                    if (n2 != 3) continue;
                    n = this.ins.readInt();
                    byArray = new byte[n];
                    this.ins.readFully(byArray);
                    String string = new String(byArray);
                    try {
                        this.subscriptions_lock.writeLock().lock();
                        int n4 = 0;
                        int n5 = this.subscriptions.size();
                        while (true) {
                            if (n4 >= n5) continue block13;
                            if (this.subscriptions.get((int)n4).regex.equals(string)) {
                                this.subscriptions.remove(n4);
                                continue block13;
                            }
                            ++n4;
                        }
                    }
                    finally {
                        this.subscriptions_lock.writeLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                try {
                    this.closeResources();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                try {
                    TCPService.this.clients_lock.writeLock().lock();
                    TCPService.this.clients.remove(this);
                }
                finally {
                    TCPService.this.clients_lock.writeLock().unlock();
                }
                return;
            }
        }

        public void closeResources() throws IOException {
            this.sock.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void send(String string, byte[] byArray, byte[] byArray2) {
            try {
                SubscriptionRecord subscriptionRecord;
                this.subscriptions_lock.readLock().lock();
                Iterator<SubscriptionRecord> iterator = this.subscriptions.iterator();
                do {
                    if (!iterator.hasNext()) return;
                    subscriptionRecord = iterator.next();
                } while (!subscriptionRecord.pat.matcher(string).matches());
                DataOutputStream dataOutputStream = this.outs;
                synchronized (dataOutputStream) {
                    this.outs.writeInt(1);
                    this.outs.writeInt(byArray.length);
                    this.outs.write(byArray);
                    this.outs.writeInt(byArray2.length);
                    this.outs.write(byArray2);
                    this.outs.flush();
                    return;
                }
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                this.subscriptions_lock.readLock().unlock();
            }
        }

        class SubscriptionRecord {
            String regex;
            Pattern pat;

            SubscriptionRecord(String string) {
                this.regex = string;
                this.pat = Pattern.compile(string);
            }
        }
    }

    class AcceptThread
    extends Thread {
        AcceptThread() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Socket socket = TCPService.this.serverSocket.accept();
                    ClientThread clientThread = new ClientThread(socket);
                    clientThread.start();
                    try {
                        TCPService.this.clients_lock.writeLock().lock();
                        TCPService.this.clients.add(clientThread);
                    }
                    finally {
                        TCPService.this.clients_lock.writeLock().unlock();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

