/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import lcm.lcm.LCM;
import lcm.lcm.Provider;
import lcm.lcm.URLParser;

public class TCPProvider
implements Provider {
    LCM lcm;
    static final int DEFAULT_PORT = 7700;
    static final String DEFAULT_NETWORK = "127.0.0.1:7700";
    InetAddress inetAddr;
    int inetPort;
    TCPThread tcp;
    public static final int MAGIC_SERVER = 678828026;
    public static final int MAGIC_CLIENT = 678828027;
    public static final int VERSION = 256;
    public static final int MESSAGE_TYPE_PUBLISH = 1;
    public static final int MESSAGE_TYPE_SUBSCRIBE = 2;
    public static final int MESSAGE_TYPE_UNSUBSCRIBE = 3;
    HashSet<String> subscriptions = new HashSet();

    public TCPProvider(LCM lCM, URLParser uRLParser) throws IOException {
        this.lcm = lCM;
        String[] stringArray = uRLParser.get("network", DEFAULT_NETWORK).split(":");
        if (stringArray.length == 1) {
            this.inetAddr = InetAddress.getByName(stringArray[0]);
            this.inetPort = 7700;
        } else if (stringArray.length == 2) {
            this.inetAddr = InetAddress.getByName(stringArray[0]);
            this.inetPort = Integer.valueOf(stringArray[1]);
        } else {
            System.err.println("TCPProvider: Don't know how to parse " + uRLParser.get("network", DEFAULT_NETWORK));
            System.exit(-1);
        }
        this.tcp = new TCPThread();
        this.tcp.start();
    }

    @Override
    public synchronized void publish(String string, byte[] byArray, int n, int n2) {
        try {
            this.publishEx(string, byArray, n, n2);
        }
        catch (Exception exception) {
            System.err.println("TCPProvider ex: " + exception);
        }
    }

    byte[] stringToBytes(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("lcm.TCPProvider: Bad channel name" + string);
            throw new RuntimeException("Don't know how to recover from this");
        }
    }

    @Override
    public synchronized void subscribe(String string) {
        this.subscriptions.add(string);
        this.tcp.sendSubscribe(string);
    }

    @Override
    public synchronized void unsubscribe(String string) {
        this.subscriptions.remove(string);
        this.tcp.sendUnsubscribe(string);
    }

    @Override
    public synchronized void close() {
        if (null != this.tcp) {
            this.tcp.close();
            try {
                this.tcp.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tcp = null;
    }

    static final void safeSleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void publishEx(String string, byte[] byArray, int n, int n2) throws Exception {
        byte[] byArray2 = this.stringToBytes(string);
        int n3 = byArray2.length + n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 + string.length() + 32);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(byArray2.length);
        dataOutputStream.write(byArray2, 0, byArray2.length);
        dataOutputStream.writeInt(n2);
        dataOutputStream.write(byArray, n, n2);
        this.tcp.write(byteArrayOutputStream.toByteArray());
    }

    class TCPThread
    extends Thread {
        Socket sock;
        DataInputStream ins;
        OutputStream outs;
        boolean exit = false;
        int serverVersion;

        TCPThread() {
        }

        synchronized void write(byte[] byArray) throws IOException {
            if (this.outs == null) {
                return;
            }
            this.outs.write(byArray);
            this.outs.flush();
        }

        synchronized void sendSubscribe(String string) {
            byte[] byArray = TCPProvider.this.stringToBytes(string);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() + 8);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(2);
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray, 0, byArray.length);
                this.write(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                System.out.println("ex: " + iOException);
            }
        }

        synchronized void sendUnsubscribe(String string) {
            byte[] byArray = TCPProvider.this.stringToBytes(string);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() + 8);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(3);
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray, 0, byArray.length);
                this.write(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.exit) {
                int n;
                TCPThread tCPThread = this;
                synchronized (tCPThread) {
                    try {
                        this.sock = new Socket(TCPProvider.this.inetAddr, TCPProvider.this.inetPort);
                        OutputStream outputStream = this.sock.getOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                        dataOutputStream.writeInt(678828027);
                        dataOutputStream.writeInt(256);
                        dataOutputStream.flush();
                        this.outs = outputStream;
                        this.ins = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                        n = this.ins.readInt();
                        if (n != 678828026) {
                            this.sock.close();
                            continue;
                        }
                        this.serverVersion = this.ins.readInt();
                    }
                    catch (IOException iOException) {
                        System.err.println("lcm.TCPProvider: Unable to connect to " + TCPProvider.this.inetAddr + ":" + TCPProvider.this.inetPort);
                        TCPProvider.safeSleep(500);
                        continue;
                    }
                    for (String string : TCPProvider.this.subscriptions) {
                        System.out.println("resending subscription " + string);
                        this.sendSubscribe(string);
                    }
                }
                try {
                    while (!this.exit) {
                        int n2 = this.ins.readInt();
                        int n3 = this.ins.readInt();
                        byte[] byArray = new byte[n3];
                        this.ins.readFully(byArray);
                        n = this.ins.readInt();
                        byte[] byArray2 = new byte[n];
                        this.ins.readFully(byArray2);
                        TCPProvider.this.lcm.receiveMessage(new String(byArray), byArray2, 0, byArray2.length);
                    }
                }
                catch (IOException iOException) {
                }
            }
        }

        void close() {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.exit = true;
        }

        OutputStream getOutputStream() {
            return this.outs;
        }
    }
}

