/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.IOException;
import java.util.LinkedList;
import lcm.lcm.LCM;
import lcm.lcm.LCMDataInputStream;
import lcm.lcm.LCMSubscriber;

public class MessageAggregator
implements LCMSubscriber {
    LinkedList<Message> messages = new LinkedList();
    long queue_data_size = 0L;
    long max_queue_data_size = 0x6400000L;
    int max_queue_length = Integer.MAX_VALUE;

    @Override
    public synchronized void messageReceived(LCM lCM, String string, LCMDataInputStream lCMDataInputStream) {
        try {
            byte[] byArray = new byte[lCMDataInputStream.available()];
            lCMDataInputStream.readFully(byArray);
            this.messages.addLast(new Message(string, byArray));
            this.queue_data_size += (long)byArray.length;
            while (this.queue_data_size > this.max_queue_data_size || this.messages.size() > this.max_queue_length) {
                Message message = this.messages.removeFirst();
                this.queue_data_size -= (long)message.data.length;
            }
            this.notify();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void setMaxBufferSize(long l) {
        this.max_queue_data_size = l;
    }

    public synchronized long getMaxBufferSize() {
        return this.max_queue_data_size;
    }

    public synchronized void setMaxMessages(int n) {
        this.max_queue_length = n;
    }

    public synchronized int getMaxMessages() {
        return this.max_queue_length;
    }

    public synchronized Message getNextMessage(long l) {
        if (!this.messages.isEmpty()) {
            Message message = this.messages.removeFirst();
            this.queue_data_size -= (long)message.data.length;
            return message;
        }
        if (l == 0L) {
            return null;
        }
        try {
            if (l > 0L) {
                this.wait(l);
            } else {
                this.wait();
            }
            if (!this.messages.isEmpty()) {
                Message message = this.messages.removeFirst();
                this.queue_data_size -= (long)message.data.length;
                return message;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public synchronized Message getNextMessage() {
        return this.getNextMessage(-1L);
    }

    public synchronized int numMessagesAvailable() {
        return this.messages.size();
    }

    public class Message {
        public final byte[] data;
        public final String channel;

        public Message(String string, byte[] byArray) {
            this.data = byArray;
            this.channel = string;
        }
    }
}

