/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.util.concurrent.LinkedBlockingQueue;
import lcm.lcm.LCM;
import lcm.lcm.Provider;
import lcm.lcm.URLParser;

public class MemqProvider
implements Provider {
    LCM lcm;
    ReaderThread reader;
    LinkedBlockingQueue<Message> queue;

    public MemqProvider(LCM lCM, URLParser uRLParser) {
        this.lcm = lCM;
        this.queue = new LinkedBlockingQueue();
        this.reader = new ReaderThread();
        this.reader.start();
    }

    @Override
    public void publish(String string, byte[] byArray, int n, int n2) {
        Message message = new Message();
        message.channel = string;
        message.data = new byte[n2];
        System.arraycopy(byArray, n, message.data, 0, n2);
        try {
            this.queue.put(message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void subscribe(String string) {
    }

    @Override
    public void unsubscribe(String string) {
    }

    @Override
    public synchronized void close() {
        if (this.reader != null) {
            this.reader.interrupt();
            try {
                this.reader.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.reader = null;
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.runEx();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        void runEx() throws InterruptedException {
            while (true) {
                Message message = MemqProvider.this.queue.take();
                MemqProvider.this.lcm.receiveMessage(message.channel, message.data, 0, message.data.length);
            }
        }
    }

    static class Message {
        String channel;
        byte[] data;

        Message() {
        }
    }
}

