/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.IOException;
import lcm.lcm.LCM;
import lcm.lcm.Provider;
import lcm.lcm.URLParser;
import lcm.logging.Log;

public class LogFileProvider
implements Provider {
    LCM lcm;
    Log log;
    double speed;
    double delay;
    boolean verbose;
    double skip;
    boolean writemode;
    long nanotime_start;
    long utime_start;
    ReaderThread reader;
    boolean publishWarned = false;

    public LogFileProvider(LCM lCM, URLParser uRLParser) throws IOException {
        this.lcm = lCM;
        String string = uRLParser.get("network", "");
        this.speed = uRLParser.get("speed", 1.0);
        this.delay = uRLParser.get("delay", 0.5);
        this.verbose = uRLParser.get("verbose", false);
        this.skip = uRLParser.get("skip", 0.0);
        this.writemode = uRLParser.get("mode", "r").equals("w");
        if (this.writemode) {
            this.log = new Log(string, "rw");
            this.nanotime_start = System.nanoTime();
            this.utime_start = System.currentTimeMillis() * 1000L;
        } else {
            this.log = new Log(string, "r");
            this.reader = new ReaderThread();
            this.reader.start();
        }
    }

    @Override
    public synchronized void publish(String string, byte[] byArray, int n, int n2) {
        if (!this.writemode) {
            if (this.publishWarned) {
                return;
            }
            System.err.println("LogFileProvider opened in read mode, no publishing allowed.");
            this.publishWarned = true;
        }
        Log.Event event = new Log.Event();
        event.utime = this.utime_start + (System.nanoTime() - this.nanotime_start) / 1000L;
        event.eventNumber = 0L;
        event.data = new byte[n2];
        System.arraycopy(byArray, n, event.data, 0, n2);
        event.channel = string;
        try {
            this.log.write(event);
        }
        catch (IOException iOException) {
            System.err.println("ex: " + iOException);
        }
    }

    @Override
    public synchronized void subscribe(String string) {
    }

    @Override
    public void unsubscribe(String string) {
    }

    @Override
    public synchronized void close() {
        if (this.reader != null) {
            this.reader.interrupt();
            try {
                this.reader.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.reader = null;
        try {
            this.log.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.log = null;
    }

    class ReaderThread
    extends Thread {
        ReaderThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.runEx();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        void runEx() throws IOException, InterruptedException {
            LogFileProvider.this.log.seekPositionFraction(LogFileProvider.this.skip);
            while (LogFileProvider.this.lcm.getNumSubscriptions() == 0) {
                Thread.sleep(10L);
            }
            Thread.sleep((int)(LogFileProvider.this.delay * 1000.0));
            long l = System.nanoTime() / 1000L;
            long l2 = -1L;
            double d = 0.0;
            double d2 = 0.0;
            long l3 = -1L;
            while (true) {
                double d3;
                Log.Event event = LogFileProvider.this.log.readNext();
                if (l2 > 0L && (d3 = (double)(event.utime - l2) / 1000000.0) > 0.0 && LogFileProvider.this.speed > 0.0) {
                    d += d3 / LogFileProvider.this.speed;
                }
                l2 = event.utime;
                long l4 = System.nanoTime() / 1000L;
                double d4 = (double)(l4 - l) / 1000000.0;
                l = l4;
                d -= d4;
                if ((d2 += d4) > 1.0 && LogFileProvider.this.verbose) {
                    double d5 = (double)(l2 - l3) / 1000000.0;
                    l3 = l2;
                    System.err.printf("LogFile: rate = %8.3f, position = %8.3f %%\n", d5 / d2, LogFileProvider.this.log.getPositionFraction() * 100.0);
                    d2 = 0.0;
                }
                if (d > 0.001) {
                    int n = (int)(d * 1000.0);
                    Thread.sleep(n);
                }
                LogFileProvider.this.lcm.receiveMessage(event.channel, event.data, 0, event.data.length);
            }
        }
    }
}

