/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.DataOutput;

public final class LCMDataOutputStream
implements DataOutput {
    byte[] buf;
    int pos;

    public LCMDataOutputStream() {
        this(512);
    }

    public LCMDataOutputStream(int n) {
        this.buf = new byte[n];
    }

    public LCMDataOutputStream(byte[] byArray) {
        this.buf = byArray;
    }

    public void reset() {
        this.pos = 0;
    }

    void ensureSpace(int n) {
        if (this.pos + n >= this.buf.length) {
            int n2;
            for (n2 = this.buf.length; n2 < this.pos + n; n2 *= 2) {
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.pos);
            this.buf = byArray;
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.ensureSpace(byArray.length);
        System.arraycopy(byArray, 0, this.buf, this.pos, byArray.length);
        this.pos += byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.ensureSpace(n2);
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
    }

    public void writeCharsAsBytes(char[] cArray) {
        this.ensureSpace(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            this.write(cArray[i]);
        }
    }

    @Override
    public void write(int n) {
        this.ensureSpace(1);
        this.buf[this.pos++] = (byte)n;
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.ensureSpace(1);
        this.buf[this.pos++] = bl ? (byte)1 : 0;
    }

    @Override
    public void writeByte(int n) {
        this.ensureSpace(1);
        this.buf[this.pos++] = (byte)n;
    }

    @Override
    public void writeBytes(String string) {
        this.ensureSpace(string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.buf[this.pos++] = (byte)string.charAt(i);
        }
    }

    @Override
    public void writeChar(int n) {
        this.writeShort(n);
    }

    @Override
    public void writeChars(String string) {
        this.ensureSpace(2 * string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.buf[this.pos++] = (byte)(c >>> 8);
            this.buf[this.pos++] = (byte)(c >>> 0);
        }
    }

    public void writeStringZ(String string) {
        this.ensureSpace(string.length() + 1);
        for (int i = 0; i < string.length(); ++i) {
            this.buf[this.pos++] = (byte)string.charAt(i);
        }
        this.buf[this.pos++] = 0;
    }

    @Override
    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeInt(int n) {
        this.ensureSpace(4);
        this.buf[this.pos++] = (byte)(n >>> 24);
        this.buf[this.pos++] = (byte)(n >>> 16);
        this.buf[this.pos++] = (byte)(n >>> 8);
        this.buf[this.pos++] = (byte)(n >>> 0);
    }

    @Override
    public void writeLong(long l) {
        this.ensureSpace(8);
        this.buf[this.pos++] = (byte)(l >>> 56);
        this.buf[this.pos++] = (byte)(l >>> 48);
        this.buf[this.pos++] = (byte)(l >>> 40);
        this.buf[this.pos++] = (byte)(l >>> 32);
        this.buf[this.pos++] = (byte)(l >>> 24);
        this.buf[this.pos++] = (byte)(l >>> 16);
        this.buf[this.pos++] = (byte)(l >>> 8);
        this.buf[this.pos++] = (byte)(l >>> 0);
    }

    @Override
    public void writeShort(int n) {
        this.ensureSpace(2);
        this.buf[this.pos++] = (byte)(n >>> 8);
        this.buf[this.pos++] = (byte)(n >>> 0);
    }

    @Override
    public void writeUTF(String string) {
        assert (false);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.buf, 0, byArray, 0, this.pos);
        return byArray;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int size() {
        return this.pos;
    }
}

