from typing import Any, Dict, List

class _WriteResult:
    @property
    def acknowledged(self) -> bool: ...

class InsertOneResult(_WriteResult):
    @property
    def inserted_id(self) -> Any: ...

class InsertManyResult(_WriteResult):
    @property
    def inserted_ids(self) -> List[Any]: ...

class DeleteResult(_WriteResult):
    @property
    def raw_result(self) -> Any: ...
    @property
    def deleted_count(self) -> int: ...

class BulkWriteResult(_WriteResult):
    @property
    def bulk_api_result(self) -> Dict[str, Any]: ...
    @property
    def inserted_count(self) -> int: ...
    @property
    def matched_count(self) -> int: ...
    @property
    def modified_count(self) -> int: ...
    @property
    def upserted_count(self) -> int: ...
    @property
    def upserted_ids(self) -> Dict[int, Any]: ...

class UpdateResult(_WriteResult):
    @property
    def raw_result(self) -> Any: ...
    @property
    def matched_count(self) -> int: ...
    @property
    def modified_count(self) -> int: ...
    @property
    def upserted_id(self) -> int: ...
