"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplateRequireImdsv2Aspect = exports.InstanceRequireImdsv2Aspect = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const cxapi = require("@aws-cdk/cx-api");
const ec2_generated_1 = require("../ec2.generated");
const instance_1 = require("../instance");
const launch_template_1 = require("../launch-template");
/**
 * Base class for Aspect that makes IMDSv2 required.
 */
class RequireImdsv2Aspect {
    constructor(props) {
        var _c;
        this.suppressWarnings = (_c = props === null || props === void 0 ? void 0 : props.suppressWarnings) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     *
     * @param node The scope to add the warning to.
     * @param message The warning message.
     * @stability stable
     */
    warn(node, message) {
        if (this.suppressWarnings !== true) {
            cdk.Annotations.of(node).addWarning(`${RequireImdsv2Aspect.name} failed on node ${node.node.id}: ${message}`);
        }
    }
}
/**
 * Aspect that applies IMDS configuration on EC2 Instance constructs.
 *
 * This aspect configures IMDS on an EC2 instance by creating a Launch Template with the
 * IMDS configuration and associating that Launch Template with the instance. If an Instance
 * is already associated with a Launch Template, a warning will (optionally) be added to the
 * construct node and it will be skipped.
 *
 * To cover Instances already associated with Launch Templates, use `LaunchTemplateImdsAspect`.
 *
 * @stability stable
 */
class InstanceRequireImdsv2Aspect extends RequireImdsv2Aspect {
    /**
     * @stability stable
     */
    constructor(props) {
        var _c;
        super(props);
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceRequireImdsv2AspectProps(props);
        this.suppressLaunchTemplateWarning = (_c = props === null || props === void 0 ? void 0 : props.suppressLaunchTemplateWarning) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        if (!(node instanceof instance_1.Instance)) {
            return;
        }
        if (node.instance.launchTemplate !== undefined) {
            this.warn(node, 'Cannot toggle IMDSv1 because this Instance is associated with an existing Launch Template.');
            return;
        }
        const launchTemplate = new ec2_generated_1.CfnLaunchTemplate(node, 'LaunchTemplate', {
            launchTemplateData: {
                metadataOptions: {
                    httpTokens: 'required',
                },
            },
        });
        if (core_1.FeatureFlags.of(node).isEnabled(cxapi.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME)) {
            launchTemplate.launchTemplateName = cdk.Names.uniqueId(launchTemplate);
        }
        else {
            launchTemplate.launchTemplateName = `${node.node.id}LaunchTemplate`;
        }
        node.instance.launchTemplate = {
            launchTemplateName: launchTemplate.launchTemplateName,
            version: launchTemplate.getAtt('LatestVersionNumber').toString(),
        };
    }
    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     *
     * @stability stable
     */
    warn(node, message) {
        if (this.suppressLaunchTemplateWarning !== true) {
            super.warn(node, message);
        }
    }
}
exports.InstanceRequireImdsv2Aspect = InstanceRequireImdsv2Aspect;
_a = JSII_RTTI_SYMBOL_1;
InstanceRequireImdsv2Aspect[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceRequireImdsv2Aspect", version: "1.141.0" };
/**
 * Aspect that applies IMDS configuration on EC2 Launch Template constructs.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
 * @stability stable
 */
class LaunchTemplateRequireImdsv2Aspect extends RequireImdsv2Aspect {
    /**
     * @stability stable
     */
    constructor(props) {
        super(props);
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_LaunchTemplateRequireImdsv2AspectProps(props);
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        if (!(node instanceof launch_template_1.LaunchTemplate)) {
            return;
        }
        const launchTemplate = node.node.tryFindChild('Resource');
        const data = launchTemplate.launchTemplateData;
        if (cdk.isResolvableObject(data)) {
            this.warn(node, 'LaunchTemplateData is a CDK token.');
            return;
        }
        const metadataOptions = data.metadataOptions;
        if (cdk.isResolvableObject(metadataOptions)) {
            this.warn(node, 'LaunchTemplateData.MetadataOptions is a CDK token.');
            return;
        }
        const newData = {
            ...data,
            metadataOptions: {
                ...metadataOptions,
                httpTokens: 'required',
            },
        };
        launchTemplate.launchTemplateData = newData;
    }
}
exports.LaunchTemplateRequireImdsv2Aspect = LaunchTemplateRequireImdsv2Aspect;
_b = JSII_RTTI_SYMBOL_1;
LaunchTemplateRequireImdsv2Aspect[_b] = { fqn: "@aws-cdk/aws-ec2.LaunchTemplateRequireImdsv2Aspect", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVxdWlyZS1pbWRzdjItYXNwZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVxdWlyZS1pbWRzdjItYXNwZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHFDQUFxQztBQUNyQyx3Q0FBNkM7QUFDN0MseUNBQXlDO0FBQ3pDLG9EQUFxRDtBQUNyRCwwQ0FBdUM7QUFDdkMsd0RBQW9EO0FBVXBEOztHQUVHO0FBQ0gsTUFBZSxtQkFBbUI7SUFHaEMsWUFBWSxLQUFnQzs7UUFDMUMsSUFBSSxDQUFDLGdCQUFnQixTQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxnQkFBZ0IsbUNBQUksS0FBSyxDQUFDO0tBQzFEOzs7Ozs7OztJQUtTLElBQUksQ0FBQyxJQUFvQixFQUFFLE9BQWU7UUFDbEQsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLEtBQUssSUFBSSxFQUFFO1lBQ2xDLEdBQUcsQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLG1CQUFtQixDQUFDLElBQUksbUJBQW1CLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxLQUFLLE9BQU8sRUFBRSxDQUFDLENBQUM7U0FDL0c7S0FDRjtDQUNGOzs7Ozs7Ozs7Ozs7O0FBU0QsTUFBYSwyQkFBNEIsU0FBUSxtQkFBbUI7Ozs7SUFHbEUsWUFBWSxLQUF3Qzs7UUFDbEQsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDOztRQUNiLElBQUksQ0FBQyw2QkFBNkIsU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsNkJBQTZCLG1DQUFJLEtBQUssQ0FBQztLQUNwRjs7Ozs7O0lBRUQsS0FBSyxDQUFDLElBQW9CO1FBQ3hCLElBQUksQ0FBQyxDQUFDLElBQUksWUFBWSxtQkFBUSxDQUFDLEVBQUU7WUFDL0IsT0FBTztTQUNSO1FBQ0QsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsS0FBSyxTQUFTLEVBQUU7WUFDOUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsNEZBQTRGLENBQUMsQ0FBQztZQUM5RyxPQUFPO1NBQ1I7UUFFRCxNQUFNLGNBQWMsR0FBRyxJQUFJLGlDQUFpQixDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtZQUNuRSxrQkFBa0IsRUFBRTtnQkFDbEIsZUFBZSxFQUFFO29CQUNmLFVBQVUsRUFBRSxVQUFVO2lCQUN2QjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxtQkFBWSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLHNDQUFzQyxDQUFDLEVBQUU7WUFDakYsY0FBYyxDQUFDLGtCQUFrQixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1NBQ3hFO2FBQU07WUFDTCxjQUFjLENBQUMsa0JBQWtCLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsZ0JBQWdCLENBQUM7U0FDckU7UUFDRCxJQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsR0FBRztZQUM3QixrQkFBa0IsRUFBRSxjQUFjLENBQUMsa0JBQWtCO1lBQ3JELE9BQU8sRUFBRSxjQUFjLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUMsUUFBUSxFQUFFO1NBQ2pFLENBQUM7S0FDSDs7Ozs7O0lBRVMsSUFBSSxDQUFDLElBQW9CLEVBQUUsT0FBZTtRQUNsRCxJQUFJLElBQUksQ0FBQyw2QkFBNkIsS0FBSyxJQUFJLEVBQUU7WUFDL0MsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDM0I7S0FDRjs7QUF2Q0gsa0VBd0NDOzs7Ozs7Ozs7QUFNRCxNQUFhLGlDQUFrQyxTQUFRLG1CQUFtQjs7OztJQUN4RSxZQUFZLEtBQThDO1FBQ3hELEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQzs7S0FDZDs7Ozs7O0lBRUQsS0FBSyxDQUFDLElBQW9CO1FBQ3hCLElBQUksQ0FBQyxDQUFDLElBQUksWUFBWSxnQ0FBYyxDQUFDLEVBQUU7WUFDckMsT0FBTztTQUNSO1FBRUQsTUFBTSxjQUFjLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFzQixDQUFDO1FBQy9FLE1BQU0sSUFBSSxHQUFHLGNBQWMsQ0FBQyxrQkFBa0IsQ0FBQztRQUMvQyxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUNoQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxvQ0FBb0MsQ0FBQyxDQUFDO1lBQ3RELE9BQU87U0FDUjtRQUVELE1BQU0sZUFBZSxHQUFJLElBQXFELENBQUMsZUFBZSxDQUFDO1FBQy9GLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxFQUFFO1lBQzNDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLG9EQUFvRCxDQUFDLENBQUM7WUFDdEUsT0FBTztTQUNSO1FBRUQsTUFBTSxPQUFPLEdBQWlEO1lBQzVELEdBQUcsSUFBSTtZQUNQLGVBQWUsRUFBRTtnQkFDZixHQUFHLGVBQWU7Z0JBQ2xCLFVBQVUsRUFBRSxVQUFVO2FBQ3ZCO1NBQ0YsQ0FBQztRQUNGLGNBQWMsQ0FBQyxrQkFBa0IsR0FBRyxPQUFPLENBQUM7S0FDN0M7O0FBL0JILDhFQWdDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEZlYXR1cmVGbGFncyB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY3hhcGkgZnJvbSAnQGF3cy1jZGsvY3gtYXBpJztcbmltcG9ydCB7IENmbkxhdW5jaFRlbXBsYXRlIH0gZnJvbSAnLi4vZWMyLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBJbnN0YW5jZSB9IGZyb20gJy4uL2luc3RhbmNlJztcbmltcG9ydCB7IExhdW5jaFRlbXBsYXRlIH0gZnJvbSAnLi4vbGF1bmNoLXRlbXBsYXRlJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBgUmVxdWlyZUltZHN2MkFzcGVjdGAuXG4gKi9cbmludGVyZmFjZSBSZXF1aXJlSW1kc3YyQXNwZWN0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN1cHByZXNzV2FybmluZ3M/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIEJhc2UgY2xhc3MgZm9yIEFzcGVjdCB0aGF0IG1ha2VzIElNRFN2MiByZXF1aXJlZC5cbiAqL1xuYWJzdHJhY3QgY2xhc3MgUmVxdWlyZUltZHN2MkFzcGVjdCBpbXBsZW1lbnRzIGNkay5JQXNwZWN0IHtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHN1cHByZXNzV2FybmluZ3M6IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IocHJvcHM/OiBSZXF1aXJlSW1kc3YyQXNwZWN0UHJvcHMpIHtcbiAgICB0aGlzLnN1cHByZXNzV2FybmluZ3MgPSBwcm9wcz8uc3VwcHJlc3NXYXJuaW5ncyA/PyBmYWxzZTtcbiAgfVxuXG4gIGFic3RyYWN0IHZpc2l0KG5vZGU6IGNkay5JQ29uc3RydWN0KTogdm9pZDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwcm90ZWN0ZWQgd2Fybihub2RlOiBjZGsuSUNvbnN0cnVjdCwgbWVzc2FnZTogc3RyaW5nKSB7XG4gICAgaWYgKHRoaXMuc3VwcHJlc3NXYXJuaW5ncyAhPT0gdHJ1ZSkge1xuICAgICAgY2RrLkFubm90YXRpb25zLm9mKG5vZGUpLmFkZFdhcm5pbmcoYCR7UmVxdWlyZUltZHN2MkFzcGVjdC5uYW1lfSBmYWlsZWQgb24gbm9kZSAke25vZGUubm9kZS5pZH06ICR7bWVzc2FnZX1gKTtcbiAgICB9XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSW5zdGFuY2VSZXF1aXJlSW1kc3YyQXNwZWN0UHJvcHMgZXh0ZW5kcyBSZXF1aXJlSW1kc3YyQXNwZWN0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3VwcHJlc3NMYXVuY2hUZW1wbGF0ZVdhcm5pbmc/OiBib29sZWFuO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSW5zdGFuY2VSZXF1aXJlSW1kc3YyQXNwZWN0IGV4dGVuZHMgUmVxdWlyZUltZHN2MkFzcGVjdCB7XG4gIHByaXZhdGUgcmVhZG9ubHkgc3VwcHJlc3NMYXVuY2hUZW1wbGF0ZVdhcm5pbmc6IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IocHJvcHM/OiBJbnN0YW5jZVJlcXVpcmVJbWRzdjJBc3BlY3RQcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcbiAgICB0aGlzLnN1cHByZXNzTGF1bmNoVGVtcGxhdGVXYXJuaW5nID0gcHJvcHM/LnN1cHByZXNzTGF1bmNoVGVtcGxhdGVXYXJuaW5nID8/IGZhbHNlO1xuICB9XG5cbiAgdmlzaXQobm9kZTogY2RrLklDb25zdHJ1Y3QpOiB2b2lkIHtcbiAgICBpZiAoIShub2RlIGluc3RhbmNlb2YgSW5zdGFuY2UpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIGlmIChub2RlLmluc3RhbmNlLmxhdW5jaFRlbXBsYXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMud2Fybihub2RlLCAnQ2Fubm90IHRvZ2dsZSBJTURTdjEgYmVjYXVzZSB0aGlzIEluc3RhbmNlIGlzIGFzc29jaWF0ZWQgd2l0aCBhbiBleGlzdGluZyBMYXVuY2ggVGVtcGxhdGUuJyk7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgbGF1bmNoVGVtcGxhdGUgPSBuZXcgQ2ZuTGF1bmNoVGVtcGxhdGUobm9kZSwgJ0xhdW5jaFRlbXBsYXRlJywge1xuICAgICAgbGF1bmNoVGVtcGxhdGVEYXRhOiB7XG4gICAgICAgIG1ldGFkYXRhT3B0aW9uczoge1xuICAgICAgICAgIGh0dHBUb2tlbnM6ICdyZXF1aXJlZCcsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuICAgIGlmIChGZWF0dXJlRmxhZ3Mub2Yobm9kZSkuaXNFbmFibGVkKGN4YXBpLkVDMl9VTklRVUVfSU1EU1YyX0xBVU5DSF9URU1QTEFURV9OQU1FKSkge1xuICAgICAgbGF1bmNoVGVtcGxhdGUubGF1bmNoVGVtcGxhdGVOYW1lID0gY2RrLk5hbWVzLnVuaXF1ZUlkKGxhdW5jaFRlbXBsYXRlKTtcbiAgICB9IGVsc2Uge1xuICAgICAgbGF1bmNoVGVtcGxhdGUubGF1bmNoVGVtcGxhdGVOYW1lID0gYCR7bm9kZS5ub2RlLmlkfUxhdW5jaFRlbXBsYXRlYDtcbiAgICB9XG4gICAgbm9kZS5pbnN0YW5jZS5sYXVuY2hUZW1wbGF0ZSA9IHtcbiAgICAgIGxhdW5jaFRlbXBsYXRlTmFtZTogbGF1bmNoVGVtcGxhdGUubGF1bmNoVGVtcGxhdGVOYW1lLFxuICAgICAgdmVyc2lvbjogbGF1bmNoVGVtcGxhdGUuZ2V0QXR0KCdMYXRlc3RWZXJzaW9uTnVtYmVyJykudG9TdHJpbmcoKSxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIHdhcm4obm9kZTogY2RrLklDb25zdHJ1Y3QsIG1lc3NhZ2U6IHN0cmluZykge1xuICAgIGlmICh0aGlzLnN1cHByZXNzTGF1bmNoVGVtcGxhdGVXYXJuaW5nICE9PSB0cnVlKSB7XG4gICAgICBzdXBlci53YXJuKG5vZGUsIG1lc3NhZ2UpO1xuICAgIH1cbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBMYXVuY2hUZW1wbGF0ZVJlcXVpcmVJbWRzdjJBc3BlY3RQcm9wcyBleHRlbmRzIFJlcXVpcmVJbWRzdjJBc3BlY3RQcm9wcyB7fVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTGF1bmNoVGVtcGxhdGVSZXF1aXJlSW1kc3YyQXNwZWN0IGV4dGVuZHMgUmVxdWlyZUltZHN2MkFzcGVjdCB7XG4gIGNvbnN0cnVjdG9yKHByb3BzPzogTGF1bmNoVGVtcGxhdGVSZXF1aXJlSW1kc3YyQXNwZWN0UHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gIH1cblxuICB2aXNpdChub2RlOiBjZGsuSUNvbnN0cnVjdCk6IHZvaWQge1xuICAgIGlmICghKG5vZGUgaW5zdGFuY2VvZiBMYXVuY2hUZW1wbGF0ZSkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCBsYXVuY2hUZW1wbGF0ZSA9IG5vZGUubm9kZS50cnlGaW5kQ2hpbGQoJ1Jlc291cmNlJykgYXMgQ2ZuTGF1bmNoVGVtcGxhdGU7XG4gICAgY29uc3QgZGF0YSA9IGxhdW5jaFRlbXBsYXRlLmxhdW5jaFRlbXBsYXRlRGF0YTtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChkYXRhKSkge1xuICAgICAgdGhpcy53YXJuKG5vZGUsICdMYXVuY2hUZW1wbGF0ZURhdGEgaXMgYSBDREsgdG9rZW4uJyk7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgbWV0YWRhdGFPcHRpb25zID0gKGRhdGEgYXMgQ2ZuTGF1bmNoVGVtcGxhdGUuTGF1bmNoVGVtcGxhdGVEYXRhUHJvcGVydHkpLm1ldGFkYXRhT3B0aW9ucztcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChtZXRhZGF0YU9wdGlvbnMpKSB7XG4gICAgICB0aGlzLndhcm4obm9kZSwgJ0xhdW5jaFRlbXBsYXRlRGF0YS5NZXRhZGF0YU9wdGlvbnMgaXMgYSBDREsgdG9rZW4uJyk7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgbmV3RGF0YTogQ2ZuTGF1bmNoVGVtcGxhdGUuTGF1bmNoVGVtcGxhdGVEYXRhUHJvcGVydHkgPSB7XG4gICAgICAuLi5kYXRhLFxuICAgICAgbWV0YWRhdGFPcHRpb25zOiB7XG4gICAgICAgIC4uLm1ldGFkYXRhT3B0aW9ucyxcbiAgICAgICAgaHR0cFRva2VuczogJ3JlcXVpcmVkJyxcbiAgICAgIH0sXG4gICAgfTtcbiAgICBsYXVuY2hUZW1wbGF0ZS5sYXVuY2hUZW1wbGF0ZURhdGEgPSBuZXdEYXRhO1xuICB9XG59XG4iXX0=