"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeStarConnectionsSourceAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * A CodePipeline source action for the CodeStar Connections source,
 * which allows connecting to GitHub and BitBucket.
 */
class CodeStarConnectionsSourceAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.SOURCE,
            owner: 'AWS',
            provider: 'CodeStarSourceConnection',
            artifactBounds: common_1.sourceArtifactBounds(),
            outputs: [props.output],
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_CodeStarConnectionsSourceActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeStarConnectionsSourceAction);
            }
            throw error;
        }
        this.props = props;
    }
    /** The variables emitted by this action. */
    get variables() {
        return {
            fullRepositoryName: this.variableExpression('FullRepositoryName'),
            branchName: this.variableExpression('BranchName'),
            authorDate: this.variableExpression('AuthorDate'),
            commitId: this.variableExpression('CommitId'),
            commitMessage: this.variableExpression('CommitMessage'),
            connectionArn: this.variableExpression('ConnectionArn'),
        };
    }
    bound(_scope, _stage, options) {
        // https://docs.aws.amazon.com/codepipeline/latest/userguide/security-iam.html#how-to-update-role-new-services
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: [
                'codestar-connections:UseConnection',
            ],
            resources: [
                this.props.connectionArn,
            ],
        }));
        // the action needs to write the output to the pipeline bucket
        options.bucket.grantReadWrite(options.role);
        options.bucket.grantPutAcl(options.role);
        // if codeBuildCloneOutput is true,
        // save the connectionArn in the Artifact instance
        // to be read by the CodeBuildAction later
        if (this.props.codeBuildCloneOutput === true) {
            this.props.output.setMetadata(CodeStarConnectionsSourceAction._CONNECTION_ARN_PROPERTY, this.props.connectionArn);
        }
        return {
            configuration: {
                ConnectionArn: this.props.connectionArn,
                FullRepositoryId: `${this.props.owner}/${this.props.repo}`,
                BranchName: this.props.branch ?? 'master',
                OutputArtifactFormat: this.props.codeBuildCloneOutput === true
                    ? 'CODEBUILD_CLONE_REF'
                    : undefined,
                DetectChanges: this.props.triggerOnPush,
            },
        };
    }
}
exports.CodeStarConnectionsSourceAction = CodeStarConnectionsSourceAction;
_a = JSII_RTTI_SYMBOL_1;
CodeStarConnectionsSourceAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.CodeStarConnectionsSourceAction", version: "1.194.0" };
/**
 * The name of the property that holds the ARN of the CodeStar Connection
 * inside of the CodePipeline Artifact's metadata.
 *
 * @internal
 */
CodeStarConnectionsSourceAction._CONNECTION_ARN_PROPERTY = 'CodeStarConnectionArnProperty';
//# sourceMappingURL=data:application/json;base64,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