## TorchBlocks

A PyTorch-based toolkit for natural language processing

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black) [![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)

### Requirements

- transformers>=4.1.1
- torch>=1.6.0

TorchBlocks requires Python 3.6+. We recommend installing TorchBlocks in a Linux or OSX environment.

### Installation

Recommended (because of active development):

```shell
git clone https://github.com/lonePatient/TorchBlocks.git
cd TorchBlocks
python setup.py install
```

### Tutorials

* Tutorial 1 (text classification): [task_text_classification_cola.py](https://github.com/lonePatient/TorchBlocks/blob/master/examples/task_text_classification_cola.py)
* Tutorial 2 (siamese similarity): [task_siamese_similarity_afqmc.py](https://github.com/lonePatient/TorchBlocks/blob/master/examples/task_siamese_similarity_afqmc.py)
* Tutorial 3 (sequence labeling): [task_sequence_labeling_ner_crf.py](https://github.com/lonePatient/TorchBlocks/blob/master/examples/task_sequence_labeling_ner_crf.py)
* Tutorial 4 (sentence similarity): [task_sentence_similarity_lcqmc.py](https://github.com/lonePatient/TorchBlocks/blob/master/examples/task_sentence_similarity_lcqmc.py)
* Tutorial 5 (triple similarity): [task_triple_similarity_epidemic.py](https://github.com/lonePatient/TorchBlocks/blob/master/examples/task_triple_similarity_epidemic.py)
* Example scripts for each task: [TorchBlocks/examples/](https://github.com/lonePatient/TorchBlocks/tree/master/examples)

