"""
Main entry point for the Python Iceberg implementation
"""


def main() -> None:
    """Main entry point when module is executed directly"""
    print("Python Iceberg Implementation")
    print("=============================")
    print(
        "This package provides a simplified but powerful Python implementation of Apache Iceberg."
    )
    print("Features: ACID transactions, time travel, and metadata management.")
    print()
    print("To run tests: python -c 'from test_iceberg import main; main()'")
    print("For example:  python -c 'from example import main; main()'")


if __name__ == "__main__":
    main()
