# mypy-boto3-appflow

[![PyPI - mypy-boto3-appflow](https://img.shields.io/pypi/v/mypy-boto3-appflow.svg?color=blue)](https://pypi.org/project/mypy-boto3-appflow)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-appflow.svg?color=blue)](https://pypi.org/project/mypy-boto3-appflow)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Appflow 1.17.14](https://boto3.amazonaws.com/v1/documentation/api/1.17.14/reference/services/appflow.html#Appflow) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-appflow](#mypy-boto3-appflow)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Appflow` service.

```bash
python -m pip install boto3-stubs[appflow]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[appflow]` in your environment: `python -m pip install 'boto3-stubs[appflow]'`

Both type checking and auto-complete should work for `Appflow` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[appflow]` in your environment: `python -m pip install 'boto3-stubs[appflow]'`

Both type checking and auto-complete should work for `Appflow` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[appflow]` in your environment: `python -m pip install 'boto3-stubs[appflow]'`
- Run `mypy` as usual

Type checking should work for `Appflow` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[appflow]` in your environment: `python -m pip install 'boto3-stubs[appflow]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Appflow` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`AppflowClient` provides annotations for `boto3.client("appflow")`.

```python
import boto3

from mypy_boto3_appflow import AppflowClient

client: AppflowClient = boto3.client("appflow")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AppflowClient = session.client("appflow")
```








### Typed dictionations

`mypy_boto3_appflow.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_appflow.type_defs import (
    AggregationConfigTypeDef,
    AmplitudeConnectorProfileCredentialsTypeDef,
    AmplitudeSourcePropertiesTypeDef,
    ConnectorConfigurationTypeDef,
    ConnectorEntityFieldTypeDef,
    ConnectorEntityTypeDef,
    ConnectorMetadataTypeDef,
    ConnectorOAuthRequestTypeDef,
    ConnectorOperatorTypeDef,
    ConnectorProfileCredentialsTypeDef,
    ConnectorProfilePropertiesTypeDef,
    ConnectorProfileTypeDef,
    DatadogConnectorProfileCredentialsTypeDef,
    DatadogConnectorProfilePropertiesTypeDef,
    DatadogSourcePropertiesTypeDef,
    DestinationConnectorPropertiesTypeDef,
    DestinationFieldPropertiesTypeDef,
    DestinationFlowConfigTypeDef,
    DynatraceConnectorProfileCredentialsTypeDef,
    DynatraceConnectorProfilePropertiesTypeDef,
    DynatraceSourcePropertiesTypeDef,
    ErrorHandlingConfigTypeDef,
    ErrorInfoTypeDef,
    EventBridgeDestinationPropertiesTypeDef,
    ExecutionDetailsTypeDef,
    ExecutionRecordTypeDef,
    ExecutionResultTypeDef,
    FieldTypeDetailsTypeDef,
    FlowDefinitionTypeDef,
    GoogleAnalyticsConnectorProfileCredentialsTypeDef,
    GoogleAnalyticsMetadataTypeDef,
    GoogleAnalyticsSourcePropertiesTypeDef,
    IncrementalPullConfigTypeDef,
    InforNexusConnectorProfileCredentialsTypeDef,
    InforNexusConnectorProfilePropertiesTypeDef,
    InforNexusSourcePropertiesTypeDef,
    MarketoConnectorProfileCredentialsTypeDef,
    MarketoConnectorProfilePropertiesTypeDef,
    MarketoSourcePropertiesTypeDef,
    PrefixConfigTypeDef,
    RedshiftConnectorProfileCredentialsTypeDef,
    RedshiftConnectorProfilePropertiesTypeDef,
    RedshiftDestinationPropertiesTypeDef,
    S3DestinationPropertiesTypeDef,
    S3OutputFormatConfigTypeDef,
    S3SourcePropertiesTypeDef,
    SalesforceConnectorProfileCredentialsTypeDef,
    SalesforceConnectorProfilePropertiesTypeDef,
    SalesforceDestinationPropertiesTypeDef,
    SalesforceMetadataTypeDef,
    SalesforceSourcePropertiesTypeDef,
    ScheduledTriggerPropertiesTypeDef,
    ServiceNowConnectorProfileCredentialsTypeDef,
    ServiceNowConnectorProfilePropertiesTypeDef,
    ServiceNowSourcePropertiesTypeDef,
    SingularConnectorProfileCredentialsTypeDef,
    SingularSourcePropertiesTypeDef,
    SlackConnectorProfileCredentialsTypeDef,
    SlackConnectorProfilePropertiesTypeDef,
    SlackMetadataTypeDef,
    SlackSourcePropertiesTypeDef,
    SnowflakeConnectorProfileCredentialsTypeDef,
    SnowflakeConnectorProfilePropertiesTypeDef,
    SnowflakeDestinationPropertiesTypeDef,
    SnowflakeMetadataTypeDef,
    SourceConnectorPropertiesTypeDef,
    SourceFieldPropertiesTypeDef,
    SourceFlowConfigTypeDef,
    SupportedFieldTypeDetailsTypeDef,
    TaskTypeDef,
    TrendmicroConnectorProfileCredentialsTypeDef,
    TrendmicroSourcePropertiesTypeDef,
    TriggerConfigTypeDef,
    TriggerPropertiesTypeDef,
    UpsolverDestinationPropertiesTypeDef,
    UpsolverS3OutputFormatConfigTypeDef,
    VeevaConnectorProfileCredentialsTypeDef,
    VeevaConnectorProfilePropertiesTypeDef,
    VeevaSourcePropertiesTypeDef,
    ZendeskConnectorProfileCredentialsTypeDef,
    ZendeskConnectorProfilePropertiesTypeDef,
    ZendeskMetadataTypeDef,
    ZendeskSourcePropertiesTypeDef,
    ConnectorProfileConfigTypeDef,
    CreateConnectorProfileResponseTypeDef,
    CreateFlowResponseTypeDef,
    DescribeConnectorEntityResponseTypeDef,
    DescribeConnectorProfilesResponseTypeDef,
    DescribeConnectorsResponseTypeDef,
    DescribeFlowExecutionRecordsResponseTypeDef,
    DescribeFlowResponseTypeDef,
    ListConnectorEntitiesResponseTypeDef,
    ListFlowsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    StartFlowResponseTypeDef,
    StopFlowResponseTypeDef,
    UpdateConnectorProfileResponseTypeDef,
    UpdateFlowResponseTypeDef,
)

def get_structure() -> AggregationConfigTypeDef:
    return {
      ...
    }
```
