import pytest 
import numpy as np
from ..spm_dep    import spm
from ..processing import knee
from ..canon import canon_hrf2dd

def test_wgr_spm_get_canonhrf():
    xBF  = {}
    xBF['dt'] = 2./3
    xBF['T'] = 3
    xBF['len'] = 24
    col1 = np.asarray([0.0, 0.00044807354048549653, 0.007361556038668112, 0.028700948964288868, 0.06209550607132158, 0.09729254798416208, 0.12429404240995112, 0.13792056661956356, 0.13802824093013008, 0.12762119074617928, 0.11077174845169241, 0.09120490808593994, 0.07165360815082951, 0.05376914935191879, 0.03832112614220298, 0.025486073112810325, 0.015110211890879629, 0.006900111913950147, 0.0005371690913944248, -0.004268194929392522, -0.007761293488920797, -0.010148007538333283, -0.01160630142209315, -0.012296736371437677, -0.012368815040058252, -0.011962915647414259, -0.011209052391768252, -0.01022411801820082, -0.009109051781949583, -0.007946887485859182, -0.006802115673078029, -0.005721375663317213, -0.004735225783873632, -0.003860617757643374, -0.0031036899586120515, -0.0024625525460218694, -0.001929827998394537])
    col2 = np.asarray([0.0, 0.00044807354048549653, 0.007342074519043911, 0.026270427564126324, 0.04604777855227284, 0.05298027426688717, 0.04436283618465861, 0.02599351455862868, 0.005549510765577248, -0.011472257205405234, -0.022704308365117443, -0.02817568454942533, -0.029165400859453156, -0.02728041542804467, -0.023923908293136474, -0.020091968757198677, -0.016373874758523064, -0.013045686593496723, -0.010184308584631133, -0.007764223130961229, -0.005723757639472168, -0.004001906734121734, -0.002552994436344191, -0.001347742979076045, -0.0003679965853120599, 0.0003999224194857678, 0.0009704879108325976, 0.0013618737912804435, 0.0015965904821198564, 0.0017004983374237365, 0.0017009756059719753, 0.001624910779748503, 0.0014969777484681833, 0.0013384308028707623, 0.0011664765672502776, 0.000994160094124114, 0.0008306404084625725])
    col3 = np.asarray([0.0, -0.0033744701883765727, -0.02853758656830626, -0.059581285703262654, -0.06276731227887467, -0.03315584298773516, 0.010290875704026259, 0.046611800411483495, 0.06497283018250533, 0.06515064496825096, 0.05287141888607183, 0.035134036642002486, 0.017473063697658053, 0.0031007110271825955, -0.006822656698791951, -0.01249576703581251, -0.014792986331505636, -0.014769241817926427, -0.01337626141896856, -0.011343705230548555, -0.009163530885765957, -0.0071259520361853165, -0.005372467154512138, -0.003946877599547011, -0.0028361208240172686, -0.001999202787460186, -0.0013856669839915764, -0.0009461276756354484, -0.000637391149634764, -0.00042422350787132274, -0.00027925231676790424, -0.0001819802281565093, -0.00011749866181071447, -7.521986433059284e-05, -4.777425670014074e-05, -3.0120010414058304e-05, -1.8859316315220087e-05])
    xBF['TD_DD'] = 0
    out = canon_hrf2dd.wgr_spm_get_canonhrf(xBF)
    assert type(out) == type(np.asarray([]))
    assert out.shape == (37, 1)
    assert np.allclose(out[:,0], col1)
    xBF['TD_DD'] = 1
    out = canon_hrf2dd.wgr_spm_get_canonhrf(xBF)
    assert type(out) == type(np.asarray([]))
    assert out.shape == (37, 2)
    assert np.allclose(out[:,0], col1)
    assert np.allclose(out[:,1], col2)
    xBF['TD_DD'] = 2
    out = canon_hrf2dd.wgr_spm_get_canonhrf(xBF)
    assert type(out) == type(np.asarray([]))
    assert out.shape == (37, 3)
    assert np.allclose(out[:,0], col1)
    assert np.allclose(out[:,1], col2)
    assert np.allclose(out[:,2], col3)