# [TALBOTS PYTHON LIBRARY](https://pypi.org/project/talbots/) #

Talbots is a simple Python library for understanding, analyzing, and evaluating the content of text-generating systems through research papers published in scientific journals. This will be a useful library to help you quickly, efficiently, and cost-effectively develop and publish your own projects with the following features:

1. Allows downloading Bibtex information of research papers through Crossref, and Google Scholar;
2. Allows downloading pdf files of research papers through the Crossref or Sci-hub API;
3. Supports data conversion between .pdf and .txt formats and vice versa;
4. Supports finding the relationships between authors;
5. Detects tortured phrases in each research paper.

### THE MAIN FEATURES ###

Here are some functions that the Talbots library can perform well:

* Download Bibtex information via DOIs or Google Scholar links;
* Download PDF files of research papers via DOI links using Crossref or Sci-hub APIs;
* Filter information of each research paper by year, author, journal, or citation index;
* Convert between file formats (.pdf to .txt or vice versa);
* Extract text from images of each research paper;
* Search for a word or phrase and its location in each research paper;
* Detect tortured phrases in each research paper;
* List the sources of references in each research paper;
* Investigate the relationship between authors.

### INSTALLATION GUIDE ###

The source code is currently stored on [Bitbucket](http://bitbucket.org) at:

The binary installer for the latest released version is available on both **Python Package Index (PyPI) and Anaconda**:

* Using PyPI: `pip3 install talbots` for MacOS and `pip install talbots` for Windows
* Using Anaconda: `conda install talbots`

### VERSIONS ###

The craft version is from `0.0.1 to 2.0.1`, which is for self-test. Therefore, you will not find them on PyPi. In 2023, Mar 15, we published version `1.1.0` as the main version for Talbots.

### OPEN-SOURCE ###

To make the Talbots library more and more popular, we provide a basic open source code in the form of an open-source for the development community.

### AUTHOR CONTRIBUTIONS ###

Author Contributions is a section that describes the specific contributions of each author in a project. It demonstrates transparency and clarity regarding the roles and responsibilities of each author in the research process. This is an important aspect of the research process to ensure that each author is recognized fully and accurately for their contributions. To understand more about the roles of each author in this Talbots project, you can read the additional information below:

* [Tan H. Nguyen](https://huynhnt.com) conceptualized the project, conducted the literature search, designed and planned the research, designing functions, synthesized, tested, edited, combined & packaged, and uploaded the Talbots library source code to PyPI and Bitbucket, and wrote the API documentation.
* [Thien Q. Tran](https://github.com/deadpool252) contributed to designing functions, testing, editing, combining & packaging, and uploading the Talbots library source code to PyPI and Bitbucket.
* [Nguyen Huy Tan](https://github.com/Nghuytan) contributed to design research, designing functions, and testing the Talbots library source code.

### AUTHORS INFORMATION###

1. [Tan H. Nguyen](https://huynhnt.com). Department of Computer Science - [University of the People](https://uopeople.edu)
2. [Thien Q. Tran](https://github.com/deadpool252). マルチメディア研究 - [ECCコンピュータ専門学校](https://comp.ecc.ac.jp/)
3. [Nguyen Huy Tan](https://github.com/Nghuytan). Information Technology Faculty - [Van Lang University]()

### CITATION ###

Tan H. Nguyen, Thien Q. Tran, Nguyen Huy Tan. (2023, Mar 15). Talbots (Version 1.1.0). Bitbucket. https://bitbucket.org/tanhuynhng/talbots/src/master/