import * as autoscaling from '@aws-cdk/aws-autoscaling';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as kms from '@aws-cdk/aws-kms';
import * as lambda from '@aws-cdk/aws-lambda';
import { IResource, Resource, Duration, Size } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { AwsAuth } from './aws-auth';
import { FargateProfile, FargateProfileOptions } from './fargate-profile';
import { HelmChart, HelmChartOptions } from './helm-chart';
import { KubernetesManifest } from './k8s-manifest';
import { KubectlProvider } from './kubectl-provider';
import { Nodegroup, NodegroupOptions } from './managed-nodegroup';
import { ServiceAccount, ServiceAccountOptions } from './service-account';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) An EKS cluster.
 *
 * @experimental
 */
export interface ICluster extends IResource, ec2.IConnectable {
    /**
     * (experimental) The VPC in which this Cluster was created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The physical name of the Cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterName: string;
    /**
     * (experimental) The unique ARN assigned to the service by AWS in the form of arn:aws:eks:.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterArn: string;
    /**
     * (experimental) The API Server endpoint URL.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterEndpoint: string;
    /**
     * (experimental) The certificate-authority-data for your cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterCertificateAuthorityData: string;
    /**
     * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterSecurityGroupId: string;
    /**
     * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     *
     * @experimental
     * @attribute true
     */
    readonly clusterEncryptionConfigKeyArn: string;
    /**
     * (experimental) The Open ID Connect Provider of the cluster used to configure Service Accounts.
     *
     * @experimental
     */
    readonly openIdConnectProvider: iam.IOpenIdConnectProvider;
    /**
     * (experimental) An IAM role that can perform kubectl operations against this cluster.
     *
     * The role should be mapped to the `system:masters` Kubernetes RBAC role.
     *
     * @experimental
     */
    readonly kubectlRole?: iam.IRole;
    /**
     * (experimental) Custom environment variables when running `kubectl` against this cluster.
     *
     * @experimental
     */
    readonly kubectlEnvironment?: {
        [key: string]: string;
    };
    /**
     * (experimental) A security group to use for `kubectl` execution.
     *
     * If this is undefined, the k8s endpoint is expected to be accessible
     * publicly.
     *
     * @experimental
     */
    readonly kubectlSecurityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Subnets to host the `kubectl` compute resources.
     *
     * If this is undefined, the k8s endpoint is expected to be accessible
     * publicly.
     *
     * @experimental
     */
    readonly kubectlPrivateSubnets?: ec2.ISubnet[];
    /**
     * (experimental) An AWS Lambda layer that includes `kubectl`, `helm` and the `aws` CLI.
     *
     * If not defined, a default layer will be used.
     *
     * @experimental
     */
    readonly kubectlLayer?: lambda.ILayerVersion;
    /**
     * (experimental) Amount of memory to allocate to the provider's lambda function.
     *
     * @experimental
     */
    readonly kubectlMemory?: Size;
    /**
     * (experimental) Indicates whether Kubernetes resources can be automatically pruned.
     *
     * When
     * this is enabled (default), prune labels will be allocated and injected to
     * each resource. These labels will then be used when issuing the `kubectl
     * apply` operation with the `--prune` switch.
     *
     * @experimental
     */
    readonly prune: boolean;
    /**
     * (experimental) Creates a new service account with corresponding IAM Role (IRSA).
     *
     * @param id logical id of service account.
     * @param options service account options.
     * @experimental
     */
    addServiceAccount(id: string, options?: ServiceAccountOptions): ServiceAccount;
    /**
     * (experimental) Defines a Kubernetes resource in this cluster.
     *
     * The manifest will be applied/deleted using kubectl as needed.
     *
     * @param id logical id of this manifest.
     * @param manifest a list of Kubernetes resource specifications.
     * @returns a `KubernetesManifest` object.
     * @experimental
     */
    addManifest(id: string, ...manifest: Record<string, any>[]): KubernetesManifest;
    /**
     * (experimental) Defines a Helm chart in this cluster.
     *
     * @param id logical id of this chart.
     * @param options options of this chart.
     * @returns a `HelmChart` construct
     * @experimental
     */
    addHelmChart(id: string, options: HelmChartOptions): HelmChart;
    /**
     * (experimental) Defines a CDK8s chart in this cluster.
     *
     * @param id logical id of this chart.
     * @param chart the cdk8s chart.
     * @returns a `KubernetesManifest` construct representing the chart.
     * @experimental
     */
    addCdk8sChart(id: string, chart: Construct): KubernetesManifest;
}
/**
 * (experimental) Attributes for EKS clusters.
 *
 * @experimental
 */
export interface ClusterAttributes {
    /**
     * (experimental) The VPC in which this Cluster was created.
     *
     * @default - if not specified `cluster.vpc` will throw an error
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) The physical name of the Cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The API Server endpoint URL.
     *
     * @default - if not specified `cluster.clusterEndpoint` will throw an error.
     * @experimental
     */
    readonly clusterEndpoint?: string;
    /**
     * (experimental) The certificate-authority-data for your cluster.
     *
     * @default - if not specified `cluster.clusterCertificateAuthorityData` will
     * throw an error
     * @experimental
     */
    readonly clusterCertificateAuthorityData?: string;
    /**
     * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
     *
     * @default - if not specified `cluster.clusterSecurityGroupId` will throw an
     * error
     * @experimental
     */
    readonly clusterSecurityGroupId?: string;
    /**
     * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     *
     * @default - if not specified `cluster.clusterEncryptionConfigKeyArn` will
     * throw an error
     * @experimental
     */
    readonly clusterEncryptionConfigKeyArn?: string;
    /**
     * (experimental) Additional security groups associated with this cluster.
     *
     * @default - if not specified, no additional security groups will be
     * considered in `cluster.connections`.
     * @experimental
     */
    readonly securityGroupIds?: string[];
    /**
     * (experimental) An IAM role with cluster administrator and "system:masters" permissions.
     *
     * @default - if not specified, it not be possible to issue `kubectl` commands
     * against an imported cluster.
     * @experimental
     */
    readonly kubectlRoleArn?: string;
    /**
     * (experimental) Environment variables to use when running `kubectl` against this cluster.
     *
     * @default - no additional variables
     * @experimental
     */
    readonly kubectlEnvironment?: {
        [name: string]: string;
    };
    /**
     * (experimental) A security group to use for `kubectl` execution.
     *
     * If not specified, the k8s
     * endpoint is expected to be accessible publicly.
     *
     * @default - k8s endpoint is expected to be accessible publicly
     * @experimental
     */
    readonly kubectlSecurityGroupId?: string;
    /**
     * (experimental) Subnets to host the `kubectl` compute resources.
     *
     * If not specified, the k8s
     * endpoint is expected to be accessible publicly.
     *
     * @default - k8s endpoint is expected to be accessible publicly
     * @experimental
     */
    readonly kubectlPrivateSubnetIds?: string[];
    /**
     * (experimental) An Open ID Connect provider for this cluster that can be used to configure service accounts.
     *
     * You can either import an existing provider using `iam.OpenIdConnectProvider.fromProviderArn`,
     * or create a new provider using `new eks.OpenIdConnectProvider`
     *
     * @default - if not specified `cluster.openIdConnectProvider` and `cluster.addServiceAccount` will throw an error.
     * @experimental
     */
    readonly openIdConnectProvider?: iam.IOpenIdConnectProvider;
    /**
     * (experimental) An AWS Lambda Layer which includes `kubectl`, Helm and the AWS CLI.
     *
     * By default, the provider will use the layer included in the
     * "aws-lambda-layer-kubectl" SAR application which is available in all
     * commercial regions.
     *
     * To deploy the layer locally, visit
     * https://github.com/aws-samples/aws-lambda-layer-kubectl/blob/master/cdk/README.md
     * for instructions on how to prepare the .zip file and then define it in your
     * app as follows:
     *
     * ```ts
     * const layer = new lambda.LayerVersion(this, 'kubectl-layer', {
     *    code: lambda.Code.fromAsset(`${__dirname}/layer.zip`)),
     *    compatibleRuntimes: [lambda.Runtime.PROVIDED]
     * });
     *
     * Or you can use the standard layer like this (with options
     * to customize the version and SAR application ID):
     *
     * ```ts
     * const layer = new eks.KubectlLayer(this, 'KubectlLayer');
     * ```
     *
     * @default - the layer provided by the `aws-lambda-layer-kubectl` SAR app.
     * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
     * @experimental
     */
    readonly kubectlLayer?: lambda.ILayerVersion;
    /**
     * (experimental) Amount of memory to allocate to the provider's lambda function.
     *
     * @default Size.gibibytes(1)
     * @experimental
     */
    readonly kubectlMemory?: Size;
    /**
     * (experimental) Indicates whether Kubernetes resources added through `addManifest()` can be automatically pruned.
     *
     * When this is enabled (default), prune labels will be
     * allocated and injected to each resource. These labels will then be used
     * when issuing the `kubectl apply` operation with the `--prune` switch.
     *
     * @default true
     * @experimental
     */
    readonly prune?: boolean;
}
/**
 * (experimental) Options for configuring an EKS cluster.
 *
 * @experimental
 */
export interface CommonClusterOptions {
    /**
     * (experimental) The VPC in which to create the Cluster.
     *
     * @default - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Where to place EKS Control Plane ENIs.
     *
     * If you want to create public load balancers, this must include public subnets.
     *
     * For example, to only select private subnets, supply the following:
     *
     * ```ts
     * vpcSubnets: [
     *    { subnetType: ec2.SubnetType.Private }
     * ]
     * ```
     *
     * @default - All public and private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection[];
    /**
     * (experimental) Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     *
     * @default - A role is automatically created for you
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Name for the cluster.
     *
     * @default - Automatically generated name
     * @experimental
     */
    readonly clusterName?: string;
    /**
     * (experimental) Security Group to use for Control Plane ENIs.
     *
     * @default - A security group is automatically created
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The Kubernetes version to run in the cluster.
     *
     * @experimental
     */
    readonly version: KubernetesVersion;
    /**
     * (experimental) Determines whether a CloudFormation output with the name of the cluster will be synthesized.
     *
     * @default false
     * @experimental
     */
    readonly outputClusterName?: boolean;
    /**
     * (experimental) Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
     *
     * This command will include
     * the cluster name and, if applicable, the ARN of the masters IAM role.
     *
     * @default true
     * @experimental
     */
    readonly outputConfigCommand?: boolean;
}
/**
 * (experimental) Options for EKS clusters.
 *
 * @experimental
 */
export interface ClusterOptions extends CommonClusterOptions {
    /**
     * (experimental) An IAM role that will be added to the `system:masters` Kubernetes RBAC group.
     *
     * @default - a role that assumable by anyone with permissions in the same
     * account will automatically be defined
     * @see https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings
     * @experimental
     */
    readonly mastersRole?: iam.IRole;
    /**
     * (experimental) Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS.
     *
     * @default CoreDnsComputeType.EC2 (for `FargateCluster` the default is FARGATE)
     * @experimental
     */
    readonly coreDnsComputeType?: CoreDnsComputeType;
    /**
     * (experimental) Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified).
     *
     * @default false
     * @experimental
     */
    readonly outputMastersRoleArn?: boolean;
    /**
     * (experimental) Configure access to the Kubernetes API server endpoint..
     *
     * @default EndpointAccess.PUBLIC_AND_PRIVATE
     * @see https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
     * @experimental
     */
    readonly endpointAccess?: EndpointAccess;
    /**
     * (experimental) Environment variables for the kubectl execution.
     *
     * Only relevant for kubectl enabled clusters.
     *
     * @default - No environment variables.
     * @experimental
     */
    readonly kubectlEnvironment?: {
        [key: string]: string;
    };
    /**
     * (experimental) An AWS Lambda Layer which includes `kubectl`, Helm and the AWS CLI.
     *
     * By default, the provider will use the layer included in the
     * "aws-lambda-layer-kubectl" SAR application which is available in all
     * commercial regions.
     *
     * To deploy the layer locally, visit
     * https://github.com/aws-samples/aws-lambda-layer-kubectl/blob/master/cdk/README.md
     * for instructions on how to prepare the .zip file and then define it in your
     * app as follows:
     *
     * ```ts
     * const layer = new lambda.LayerVersion(this, 'kubectl-layer', {
     *    code: lambda.Code.fromAsset(`${__dirname}/layer.zip`)),
     *    compatibleRuntimes: [lambda.Runtime.PROVIDED]
     * })
     * ```
     *
     * @default - the layer provided by the `aws-lambda-layer-kubectl` SAR app.
     * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
     * @experimental
     */
    readonly kubectlLayer?: lambda.ILayerVersion;
    /**
     * (experimental) Amount of memory to allocate to the provider's lambda function.
     *
     * @default Size.gibibytes(1)
     * @experimental
     */
    readonly kubectlMemory?: Size;
    /**
     * (experimental) Indicates whether Kubernetes resources added through `addManifest()` can be automatically pruned.
     *
     * When this is enabled (default), prune labels will be
     * allocated and injected to each resource. These labels will then be used
     * when issuing the `kubectl apply` operation with the `--prune` switch.
     *
     * @default true
     * @experimental
     */
    readonly prune?: boolean;
}
/**
 * Group access configuration together.
 */
interface EndpointAccessConfig {
    /**
     * Indicates if private access is enabled.
     */
    readonly privateAccess: boolean;
    /**
     * Indicates if public access is enabled.
     */
    readonly publicAccess: boolean;
    /**
     * Public access is allowed only from these CIDR blocks.
     * An empty array means access is open to any address.
     *
     * @default - No restrictions.
     */
    readonly publicCidrs?: string[];
}
/**
 * (experimental) Endpoint access characteristics.
 *
 * @experimental
 */
export declare class EndpointAccess {
    /**
     * Configuration properties.
     *
     * @internal
     */
    readonly _config: EndpointAccessConfig;
    /**
     * (experimental) The cluster endpoint is accessible from outside of your VPC.
     *
     * Worker node traffic will leave your VPC to connect to the endpoint.
     *
     * By default, the endpoint is exposed to all adresses. You can optionally limit the CIDR blocks that can access the public endpoint using the `PUBLIC.onlyFrom` method.
     * If you limit access to specific CIDR blocks, you must ensure that the CIDR blocks that you
     * specify include the addresses that worker nodes and Fargate pods (if you use them)
     * access the public endpoint from.
     *
     * @experimental
     */
    static readonly PUBLIC: EndpointAccess;
    /**
     * (experimental) The cluster endpoint is only accessible through your VPC.
     *
     * Worker node traffic to the endpoint will stay within your VPC.
     *
     * @experimental
     */
    static readonly PRIVATE: EndpointAccess;
    /**
     * (experimental) The cluster endpoint is accessible from outside of your VPC.
     *
     * Worker node traffic to the endpoint will stay within your VPC.
     *
     * By default, the endpoint is exposed to all adresses. You can optionally limit the CIDR blocks that can access the public endpoint using the `PUBLIC_AND_PRIVATE.onlyFrom` method.
     * If you limit access to specific CIDR blocks, you must ensure that the CIDR blocks that you
     * specify include the addresses that worker nodes and Fargate pods (if you use them)
     * access the public endpoint from.
     *
     * @experimental
     */
    static readonly PUBLIC_AND_PRIVATE: EndpointAccess;
    private constructor();
    /**
     * (experimental) Restrict public access to specific CIDR blocks.
     *
     * If public access is disabled, this method will result in an error.
     *
     * @param cidr CIDR blocks.
     * @experimental
     */
    onlyFrom(...cidr: string[]): EndpointAccess;
}
/**
 * (experimental) Common configuration props for EKS clusters.
 *
 * @experimental
 */
export interface ClusterProps extends ClusterOptions {
    /**
     * (deprecated) NOT SUPPORTED: We no longer allow disabling kubectl-support. Setting this option to `false` will throw an error.
     *
     * To temporary allow you to retain existing clusters created with
     * `kubectlEnabled: false`, you can use `eks.LegacyCluster` class, which is a
     * drop-in replacement for `eks.Cluster` with `kubectlEnabled: false`.
     *
     * Bear in mind that this is a temporary workaround. We have plans to remove
     * `eks.LegacyCluster`. If you have a use case for using `eks.LegacyCluster`,
     * please add a comment here https://github.com/aws/aws-cdk/issues/9332 and
     * let us know so we can make sure to continue to support your use case with
     * `eks.Cluster`. This issue also includes additional context into why this
     * class is being removed.
     *
     * @default true
     * @see https://github.com/aws/aws-cdk/issues/9332
     * @deprecated `eks.LegacyCluster` is __temporarily__ provided as a drop-in
     * replacement until you are able to migrate to `eks.Cluster`.
     */
    readonly kubectlEnabled?: boolean;
    /**
     * (experimental) Number of instances to allocate as an initial capacity for this cluster.
     *
     * Instance type can be configured through `defaultCapacityInstanceType`,
     * which defaults to `m5.large`.
     *
     * Use `cluster.addAutoScalingGroupCapacity` to add additional customized capacity. Set this
     * to `0` is you wish to avoid the initial capacity allocation.
     *
     * @default 2
     * @experimental
     */
    readonly defaultCapacity?: number;
    /**
     * (experimental) The instance type to use for the default capacity.
     *
     * This will only be taken
     * into account if `defaultCapacity` is > 0.
     *
     * @default m5.large
     * @experimental
     */
    readonly defaultCapacityInstance?: ec2.InstanceType;
    /**
     * (experimental) The default capacity type for the cluster.
     *
     * @default NODEGROUP
     * @experimental
     */
    readonly defaultCapacityType?: DefaultCapacityType;
    /**
     * (experimental) KMS secret for envelope encryption for Kubernetes secrets.
     *
     * @default - By default, Kubernetes stores all secret object data within etcd and
     *   all etcd volumes used by Amazon EKS are encrypted at the disk-level
     *   using AWS-Managed encryption keys.
     * @experimental
     */
    readonly secretsEncryptionKey?: kms.IKey;
}
/**
 * (experimental) Kubernetes cluster version.
 *
 * @experimental
 */
export declare class KubernetesVersion {
    readonly version: string;
    /**
     * (experimental) Kubernetes version 1.14.
     *
     * @experimental
     */
    static readonly V1_14: KubernetesVersion;
    /**
     * (experimental) Kubernetes version 1.15.
     *
     * @experimental
     */
    static readonly V1_15: KubernetesVersion;
    /**
     * (experimental) Kubernetes version 1.16.
     *
     * @experimental
     */
    static readonly V1_16: KubernetesVersion;
    /**
     * (experimental) Kubernetes version 1.17.
     *
     * @experimental
     */
    static readonly V1_17: KubernetesVersion;
    /**
     * (experimental) Kubernetes version 1.18.
     *
     * @experimental
     */
    static readonly V1_18: KubernetesVersion;
    /**
     * (experimental) Custom cluster version.
     *
     * @param version custom version number.
     * @experimental
     */
    static of(version: string): KubernetesVersion;
    /**
     *
     * @param version cluster version number
     */
    private constructor();
}
declare abstract class ClusterBase extends Resource implements ICluster {
    abstract readonly connections: ec2.Connections;
    abstract readonly vpc: ec2.IVpc;
    abstract readonly clusterName: string;
    abstract readonly clusterArn: string;
    abstract readonly clusterEndpoint: string;
    abstract readonly clusterCertificateAuthorityData: string;
    abstract readonly clusterSecurityGroupId: string;
    abstract readonly clusterEncryptionConfigKeyArn: string;
    abstract readonly kubectlRole?: iam.IRole;
    abstract readonly kubectlEnvironment?: {
        [key: string]: string;
    };
    abstract readonly kubectlSecurityGroup?: ec2.ISecurityGroup;
    abstract readonly kubectlPrivateSubnets?: ec2.ISubnet[];
    abstract readonly kubectlMemory?: Size;
    abstract readonly prune: boolean;
    abstract readonly openIdConnectProvider: iam.IOpenIdConnectProvider;
    /**
     * (experimental) Defines a Kubernetes resource in this cluster.
     *
     * The manifest will be applied/deleted using kubectl as needed.
     *
     * @param id logical id of this manifest.
     * @param manifest a list of Kubernetes resource specifications.
     * @returns a `KubernetesResource` object.
     * @experimental
     */
    addManifest(id: string, ...manifest: Record<string, any>[]): KubernetesManifest;
    /**
     * (experimental) Defines a Helm chart in this cluster.
     *
     * @param id logical id of this chart.
     * @param options options of this chart.
     * @returns a `HelmChart` construct
     * @experimental
     */
    addHelmChart(id: string, options: HelmChartOptions): HelmChart;
    /**
     * (experimental) Defines a CDK8s chart in this cluster.
     *
     * @param id logical id of this chart.
     * @param chart the cdk8s chart.
     * @returns a `KubernetesManifest` construct representing the chart.
     * @experimental
     */
    addCdk8sChart(id: string, chart: Construct): KubernetesManifest;
    /**
     * (experimental) Creates a new service account with corresponding IAM Role (IRSA).
     *
     * @experimental
     */
    addServiceAccount(id: string, options?: ServiceAccountOptions): ServiceAccount;
}
/**
 * (experimental) Options for fetching a ServiceLoadBalancerAddress.
 *
 * @experimental
 */
export interface ServiceLoadBalancerAddressOptions {
    /**
     * (experimental) Timeout for waiting on the load balancer address.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly timeout?: Duration;
    /**
     * (experimental) The namespace the service belongs to.
     *
     * @default 'default'
     * @experimental
     */
    readonly namespace?: string;
}
/**
 * (experimental) A Cluster represents a managed Kubernetes Service (EKS).
 *
 * This is a fully managed cluster of API Servers (control-plane)
 * The user is still required to create the worker nodes.
 *
 * @experimental
 */
export declare class Cluster extends ClusterBase {
    /**
     * (experimental) Import an existing cluster.
     *
     * @param scope the construct scope, in most cases 'this'.
     * @param id the id or name to import as.
     * @param attrs the cluster properties to use for importing information.
     * @experimental
     */
    static fromClusterAttributes(scope: Construct, id: string, attrs: ClusterAttributes): ICluster;
    /**
     * (experimental) The VPC in which this Cluster was created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The Name of the created EKS Cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The AWS generated ARN for the Cluster resource.
     *
     * @experimental
     * @example
     *
     * arn:aws:eks:us-west-2:666666666666:cluster/prod
     */
    readonly clusterArn: string;
    /**
     * (experimental) The endpoint URL for the Cluster.
     *
     * This is the URL inside the kubeconfig file to use with kubectl
     *
     * @experimental
     * @example
     *
     * https://5E1D0CEXAMPLEA591B746AFC5AB30262.yl4.us-west-2.eks.amazonaws.com
     */
    readonly clusterEndpoint: string;
    /**
     * (experimental) The certificate-authority-data for your cluster.
     *
     * @experimental
     */
    readonly clusterCertificateAuthorityData: string;
    /**
     * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
     *
     * @experimental
     */
    readonly clusterSecurityGroupId: string;
    /**
     * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     *
     * @experimental
     */
    readonly clusterEncryptionConfigKeyArn: string;
    /**
     * (experimental) Manages connection rules (Security Group Rules) for the cluster.
     *
     * @experimental
     * @type {ec2.Connections}
     * @memberof Cluster
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) IAM role assumed by the EKS Control Plane.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The auto scaling group that hosts the default capacity for this cluster.
     *
     * This will be `undefined` if the `defaultCapacityType` is not `EC2` or
     * `defaultCapacityType` is `EC2` but default capacity is set to 0.
     *
     * @experimental
     */
    readonly defaultCapacity?: autoscaling.AutoScalingGroup;
    /**
     * (experimental) The node group that hosts the default capacity for this cluster.
     *
     * This will be `undefined` if the `defaultCapacityType` is `EC2` or
     * `defaultCapacityType` is `NODEGROUP` but default capacity is set to 0.
     *
     * @experimental
     */
    readonly defaultNodegroup?: Nodegroup;
    /**
     * (experimental) An IAM role that can perform kubectl operations against this cluster.
     *
     * The role should be mapped to the `system:masters` Kubernetes RBAC role.
     *
     * @experimental
     */
    readonly kubectlRole?: iam.IRole;
    /**
     * (experimental) Custom environment variables when running `kubectl` against this cluster.
     *
     * @default - no additional environment variables
     * @experimental
     */
    readonly kubectlEnvironment?: {
        [key: string]: string;
    };
    /**
     * (experimental) A security group to use for `kubectl` execution.
     *
     * @default - If not specified, the k8s endpoint is expected to be accessible
     * publicly.
     * @experimental
     */
    readonly kubectlSecurityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Subnets to host the `kubectl` compute resources.
     *
     * @default - If not specified, the k8s endpoint is expected to be accessible
     * publicly.
     * @experimental
     */
    readonly kubectlPrivateSubnets?: ec2.ISubnet[];
    /**
     * (experimental) An IAM role with administrative permissions to create or update the cluster.
     *
     * This role also has `systems:master` permissions.
     *
     * @experimental
     */
    readonly adminRole: iam.Role;
    /**
     * If the cluster has one (or more) FargateProfiles associated, this array
     * will hold a reference to each.
     */
    private readonly _fargateProfiles;
    /**
     * an Open ID Connect Provider instance
     */
    private _openIdConnectProvider?;
    /**
     * (experimental) The AWS Lambda layer that contains `kubectl`, `helm` and the AWS CLI.
     *
     * If
     * undefined, a SAR app that contains this layer will be used.
     *
     * @experimental
     */
    readonly kubectlLayer?: lambda.ILayerVersion;
    /**
     * (experimental) The amount of memory allocated to the kubectl provider's lambda function.
     *
     * @experimental
     */
    readonly kubectlMemory?: Size;
    /**
     * (experimental) Determines if Kubernetes resources can be pruned automatically.
     *
     * @experimental
     */
    readonly prune: boolean;
    /**
     * If this cluster is kubectl-enabled, returns the `ClusterResource` object
     * that manages it. If this cluster is not kubectl-enabled (i.e. uses the
     * stock `CfnCluster`), this is `undefined`.
     */
    private readonly _clusterResource;
    /**
     * Manages the aws-auth config map.
     */
    private _awsAuth?;
    private _spotInterruptHandler?;
    private _neuronDevicePlugin?;
    private readonly endpointAccess;
    private readonly vpcSubnets;
    private readonly version;
    /**
     * A dummy CloudFormation resource that is used as a wait barrier which
     * represents that the cluster is ready to receive "kubectl" commands.
     *
     * Specifically, all fargate profiles are automatically added as a dependency
     * of this barrier, which means that it will only be "signaled" when all
     * fargate profiles have been successfully created.
     *
     * When kubectl resources call `_attachKubectlResourceScope()`, this resource
     * is added as their dependency which implies that they can only be deployed
     * after the cluster is ready.
     */
    private readonly _kubectlReadyBarrier;
    private readonly _kubectlResourceProvider;
    /**
     * (experimental) Initiates an EKS Cluster with the supplied arguments.
     *
     * @param scope a Construct, most likely a cdk.Stack created.
     * @param id the id of the Construct to create.
     * @param props properties in the IClusterProps interface.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClusterProps);
    /**
     * (experimental) Fetch the load balancer address of a service of type 'LoadBalancer'.
     *
     * @param serviceName The name of the service.
     * @param options Additional operation options.
     * @experimental
     */
    getServiceLoadBalancerAddress(serviceName: string, options?: ServiceLoadBalancerAddressOptions): string;
    /**
     * (experimental) Add nodes to this EKS cluster.
     *
     * The nodes will automatically be configured with the right VPC and AMI
     * for the instance type and Kubernetes version.
     *
     * Note that if you specify `updateType: RollingUpdate` or `updateType: ReplacingUpdate`, your nodes might be replaced at deploy
     * time without notice in case the recommended AMI for your machine image type has been updated by AWS.
     * The default behavior for `updateType` is `None`, which means only new instances will be launched using the new AMI.
     *
     * Spot instances will be labeled `lifecycle=Ec2Spot` and tainted with `PreferNoSchedule`.
     * In addition, the [spot interrupt handler](https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler)
     * daemon will be installed on all spot instances to handle
     * [EC2 Spot Instance Termination Notices](https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/).
     *
     * @experimental
     */
    addAutoScalingGroupCapacity(id: string, options: AutoScalingGroupCapacityOptions): autoscaling.AutoScalingGroup;
    /**
     * (experimental) Add managed nodegroup to this Amazon EKS cluster.
     *
     * This method will create a new managed nodegroup and add into the capacity.
     *
     * @param id The ID of the nodegroup.
     * @param options options for creating a new nodegroup.
     * @see https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html
     * @experimental
     */
    addNodegroupCapacity(id: string, options?: NodegroupOptions): Nodegroup;
    /**
     * (experimental) Connect capacity in the form of an existing AutoScalingGroup to the EKS cluster.
     *
     * The AutoScalingGroup must be running an EKS-optimized AMI containing the
     * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
     * add the right policies to the instance role, apply the right tags, and add
     * the required user data to the instance's launch configuration.
     *
     * Spot instances will be labeled `lifecycle=Ec2Spot` and tainted with `PreferNoSchedule`.
     * If kubectl is enabled, the
     * [spot interrupt handler](https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler)
     * daemon will be installed on all spot instances to handle
     * [EC2 Spot Instance Termination Notices](https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/).
     *
     * Prefer to use `addAutoScalingGroupCapacity` if possible.
     *
     * @param autoScalingGroup [disable-awslint:ref-via-interface].
     * @param options options for adding auto scaling groups, like customizing the bootstrap script.
     * @see https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html
     * @experimental
     */
    connectAutoScalingGroupCapacity(autoScalingGroup: autoscaling.AutoScalingGroup, options: AutoScalingGroupOptions): void;
    /**
     * (experimental) Lazily creates the AwsAuth resource, which manages AWS authentication mapping.
     *
     * @experimental
     */
    get awsAuth(): AwsAuth;
    /**
     * (experimental) If this cluster is kubectl-enabled, returns the OpenID Connect issuer url.
     *
     * This is because the values is only be retrieved by the API and not exposed
     * by CloudFormation. If this cluster is not kubectl-enabled (i.e. uses the
     * stock `CfnCluster`), this is `undefined`.
     *
     * @experimental
     * @attribute true
     */
    get clusterOpenIdConnectIssuerUrl(): string;
    /**
     * (experimental) If this cluster is kubectl-enabled, returns the OpenID Connect issuer.
     *
     * This is because the values is only be retrieved by the API and not exposed
     * by CloudFormation. If this cluster is not kubectl-enabled (i.e. uses the
     * stock `CfnCluster`), this is `undefined`.
     *
     * @experimental
     * @attribute true
     */
    get clusterOpenIdConnectIssuer(): string;
    /**
     * (experimental) An `OpenIdConnectProvider` resource associated with this cluster, and which can be used to link this cluster to AWS IAM.
     *
     * A provider will only be defined if this property is accessed (lazy initialization).
     *
     * @experimental
     */
    get openIdConnectProvider(): iam.IOpenIdConnectProvider;
    /**
     * (experimental) Adds a Fargate profile to this cluster.
     *
     * @param id the id of this profile.
     * @param options profile options.
     * @see https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html
     * @experimental
     */
    addFargateProfile(id: string, options: FargateProfileOptions): FargateProfile;
    /**
     * Internal API used by `FargateProfile` to keep inventory of Fargate profiles associated with
     * this cluster, for the sake of ensuring the profiles are created sequentially.
     *
     * @returns the list of FargateProfiles attached to this cluster, including the one just attached.
     * @internal
     */
    _attachFargateProfile(fargateProfile: FargateProfile): FargateProfile[];
    /**
     * Adds a resource scope that requires `kubectl` to this cluster and returns
     * the `KubectlProvider` which is the custom resource provider that should be
     * used as the resource provider.
     *
     * Called from `HelmResource` and `KubernetesResource`
     *
     * @param resourceScope the construct scope in which kubectl resources are defined.
     *
     * @internal
     */
    _attachKubectlResourceScope(resourceScope: Construct): KubectlProvider;
    private defineKubectlProvider;
    private selectPrivateSubnets;
    /**
     * Installs the AWS spot instance interrupt handler on the cluster if it's not
     * already added.
     */
    private addSpotInterruptHandler;
    /**
     * Installs the Neuron device plugin on the cluster if it's not
     * already added.
     */
    private addNeuronDevicePlugin;
    /**
     * Opportunistically tag subnets with the required tags.
     *
     * If no subnets could be found (because this is an imported VPC), add a warning.
     *
     * @see https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html
     */
    private tagSubnets;
    /**
     * Patches the CoreDNS deployment configuration and sets the "eks.amazonaws.com/compute-type"
     * annotation to either "ec2" or "fargate". Note that if "ec2" is selected, the resource is
     * omitted/removed, since the cluster is created with the "ec2" compute type by default.
     */
    private defineCoreDnsComputeType;
}
/**
 * (experimental) Options for adding worker nodes.
 *
 * @experimental
 */
export interface AutoScalingGroupCapacityOptions extends autoscaling.CommonAutoScalingGroupProps {
    /**
     * (experimental) Instance type of the instances to start.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
     *
     * This cannot be explicitly set to `true` if the cluster has kubectl disabled.
     *
     * @default - true if the cluster has kubectl enabled (which is the default).
     * @experimental
     */
    readonly mapRole?: boolean;
    /**
     * (experimental) Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
     *
     * If you wish to provide a custom user data script, set this to `false` and
     * manually invoke `autoscalingGroup.addUserData()`.
     *
     * @default true
     * @experimental
     */
    readonly bootstrapEnabled?: boolean;
    /**
     * (experimental) EKS node bootstrapping options.
     *
     * @default - none
     * @experimental
     */
    readonly bootstrapOptions?: BootstrapOptions;
    /**
     * (experimental) Machine image type.
     *
     * @default MachineImageType.AMAZON_LINUX_2
     * @experimental
     */
    readonly machineImageType?: MachineImageType;
}
/**
 * (experimental) EKS node bootstrapping options.
 *
 * @experimental
 */
export interface BootstrapOptions {
    /**
     * (experimental) Sets `--max-pods` for the kubelet based on the capacity of the EC2 instance.
     *
     * @default true
     * @experimental
     */
    readonly useMaxPods?: boolean;
    /**
     * (experimental) Restores the docker default bridge network.
     *
     * @default false
     * @experimental
     */
    readonly enableDockerBridge?: boolean;
    /**
     * (experimental) Number of retry attempts for AWS API call (DescribeCluster).
     *
     * @default 3
     * @experimental
     */
    readonly awsApiRetryAttempts?: number;
    /**
     * (experimental) The contents of the `/etc/docker/daemon.json` file. Useful if you want a custom config differing from the default one in the EKS AMI.
     *
     * @default - none
     * @experimental
     */
    readonly dockerConfigJson?: string;
    /**
     * (experimental) Extra arguments to add to the kubelet.
     *
     * Useful for adding labels or taints.
     *
     * @default - none
     * @experimental
     * @example
     *
     * --node-labels foo=bar,goo=far
     */
    readonly kubeletExtraArgs?: string;
    /**
     * (experimental) Additional command line arguments to pass to the `/etc/eks/bootstrap.sh` command.
     *
     * @default - none
     * @see https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh
     * @experimental
     */
    readonly additionalArgs?: string;
}
/**
 * (experimental) Options for adding an AutoScalingGroup as capacity.
 *
 * @experimental
 */
export interface AutoScalingGroupOptions {
    /**
     * (experimental) Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
     *
     * This cannot be explicitly set to `true` if the cluster has kubectl disabled.
     *
     * @default - true if the cluster has kubectl enabled (which is the default).
     * @experimental
     */
    readonly mapRole?: boolean;
    /**
     * (experimental) Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
     *
     * If you wish to provide a custom user data script, set this to `false` and
     * manually invoke `autoscalingGroup.addUserData()`.
     *
     * @default true
     * @experimental
     */
    readonly bootstrapEnabled?: boolean;
    /**
     * (experimental) Allows options for node bootstrapping through EC2 user data.
     *
     * @default - default options
     * @experimental
     */
    readonly bootstrapOptions?: BootstrapOptions;
    /**
     * (experimental) Allow options to specify different machine image type.
     *
     * @default MachineImageType.AMAZON_LINUX_2
     * @experimental
     */
    readonly machineImageType?: MachineImageType;
}
/**
 * (experimental) Properties for EksOptimizedImage.
 *
 * @experimental
 */
export interface EksOptimizedImageProps {
    /**
     * (experimental) What instance type to retrieve the image for (standard or GPU-optimized).
     *
     * @default NodeType.STANDARD
     * @experimental
     */
    readonly nodeType?: NodeType;
    /**
     * (experimental) What cpu architecture to retrieve the image for (arm64 or x86_64).
     *
     * @default CpuArch.X86_64
     * @experimental
     */
    readonly cpuArch?: CpuArch;
    /**
     * (experimental) The Kubernetes version to use.
     *
     * @default - The latest version
     * @experimental
     */
    readonly kubernetesVersion?: string;
}
/**
 * (experimental) Construct an Amazon Linux 2 image from the latest EKS Optimized AMI published in SSM.
 *
 * @experimental
 */
export declare class EksOptimizedImage implements ec2.IMachineImage {
    private readonly nodeType?;
    private readonly cpuArch?;
    private readonly kubernetesVersion?;
    private readonly amiParameterName;
    /**
     * (experimental) Constructs a new instance of the EcsOptimizedAmi class.
     *
     * @experimental
     */
    constructor(props?: EksOptimizedImageProps);
    /**
     * (experimental) Return the correct image.
     *
     * @experimental
     */
    getImage(scope: CoreConstruct): ec2.MachineImageConfig;
}
/**
 * (experimental) Whether the worker nodes should support GPU or just standard instances.
 *
 * @experimental
 */
export declare enum NodeType {
    /**
     * (experimental) Standard instances.
     *
     * @experimental
     */
    STANDARD = "Standard",
    /**
     * (experimental) GPU instances.
     *
     * @experimental
     */
    GPU = "GPU",
    /**
     * (experimental) Inferentia instances.
     *
     * @experimental
     */
    INFERENTIA = "INFERENTIA"
}
/**
 * (experimental) CPU architecture.
 *
 * @experimental
 */
export declare enum CpuArch {
    /**
     * (experimental) arm64 CPU type.
     *
     * @experimental
     */
    ARM_64 = "arm64",
    /**
     * (experimental) x86_64 CPU type.
     *
     * @experimental
     */
    X86_64 = "x86_64"
}
/**
 * (experimental) The type of compute resources to use for CoreDNS.
 *
 * @experimental
 */
export declare enum CoreDnsComputeType {
    /**
     * (experimental) Deploy CoreDNS on EC2 instances.
     *
     * @experimental
     */
    EC2 = "ec2",
    /**
     * (experimental) Deploy CoreDNS on Fargate-managed instances.
     *
     * @experimental
     */
    FARGATE = "fargate"
}
/**
 * (experimental) The default capacity type for the cluster.
 *
 * @experimental
 */
export declare enum DefaultCapacityType {
    /**
     * (experimental) managed node group.
     *
     * @experimental
     */
    NODEGROUP = 0,
    /**
     * (experimental) EC2 autoscaling group.
     *
     * @experimental
     */
    EC2 = 1
}
/**
 * (experimental) The machine image type.
 *
 * @experimental
 */
export declare enum MachineImageType {
    /**
     * (experimental) Amazon EKS-optimized Linux AMI.
     *
     * @experimental
     */
    AMAZON_LINUX_2 = 0,
    /**
     * (experimental) Bottlerocket AMI.
     *
     * @experimental
     */
    BOTTLEROCKET = 1
}
export {};
