# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['seaborn_image']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib-scalebar>=0.7.0,<0.8.0',
 'matplotlib>=3.2.2',
 'palettable>=3.3.0',
 'pooch>=1.2.0',
 'scikit-image>=0.17.2',
 'scipy>=1.5.1']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.7.0,<2.0.0']}

setup_kwargs = {
    'name': 'seaborn-image',
    'version': '0.5.0',
    'description': 'Attractive, descriptive and effective image visualization with seaborn-like API built on top of matplotlib',
    'long_description': '# seaborn-image: image data visualization\n\n[![Tests](https://github.com/SarthakJariwala/seaborn-image/workflows/Tests/badge.svg)](https://github.com/SarthakJariwala/seaborn-image/actions?workflow=Tests)\n[![Codecov](https://codecov.io/gh/SarthakJariwala/seaborn-image/branch/master/graph/badge.svg)](https://codecov.io/gh/SarthakJariwala/seaborn-image)\n[![PyPI](https://img.shields.io/pypi/v/seaborn-image.svg)](https://pypi.org/project/seaborn-image/)\n[![Documentation Status](https://readthedocs.org/projects/seaborn-image/badge/?version=latest)](https://seaborn-image.readthedocs.io/en/latest/?badge=latest)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n\n<div class="row">\n\n  <a href="https://seaborn-image.readthedocs.io/en/latest/auto_examples/plot_image_hist.html">\n  <img src="./images/sphx_glr_plot_image_hist_001.png" height="120" width="170">\n  </a>\n\n  <a href="https://seaborn-image.readthedocs.io/en/latest/auto_examples/plot_filter.html">\n  <img src="./images/sphx_glr_plot_filter_001.png" height="120" width="130">\n  </a>\n\n  <a href="https://seaborn-image.readthedocs.io/en/latest/auto_examples/plot_fft.html">\n  <img src="./images/sphx_glr_plot_fft_001.png" height="120" width="120">\n  </a>\n\n  <a href="https://seaborn-image.readthedocs.io/en/latest/auto_examples/plot_filtergrid.html">\n  <img src="./images/sphx_glr_plot_filtergrid_001.png" height="120" width="120">\n  </a>\n\n  <a href="https://seaborn-image.readthedocs.io/en/latest/auto_examples/plot_image_robust.html">\n  <img src="./images/sphx_glr_plot_image_robust_001.png" height="120" width="260">\n  </a>\n\n</div>\n\n\n## Description\n\nSeaborn-image is a Python **image** visualization library based on matplotlib\nand provides a high-level API to **draw attractive and informative images quickly and effectively**.\n\nIt is heavily inspired by [seaborn](https://seaborn.pydata.org/), a high-level visualization library\nfor drawing attractive statistical graphics in Python.\n\n## Documentation\n\nDetailed documentation can be found [here](https://seaborn-image.readthedocs.io/).\n\n- [Tutorial](https://seaborn-image.readthedocs.io/en/latest/tutorial.html)\n- [Examples](https://seaborn-image.readthedocs.io/auto_examples/index.html)\n- [API Reference](https://seaborn-image.readthedocs.io/en/latest/reference.html)\n\n## Installation\n\nFor latest release:\n\nUsing `pip`\n\n```bash\npip install -U seaborn-image\n```\n\nUsing `conda`\n\n```bash\nconda install seaborn-image -c conda-forge\n```\n\nFor latest commit\n```bash\npip install git+https://github.com/SarthakJariwala/seaborn-image\n```\n\n## Contributing\n\nPlease see the [contributing guidelines](https://github.com/SarthakJariwala/seaborn-image/blob/master/CONTRIBUTING.rst)\n',
    'author': 'Sarthak Jariwala',
    'author_email': 'jariwala@uw.edu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/SarthakJariwala/seaborn-image',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
