/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.dom.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class AttributesMap
extends HashMap<String, String> {
    private static final long serialVersionUID = -6165499554111988049L;
    protected static final String STYLE_ATTR = "style";
    protected static final String CLASS_ATTR = "class";
    protected static final String SPACE = " ";
    protected static final String NL_TAB_REGEXP = "\\n|\\t";

    public AttributesMap() {
    }

    public AttributesMap(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.put(attributes.getQName(i).toLowerCase(), attributes.getValue(i));
        }
    }

    public boolean hasSameAttributes(Attributes attributes) {
        if (attributes.getLength() != this.size()) {
            return false;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i).toLowerCase();
            String string2 = attributes.getValue(i);
            String string3 = (String)this.get(string);
            if (string3 == null) {
                return false;
            }
            if (string3.equals(string2) || string.equals(STYLE_ATTR) && AttributesMap.equivalentStyles(string2, string3) || string.equals(CLASS_ATTR) && AttributesMap.sameClassSet(string2, string3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof AttributesMap) {
            AttributesMap attributesMap = (AttributesMap)object;
            if (this.size() == attributesMap.size()) {
                bl = true;
                for (Map.Entry entry : this.entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    String string3 = (String)attributesMap.get(string);
                    if (string3 != null && string3.equals(string2) || (string.equals(STYLE_ATTR) ? AttributesMap.equivalentStyles(string2, string3) : string.equals(CLASS_ATTR) && AttributesMap.sameClassSet(string2, string3))) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public int hashCode() {
        int n = 19;
        int n2 = 0;
        for (String string : this.keySet()) {
            n2 += string.hashCode() * n;
            if (string.equals(STYLE_ATTR)) {
                n2 += AttributesMap.normalizeStyleString((String)this.get(string)).hashCode();
                continue;
            }
            if (string.equals(CLASS_ATTR)) {
                n2 += AttributesMap.normalizeClassString((String)this.get(string)).hashCode();
                continue;
            }
            n2 += ((String)this.get(string)).hashCode();
        }
        return n2;
    }

    public static boolean equivalentStyles(String string, String string2) {
        Object[] objectArray;
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        string = string.replaceAll(NL_TAB_REGEXP, SPACE);
        string2 = string2.replaceAll(NL_TAB_REGEXP, SPACE);
        string = string.replaceAll(" ++", SPACE);
        string2 = string2.replaceAll(" ++", SPACE);
        if ((string = string.trim()).equals(string2 = string2.trim())) {
            return true;
        }
        Object[] objectArray2 = string.split(" *+(?>; *+)++");
        if (objectArray2.length != (objectArray = string2.split(" *+(?>; *+)++")).length) {
            return false;
        }
        Arrays.sort(objectArray2);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = ((String)objectArray2[i]).replaceFirst(" *+: *+", ":");
            objectArray[i] = ((String)objectArray[i]).replaceFirst(" *+: *+", ":");
            if (((String)objectArray2[i]).equals(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean sameClassSet(String string, String string2) {
        Object[] objectArray;
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        string = string.replaceAll(NL_TAB_REGEXP, SPACE);
        string2 = string2.replaceAll(NL_TAB_REGEXP, SPACE);
        if ((string = string.trim()).equals(string2 = string2.trim())) {
            return true;
        }
        Object[] objectArray2 = string.split(" ++");
        if (objectArray2.length != (objectArray = string2.split(" ++")).length) {
            return false;
        }
        Arrays.sort(objectArray2);
        Arrays.sort(objectArray);
        return Arrays.equals(objectArray2, objectArray);
    }

    public static String normalizeStyleString(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        string = string.replaceAll(NL_TAB_REGEXP, SPACE);
        string = string.replaceAll(" ++", SPACE);
        if ((string = string.trim()).length() == 0) {
            return string;
        }
        Object[] objectArray = string.split(" *+(?>; *+)++");
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(((String)objectArray[i]).replaceFirst(" *+: *+", ":")).append("; ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }

    public static String normalizeClassString(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        string = string.replaceAll(NL_TAB_REGEXP, SPACE);
        string = string.trim();
        Object[] objectArray = string.split(" ++");
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append((String)objectArray[i]).append(SPACE);
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "margin-left:50px;font-size:16pt;";
        String string2 = "    font-size  :  16pt    ;  ;   ;  ; margin-left  : 50px   ";
        System.out.println("equal? -" + AttributesMap.equivalentStyles(string, string2));
    }
}

