# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['paroxython']

package_data = \
{'': ['*'], 'paroxython': ['resources/*']}

install_requires = \
['docopt>=0.6.2,<0.7.0',
 'regex>=2020.7.14,<2021.0.0',
 'typed-ast>=1.4.1,<2.0.0',
 'typing-extensions>=3.7.4.3,<4.0.0.0']

entry_points = \
{'console_scripts': ['paroxython = paroxython.cli:main']}

setup_kwargs = {
    'name': 'paroxython',
    'version': '0.4.8',
    'description': 'Search Python code for algorithmic features',
    'long_description': '[![Build Status](https://travis-ci.com/laowantong/paroxython.svg?branch=master)](https://travis-ci.com/laowantong/paroxython)\n[![codecov](https://img.shields.io/codecov/c/github/laowantong/paroxython/master)](https://codecov.io/gh/laowantong/paroxython)\n[![Checked with mypy](https://img.shields.io/badge/typing-mypy-brightgreen)](http://mypy-lang.org/)\n[![Codacy Badge](https://api.codacy.com/project/badge/Grade/73432ed4c5294326ba6279bbbb0fe2e6)](https://www.codacy.com/manual/laowantong/paroxython)\n[![Updates](https://pyup.io/repos/github/laowantong/paroxython/shield.svg)](https://pyup.io/repos/github/laowantong/paroxython/)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/paroxython)\n[![GitHub Release](https://img.shields.io/github/release/laowantong/paroxython.svg?style=flat)]()\n![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/laowantong/paroxython)\n[![paroxython SLOC](https://img.shields.io/badge/main%20program-~1700%20SLOC-blue)](https://github.com/laowantong/paroxython/blob/master/paroxython)\n[![tests SLOC](https://img.shields.io/badge/tests-~2700%20SLOC-blue)](https://github.com/laowantong/paroxython/blob/master/tests)\n[![helpers SLOC](https://img.shields.io/badge/helpers-~850%20SLOC-blue)](https://github.com/laowantong/paroxython/blob/master/helpers)\n[![spec lines](https://img.shields.io/badge/spec-~8400%20lines-blue)](https://github.com/laowantong/paroxython/blob/master/paroxython/resources/spec.md)\n[![taxonomy mappings](https://img.shields.io/badge/taxonomy-274%20mappings-blue)](https://github.com/laowantong/paroxython/blob/master/paroxython/resources/taxonomy.tsv)\n![GitHub commit activity](https://img.shields.io/github/commit-activity/y/laowantong/paroxython.svg?style=flat)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n[![Band-aid](https://img.shields.io/badge/not%C2%A0%C2%A0%F0%9F%85%B3%F0%9F%85%B4%F0%9F%85%B0%F0%9F%85%B3-yet-%23F3D9C5?labelColor=%23F3D9C5)](https://youtu.be/QcbR1J_4ICg?t=54)\n\n<p align="center">\n  <a href="https://laowantong.github.io/paroxython/index.html">\n  <img src="docs/resources/logo.png">\n  </a>\n</p>\n\n## Introduction\n\nParoxython is a set of command line tools which **tag** and **filter** by algorithmic features a collection of Python programming exercises.\n\n### Audience\n\nYou are a teacher, in charge of an introductory programming course in an educational institution. Over the years, you have accumulated many—far too many—programs and code snippets that may be of interest to your students.\n\nOr, as a seasoned developer, you would like to share your knowledge by helping a loved one learn how to code. A cursory search for pedagogical material yields an overwhelming amount of websites and repositories stuffed with Python programs of various levels (e.g.,\n[1](https://github.com/TheAlgorithms/Python),\n[2](http://rosettacode.org/wiki/Category:Python),\n[3](https://www.programming-idioms.org/about#about-block-language-coverage),\n[4](https://github.com/codebasics/py),\n[5](https://github.com/keon/algorithms),\n[6](https://github.com/OmkarPathak/Python-Programs),\nand a lot more from [Awesome Python in Education](https://github.com/quobit/awesome-python-in-education)).\n\nIn any case, the Python source codes you have gathered are typically\n**numerous** (hundreds or even thousands),\n**reasonably sized** (anything below 1000 lines of code),\nand **educational** in nature (e.g., snippets, examples, quizzes, exercise solutions, classic algorithms).\nThe programming concepts you plan to teach remain relatively **low level** (e.g. assignments, nested loops, accumulation patterns, tail recursive functions, etc.).\n\nIf all that sounds familiar, keep reading me.\n\n### Main goals\n\nParoxython aims to help you select, from your collection, the one program that best suits your needs. For instance, it will gladly answer the following questions:\n\n> - How can this concept be illustrated?\n> - What problems use the same algorithmic and data structures as this one?\n> - What homework assignment should I give my students so they can practice the content of the last lesson?\n\nMoreover, since Paroxython knows what your class knows, it can recommend the right program at the right time:\n\n> - What would make a good review exercise?\n> - Which exercises can I give on this exam?\n> - What is the current learning cost of this example?\n\nIn the long run, Paroxython may guide you and somehow make you rethink your course outline:\n\n> - What are the prerequisites for the concept of assignment?\n> - Do I have enough material to introduce subroutines before I even talk about conditionals and loops?\n> - Among the loops, which must come first: the most powerful (`while`), or the most useful (`for`)?\n> - How to logically structure this bunch of usual iterative patterns?\n> - What are the _basics_, exactly?\n\nAll issues on which the author changed his mind since he started to work on this project!\n\nIn an ideal world, Paroxython could even put an end to the deadliest religious wars, with rational, data-driven arguments:\n\n> - Father, is it a sin to exit early?\n> - Should a real byte use a mask?\n\n### How it works\n\n<p align="center">\n  <a href="https://laowantong.github.io/paroxython/developer_manual/index.html">\n  <img src="docs/resources/waterfall.png">\n  </a>\n</p>\n\nParoxython starts from a given folder of **programs**. Its contents is parsed, and all features that meet the provided **specifications** are labelled and associated with their spanning lines (e.g., `"assignment_lhs_identifier:a": 4, 6, 18` or `"loop_with_late_exit:while": 3-7, 20-29`).\n\nThese **labels** constitute only a scattered knowledge. The next step is to map them onto a **taxonomy** designed with basic hierarchical constraints in mind (e.g., the fact that the introduction of the concept of early exit must come after that of loop, which itself requires that of control flow, is expressed by the _taxon_ `"flow/loop/exit/early"`).\n\n<p align="center">\n  <a href="https://laowantong.github.io/paroxython/user_manual/index.html#taxonomy">\n  <img src="docs/resources/tree.png" alt="A taxonomy.">\n  </a>\n  <br>\n  <em>Extract of the taxonomy generated from <a href="https://github.com/TheAlgorithms/Python">The Algorithms - Python</a>.<br>Click to jump to its full dynamic version in the user manual.</em>\n</p>\n\nEverything is then persisted in a tag **database**, which can later be filtered through a **pipeline** of commands, for instance:\n\n- _include_ only the programs which feature a recursive function;\n- _exclude_ this or that program you want to set aside for the exam;\n- “_impart_” all programs studied so far, _i.e_, consider that all the notions they implement are acquired.\n\nThe result is a list of program **recommendations** ordered by increasing learning cost.\n\n### Example\n\nSuppose that the `programs` directory contains [these simple programs](https://wiki.python.org/moin/SimplePrograms).\n\nFirst, build [this tag database](https://github.com/laowantong/paroxython/blob/master/examples/simple/programs_db.json):\n\n```shell\n> paroxython collect programs\nLabelling 21 programs.\nMapping taxonomy on 21 programs.\nWriting programs_db.json.\n```\n\nThen, filter it through [this pipeline](https://github.com/laowantong/paroxython/blob/master/examples/simple/programs_pipe.py):\n\n```shell\n> paroxython recommend -p programs_pipe.py programs_db.json\nProcessing 5 commands on 21 programs.\n  19 programs remaining after operation 1 (impart).\n  18 programs remaining after operation 2 (exclude).\n  12 programs remaining after operation 3 (exclude).\n  10 programs remaining after operation 4 (include).\n  10 programs remaining after operation 5 (hide).\nDumped: programs_recommendations.md.\n```\n\nEt voilà, [your recommendation report](https://github.com/laowantong/paroxython/blob/master/examples/simple/programs_recommendations.md)!\n\n\n## Installation and test-drive\n\n### Command line\n\nMuch to no one\'s surprise:\n\n```\npip install paroxython\n```\n\nThe following command should print a help message and exit:\n\n```\nparoxython --help\n```\n\n### IPython magic command\n\nIf you use Jupyter notebook/lab, you\'ve also just installed a so-called magic command. Load it like this:\n\n```python\n%load_ext paroxython\n```\n\nThis should print `"paroxython 0.4.8 loaded."`. Run it on a cell of Python code:\n\n```python\n%%paroxython                          # Lines\ndef fibonacci(n):                     # 2\n    result = []                       # 3\n    (a, b) = (0, 1)                   # 4\n    while a < n:                      # 5\n        result.append(a)              # 6\n        (a, b) = (b, a + b)           # 7\n    return result                     # 8\n```\n\n| Taxon | Lines |\n|:--|:--|\n| `call/subroutine/method/sequence/list/append` | 6 |\n| `condition/inequality` | 5 |\n| `def/subroutine/function/impure` | 2-8 |\n| `flow/loop/exit/late` | 5-7 |\n| `flow/loop/while` | 5-7 |\n| `meta/count/program/sloc/8` | 2-8 |\n| `meta/count/subroutine/sloc/7` | 2-8 |\n| `meta/program` | 2-8 |\n| `operator/arithmetic/addition` | 7 |\n| `style/procedural` | 2-8 |\n| `type/number/integer/literal` | 4 |\n| `type/number/integer/literal/zero` | 4 |\n| `type/sequence/list` | 6 |\n| `type/sequence/list/literal/empty` | 3 |\n| `type/sequence/tuple/literal` | 4, 4, 7, 7 |\n| `var/assignment/explicit/parallel` | 4 |\n| `var/assignment/explicit/parallel/slide` | 7 |\n| `var/assignment/explicit/single` | 3 |\n| `var/assignment/implicit/parameter` | 2 |\n| `var/scope/local` | 2-8, 2-8, 2-8, 2-8 |\n\nAs you can see, in this program, Paroxython identifies among others:\n\n- the use of the [procedural paradigm](https://en.wikipedia.org/wiki/Procedural_programming) (`style/procedural`);\n- an im[pure function](https://en.wikipedia.org/wiki/Pure_function) (`def/subroutine/function/impure`);\n- a `while` loop (`flow/loop/while`) with a late exit (`flow/loop/exit/late`);\n- a little bit of voodoo on lists (`type/sequence/list/literal/empty` and `call/subroutine/method/sequence/list/append`);\n- a simple [tuple assignment](https://openbookproject.net/thinkcs/python/english3e/tuples.html#tuple-assignment) (`var/assignment/explicit/parallel`). Note that we distinguish between explicit (with `=`) and implicit (parameters and iteration variables) assignments;\n- a “sliding” tuple assignment (`var/assignment/explicit/parallel/slide`). If the denomination is unique to us, the pattern itself occurs in a number of programs: implementations of [C-finite sequences](https://en.wikipedia.org/wiki/Constant-recursive_sequence) with C greater than 1, [Greatest Common Divisor](https://en.wikipedia.org/wiki/Greatest_common_divisor), [Quicksort](https://en.wikipedia.org/wiki/Quicksort), etc.\n- four local variables (`var/scope/local`): `n`, `result`, `a`, `b`.\n\nThe magic command `%%paroxython` (corresponding to the subcommand [`tag`](https://laowantong.github.io/paroxython/cli_tag.html)) only scratches the surface of the system. As shown before, to estimate the learning cost of the features and get actionable recommendations, you will need first to construct the tag database with [`collect`](https://laowantong.github.io/paroxython/cli_collect.html), and then call [`recommend`](https://laowantong.github.io/paroxython/cli_recommend.html) on a pipeline of yours.\n\n# Read them\n\nAlthough this is still a work-in-progress, Paroxython should already be fairly well [documented](https://laowantong.github.io/paroxython/index.html):\n\n- [User manual](https://laowantong.github.io/paroxython/user_manual/index.html):\n  - [write a command pipeline to get recommendations](https://laowantong.github.io/paroxython/user_manual/index.html#pipeline-tutorial),\n  - [prepare your program collections for better results](https://laowantong.github.io/paroxython/user_manual/index#preparing-your-program-collection),\n  - [understand and modify the taxonomic classification](https://laowantong.github.io/paroxython/user_manual/index#taxonomy),\n  - and more.\n- [Developer manual](https://laowantong.github.io/paroxython/developer_manual/index.html):\n  - [get a rough idea of the program structure and operations](https://laowantong.github.io/paroxython/developer_manual/index.html#bird-view),\n  - [use the provided helpers to contribute to the code](helper-programs),\n  - and more.\n- [Module reference](https://laowantong.github.io/paroxython/#header-submodules).\n- [Feature specifications](https://github.com/laowantong/paroxython/blob/master/paroxython/resources/spec.md): a document mixing prose, tests, regular expressions and SQL queries to describe which algorithmic features are recognized and how.\n- [User types](https://github.com/laowantong/paroxython/blob/master/paroxython/user_types.py): all objects of interest are precisely typed and checked by [mypy](http://mypy-lang.org).\n\nFinally, a [battery of examples](https://github.com/laowantong/paroxython/tree/master/examples) and [comprehensive test coverage](https://github.com/laowantong/paroxython/tree/master/tests) should help answer any remaining question.\n',
    'author': 'Aristide Grange',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/laowantong/paroxython/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
