# -*- coding: utf-8 -*-

"""Console script for resseg."""
import sys
import click


INPUT_FILE_TYPE = click.Path(exists=True, dir_okay=False)
OUTPUT_FILE_TYPE = click.Path(dir_okay=False)

@click.command()
@click.argument('input-path', type=INPUT_FILE_TYPE)
@click.option(
    '--output-path', '-o',
    type=OUTPUT_FILE_TYPE,
    help='Output image path. If not given, "_seg" will be added to the input path'
)
@click.option(
    '--tta-iterations', '-a',
    type=int,
    default=0,
    show_default=True,
    help='Number of test-time augmentations (TTA). Using a number greater than zero might yield slightly better results'
)
@click.option(
    '--interpolation', '-i',
    type=str,
    default='bspline',
    show_default=True,
)
@click.option(
    '--num_workers', '-j',
    type=int,
    default=0,
    show_default=True,
)
@click.option(
    '--postprocess/--raw',
    default=True,
    show_default=True,
)
@click.option(
    '--transform-mni', '-t',
    type=INPUT_FILE_TYPE,
    help='Path to an affine transform generated by resseg-mni (highly recommended)'
)
@click.option(
    '--seed', '-s',
    type=int,
    help='Seed to reproduce TTA results'
)
def main(
        input_path,
        output_path,
        tta_iterations,
        interpolation,
        num_workers,
        postprocess,
        transform_mni,
        seed,
        ):
    """Console script for resseg."""
    from resseg import resseg
    if seed is not None:
        import torch
        torch.manual_seed(seed)
    resseg(
        input_path,
        output_path,
        tta_iterations,
        interpolation,
        num_workers,
        postprocess=postprocess,
        mni_transform_path=transform_mni,
    )
    return 0


if __name__ == "__main__":
    # pylint: disable=no-value-for-parameter
    sys.exit(main())  # pragma: no cover
