"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-6207
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.policy_abstract_profile_relationship import PolicyAbstractProfileRelationship
    from intersight.model.storage_base_cluster_relationship import StorageBaseClusterRelationship
    from intersight.model.virtualization_cpu_allocation import VirtualizationCpuAllocation
    from intersight.model.virtualization_memory_allocation import VirtualizationMemoryAllocation
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['PolicyAbstractProfileRelationship'] = PolicyAbstractProfileRelationship
    globals()['StorageBaseClusterRelationship'] = StorageBaseClusterRelationship
    globals()['VirtualizationCpuAllocation'] = VirtualizationCpuAllocation
    globals()['VirtualizationMemoryAllocation'] = VirtualizationMemoryAllocation


class VirtualizationIweClusterAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'VIRTUALIZATION.IWECLUSTER': "virtualization.IweCluster",
        },
        ('object_type',): {
            'VIRTUALIZATION.IWECLUSTER': "virtualization.IweCluster",
        },
        ('deployment_type',): {
            'NA': "NA",
            'DATACENTER': "Datacenter",
            'STRETCHED_CLUSTER': "Stretched Cluster",
            'EDGE': "Edge",
        },
        ('drive_type',): {
            'NA': "NA",
            'ALL-FLASH': "All-Flash",
            'HYBRID': "Hybrid",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'capacity_runway': (int,),  # noqa: E501
            'cluster_name': (str,),  # noqa: E501
            'compute_node_count': (int,),  # noqa: E501
            'configured_cpu_over_sub_factor': (float,),  # noqa: E501
            'converged_node_count': (int,),  # noqa: E501
            'cpu_allocation': (VirtualizationCpuAllocation,),  # noqa: E501
            'current_cpu_over_sub_factor': (float,),  # noqa: E501
            'datacenter_name': (str,),  # noqa: E501
            'deployment_type': (str,),  # noqa: E501
            'drive_type': (str,),  # noqa: E501
            'failure_reason': (str,),  # noqa: E501
            'hx_version': (str,),  # noqa: E501
            'hypervisor_build': (str,),  # noqa: E501
            'management_ip_address': (str,),  # noqa: E501
            'memory_allocation': (VirtualizationMemoryAllocation,),  # noqa: E501
            'storage_capacity': (int,),  # noqa: E501
            'storage_node_count': (int,),  # noqa: E501
            'storage_utilization': (float,),  # noqa: E501
            'utilization_percentage': (float,),  # noqa: E501
            'utilization_trend_percentage': (float,),  # noqa: E501
            'associated_profile': (PolicyAbstractProfileRelationship,),  # noqa: E501
            'hx_cluster': (StorageBaseClusterRelationship,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'capacity_runway': 'CapacityRunway',  # noqa: E501
        'cluster_name': 'ClusterName',  # noqa: E501
        'compute_node_count': 'ComputeNodeCount',  # noqa: E501
        'configured_cpu_over_sub_factor': 'ConfiguredCpuOverSubFactor',  # noqa: E501
        'converged_node_count': 'ConvergedNodeCount',  # noqa: E501
        'cpu_allocation': 'CpuAllocation',  # noqa: E501
        'current_cpu_over_sub_factor': 'CurrentCpuOverSubFactor',  # noqa: E501
        'datacenter_name': 'DatacenterName',  # noqa: E501
        'deployment_type': 'DeploymentType',  # noqa: E501
        'drive_type': 'DriveType',  # noqa: E501
        'failure_reason': 'FailureReason',  # noqa: E501
        'hx_version': 'HxVersion',  # noqa: E501
        'hypervisor_build': 'HypervisorBuild',  # noqa: E501
        'management_ip_address': 'ManagementIpAddress',  # noqa: E501
        'memory_allocation': 'MemoryAllocation',  # noqa: E501
        'storage_capacity': 'StorageCapacity',  # noqa: E501
        'storage_node_count': 'StorageNodeCount',  # noqa: E501
        'storage_utilization': 'StorageUtilization',  # noqa: E501
        'utilization_percentage': 'UtilizationPercentage',  # noqa: E501
        'utilization_trend_percentage': 'UtilizationTrendPercentage',  # noqa: E501
        'associated_profile': 'AssociatedProfile',  # noqa: E501
        'hx_cluster': 'HxCluster',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
    }

    read_only_vars = {
        'capacity_runway',  # noqa: E501
        'cluster_name',  # noqa: E501
        'compute_node_count',  # noqa: E501
        'converged_node_count',  # noqa: E501
        'deployment_type',  # noqa: E501
        'drive_type',  # noqa: E501
        'hx_version',  # noqa: E501
        'storage_capacity',  # noqa: E501
        'storage_node_count',  # noqa: E501
        'storage_utilization',  # noqa: E501
        'utilization_percentage',  # noqa: E501
        'utilization_trend_percentage',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """VirtualizationIweClusterAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.IweCluster", must be one of ["virtualization.IweCluster", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.IweCluster", must be one of ["virtualization.IweCluster", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            capacity_runway (int): The number of days remaining before the cluster's storage utilization reaches the recommended capacity limit of 76%. Default value is math.MaxInt32 to indicate that the capacity runway is \"Unknown\" for a cluster that is not connected or with not sufficient data.. [optional] if omitted the server will use the default value of 2147483647  # noqa: E501
            cluster_name (str): The name of this HyperFlex cluster.. [optional]  # noqa: E501
            compute_node_count (int): The number of compute nodes that belong to this cluster.. [optional]  # noqa: E501
            configured_cpu_over_sub_factor (float): CPU oversubscription factor configured on the cluster.. [optional]  # noqa: E501
            converged_node_count (int): The number of converged nodes that belong to this cluster.. [optional]  # noqa: E501
            cpu_allocation (VirtualizationCpuAllocation): [optional]  # noqa: E501
            current_cpu_over_sub_factor (float): Current oversubscription factor of the cluster.. [optional]  # noqa: E501
            datacenter_name (str): Datacenter to which the cluster belongs.. [optional]  # noqa: E501
            deployment_type (str): The deployment type of the HyperFlex cluster. The cluster can have one of the following configurations: 1. Datacenter: The HyperFlex cluster consists of UCS Fabric Interconnect-attached nodes on a single site. 2. Stretched Cluster: The HyperFlex cluster consists of UCS Fabric Interconnect-attached nodes distributed across multiple sites. 3. Edge: The HyperFlex cluster consists of 2-4 standalone nodes. If the cluster is running a HyperFlex Data Platform version less than 4.0 or if the deployment type cannot be determined, the deployment type is set as 'NA' (not available). * `NA` - The deployment type of the cluster is not available. * `Datacenter` - The deployment type of a cluster consisting of UCS Fabric Interconnect-attached nodes on the same site. * `Stretched Cluster` - The deployment type of a cluster consisting of UCS Fabric Interconnect-attached nodes across different sites. * `Edge` - The deployment type of a cluster consisting of 2 or more standalone nodes.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            drive_type (str): The type of the drives used for storage in this cluster. * `NA` - The drive type of the cluster is not available. * `All-Flash` - Indicates that this cluster contains flash drives only. * `Hybrid` - Indicates that this cluster contains both flash and hard disk drives.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            failure_reason (str): Reason for the failure when cluster is in failed state.. [optional]  # noqa: E501
            hx_version (str): The HyperFlex Data or Application Platform version of this cluster.. [optional]  # noqa: E501
            hypervisor_build (str): Hypervisor version of HyperFlex compute cluster along with build number.. [optional]  # noqa: E501
            management_ip_address (str): Management IP Address of the cluster.. [optional]  # noqa: E501
            memory_allocation (VirtualizationMemoryAllocation): [optional]  # noqa: E501
            storage_capacity (int): The storage capacity in this cluster.. [optional]  # noqa: E501
            storage_node_count (int): The number of storage nodes that belong to this cluster.. [optional]  # noqa: E501
            storage_utilization (float): The storage utilization is computed based on total capacity and current capacity utilization.. [optional]  # noqa: E501
            utilization_percentage (float): The storage utilization percentage is computed based on total capacity and current capacity utilization.. [optional]  # noqa: E501
            utilization_trend_percentage (float): The storage utilization trend percentage represents the trend in percentage computed using the first and last point from historical data.. [optional]  # noqa: E501
            associated_profile (PolicyAbstractProfileRelationship): [optional]  # noqa: E501
            hx_cluster (StorageBaseClusterRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "virtualization.IweCluster")
        object_type = kwargs.get('object_type', "virtualization.IweCluster")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """VirtualizationIweClusterAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.IweCluster", must be one of ["virtualization.IweCluster", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.IweCluster", must be one of ["virtualization.IweCluster", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            capacity_runway (int): The number of days remaining before the cluster's storage utilization reaches the recommended capacity limit of 76%. Default value is math.MaxInt32 to indicate that the capacity runway is \"Unknown\" for a cluster that is not connected or with not sufficient data.. [optional] if omitted the server will use the default value of 2147483647  # noqa: E501
            cluster_name (str): The name of this HyperFlex cluster.. [optional]  # noqa: E501
            compute_node_count (int): The number of compute nodes that belong to this cluster.. [optional]  # noqa: E501
            configured_cpu_over_sub_factor (float): CPU oversubscription factor configured on the cluster.. [optional]  # noqa: E501
            converged_node_count (int): The number of converged nodes that belong to this cluster.. [optional]  # noqa: E501
            cpu_allocation (VirtualizationCpuAllocation): [optional]  # noqa: E501
            current_cpu_over_sub_factor (float): Current oversubscription factor of the cluster.. [optional]  # noqa: E501
            datacenter_name (str): Datacenter to which the cluster belongs.. [optional]  # noqa: E501
            deployment_type (str): The deployment type of the HyperFlex cluster. The cluster can have one of the following configurations: 1. Datacenter: The HyperFlex cluster consists of UCS Fabric Interconnect-attached nodes on a single site. 2. Stretched Cluster: The HyperFlex cluster consists of UCS Fabric Interconnect-attached nodes distributed across multiple sites. 3. Edge: The HyperFlex cluster consists of 2-4 standalone nodes. If the cluster is running a HyperFlex Data Platform version less than 4.0 or if the deployment type cannot be determined, the deployment type is set as 'NA' (not available). * `NA` - The deployment type of the cluster is not available. * `Datacenter` - The deployment type of a cluster consisting of UCS Fabric Interconnect-attached nodes on the same site. * `Stretched Cluster` - The deployment type of a cluster consisting of UCS Fabric Interconnect-attached nodes across different sites. * `Edge` - The deployment type of a cluster consisting of 2 or more standalone nodes.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            drive_type (str): The type of the drives used for storage in this cluster. * `NA` - The drive type of the cluster is not available. * `All-Flash` - Indicates that this cluster contains flash drives only. * `Hybrid` - Indicates that this cluster contains both flash and hard disk drives.. [optional] if omitted the server will use the default value of "NA"  # noqa: E501
            failure_reason (str): Reason for the failure when cluster is in failed state.. [optional]  # noqa: E501
            hx_version (str): The HyperFlex Data or Application Platform version of this cluster.. [optional]  # noqa: E501
            hypervisor_build (str): Hypervisor version of HyperFlex compute cluster along with build number.. [optional]  # noqa: E501
            management_ip_address (str): Management IP Address of the cluster.. [optional]  # noqa: E501
            memory_allocation (VirtualizationMemoryAllocation): [optional]  # noqa: E501
            storage_capacity (int): The storage capacity in this cluster.. [optional]  # noqa: E501
            storage_node_count (int): The number of storage nodes that belong to this cluster.. [optional]  # noqa: E501
            storage_utilization (float): The storage utilization is computed based on total capacity and current capacity utilization.. [optional]  # noqa: E501
            utilization_percentage (float): The storage utilization percentage is computed based on total capacity and current capacity utilization.. [optional]  # noqa: E501
            utilization_trend_percentage (float): The storage utilization trend percentage represents the trend in percentage computed using the first and last point from historical data.. [optional]  # noqa: E501
            associated_profile (PolicyAbstractProfileRelationship): [optional]  # noqa: E501
            hx_cluster (StorageBaseClusterRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "virtualization.IweCluster")
        object_type = kwargs.get('object_type', "virtualization.IweCluster")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
