"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-6207
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.aaa_retention_policy import AaaRetentionPolicy
    from intersight.model.access_policy import AccessPolicy
    from intersight.model.adapter_config_policy import AdapterConfigPolicy
    from intersight.model.bios_policy import BiosPolicy
    from intersight.model.boot_precision_policy import BootPrecisionPolicy
    from intersight.model.certificatemanagement_policy import CertificatemanagementPolicy
    from intersight.model.comm_abstract_http_proxy_policy import CommAbstractHttpProxyPolicy
    from intersight.model.comm_http_proxy_policy import CommHttpProxyPolicy
    from intersight.model.compute_server_power_policy import ComputeServerPowerPolicy
    from intersight.model.deviceconnector_policy import DeviceconnectorPolicy
    from intersight.model.display_names import DisplayNames
    from intersight.model.fabric_eth_network_control_policy import FabricEthNetworkControlPolicy
    from intersight.model.fabric_eth_network_group_policy import FabricEthNetworkGroupPolicy
    from intersight.model.fabric_eth_network_policy import FabricEthNetworkPolicy
    from intersight.model.fabric_fc_network_policy import FabricFcNetworkPolicy
    from intersight.model.fabric_flow_control_policy import FabricFlowControlPolicy
    from intersight.model.fabric_link_aggregation_policy import FabricLinkAggregationPolicy
    from intersight.model.fabric_link_control_policy import FabricLinkControlPolicy
    from intersight.model.fabric_multicast_policy import FabricMulticastPolicy
    from intersight.model.fabric_port_policy import FabricPortPolicy
    from intersight.model.fabric_switch_control_policy import FabricSwitchControlPolicy
    from intersight.model.fabric_system_qos_policy import FabricSystemQosPolicy
    from intersight.model.fcpool_pool import FcpoolPool
    from intersight.model.hyperflex_auto_support_policy import HyperflexAutoSupportPolicy
    from intersight.model.hyperflex_cluster_backup_policy import HyperflexClusterBackupPolicy
    from intersight.model.hyperflex_cluster_network_policy import HyperflexClusterNetworkPolicy
    from intersight.model.hyperflex_cluster_replication_network_policy import HyperflexClusterReplicationNetworkPolicy
    from intersight.model.hyperflex_cluster_storage_policy import HyperflexClusterStoragePolicy
    from intersight.model.hyperflex_ext_fc_storage_policy import HyperflexExtFcStoragePolicy
    from intersight.model.hyperflex_ext_iscsi_storage_policy import HyperflexExtIscsiStoragePolicy
    from intersight.model.hyperflex_local_credential_policy import HyperflexLocalCredentialPolicy
    from intersight.model.hyperflex_node_config_policy import HyperflexNodeConfigPolicy
    from intersight.model.hyperflex_proxy_setting_policy import HyperflexProxySettingPolicy
    from intersight.model.hyperflex_software_version_policy import HyperflexSoftwareVersionPolicy
    from intersight.model.hyperflex_sys_config_policy import HyperflexSysConfigPolicy
    from intersight.model.hyperflex_ucsm_config_policy import HyperflexUcsmConfigPolicy
    from intersight.model.hyperflex_vcenter_config_policy import HyperflexVcenterConfigPolicy
    from intersight.model.iam_end_point_user_policy import IamEndPointUserPolicy
    from intersight.model.iam_ldap_policy import IamLdapPolicy
    from intersight.model.ipmioverlan_policy import IpmioverlanPolicy
    from intersight.model.ippool_pool import IppoolPool
    from intersight.model.ippool_shadow_pool import IppoolShadowPool
    from intersight.model.iqnpool_pool import IqnpoolPool
    from intersight.model.kubernetes_addon_policy import KubernetesAddonPolicy
    from intersight.model.kubernetes_container_runtime_policy import KubernetesContainerRuntimePolicy
    from intersight.model.kubernetes_network_policy import KubernetesNetworkPolicy
    from intersight.model.kubernetes_sys_config_policy import KubernetesSysConfigPolicy
    from intersight.model.kubernetes_trusted_registries_policy import KubernetesTrustedRegistriesPolicy
    from intersight.model.kubernetes_version_policy import KubernetesVersionPolicy
    from intersight.model.kubernetes_virtual_machine_infra_config_policy import KubernetesVirtualMachineInfraConfigPolicy
    from intersight.model.kubernetes_virtual_machine_instance_type import KubernetesVirtualMachineInstanceType
    from intersight.model.kvm_policy import KvmPolicy
    from intersight.model.macpool_pool import MacpoolPool
    from intersight.model.memory_persistent_memory_policy import MemoryPersistentMemoryPolicy
    from intersight.model.mo_base_mo import MoBaseMo
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.networkconfig_policy import NetworkconfigPolicy
    from intersight.model.ntp_policy import NtpPolicy
    from intersight.model.policy_abstract_policy_all_of import PolicyAbstractPolicyAllOf
    from intersight.model.pool_abstract_pool import PoolAbstractPool
    from intersight.model.power_policy import PowerPolicy
    from intersight.model.recovery_abstract_backup_config import RecoveryAbstractBackupConfig
    from intersight.model.recovery_backup_config_policy import RecoveryBackupConfigPolicy
    from intersight.model.recovery_on_demand_backup import RecoveryOnDemandBackup
    from intersight.model.recovery_schedule_config_policy import RecoveryScheduleConfigPolicy
    from intersight.model.resourcepool_pool import ResourcepoolPool
    from intersight.model.sdcard_policy import SdcardPolicy
    from intersight.model.smtp_policy import SmtpPolicy
    from intersight.model.snmp_policy import SnmpPolicy
    from intersight.model.sol_policy import SolPolicy
    from intersight.model.ssh_policy import SshPolicy
    from intersight.model.storage_storage_policy import StorageStoragePolicy
    from intersight.model.syslog_policy import SyslogPolicy
    from intersight.model.thermal_policy import ThermalPolicy
    from intersight.model.uuidpool_pool import UuidpoolPool
    from intersight.model.vmedia_policy import VmediaPolicy
    from intersight.model.vnic_eth_adapter_policy import VnicEthAdapterPolicy
    from intersight.model.vnic_eth_network_policy import VnicEthNetworkPolicy
    from intersight.model.vnic_eth_qos_policy import VnicEthQosPolicy
    from intersight.model.vnic_fc_adapter_policy import VnicFcAdapterPolicy
    from intersight.model.vnic_fc_network_policy import VnicFcNetworkPolicy
    from intersight.model.vnic_fc_qos_policy import VnicFcQosPolicy
    from intersight.model.vnic_iscsi_adapter_policy import VnicIscsiAdapterPolicy
    from intersight.model.vnic_iscsi_boot_policy import VnicIscsiBootPolicy
    from intersight.model.vnic_iscsi_static_target_policy import VnicIscsiStaticTargetPolicy
    from intersight.model.vnic_lan_connectivity_policy import VnicLanConnectivityPolicy
    from intersight.model.vnic_san_connectivity_policy import VnicSanConnectivityPolicy
    globals()['AaaRetentionPolicy'] = AaaRetentionPolicy
    globals()['AccessPolicy'] = AccessPolicy
    globals()['AdapterConfigPolicy'] = AdapterConfigPolicy
    globals()['BiosPolicy'] = BiosPolicy
    globals()['BootPrecisionPolicy'] = BootPrecisionPolicy
    globals()['CertificatemanagementPolicy'] = CertificatemanagementPolicy
    globals()['CommAbstractHttpProxyPolicy'] = CommAbstractHttpProxyPolicy
    globals()['CommHttpProxyPolicy'] = CommHttpProxyPolicy
    globals()['ComputeServerPowerPolicy'] = ComputeServerPowerPolicy
    globals()['DeviceconnectorPolicy'] = DeviceconnectorPolicy
    globals()['DisplayNames'] = DisplayNames
    globals()['FabricEthNetworkControlPolicy'] = FabricEthNetworkControlPolicy
    globals()['FabricEthNetworkGroupPolicy'] = FabricEthNetworkGroupPolicy
    globals()['FabricEthNetworkPolicy'] = FabricEthNetworkPolicy
    globals()['FabricFcNetworkPolicy'] = FabricFcNetworkPolicy
    globals()['FabricFlowControlPolicy'] = FabricFlowControlPolicy
    globals()['FabricLinkAggregationPolicy'] = FabricLinkAggregationPolicy
    globals()['FabricLinkControlPolicy'] = FabricLinkControlPolicy
    globals()['FabricMulticastPolicy'] = FabricMulticastPolicy
    globals()['FabricPortPolicy'] = FabricPortPolicy
    globals()['FabricSwitchControlPolicy'] = FabricSwitchControlPolicy
    globals()['FabricSystemQosPolicy'] = FabricSystemQosPolicy
    globals()['FcpoolPool'] = FcpoolPool
    globals()['HyperflexAutoSupportPolicy'] = HyperflexAutoSupportPolicy
    globals()['HyperflexClusterBackupPolicy'] = HyperflexClusterBackupPolicy
    globals()['HyperflexClusterNetworkPolicy'] = HyperflexClusterNetworkPolicy
    globals()['HyperflexClusterReplicationNetworkPolicy'] = HyperflexClusterReplicationNetworkPolicy
    globals()['HyperflexClusterStoragePolicy'] = HyperflexClusterStoragePolicy
    globals()['HyperflexExtFcStoragePolicy'] = HyperflexExtFcStoragePolicy
    globals()['HyperflexExtIscsiStoragePolicy'] = HyperflexExtIscsiStoragePolicy
    globals()['HyperflexLocalCredentialPolicy'] = HyperflexLocalCredentialPolicy
    globals()['HyperflexNodeConfigPolicy'] = HyperflexNodeConfigPolicy
    globals()['HyperflexProxySettingPolicy'] = HyperflexProxySettingPolicy
    globals()['HyperflexSoftwareVersionPolicy'] = HyperflexSoftwareVersionPolicy
    globals()['HyperflexSysConfigPolicy'] = HyperflexSysConfigPolicy
    globals()['HyperflexUcsmConfigPolicy'] = HyperflexUcsmConfigPolicy
    globals()['HyperflexVcenterConfigPolicy'] = HyperflexVcenterConfigPolicy
    globals()['IamEndPointUserPolicy'] = IamEndPointUserPolicy
    globals()['IamLdapPolicy'] = IamLdapPolicy
    globals()['IpmioverlanPolicy'] = IpmioverlanPolicy
    globals()['IppoolPool'] = IppoolPool
    globals()['IppoolShadowPool'] = IppoolShadowPool
    globals()['IqnpoolPool'] = IqnpoolPool
    globals()['KubernetesAddonPolicy'] = KubernetesAddonPolicy
    globals()['KubernetesContainerRuntimePolicy'] = KubernetesContainerRuntimePolicy
    globals()['KubernetesNetworkPolicy'] = KubernetesNetworkPolicy
    globals()['KubernetesSysConfigPolicy'] = KubernetesSysConfigPolicy
    globals()['KubernetesTrustedRegistriesPolicy'] = KubernetesTrustedRegistriesPolicy
    globals()['KubernetesVersionPolicy'] = KubernetesVersionPolicy
    globals()['KubernetesVirtualMachineInfraConfigPolicy'] = KubernetesVirtualMachineInfraConfigPolicy
    globals()['KubernetesVirtualMachineInstanceType'] = KubernetesVirtualMachineInstanceType
    globals()['KvmPolicy'] = KvmPolicy
    globals()['MacpoolPool'] = MacpoolPool
    globals()['MemoryPersistentMemoryPolicy'] = MemoryPersistentMemoryPolicy
    globals()['MoBaseMo'] = MoBaseMo
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['NetworkconfigPolicy'] = NetworkconfigPolicy
    globals()['NtpPolicy'] = NtpPolicy
    globals()['PolicyAbstractPolicyAllOf'] = PolicyAbstractPolicyAllOf
    globals()['PoolAbstractPool'] = PoolAbstractPool
    globals()['PowerPolicy'] = PowerPolicy
    globals()['RecoveryAbstractBackupConfig'] = RecoveryAbstractBackupConfig
    globals()['RecoveryBackupConfigPolicy'] = RecoveryBackupConfigPolicy
    globals()['RecoveryOnDemandBackup'] = RecoveryOnDemandBackup
    globals()['RecoveryScheduleConfigPolicy'] = RecoveryScheduleConfigPolicy
    globals()['ResourcepoolPool'] = ResourcepoolPool
    globals()['SdcardPolicy'] = SdcardPolicy
    globals()['SmtpPolicy'] = SmtpPolicy
    globals()['SnmpPolicy'] = SnmpPolicy
    globals()['SolPolicy'] = SolPolicy
    globals()['SshPolicy'] = SshPolicy
    globals()['StorageStoragePolicy'] = StorageStoragePolicy
    globals()['SyslogPolicy'] = SyslogPolicy
    globals()['ThermalPolicy'] = ThermalPolicy
    globals()['UuidpoolPool'] = UuidpoolPool
    globals()['VmediaPolicy'] = VmediaPolicy
    globals()['VnicEthAdapterPolicy'] = VnicEthAdapterPolicy
    globals()['VnicEthNetworkPolicy'] = VnicEthNetworkPolicy
    globals()['VnicEthQosPolicy'] = VnicEthQosPolicy
    globals()['VnicFcAdapterPolicy'] = VnicFcAdapterPolicy
    globals()['VnicFcNetworkPolicy'] = VnicFcNetworkPolicy
    globals()['VnicFcQosPolicy'] = VnicFcQosPolicy
    globals()['VnicIscsiAdapterPolicy'] = VnicIscsiAdapterPolicy
    globals()['VnicIscsiBootPolicy'] = VnicIscsiBootPolicy
    globals()['VnicIscsiStaticTargetPolicy'] = VnicIscsiStaticTargetPolicy
    globals()['VnicLanConnectivityPolicy'] = VnicLanConnectivityPolicy
    globals()['VnicSanConnectivityPolicy'] = VnicSanConnectivityPolicy


class PolicyAbstractPolicy(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'AAA.RETENTIONPOLICY': "aaa.RetentionPolicy",
            'ACCESS.POLICY': "access.Policy",
            'ADAPTER.CONFIGPOLICY': "adapter.ConfigPolicy",
            'BIOS.POLICY': "bios.Policy",
            'BOOT.PRECISIONPOLICY': "boot.PrecisionPolicy",
            'CERTIFICATEMANAGEMENT.POLICY': "certificatemanagement.Policy",
            'COMM.HTTPPROXYPOLICY': "comm.HttpProxyPolicy",
            'COMPUTE.SERVERPOWERPOLICY': "compute.ServerPowerPolicy",
            'DEVICECONNECTOR.POLICY': "deviceconnector.Policy",
            'FABRIC.ETHNETWORKCONTROLPOLICY': "fabric.EthNetworkControlPolicy",
            'FABRIC.ETHNETWORKGROUPPOLICY': "fabric.EthNetworkGroupPolicy",
            'FABRIC.ETHNETWORKPOLICY': "fabric.EthNetworkPolicy",
            'FABRIC.FCNETWORKPOLICY': "fabric.FcNetworkPolicy",
            'FABRIC.FLOWCONTROLPOLICY': "fabric.FlowControlPolicy",
            'FABRIC.LINKAGGREGATIONPOLICY': "fabric.LinkAggregationPolicy",
            'FABRIC.LINKCONTROLPOLICY': "fabric.LinkControlPolicy",
            'FABRIC.MULTICASTPOLICY': "fabric.MulticastPolicy",
            'FABRIC.PORTPOLICY': "fabric.PortPolicy",
            'FABRIC.SWITCHCONTROLPOLICY': "fabric.SwitchControlPolicy",
            'FABRIC.SYSTEMQOSPOLICY': "fabric.SystemQosPolicy",
            'FCPOOL.POOL': "fcpool.Pool",
            'HYPERFLEX.AUTOSUPPORTPOLICY': "hyperflex.AutoSupportPolicy",
            'HYPERFLEX.CLUSTERBACKUPPOLICY': "hyperflex.ClusterBackupPolicy",
            'HYPERFLEX.CLUSTERNETWORKPOLICY': "hyperflex.ClusterNetworkPolicy",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICY': "hyperflex.ClusterReplicationNetworkPolicy",
            'HYPERFLEX.CLUSTERSTORAGEPOLICY': "hyperflex.ClusterStoragePolicy",
            'HYPERFLEX.EXTFCSTORAGEPOLICY': "hyperflex.ExtFcStoragePolicy",
            'HYPERFLEX.EXTISCSISTORAGEPOLICY': "hyperflex.ExtIscsiStoragePolicy",
            'HYPERFLEX.LOCALCREDENTIALPOLICY': "hyperflex.LocalCredentialPolicy",
            'HYPERFLEX.NODECONFIGPOLICY': "hyperflex.NodeConfigPolicy",
            'HYPERFLEX.PROXYSETTINGPOLICY': "hyperflex.ProxySettingPolicy",
            'HYPERFLEX.SOFTWAREVERSIONPOLICY': "hyperflex.SoftwareVersionPolicy",
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
            'HYPERFLEX.UCSMCONFIGPOLICY': "hyperflex.UcsmConfigPolicy",
            'HYPERFLEX.VCENTERCONFIGPOLICY': "hyperflex.VcenterConfigPolicy",
            'IAM.ENDPOINTUSERPOLICY': "iam.EndPointUserPolicy",
            'IAM.LDAPPOLICY': "iam.LdapPolicy",
            'IPMIOVERLAN.POLICY': "ipmioverlan.Policy",
            'IPPOOL.POOL': "ippool.Pool",
            'IPPOOL.SHADOWPOOL': "ippool.ShadowPool",
            'IQNPOOL.POOL': "iqnpool.Pool",
            'KUBERNETES.ADDONPOLICY': "kubernetes.AddonPolicy",
            'KUBERNETES.CONTAINERRUNTIMEPOLICY': "kubernetes.ContainerRuntimePolicy",
            'KUBERNETES.NETWORKPOLICY': "kubernetes.NetworkPolicy",
            'KUBERNETES.SYSCONFIGPOLICY': "kubernetes.SysConfigPolicy",
            'KUBERNETES.TRUSTEDREGISTRIESPOLICY': "kubernetes.TrustedRegistriesPolicy",
            'KUBERNETES.VERSIONPOLICY': "kubernetes.VersionPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRACONFIGPOLICY': "kubernetes.VirtualMachineInfraConfigPolicy",
            'KUBERNETES.VIRTUALMACHINEINSTANCETYPE': "kubernetes.VirtualMachineInstanceType",
            'KVM.POLICY': "kvm.Policy",
            'MACPOOL.POOL': "macpool.Pool",
            'MEMORY.PERSISTENTMEMORYPOLICY': "memory.PersistentMemoryPolicy",
            'NETWORKCONFIG.POLICY': "networkconfig.Policy",
            'NTP.POLICY': "ntp.Policy",
            'POWER.POLICY': "power.Policy",
            'RECOVERY.BACKUPCONFIGPOLICY': "recovery.BackupConfigPolicy",
            'RECOVERY.ONDEMANDBACKUP': "recovery.OnDemandBackup",
            'RECOVERY.SCHEDULECONFIGPOLICY': "recovery.ScheduleConfigPolicy",
            'RESOURCEPOOL.POOL': "resourcepool.Pool",
            'SDCARD.POLICY': "sdcard.Policy",
            'SMTP.POLICY': "smtp.Policy",
            'SNMP.POLICY': "snmp.Policy",
            'SOL.POLICY': "sol.Policy",
            'SSH.POLICY': "ssh.Policy",
            'STORAGE.STORAGEPOLICY': "storage.StoragePolicy",
            'SYSLOG.POLICY': "syslog.Policy",
            'THERMAL.POLICY': "thermal.Policy",
            'UUIDPOOL.POOL': "uuidpool.Pool",
            'VMEDIA.POLICY': "vmedia.Policy",
            'VNIC.ETHADAPTERPOLICY': "vnic.EthAdapterPolicy",
            'VNIC.ETHNETWORKPOLICY': "vnic.EthNetworkPolicy",
            'VNIC.ETHQOSPOLICY': "vnic.EthQosPolicy",
            'VNIC.FCADAPTERPOLICY': "vnic.FcAdapterPolicy",
            'VNIC.FCNETWORKPOLICY': "vnic.FcNetworkPolicy",
            'VNIC.FCQOSPOLICY': "vnic.FcQosPolicy",
            'VNIC.ISCSIADAPTERPOLICY': "vnic.IscsiAdapterPolicy",
            'VNIC.ISCSIBOOTPOLICY': "vnic.IscsiBootPolicy",
            'VNIC.ISCSISTATICTARGETPOLICY': "vnic.IscsiStaticTargetPolicy",
            'VNIC.LANCONNECTIVITYPOLICY': "vnic.LanConnectivityPolicy",
            'VNIC.SANCONNECTIVITYPOLICY': "vnic.SanConnectivityPolicy",
        },
        ('object_type',): {
            'AAA.RETENTIONPOLICY': "aaa.RetentionPolicy",
            'ACCESS.POLICY': "access.Policy",
            'ADAPTER.CONFIGPOLICY': "adapter.ConfigPolicy",
            'BIOS.POLICY': "bios.Policy",
            'BOOT.PRECISIONPOLICY': "boot.PrecisionPolicy",
            'CERTIFICATEMANAGEMENT.POLICY': "certificatemanagement.Policy",
            'COMM.HTTPPROXYPOLICY': "comm.HttpProxyPolicy",
            'COMPUTE.SERVERPOWERPOLICY': "compute.ServerPowerPolicy",
            'DEVICECONNECTOR.POLICY': "deviceconnector.Policy",
            'FABRIC.ETHNETWORKCONTROLPOLICY': "fabric.EthNetworkControlPolicy",
            'FABRIC.ETHNETWORKGROUPPOLICY': "fabric.EthNetworkGroupPolicy",
            'FABRIC.ETHNETWORKPOLICY': "fabric.EthNetworkPolicy",
            'FABRIC.FCNETWORKPOLICY': "fabric.FcNetworkPolicy",
            'FABRIC.FLOWCONTROLPOLICY': "fabric.FlowControlPolicy",
            'FABRIC.LINKAGGREGATIONPOLICY': "fabric.LinkAggregationPolicy",
            'FABRIC.LINKCONTROLPOLICY': "fabric.LinkControlPolicy",
            'FABRIC.MULTICASTPOLICY': "fabric.MulticastPolicy",
            'FABRIC.PORTPOLICY': "fabric.PortPolicy",
            'FABRIC.SWITCHCONTROLPOLICY': "fabric.SwitchControlPolicy",
            'FABRIC.SYSTEMQOSPOLICY': "fabric.SystemQosPolicy",
            'FCPOOL.POOL': "fcpool.Pool",
            'HYPERFLEX.AUTOSUPPORTPOLICY': "hyperflex.AutoSupportPolicy",
            'HYPERFLEX.CLUSTERBACKUPPOLICY': "hyperflex.ClusterBackupPolicy",
            'HYPERFLEX.CLUSTERNETWORKPOLICY': "hyperflex.ClusterNetworkPolicy",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICY': "hyperflex.ClusterReplicationNetworkPolicy",
            'HYPERFLEX.CLUSTERSTORAGEPOLICY': "hyperflex.ClusterStoragePolicy",
            'HYPERFLEX.EXTFCSTORAGEPOLICY': "hyperflex.ExtFcStoragePolicy",
            'HYPERFLEX.EXTISCSISTORAGEPOLICY': "hyperflex.ExtIscsiStoragePolicy",
            'HYPERFLEX.LOCALCREDENTIALPOLICY': "hyperflex.LocalCredentialPolicy",
            'HYPERFLEX.NODECONFIGPOLICY': "hyperflex.NodeConfigPolicy",
            'HYPERFLEX.PROXYSETTINGPOLICY': "hyperflex.ProxySettingPolicy",
            'HYPERFLEX.SOFTWAREVERSIONPOLICY': "hyperflex.SoftwareVersionPolicy",
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
            'HYPERFLEX.UCSMCONFIGPOLICY': "hyperflex.UcsmConfigPolicy",
            'HYPERFLEX.VCENTERCONFIGPOLICY': "hyperflex.VcenterConfigPolicy",
            'IAM.ENDPOINTUSERPOLICY': "iam.EndPointUserPolicy",
            'IAM.LDAPPOLICY': "iam.LdapPolicy",
            'IPMIOVERLAN.POLICY': "ipmioverlan.Policy",
            'IPPOOL.POOL': "ippool.Pool",
            'IPPOOL.SHADOWPOOL': "ippool.ShadowPool",
            'IQNPOOL.POOL': "iqnpool.Pool",
            'KUBERNETES.ADDONPOLICY': "kubernetes.AddonPolicy",
            'KUBERNETES.CONTAINERRUNTIMEPOLICY': "kubernetes.ContainerRuntimePolicy",
            'KUBERNETES.NETWORKPOLICY': "kubernetes.NetworkPolicy",
            'KUBERNETES.SYSCONFIGPOLICY': "kubernetes.SysConfigPolicy",
            'KUBERNETES.TRUSTEDREGISTRIESPOLICY': "kubernetes.TrustedRegistriesPolicy",
            'KUBERNETES.VERSIONPOLICY': "kubernetes.VersionPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRACONFIGPOLICY': "kubernetes.VirtualMachineInfraConfigPolicy",
            'KUBERNETES.VIRTUALMACHINEINSTANCETYPE': "kubernetes.VirtualMachineInstanceType",
            'KVM.POLICY': "kvm.Policy",
            'MACPOOL.POOL': "macpool.Pool",
            'MEMORY.PERSISTENTMEMORYPOLICY': "memory.PersistentMemoryPolicy",
            'NETWORKCONFIG.POLICY': "networkconfig.Policy",
            'NTP.POLICY': "ntp.Policy",
            'POWER.POLICY': "power.Policy",
            'RECOVERY.BACKUPCONFIGPOLICY': "recovery.BackupConfigPolicy",
            'RECOVERY.ONDEMANDBACKUP': "recovery.OnDemandBackup",
            'RECOVERY.SCHEDULECONFIGPOLICY': "recovery.ScheduleConfigPolicy",
            'RESOURCEPOOL.POOL': "resourcepool.Pool",
            'SDCARD.POLICY': "sdcard.Policy",
            'SMTP.POLICY': "smtp.Policy",
            'SNMP.POLICY': "snmp.Policy",
            'SOL.POLICY': "sol.Policy",
            'SSH.POLICY': "ssh.Policy",
            'STORAGE.STORAGEPOLICY': "storage.StoragePolicy",
            'SYSLOG.POLICY': "syslog.Policy",
            'THERMAL.POLICY': "thermal.Policy",
            'UUIDPOOL.POOL': "uuidpool.Pool",
            'VMEDIA.POLICY': "vmedia.Policy",
            'VNIC.ETHADAPTERPOLICY': "vnic.EthAdapterPolicy",
            'VNIC.ETHNETWORKPOLICY': "vnic.EthNetworkPolicy",
            'VNIC.ETHQOSPOLICY': "vnic.EthQosPolicy",
            'VNIC.FCADAPTERPOLICY': "vnic.FcAdapterPolicy",
            'VNIC.FCNETWORKPOLICY': "vnic.FcNetworkPolicy",
            'VNIC.FCQOSPOLICY': "vnic.FcQosPolicy",
            'VNIC.ISCSIADAPTERPOLICY': "vnic.IscsiAdapterPolicy",
            'VNIC.ISCSIBOOTPOLICY': "vnic.IscsiBootPolicy",
            'VNIC.ISCSISTATICTARGETPOLICY': "vnic.IscsiStaticTargetPolicy",
            'VNIC.LANCONNECTIVITYPOLICY': "vnic.LanConnectivityPolicy",
            'VNIC.SANCONNECTIVITYPOLICY': "vnic.SanConnectivityPolicy",
        },
    }

    validations = {
        ('description',): {
            'max_length': 1024,
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9]+[\x00-\xFF]*$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9_.:-]{1,64}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'aaa.RetentionPolicy': AaaRetentionPolicy,
            'access.Policy': AccessPolicy,
            'adapter.ConfigPolicy': AdapterConfigPolicy,
            'bios.Policy': BiosPolicy,
            'boot.PrecisionPolicy': BootPrecisionPolicy,
            'certificatemanagement.Policy': CertificatemanagementPolicy,
            'comm.AbstractHttpProxyPolicy': CommAbstractHttpProxyPolicy,
            'comm.HttpProxyPolicy': CommHttpProxyPolicy,
            'compute.ServerPowerPolicy': ComputeServerPowerPolicy,
            'deviceconnector.Policy': DeviceconnectorPolicy,
            'fabric.EthNetworkControlPolicy': FabricEthNetworkControlPolicy,
            'fabric.EthNetworkGroupPolicy': FabricEthNetworkGroupPolicy,
            'fabric.EthNetworkPolicy': FabricEthNetworkPolicy,
            'fabric.FcNetworkPolicy': FabricFcNetworkPolicy,
            'fabric.FlowControlPolicy': FabricFlowControlPolicy,
            'fabric.LinkAggregationPolicy': FabricLinkAggregationPolicy,
            'fabric.LinkControlPolicy': FabricLinkControlPolicy,
            'fabric.MulticastPolicy': FabricMulticastPolicy,
            'fabric.PortPolicy': FabricPortPolicy,
            'fabric.SwitchControlPolicy': FabricSwitchControlPolicy,
            'fabric.SystemQosPolicy': FabricSystemQosPolicy,
            'fcpool.Pool': FcpoolPool,
            'hyperflex.AutoSupportPolicy': HyperflexAutoSupportPolicy,
            'hyperflex.ClusterBackupPolicy': HyperflexClusterBackupPolicy,
            'hyperflex.ClusterNetworkPolicy': HyperflexClusterNetworkPolicy,
            'hyperflex.ClusterReplicationNetworkPolicy': HyperflexClusterReplicationNetworkPolicy,
            'hyperflex.ClusterStoragePolicy': HyperflexClusterStoragePolicy,
            'hyperflex.ExtFcStoragePolicy': HyperflexExtFcStoragePolicy,
            'hyperflex.ExtIscsiStoragePolicy': HyperflexExtIscsiStoragePolicy,
            'hyperflex.LocalCredentialPolicy': HyperflexLocalCredentialPolicy,
            'hyperflex.NodeConfigPolicy': HyperflexNodeConfigPolicy,
            'hyperflex.ProxySettingPolicy': HyperflexProxySettingPolicy,
            'hyperflex.SoftwareVersionPolicy': HyperflexSoftwareVersionPolicy,
            'hyperflex.SysConfigPolicy': HyperflexSysConfigPolicy,
            'hyperflex.UcsmConfigPolicy': HyperflexUcsmConfigPolicy,
            'hyperflex.VcenterConfigPolicy': HyperflexVcenterConfigPolicy,
            'iam.EndPointUserPolicy': IamEndPointUserPolicy,
            'iam.LdapPolicy': IamLdapPolicy,
            'ipmioverlan.Policy': IpmioverlanPolicy,
            'ippool.Pool': IppoolPool,
            'ippool.ShadowPool': IppoolShadowPool,
            'iqnpool.Pool': IqnpoolPool,
            'kubernetes.AddonPolicy': KubernetesAddonPolicy,
            'kubernetes.ContainerRuntimePolicy': KubernetesContainerRuntimePolicy,
            'kubernetes.NetworkPolicy': KubernetesNetworkPolicy,
            'kubernetes.SysConfigPolicy': KubernetesSysConfigPolicy,
            'kubernetes.TrustedRegistriesPolicy': KubernetesTrustedRegistriesPolicy,
            'kubernetes.VersionPolicy': KubernetesVersionPolicy,
            'kubernetes.VirtualMachineInfraConfigPolicy': KubernetesVirtualMachineInfraConfigPolicy,
            'kubernetes.VirtualMachineInstanceType': KubernetesVirtualMachineInstanceType,
            'kvm.Policy': KvmPolicy,
            'macpool.Pool': MacpoolPool,
            'memory.PersistentMemoryPolicy': MemoryPersistentMemoryPolicy,
            'networkconfig.Policy': NetworkconfigPolicy,
            'ntp.Policy': NtpPolicy,
            'pool.AbstractPool': PoolAbstractPool,
            'power.Policy': PowerPolicy,
            'recovery.AbstractBackupConfig': RecoveryAbstractBackupConfig,
            'recovery.BackupConfigPolicy': RecoveryBackupConfigPolicy,
            'recovery.OnDemandBackup': RecoveryOnDemandBackup,
            'recovery.ScheduleConfigPolicy': RecoveryScheduleConfigPolicy,
            'resourcepool.Pool': ResourcepoolPool,
            'sdcard.Policy': SdcardPolicy,
            'smtp.Policy': SmtpPolicy,
            'snmp.Policy': SnmpPolicy,
            'sol.Policy': SolPolicy,
            'ssh.Policy': SshPolicy,
            'storage.StoragePolicy': StorageStoragePolicy,
            'syslog.Policy': SyslogPolicy,
            'thermal.Policy': ThermalPolicy,
            'uuidpool.Pool': UuidpoolPool,
            'vmedia.Policy': VmediaPolicy,
            'vnic.EthAdapterPolicy': VnicEthAdapterPolicy,
            'vnic.EthNetworkPolicy': VnicEthNetworkPolicy,
            'vnic.EthQosPolicy': VnicEthQosPolicy,
            'vnic.FcAdapterPolicy': VnicFcAdapterPolicy,
            'vnic.FcNetworkPolicy': VnicFcNetworkPolicy,
            'vnic.FcQosPolicy': VnicFcQosPolicy,
            'vnic.IscsiAdapterPolicy': VnicIscsiAdapterPolicy,
            'vnic.IscsiBootPolicy': VnicIscsiBootPolicy,
            'vnic.IscsiStaticTargetPolicy': VnicIscsiStaticTargetPolicy,
            'vnic.LanConnectivityPolicy': VnicLanConnectivityPolicy,
            'vnic.SanConnectivityPolicy': VnicSanConnectivityPolicy,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
    }

    read_only_vars = {
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """PolicyAbstractPolicy - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): Description of the policy.. [optional]  # noqa: E501
            name (str): Name of the concrete policy.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """PolicyAbstractPolicy - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): Description of the policy.. [optional]  # noqa: E501
            name (str): Name of the concrete policy.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              MoBaseMo,
              PolicyAbstractPolicyAllOf,
          ],
          'oneOf': [
          ],
        }
