"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-6207
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.niatelemetry_smart_license import NiatelemetrySmartLicense
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['NiatelemetrySmartLicense'] = NiatelemetrySmartLicense


class NiatelemetryNiaFeatureUsageAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'NIATELEMETRY.NIAFEATUREUSAGE': "niatelemetry.NiaFeatureUsage",
        },
        ('object_type',): {
            'NIATELEMETRY.NIAFEATUREUSAGE': "niatelemetry.NiaFeatureUsage",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'aaa_ldap_provider_count': (int,),  # noqa: E501
            'aaa_radius_provider_count': (int,),  # noqa: E501
            'aaa_tacacs_provider_count': (int,),  # noqa: E501
            'apic_count': (int,),  # noqa: E501
            'apic_is_telnet_enabled': (bool,),  # noqa: E501
            'apic_ntp_count': (int,),  # noqa: E501
            'apic_snmp_community_count': (int,),  # noqa: E501
            'apic_sys_log_grp_count': (int,),  # noqa: E501
            'apic_sys_log_src_count': (int,),  # noqa: E501
            'app_center_count': (int,),  # noqa: E501
            'ave': (str,),  # noqa: E501
            'bd_count': (int,),  # noqa: E501
            'callhome_smart_group_count': (int,),  # noqa: E501
            'cloud_sec_peer_count': (int,),  # noqa: E501
            'comp_hv_count': (int,),  # noqa: E501
            'config_exportp_count': (int,),  # noqa: E501
            'config_job_count': (int,),  # noqa: E501
            'consistency_checker_app': (str,),  # noqa: E501
            'contract_count': (int,),  # noqa: E501
            'dns_count': (int,),  # noqa: E501
            'eigrp_count': (int,),  # noqa: E501
            'epg_count': (int,),  # noqa: E501
            'fabric_module_count': (int,),  # noqa: E501
            'fabric_setupp_count': (int,),  # noqa: E501
            'fcoe_nport_count': (int,),  # noqa: E501
            'fcoe_nport_dom_count': (int,),  # noqa: E501
            'fcoe_nport_vlan_count': (int,),  # noqa: E501
            'fcoe_nport_vsan_count': (int,),  # noqa: E501
            'fv_sla_def_count': (int,),  # noqa: E501
            'hsrp_count': (int,),  # noqa: E501
            'ibgp_count': (int,),  # noqa: E501
            'igmp_access_list_count': (int,),  # noqa: E501
            'igmp_snoop': (str,),  # noqa: E501
            'ip_epg_count': (int,),  # noqa: E501
            'is_bgp_route_reflectors_feature_used': (bool,),  # noqa: E501
            'is_bridge_domains_feature_used': (bool,),  # noqa: E501
            'is_common_local_user_name': (bool,),  # noqa: E501
            'is_contracts_feature_used': (bool,),  # noqa: E501
            'is_epg_feature_used': (bool,),  # noqa: E501
            'is_filters_feature_used': (bool,),  # noqa: E501
            'is_http_configured': (bool,),  # noqa: E501
            'is_https_configured': (bool,),  # noqa: E501
            'is_ntp_feature_used': (bool,),  # noqa: E501
            'is_ptp_feature_used': (bool,),  # noqa: E501
            'is_synce_feature_used': (bool,),  # noqa: E501
            'is_tech_support_collected': (str,),  # noqa: E501
            'is_tenants_feature_used': (bool,),  # noqa: E501
            'is_vrfs_feature_used': (bool,),  # noqa: E501
            'isis_count': (int,),  # noqa: E501
            'l2_multicast': (str,),  # noqa: E501
            'latency_ptp_mode': (str,),  # noqa: E501
            'leaf_count': (int,),  # noqa: E501
            'local_username_count': (int,),  # noqa: E501
            'login_block_duration': (int,),  # noqa: E501
            'login_max_failed_attempts': (int,),  # noqa: E501
            'login_max_failed_attempts_window': (int,),  # noqa: E501
            'maintenance_mode_count': (int,),  # noqa: E501
            'management_over_v6_count': (int,),  # noqa: E501
            'microsoft_useg_vmm_ep_pd_count': (int,),  # noqa: E501
            'net_flow_count': (int,),  # noqa: E501
            'nir': (str,),  # noqa: E501
            'open_stack': (str,),  # noqa: E501
            'opflex_kubernetes_count': (int,),  # noqa: E501
            'ospf_count': (int,),  # noqa: E501
            'password_history_count': (int,),  # noqa: E501
            'password_strength_check': (str,),  # noqa: E501
            'password_strength_profile_count': (int,),  # noqa: E501
            'poe_count': (int,),  # noqa: E501
            'port_security_count': (int,),  # noqa: E501
            'qin_vni_tunnel_count': (int,),  # noqa: E501
            'qos_cong_count': (int,),  # noqa: E501
            'qos_pfc_pol_count': (int,),  # noqa: E501
            'realm_count': (int,),  # noqa: E501
            'record_type': (str,),  # noqa: E501
            'record_version': (str,),  # noqa: E501
            'remote_leaf_count': (int,),  # noqa: E501
            'scvmm_count': (int,),  # noqa: E501
            'shared_l3_out_count': (int,),  # noqa: E501
            'site_name': (str,),  # noqa: E501
            'smart_call_home': (str,),  # noqa: E501
            'smart_license': (NiatelemetrySmartLicense,),  # noqa: E501
            'snapshot_count': (int,),  # noqa: E501
            'snmp': (str,),  # noqa: E501
            'snmp_community_access_count': (int,),  # noqa: E501
            'snmp_group_count': (int,),  # noqa: E501
            'snmp_trap_count': (int,),  # noqa: E501
            'snmp_v3_count': (int,),  # noqa: E501
            'span_count': (int,),  # noqa: E501
            'span_dst_count': (int,),  # noqa: E501
            'span_src_count': (int,),  # noqa: E501
            'spine_count': (int,),  # noqa: E501
            'ssh_over_v6_count': (int,),  # noqa: E501
            'ssh_v2_count': (int,),  # noqa: E501
            'supervisor_module_count': (int,),  # noqa: E501
            'syslog_group_count': (int,),  # noqa: E501
            'syslog_over_v6_count': (int,),  # noqa: E501
            'system_controller_count': (int,),  # noqa: E501
            'tacacs_group_count': (int,),  # noqa: E501
            'tenant_count': (int,),  # noqa: E501
            'tier_two_leaf_count': (int,),  # noqa: E501
            'total_critical_faults': (int,),  # noqa: E501
            'twamp': (str,),  # noqa: E501
            'useg': (str,),  # noqa: E501
            'vm_ware_vds_count': (int,),  # noqa: E501
            'vmm_ctrlrp_count': (int,),  # noqa: E501
            'vmm_domp_count': (int,),  # noqa: E501
            'vmm_ep_pd_count': (int,),  # noqa: E501
            'vnsm_dev_count': (int,),  # noqa: E501
            'vpod_count': (int,),  # noqa: E501
            'webtoken_timeout_seconds': (int,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'aaa_ldap_provider_count': 'AaaLdapProviderCount',  # noqa: E501
        'aaa_radius_provider_count': 'AaaRadiusProviderCount',  # noqa: E501
        'aaa_tacacs_provider_count': 'AaaTacacsProviderCount',  # noqa: E501
        'apic_count': 'ApicCount',  # noqa: E501
        'apic_is_telnet_enabled': 'ApicIsTelnetEnabled',  # noqa: E501
        'apic_ntp_count': 'ApicNtpCount',  # noqa: E501
        'apic_snmp_community_count': 'ApicSnmpCommunityCount',  # noqa: E501
        'apic_sys_log_grp_count': 'ApicSysLogGrpCount',  # noqa: E501
        'apic_sys_log_src_count': 'ApicSysLogSrcCount',  # noqa: E501
        'app_center_count': 'AppCenterCount',  # noqa: E501
        'ave': 'Ave',  # noqa: E501
        'bd_count': 'BdCount',  # noqa: E501
        'callhome_smart_group_count': 'CallhomeSmartGroupCount',  # noqa: E501
        'cloud_sec_peer_count': 'CloudSecPeerCount',  # noqa: E501
        'comp_hv_count': 'CompHvCount',  # noqa: E501
        'config_exportp_count': 'ConfigExportpCount',  # noqa: E501
        'config_job_count': 'ConfigJobCount',  # noqa: E501
        'consistency_checker_app': 'ConsistencyCheckerApp',  # noqa: E501
        'contract_count': 'ContractCount',  # noqa: E501
        'dns_count': 'DnsCount',  # noqa: E501
        'eigrp_count': 'EigrpCount',  # noqa: E501
        'epg_count': 'EpgCount',  # noqa: E501
        'fabric_module_count': 'FabricModuleCount',  # noqa: E501
        'fabric_setupp_count': 'FabricSetuppCount',  # noqa: E501
        'fcoe_nport_count': 'FcoeNportCount',  # noqa: E501
        'fcoe_nport_dom_count': 'FcoeNportDomCount',  # noqa: E501
        'fcoe_nport_vlan_count': 'FcoeNportVlanCount',  # noqa: E501
        'fcoe_nport_vsan_count': 'FcoeNportVsanCount',  # noqa: E501
        'fv_sla_def_count': 'FvSlaDefCount',  # noqa: E501
        'hsrp_count': 'HsrpCount',  # noqa: E501
        'ibgp_count': 'IbgpCount',  # noqa: E501
        'igmp_access_list_count': 'IgmpAccessListCount',  # noqa: E501
        'igmp_snoop': 'IgmpSnoop',  # noqa: E501
        'ip_epg_count': 'IpEpgCount',  # noqa: E501
        'is_bgp_route_reflectors_feature_used': 'IsBgpRouteReflectorsFeatureUsed',  # noqa: E501
        'is_bridge_domains_feature_used': 'IsBridgeDomainsFeatureUsed',  # noqa: E501
        'is_common_local_user_name': 'IsCommonLocalUserName',  # noqa: E501
        'is_contracts_feature_used': 'IsContractsFeatureUsed',  # noqa: E501
        'is_epg_feature_used': 'IsEpgFeatureUsed',  # noqa: E501
        'is_filters_feature_used': 'IsFiltersFeatureUsed',  # noqa: E501
        'is_http_configured': 'IsHttpConfigured',  # noqa: E501
        'is_https_configured': 'IsHttpsConfigured',  # noqa: E501
        'is_ntp_feature_used': 'IsNtpFeatureUsed',  # noqa: E501
        'is_ptp_feature_used': 'IsPtpFeatureUsed',  # noqa: E501
        'is_synce_feature_used': 'IsSynceFeatureUsed',  # noqa: E501
        'is_tech_support_collected': 'IsTechSupportCollected',  # noqa: E501
        'is_tenants_feature_used': 'IsTenantsFeatureUsed',  # noqa: E501
        'is_vrfs_feature_used': 'IsVrfsFeatureUsed',  # noqa: E501
        'isis_count': 'IsisCount',  # noqa: E501
        'l2_multicast': 'L2Multicast',  # noqa: E501
        'latency_ptp_mode': 'LatencyPtpMode',  # noqa: E501
        'leaf_count': 'LeafCount',  # noqa: E501
        'local_username_count': 'LocalUsernameCount',  # noqa: E501
        'login_block_duration': 'LoginBlockDuration',  # noqa: E501
        'login_max_failed_attempts': 'LoginMaxFailedAttempts',  # noqa: E501
        'login_max_failed_attempts_window': 'LoginMaxFailedAttemptsWindow',  # noqa: E501
        'maintenance_mode_count': 'MaintenanceModeCount',  # noqa: E501
        'management_over_v6_count': 'ManagementOverV6Count',  # noqa: E501
        'microsoft_useg_vmm_ep_pd_count': 'MicrosoftUsegVmmEpPdCount',  # noqa: E501
        'net_flow_count': 'NetFlowCount',  # noqa: E501
        'nir': 'Nir',  # noqa: E501
        'open_stack': 'OpenStack',  # noqa: E501
        'opflex_kubernetes_count': 'OpflexKubernetesCount',  # noqa: E501
        'ospf_count': 'OspfCount',  # noqa: E501
        'password_history_count': 'PasswordHistoryCount',  # noqa: E501
        'password_strength_check': 'PasswordStrengthCheck',  # noqa: E501
        'password_strength_profile_count': 'PasswordStrengthProfileCount',  # noqa: E501
        'poe_count': 'PoeCount',  # noqa: E501
        'port_security_count': 'PortSecurityCount',  # noqa: E501
        'qin_vni_tunnel_count': 'QinVniTunnelCount',  # noqa: E501
        'qos_cong_count': 'QosCongCount',  # noqa: E501
        'qos_pfc_pol_count': 'QosPfcPolCount',  # noqa: E501
        'realm_count': 'RealmCount',  # noqa: E501
        'record_type': 'RecordType',  # noqa: E501
        'record_version': 'RecordVersion',  # noqa: E501
        'remote_leaf_count': 'RemoteLeafCount',  # noqa: E501
        'scvmm_count': 'ScvmmCount',  # noqa: E501
        'shared_l3_out_count': 'SharedL3OutCount',  # noqa: E501
        'site_name': 'SiteName',  # noqa: E501
        'smart_call_home': 'SmartCallHome',  # noqa: E501
        'smart_license': 'SmartLicense',  # noqa: E501
        'snapshot_count': 'SnapshotCount',  # noqa: E501
        'snmp': 'Snmp',  # noqa: E501
        'snmp_community_access_count': 'SnmpCommunityAccessCount',  # noqa: E501
        'snmp_group_count': 'SnmpGroupCount',  # noqa: E501
        'snmp_trap_count': 'SnmpTrapCount',  # noqa: E501
        'snmp_v3_count': 'SnmpV3Count',  # noqa: E501
        'span_count': 'SpanCount',  # noqa: E501
        'span_dst_count': 'SpanDstCount',  # noqa: E501
        'span_src_count': 'SpanSrcCount',  # noqa: E501
        'spine_count': 'SpineCount',  # noqa: E501
        'ssh_over_v6_count': 'SshOverV6Count',  # noqa: E501
        'ssh_v2_count': 'SshV2Count',  # noqa: E501
        'supervisor_module_count': 'SupervisorModuleCount',  # noqa: E501
        'syslog_group_count': 'SyslogGroupCount',  # noqa: E501
        'syslog_over_v6_count': 'SyslogOverV6Count',  # noqa: E501
        'system_controller_count': 'SystemControllerCount',  # noqa: E501
        'tacacs_group_count': 'TacacsGroupCount',  # noqa: E501
        'tenant_count': 'TenantCount',  # noqa: E501
        'tier_two_leaf_count': 'TierTwoLeafCount',  # noqa: E501
        'total_critical_faults': 'TotalCriticalFaults',  # noqa: E501
        'twamp': 'Twamp',  # noqa: E501
        'useg': 'Useg',  # noqa: E501
        'vm_ware_vds_count': 'VmWareVdsCount',  # noqa: E501
        'vmm_ctrlrp_count': 'VmmCtrlrpCount',  # noqa: E501
        'vmm_domp_count': 'VmmDompCount',  # noqa: E501
        'vmm_ep_pd_count': 'VmmEpPdCount',  # noqa: E501
        'vnsm_dev_count': 'VnsmDevCount',  # noqa: E501
        'vpod_count': 'VpodCount',  # noqa: E501
        'webtoken_timeout_seconds': 'WebtokenTimeoutSeconds',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """NiatelemetryNiaFeatureUsageAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "niatelemetry.NiaFeatureUsage", must be one of ["niatelemetry.NiaFeatureUsage", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "niatelemetry.NiaFeatureUsage", must be one of ["niatelemetry.NiaFeatureUsage", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            aaa_ldap_provider_count (int): Returns the total number of AAA Ldap Providers.. [optional]  # noqa: E501
            aaa_radius_provider_count (int): Returns the total number of AAA Radius Providers.. [optional]  # noqa: E501
            aaa_tacacs_provider_count (int): Returns the total number of AAA Tacacs Providers.. [optional]  # noqa: E501
            apic_count (int): Number of APIC controllers. This determines the value of controllers for the fabric.. [optional]  # noqa: E501
            apic_is_telnet_enabled (bool): Returns if telnet is enabled on APIC.. [optional]  # noqa: E501
            apic_ntp_count (int): Count of NTP servers configured on APIC.. [optional]  # noqa: E501
            apic_snmp_community_count (int): Number of SNMP communities configured on APIC.. [optional]  # noqa: E501
            apic_sys_log_grp_count (int): Number of logging groups configured on APIC.. [optional]  # noqa: E501
            apic_sys_log_src_count (int): Number of logging sources configured on APIC.. [optional]  # noqa: E501
            app_center_count (int): ACI APPs feature usage scale.. [optional]  # noqa: E501
            ave (str): AVE feature usage. This determines if ACI virtual edge feature is enabled or disabled.. [optional]  # noqa: E501
            bd_count (int): Number of BDs. This determines the total number of Broadcast Domains across the fabric.. [optional]  # noqa: E501
            callhome_smart_group_count (int): Number of call home smart monitoring policies on the fabric.. [optional]  # noqa: E501
            cloud_sec_peer_count (int): Number of Cloudsec SA peers.. [optional]  # noqa: E501
            comp_hv_count (int): Number of compute hypervisors on the fabric.. [optional]  # noqa: E501
            config_exportp_count (int): Number of system backup configure export policies on the fabric.. [optional]  # noqa: E501
            config_job_count (int): Number of system backup configure jobs on the fabric.. [optional]  # noqa: E501
            consistency_checker_app (str): Consistency checker application usage. This determines if the fabric has Consistency checker application installed.. [optional]  # noqa: E501
            contract_count (int): Number of contracts. This determines the total number of Contracts configured across the fabric.. [optional]  # noqa: E501
            dns_count (int): DNS feature usage. This determines the total number of DNS configurations across the fabric.. [optional]  # noqa: E501
            eigrp_count (int): Eigrp feature usage. This determines the total number of EIGRP sessions across the fabric.. [optional]  # noqa: E501
            epg_count (int): Number of End Point Groups. This determines the total number of End Point Groups across the fabric.. [optional]  # noqa: E501
            fabric_module_count (int): Returns the total number of fabric module slots.. [optional]  # noqa: E501
            fabric_setupp_count (int): Number of Multi-Pods per fabric.. [optional]  # noqa: E501
            fcoe_nport_count (int): Total number of FCoE N-Port for DOM, VSAn, and VLAN.. [optional]  # noqa: E501
            fcoe_nport_dom_count (int): Number of FCoE N-Port DOM.. [optional]  # noqa: E501
            fcoe_nport_vlan_count (int): Number of FCoE N-Port VLAN.. [optional]  # noqa: E501
            fcoe_nport_vsan_count (int): Number of FCoE N-Port VSAN.. [optional]  # noqa: E501
            fv_sla_def_count (int): Number of Internet Protocol Service Level Agreements Monitoring policy objects for object tracking.. [optional]  # noqa: E501
            hsrp_count (int): Hsrp feature usage. This determines the total number of HSRP sessions across the fabric.. [optional]  # noqa: E501
            ibgp_count (int): Ibgp feature usage. This determines the total number of BGP sessions across the fabric.. [optional]  # noqa: E501
            igmp_access_list_count (int): IGMP Access List feature usage. This determines the total number of IGMP access lists configured across the fabric.. [optional]  # noqa: E501
            igmp_snoop (str): IGMP Snooping feature usage. This determines if this feature is enabled or disabled.. [optional]  # noqa: E501
            ip_epg_count (int): Number of IP based End Point Groups. This determines the total number of IP End Point Groups across the fabric.. [optional]  # noqa: E501
            is_bgp_route_reflectors_feature_used (bool): BGP route reflector usage on APIC.. [optional]  # noqa: E501
            is_bridge_domains_feature_used (bool): Brodge domains feature usage on APIC controller.. [optional]  # noqa: E501
            is_common_local_user_name (bool): Returns value of isCommonLocalUserName field.. [optional]  # noqa: E501
            is_contracts_feature_used (bool): Contracts feature usage on APIC controller.. [optional]  # noqa: E501
            is_epg_feature_used (bool): EPG feature usage on APIC controller.. [optional]  # noqa: E501
            is_filters_feature_used (bool): Filters feature usage on APIC.. [optional]  # noqa: E501
            is_http_configured (bool): Returns if HTTP is configured.. [optional]  # noqa: E501
            is_https_configured (bool): Returns if HTTPS is configured.. [optional]  # noqa: E501
            is_ntp_feature_used (bool): NTP feature usage on APIC controller.. [optional]  # noqa: E501
            is_ptp_feature_used (bool): Ptp feature usage on APIC.. [optional]  # noqa: E501
            is_synce_feature_used (bool): Synce feature usage on APIC.. [optional]  # noqa: E501
            is_tech_support_collected (str): Status of techsupport collection.. [optional]  # noqa: E501
            is_tenants_feature_used (bool): Tenants feature usage on APIC.. [optional]  # noqa: E501
            is_vrfs_feature_used (bool): VRF feature usage on APIC controller.. [optional]  # noqa: E501
            isis_count (int): Isis feature usage. This determines the total number of ISIS sessions across the fabric.. [optional]  # noqa: E501
            l2_multicast (str): L2Multicast feature usage. This determines if this Layer 2 Multicast feature is being enabled / disabled on the fabric.. [optional]  # noqa: E501
            latency_ptp_mode (str): Returns the Latency ptp mode for the controller.. [optional]  # noqa: E501
            leaf_count (int): Number of Leafs. This determines the total number of Leaf switches in the fabric.. [optional]  # noqa: E501
            local_username_count (int): Returns count of local users.. [optional]  # noqa: E501
            login_block_duration (int): Returns login block duration value.. [optional]  # noqa: E501
            login_max_failed_attempts (int): Returns the maximum failed attempts on login.. [optional]  # noqa: E501
            login_max_failed_attempts_window (int): Returns the maximum failed attempt windows on login.. [optional]  # noqa: E501
            maintenance_mode_count (int): Maintenance Mode feature usage. This determines the number of switches that are currently in maintenance mode.. [optional]  # noqa: E501
            management_over_v6_count (int): Management over IPv6 feature usage. This determines the total number of IPv6 configurtaions in the fabric.. [optional]  # noqa: E501
            microsoft_useg_vmm_ep_pd_count (int): Number of Microsoft microsegmentation VmmEpPD objects. Ensures that Microsoft was configured.. [optional]  # noqa: E501
            net_flow_count (int): Number of Netflow monitor policies.. [optional]  # noqa: E501
            nir (str): NIR application usage. This determines if the fabric has NIR application installed.. [optional]  # noqa: E501
            open_stack (str): Open stack feature usage.. [optional]  # noqa: E501
            opflex_kubernetes_count (int): Opflex for Kubernetes feature usage. This determines the total number of VMM sessions of type kubernetes.. [optional]  # noqa: E501
            ospf_count (int): Ospf feature usage. This determines the total number of OSPF sessions across the fabric.. [optional]  # noqa: E501
            password_history_count (int): Returns count of passwords.. [optional]  # noqa: E501
            password_strength_check (str): Returns if the password is strong or not.. [optional]  # noqa: E501
            password_strength_profile_count (int): Returns the number of password strength profile.. [optional]  # noqa: E501
            poe_count (int): POE feature usage. This determines the total number of POE configurations across the fabric.. [optional]  # noqa: E501
            port_security_count (int): Number of objects with Port Security enabled. Non-Zero value indicates the object as enabled.. [optional]  # noqa: E501
            qin_vni_tunnel_count (int): QinVniTunnel feature usage. This determines if the qinVniTunnel feature is being used on the fabric and the scale of it.. [optional]  # noqa: E501
            qos_cong_count (int): Number of Quality Of Service congestion class.. [optional]  # noqa: E501
            qos_pfc_pol_count (int): Number of Quality Of Service class.. [optional]  # noqa: E501
            realm_count (int): Returns the value of count of realms.. [optional]  # noqa: E501
            record_type (str): Type of record DCNM / APIC / SE. This determines the type of platform where inventory was collected.. [optional]  # noqa: E501
            record_version (str): Version of record being pushed. This determines what was the API version for data available from the device.. [optional]  # noqa: E501
            remote_leaf_count (int): Number of remote Leafs. This determines the total number of remote leaf switches in the fabric.. [optional]  # noqa: E501
            scvmm_count (int): SCVMM feature usage. This determines the total number of SCVMM configurations in the fabric.. [optional]  # noqa: E501
            shared_l3_out_count (int): SharedL3Out feature usage. This determines the total number of Shared L3 out configured across the fabric.. [optional]  # noqa: E501
            site_name (str): The Site name represents an APIC cluster. Service Engine can onboard multiple APIC clusters / sites. There will be a feature usage object per site in Multi site scenario. In multi-site scenario the site name is available in all the requests being made.. [optional]  # noqa: E501
            smart_call_home (str): Smart callhome feature usage. This determines if this feature is being enabled or disabled.. [optional]  # noqa: E501
            smart_license (NiatelemetrySmartLicense): [optional]  # noqa: E501
            snapshot_count (int): Returns count of snapshots.. [optional]  # noqa: E501
            snmp (str): SNMP feature usage. This determines if this feature is enabled or disabled.. [optional]  # noqa: E501
            snmp_community_access_count (int): Returns count of SNMP Community Access.. [optional]  # noqa: E501
            snmp_group_count (int): Number of SNMP monitoring policies on the fabric.. [optional]  # noqa: E501
            snmp_trap_count (int): Returns count of SNMP trap.. [optional]  # noqa: E501
            snmp_v3_count (int): Returns count of SNMP V3 on the fabric.. [optional]  # noqa: E501
            span_count (int): Number of Span Sources and Destinations.. [optional]  # noqa: E501
            span_dst_count (int): Number of Span Destinations with valid state.. [optional]  # noqa: E501
            span_src_count (int): Number of Span Sources with valid state.. [optional]  # noqa: E501
            spine_count (int): Number of Spines. This determines the total number of spine switches in the fabric.. [optional]  # noqa: E501
            ssh_over_v6_count (int): Ssh over IPv6 feature usage. This determines the total number of IPv6 configurtaions in the fabric.. [optional]  # noqa: E501
            ssh_v2_count (int): Returns count of ssh V2 on the fabric.. [optional]  # noqa: E501
            supervisor_module_count (int): Returns the total number of supervisor module slots.. [optional]  # noqa: E501
            syslog_group_count (int): Number of syslog monitoring policies on the fabric.. [optional]  # noqa: E501
            syslog_over_v6_count (int): Syslog over IPv6 feature usage. This determines the total number of IPv6 configurtaions in the fabric.. [optional]  # noqa: E501
            system_controller_count (int): Returns the total number of system controller slots.. [optional]  # noqa: E501
            tacacs_group_count (int): Number of tacacs monitoring policies on the fabric.. [optional]  # noqa: E501
            tenant_count (int): Number of tenants. This determines the total number of tenants configured across the fabric.. [optional]  # noqa: E501
            tier_two_leaf_count (int): Number of tier 2 Leafs. This determines the total number of tier 2 Leaf switches in the fabric.. [optional]  # noqa: E501
            total_critical_faults (int): Returns the total number of critical faults.. [optional]  # noqa: E501
            twamp (str): TWAMP feature usage. This determines if this feature is enabled or disabled.. [optional]  # noqa: E501
            useg (str): VMM uSegmentation feature usage. This determines if microsegmentation feature is enabled or disabled.. [optional]  # noqa: E501
            vm_ware_vds_count (int): Number of objects with VmWare vCenter 6.5 support. Checks the controller revision value.. [optional]  # noqa: E501
            vmm_ctrlrp_count (int): Number of Virtual Machine Monitor controller policy objects for VMware vCenter.. [optional]  # noqa: E501
            vmm_domp_count (int): Number of Virtual Machine Monitor domain policy model objects for VMware vCenter.. [optional]  # noqa: E501
            vmm_ep_pd_count (int): Microsegmentation Distributed Virtual Switch feature usage. Gets the number of objects associated to VMware vCenter.. [optional]  # noqa: E501
            vnsm_dev_count (int): Number of objects with L4-L7 Device Package Import enabled. Checks for the vendor and the model.. [optional]  # noqa: E501
            vpod_count (int): Virtual pod feature usage. This determines the total number of virtual POD configurations in the fabrics.. [optional]  # noqa: E501
            webtoken_timeout_seconds (int): Timeout for web token in seconds.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "niatelemetry.NiaFeatureUsage")
        object_type = kwargs.get('object_type', "niatelemetry.NiaFeatureUsage")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """NiatelemetryNiaFeatureUsageAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "niatelemetry.NiaFeatureUsage", must be one of ["niatelemetry.NiaFeatureUsage", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "niatelemetry.NiaFeatureUsage", must be one of ["niatelemetry.NiaFeatureUsage", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            aaa_ldap_provider_count (int): Returns the total number of AAA Ldap Providers.. [optional]  # noqa: E501
            aaa_radius_provider_count (int): Returns the total number of AAA Radius Providers.. [optional]  # noqa: E501
            aaa_tacacs_provider_count (int): Returns the total number of AAA Tacacs Providers.. [optional]  # noqa: E501
            apic_count (int): Number of APIC controllers. This determines the value of controllers for the fabric.. [optional]  # noqa: E501
            apic_is_telnet_enabled (bool): Returns if telnet is enabled on APIC.. [optional]  # noqa: E501
            apic_ntp_count (int): Count of NTP servers configured on APIC.. [optional]  # noqa: E501
            apic_snmp_community_count (int): Number of SNMP communities configured on APIC.. [optional]  # noqa: E501
            apic_sys_log_grp_count (int): Number of logging groups configured on APIC.. [optional]  # noqa: E501
            apic_sys_log_src_count (int): Number of logging sources configured on APIC.. [optional]  # noqa: E501
            app_center_count (int): ACI APPs feature usage scale.. [optional]  # noqa: E501
            ave (str): AVE feature usage. This determines if ACI virtual edge feature is enabled or disabled.. [optional]  # noqa: E501
            bd_count (int): Number of BDs. This determines the total number of Broadcast Domains across the fabric.. [optional]  # noqa: E501
            callhome_smart_group_count (int): Number of call home smart monitoring policies on the fabric.. [optional]  # noqa: E501
            cloud_sec_peer_count (int): Number of Cloudsec SA peers.. [optional]  # noqa: E501
            comp_hv_count (int): Number of compute hypervisors on the fabric.. [optional]  # noqa: E501
            config_exportp_count (int): Number of system backup configure export policies on the fabric.. [optional]  # noqa: E501
            config_job_count (int): Number of system backup configure jobs on the fabric.. [optional]  # noqa: E501
            consistency_checker_app (str): Consistency checker application usage. This determines if the fabric has Consistency checker application installed.. [optional]  # noqa: E501
            contract_count (int): Number of contracts. This determines the total number of Contracts configured across the fabric.. [optional]  # noqa: E501
            dns_count (int): DNS feature usage. This determines the total number of DNS configurations across the fabric.. [optional]  # noqa: E501
            eigrp_count (int): Eigrp feature usage. This determines the total number of EIGRP sessions across the fabric.. [optional]  # noqa: E501
            epg_count (int): Number of End Point Groups. This determines the total number of End Point Groups across the fabric.. [optional]  # noqa: E501
            fabric_module_count (int): Returns the total number of fabric module slots.. [optional]  # noqa: E501
            fabric_setupp_count (int): Number of Multi-Pods per fabric.. [optional]  # noqa: E501
            fcoe_nport_count (int): Total number of FCoE N-Port for DOM, VSAn, and VLAN.. [optional]  # noqa: E501
            fcoe_nport_dom_count (int): Number of FCoE N-Port DOM.. [optional]  # noqa: E501
            fcoe_nport_vlan_count (int): Number of FCoE N-Port VLAN.. [optional]  # noqa: E501
            fcoe_nport_vsan_count (int): Number of FCoE N-Port VSAN.. [optional]  # noqa: E501
            fv_sla_def_count (int): Number of Internet Protocol Service Level Agreements Monitoring policy objects for object tracking.. [optional]  # noqa: E501
            hsrp_count (int): Hsrp feature usage. This determines the total number of HSRP sessions across the fabric.. [optional]  # noqa: E501
            ibgp_count (int): Ibgp feature usage. This determines the total number of BGP sessions across the fabric.. [optional]  # noqa: E501
            igmp_access_list_count (int): IGMP Access List feature usage. This determines the total number of IGMP access lists configured across the fabric.. [optional]  # noqa: E501
            igmp_snoop (str): IGMP Snooping feature usage. This determines if this feature is enabled or disabled.. [optional]  # noqa: E501
            ip_epg_count (int): Number of IP based End Point Groups. This determines the total number of IP End Point Groups across the fabric.. [optional]  # noqa: E501
            is_bgp_route_reflectors_feature_used (bool): BGP route reflector usage on APIC.. [optional]  # noqa: E501
            is_bridge_domains_feature_used (bool): Brodge domains feature usage on APIC controller.. [optional]  # noqa: E501
            is_common_local_user_name (bool): Returns value of isCommonLocalUserName field.. [optional]  # noqa: E501
            is_contracts_feature_used (bool): Contracts feature usage on APIC controller.. [optional]  # noqa: E501
            is_epg_feature_used (bool): EPG feature usage on APIC controller.. [optional]  # noqa: E501
            is_filters_feature_used (bool): Filters feature usage on APIC.. [optional]  # noqa: E501
            is_http_configured (bool): Returns if HTTP is configured.. [optional]  # noqa: E501
            is_https_configured (bool): Returns if HTTPS is configured.. [optional]  # noqa: E501
            is_ntp_feature_used (bool): NTP feature usage on APIC controller.. [optional]  # noqa: E501
            is_ptp_feature_used (bool): Ptp feature usage on APIC.. [optional]  # noqa: E501
            is_synce_feature_used (bool): Synce feature usage on APIC.. [optional]  # noqa: E501
            is_tech_support_collected (str): Status of techsupport collection.. [optional]  # noqa: E501
            is_tenants_feature_used (bool): Tenants feature usage on APIC.. [optional]  # noqa: E501
            is_vrfs_feature_used (bool): VRF feature usage on APIC controller.. [optional]  # noqa: E501
            isis_count (int): Isis feature usage. This determines the total number of ISIS sessions across the fabric.. [optional]  # noqa: E501
            l2_multicast (str): L2Multicast feature usage. This determines if this Layer 2 Multicast feature is being enabled / disabled on the fabric.. [optional]  # noqa: E501
            latency_ptp_mode (str): Returns the Latency ptp mode for the controller.. [optional]  # noqa: E501
            leaf_count (int): Number of Leafs. This determines the total number of Leaf switches in the fabric.. [optional]  # noqa: E501
            local_username_count (int): Returns count of local users.. [optional]  # noqa: E501
            login_block_duration (int): Returns login block duration value.. [optional]  # noqa: E501
            login_max_failed_attempts (int): Returns the maximum failed attempts on login.. [optional]  # noqa: E501
            login_max_failed_attempts_window (int): Returns the maximum failed attempt windows on login.. [optional]  # noqa: E501
            maintenance_mode_count (int): Maintenance Mode feature usage. This determines the number of switches that are currently in maintenance mode.. [optional]  # noqa: E501
            management_over_v6_count (int): Management over IPv6 feature usage. This determines the total number of IPv6 configurtaions in the fabric.. [optional]  # noqa: E501
            microsoft_useg_vmm_ep_pd_count (int): Number of Microsoft microsegmentation VmmEpPD objects. Ensures that Microsoft was configured.. [optional]  # noqa: E501
            net_flow_count (int): Number of Netflow monitor policies.. [optional]  # noqa: E501
            nir (str): NIR application usage. This determines if the fabric has NIR application installed.. [optional]  # noqa: E501
            open_stack (str): Open stack feature usage.. [optional]  # noqa: E501
            opflex_kubernetes_count (int): Opflex for Kubernetes feature usage. This determines the total number of VMM sessions of type kubernetes.. [optional]  # noqa: E501
            ospf_count (int): Ospf feature usage. This determines the total number of OSPF sessions across the fabric.. [optional]  # noqa: E501
            password_history_count (int): Returns count of passwords.. [optional]  # noqa: E501
            password_strength_check (str): Returns if the password is strong or not.. [optional]  # noqa: E501
            password_strength_profile_count (int): Returns the number of password strength profile.. [optional]  # noqa: E501
            poe_count (int): POE feature usage. This determines the total number of POE configurations across the fabric.. [optional]  # noqa: E501
            port_security_count (int): Number of objects with Port Security enabled. Non-Zero value indicates the object as enabled.. [optional]  # noqa: E501
            qin_vni_tunnel_count (int): QinVniTunnel feature usage. This determines if the qinVniTunnel feature is being used on the fabric and the scale of it.. [optional]  # noqa: E501
            qos_cong_count (int): Number of Quality Of Service congestion class.. [optional]  # noqa: E501
            qos_pfc_pol_count (int): Number of Quality Of Service class.. [optional]  # noqa: E501
            realm_count (int): Returns the value of count of realms.. [optional]  # noqa: E501
            record_type (str): Type of record DCNM / APIC / SE. This determines the type of platform where inventory was collected.. [optional]  # noqa: E501
            record_version (str): Version of record being pushed. This determines what was the API version for data available from the device.. [optional]  # noqa: E501
            remote_leaf_count (int): Number of remote Leafs. This determines the total number of remote leaf switches in the fabric.. [optional]  # noqa: E501
            scvmm_count (int): SCVMM feature usage. This determines the total number of SCVMM configurations in the fabric.. [optional]  # noqa: E501
            shared_l3_out_count (int): SharedL3Out feature usage. This determines the total number of Shared L3 out configured across the fabric.. [optional]  # noqa: E501
            site_name (str): The Site name represents an APIC cluster. Service Engine can onboard multiple APIC clusters / sites. There will be a feature usage object per site in Multi site scenario. In multi-site scenario the site name is available in all the requests being made.. [optional]  # noqa: E501
            smart_call_home (str): Smart callhome feature usage. This determines if this feature is being enabled or disabled.. [optional]  # noqa: E501
            smart_license (NiatelemetrySmartLicense): [optional]  # noqa: E501
            snapshot_count (int): Returns count of snapshots.. [optional]  # noqa: E501
            snmp (str): SNMP feature usage. This determines if this feature is enabled or disabled.. [optional]  # noqa: E501
            snmp_community_access_count (int): Returns count of SNMP Community Access.. [optional]  # noqa: E501
            snmp_group_count (int): Number of SNMP monitoring policies on the fabric.. [optional]  # noqa: E501
            snmp_trap_count (int): Returns count of SNMP trap.. [optional]  # noqa: E501
            snmp_v3_count (int): Returns count of SNMP V3 on the fabric.. [optional]  # noqa: E501
            span_count (int): Number of Span Sources and Destinations.. [optional]  # noqa: E501
            span_dst_count (int): Number of Span Destinations with valid state.. [optional]  # noqa: E501
            span_src_count (int): Number of Span Sources with valid state.. [optional]  # noqa: E501
            spine_count (int): Number of Spines. This determines the total number of spine switches in the fabric.. [optional]  # noqa: E501
            ssh_over_v6_count (int): Ssh over IPv6 feature usage. This determines the total number of IPv6 configurtaions in the fabric.. [optional]  # noqa: E501
            ssh_v2_count (int): Returns count of ssh V2 on the fabric.. [optional]  # noqa: E501
            supervisor_module_count (int): Returns the total number of supervisor module slots.. [optional]  # noqa: E501
            syslog_group_count (int): Number of syslog monitoring policies on the fabric.. [optional]  # noqa: E501
            syslog_over_v6_count (int): Syslog over IPv6 feature usage. This determines the total number of IPv6 configurtaions in the fabric.. [optional]  # noqa: E501
            system_controller_count (int): Returns the total number of system controller slots.. [optional]  # noqa: E501
            tacacs_group_count (int): Number of tacacs monitoring policies on the fabric.. [optional]  # noqa: E501
            tenant_count (int): Number of tenants. This determines the total number of tenants configured across the fabric.. [optional]  # noqa: E501
            tier_two_leaf_count (int): Number of tier 2 Leafs. This determines the total number of tier 2 Leaf switches in the fabric.. [optional]  # noqa: E501
            total_critical_faults (int): Returns the total number of critical faults.. [optional]  # noqa: E501
            twamp (str): TWAMP feature usage. This determines if this feature is enabled or disabled.. [optional]  # noqa: E501
            useg (str): VMM uSegmentation feature usage. This determines if microsegmentation feature is enabled or disabled.. [optional]  # noqa: E501
            vm_ware_vds_count (int): Number of objects with VmWare vCenter 6.5 support. Checks the controller revision value.. [optional]  # noqa: E501
            vmm_ctrlrp_count (int): Number of Virtual Machine Monitor controller policy objects for VMware vCenter.. [optional]  # noqa: E501
            vmm_domp_count (int): Number of Virtual Machine Monitor domain policy model objects for VMware vCenter.. [optional]  # noqa: E501
            vmm_ep_pd_count (int): Microsegmentation Distributed Virtual Switch feature usage. Gets the number of objects associated to VMware vCenter.. [optional]  # noqa: E501
            vnsm_dev_count (int): Number of objects with L4-L7 Device Package Import enabled. Checks for the vendor and the model.. [optional]  # noqa: E501
            vpod_count (int): Virtual pod feature usage. This determines the total number of virtual POD configurations in the fabrics.. [optional]  # noqa: E501
            webtoken_timeout_seconds (int): Timeout for web token in seconds.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "niatelemetry.NiaFeatureUsage")
        object_type = kwargs.get('object_type', "niatelemetry.NiaFeatureUsage")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
