"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-6207
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.adapter_ext_eth_interface import AdapterExtEthInterface
    from intersight.model.adapter_host_eth_interface import AdapterHostEthInterface
    from intersight.model.adapter_host_fc_interface import AdapterHostFcInterface
    from intersight.model.adapter_host_iscsi_interface import AdapterHostIscsiInterface
    from intersight.model.adapter_unit import AdapterUnit
    from intersight.model.adapter_unit_expander import AdapterUnitExpander
    from intersight.model.bios_boot_mode import BiosBootMode
    from intersight.model.bios_token_settings import BiosTokenSettings
    from intersight.model.bios_unit import BiosUnit
    from intersight.model.bios_vf_select_memory_ras_configuration import BiosVfSelectMemoryRasConfiguration
    from intersight.model.boot_cdd_device import BootCddDevice
    from intersight.model.boot_configured_device import BootConfiguredDevice
    from intersight.model.boot_device_boot_mode import BootDeviceBootMode
    from intersight.model.boot_device_boot_security import BootDeviceBootSecurity
    from intersight.model.boot_hdd_device import BootHddDevice
    from intersight.model.boot_iscsi_device import BootIscsiDevice
    from intersight.model.boot_nvme_device import BootNvmeDevice
    from intersight.model.boot_pch_storage_device import BootPchStorageDevice
    from intersight.model.boot_pxe_device import BootPxeDevice
    from intersight.model.boot_san_device import BootSanDevice
    from intersight.model.boot_sd_device import BootSdDevice
    from intersight.model.boot_uefi_shell_device import BootUefiShellDevice
    from intersight.model.boot_usb_device import BootUsbDevice
    from intersight.model.boot_vmedia_device import BootVmediaDevice
    from intersight.model.compute_blade import ComputeBlade
    from intersight.model.compute_board import ComputeBoard
    from intersight.model.compute_mapping import ComputeMapping
    from intersight.model.compute_physical import ComputePhysical
    from intersight.model.compute_rack_unit import ComputeRackUnit
    from intersight.model.compute_server_setting import ComputeServerSetting
    from intersight.model.compute_vmedia import ComputeVmedia
    from intersight.model.console_console_config import ConsoleConsoleConfig
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_abstract_device import EquipmentAbstractDevice
    from intersight.model.equipment_base import EquipmentBase
    from intersight.model.equipment_chassis import EquipmentChassis
    from intersight.model.equipment_expander_module import EquipmentExpanderModule
    from intersight.model.equipment_fan import EquipmentFan
    from intersight.model.equipment_fan_control import EquipmentFanControl
    from intersight.model.equipment_fan_module import EquipmentFanModule
    from intersight.model.equipment_fex import EquipmentFex
    from intersight.model.equipment_fru import EquipmentFru
    from intersight.model.equipment_io_card import EquipmentIoCard
    from intersight.model.equipment_io_card_base import EquipmentIoCardBase
    from intersight.model.equipment_io_expander import EquipmentIoExpander
    from intersight.model.equipment_locator_led import EquipmentLocatorLed
    from intersight.model.equipment_psu import EquipmentPsu
    from intersight.model.equipment_psu_control import EquipmentPsuControl
    from intersight.model.equipment_rack_enclosure import EquipmentRackEnclosure
    from intersight.model.equipment_rack_enclosure_slot import EquipmentRackEnclosureSlot
    from intersight.model.equipment_shared_io_module import EquipmentSharedIoModule
    from intersight.model.equipment_slot import EquipmentSlot
    from intersight.model.equipment_switch_card import EquipmentSwitchCard
    from intersight.model.equipment_system_io_controller import EquipmentSystemIoController
    from intersight.model.equipment_tpm import EquipmentTpm
    from intersight.model.equipment_transceiver import EquipmentTransceiver
    from intersight.model.ether_host_port import EtherHostPort
    from intersight.model.ether_network_port import EtherNetworkPort
    from intersight.model.ether_physical_port import EtherPhysicalPort
    from intersight.model.ether_physical_port_base import EtherPhysicalPortBase
    from intersight.model.ether_port_channel import EtherPortChannel
    from intersight.model.fault_instance import FaultInstance
    from intersight.model.fc_physical_port import FcPhysicalPort
    from intersight.model.fc_port_channel import FcPortChannel
    from intersight.model.firmware_running_firmware import FirmwareRunningFirmware
    from intersight.model.graphics_card import GraphicsCard
    from intersight.model.graphics_controller import GraphicsController
    from intersight.model.inventory_base_all_of import InventoryBaseAllOf
    from intersight.model.inventory_generic_inventory import InventoryGenericInventory
    from intersight.model.inventory_generic_inventory_holder import InventoryGenericInventoryHolder
    from intersight.model.inventory_interface import InventoryInterface
    from intersight.model.ls_service_profile import LsServiceProfile
    from intersight.model.management_controller import ManagementController
    from intersight.model.management_entity import ManagementEntity
    from intersight.model.management_interface import ManagementInterface
    from intersight.model.memory_abstract_unit import MemoryAbstractUnit
    from intersight.model.memory_array import MemoryArray
    from intersight.model.memory_persistent_memory_config_result import MemoryPersistentMemoryConfigResult
    from intersight.model.memory_persistent_memory_configuration import MemoryPersistentMemoryConfiguration
    from intersight.model.memory_persistent_memory_namespace import MemoryPersistentMemoryNamespace
    from intersight.model.memory_persistent_memory_namespace_config_result import MemoryPersistentMemoryNamespaceConfigResult
    from intersight.model.memory_persistent_memory_region import MemoryPersistentMemoryRegion
    from intersight.model.memory_persistent_memory_unit import MemoryPersistentMemoryUnit
    from intersight.model.memory_unit import MemoryUnit
    from intersight.model.mo_base_mo import MoBaseMo
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.network_element import NetworkElement
    from intersight.model.network_fc_zone_info import NetworkFcZoneInfo
    from intersight.model.network_feature_control import NetworkFeatureControl
    from intersight.model.network_interface_list import NetworkInterfaceList
    from intersight.model.network_license_file import NetworkLicenseFile
    from intersight.model.network_supervisor_card import NetworkSupervisorCard
    from intersight.model.network_vlan_port_info import NetworkVlanPortInfo
    from intersight.model.network_vrf import NetworkVrf
    from intersight.model.pci_coprocessor_card import PciCoprocessorCard
    from intersight.model.pci_device import PciDevice
    from intersight.model.pci_link import PciLink
    from intersight.model.pci_switch import PciSwitch
    from intersight.model.port_group import PortGroup
    from intersight.model.port_interface_base import PortInterfaceBase
    from intersight.model.port_mac_binding import PortMacBinding
    from intersight.model.port_physical import PortPhysical
    from intersight.model.port_sub_group import PortSubGroup
    from intersight.model.processor_unit import ProcessorUnit
    from intersight.model.rack_unit_personality import RackUnitPersonality
    from intersight.model.security_unit import SecurityUnit
    from intersight.model.storage_base_array import StorageBaseArray
    from intersight.model.storage_base_array_controller import StorageBaseArrayController
    from intersight.model.storage_base_array_disk import StorageBaseArrayDisk
    from intersight.model.storage_controller import StorageController
    from intersight.model.storage_disk_group import StorageDiskGroup
    from intersight.model.storage_disk_slot import StorageDiskSlot
    from intersight.model.storage_enclosure import StorageEnclosure
    from intersight.model.storage_enclosure_disk import StorageEnclosureDisk
    from intersight.model.storage_enclosure_disk_slot_ep import StorageEnclosureDiskSlotEp
    from intersight.model.storage_flex_flash_controller import StorageFlexFlashController
    from intersight.model.storage_flex_flash_controller_props import StorageFlexFlashControllerProps
    from intersight.model.storage_flex_flash_physical_drive import StorageFlexFlashPhysicalDrive
    from intersight.model.storage_flex_flash_virtual_drive import StorageFlexFlashVirtualDrive
    from intersight.model.storage_flex_util_controller import StorageFlexUtilController
    from intersight.model.storage_flex_util_physical_drive import StorageFlexUtilPhysicalDrive
    from intersight.model.storage_flex_util_virtual_drive import StorageFlexUtilVirtualDrive
    from intersight.model.storage_hitachi_array import StorageHitachiArray
    from intersight.model.storage_hitachi_controller import StorageHitachiController
    from intersight.model.storage_hitachi_disk import StorageHitachiDisk
    from intersight.model.storage_item import StorageItem
    from intersight.model.storage_net_app_base_disk import StorageNetAppBaseDisk
    from intersight.model.storage_net_app_cluster import StorageNetAppCluster
    from intersight.model.storage_net_app_node import StorageNetAppNode
    from intersight.model.storage_physical_disk import StoragePhysicalDisk
    from intersight.model.storage_physical_disk_extension import StoragePhysicalDiskExtension
    from intersight.model.storage_physical_disk_usage import StoragePhysicalDiskUsage
    from intersight.model.storage_pure_array import StoragePureArray
    from intersight.model.storage_pure_controller import StoragePureController
    from intersight.model.storage_pure_disk import StoragePureDisk
    from intersight.model.storage_sas_expander import StorageSasExpander
    from intersight.model.storage_sas_port import StorageSasPort
    from intersight.model.storage_span import StorageSpan
    from intersight.model.storage_vd_member_ep import StorageVdMemberEp
    from intersight.model.storage_virtual_drive import StorageVirtualDrive
    from intersight.model.storage_virtual_drive_container import StorageVirtualDriveContainer
    from intersight.model.storage_virtual_drive_extension import StorageVirtualDriveExtension
    from intersight.model.top_system import TopSystem
    globals()['AdapterExtEthInterface'] = AdapterExtEthInterface
    globals()['AdapterHostEthInterface'] = AdapterHostEthInterface
    globals()['AdapterHostFcInterface'] = AdapterHostFcInterface
    globals()['AdapterHostIscsiInterface'] = AdapterHostIscsiInterface
    globals()['AdapterUnit'] = AdapterUnit
    globals()['AdapterUnitExpander'] = AdapterUnitExpander
    globals()['BiosBootMode'] = BiosBootMode
    globals()['BiosTokenSettings'] = BiosTokenSettings
    globals()['BiosUnit'] = BiosUnit
    globals()['BiosVfSelectMemoryRasConfiguration'] = BiosVfSelectMemoryRasConfiguration
    globals()['BootCddDevice'] = BootCddDevice
    globals()['BootConfiguredDevice'] = BootConfiguredDevice
    globals()['BootDeviceBootMode'] = BootDeviceBootMode
    globals()['BootDeviceBootSecurity'] = BootDeviceBootSecurity
    globals()['BootHddDevice'] = BootHddDevice
    globals()['BootIscsiDevice'] = BootIscsiDevice
    globals()['BootNvmeDevice'] = BootNvmeDevice
    globals()['BootPchStorageDevice'] = BootPchStorageDevice
    globals()['BootPxeDevice'] = BootPxeDevice
    globals()['BootSanDevice'] = BootSanDevice
    globals()['BootSdDevice'] = BootSdDevice
    globals()['BootUefiShellDevice'] = BootUefiShellDevice
    globals()['BootUsbDevice'] = BootUsbDevice
    globals()['BootVmediaDevice'] = BootVmediaDevice
    globals()['ComputeBlade'] = ComputeBlade
    globals()['ComputeBoard'] = ComputeBoard
    globals()['ComputeMapping'] = ComputeMapping
    globals()['ComputePhysical'] = ComputePhysical
    globals()['ComputeRackUnit'] = ComputeRackUnit
    globals()['ComputeServerSetting'] = ComputeServerSetting
    globals()['ComputeVmedia'] = ComputeVmedia
    globals()['ConsoleConsoleConfig'] = ConsoleConsoleConfig
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentAbstractDevice'] = EquipmentAbstractDevice
    globals()['EquipmentBase'] = EquipmentBase
    globals()['EquipmentChassis'] = EquipmentChassis
    globals()['EquipmentExpanderModule'] = EquipmentExpanderModule
    globals()['EquipmentFan'] = EquipmentFan
    globals()['EquipmentFanControl'] = EquipmentFanControl
    globals()['EquipmentFanModule'] = EquipmentFanModule
    globals()['EquipmentFex'] = EquipmentFex
    globals()['EquipmentFru'] = EquipmentFru
    globals()['EquipmentIoCard'] = EquipmentIoCard
    globals()['EquipmentIoCardBase'] = EquipmentIoCardBase
    globals()['EquipmentIoExpander'] = EquipmentIoExpander
    globals()['EquipmentLocatorLed'] = EquipmentLocatorLed
    globals()['EquipmentPsu'] = EquipmentPsu
    globals()['EquipmentPsuControl'] = EquipmentPsuControl
    globals()['EquipmentRackEnclosure'] = EquipmentRackEnclosure
    globals()['EquipmentRackEnclosureSlot'] = EquipmentRackEnclosureSlot
    globals()['EquipmentSharedIoModule'] = EquipmentSharedIoModule
    globals()['EquipmentSlot'] = EquipmentSlot
    globals()['EquipmentSwitchCard'] = EquipmentSwitchCard
    globals()['EquipmentSystemIoController'] = EquipmentSystemIoController
    globals()['EquipmentTpm'] = EquipmentTpm
    globals()['EquipmentTransceiver'] = EquipmentTransceiver
    globals()['EtherHostPort'] = EtherHostPort
    globals()['EtherNetworkPort'] = EtherNetworkPort
    globals()['EtherPhysicalPort'] = EtherPhysicalPort
    globals()['EtherPhysicalPortBase'] = EtherPhysicalPortBase
    globals()['EtherPortChannel'] = EtherPortChannel
    globals()['FaultInstance'] = FaultInstance
    globals()['FcPhysicalPort'] = FcPhysicalPort
    globals()['FcPortChannel'] = FcPortChannel
    globals()['FirmwareRunningFirmware'] = FirmwareRunningFirmware
    globals()['GraphicsCard'] = GraphicsCard
    globals()['GraphicsController'] = GraphicsController
    globals()['InventoryBaseAllOf'] = InventoryBaseAllOf
    globals()['InventoryGenericInventory'] = InventoryGenericInventory
    globals()['InventoryGenericInventoryHolder'] = InventoryGenericInventoryHolder
    globals()['InventoryInterface'] = InventoryInterface
    globals()['LsServiceProfile'] = LsServiceProfile
    globals()['ManagementController'] = ManagementController
    globals()['ManagementEntity'] = ManagementEntity
    globals()['ManagementInterface'] = ManagementInterface
    globals()['MemoryAbstractUnit'] = MemoryAbstractUnit
    globals()['MemoryArray'] = MemoryArray
    globals()['MemoryPersistentMemoryConfigResult'] = MemoryPersistentMemoryConfigResult
    globals()['MemoryPersistentMemoryConfiguration'] = MemoryPersistentMemoryConfiguration
    globals()['MemoryPersistentMemoryNamespace'] = MemoryPersistentMemoryNamespace
    globals()['MemoryPersistentMemoryNamespaceConfigResult'] = MemoryPersistentMemoryNamespaceConfigResult
    globals()['MemoryPersistentMemoryRegion'] = MemoryPersistentMemoryRegion
    globals()['MemoryPersistentMemoryUnit'] = MemoryPersistentMemoryUnit
    globals()['MemoryUnit'] = MemoryUnit
    globals()['MoBaseMo'] = MoBaseMo
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['NetworkElement'] = NetworkElement
    globals()['NetworkFcZoneInfo'] = NetworkFcZoneInfo
    globals()['NetworkFeatureControl'] = NetworkFeatureControl
    globals()['NetworkInterfaceList'] = NetworkInterfaceList
    globals()['NetworkLicenseFile'] = NetworkLicenseFile
    globals()['NetworkSupervisorCard'] = NetworkSupervisorCard
    globals()['NetworkVlanPortInfo'] = NetworkVlanPortInfo
    globals()['NetworkVrf'] = NetworkVrf
    globals()['PciCoprocessorCard'] = PciCoprocessorCard
    globals()['PciDevice'] = PciDevice
    globals()['PciLink'] = PciLink
    globals()['PciSwitch'] = PciSwitch
    globals()['PortGroup'] = PortGroup
    globals()['PortInterfaceBase'] = PortInterfaceBase
    globals()['PortMacBinding'] = PortMacBinding
    globals()['PortPhysical'] = PortPhysical
    globals()['PortSubGroup'] = PortSubGroup
    globals()['ProcessorUnit'] = ProcessorUnit
    globals()['RackUnitPersonality'] = RackUnitPersonality
    globals()['SecurityUnit'] = SecurityUnit
    globals()['StorageBaseArray'] = StorageBaseArray
    globals()['StorageBaseArrayController'] = StorageBaseArrayController
    globals()['StorageBaseArrayDisk'] = StorageBaseArrayDisk
    globals()['StorageController'] = StorageController
    globals()['StorageDiskGroup'] = StorageDiskGroup
    globals()['StorageDiskSlot'] = StorageDiskSlot
    globals()['StorageEnclosure'] = StorageEnclosure
    globals()['StorageEnclosureDisk'] = StorageEnclosureDisk
    globals()['StorageEnclosureDiskSlotEp'] = StorageEnclosureDiskSlotEp
    globals()['StorageFlexFlashController'] = StorageFlexFlashController
    globals()['StorageFlexFlashControllerProps'] = StorageFlexFlashControllerProps
    globals()['StorageFlexFlashPhysicalDrive'] = StorageFlexFlashPhysicalDrive
    globals()['StorageFlexFlashVirtualDrive'] = StorageFlexFlashVirtualDrive
    globals()['StorageFlexUtilController'] = StorageFlexUtilController
    globals()['StorageFlexUtilPhysicalDrive'] = StorageFlexUtilPhysicalDrive
    globals()['StorageFlexUtilVirtualDrive'] = StorageFlexUtilVirtualDrive
    globals()['StorageHitachiArray'] = StorageHitachiArray
    globals()['StorageHitachiController'] = StorageHitachiController
    globals()['StorageHitachiDisk'] = StorageHitachiDisk
    globals()['StorageItem'] = StorageItem
    globals()['StorageNetAppBaseDisk'] = StorageNetAppBaseDisk
    globals()['StorageNetAppCluster'] = StorageNetAppCluster
    globals()['StorageNetAppNode'] = StorageNetAppNode
    globals()['StoragePhysicalDisk'] = StoragePhysicalDisk
    globals()['StoragePhysicalDiskExtension'] = StoragePhysicalDiskExtension
    globals()['StoragePhysicalDiskUsage'] = StoragePhysicalDiskUsage
    globals()['StoragePureArray'] = StoragePureArray
    globals()['StoragePureController'] = StoragePureController
    globals()['StoragePureDisk'] = StoragePureDisk
    globals()['StorageSasExpander'] = StorageSasExpander
    globals()['StorageSasPort'] = StorageSasPort
    globals()['StorageSpan'] = StorageSpan
    globals()['StorageVdMemberEp'] = StorageVdMemberEp
    globals()['StorageVirtualDrive'] = StorageVirtualDrive
    globals()['StorageVirtualDriveContainer'] = StorageVirtualDriveContainer
    globals()['StorageVirtualDriveExtension'] = StorageVirtualDriveExtension
    globals()['TopSystem'] = TopSystem


class InventoryBase(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ADAPTER.EXTETHINTERFACE': "adapter.ExtEthInterface",
            'ADAPTER.HOSTETHINTERFACE': "adapter.HostEthInterface",
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'BIOS.BOOTMODE': "bios.BootMode",
            'BIOS.TOKENSETTINGS': "bios.TokenSettings",
            'BIOS.UNIT': "bios.Unit",
            'BIOS.VFSELECTMEMORYRASCONFIGURATION': "bios.VfSelectMemoryRasConfiguration",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.DEVICEBOOTMODE': "boot.DeviceBootMode",
            'BOOT.DEVICEBOOTSECURITY': "boot.DeviceBootSecurity",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.MAPPING': "compute.Mapping",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'COMPUTE.SERVERSETTING': "compute.ServerSetting",
            'COMPUTE.VMEDIA': "compute.Vmedia",
            'CONSOLE.CONSOLECONFIG': "console.ConsoleConfig",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.LOCATORLED': "equipment.LocatorLed",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'ETHER.HOSTPORT': "ether.HostPort",
            'ETHER.NETWORKPORT': "ether.NetworkPort",
            'ETHER.PHYSICALPORT': "ether.PhysicalPort",
            'ETHER.PORTCHANNEL': "ether.PortChannel",
            'FAULT.INSTANCE': "fault.Instance",
            'FC.PHYSICALPORT': "fc.PhysicalPort",
            'FC.PORTCHANNEL': "fc.PortChannel",
            'FIRMWARE.RUNNINGFIRMWARE': "firmware.RunningFirmware",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'INVENTORY.GENERICINVENTORY': "inventory.GenericInventory",
            'INVENTORY.GENERICINVENTORYHOLDER': "inventory.GenericInventoryHolder",
            'LS.SERVICEPROFILE': "ls.ServiceProfile",
            'MANAGEMENT.CONTROLLER': "management.Controller",
            'MANAGEMENT.ENTITY': "management.Entity",
            'MANAGEMENT.INTERFACE': "management.Interface",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYCONFIGRESULT': "memory.PersistentMemoryConfigResult",
            'MEMORY.PERSISTENTMEMORYCONFIGURATION': "memory.PersistentMemoryConfiguration",
            'MEMORY.PERSISTENTMEMORYNAMESPACE': "memory.PersistentMemoryNamespace",
            'MEMORY.PERSISTENTMEMORYNAMESPACECONFIGRESULT': "memory.PersistentMemoryNamespaceConfigResult",
            'MEMORY.PERSISTENTMEMORYREGION': "memory.PersistentMemoryRegion",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.FCZONEINFO': "network.FcZoneInfo",
            'NETWORK.FEATURECONTROL': "network.FeatureControl",
            'NETWORK.INTERFACELIST': "network.InterfaceList",
            'NETWORK.LICENSEFILE': "network.LicenseFile",
            'NETWORK.SUPERVISORCARD': "network.SupervisorCard",
            'NETWORK.VLANPORTINFO': "network.VlanPortInfo",
            'NETWORK.VRF': "network.Vrf",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.SWITCH': "pci.Switch",
            'PORT.GROUP': "port.Group",
            'PORT.MACBINDING': "port.MacBinding",
            'PORT.SUBGROUP': "port.SubGroup",
            'PROCESSOR.UNIT': "processor.Unit",
            'RACK.UNITPERSONALITY': "rack.UnitPersonality",
            'SECURITY.UNIT': "security.Unit",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKGROUP': "storage.DiskGroup",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.ENCLOSUREDISKSLOTEP': "storage.EnclosureDiskSlotEp",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILCONTROLLER': "storage.FlexUtilController",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.FLEXUTILVIRTUALDRIVE': "storage.FlexUtilVirtualDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.ITEM': "storage.Item",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PHYSICALDISKUSAGE': "storage.PhysicalDiskUsage",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.SASPORT': "storage.SasPort",
            'STORAGE.SPAN': "storage.Span",
            'STORAGE.VDMEMBEREP': "storage.VdMemberEp",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
            'STORAGE.VIRTUALDRIVEEXTENSION': "storage.VirtualDriveExtension",
            'TOP.SYSTEM': "top.System",
        },
        ('object_type',): {
            'ADAPTER.EXTETHINTERFACE': "adapter.ExtEthInterface",
            'ADAPTER.HOSTETHINTERFACE': "adapter.HostEthInterface",
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'BIOS.BOOTMODE': "bios.BootMode",
            'BIOS.TOKENSETTINGS': "bios.TokenSettings",
            'BIOS.UNIT': "bios.Unit",
            'BIOS.VFSELECTMEMORYRASCONFIGURATION': "bios.VfSelectMemoryRasConfiguration",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.DEVICEBOOTMODE': "boot.DeviceBootMode",
            'BOOT.DEVICEBOOTSECURITY': "boot.DeviceBootSecurity",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.MAPPING': "compute.Mapping",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'COMPUTE.SERVERSETTING': "compute.ServerSetting",
            'COMPUTE.VMEDIA': "compute.Vmedia",
            'CONSOLE.CONSOLECONFIG': "console.ConsoleConfig",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.LOCATORLED': "equipment.LocatorLed",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'ETHER.HOSTPORT': "ether.HostPort",
            'ETHER.NETWORKPORT': "ether.NetworkPort",
            'ETHER.PHYSICALPORT': "ether.PhysicalPort",
            'ETHER.PORTCHANNEL': "ether.PortChannel",
            'FAULT.INSTANCE': "fault.Instance",
            'FC.PHYSICALPORT': "fc.PhysicalPort",
            'FC.PORTCHANNEL': "fc.PortChannel",
            'FIRMWARE.RUNNINGFIRMWARE': "firmware.RunningFirmware",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'INVENTORY.GENERICINVENTORY': "inventory.GenericInventory",
            'INVENTORY.GENERICINVENTORYHOLDER': "inventory.GenericInventoryHolder",
            'LS.SERVICEPROFILE': "ls.ServiceProfile",
            'MANAGEMENT.CONTROLLER': "management.Controller",
            'MANAGEMENT.ENTITY': "management.Entity",
            'MANAGEMENT.INTERFACE': "management.Interface",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYCONFIGRESULT': "memory.PersistentMemoryConfigResult",
            'MEMORY.PERSISTENTMEMORYCONFIGURATION': "memory.PersistentMemoryConfiguration",
            'MEMORY.PERSISTENTMEMORYNAMESPACE': "memory.PersistentMemoryNamespace",
            'MEMORY.PERSISTENTMEMORYNAMESPACECONFIGRESULT': "memory.PersistentMemoryNamespaceConfigResult",
            'MEMORY.PERSISTENTMEMORYREGION': "memory.PersistentMemoryRegion",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.FCZONEINFO': "network.FcZoneInfo",
            'NETWORK.FEATURECONTROL': "network.FeatureControl",
            'NETWORK.INTERFACELIST': "network.InterfaceList",
            'NETWORK.LICENSEFILE': "network.LicenseFile",
            'NETWORK.SUPERVISORCARD': "network.SupervisorCard",
            'NETWORK.VLANPORTINFO': "network.VlanPortInfo",
            'NETWORK.VRF': "network.Vrf",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.SWITCH': "pci.Switch",
            'PORT.GROUP': "port.Group",
            'PORT.MACBINDING': "port.MacBinding",
            'PORT.SUBGROUP': "port.SubGroup",
            'PROCESSOR.UNIT': "processor.Unit",
            'RACK.UNITPERSONALITY': "rack.UnitPersonality",
            'SECURITY.UNIT': "security.Unit",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKGROUP': "storage.DiskGroup",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.ENCLOSUREDISKSLOTEP': "storage.EnclosureDiskSlotEp",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILCONTROLLER': "storage.FlexUtilController",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.FLEXUTILVIRTUALDRIVE': "storage.FlexUtilVirtualDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.ITEM': "storage.Item",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PHYSICALDISKUSAGE': "storage.PhysicalDiskUsage",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.SASPORT': "storage.SasPort",
            'STORAGE.SPAN': "storage.Span",
            'STORAGE.VDMEMBEREP': "storage.VdMemberEp",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
            'STORAGE.VIRTUALDRIVEEXTENSION': "storage.VirtualDriveExtension",
            'TOP.SYSTEM': "top.System",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'device_mo_id': (str,),  # noqa: E501
            'dn': (str,),  # noqa: E501
            'rn': (str,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'adapter.ExtEthInterface': AdapterExtEthInterface,
            'adapter.HostEthInterface': AdapterHostEthInterface,
            'adapter.HostFcInterface': AdapterHostFcInterface,
            'adapter.HostIscsiInterface': AdapterHostIscsiInterface,
            'adapter.Unit': AdapterUnit,
            'adapter.UnitExpander': AdapterUnitExpander,
            'bios.BootMode': BiosBootMode,
            'bios.TokenSettings': BiosTokenSettings,
            'bios.Unit': BiosUnit,
            'bios.VfSelectMemoryRasConfiguration': BiosVfSelectMemoryRasConfiguration,
            'boot.CddDevice': BootCddDevice,
            'boot.ConfiguredDevice': BootConfiguredDevice,
            'boot.DeviceBootMode': BootDeviceBootMode,
            'boot.DeviceBootSecurity': BootDeviceBootSecurity,
            'boot.HddDevice': BootHddDevice,
            'boot.IscsiDevice': BootIscsiDevice,
            'boot.NvmeDevice': BootNvmeDevice,
            'boot.PchStorageDevice': BootPchStorageDevice,
            'boot.PxeDevice': BootPxeDevice,
            'boot.SanDevice': BootSanDevice,
            'boot.SdDevice': BootSdDevice,
            'boot.UefiShellDevice': BootUefiShellDevice,
            'boot.UsbDevice': BootUsbDevice,
            'boot.VmediaDevice': BootVmediaDevice,
            'compute.Blade': ComputeBlade,
            'compute.Board': ComputeBoard,
            'compute.Mapping': ComputeMapping,
            'compute.Physical': ComputePhysical,
            'compute.RackUnit': ComputeRackUnit,
            'compute.ServerSetting': ComputeServerSetting,
            'compute.Vmedia': ComputeVmedia,
            'console.ConsoleConfig': ConsoleConsoleConfig,
            'equipment.AbstractDevice': EquipmentAbstractDevice,
            'equipment.Base': EquipmentBase,
            'equipment.Chassis': EquipmentChassis,
            'equipment.ExpanderModule': EquipmentExpanderModule,
            'equipment.Fan': EquipmentFan,
            'equipment.FanControl': EquipmentFanControl,
            'equipment.FanModule': EquipmentFanModule,
            'equipment.Fex': EquipmentFex,
            'equipment.Fru': EquipmentFru,
            'equipment.IoCard': EquipmentIoCard,
            'equipment.IoCardBase': EquipmentIoCardBase,
            'equipment.IoExpander': EquipmentIoExpander,
            'equipment.LocatorLed': EquipmentLocatorLed,
            'equipment.Psu': EquipmentPsu,
            'equipment.PsuControl': EquipmentPsuControl,
            'equipment.RackEnclosure': EquipmentRackEnclosure,
            'equipment.RackEnclosureSlot': EquipmentRackEnclosureSlot,
            'equipment.SharedIoModule': EquipmentSharedIoModule,
            'equipment.Slot': EquipmentSlot,
            'equipment.SwitchCard': EquipmentSwitchCard,
            'equipment.SystemIoController': EquipmentSystemIoController,
            'equipment.Tpm': EquipmentTpm,
            'equipment.Transceiver': EquipmentTransceiver,
            'ether.HostPort': EtherHostPort,
            'ether.NetworkPort': EtherNetworkPort,
            'ether.PhysicalPort': EtherPhysicalPort,
            'ether.PhysicalPortBase': EtherPhysicalPortBase,
            'ether.PortChannel': EtherPortChannel,
            'fault.Instance': FaultInstance,
            'fc.PhysicalPort': FcPhysicalPort,
            'fc.PortChannel': FcPortChannel,
            'firmware.RunningFirmware': FirmwareRunningFirmware,
            'graphics.Card': GraphicsCard,
            'graphics.Controller': GraphicsController,
            'inventory.GenericInventory': InventoryGenericInventory,
            'inventory.GenericInventoryHolder': InventoryGenericInventoryHolder,
            'inventory.Interface': InventoryInterface,
            'ls.ServiceProfile': LsServiceProfile,
            'management.Controller': ManagementController,
            'management.Entity': ManagementEntity,
            'management.Interface': ManagementInterface,
            'memory.AbstractUnit': MemoryAbstractUnit,
            'memory.Array': MemoryArray,
            'memory.PersistentMemoryConfigResult': MemoryPersistentMemoryConfigResult,
            'memory.PersistentMemoryConfiguration': MemoryPersistentMemoryConfiguration,
            'memory.PersistentMemoryNamespace': MemoryPersistentMemoryNamespace,
            'memory.PersistentMemoryNamespaceConfigResult': MemoryPersistentMemoryNamespaceConfigResult,
            'memory.PersistentMemoryRegion': MemoryPersistentMemoryRegion,
            'memory.PersistentMemoryUnit': MemoryPersistentMemoryUnit,
            'memory.Unit': MemoryUnit,
            'network.Element': NetworkElement,
            'network.FcZoneInfo': NetworkFcZoneInfo,
            'network.FeatureControl': NetworkFeatureControl,
            'network.InterfaceList': NetworkInterfaceList,
            'network.LicenseFile': NetworkLicenseFile,
            'network.SupervisorCard': NetworkSupervisorCard,
            'network.VlanPortInfo': NetworkVlanPortInfo,
            'network.Vrf': NetworkVrf,
            'pci.CoprocessorCard': PciCoprocessorCard,
            'pci.Device': PciDevice,
            'pci.Link': PciLink,
            'pci.Switch': PciSwitch,
            'port.Group': PortGroup,
            'port.InterfaceBase': PortInterfaceBase,
            'port.MacBinding': PortMacBinding,
            'port.Physical': PortPhysical,
            'port.SubGroup': PortSubGroup,
            'processor.Unit': ProcessorUnit,
            'rack.UnitPersonality': RackUnitPersonality,
            'security.Unit': SecurityUnit,
            'storage.BaseArray': StorageBaseArray,
            'storage.BaseArrayController': StorageBaseArrayController,
            'storage.BaseArrayDisk': StorageBaseArrayDisk,
            'storage.Controller': StorageController,
            'storage.DiskGroup': StorageDiskGroup,
            'storage.DiskSlot': StorageDiskSlot,
            'storage.Enclosure': StorageEnclosure,
            'storage.EnclosureDisk': StorageEnclosureDisk,
            'storage.EnclosureDiskSlotEp': StorageEnclosureDiskSlotEp,
            'storage.FlexFlashController': StorageFlexFlashController,
            'storage.FlexFlashControllerProps': StorageFlexFlashControllerProps,
            'storage.FlexFlashPhysicalDrive': StorageFlexFlashPhysicalDrive,
            'storage.FlexFlashVirtualDrive': StorageFlexFlashVirtualDrive,
            'storage.FlexUtilController': StorageFlexUtilController,
            'storage.FlexUtilPhysicalDrive': StorageFlexUtilPhysicalDrive,
            'storage.FlexUtilVirtualDrive': StorageFlexUtilVirtualDrive,
            'storage.HitachiArray': StorageHitachiArray,
            'storage.HitachiController': StorageHitachiController,
            'storage.HitachiDisk': StorageHitachiDisk,
            'storage.Item': StorageItem,
            'storage.NetAppBaseDisk': StorageNetAppBaseDisk,
            'storage.NetAppCluster': StorageNetAppCluster,
            'storage.NetAppNode': StorageNetAppNode,
            'storage.PhysicalDisk': StoragePhysicalDisk,
            'storage.PhysicalDiskExtension': StoragePhysicalDiskExtension,
            'storage.PhysicalDiskUsage': StoragePhysicalDiskUsage,
            'storage.PureArray': StoragePureArray,
            'storage.PureController': StoragePureController,
            'storage.PureDisk': StoragePureDisk,
            'storage.SasExpander': StorageSasExpander,
            'storage.SasPort': StorageSasPort,
            'storage.Span': StorageSpan,
            'storage.VdMemberEp': StorageVdMemberEp,
            'storage.VirtualDrive': StorageVirtualDrive,
            'storage.VirtualDriveContainer': StorageVirtualDriveContainer,
            'storage.VirtualDriveExtension': StorageVirtualDriveExtension,
            'top.System': TopSystem,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'device_mo_id': 'DeviceMoId',  # noqa: E501
        'dn': 'Dn',  # noqa: E501
        'rn': 'Rn',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
    }

    read_only_vars = {
        'device_mo_id',  # noqa: E501
        'dn',  # noqa: E501
        'rn',  # noqa: E501
        'account_moid',  # noqa: E501
        'create_time',  # noqa: E501
        'domain_group_moid',  # noqa: E501
        'mod_time',  # noqa: E501
        'shared_scope',  # noqa: E501
        'ancestors',  # noqa: E501
        'permission_resources',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """InventoryBase - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """InventoryBase - a model defined in OpenAPI

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            device_mo_id (str): The database identifier of the registered device of an object.. [optional]  # noqa: E501
            dn (str): The Distinguished Name unambiguously identifies an object in the system.. [optional]  # noqa: E501
            rn (str): The Relative Name uniquely identifies an object within a given context.. [optional]  # noqa: E501
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        kwargs.update(required_args)
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              InventoryBaseAllOf,
              MoBaseMo,
          ],
          'oneOf': [
          ],
        }
