import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsimpleProviderConfig {
    /**
    * The account for API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple#account DnsimpleProvider#account}
    */
    readonly account: string;
    /**
    * Flag to enable the prefetch of zone records.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple#prefetch DnsimpleProvider#prefetch}
    */
    readonly prefetch?: boolean | cdktf.IResolvable;
    /**
    * Flag to enable the sandbox API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple#sandbox DnsimpleProvider#sandbox}
    */
    readonly sandbox?: boolean | cdktf.IResolvable;
    /**
    * The API v2 token for API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple#token DnsimpleProvider#token}
    */
    readonly token: string;
    /**
    * Custom string to append to the user agent used for sending HTTP requests to the API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple#user_agent DnsimpleProvider#user_agent}
    */
    readonly userAgent?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple#alias DnsimpleProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/dnsimple dnsimple}
*/
export declare class DnsimpleProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "dnsimple";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/dnsimple dnsimple} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsimpleProviderConfig
    */
    constructor(scope: Construct, id: string, config: DnsimpleProviderConfig);
    private _account?;
    get account(): string | undefined;
    set account(value: string | undefined);
    get accountInput(): string | undefined;
    private _prefetch?;
    get prefetch(): boolean | cdktf.IResolvable | undefined;
    set prefetch(value: boolean | cdktf.IResolvable | undefined);
    resetPrefetch(): void;
    get prefetchInput(): boolean | cdktf.IResolvable | undefined;
    private _sandbox?;
    get sandbox(): boolean | cdktf.IResolvable | undefined;
    set sandbox(value: boolean | cdktf.IResolvable | undefined);
    resetSandbox(): void;
    get sandboxInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    get tokenInput(): string | undefined;
    private _userAgent?;
    get userAgent(): string | undefined;
    set userAgent(value: string | undefined);
    resetUserAgent(): void;
    get userAgentInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
