"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseServiceInstance = exports.DatabaseServiceInstanceTimeoutsOutputReference = exports.databaseServiceInstanceTimeoutsToTerraform = exports.DatabaseServiceInstanceStandbyOutputReference = exports.databaseServiceInstanceStandbyToTerraform = exports.DatabaseServiceInstanceInstantiateFromBackupOutputReference = exports.databaseServiceInstanceInstantiateFromBackupToTerraform = exports.DatabaseServiceInstanceHybridDisasterRecoveryOutputReference = exports.databaseServiceInstanceHybridDisasterRecoveryToTerraform = exports.DatabaseServiceInstanceDefaultAccessRulesOutputReference = exports.databaseServiceInstanceDefaultAccessRulesToTerraform = exports.DatabaseServiceInstanceDatabaseConfigurationOutputReference = exports.databaseServiceInstanceDatabaseConfigurationToTerraform = exports.DatabaseServiceInstanceBackupsOutputReference = exports.databaseServiceInstanceBackupsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function databaseServiceInstanceBackupsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cloud_storage_container: cdktf.stringToTerraform(struct.cloudStorageContainer),
        cloud_storage_password: cdktf.stringToTerraform(struct.cloudStoragePassword),
        cloud_storage_username: cdktf.stringToTerraform(struct.cloudStorageUsername),
        create_if_missing: cdktf.booleanToTerraform(struct.createIfMissing),
    };
}
exports.databaseServiceInstanceBackupsToTerraform = databaseServiceInstanceBackupsToTerraform;
class DatabaseServiceInstanceBackupsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cloudStorageContainer !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageContainer = this._cloudStorageContainer;
        }
        if (this._cloudStoragePassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStoragePassword = this._cloudStoragePassword;
        }
        if (this._cloudStorageUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageUsername = this._cloudStorageUsername;
        }
        if (this._createIfMissing !== undefined) {
            hasAnyValues = true;
            internalValueResult.createIfMissing = this._createIfMissing;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cloudStorageContainer = undefined;
            this._cloudStoragePassword = undefined;
            this._cloudStorageUsername = undefined;
            this._createIfMissing = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cloudStorageContainer = value.cloudStorageContainer;
            this._cloudStoragePassword = value.cloudStoragePassword;
            this._cloudStorageUsername = value.cloudStorageUsername;
            this._createIfMissing = value.createIfMissing;
        }
    }
    get cloudStorageContainer() {
        return this.getStringAttribute('cloud_storage_container');
    }
    set cloudStorageContainer(value) {
        this._cloudStorageContainer = value;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageContainerInput() {
        return this._cloudStorageContainer;
    }
    get cloudStoragePassword() {
        return this.getStringAttribute('cloud_storage_password');
    }
    set cloudStoragePassword(value) {
        this._cloudStoragePassword = value;
    }
    resetCloudStoragePassword() {
        this._cloudStoragePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStoragePasswordInput() {
        return this._cloudStoragePassword;
    }
    get cloudStorageUsername() {
        return this.getStringAttribute('cloud_storage_username');
    }
    set cloudStorageUsername(value) {
        this._cloudStorageUsername = value;
    }
    resetCloudStorageUsername() {
        this._cloudStorageUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageUsernameInput() {
        return this._cloudStorageUsername;
    }
    get createIfMissing() {
        return this.getBooleanAttribute('create_if_missing');
    }
    set createIfMissing(value) {
        this._createIfMissing = value;
    }
    resetCreateIfMissing() {
        this._createIfMissing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createIfMissingInput() {
        return this._createIfMissing;
    }
}
exports.DatabaseServiceInstanceBackupsOutputReference = DatabaseServiceInstanceBackupsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstanceBackupsOutputReference[_a] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstanceBackupsOutputReference", version: "1.0.2" };
function databaseServiceInstanceDatabaseConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        admin_password: cdktf.stringToTerraform(struct.adminPassword),
        backup_destination: cdktf.stringToTerraform(struct.backupDestination),
        backup_storage_volume_size: cdktf.numberToTerraform(struct.backupStorageVolumeSize),
        character_set: cdktf.stringToTerraform(struct.characterSet),
        data_storage_volume_size: cdktf.numberToTerraform(struct.dataStorageVolumeSize),
        db_demo: cdktf.stringToTerraform(struct.dbDemo),
        disaster_recovery: cdktf.booleanToTerraform(struct.disasterRecovery),
        failover_database: cdktf.booleanToTerraform(struct.failoverDatabase),
        golden_gate: cdktf.booleanToTerraform(struct.goldenGate),
        is_rac: cdktf.booleanToTerraform(struct.isRac),
        national_character_set: cdktf.stringToTerraform(struct.nationalCharacterSet),
        pdb_name: cdktf.stringToTerraform(struct.pdbName),
        sid: cdktf.stringToTerraform(struct.sid),
        snapshot_name: cdktf.stringToTerraform(struct.snapshotName),
        source_service_name: cdktf.stringToTerraform(struct.sourceServiceName),
        timezone: cdktf.stringToTerraform(struct.timezone),
        type: cdktf.stringToTerraform(struct.type),
        usable_storage: cdktf.numberToTerraform(struct.usableStorage),
    };
}
exports.databaseServiceInstanceDatabaseConfigurationToTerraform = databaseServiceInstanceDatabaseConfigurationToTerraform;
class DatabaseServiceInstanceDatabaseConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._adminPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.adminPassword = this._adminPassword;
        }
        if (this._backupDestination !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupDestination = this._backupDestination;
        }
        if (this._backupStorageVolumeSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupStorageVolumeSize = this._backupStorageVolumeSize;
        }
        if (this._characterSet !== undefined) {
            hasAnyValues = true;
            internalValueResult.characterSet = this._characterSet;
        }
        if (this._dataStorageVolumeSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.dataStorageVolumeSize = this._dataStorageVolumeSize;
        }
        if (this._dbDemo !== undefined) {
            hasAnyValues = true;
            internalValueResult.dbDemo = this._dbDemo;
        }
        if (this._disasterRecovery !== undefined) {
            hasAnyValues = true;
            internalValueResult.disasterRecovery = this._disasterRecovery;
        }
        if (this._failoverDatabase !== undefined) {
            hasAnyValues = true;
            internalValueResult.failoverDatabase = this._failoverDatabase;
        }
        if (this._goldenGate !== undefined) {
            hasAnyValues = true;
            internalValueResult.goldenGate = this._goldenGate;
        }
        if (this._isRac !== undefined) {
            hasAnyValues = true;
            internalValueResult.isRac = this._isRac;
        }
        if (this._nationalCharacterSet !== undefined) {
            hasAnyValues = true;
            internalValueResult.nationalCharacterSet = this._nationalCharacterSet;
        }
        if (this._pdbName !== undefined) {
            hasAnyValues = true;
            internalValueResult.pdbName = this._pdbName;
        }
        if (this._sid !== undefined) {
            hasAnyValues = true;
            internalValueResult.sid = this._sid;
        }
        if (this._snapshotName !== undefined) {
            hasAnyValues = true;
            internalValueResult.snapshotName = this._snapshotName;
        }
        if (this._sourceServiceName !== undefined) {
            hasAnyValues = true;
            internalValueResult.sourceServiceName = this._sourceServiceName;
        }
        if (this._timezone !== undefined) {
            hasAnyValues = true;
            internalValueResult.timezone = this._timezone;
        }
        if (this._type !== undefined) {
            hasAnyValues = true;
            internalValueResult.type = this._type;
        }
        if (this._usableStorage !== undefined) {
            hasAnyValues = true;
            internalValueResult.usableStorage = this._usableStorage;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._adminPassword = undefined;
            this._backupDestination = undefined;
            this._backupStorageVolumeSize = undefined;
            this._characterSet = undefined;
            this._dataStorageVolumeSize = undefined;
            this._dbDemo = undefined;
            this._disasterRecovery = undefined;
            this._failoverDatabase = undefined;
            this._goldenGate = undefined;
            this._isRac = undefined;
            this._nationalCharacterSet = undefined;
            this._pdbName = undefined;
            this._sid = undefined;
            this._snapshotName = undefined;
            this._sourceServiceName = undefined;
            this._timezone = undefined;
            this._type = undefined;
            this._usableStorage = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._adminPassword = value.adminPassword;
            this._backupDestination = value.backupDestination;
            this._backupStorageVolumeSize = value.backupStorageVolumeSize;
            this._characterSet = value.characterSet;
            this._dataStorageVolumeSize = value.dataStorageVolumeSize;
            this._dbDemo = value.dbDemo;
            this._disasterRecovery = value.disasterRecovery;
            this._failoverDatabase = value.failoverDatabase;
            this._goldenGate = value.goldenGate;
            this._isRac = value.isRac;
            this._nationalCharacterSet = value.nationalCharacterSet;
            this._pdbName = value.pdbName;
            this._sid = value.sid;
            this._snapshotName = value.snapshotName;
            this._sourceServiceName = value.sourceServiceName;
            this._timezone = value.timezone;
            this._type = value.type;
            this._usableStorage = value.usableStorage;
        }
    }
    get adminPassword() {
        return this.getStringAttribute('admin_password');
    }
    set adminPassword(value) {
        this._adminPassword = value;
    }
    // Temporarily expose input value. Use with caution.
    get adminPasswordInput() {
        return this._adminPassword;
    }
    get backupDestination() {
        return this.getStringAttribute('backup_destination');
    }
    set backupDestination(value) {
        this._backupDestination = value;
    }
    resetBackupDestination() {
        this._backupDestination = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupDestinationInput() {
        return this._backupDestination;
    }
    get backupStorageVolumeSize() {
        return this.getNumberAttribute('backup_storage_volume_size');
    }
    set backupStorageVolumeSize(value) {
        this._backupStorageVolumeSize = value;
    }
    resetBackupStorageVolumeSize() {
        this._backupStorageVolumeSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupStorageVolumeSizeInput() {
        return this._backupStorageVolumeSize;
    }
    get characterSet() {
        return this.getStringAttribute('character_set');
    }
    set characterSet(value) {
        this._characterSet = value;
    }
    resetCharacterSet() {
        this._characterSet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get characterSetInput() {
        return this._characterSet;
    }
    get dataStorageVolumeSize() {
        return this.getNumberAttribute('data_storage_volume_size');
    }
    set dataStorageVolumeSize(value) {
        this._dataStorageVolumeSize = value;
    }
    resetDataStorageVolumeSize() {
        this._dataStorageVolumeSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataStorageVolumeSizeInput() {
        return this._dataStorageVolumeSize;
    }
    get dbDemo() {
        return this.getStringAttribute('db_demo');
    }
    set dbDemo(value) {
        this._dbDemo = value;
    }
    resetDbDemo() {
        this._dbDemo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dbDemoInput() {
        return this._dbDemo;
    }
    get disasterRecovery() {
        return this.getBooleanAttribute('disaster_recovery');
    }
    set disasterRecovery(value) {
        this._disasterRecovery = value;
    }
    resetDisasterRecovery() {
        this._disasterRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disasterRecoveryInput() {
        return this._disasterRecovery;
    }
    get failoverDatabase() {
        return this.getBooleanAttribute('failover_database');
    }
    set failoverDatabase(value) {
        this._failoverDatabase = value;
    }
    resetFailoverDatabase() {
        this._failoverDatabase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failoverDatabaseInput() {
        return this._failoverDatabase;
    }
    get goldenGate() {
        return this.getBooleanAttribute('golden_gate');
    }
    set goldenGate(value) {
        this._goldenGate = value;
    }
    resetGoldenGate() {
        this._goldenGate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get goldenGateInput() {
        return this._goldenGate;
    }
    get isRac() {
        return this.getBooleanAttribute('is_rac');
    }
    set isRac(value) {
        this._isRac = value;
    }
    resetIsRac() {
        this._isRac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isRacInput() {
        return this._isRac;
    }
    get nationalCharacterSet() {
        return this.getStringAttribute('national_character_set');
    }
    set nationalCharacterSet(value) {
        this._nationalCharacterSet = value;
    }
    resetNationalCharacterSet() {
        this._nationalCharacterSet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nationalCharacterSetInput() {
        return this._nationalCharacterSet;
    }
    get pdbName() {
        return this.getStringAttribute('pdb_name');
    }
    set pdbName(value) {
        this._pdbName = value;
    }
    resetPdbName() {
        this._pdbName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pdbNameInput() {
        return this._pdbName;
    }
    get sid() {
        return this.getStringAttribute('sid');
    }
    set sid(value) {
        this._sid = value;
    }
    resetSid() {
        this._sid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sidInput() {
        return this._sid;
    }
    get snapshotName() {
        return this.getStringAttribute('snapshot_name');
    }
    set snapshotName(value) {
        this._snapshotName = value;
    }
    resetSnapshotName() {
        this._snapshotName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snapshotNameInput() {
        return this._snapshotName;
    }
    get sourceServiceName() {
        return this.getStringAttribute('source_service_name');
    }
    set sourceServiceName(value) {
        this._sourceServiceName = value;
    }
    resetSourceServiceName() {
        this._sourceServiceName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceServiceNameInput() {
        return this._sourceServiceName;
    }
    get timezone() {
        return this.getStringAttribute('timezone');
    }
    set timezone(value) {
        this._timezone = value;
    }
    resetTimezone() {
        this._timezone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timezoneInput() {
        return this._timezone;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get usableStorage() {
        return this.getNumberAttribute('usable_storage');
    }
    set usableStorage(value) {
        this._usableStorage = value;
    }
    // Temporarily expose input value. Use with caution.
    get usableStorageInput() {
        return this._usableStorage;
    }
}
exports.DatabaseServiceInstanceDatabaseConfigurationOutputReference = DatabaseServiceInstanceDatabaseConfigurationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstanceDatabaseConfigurationOutputReference[_b] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstanceDatabaseConfigurationOutputReference", version: "1.0.2" };
function databaseServiceInstanceDefaultAccessRulesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable_db_console: cdktf.booleanToTerraform(struct.enableDbConsole),
        enable_db_express: cdktf.booleanToTerraform(struct.enableDbExpress),
        enable_db_listener: cdktf.booleanToTerraform(struct.enableDbListener),
        enable_em_console: cdktf.booleanToTerraform(struct.enableEmConsole),
        enable_http: cdktf.booleanToTerraform(struct.enableHttp),
        enable_http_ssl: cdktf.booleanToTerraform(struct.enableHttpSsl),
        enable_rac_db_listener: cdktf.booleanToTerraform(struct.enableRacDbListener),
        enable_rac_ons: cdktf.booleanToTerraform(struct.enableRacOns),
        enable_scan_listener: cdktf.booleanToTerraform(struct.enableScanListener),
        enable_ssh: cdktf.booleanToTerraform(struct.enableSsh),
    };
}
exports.databaseServiceInstanceDefaultAccessRulesToTerraform = databaseServiceInstanceDefaultAccessRulesToTerraform;
class DatabaseServiceInstanceDefaultAccessRulesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._enableDbConsole !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableDbConsole = this._enableDbConsole;
        }
        if (this._enableDbExpress !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableDbExpress = this._enableDbExpress;
        }
        if (this._enableDbListener !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableDbListener = this._enableDbListener;
        }
        if (this._enableEmConsole !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableEmConsole = this._enableEmConsole;
        }
        if (this._enableHttp !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableHttp = this._enableHttp;
        }
        if (this._enableHttpSsl !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableHttpSsl = this._enableHttpSsl;
        }
        if (this._enableRacDbListener !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableRacDbListener = this._enableRacDbListener;
        }
        if (this._enableRacOns !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableRacOns = this._enableRacOns;
        }
        if (this._enableScanListener !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableScanListener = this._enableScanListener;
        }
        if (this._enableSsh !== undefined) {
            hasAnyValues = true;
            internalValueResult.enableSsh = this._enableSsh;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._enableDbConsole = undefined;
            this._enableDbExpress = undefined;
            this._enableDbListener = undefined;
            this._enableEmConsole = undefined;
            this._enableHttp = undefined;
            this._enableHttpSsl = undefined;
            this._enableRacDbListener = undefined;
            this._enableRacOns = undefined;
            this._enableScanListener = undefined;
            this._enableSsh = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._enableDbConsole = value.enableDbConsole;
            this._enableDbExpress = value.enableDbExpress;
            this._enableDbListener = value.enableDbListener;
            this._enableEmConsole = value.enableEmConsole;
            this._enableHttp = value.enableHttp;
            this._enableHttpSsl = value.enableHttpSsl;
            this._enableRacDbListener = value.enableRacDbListener;
            this._enableRacOns = value.enableRacOns;
            this._enableScanListener = value.enableScanListener;
            this._enableSsh = value.enableSsh;
        }
    }
    get enableDbConsole() {
        return this.getBooleanAttribute('enable_db_console');
    }
    set enableDbConsole(value) {
        this._enableDbConsole = value;
    }
    resetEnableDbConsole() {
        this._enableDbConsole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableDbConsoleInput() {
        return this._enableDbConsole;
    }
    get enableDbExpress() {
        return this.getBooleanAttribute('enable_db_express');
    }
    set enableDbExpress(value) {
        this._enableDbExpress = value;
    }
    resetEnableDbExpress() {
        this._enableDbExpress = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableDbExpressInput() {
        return this._enableDbExpress;
    }
    get enableDbListener() {
        return this.getBooleanAttribute('enable_db_listener');
    }
    set enableDbListener(value) {
        this._enableDbListener = value;
    }
    resetEnableDbListener() {
        this._enableDbListener = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableDbListenerInput() {
        return this._enableDbListener;
    }
    get enableEmConsole() {
        return this.getBooleanAttribute('enable_em_console');
    }
    set enableEmConsole(value) {
        this._enableEmConsole = value;
    }
    resetEnableEmConsole() {
        this._enableEmConsole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableEmConsoleInput() {
        return this._enableEmConsole;
    }
    get enableHttp() {
        return this.getBooleanAttribute('enable_http');
    }
    set enableHttp(value) {
        this._enableHttp = value;
    }
    resetEnableHttp() {
        this._enableHttp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHttpInput() {
        return this._enableHttp;
    }
    get enableHttpSsl() {
        return this.getBooleanAttribute('enable_http_ssl');
    }
    set enableHttpSsl(value) {
        this._enableHttpSsl = value;
    }
    resetEnableHttpSsl() {
        this._enableHttpSsl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHttpSslInput() {
        return this._enableHttpSsl;
    }
    get enableRacDbListener() {
        return this.getBooleanAttribute('enable_rac_db_listener');
    }
    set enableRacDbListener(value) {
        this._enableRacDbListener = value;
    }
    resetEnableRacDbListener() {
        this._enableRacDbListener = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableRacDbListenerInput() {
        return this._enableRacDbListener;
    }
    get enableRacOns() {
        return this.getBooleanAttribute('enable_rac_ons');
    }
    set enableRacOns(value) {
        this._enableRacOns = value;
    }
    resetEnableRacOns() {
        this._enableRacOns = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableRacOnsInput() {
        return this._enableRacOns;
    }
    get enableScanListener() {
        return this.getBooleanAttribute('enable_scan_listener');
    }
    set enableScanListener(value) {
        this._enableScanListener = value;
    }
    resetEnableScanListener() {
        this._enableScanListener = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableScanListenerInput() {
        return this._enableScanListener;
    }
    get enableSsh() {
        return this.getBooleanAttribute('enable_ssh');
    }
    set enableSsh(value) {
        this._enableSsh = value;
    }
    resetEnableSsh() {
        this._enableSsh = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableSshInput() {
        return this._enableSsh;
    }
}
exports.DatabaseServiceInstanceDefaultAccessRulesOutputReference = DatabaseServiceInstanceDefaultAccessRulesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstanceDefaultAccessRulesOutputReference[_c] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstanceDefaultAccessRulesOutputReference", version: "1.0.2" };
function databaseServiceInstanceHybridDisasterRecoveryToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cloud_storage_container: cdktf.stringToTerraform(struct.cloudStorageContainer),
        cloud_storage_password: cdktf.stringToTerraform(struct.cloudStoragePassword),
        cloud_storage_username: cdktf.stringToTerraform(struct.cloudStorageUsername),
    };
}
exports.databaseServiceInstanceHybridDisasterRecoveryToTerraform = databaseServiceInstanceHybridDisasterRecoveryToTerraform;
class DatabaseServiceInstanceHybridDisasterRecoveryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cloudStorageContainer !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageContainer = this._cloudStorageContainer;
        }
        if (this._cloudStoragePassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStoragePassword = this._cloudStoragePassword;
        }
        if (this._cloudStorageUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageUsername = this._cloudStorageUsername;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cloudStorageContainer = undefined;
            this._cloudStoragePassword = undefined;
            this._cloudStorageUsername = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cloudStorageContainer = value.cloudStorageContainer;
            this._cloudStoragePassword = value.cloudStoragePassword;
            this._cloudStorageUsername = value.cloudStorageUsername;
        }
    }
    get cloudStorageContainer() {
        return this.getStringAttribute('cloud_storage_container');
    }
    set cloudStorageContainer(value) {
        this._cloudStorageContainer = value;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageContainerInput() {
        return this._cloudStorageContainer;
    }
    get cloudStoragePassword() {
        return this.getStringAttribute('cloud_storage_password');
    }
    set cloudStoragePassword(value) {
        this._cloudStoragePassword = value;
    }
    resetCloudStoragePassword() {
        this._cloudStoragePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStoragePasswordInput() {
        return this._cloudStoragePassword;
    }
    get cloudStorageUsername() {
        return this.getStringAttribute('cloud_storage_username');
    }
    set cloudStorageUsername(value) {
        this._cloudStorageUsername = value;
    }
    resetCloudStorageUsername() {
        this._cloudStorageUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageUsernameInput() {
        return this._cloudStorageUsername;
    }
}
exports.DatabaseServiceInstanceHybridDisasterRecoveryOutputReference = DatabaseServiceInstanceHybridDisasterRecoveryOutputReference;
_d = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstanceHybridDisasterRecoveryOutputReference[_d] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstanceHybridDisasterRecoveryOutputReference", version: "1.0.2" };
function databaseServiceInstanceInstantiateFromBackupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cloud_storage_container: cdktf.stringToTerraform(struct.cloudStorageContainer),
        cloud_storage_password: cdktf.stringToTerraform(struct.cloudStoragePassword),
        cloud_storage_username: cdktf.stringToTerraform(struct.cloudStorageUsername),
        database_id: cdktf.stringToTerraform(struct.databaseId),
        decryption_key: cdktf.stringToTerraform(struct.decryptionKey),
        on_premise: cdktf.booleanToTerraform(struct.onPremise),
        service_id: cdktf.stringToTerraform(struct.serviceId),
        wallet_file_content: cdktf.stringToTerraform(struct.walletFileContent),
    };
}
exports.databaseServiceInstanceInstantiateFromBackupToTerraform = databaseServiceInstanceInstantiateFromBackupToTerraform;
class DatabaseServiceInstanceInstantiateFromBackupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cloudStorageContainer !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageContainer = this._cloudStorageContainer;
        }
        if (this._cloudStoragePassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStoragePassword = this._cloudStoragePassword;
        }
        if (this._cloudStorageUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageUsername = this._cloudStorageUsername;
        }
        if (this._databaseId !== undefined) {
            hasAnyValues = true;
            internalValueResult.databaseId = this._databaseId;
        }
        if (this._decryptionKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.decryptionKey = this._decryptionKey;
        }
        if (this._onPremise !== undefined) {
            hasAnyValues = true;
            internalValueResult.onPremise = this._onPremise;
        }
        if (this._serviceId !== undefined) {
            hasAnyValues = true;
            internalValueResult.serviceId = this._serviceId;
        }
        if (this._walletFileContent !== undefined) {
            hasAnyValues = true;
            internalValueResult.walletFileContent = this._walletFileContent;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cloudStorageContainer = undefined;
            this._cloudStoragePassword = undefined;
            this._cloudStorageUsername = undefined;
            this._databaseId = undefined;
            this._decryptionKey = undefined;
            this._onPremise = undefined;
            this._serviceId = undefined;
            this._walletFileContent = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cloudStorageContainer = value.cloudStorageContainer;
            this._cloudStoragePassword = value.cloudStoragePassword;
            this._cloudStorageUsername = value.cloudStorageUsername;
            this._databaseId = value.databaseId;
            this._decryptionKey = value.decryptionKey;
            this._onPremise = value.onPremise;
            this._serviceId = value.serviceId;
            this._walletFileContent = value.walletFileContent;
        }
    }
    get cloudStorageContainer() {
        return this.getStringAttribute('cloud_storage_container');
    }
    set cloudStorageContainer(value) {
        this._cloudStorageContainer = value;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageContainerInput() {
        return this._cloudStorageContainer;
    }
    get cloudStoragePassword() {
        return this.getStringAttribute('cloud_storage_password');
    }
    set cloudStoragePassword(value) {
        this._cloudStoragePassword = value;
    }
    resetCloudStoragePassword() {
        this._cloudStoragePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStoragePasswordInput() {
        return this._cloudStoragePassword;
    }
    get cloudStorageUsername() {
        return this.getStringAttribute('cloud_storage_username');
    }
    set cloudStorageUsername(value) {
        this._cloudStorageUsername = value;
    }
    resetCloudStorageUsername() {
        this._cloudStorageUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageUsernameInput() {
        return this._cloudStorageUsername;
    }
    get databaseId() {
        return this.getStringAttribute('database_id');
    }
    set databaseId(value) {
        this._databaseId = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseIdInput() {
        return this._databaseId;
    }
    get decryptionKey() {
        return this.getStringAttribute('decryption_key');
    }
    set decryptionKey(value) {
        this._decryptionKey = value;
    }
    resetDecryptionKey() {
        this._decryptionKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get decryptionKeyInput() {
        return this._decryptionKey;
    }
    get onPremise() {
        return this.getBooleanAttribute('on_premise');
    }
    set onPremise(value) {
        this._onPremise = value;
    }
    resetOnPremise() {
        this._onPremise = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onPremiseInput() {
        return this._onPremise;
    }
    get serviceId() {
        return this.getStringAttribute('service_id');
    }
    set serviceId(value) {
        this._serviceId = value;
    }
    resetServiceId() {
        this._serviceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceIdInput() {
        return this._serviceId;
    }
    get walletFileContent() {
        return this.getStringAttribute('wallet_file_content');
    }
    set walletFileContent(value) {
        this._walletFileContent = value;
    }
    resetWalletFileContent() {
        this._walletFileContent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get walletFileContentInput() {
        return this._walletFileContent;
    }
}
exports.DatabaseServiceInstanceInstantiateFromBackupOutputReference = DatabaseServiceInstanceInstantiateFromBackupOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstanceInstantiateFromBackupOutputReference[_e] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstanceInstantiateFromBackupOutputReference", version: "1.0.2" };
function databaseServiceInstanceStandbyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        availability_domain: cdktf.stringToTerraform(struct.availabilityDomain),
        subnet: cdktf.stringToTerraform(struct.subnet),
    };
}
exports.databaseServiceInstanceStandbyToTerraform = databaseServiceInstanceStandbyToTerraform;
class DatabaseServiceInstanceStandbyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._availabilityDomain !== undefined) {
            hasAnyValues = true;
            internalValueResult.availabilityDomain = this._availabilityDomain;
        }
        if (this._subnet !== undefined) {
            hasAnyValues = true;
            internalValueResult.subnet = this._subnet;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._availabilityDomain = undefined;
            this._subnet = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._availabilityDomain = value.availabilityDomain;
            this._subnet = value.subnet;
        }
    }
    get availabilityDomain() {
        return this.getStringAttribute('availability_domain');
    }
    set availabilityDomain(value) {
        this._availabilityDomain = value;
    }
    // Temporarily expose input value. Use with caution.
    get availabilityDomainInput() {
        return this._availabilityDomain;
    }
    get subnet() {
        return this.getStringAttribute('subnet');
    }
    set subnet(value) {
        this._subnet = value;
    }
    // Temporarily expose input value. Use with caution.
    get subnetInput() {
        return this._subnet;
    }
}
exports.DatabaseServiceInstanceStandbyOutputReference = DatabaseServiceInstanceStandbyOutputReference;
_f = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstanceStandbyOutputReference[_f] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstanceStandbyOutputReference", version: "1.0.2" };
function databaseServiceInstanceTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.databaseServiceInstanceTimeoutsToTerraform = databaseServiceInstanceTimeoutsToTerraform;
class DatabaseServiceInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.DatabaseServiceInstanceTimeoutsOutputReference = DatabaseServiceInstanceTimeoutsOutputReference;
_g = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstanceTimeoutsOutputReference[_g] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstanceTimeoutsOutputReference", version: "1.0.2" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance oraclepaas_database_service_instance}
*/
class DatabaseServiceInstance extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas/r/database_service_instance oraclepaas_database_service_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseServiceInstanceConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'oraclepaas_database_service_instance',
            terraformGeneratorMetadata: {
                providerName: 'oraclepaas',
                providerVersion: '1.5.3',
                providerVersionConstraint: '~> 1.5'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // backups - computed: false, optional: true, required: false
        this._backups = new DatabaseServiceInstanceBackupsOutputReference(this, "backups");
        // database_configuration - computed: false, optional: false, required: true
        this._databaseConfiguration = new DatabaseServiceInstanceDatabaseConfigurationOutputReference(this, "database_configuration");
        // default_access_rules - computed: false, optional: true, required: false
        this._defaultAccessRules = new DatabaseServiceInstanceDefaultAccessRulesOutputReference(this, "default_access_rules");
        // hybrid_disaster_recovery - computed: false, optional: true, required: false
        this._hybridDisasterRecovery = new DatabaseServiceInstanceHybridDisasterRecoveryOutputReference(this, "hybrid_disaster_recovery");
        // instantiate_from_backup - computed: false, optional: true, required: false
        this._instantiateFromBackup = new DatabaseServiceInstanceInstantiateFromBackupOutputReference(this, "instantiate_from_backup");
        // standby - computed: false, optional: true, required: false
        this._standby = new DatabaseServiceInstanceStandbyOutputReference(this, "standby");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new DatabaseServiceInstanceTimeoutsOutputReference(this, "timeouts");
        this._availabilityDomain = config.availabilityDomain;
        this._bringYourOwnLicense = config.bringYourOwnLicense;
        this._description = config.description;
        this._desiredState = config.desiredState;
        this._edition = config.edition;
        this._highPerformanceStorage = config.highPerformanceStorage;
        this._id = config.id;
        this._ipNetwork = config.ipNetwork;
        this._ipReservations = config.ipReservations;
        this._level = config.level;
        this._name = config.name;
        this._notificationEmail = config.notificationEmail;
        this._region = config.region;
        this._shape = config.shape;
        this._sshPublicKey = config.sshPublicKey;
        this._subnet = config.subnet;
        this._subscriptionType = config.subscriptionType;
        this._version = config.version;
        this._backups.internalValue = config.backups;
        this._databaseConfiguration.internalValue = config.databaseConfiguration;
        this._defaultAccessRules.internalValue = config.defaultAccessRules;
        this._hybridDisasterRecovery.internalValue = config.hybridDisasterRecovery;
        this._instantiateFromBackup.internalValue = config.instantiateFromBackup;
        this._standby.internalValue = config.standby;
        this._timeouts.internalValue = config.timeouts;
    }
    get availabilityDomain() {
        return this.getStringAttribute('availability_domain');
    }
    set availabilityDomain(value) {
        this._availabilityDomain = value;
    }
    resetAvailabilityDomain() {
        this._availabilityDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get availabilityDomainInput() {
        return this._availabilityDomain;
    }
    get bringYourOwnLicense() {
        return this.getBooleanAttribute('bring_your_own_license');
    }
    set bringYourOwnLicense(value) {
        this._bringYourOwnLicense = value;
    }
    resetBringYourOwnLicense() {
        this._bringYourOwnLicense = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bringYourOwnLicenseInput() {
        return this._bringYourOwnLicense;
    }
    // cloud_storage_container - computed: true, optional: false, required: false
    get cloudStorageContainer() {
        return this.getStringAttribute('cloud_storage_container');
    }
    // compute_site_name - computed: true, optional: false, required: false
    get computeSiteName() {
        return this.getStringAttribute('compute_site_name');
    }
    // dbaas_monitor_url - computed: true, optional: false, required: false
    get dbaasMonitorUrl() {
        return this.getStringAttribute('dbaas_monitor_url');
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get desiredState() {
        return this.getStringAttribute('desired_state');
    }
    set desiredState(value) {
        this._desiredState = value;
    }
    resetDesiredState() {
        this._desiredState = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get desiredStateInput() {
        return this._desiredState;
    }
    get edition() {
        return this.getStringAttribute('edition');
    }
    set edition(value) {
        this._edition = value;
    }
    // Temporarily expose input value. Use with caution.
    get editionInput() {
        return this._edition;
    }
    // em_url - computed: true, optional: false, required: false
    get emUrl() {
        return this.getStringAttribute('em_url');
    }
    // glassfish_url - computed: true, optional: false, required: false
    get glassfishUrl() {
        return this.getStringAttribute('glassfish_url');
    }
    get highPerformanceStorage() {
        return this.getBooleanAttribute('high_performance_storage');
    }
    set highPerformanceStorage(value) {
        this._highPerformanceStorage = value;
    }
    resetHighPerformanceStorage() {
        this._highPerformanceStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get highPerformanceStorageInput() {
        return this._highPerformanceStorage;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    // identity_domain - computed: true, optional: false, required: false
    get identityDomain() {
        return this.getStringAttribute('identity_domain');
    }
    get ipNetwork() {
        return this.getStringAttribute('ip_network');
    }
    set ipNetwork(value) {
        this._ipNetwork = value;
    }
    resetIpNetwork() {
        this._ipNetwork = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipNetworkInput() {
        return this._ipNetwork;
    }
    get ipReservations() {
        return this.getListAttribute('ip_reservations');
    }
    set ipReservations(value) {
        this._ipReservations = value;
    }
    resetIpReservations() {
        this._ipReservations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipReservationsInput() {
        return this._ipReservations;
    }
    get level() {
        return this.getStringAttribute('level');
    }
    set level(value) {
        this._level = value;
    }
    resetLevel() {
        this._level = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get levelInput() {
        return this._level;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get notificationEmail() {
        return this.getStringAttribute('notification_email');
    }
    set notificationEmail(value) {
        this._notificationEmail = value;
    }
    resetNotificationEmail() {
        this._notificationEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationEmailInput() {
        return this._notificationEmail;
    }
    get region() {
        return this.getStringAttribute('region');
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get shape() {
        return this.getStringAttribute('shape');
    }
    set shape(value) {
        this._shape = value;
    }
    // Temporarily expose input value. Use with caution.
    get shapeInput() {
        return this._shape;
    }
    get sshPublicKey() {
        return this.getStringAttribute('ssh_public_key');
    }
    set sshPublicKey(value) {
        this._sshPublicKey = value;
    }
    // Temporarily expose input value. Use with caution.
    get sshPublicKeyInput() {
        return this._sshPublicKey;
    }
    // status - computed: true, optional: false, required: false
    get status() {
        return this.getStringAttribute('status');
    }
    get subnet() {
        return this.getStringAttribute('subnet');
    }
    set subnet(value) {
        this._subnet = value;
    }
    resetSubnet() {
        this._subnet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subnetInput() {
        return this._subnet;
    }
    get subscriptionType() {
        return this.getStringAttribute('subscription_type');
    }
    set subscriptionType(value) {
        this._subscriptionType = value;
    }
    // Temporarily expose input value. Use with caution.
    get subscriptionTypeInput() {
        return this._subscriptionType;
    }
    // uri - computed: true, optional: false, required: false
    get uri() {
        return this.getStringAttribute('uri');
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get backups() {
        return this._backups;
    }
    putBackups(value) {
        this._backups.internalValue = value;
    }
    resetBackups() {
        this._backups.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupsInput() {
        return this._backups.internalValue;
    }
    get databaseConfiguration() {
        return this._databaseConfiguration;
    }
    putDatabaseConfiguration(value) {
        this._databaseConfiguration.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseConfigurationInput() {
        return this._databaseConfiguration.internalValue;
    }
    get defaultAccessRules() {
        return this._defaultAccessRules;
    }
    putDefaultAccessRules(value) {
        this._defaultAccessRules.internalValue = value;
    }
    resetDefaultAccessRules() {
        this._defaultAccessRules.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultAccessRulesInput() {
        return this._defaultAccessRules.internalValue;
    }
    get hybridDisasterRecovery() {
        return this._hybridDisasterRecovery;
    }
    putHybridDisasterRecovery(value) {
        this._hybridDisasterRecovery.internalValue = value;
    }
    resetHybridDisasterRecovery() {
        this._hybridDisasterRecovery.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hybridDisasterRecoveryInput() {
        return this._hybridDisasterRecovery.internalValue;
    }
    get instantiateFromBackup() {
        return this._instantiateFromBackup;
    }
    putInstantiateFromBackup(value) {
        this._instantiateFromBackup.internalValue = value;
    }
    resetInstantiateFromBackup() {
        this._instantiateFromBackup.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get instantiateFromBackupInput() {
        return this._instantiateFromBackup.internalValue;
    }
    get standby() {
        return this._standby;
    }
    putStandby(value) {
        this._standby.internalValue = value;
    }
    resetStandby() {
        this._standby.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get standbyInput() {
        return this._standby.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            availability_domain: cdktf.stringToTerraform(this._availabilityDomain),
            bring_your_own_license: cdktf.booleanToTerraform(this._bringYourOwnLicense),
            description: cdktf.stringToTerraform(this._description),
            desired_state: cdktf.stringToTerraform(this._desiredState),
            edition: cdktf.stringToTerraform(this._edition),
            high_performance_storage: cdktf.booleanToTerraform(this._highPerformanceStorage),
            id: cdktf.stringToTerraform(this._id),
            ip_network: cdktf.stringToTerraform(this._ipNetwork),
            ip_reservations: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ipReservations),
            level: cdktf.stringToTerraform(this._level),
            name: cdktf.stringToTerraform(this._name),
            notification_email: cdktf.stringToTerraform(this._notificationEmail),
            region: cdktf.stringToTerraform(this._region),
            shape: cdktf.stringToTerraform(this._shape),
            ssh_public_key: cdktf.stringToTerraform(this._sshPublicKey),
            subnet: cdktf.stringToTerraform(this._subnet),
            subscription_type: cdktf.stringToTerraform(this._subscriptionType),
            version: cdktf.stringToTerraform(this._version),
            backups: databaseServiceInstanceBackupsToTerraform(this._backups.internalValue),
            database_configuration: databaseServiceInstanceDatabaseConfigurationToTerraform(this._databaseConfiguration.internalValue),
            default_access_rules: databaseServiceInstanceDefaultAccessRulesToTerraform(this._defaultAccessRules.internalValue),
            hybrid_disaster_recovery: databaseServiceInstanceHybridDisasterRecoveryToTerraform(this._hybridDisasterRecovery.internalValue),
            instantiate_from_backup: databaseServiceInstanceInstantiateFromBackupToTerraform(this._instantiateFromBackup.internalValue),
            standby: databaseServiceInstanceStandbyToTerraform(this._standby.internalValue),
            timeouts: databaseServiceInstanceTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.DatabaseServiceInstance = DatabaseServiceInstance;
_h = JSII_RTTI_SYMBOL_1;
DatabaseServiceInstance[_h] = { fqn: "@cdktf/provider-oraclepaas.databaseServiceInstance.DatabaseServiceInstance", version: "1.0.2" };
// =================
// STATIC PROPERTIES
// =================
DatabaseServiceInstance.tfResourceType = "oraclepaas_database_service_instance";
//# sourceMappingURL=data:application/json;base64,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