# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['quiz']

package_data = \
{'': ['*']}

install_requires = \
['gentools>=1.2.0,<2.0.0', 'snug>=2.2.0,<3.0.0']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=1,<5']}

setup_kwargs = {
    'name': 'quiz',
    'version': '0.3.1',
    'description': 'Capable GraphQL client',
    'long_description': '🎱 Quiz\n=======\n\n.. image:: https://img.shields.io/pypi/v/quiz.svg?style=flat-square\n   :target: https://pypi.python.org/pypi/quiz\n\n.. image:: https://img.shields.io/pypi/l/quiz.svg?style=flat-square\n   :target: https://pypi.python.org/pypi/quiz\n\n.. image:: https://img.shields.io/pypi/pyversions/quiz.svg?style=flat-square\n   :target: https://pypi.python.org/pypi/quiz\n\n.. image:: https://img.shields.io/readthedocs/quiz.svg?style=flat-square\n   :target: http://quiz.readthedocs.io/\n\n.. image:: https://img.shields.io/codecov/c/github/ariebovenberg/quiz.svg?style=flat-square&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAaCAMAAACaYWzBAAABX1BMVEUAAAD///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////8P/Ub/AAAAdHRSTlMAAQIDBAUGBw0PERIVFhcZGhsgISQmKSorLS8zODk6PUFDR0lLTE1YXF5fYGRlaHB1dnd4eXt/g4eKjJKVlpeYmZqcnqOkpaanqqusrq+xsrW3ubu8vb7Hzc7Q1dfZ3N3e3+Dh4ujp6uzt7/Hz9fb3+Pv9/mHMvTIAAAFPSURBVHgBbdDXcxJRGIbx55zvnI1ijJI1YuxiEkWNsRjsKPYiFuxFsRdREH3//5Hd2YvMLL/bZ76L9yMTYe74o95g+L57qgaRQiC9qbF+X2N35zBHxmj80bC9mFYqs/sv/NLfZXxWAiekq5soTLekJgaRw9IyxOCd8yHCIekoEbaMdITEKFhCQ/9qwB1dIWGNhIu6D9s0qDJlnoIPU8z0tZ1VXSITDMACmfNq8liL0/X6jnXgIcCGXUsLmxf0jA96q7Fv7RQz5m/kI9/pI1+lTw/vvZC0F1YkPb/V6Uk/0Ot6ANJrn2c4KbVmAbfvlTgNmDmosidf6s2AVYpnmoenOlssjUBw5Iyt+lnByLkAhchB3SZQEjmmM8RJYUXnJoXAkp5glHg2/laNZNLJZXUh8a588l3XHWWB3SO9aVTXW7nMv5TUwblS4cCDLzsx4D/omEB2BXPuawAAAABJRU5ErkJggg==\n   :target: https://codecov.io/gh/ariebovenberg/quiz\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg?style=flat-square\n   :target: https://github.com/psf/black\n\nCapable GraphQL client for Python.\n\nFeatures:\n\n* Sync/async compatible, pluggable HTTP clients.\n* Auto-generate typed and documented python APIs\n* ORM-like syntax to write GraphQL.\n\nNote that this project is in an early alpha stage.\nSome features are not yet implemented (see the roadmap below),\nand it may be a little rough around the edges.\nIf you encounter a problem or have a feature request,\ndon\'t hesitate to open an issue in the `issue tracker <https://github.com/ariebovenberg/quiz/issues>`_.\n\n\nQuickstart\n----------\n\nA quick \'n dirty request to GitHub\'s new V4 API:\n\n.. code-block:: python3\n\n   >>> import quiz\n   >>> query = \'\'\'\n   ...   {\n   ...     repository(owner: "octocat", name: "Hello-World") {\n   ...       createdAt\n   ...       description\n   ...     }\n   ...   }\n   ... \'\'\'\n   >>> quiz.execute(query, url=\'https://api.github.com/graphql\',\n   ...              auth=(\'me\', \'password\'))\n   {"repository": ...}\n\n\nFeatures\n--------\n\n1. **Adaptability**. Built on top of `snug <http://snug.readthedocs.io/>`_,\n   quiz supports different HTTP clients\n\n   .. code-block:: python3\n\n      import requests\n      result = quiz.execute(query, ..., client=requests.Session())\n\n   as well as async execution\n   (optionally with `aiohttp <http:aiohttp.readthedocs.io/>`_):\n\n   .. code-block:: python3\n\n      result = await quiz.execute_async(query, ...)\n\n2. **Typing**.\n   Convert a GraphQL schema into documented python classes:\n\n   .. code-block:: python3\n\n      >>> schema = quiz.Schema.from_url(\'https://api.github.com/graphql\',\n      ...                               auth=(\'me\', \'password\'))\n      >>> help(schema.Repository)\n      class Repository(Node, ProjectOwner, Subscribable, Starrable,\n       UniformResourceLocatable, RepositoryInfo, quiz.types.Object)\n       |  A repository contains the content for a project.\n       |\n       |  Method resolution order:\n       |      ...\n       |\n       |  Data descriptors defined here:\n       |\n       |  assignableUsers\n       |      : UserConnection\n       |      A list of users that can be assigned to issues in this repo\n       |\n       |  codeOfConduct\n       |      : CodeOfConduct or None\n       |      Returns the code of conduct for this repository\n       ...\n\n\n3. **GraphQL "ORM"**. Write queries as you would with an ORM:\n\n   .. code-block:: python3\n\n      >>> _ = quiz.SELECTOR\n      >>> query = schema.query[\n      ...     _\n      ...     .repository(owner=\'octocat\', name=\'Hello-World\')[\n      ...         _\n      ...         .createdAt\n      ...         .description\n      ...     ]\n      ... ]\n      >>> str(query)\n      query {\n        repository(owner: "octocat", name: "Hello-World") {\n          createdAt\n          description\n        }\n      }\n\n4. **Offline query validation**. Use the schema to catch errors quickly:\n\n   .. code-block:: python3\n\n      >>> schema.query[\n      ...     _\n      ...     .repository(owner=\'octocat\', name=\'Hello-World\')[\n      ...         _\n      ...         .createdAt\n      ...         .foo\n      ...         .description\n      ...     ]\n      ... ]\n      SelectionError: SelectionError on "Query" at path "repository":\n\n          SelectionError: SelectionError on "Repository" at path "foo":\n\n              NoSuchField: field does not exist\n\n5. **Deserialization into python objects**. Responses are loaded into the schema\'s types.\n   Use ``.`` to access fields:\n\n   .. code-block:: python3\n\n      >>> r = quiz.execute(query, ...)\n      >>> r.repository.description\n      "My first repository on GitHub!"\n      >>> isinstance(r.repository, schema.Repository)\n      True\n\n   If you prefer the raw JSON response, you can always do:\n\n   .. code-block:: python3\n\n      >>> quiz.execute(str(query), ...)\n      {"repository": ...}\n\n\nInstallation\n------------\n\n``quiz`` and its dependencies are pure python. Installation is easy as:\n\n.. code-block:: bash\n\n   pip install quiz\n\n\nContributing\n------------\n\nAfter you\'ve cloned the repo locally, set up the development environment\nwith:\n\n.. code-block:: bash\n\n   make init\n\nFor quick test runs, run:\n\n.. code-block:: bash\n\n   pytest\n\nTo run all tests and checks on various python versions, run:\n\n.. code-block:: bash\n\n   make test\n\nGenerate the docs with:\n\n.. code-block:: bash\n\n   make docs\n\n\nPull requests welcome!\n\n\nPreliminary roadmap\n-------------------\n\n================================================================== ===========\nFeature                                                            status\n================================================================== ===========\nInput objects                                                      planned\nbetter query validation errors                                     planned\nmore examples in docs                                              planned\nexecuting selection sets directly                                  planned\nintrospection fields (i.e. ``__typename``)                         planned\ncustom scalars for existing types (e.g. ``datetime``)              planned\nimprove Object/Interface API                                       planned\nvalue object docs                                                  planned\nMutations & subscriptions                                          planned\nInline fragments                                                   planned\nFragments and fragment spreads                                     planned\npy2 unicode robustness                                             planned\nMixing in raw GraphQL                                              planned\nModule autogeneration                                              planned\nType inference (e.g. enum values)                                  planned\nVariables                                                          planned\nDirectives                                                         planned\nInteger 32-bit limit                                               planned\nconverting names from camelcase to snake-case                      idea\nAutogenerate module .rst from schema                               idea\nAutogenerate module .py from schema                                idea\nEscaping python keywords                                           idea\nHandling markdown in descriptions                                  idea\nWarnings when using deprecated fields                              idea\nHandle optional types descriptions in schema                       idea\nReturning multiple validation errors at the same time              idea\nExplicit ordering                                                  idea\n================================================================== ===========\n',
    'author': 'Arie Bovenberg',
    'author_email': 'a.c.bovenberg@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ariebovenberg/quiz',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
