# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cp2k_output_tools',
 'cp2k_output_tools.blocks',
 'cp2k_output_tools.scripts',
 'cp2k_output_tools.trajectories']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.19,<2.0', 'regex>=2020.1,<2021.0']

extras_require = \
{':python_version >= "3.6" and python_version < "3.7"': ['dataclasses>=0.7,<0.8'],
 'yaml': ['ruamel.yaml>=0.16.5,<0.17.0']}

entry_points = \
{'console_scripts': ['cp2k_bs2csv = '
                     'cp2k_output_tools.scripts.bandstructure:cp2k_bs2csv',
                     'cp2k_pdos = cp2k_output_tools.scripts.pdos:cp2k_pdos',
                     'cp2kparse = cp2k_output_tools.cli:cp2kparse',
                     'xyz_restart_cleaner = '
                     'cp2k_output_tools.trajectories.xyz_cli:xyz_restart_cleaner']}

setup_kwargs = {
    'name': 'cp2k-output-tools',
    'version': '0.3.0',
    'description': 'Python tools to handle CP2K output files',
    'long_description': '# cp2k-output-tools\n\n[![Build Status](https://github.com/cp2k/cp2k-output-tools/workflows/tests/badge.svg)](https://github.com/cp2k/cp2k-output-tools/actions) [![codecov](https://codecov.io/gh/cp2k/cp2k-output-tools/branch/develop/graph/badge.svg)](https://codecov.io/gh/cp2k/cp2k-output-tools) [![PyPI](https://img.shields.io/pypi/pyversions/cp2k-output-tools)](https://pypi.org/project/cp2k-output-tools/)\n\nModular CP2K output file parsers, mostly in the form of regular expressions plus other tools to mangle various CP2K output:\n\n  * `cp2kparse` ... parse CP2K output files (for restart & input files look at the [cp2k-input-tools](https://github.com/cp2k/cp2k-input-tools) project)\n  * `xyz_restart_parser` ... when restarts occur during an MD you may end up with duplicated frames in the trajectory, this tool filters them\n  * `cp2k_bs2csv` ... convert a CP2K band structure file to multiple (one-per-set) CSV files for easier plotting. There is also an API available if you need to import bandstructure data into your application.\n\n## Requirements\n\n* Python 3.6+\n* regex 2020+\n\nFor development: https://poetry.eustace.io/ https://pytest.org/\n\n\n## Usage: cp2kparse\n\nThere is a simple command-line interface `cp2kparse`:\n\n```console\n$ cp2kparse --help\nusage: cp2kparse [-h] [-y] [-k <path>] [<file>]\n\nParse the CP2K output file and return a JSON\n\npositional arguments:\n  <file>                CP2K output file, stdin if not specified\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -y, --yaml            output yaml instead of json\n  -k <path>, --key <path>\n                        Path, ex.: \'energies/total force_eval\'\n\n$ cp2kparse calc.out\n{\n  "cp2k": {\n    "cp2kflags: libint fftw3 libxc xsmm spglib": " ",\n    "data directory path": "/data/tiziano/cp2k/data",\n    "input file name": "Si-supercell-001.inp",\n    "is freely available from": "https://www.cp2k.org/",\n    "program compiled at": "Mon Sep 16 14:42:43 CEST 2019",\n    "program compiled for": "local",\n    "program compiled on": "tcpc18",\n    "source code revision number": "git:43f50e2",\n    "version string": "CP2K version 7.0 (Development Version)"\n  },\n  "dbcsr": {\n    "cpu multiplication driver": "XSMM",\n    "maximum elements for images": "UNLIMITED",\n    "multiplication size stacks": 3,\n    "multiplication stack size": 1000,\n    "multiplicative factor virtual images": 1,\n    "multrec recursion limit": 512,\n    "use multiplication densification": true\n  },\n  "energies": {\n    "total force_eval": -251.6873903110507\n  },\n  "global": {\n    "all-to-all communication in single precision": false,\n    "basis set file name": "BASIS_MOLOPT",\n    "coordinate file name": "__STD_INPUT__",\n    "cpu model name": "Intel(R) Core(TM) i7-4790 CPU @ 3.60GHz",\n    "cpuid": 1002,\n    "ffts using library dependent lengths": false,\n    "force environment number": 1,\n    "global print level": "MEDIUM",\n    "method name": "CP2K",\n    "mm potential file name": "MM_POTENTIAL",\n    "mpi i/o enabled": true,\n    "number of threads for this process": 1,\n    "potential file name": "POTENTIAL",\n    "preferred diagonalization lib.": "SL",\n    "preferred fft library": "FFTW3",\n    "project name": "Si-supercell-001",\n    "run type": "ENERGY_FORCE",\n    "this output is from process": 0,\n    "total number of message passing processes": 1\n  },\n  "mulliken population analysis": {\n    "per atom": [\n      {\n        "charge": 7e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999993\n      },\n      {\n        "charge": 0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": -0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": -1e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000001\n      },\n      {\n        "charge": -0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": -1e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000001\n      },\n      {\n        "charge": -1e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000001\n      },\n      {\n        "charge": -0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": 0.000137,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999863\n      },\n      {\n        "charge": -2e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00002\n      },\n      {\n        "charge": -0.000133,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000133\n      },\n      {\n        "charge": 2.1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999979\n      },\n      {\n        "charge": -0.000133,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000133\n      },\n      {\n        "charge": 2.1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999979\n      },\n      {\n        "charge": 0.000137,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999863\n      },\n      {\n        "charge": -2e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00002\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": 6e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999994\n      },\n      {\n        "charge": 3.5e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999965\n      },\n      {\n        "charge": 3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999967\n      },\n      {\n        "charge": 9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999991\n      },\n      {\n        "charge": 3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999967\n      },\n      {\n        "charge": 9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999991\n      },\n      {\n        "charge": 3e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999997\n      },\n      {\n        "charge": -0.000312,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000312\n      },\n      {\n        "charge": 3e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999997\n      },\n      {\n        "charge": -0.000311,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000311\n      },\n      {\n        "charge": 3.4e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999966\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": 3.4e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999966\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": 6e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999994\n      },\n      {\n        "charge": 3.5e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999965\n      },\n      {\n        "charge": -9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000009\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      },\n      {\n        "charge": 0.000308,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999692\n      },\n      {\n        "charge": -4e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000004\n      },\n      {\n        "charge": -3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000036\n      },\n      {\n        "charge": -7e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000007\n      },\n      {\n        "charge": -9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000009\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      },\n      {\n        "charge": -8e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000008\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      },\n      {\n        "charge": -3.5e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000035\n      },\n      {\n        "charge": -6e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000006\n      },\n      {\n        "charge": 0.000308,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999692\n      },\n      {\n        "charge": -4e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000004\n      },\n      {\n        "charge": -8e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000008\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      }\n    ],\n    "total": {\n      "charge": 0.0,\n      "population": 256.0\n    }\n  },\n  "program info": {\n    "ended at": "2019-09-17 17:02:35.738",\n    "process id": "23773",\n    "ran by": "tiziano",\n    "ran on": "tcpc18",\n    "started at": "2019-09-17 17:01:19.273",\n    "started by": "tiziano",\n    "started in": "/users/tiziano/work/phonopy/example/Si-CP2K",\n    "started on": "tcpc18",\n    "stopped in": "/users/tiziano/work/phonopy/example/Si-CP2K"\n  }\n}\n```\n\nand an API:\n\n```python\nfrom cp2k_output_tools import parse_iter\n\nwith open("calc.out", "r") as fhandle:\n    for match in parse_iter(fhandle.read()):\n        print(match.values)\n```\n\n## Usage: xyz_restart_cleaner\n\n```console\n$ xyz_restart_cleaner orig_trajectory.xyz new_trajectory.xyz\nfound restart point @1, dropping 1 frames, flushing 1\nflushing remaining 2 frames\n```\n\n## Development\n\n```console\n$ poetry install\n$ poetry run pytest -v\n```\n',
    'author': 'Tiziano Müller',
    'author_email': 'tiziano.mueller@chem.uzh.ch',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cp2k/cp2k-output-tools',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
